#include "wimexim.h"
#include "wimeapi.h"

/*
  ktermXNClientWindowConfigureNotifyȤʤΤϤʤ
  ץץȤȥ٥ȤΤ
  ɥưȤΥ٥Ȥ­ǤСΤȤ˱Ѵɥ
  ư뤳ȤǤ롣ΤȤʬʤΤǡXNSpotLocation
  褿Ȥ˱Ѵɥư뤳Ȥˤ롣
*/

static void spot_loc(const CallbackParam* p,const XPoint* pos);

static int open_ime(CallbackParam* p,bool st)
{
    WimeEnableIme(p->Ic->WimeCxn,st,true,true);
    return 0;
}

static void init(CallbackParam* p)
{
    /*
      αΰư饤ȥɥưȤXNSpotLocation
      褿Ȥ˹Ԥ
    */
    SetCompFont(p->Ic);
    MoveWineWindow(p->Disp,p->Ic);
    spot_loc(p,&p->Ic->Attrs.Preedit.SpotLocation);
}

static int done_preedit(CallbackParam* p UNUSED)
{
    return 0;
}

static bool reject_key(CallbackParam* p UNUSED)
{
    return true;
}

/*
  Ѵɥspot-locationǻꤵ줿֤˰ư롣
*/
static void spot_loc(const CallbackParam* p,const XPoint* pos)
{
    if(p->Ic->CompFontHeight > 0){ //InitƤФƤ
	MoveWineWindow(p->Disp,p->Ic);

	//yϥ١饤ʤΤǡѴɥեȤι⤵Ƥ
	int y = pos->y - p->Ic->CompFontHeight;
	if(y < 0)
	    y = 0;
	WimeSetCompWin(p->Ic->WimeCxn,WIME_POS_POINT,pos->x,y);
	LOG("	composition window pos (%d,%d)\n",pos->x,y);
    }
}

ConvCallbackFuncs ConvFuncOverTheSpot = {
    .OpenIme =		open_ime,
    .Done =		done_preedit,
    .Draw =		ConvDoNothing,
    .RejectKey =	reject_key,
    .Cleanup =		ConvDoNothing,
    .SetSpotLoc =	spot_loc,
    .Init =		init,
    .TargetWindow =	ConvDoNothing,
    .MoveWime =		ConvDoNothing,
};
