#include <stdio.h>
#include <string.h>
#include <gdk/gdkx.h>
#include <stdlib.h>
#include <X11/keysym.h>
#include "gim.h"
#include "winkey.h"
#include "xres.h"
#include "ut.h"

static GType RegisteredType;
static ToggleKey *ToggleKeys;

static const char SigCommit[] = "commit";
static const char SigPeStart[] = "preedit-start";
static const char SigPeEnd[] = "preedit-end";
static const char SigPeChanged[] = "preedit-changed";

static gboolean ascii_mode(IMContextWime* wi,int keyval,int state)
{
    gboolean st = FALSE;

    //ñΡƤȤimǤνϤʤ
    if((state & ~ShiftMask)==0 && !IsModifierKey(keyval)){
	gunichar ukey = gdk_keyval_to_unicode(keyval);
	if(ukey != 0){
	    gchar buf[7];
	    memset(buf,0,sizeof(buf));
	    g_unichar_to_utf8(ukey,buf);
	    g_signal_emit_by_name(wi,SigCommit,buf);
	    st = TRUE;
	}
    }
    return st;
}

static char* commit(IMContextWime* wi,char* u)
{
    wi->PreeditStr = NULL;
    g_signal_emit_by_name(wi,SigPeChanged); //Խʸä
    g_signal_emit_by_name(wi,SigPeEnd);
    g_signal_emit_by_name(wi,SigCommit,u);
    return u;
}

/*
  wime롣
*/
static bool send_key(IMContextWime* wi,unsigned wk,char** res)
{
    int st;
    if((st = WimeSendKey(wi->WimeCxn,wk,res)) == -2){
	//Ѵä
	gchar* sur;
	gint cursor;
	gunichar2* u16;
	int len,pos;

	gtk_im_context_get_surrounding(GTK_IM_CONTEXT(wi),&sur,&cursor);
	cursor = g_utf8_strlen(sur,cursor); //ХȥեåȢʸñ
	LOG("cursor %d strlen %d\n",cursor,g_utf8_strlen(sur,INT_MAX));
	u16 = g_utf8_to_utf16(sur,-1,NULL,NULL,NULL);
	len = WimeReconvert(wi->WimeCxn,u16,cursor,&pos);
	*res = NULL;
	st = (len>0);
	if(st){
	    pos -= cursor; //ʸäʥ뤫а֡
	    LOG("delete pos %d,len %d\n",pos,len);
	    gtk_im_context_delete_surrounding(GTK_IM_CONTEXT(wi),pos,len);
	}
	g_free(sur);
	g_free(u16);
    }
    return st!=0;
}

static gboolean aux_input(IMContextWime* wi)
{
    uint16_t *u16;
    char *u;

    free(wi->PreeditStr);
    wi->PreeditStr = NULL;

    u = commit(wi,U16ToU8(NULL,u16=WimeGetResultStr(wi->WimeCxn),-1));
    VERBOSE(Array d;ArNew(&d,1,NULL);
	    MSG("aux input,utf8 string=%s\n",ArAdr(Dump1(" 0x%02x",u,strlen(u),&d)));
	    ArDelete(&d));
    free(u);
    free(u16);
    return TRUE;
}

/*
  keyimTRUE֤
*/
gboolean imwime_filter_keypress(GtkIMContext* context,GdkEventKey* ev)
{
    if(ev->type == GDK_KEY_RELEASE)
	return FALSE;

    unsigned wk;
    char *res;
    gboolean st = FALSE;
    IMContextWime *wi = IMCONTEXT_WIME(context);
    //IMContextWimeClass *wc = IMWIME_GET_CLASS(wi);
    KeySym xk;

    if(!WimeIsConnected())
	WimeInitialize(0,LOGMARK);
    if(setjmp(WimeJmp) != 0){
	ERR("Disconnect wime\n");
	return ascii_mode(wi,ev->keyval,ev->state);
    }

    if((ev->state & 0xff) == AUX_INPUT_MOD) //[atok]ѥåȤ
	return aux_input(wi);

    /*
      㤨'('Ϥ硢ev->keyvalXK_parenleftˤʤ롣winб벾ۥɤϤʤshift+'9'ɽ롣
      դεϥܡɤˤäư֤㤦ñ˥ơ֥Ĥ뤳ȤǤʤ
      󥳡ɤϤȤפäXwinǤϥɤ㤦(X8255δ֤οͤˤʤˡ
      ̾Υsym򥹥󥳡ɤˤ⤦٥symˤƥꥹȤΣܤΥsym(եȤΤʤsym)winۥѴ롣

      imeȥ륭ӤǤ꤬A-Zenkaku_HankakuˤƤ硢keyvalˤΤZenkaku_HankakuǤϤʤKanji(ximǤϥ󥳡ɤΤʤ
      ΤƤϤǥsymѴ򤹤뤳ȤˤʤäƤޤä
      !!!ȥ륭ϥ󥳡ɤǤäƤ
    */
    xk = XKeycodeToKeysym(GDK_DISPLAY(),XKeysymToKeycode(GDK_DISPLAY(),ev->keyval),0);
    LOG("keysym 0x%x(state 0x%x) --> keysym 0x%x\n",ev->keyval,ev->state,xk);
    if(wi->Flag & ENABLE_IME){
	if(IsToggleKey(ToggleKeys,xk,ev->state)){
	    //⡼ɽλcommiƤʤ̵뤹
	    if(wi->PreeditStr == NULL){
		WimeEnableIme(wi->WimeCxn,FALSE,FALSE,FALSE);
		wi->Flag &= ~ENABLE_IME;
	    }
	}else{
	    wk = ConvToVk(xk,ev->state);
	    LOG("windows vk 0x%x\n",wk);
	    if(send_key(wi,wk,&res)){
		st = TRUE;
		free(wi->PreeditStr);
		if(res==NULL){ //
		    if(wi->PreeditStr == NULL)
			g_signal_emit_by_name(wi,SigPeStart);
		    res = WimeGetCompStr(wi->WimeCxn,&wi->StrInfo);
		    if(res!=NULL || wi->PreeditStr!=NULL){
			/*
			  Խʸ󤬣ʸλbs򲡤resNULLˤʤ뤬
			  wi->PreeditStrˤϤޤԽʸ󤬤롣
			  θ幹bs򲡤elseؤ
			*/
			wi->PreeditStr = EjToU8(NULL,res);
			g_signal_emit_by_name(wi,SigPeChanged);
			LOG("preedit string='%s'\n",res);
		    }else{
			/*
			  ime˽줿ߤľԽʸ󤬤ʤ
			  ξ֤ǥ󥿡bs򲡤
			*/
			st = ascii_mode(wi,ev->keyval,ev->state);
			LOG("control char\n");
		    }
		}else{ //
		    free(commit(wi,EjToU8(NULL,res)));
		    LOG("commit '%s'\n",res);
		}
		free(res);
	    }else{ //ime˽ʤä
		st = ascii_mode(wi,ev->keyval,ev->state);
	    }
	}
    }else{
	if(IsToggleKey(ToggleKeys,xk,ev->state)){
	    //⡼ɳ
	    WimeEnableIme(wi->WimeCxn,TRUE,TRUE,FALSE);
	    wi->Flag |= ENABLE_IME;
	}else{
	    st = ascii_mode(wi,ev->keyval,ev->state); //ascii⡼
	}
    }
    return st;
}

//utf8ǤʸեåȤХȥեåȤˤ
static int offset_char_to_byte(const char* u8,int char_offset)
{
    return g_utf8_offset_to_pointer(u8,char_offset) - u8;
}

//ϻˤƤФ
void imwime_get_preedit_str(GtkIMContext* context,gchar** str,PangoAttrList** attrs,gint* cursor_pos)
{
    IMContextWime *wi = IMCONTEXT_WIME(context);
    PangoAttribute *at;
    gint cursor_dum,cl_start=-1,cl_end;

    if(cursor_pos == NULL)
	cursor_pos = &cursor_dum;

    if(attrs != NULL)
	*attrs = pango_attr_list_new(); //ʤȤ
    if(wi->PreeditStr == NULL){
	if(str != NULL)
	    *str = g_strdup("");
	*cursor_pos = 0;
	return;
    }

    if(str != NULL){
	*str = g_strdup(wi->PreeditStr);
    }
    if(wi->StrInfo.TargetClause>=0){ //ʸ᤬
	cl_start = offset_char_to_byte(wi->PreeditStr,wi->StrInfo.TargetClause);
	cl_end = offset_char_to_byte(wi->PreeditStr,wi->StrInfo.TargetClause+wi->StrInfo.TargetClLen);
    }
    if(attrs != NULL){
	at = pango_attr_underline_new(PANGO_UNDERLINE_SINGLE);
	at->start_index = 0;
	at->end_index = strlen(*str);
	pango_attr_list_insert(*attrs,at);

	if(cl_start >= 0){ //ʸ᤬
	    at = pango_attr_background_new(0,0,0);
	    at->start_index = cl_start;
	    at->end_index = cl_end;
	    pango_attr_list_insert(*attrs,at);

	    at = pango_attr_foreground_new(-1,-1,-1);
	    at->start_index = cl_start;
	    at->end_index = cl_end;
	    pango_attr_list_insert(*attrs,at);
	}
    }

    //֤ϥХȤǤϤʤʸñ
    *cursor_pos = cl_start>=0 ? wi->StrInfo.TargetClause:strlen(wi->PreeditStr);
}

//ɥΰư礭ѹǤ⤳줬ƤФ褦
void imwime_set_cursor_loc(GtkIMContext* context,GdkRectangle* area)
{
    gint d;
    GdkRectangle r;
    IMContextWime *wi = IMCONTEXT_WIME(context);

    if(!WimeIsConnected())
	WimeInitialize(0,LOGMARK);
    if(setjmp(WimeJmp) != 0){
	ERR("Disconnect wime\n");
	return;
    }

    if(wi->Client != NULL){
	gdk_window_get_geometry(wi->Client,&d,&d,&r.width,&r.height,&d);
	gdk_window_get_origin(wi->Client,&r.x,&r.y);
	if(memcmp(&wi->Geom,&r,sizeof(r)) != 0){
	    wi->Geom = r;
	    WimeMoveShadowWin(wi->WimeCxn,r.x,r.y,r.width,r.height);
	    LOG("shadow window (%d,%d) %dx%d\n",r.x,r.y,r.width,r.height);
	}
	r = *area;
	r.y += r.height+3;
	if(wi->PreeditStr!=NULL && memcmp(&wi->CandPos,&r,sizeof(r))!=0){
	    wi->CandPos = r;
	    WimeSetCandWin(wi->WimeCxn,WIME_POS_POINT,r.x,r.y);
	    LOG("candidate window (%d,%d)\n",r.x,r.y);
	}
    }
}

void imwime_set_client_window(GtkIMContext* context,GdkWindow* window)
{
    IMContextWime *wi = IMCONTEXT_WIME(context);
    wi->Client = window;
    WimeRegXWindow(wi->WimeCxn,GDK_DRAWABLE_XID(window));
    LOG("cxn=%d xwin=%x\n",wi->WimeCxn,GDK_DRAWABLE_XID(window));
}

////////////////////////////////////////////////////////

void imwime_init(GtkIMContext* cx)
{
    IMContextWime *wi = IMCONTEXT_WIME(cx);

    if(setjmp(WimeJmp) != 0){
	return;
    }

    memset(&(wi->Parent)+1,0,sizeof(*wi)-sizeof(wi->Parent)); //IMContextWimeΥФ0ꥢ
    wi->WimeCxn = WimeCreateContext();
    LOG("wime context %d\n",wi->WimeCxn);
}

////////////////////////////////////////////////////////

void imwime_class_init(GtkIMContextClass *cl)
{
    //IMContextWimeClass *wc = IMCONTEXTWIMECLASS(cl);

    cl->filter_keypress =  imwime_filter_keypress;
    cl->get_preedit_string = imwime_get_preedit_str;
    cl->set_cursor_location = imwime_set_cursor_loc;
    cl->set_client_window = imwime_set_client_window;

    LOG("ok\n");
}

void imwime_class_fin(GtkIMContextClass *cl UNUSED)
{
    LOG("ok\n");
}

////////////////////////////////////////////////////////
//⥸塼뤬exportؿ

const char ContextId[] = "wime";
const char ContextName[] = "Wime";
const char DomainName[] = "gtk20";
const char RegisterName[] = "IMContextWime";

GtkIMContextInfo ImwimeInfo = {
    .context_id = ContextId,
    .context_name = ContextName,
    .domain = DomainName,
    .domain_dirname = LOCALEDIR,
    .default_locales = "*"
};

GtkIMContextInfo *ImcInfoList[] = {
    &ImwimeInfo
};

void im_module_init(GTypeModule* module)
{
    GTypeInfo info = {
	sizeof(IMContextWimeClass),	//class_size
	NULL,				//GBaseInitFunc base_init
	NULL,				//GBaseFinalizeFunc base_finalize

	(GClassInitFunc)imwime_class_init,	//class_init
	(GClassFinalizeFunc)imwime_class_fin, 	//class_finalize
	NULL,           			//class_data

	sizeof(IMContextWime),		//instance_size
	0,				//n_preallocs
	(GtkObjectInitFunc)imwime_init,	//instance_init

	NULL			   	//value_table
    };

    Verbose = 1;
    RegisteredType = g_type_module_register_type(module,GTK_TYPE_IM_CONTEXT,RegisterName,&info,0);
    WimeInitialize(0,LOGMARK);
    InitDatabase(NULL,"gim");
    ToggleKeys = GetConvKeyFromResource(GDK_DISPLAY());
    LOG("ok\n");
}

void im_module_exit(void)
{
    WimeFinalize();
    LOG("ok\n");
}

void im_module_list(GtkIMContextInfo*** contexts,int* n_contexts)
{
    *contexts = ImcInfoList;
    *n_contexts = G_N_ELEMENTS(ImcInfoList);
}

GtkIMContext* im_module_create(const gchar* context_id)
{
    return strcmp(context_id,ContextId)==0 ? GTK_IM_CONTEXT(g_object_new(RegisteredType,NULL)) : NULL;
}
