/*
 * Copyright (C) 2014 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from generate-enum-encoding-helpers.json
// by the script: JavaScriptCore/replay/scripts/CodeGeneratorReplayInputs.py

#include "config.h"
#include "generate-enum-encoding-helpers.json-TestReplayInputs.h"

#if ENABLE(WEB_REPLAY)
#include "InternalNamespaceImplIncludeDummy.h"
#include "NondeterministicInput.h"
#include "PlatformMouseEvent.h"
#include <platform/ExternalNamespaceImplIncludeDummy.h>

namespace Test {
SavedMouseButton::SavedMouseButton(MouseButton button)
    : NondeterministicInput<SavedMouseButton>()
    , m_button(button)
{
}

SavedMouseButton::~SavedMouseButton()
{
}
} // namespace Test

namespace JSC {
const String& InputTraits<Test::SavedMouseButton>::type()
{
    static NeverDestroyed<const String> type(ASCIILiteral("SavedMouseButton"));
    return type;
}

void InputTraits<Test::SavedMouseButton>::encode(EncodedValue& encodedValue, const Test::SavedMouseButton& input)
{
    encodedValue.put<Test::MouseButton>(ASCIILiteral("button"), input.button());
}

bool InputTraits<Test::SavedMouseButton>::decode(EncodedValue& encodedValue, std::unique_ptr<Test::SavedMouseButton>& input)
{
    Test::MouseButton button;
    if (!encodedValue.get<Test::MouseButton>(ASCIILiteral("button"), button))
        return false;

    input = std::make_unique<Test::SavedMouseButton>(button);
    return true;
}
EncodedValue EncodingTraits<Test::InputQueue>::encodeValue(const Test::InputQueue& enumValue)
{
    switch (enumValue) {
    case Test::InputQueue::EventLoopInput: return EncodedValue::createString("EventLoopInput");
    case Test::InputQueue::LoaderMemoizedData: return EncodedValue::createString("LoaderMemoizedData");
    case Test::InputQueue::ScriptMemoizedData: return EncodedValue::createString("ScriptMemoizedData");
    default: ASSERT_NOT_REACHED(); return EncodedValue::createString("Error!");
    }
}

bool EncodingTraits<Test::InputQueue>::decodeValue(EncodedValue& encodedValue, Test::InputQueue& enumValue)
{
    String enumString = encodedValue.convertTo<String>();
    if (enumString == "EventLoopInput") {
        enumValue = Test::InputQueue::EventLoopInput;
        return true;
    }
    if (enumString == "LoaderMemoizedData") {
        enumValue = Test::InputQueue::LoaderMemoizedData;
        return true;
    }
    if (enumString == "ScriptMemoizedData") {
        enumValue = Test::InputQueue::ScriptMemoizedData;
        return true;
    }
    return false;
}

EncodedValue EncodingTraits<Test::MouseButton>::encodeValue(const Test::MouseButton& enumValue)
{
    EncodedValue encodedValue = EncodedValue::createArray();
    if (enumValue & Test::NoButton) {
        encodedValue.append<String>(ASCIILiteral("NoButton"));
        if (enumValue == Test::NoButton)
            return encodedValue;
    }
    if (enumValue & Test::LeftButton) {
        encodedValue.append<String>(ASCIILiteral("LeftButton"));
        if (enumValue == Test::LeftButton)
            return encodedValue;
    }
    if (enumValue & Test::MiddleButton) {
        encodedValue.append<String>(ASCIILiteral("MiddleButton"));
        if (enumValue == Test::MiddleButton)
            return encodedValue;
    }
    if (enumValue & Test::RightButton) {
        encodedValue.append<String>(ASCIILiteral("RightButton"));
        if (enumValue == Test::RightButton)
            return encodedValue;
    }
    return encodedValue;
}

bool EncodingTraits<Test::MouseButton>::decodeValue(EncodedValue& encodedValue, Test::MouseButton& enumValue)
{
    Vector<String> enumStrings;
    if (!EncodingTraits<Vector<String>>::decodeValue(encodedValue, enumStrings))
        return false;

    for (const String& enumString : enumStrings) {
        if (enumString == "NoButton")
            enumValue = static_cast<Test::MouseButton>(enumValue | Test::NoButton);
        else if (enumString == "LeftButton")
            enumValue = static_cast<Test::MouseButton>(enumValue | Test::LeftButton);
        else if (enumString == "MiddleButton")
            enumValue = static_cast<Test::MouseButton>(enumValue | Test::MiddleButton);
        else if (enumString == "RightButton")
            enumValue = static_cast<Test::MouseButton>(enumValue | Test::RightButton);
    }

    return true;
}

EncodedValue EncodingTraits<Test::PlatformEvent::OtherType>::encodeValue(const OptionSet<Test::PlatformEvent::OtherType>& enumValue)
{
    EncodedValue encodedValue = EncodedValue::createArray();
    if (enumValue.contains(Test::PlatformEvent::OtherType::Mouse))
        encodedValue.append<String>(ASCIILiteral("Mouse"));
    if (enumValue.contains(Test::PlatformEvent::OtherType::Key))
        encodedValue.append<String>(ASCIILiteral("Key"));
    if (enumValue.contains(Test::PlatformEvent::OtherType::Touch))
        encodedValue.append<String>(ASCIILiteral("Touch"));
    if (enumValue.contains(Test::PlatformEvent::OtherType::Wheel))
        encodedValue.append<String>(ASCIILiteral("Wheel"));

    return encodedValue;
}

bool EncodingTraits<Test::PlatformEvent::OtherType>::decodeValue(EncodedValue& encodedValue, OptionSet<Test::PlatformEvent::OtherType>& enumValue)
{
    Vector<String> enumStrings;
    if (!EncodingTraits<Vector<String>>::decodeValue(encodedValue, enumStrings))
        return false;

    for (const String& enumString : enumStrings) {
        if (enumString == "Mouse")
            enumValue |= Test::PlatformEvent::OtherType::Mouse;
        else if (enumString == "Key")
            enumValue |= Test::PlatformEvent::OtherType::Key;
        else if (enumString == "Touch")
            enumValue |= Test::PlatformEvent::OtherType::Touch;
        else if (enumString == "Wheel")
            enumValue |= Test::PlatformEvent::OtherType::Wheel;
    }

    return true;
}

EncodedValue EncodingTraits<Test::PlatformEvent::Type>::encodeValue(const Test::PlatformEvent::Type& enumValue)
{
    EncodedValue encodedValue = EncodedValue::createArray();
    if (enumValue & Test::PlatformEvent::Mouse) {
        encodedValue.append<String>(ASCIILiteral("Mouse"));
        if (enumValue == Test::PlatformEvent::Mouse)
            return encodedValue;
    }
    if (enumValue & Test::PlatformEvent::Key) {
        encodedValue.append<String>(ASCIILiteral("Key"));
        if (enumValue == Test::PlatformEvent::Key)
            return encodedValue;
    }
    if (enumValue & Test::PlatformEvent::Touch) {
        encodedValue.append<String>(ASCIILiteral("Touch"));
        if (enumValue == Test::PlatformEvent::Touch)
            return encodedValue;
    }
    if (enumValue & Test::PlatformEvent::Wheel) {
        encodedValue.append<String>(ASCIILiteral("Wheel"));
        if (enumValue == Test::PlatformEvent::Wheel)
            return encodedValue;
    }
    return encodedValue;
}

bool EncodingTraits<Test::PlatformEvent::Type>::decodeValue(EncodedValue& encodedValue, Test::PlatformEvent::Type& enumValue)
{
    Vector<String> enumStrings;
    if (!EncodingTraits<Vector<String>>::decodeValue(encodedValue, enumStrings))
        return false;

    for (const String& enumString : enumStrings) {
        if (enumString == "Mouse")
            enumValue = static_cast<Test::PlatformEvent::Type>(enumValue | Test::PlatformEvent::Mouse);
        else if (enumString == "Key")
            enumValue = static_cast<Test::PlatformEvent::Type>(enumValue | Test::PlatformEvent::Key);
        else if (enumString == "Touch")
            enumValue = static_cast<Test::PlatformEvent::Type>(enumValue | Test::PlatformEvent::Touch);
        else if (enumString == "Wheel")
            enumValue = static_cast<Test::PlatformEvent::Type>(enumValue | Test::PlatformEvent::Wheel);
    }

    return true;
}
} // namespace JSC

#endif // ENABLE(WEB_REPLAY)
