/***************************************************************************
 *   Copyright (C) 2009 by Fabian Wuertz                                   *
 *   xadras@sidux.com                                                      *
 *   Project: Waheela                                                      *
 *   File:    waheela.h                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef waheela_H
#define waheela_H


#include <QtGui/QtGui>
#include <KConfigDialog>
#include <KPushButton>

#include "ui_amarokSettings.h"
#include "ui_passwordSettings.h"
#include "ui_wallpaperSettings.h"
#include "ui_displaySettings.h"



#include "widgets/about.h"
#include "widgets/playProgress.h"
#include "widgets/metadata.h"
#include "widgets/background.h"
#include "widgets/dateTime.h"

class Waheela : public QWidget
{
	Q_OBJECT
	public:
		Waheela();

		// init dialogs
		void initThemeDialog();
		
		// init elements
		void initElements();
		void initBottom();
		void initControlButtons();
		void initPlayButtons();
		void initWallpaper();
		void initSettingsElements();

		void initAmarok();
		
		// setup elements
		void setupElements();
		void setupCover(KConfigGroup);
		void setupMetadata(KConfigGroup);
		void setupDateTime(KConfigGroup, KConfigGroup);
		void setupProgressBar(KConfigGroup);
		void setupWallpaper();
		void setupPassword(KConfigGroup);
		
		void mousePressEvent(QMouseEvent  *event);
		void closeEvent(QCloseEvent * event );
		void wheelEvent(QWheelEvent *event);

		

	public slots:
		virtual void playSong();
		virtual void stopSong();
		virtual void prevSong();
		virtual void nextSong();
		virtual void hideButtons();
		virtual void updateMetadata(const QVariantMap&);
		virtual void setPosition(const int, const int);
		virtual void setPassword(QString);

		virtual void showSettingsDialog();

		virtual void showAboutDialog();
		
		// setttings dialogs
		virtual void applySettings();
		virtual void applyTheme();
		
		
		void setStatus(const int &);


	private:
		KPageDialog* themeDialog;
		Ui::amarokPage amarokUi;
		Ui::passwordPage passwordUi;
		Ui::wallpaperPage wallpaperUi;
		Ui::displayPage displayUi;
	  	QString theme, password, pwd;
		bool usePassword;
		QRect screensize;

		
		// events
		QMouseEvent* globalEvent;

		// elements
		QTimer *timer;
		KPushButton *playButton;
		QSlider *volumeSlider;
		QLabel *coverLabel;
		QWidget *controlButtonsWidget, *playButtonsWidget, *bottomWidget;
		
		// settings widgets:
		QWidget *amarokSettingsWidget, *passwordSettingsWidget, *displaySettingsWidget;
		
		Background *backgroundWidget;
		PlayProgress *progressWidget;
		Metadata *metadataLabel;
		DateTime *dateTimeWidget;


	protected:
		void dragEnterEvent(QDragEnterEvent *event);
		void dropEvent(QDropEvent *event);


};

#endif
