/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.sesame4.driver;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.SimpleValueFactory;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import virtuoso.jdbc4.VirtuosoConnectionPoolDataSource;
import virtuoso.sesame4.driver.VirtuosoRepositoryConnection;

public class VirtuosoRepository
implements Repository {
    ValueFactory valueFactory = SimpleValueFactory.getInstance();
    File dataDir;
    private VirtuosoConnectionPoolDataSource pds = new VirtuosoConnectionPoolDataSource();
    private String url_hostlist;
    private String user;
    private String password;
    private int resultsHandlerType = 0;
    private boolean roundrobin;
    private String charset = "UTF-8";
    static final String utf8 = "charset=utf-8";
    private boolean initialized = false;
    private DataSource _ds;
    private ConnectionPoolDataSource _pds;
    private XADataSource _xads;
    boolean useLazyAdd = true;
    boolean insertBNodeAsVirtuosoIRI = false;
    String defGraph;
    int prefetchSize = 100;
    int batchSize = 5000;
    int queryTimeout = 0;
    String ruleSet;

    public VirtuosoRepository(ConnectionPoolDataSource ds, String defGraph, boolean useLazyAdd) {
        this.defGraph = defGraph;
        this.useLazyAdd = useLazyAdd;
        this._pds = ds;
    }

    public VirtuosoRepository(DataSource ds, String defGraph, boolean useLazyAdd) {
        this.defGraph = defGraph;
        this.useLazyAdd = useLazyAdd;
        this._ds = ds;
    }

    public VirtuosoRepository(XADataSource ds, String defGraph) {
        this.defGraph = defGraph;
        this.useLazyAdd = false;
        this._xads = ds;
    }

    public VirtuosoRepository(String url_hostlist, String user, String password, String defGraph, boolean useLazyAdd) {
        this.url_hostlist = url_hostlist.trim();
        this.user = user;
        this.password = password;
        this.defGraph = defGraph;
        this.useLazyAdd = useLazyAdd;
    }

    public VirtuosoRepository(String url_hostlist, String user, String password, boolean useLazyAdd) {
        this(url_hostlist, user, password, "sesame:nil", useLazyAdd);
    }

    public VirtuosoRepository(String url_hostlist, String user, String password, String defGraph) {
        this(url_hostlist, user, password, defGraph, true);
    }

    public VirtuosoRepository(String url_hostlist, String user, String password) {
        this(url_hostlist, user, password, true);
    }

    public RepositoryConnection getConnection() throws RepositoryException {
        if (this._xads != null) {
            try {
                XAConnection xconn = this._xads.getXAConnection();
                Connection connection = xconn.getConnection();
                this.useLazyAdd = false;
                return new VirtuosoRepositoryConnection(this, connection);
            }
            catch (Exception e) {
                System.out.println("Connection to " + this.url_hostlist + " is FAILED.");
                throw new RepositoryException((Throwable)e);
            }
        }
        if (this._pds != null) {
            try {
                PooledConnection pconn = this._pds.getPooledConnection();
                Connection connection = pconn.getConnection();
                return new VirtuosoRepositoryConnection(this, connection);
            }
            catch (Exception e) {
                System.out.println("Connection to " + this.url_hostlist + " is FAILED.");
                throw new RepositoryException((Throwable)e);
            }
        }
        if (this._ds != null) {
            try {
                Connection connection = this._ds.getConnection();
                return new VirtuosoRepositoryConnection(this, connection);
            }
            catch (Exception e) {
                System.out.println("Connection to " + this.url_hostlist + " is FAILED.");
                throw new RepositoryException((Throwable)e);
            }
        }
        if (this.url_hostlist.startsWith("jdbc:virtuoso://")) {
            try {
                Class.forName("virtuoso.jdbc4.Driver");
                String url = this.url_hostlist;
                if (url.toLowerCase().indexOf(utf8) == -1) {
                    url = url.charAt(url.length() - 1) != '/' ? url + "/charset=UTF-8" : url + "charset=UTF-8";
                }
                if (this.roundrobin && url.toLowerCase().indexOf("roundrobin=") == -1) {
                    url = url.charAt(url.length() - 1) != '/' ? url + "/roundrobin=1" : url + "roundrobin=1";
                }
                if (url.toLowerCase().indexOf("log_enable=") == -1) {
                    url = url.charAt(url.length() - 1) != '/' ? url + "/log_enable=2" : url + "log_enable=2";
                }
                Connection connection = DriverManager.getConnection(url, this.user, this.password);
                return new VirtuosoRepositoryConnection(this, connection);
            }
            catch (Exception e) {
                System.out.println("Connection to " + this.url_hostlist + " is FAILED.");
                throw new RepositoryException((Throwable)e);
            }
        }
        try {
            this.pds.setServerName(this.url_hostlist);
            this.pds.setUser(this.user);
            this.pds.setPassword(this.password);
            this.pds.setCharset(this.charset);
            this.pds.setRoundrobin(this.roundrobin);
            PooledConnection pconn = this.pds.getPooledConnection();
            Connection connection = pconn.getConnection();
            return new VirtuosoRepositoryConnection(this, connection);
        }
        catch (Exception e) {
            System.out.println("Connection to " + this.url_hostlist + " is FAILED.");
            throw new RepositoryException((Throwable)e);
        }
    }

    public void setFetchSize(int sz) {
        this.prefetchSize = sz;
    }

    public int getFetchSize() {
        return this.prefetchSize;
    }

    public void setBatchSize(int sz) {
        this.batchSize = sz;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setQueryTimeout(int seconds) {
        this.queryTimeout = seconds;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setUseLazyAdd(boolean v) {
        this.useLazyAdd = v;
    }

    public boolean getUseLazyAdd() {
        return this.useLazyAdd;
    }

    public void setRoundrobin(boolean v) {
        this.roundrobin = v;
    }

    public boolean getRoundrobin() {
        return this.roundrobin;
    }

    public void setInsertBNodeAsVirtuosoIRI(boolean v) {
        this.insertBNodeAsVirtuosoIRI = v;
    }

    public boolean getInsertBNodeAsVirtuosoIRI() {
        return this.insertBNodeAsVirtuosoIRI;
    }

    public void setRuleSet(String name) {
        if (name != null && name.equals("null")) {
            name = null;
        }
        this.ruleSet = name;
    }

    public String getRuleSet() {
        return this.ruleSet;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public void initialize() throws RepositoryException {
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isWritable() throws RepositoryException {
        if (!this.initialized) {
            throw new IllegalStateException("VirtuosoRepository not initialized.");
        }
        return true;
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public void shutDown() throws RepositoryException {
        this.initialized = false;
    }

    public void createRuleSet(String ruleSetName, String uriGraphRuleSet) throws RepositoryException {
        Connection con = ((VirtuosoRepositoryConnection)this.getConnection()).getQuadStoreConnection();
        try {
            Statement st = con.createStatement();
            st.execute("rdfs_rule_set('" + ruleSetName + "', '" + uriGraphRuleSet + "')");
            st.close();
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

