/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.sesame2.driver.config;

import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryImplConfigBase;
import virtuoso.sesame2.driver.config.VirtuosoRepositorySchema;

public class VirtuosoRepositoryConfig
extends RepositoryImplConfigBase {
    private String hostlist;
    private String username;
    private String password;
    private String defGraph;
    private boolean useLazyAdd;
    private int fetchSize = 100;
    private boolean roundRobin;
    private String ruleSet;
    private int batchSize = 5000;
    private boolean insertBNodeAsVirtuosoIRI = false;

    public VirtuosoRepositoryConfig() {
        super("openrdf:VirtuosoRepository");
    }

    public VirtuosoRepositoryConfig(String hostlist) {
        this();
        this.setHostList(hostlist);
    }

    public String getHostList() {
        return this.hostlist;
    }

    public void setHostList(String hostlist) {
        this.hostlist = hostlist;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDefGraph() {
        return this.defGraph;
    }

    public void setDefGraph(String defGraph) {
        this.defGraph = defGraph;
    }

    public boolean getUseLazyAdd() {
        return this.useLazyAdd;
    }

    public void setUseLazyAdd(boolean useLazyAdd) {
        this.useLazyAdd = useLazyAdd;
    }

    public boolean getRoundRobin() {
        return this.roundRobin;
    }

    public void setRoundRobin(boolean roundRobin) {
        this.roundRobin = roundRobin;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public String getRuleSet() {
        return this.ruleSet;
    }

    public void setRuleSet(String ruleSet) {
        this.ruleSet = ruleSet != null && ruleSet.equals("null") ? null : ruleSet;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setInsertBNodeAsVirtuosoIRI(boolean v) {
        this.insertBNodeAsVirtuosoIRI = v;
    }

    public boolean getInsertBNodeAsVirtuosoIRI() {
        return this.insertBNodeAsVirtuosoIRI;
    }

    public void validate() throws RepositoryConfigException {
        super.validate();
        if (this.hostlist == null) {
            throw new RepositoryConfigException("No HostList specified for Virtuoso repository");
        }
    }

    public Resource export(Graph graph) {
        Resource implNode = super.export(graph);
        ValueFactory vf = graph.getValueFactory();
        if (this.hostlist != null) {
            graph.add(implNode, VirtuosoRepositorySchema.HOSTLIST, (Value)vf.createLiteral(this.hostlist), new Resource[0]);
        }
        if (this.username != null) {
            graph.add(implNode, VirtuosoRepositorySchema.USERNAME, (Value)vf.createLiteral(this.username), new Resource[0]);
        }
        if (this.password != null) {
            graph.add(implNode, VirtuosoRepositorySchema.PASSWORD, (Value)vf.createLiteral(this.password), new Resource[0]);
        }
        if (this.defGraph != null) {
            graph.add(implNode, VirtuosoRepositorySchema.DEFGRAPH, (Value)vf.createLiteral(this.defGraph), new Resource[0]);
        }
        if (this.ruleSet != null && this.ruleSet.length() > 0 && !this.ruleSet.equals("null")) {
            graph.add(implNode, VirtuosoRepositorySchema.RULESET, (Value)vf.createLiteral(this.ruleSet), new Resource[0]);
        }
        graph.add(implNode, VirtuosoRepositorySchema.USELAZYADD, (Value)vf.createLiteral(new Boolean(this.useLazyAdd).toString()), new Resource[0]);
        graph.add(implNode, VirtuosoRepositorySchema.ROUNDROBIN, (Value)vf.createLiteral(new Boolean(this.roundRobin).toString()), new Resource[0]);
        graph.add(implNode, VirtuosoRepositorySchema.FETCHSIZE, (Value)vf.createLiteral(Integer.toString(this.fetchSize, 10)), new Resource[0]);
        graph.add(implNode, VirtuosoRepositorySchema.BATCHSIZE, (Value)vf.createLiteral(Integer.toString(this.batchSize, 10)), new Resource[0]);
        graph.add(implNode, VirtuosoRepositorySchema.INSERTBNodeAsVirtuosoIRI, (Value)vf.createLiteral(new Boolean(this.insertBNodeAsVirtuosoIRI).toString()), new Resource[0]);
        return implNode;
    }

    public void parse(Graph graph, Resource implNode) throws RepositoryConfigException {
        super.parse(graph, implNode);
        try {
            Literal bnodeAsUri;
            Literal batchsize;
            Literal ruleset;
            Literal fetchsize;
            Literal roundrobin;
            Literal uselazyadd;
            Literal defgraph;
            Literal password;
            Literal username;
            Literal hlist = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)VirtuosoRepositorySchema.HOSTLIST);
            if (hlist != null) {
                this.setHostList(hlist.getLabel());
            }
            if ((username = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)VirtuosoRepositorySchema.USERNAME)) != null) {
                this.setUsername(username.getLabel());
            }
            if ((password = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)VirtuosoRepositorySchema.PASSWORD)) != null) {
                this.setPassword(password.getLabel());
            }
            if ((defgraph = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)VirtuosoRepositorySchema.DEFGRAPH)) != null) {
                this.setDefGraph(defgraph.getLabel());
            }
            if ((uselazyadd = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)VirtuosoRepositorySchema.USELAZYADD)) != null) {
                this.setUseLazyAdd(Boolean.parseBoolean(uselazyadd.getLabel()));
            }
            if ((roundrobin = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)VirtuosoRepositorySchema.ROUNDROBIN)) != null) {
                this.setRoundRobin(Boolean.parseBoolean(roundrobin.getLabel()));
            }
            if ((fetchsize = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)VirtuosoRepositorySchema.FETCHSIZE)) != null) {
                this.setFetchSize(Integer.parseInt(fetchsize.getLabel()));
            }
            if ((ruleset = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)VirtuosoRepositorySchema.RULESET)) != null) {
                this.setRuleSet(ruleset.getLabel());
            }
            if ((batchsize = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)VirtuosoRepositorySchema.BATCHSIZE)) != null) {
                this.setBatchSize(Integer.parseInt(batchsize.getLabel()));
            }
            if ((bnodeAsUri = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)VirtuosoRepositorySchema.INSERTBNodeAsVirtuosoIRI)) != null) {
                this.setInsertBNodeAsVirtuosoIRI(Boolean.parseBoolean(bnodeAsUri.getLabel()));
            }
        }
        catch (GraphUtilException e) {
            throw new RepositoryConfigException(e.getMessage(), (Throwable)e);
        }
    }
}

