/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.Socket;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import openlink.util.Vector;
import openlink.util.VectorOfDouble;
import openlink.util.VectorOfFloat;
import openlink.util.VectorOfLong;
import virtuoso.jdbc3.DateObject;
import virtuoso.jdbc3.VirtuosoBlob;
import virtuoso.jdbc3.VirtuosoConnection;
import virtuoso.jdbc3.VirtuosoException;
import virtuoso.jdbc3.VirtuosoExplicitString;
import virtuoso.jdbc3.VirtuosoExtendedString;
import virtuoso.jdbc3.VirtuosoNullParameter;
import virtuoso.jdbc3.VirtuosoRdfBox;

class VirtuosoOutputStream
extends BufferedOutputStream {
    private VirtuosoConnection connection;
    private byte[] tmp = new byte[16];
    private static final int DefaultBufferSize = 2048;
    static final int[] cumdays_in_month = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};

    VirtuosoOutputStream(VirtuosoConnection connection, OutputStream output) throws IOException {
        this(connection, output, 2048);
    }

    VirtuosoOutputStream(VirtuosoConnection connection, OutputStream output, int size) throws IOException {
        super(output, size);
        this.connection = connection;
    }

    VirtuosoOutputStream(VirtuosoConnection connection, Socket output) throws IOException {
        this(connection, output.getOutputStream());
    }

    VirtuosoOutputStream(VirtuosoConnection connection, Socket output, int size) throws IOException {
        this(connection, output.getOutputStream(), size);
    }

    protected boolean isClosed() {
        return this.out == null;
    }

    protected void write_object(Object obj) throws IOException, VirtuosoException {
        int tag = this.whatIs(obj);
        switch (tag) {
            case 196: {
                List o = (List)obj;
                int length = o.size();
                this.write(193);
                this.writeint(length);
                ListIterator it = o.listIterator();
                while (it.hasNext()) {
                    this.write_object(it.next());
                }
                return;
            }
            case 193: {
                Vector o = (Vector)obj;
                int length = o.size();
                this.write(tag);
                this.writeint(length);
                for (int i = 0; i < length; ++i) {
                    this.write_object(o.elementAt(i));
                }
                return;
            }
            case 209: {
                VectorOfLong o = (VectorOfLong)obj;
                int length = o.size();
                this.write(tag);
                this.writeint(length);
                for (int i = 0; i < length; ++i) {
                    this.writelongint((Long)o.elementAt(i));
                }
                return;
            }
            case 194: {
                Vector o = (Vector)obj;
                int length = o.size();
                this.write(tag);
                this.writeint(length);
                for (int i = 0; i < length; ++i) {
                    this.writeint(((Number)o.elementAt(i)).longValue());
                }
                return;
            }
            case 195: {
                VectorOfDouble o = (VectorOfDouble)obj;
                int length = o.size();
                this.write(tag);
                this.writeint(length);
                for (int i = 0; i < length; ++i) {
                    this.writerawdouble((Double)o.elementAt(i));
                }
                return;
            }
            case 202: {
                VectorOfFloat o = (VectorOfFloat)obj;
                int length = o.size();
                this.write(tag);
                this.writeint(length);
                for (int i = 0; i < length; ++i) {
                    this.writerawfloat(((Float)o.elementAt(i)).floatValue());
                }
                return;
            }
            case 181: 
            case 182: 
            case 183: 
            case 225: 
            case 226: {
                if (obj instanceof VirtuosoExplicitString) {
                    ((VirtuosoExplicitString)obj).write(this);
                } else {
                    this.writestring((String)obj);
                }
                return;
            }
            case 190: {
                this.writefloat(((Float)obj).floatValue());
                return;
            }
            case 191: {
                this.writedouble((Double)obj);
                return;
            }
            case 180: 
            case 204: {
                this.write(tag);
                return;
            }
            case 186: 
            case 187: {
                String o = (String)obj;
                this.write(o.getBytes(), 0, o.length());
                return;
            }
            case 188: {
                if (obj instanceof Boolean) {
                    this.writeint((Boolean)obj == true ? 1L : 0L);
                } else if (obj instanceof Byte) {
                    this.writeint(((Byte)obj).shortValue());
                } else {
                    this.writeint(((Number)obj).shortValue());
                }
                return;
            }
            case 189: {
                this.writeint(((Number)obj).longValue());
                return;
            }
            case 247: {
                this.writelong(((Number)obj).longValue());
                return;
            }
            case 128: 
            case 129: 
            case 208: 
            case 210: 
            case 211: {
                this.writeDate(obj, tag);
                return;
            }
            case -1: {
                throw new VirtuosoException("invalid type", -7);
            }
            case 222: {
                byte[] bobj = (byte[])obj;
                this.write(222);
                this.write(bobj.length);
                this.write(bobj, 0, bobj.length);
                return;
            }
            case 223: {
                byte[] bobj = (byte[])obj;
                this.write(223);
                this.writelongint(bobj.length);
                this.write(bobj, 0, bobj.length);
                return;
            }
            case 131: {
                this.write(126);
                this.writelongint(1L);
                this.writelongint(((VirtuosoBlob)obj).hashCode());
                this.writelongint(((VirtuosoBlob)obj).length());
                this.writelongint(((VirtuosoBlob)obj).key_id);
                this.writelongint(((VirtuosoBlob)obj).frag_no);
                this.writelongint(((VirtuosoBlob)obj).dir_page);
                this.writelongint(((VirtuosoBlob)obj).bh_timestamp);
                this.write_object(((VirtuosoBlob)obj).pages);
                return;
            }
            case 125: {
                this.write(126);
                this.writelongint(1L);
                this.writelongint(((VirtuosoBlob)obj).hashCode());
                this.writelongint(((VirtuosoBlob)obj).length());
                this.writelongint(((VirtuosoBlob)obj).key_id);
                this.writelongint(((VirtuosoBlob)obj).frag_no);
                this.writelongint(((VirtuosoBlob)obj).dir_page);
                this.writelongint(((VirtuosoBlob)obj).bh_timestamp);
                this.write_object(((VirtuosoBlob)obj).pages);
                return;
            }
            case 219: {
                if (obj instanceof Long) {
                    this.writenumeric(BigDecimal.valueOf((Long)obj));
                } else {
                    this.writenumeric((BigDecimal)obj);
                }
                return;
            }
            case 207: {
                VirtuosoExtendedString o = (VirtuosoExtendedString)obj;
                this.write(tag);
                this.writelongint(o.strType);
                this.write_object(o.str);
                return;
            }
            case 246: {
                this.writeRdfBox((VirtuosoRdfBox)obj);
                return;
            }
        }
        if (!(obj instanceof Serializable)) {
            throw new VirtuosoException("Tag " + tag + " not defined and the object " + obj.getClass().getName() + "is not serializable.", -9);
        }
        this.writeobject(obj);
    }

    private void writefloat(float n) throws IOException {
        this.write(190);
        this.writerawfloat(n);
    }

    private void writerawfloat(float m) throws IOException {
        this.writelongint(Float.floatToIntBits(m));
    }

    private void writedouble(double n) throws IOException {
        this.write(191);
        this.writerawdouble(n);
    }

    private void writerawdouble(double m) throws IOException {
        this.writerawlong(Double.doubleToLongBits(m));
    }

    private void writeint(long n) throws IOException {
        if (n >= -128L && n < 128L) {
            this.write(188);
            this.write((byte)n);
        } else {
            this.write(189);
            this.writelongint(n);
        }
    }

    protected void writelongint(long data) throws IOException {
        this.tmp[0] = (byte)(data >> 24 & 0xFFL);
        this.tmp[1] = (byte)(data >> 16 & 0xFFL);
        this.tmp[2] = (byte)(data >> 8 & 0xFFL);
        this.tmp[3] = (byte)(data & 0xFFL);
        this.write(this.tmp, 0, 4);
    }

    protected void writelongint(int data) throws IOException {
        this.tmp[0] = (byte)(data >> 24 & 0xFF);
        this.tmp[1] = (byte)(data >> 16 & 0xFF);
        this.tmp[2] = (byte)(data >> 8 & 0xFF);
        this.tmp[3] = (byte)(data & 0xFF);
        this.write(this.tmp, 0, 4);
    }

    protected void writeshort(short data) throws IOException {
        this.tmp[0] = (byte)(data >> 8 & 0xFF);
        this.tmp[1] = (byte)(data & 0xFF);
        this.write(this.tmp, 0, 2);
    }

    protected void writelong(long data) throws IOException {
        this.write(247);
        this.writerawlong(data);
    }

    protected void writerawlong(long data) throws IOException {
        this.tmp[0] = (byte)(data >> 56 & 0xFFL);
        this.tmp[1] = (byte)(data >> 48 & 0xFFL);
        this.tmp[2] = (byte)(data >> 40 & 0xFFL);
        this.tmp[3] = (byte)(data >> 32 & 0xFFL);
        this.tmp[4] = (byte)(data >> 24 & 0xFFL);
        this.tmp[5] = (byte)(data >> 16 & 0xFFL);
        this.tmp[6] = (byte)(data >> 8 & 0xFFL);
        this.tmp[7] = (byte)(data & 0xFFL);
        this.write(this.tmp, 0, 8);
    }

    private void writenumeric(BigDecimal bd) throws IOException, VirtuosoException {
        int numaftdot;
        String bcd;
        int len;
        int flags;
        this.write(219);
        if (bd.doubleValue() == Double.NaN) {
            this.write(3);
            this.write(8);
            this.write(0);
            this.write(180);
            return;
        }
        if (bd.doubleValue() == Double.NEGATIVE_INFINITY) {
            this.write(3);
            this.write(17);
            this.write(0);
            this.write(180);
            return;
        }
        if (bd.doubleValue() == Double.POSITIVE_INFINITY) {
            this.write(3);
            this.write(16);
            this.write(0);
            this.write(180);
            return;
        }
        int n = flags = bd.signum() == -1 ? 1 : 0;
        if (bd.signum() == -1) {
            bd = bd.negate();
        }
        if ((len = (bcd = bd.toString()).length()) - 1 > 40) {
            throw new VirtuosoException("Numeric " + bcd + " too large to transfer to Virtuoso as numeric", -4);
        }
        int numbefdot = bcd.indexOf(46);
        int i = 0;
        if (numbefdot < 0) {
            numbefdot = len;
        }
        if ((numbefdot & 1) == 1) {
            flags |= 4;
        }
        if ((numaftdot = len - numbefdot - 1) < 0) {
            numaftdot = 0;
        }
        if ((numaftdot & 1) == 1) {
            flags |= 2;
        }
        this.write((len + ((flags & 2) == 2 ? 1 : 0) + ((flags & 4) == 4 ? 1 : 0) >> 1) + 2);
        this.write(flags);
        this.write(numbefdot + ((flags & 4) == 4 ? 1 : 0) >> 1);
        if ((flags & 4) == 4) {
            this.write(bcd.charAt(i++) - 48);
        }
        while (i < numbefdot) {
            this.write(bcd.charAt(i) - 48 << 4 | bcd.charAt(i + 1) - 48);
            i += 2;
        }
        if (numaftdot == 0) {
            return;
        }
        ++i;
        while (i <= numaftdot + numbefdot - ((flags & 2) == 2 ? 1 : 0)) {
            this.write(bcd.charAt(i) - 48 << 4 | bcd.charAt(i + 1) - 48);
            i += 2;
        }
        if ((flags & 2) == 2) {
            this.write(bcd.charAt(i++) - 48 << 4);
        }
    }

    private void writeRdfBox(VirtuosoRdfBox rb) throws IOException, VirtuosoException {
        int flags = 0;
        this.write(246);
        if (rb.rb_ro_id != 0L) {
            flags |= 1;
        }
        if (rb.rb_ro_id > 0xFFFFFFFFL) {
            flags |= 0x20;
        }
        if (257 != rb.rb_lang) {
            flags |= 4;
        }
        if (257 != rb.rb_type) {
            flags |= 8;
        }
        if (rb.rb_is_complete) {
            flags |= 2;
        }
        this.write(flags);
        this.write_object(rb.rb_box);
        if (rb.rb_ro_id != 0L) {
            if (rb.rb_ro_id > 0xFFFFFFFFL) {
                this.writerawlong(rb.rb_ro_id);
            } else {
                this.writelongint(rb.rb_ro_id);
            }
        }
        if (257 != rb.rb_type) {
            this.writeshort(rb.rb_type);
        }
        if (257 != rb.rb_lang) {
            this.writeshort(rb.rb_lang);
        }
    }

    private void writeobject(Object obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(obj);
        oos.flush();
        byte[] bytes = bos.toByteArray();
        oos = null;
        bos = null;
        this.write(254);
        this.writelongint(-1);
        if (bytes.length > 255) {
            this.write(223);
            this.writelongint(bytes.length);
        } else {
            this.write(222);
            this.write(bytes.length);
        }
        this.write(bytes, 0, bytes.length);
        bytes = null;
    }

    private void writestring(String string) throws IOException {
        int len = string.length();
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)string.charAt(i);
        }
        if (len < 256) {
            this.write(181);
            this.write(len);
        } else {
            this.write(182);
            this.writelongint(len);
        }
        this.write(bytes, 0, len);
    }

    private void writeDate(Object obj, int tag) throws IOException {
        int _frac;
        int _second;
        int _minute;
        int _hour;
        int yday;
        java.util.Date date = (java.util.Date)obj;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime((java.util.Date)obj);
        if (!(obj instanceof Time)) {
            int _year = cal.get(1);
            int _month = cal.get(2) + 1;
            int _day = cal.get(5);
            yday = VirtuosoOutputStream.date2num(_year, _month, _day);
        } else {
            int _day = 0;
            int _month = 0;
            int _year = 0;
            yday = 0;
        }
        if (!(obj instanceof Date)) {
            _hour = cal.get(11);
            _minute = cal.get(12);
            _second = cal.get(13);
            _frac = obj instanceof Timestamp ? ((Timestamp)obj).getNanos() : 0;
        } else {
            _frac = 0;
            _second = 0;
            _minute = 0;
            _hour = 0;
        }
        int tz = cal.get(15) + cal.get(16);
        if ((tz /= 60000) != 0) {
            int day = yday;
            int sec = 0;
            sec = DateObject.time_to_sec(0, _hour, _minute, _second);
            if ((sec -= 60 * tz) < 0) {
                day -= 1 + -sec / 86400;
                if ((sec %= 86400) == 0) {
                    ++day;
                }
                sec = 86400 + sec;
            } else {
                day += sec / 86400;
                sec %= 86400;
            }
            int dummy_day = sec / 86400;
            _hour = (sec - dummy_day * 86400) / 3600;
            _minute = (sec - dummy_day * 86400 - _hour * 60 * 60) / 60;
            _second = sec % 60;
            yday = day;
        }
        this.write(211);
        this.write(yday >> 16);
        this.write(yday >> 8);
        this.write(yday);
        this.write(_hour);
        yday = _second;
        this.write(_minute << 2 & 0xFC | yday >> 4 & 3);
        int temp = _frac;
        this.write(yday << 4 | temp >> 16 & 0xF);
        this.write(temp >> 8);
        this.write(temp);
        if (tz < 0) {
            tz = 65536 + tz;
        }
        int[] tz_bytes = new int[]{tz >> 8, tz & 0xFF};
        int type = 1;
        if (obj instanceof Time) {
            type = 3;
        }
        if (obj instanceof Date) {
            type = 2;
        }
        tz_bytes[0] = tz_bytes[0] & 7;
        tz_bytes[0] = tz_bytes[0] | type << 5;
        this.write(tz_bytes[0]);
        this.write(tz_bytes[1]);
    }

    public static int date2num(int year, int month, int day) {
        int julian_days = (year - 1) * 365 + (year - 1 >> 2);
        if (year > 1582 || year == 1582 && (month > 10 || month == 10 && day > 14)) {
            julian_days -= 10;
        }
        if (year > 1582) {
            julian_days += (year - 1) / 400 - 3;
            julian_days -= (year - 1) / 100 - 15;
        }
        julian_days += cumdays_in_month[month - 1];
        julian_days += day;
        if (VirtuosoOutputStream.days_in_february(year) == 29 && month > 2) {
            ++julian_days;
        }
        return julian_days;
    }

    public static int days_in_february(int year) {
        int day;
        if (year > 1582) {
            day = (year & 3) != 0 ? 28 : (year % 100 == 0 && year % 400 != 0 ? 28 : 29);
        } else {
            if (year == 1582) {
                // empty if block
            }
            int n = day = (year & 3) != 0 ? 28 : 29;
        }
        if (year == 4) {
            --day;
        }
        return day;
    }

    private int whatIs(Object obj) {
        if (obj == null) {
            return 180;
        }
        if (obj instanceof VirtuosoNullParameter) {
            return 204;
        }
        if (obj instanceof VectorOfLong) {
            return 209;
        }
        if (obj instanceof VectorOfDouble) {
            return 195;
        }
        if (obj instanceof VectorOfFloat) {
            return 202;
        }
        if (obj instanceof LinkedList) {
            return 196;
        }
        if (obj instanceof ArrayList) {
            return 196;
        }
        if (obj instanceof Vector) {
            return 193;
        }
        if (obj instanceof Short) {
            return 188;
        }
        if (obj instanceof Boolean) {
            return 188;
        }
        if (obj instanceof Byte) {
            return 188;
        }
        if (obj instanceof Long) {
            Long o = (Long)obj;
            if (o >= -128L && o < 128L) {
                return 188;
            }
            if (o >= Integer.MIN_VALUE && o <= Integer.MAX_VALUE) {
                return 189;
            }
            return 247;
        }
        if (obj instanceof Integer) {
            Integer o = (Integer)obj;
            return o.longValue() >= -128L && o.longValue() < 128L ? 188 : 189;
        }
        if (obj instanceof Float) {
            return 190;
        }
        if (obj instanceof Double) {
            return 191;
        }
        if (obj instanceof String) {
            String o = (String)obj;
            return o.length() < 256 ? 181 : 182;
        }
        if (obj instanceof BigDecimal) {
            return 219;
        }
        if (obj instanceof byte[]) {
            return ((byte[])obj).length < 256 ? 222 : 223;
        }
        if (obj instanceof Date) {
            return 129;
        }
        if (obj instanceof Time) {
            return 210;
        }
        if (obj instanceof Timestamp) {
            return 128;
        }
        if (obj instanceof java.util.Date) {
            return 211;
        }
        if (obj instanceof Clob) {
            return 125;
        }
        if (obj instanceof Blob) {
            return 131;
        }
        if (obj instanceof VirtuosoExplicitString) {
            VirtuosoExplicitString sobj = (VirtuosoExplicitString)obj;
            return ((VirtuosoExplicitString)obj).getDtp();
        }
        if (obj instanceof VirtuosoExtendedString) {
            return 207;
        }
        if (obj instanceof VirtuosoRdfBox) {
            return 246;
        }
        return 0;
    }
}

