/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.javax;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import virtuoso.javax.OPLMessage_x;

public abstract class BaseRowSet
implements RowSet,
Serializable {
    private static final long serialVersionUID = 5374661472998522423L;
    protected static final int ev_CursorMoved = 1;
    protected static final int ev_RowChanged = 2;
    protected static final int ev_RowSetChanged = 3;
    private String command;
    private String url;
    private String dataSource;
    private transient String username;
    private transient String password;
    private int rsType = 1004;
    private int rsConcurrency = 1008;
    private int queryTimeout = 0;
    private int maxRows = 0;
    private int maxFieldSize = 0;
    private boolean readOnly = true;
    private boolean escapeProcessing = true;
    private int txn_isolation = 2;
    private int fetchDir = 1000;
    private int fetchSize = 0;
    private Map map = null;
    private LinkedList listeners = new LinkedList();
    private ArrayList params = new ArrayList();

    public void close() throws SQLException {
        this.clearParameters();
        this.listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRowSetListener(RowSetListener rowsetlistener) {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.add(rowsetlistener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRowSetListener(RowSetListener rowsetlistener) {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.remove(rowsetlistener);
        }
    }

    public void clearParameters() throws SQLException {
        this.params.clear();
    }

    public String getCommand() {
        return this.command;
    }

    public int getConcurrency() throws SQLException {
        return this.rsConcurrency;
    }

    public String getDataSourceName() {
        return this.dataSource;
    }

    public boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDir;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public Object[] getParams() throws SQLException {
        return this.params.toArray();
    }

    public String getPassword() {
        return this.password;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public int getTransactionIsolation() {
        return this.txn_isolation;
    }

    public int getType() throws SQLException {
        return this.rsType;
    }

    public Map getTypeMap() throws SQLException {
        return this.map;
    }

    public String getUrl() throws SQLException {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public synchronized void setArray(int parameterIndex, Array x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    public synchronized void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 3;
        param.length = length;
    }

    public synchronized void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    public synchronized void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 4;
        param.length = length;
    }

    public synchronized void setBlob(int parameterIndex, Blob x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    public synchronized void setBoolean(int parameterIndex, boolean x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = new Boolean(x);
        param.jType = 0;
    }

    public synchronized void setByte(int parameterIndex, byte x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = new Byte(x);
        param.jType = 0;
    }

    public synchronized void setBytes(int parameterIndex, byte[] x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    public synchronized void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 6;
        param.length = length;
    }

    public synchronized void setClob(int parameterIndex, Clob x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    public synchronized void setDate(int parameterIndex, Date x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    public synchronized void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 7;
        param.cal = cal;
    }

    public synchronized void setDouble(int parameterIndex, double x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = new Double(x);
        param.jType = 0;
    }

    public synchronized void setFloat(int parameterIndex, float x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = new Float(x);
        param.jType = 0;
    }

    public synchronized void setInt(int parameterIndex, int x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = new Integer(x);
        param.jType = 0;
    }

    public synchronized void setLong(int parameterIndex, long x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = new Long(x);
        param.jType = 0;
    }

    public synchronized void setRef(int parameterIndex, Ref x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    public synchronized void setShort(int parameterIndex, short x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = new Short(x);
        param.jType = 0;
    }

    public synchronized void setString(int parameterIndex, String x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    public synchronized void setURL(int parameterIndex, URL x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    public synchronized void setTime(int parameterIndex, Time x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    public synchronized void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 8;
        param.cal = cal;
    }

    public synchronized void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    public synchronized void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
        param.cal = cal;
    }

    public synchronized void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 5;
        param.length = length;
    }

    public synchronized void setNull(int parameterIndex, int sqlType) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = null;
        param.jType = 10;
        param.sqlType = sqlType;
    }

    public synchronized void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = null;
        param.jType = 11;
        param.sqlType = sqlType;
        param.typeName = typeName;
    }

    public synchronized void setObject(int parameterIndex, Object x) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
    }

    public synchronized void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
        param.sqlType = targetSqlType;
    }

    public synchronized void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        Parameter param = this.getParam(parameterIndex);
        param.value = x;
        param.jType = 0;
        param.sqlType = targetSqlType;
        param.scale = scale;
    }

    public synchronized void setCommand(String s) throws SQLException {
        this.command = new String(s);
        this.params.clear();
    }

    public void setConcurrency(int i) throws SQLException {
        this.rsConcurrency = i;
    }

    public void setDataSourceName(String s) throws SQLException {
        this.dataSource = s != null ? new String(s) : null;
        this.url = null;
    }

    public void setEscapeProcessing(boolean flag) throws SQLException {
        this.escapeProcessing = flag;
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.fetchDir = direction;
    }

    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.maxFieldSize = max;
    }

    public void setMaxRows(int max) throws SQLException {
        this.maxRows = max;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    public void setReadOnly(boolean value) throws SQLException {
        this.readOnly = value;
    }

    public void setPassword(String s) throws SQLException {
        this.password = s != null ? new String(s) : null;
    }

    public void setTransactionIsolation(int value) throws SQLException {
        this.txn_isolation = value;
    }

    public void setType(int value) throws SQLException {
        this.rsType = value;
    }

    public void setTypeMap(Map value) throws SQLException {
        this.map = value;
    }

    public void setUrl(String s) throws SQLException {
        this.url = s != null ? new String(s) : null;
        this.dataSource = null;
    }

    public void setUsername(String s) throws SQLException {
        this.username = s != null ? new String(s) : null;
    }

    protected void notifyListener(int event) {
        if (!this.listeners.isEmpty()) {
            LinkedList l = (LinkedList)this.listeners.clone();
            RowSetEvent ev = new RowSetEvent(this);
            Iterator i = l.iterator();
            while (i.hasNext()) {
                switch (event) {
                    case 1: {
                        ((RowSetListener)i.next()).cursorMoved(ev);
                        break;
                    }
                    case 2: {
                        ((RowSetListener)i.next()).rowChanged(ev);
                        break;
                    }
                    case 3: {
                        ((RowSetListener)i.next()).rowSetChanged(ev);
                    }
                }
            }
            l.clear();
        }
    }

    protected Parameter getParam(int paramIndex) throws SQLException {
        if (paramIndex < 1) {
            throw OPLMessage_x.makeExceptionV(12, String.valueOf(paramIndex));
        }
        int sz = this.params.size();
        if (--paramIndex < sz) {
            return (Parameter)this.params.get(paramIndex);
        }
        while (sz < paramIndex) {
            this.params.add(new Parameter());
            ++sz;
        }
        Parameter param = new Parameter();
        this.params.add(param);
        return param;
    }

    protected class Parameter {
        protected Object value;
        protected int sqlType = 12;
        protected String typeName;
        protected int scale;
        protected int length;
        protected Calendar cal;
        protected int jType = 0;
        protected static final int jObject = 0;
        protected static final int jObject_1 = 1;
        protected static final int jObject_2 = 2;
        protected static final int jAsciiStream = 3;
        protected static final int jBinaryStream = 4;
        protected static final int jUnicodeStream = 5;
        protected static final int jCharacterStream = 6;
        protected static final int jDateWithCalendar = 7;
        protected static final int jTimeWithCalendar = 8;
        protected static final int jTimestampWithCalendar = 9;
        protected static final int jNull_1 = 10;
        protected static final int jNull_2 = 11;

        protected Parameter() {
        }
    }
}

