/*
 * Decompiled with CFR 0.152.
 */
package openlink.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import openlink.util.OPLMessage_u;

public class OPLHeapBlob
implements Blob,
Serializable {
    static final long serialVersionUID = -6793193829176495886L;
    private byte[] blobData = null;
    private long blobLength = 0L;
    private static final int buf_size = 32768;
    private Object lck = this;

    public OPLHeapBlob() {
        this.blobData = new byte[1];
    }

    public OPLHeapBlob(byte[] b) {
        this(b, 0, b.length);
    }

    public OPLHeapBlob(byte[] b, int off, int len) {
        this.blobData = new byte[len];
        System.arraycopy(b, off, this.blobData, 0, len);
        this.blobLength = len;
    }

    public OPLHeapBlob(InputStream is) throws SQLException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(32768);
            BufferedInputStream in = new BufferedInputStream(is, 32768);
            byte[] tmp = new byte[32768];
            int sz = in.read(tmp, 0, 32768);
            while (sz != -1) {
                out.write(tmp, 0, sz);
                sz = in.read(tmp, 0, 32768);
            }
            this.blobData = out.toByteArray();
            this.blobLength = this.blobData.length;
        }
        catch (IOException e) {
            throw OPLMessage_u.makeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        this.ensureOpen();
        Object object = this.lck;
        synchronized (object) {
            return this.blobLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(long pos, int len) throws SQLException {
        this.ensureOpen();
        Object object = this.lck;
        synchronized (object) {
            if (--pos >= this.blobLength) {
                throw OPLMessage_u.makeException(2);
            }
            if ((long)len > this.blobLength - pos) {
                len = (int)(this.blobLength - pos);
            }
            byte[] tmp = new byte[len];
            System.arraycopy(this.blobData, (int)pos, tmp, 0, len);
            return tmp;
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        this.ensureOpen();
        return new BlobInputStream(this.lck);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(byte[] pattern, long start) throws SQLException {
        this.ensureOpen();
        Object object = this.lck;
        synchronized (object) {
            if (start < 1L) {
                throw OPLMessage_u.makeException(2);
            }
            if (--start > this.blobLength) {
                return -1L;
            }
            int i = (int)start;
            while ((long)i < this.blobLength && (long)pattern.length <= this.blobLength - (long)i) {
                if (this.blobData[i] == pattern[0]) {
                    boolean match = true;
                    for (int j = 1; j < pattern.length; ++j) {
                        if (this.blobData[i + j] == pattern[j]) continue;
                        match = false;
                        break;
                    }
                    if (match) {
                        return i + 1;
                    }
                }
                ++i;
            }
        }
        return -1L;
    }

    public long position(Blob pattern, long start) throws SQLException {
        this.ensureOpen();
        if (start < 1L) {
            throw OPLMessage_u.makeException(2);
        }
        return this.position(pattern.getBytes(0L, (int)pattern.length()), start);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        this.ensureOpen();
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.ensureOpen();
        Object object = this.lck;
        synchronized (object) {
            BlobOutputStream os = new BlobOutputStream(this.lck, pos);
            try {
                ((OutputStream)os).write(bytes, offset, len);
            }
            catch (IOException e) {
                OPLMessage_u.makeException(e);
            }
        }
        return len;
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.ensureOpen();
        return new BlobOutputStream(this.lck, pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(long len) throws SQLException {
        this.ensureOpen();
        Object object = this.lck;
        synchronized (object) {
            int newLen = (int)len;
            if (newLen < 0 || (long)newLen > this.blobLength) {
                throw OPLMessage_u.makeException(3);
            }
            if (newLen < this.blobData.length) {
                byte[] newbuf = new byte[newLen];
                System.arraycopy(this.blobData, 0, newbuf, 0, newLen);
                this.blobData = newbuf;
            }
            this.blobLength = len;
        }
    }

    private void ensureOpen() throws SQLException {
        if (this.blobData == null) {
            throw OPLMessage_u.makeException(4);
        }
    }

    static /* synthetic */ byte[] access$102(OPLHeapBlob x0, byte[] x1) {
        x0.blobData = x1;
        return x1;
    }

    protected class BlobOutputStream
    extends OutputStream {
        protected int count;
        private boolean isClosed = false;
        private Object lock;

        protected BlobOutputStream(Object lck, long pos) {
            this.lock = lck;
            this.count = (int)pos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int b) throws IOException {
            this.ensureOpen();
            Object object = this.lock;
            synchronized (object) {
                int newcount = this.count + 1;
                if (newcount > OPLHeapBlob.this.blobData.length) {
                    byte[] newbuf = new byte[Math.max(OPLHeapBlob.this.blobData.length + 32768, newcount)];
                    System.arraycopy(OPLHeapBlob.this.blobData, 0, newbuf, 0, this.count);
                    OPLHeapBlob.access$102(OPLHeapBlob.this, newbuf);
                }
                ((OPLHeapBlob)OPLHeapBlob.this).blobData[this.count] = (byte)b;
                this.count = newcount;
                OPLHeapBlob.this.blobLength += 1L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b, int off, int len) throws IOException {
            this.ensureOpen();
            Object object = this.lock;
            synchronized (object) {
                if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return;
                }
                int newcount = this.count + len;
                if (newcount > OPLHeapBlob.this.blobData.length) {
                    byte[] newbuf = new byte[Math.max(OPLHeapBlob.this.blobData.length + 32768, newcount)];
                    System.arraycopy(OPLHeapBlob.this.blobData, 0, newbuf, 0, this.count);
                    OPLHeapBlob.access$102(OPLHeapBlob.this, newbuf);
                }
                System.arraycopy(b, off, OPLHeapBlob.this.blobData, this.count, len);
                this.count = newcount;
                OPLHeapBlob.this.blobLength += len;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                this.isClosed = true;
            }
        }

        private void ensureOpen() throws IOException {
            if (this.isClosed || OPLHeapBlob.this.blobData == null) {
                throw new IOException(OPLMessage_u.getMessage(1));
            }
        }
    }

    protected class BlobInputStream
    extends InputStream {
        private boolean isClosed = false;
        private int pos = 0;
        private long length;
        private Object lock;

        protected BlobInputStream(Object lck) {
            this.lock = lck;
            this.length = OPLHeapBlob.this.blobLength;
        }

        protected BlobInputStream(Object lck, long pos, long length) {
            this.lock = lck;
            this.pos = (int)pos;
            this.length = length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            this.ensureOpen();
            Object object = this.lock;
            synchronized (object) {
                return (long)this.pos < this.length ? OPLHeapBlob.this.blobData[this.pos++] & 0xFF : -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] b, int off, int len) throws IOException {
            this.ensureOpen();
            Object object = this.lock;
            synchronized (object) {
                if (b == null) {
                    throw new NullPointerException();
                }
                if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if ((long)this.pos >= this.length) {
                    return -1;
                }
                if ((long)(this.pos + len) > this.length) {
                    len = (int)(this.length - (long)this.pos);
                }
                if (len <= 0) {
                    return 0;
                }
                System.arraycopy(OPLHeapBlob.this.blobData, this.pos, b, off, len);
                this.pos += len;
                return len;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long skip(long n) throws IOException {
            this.ensureOpen();
            Object object = this.lock;
            synchronized (object) {
                if ((long)this.pos + n > this.length) {
                    n = this.length - (long)this.pos;
                }
                if (n < 0L) {
                    return 0L;
                }
                this.pos = (int)((long)this.pos + n);
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                this.isClosed = true;
            }
        }

        private void ensureOpen() throws IOException {
            if (this.isClosed || OPLHeapBlob.this.blobData == null) {
                throw new IOException(OPLMessage_u.getMessage(1));
            }
        }
    }
}

