/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.javax;

import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.sql.RowSetMetaData;
import virtuoso.javax.OPLMessage_x;

public class OPLRowSetMetaData
implements RowSetMetaData,
Serializable {
    private static final long serialVersionUID = 4491018005954285242L;
    private Coldesc[] desc;

    public OPLRowSetMetaData(ResultSetMetaData rsmd) throws SQLException {
        int count = rsmd.getColumnCount();
        this.setColumnCount(count);
        for (int i = 0; i < count; ++i) {
            int col = i + 1;
            this.desc[i].columnLabel = rsmd.getColumnLabel(col);
            this.desc[i].columnName = rsmd.getColumnName(col);
            String v = rsmd.getSchemaName(col);
            this.desc[i].schemaName = v != null ? v : "";
            v = rsmd.getTableName(col);
            this.desc[i].tableName = v != null ? v : "";
            v = rsmd.getCatalogName(col);
            this.desc[i].catalogName = v != null ? v : "";
            this.desc[i].typeName = rsmd.getColumnTypeName(col);
            this.desc[i].type = rsmd.getColumnType(col);
            this.desc[i].precision = rsmd.getPrecision(col);
            this.desc[i].scale = rsmd.getScale(col);
            this.desc[i].displaySize = rsmd.getColumnDisplaySize(col);
            this.desc[i].isAutoIncrement = rsmd.isAutoIncrement(col);
            this.desc[i].isCaseSensitive = rsmd.isCaseSensitive(col);
            this.desc[i].isCurrency = rsmd.isCurrency(col);
            this.desc[i].nullable = rsmd.isNullable(col);
            this.desc[i].isSigned = rsmd.isSigned(col);
            this.desc[i].isSearchable = rsmd.isSearchable(col);
            this.desc[i].isDefinitelyWritable = rsmd.isDefinitelyWritable(col);
            this.desc[i].isReadOnly = rsmd.isReadOnly(col);
            this.desc[i].isWritable = rsmd.isWritable(col);
        }
    }

    @Override
    public void setAutoIncrement(int column, boolean property) throws SQLException {
        this.check_index(column).isAutoIncrement = property;
    }

    @Override
    public void setCaseSensitive(int column, boolean property) throws SQLException {
        this.check_index(column).isCaseSensitive = property;
    }

    @Override
    public void setCatalogName(int column, String catalogName) throws SQLException {
        if (catalogName != null) {
            this.check_index(column).catalogName = catalogName;
        } else {
            this.check_index(column).catalogName = "";
        }
    }

    @Override
    public void setColumnCount(int columnCount) throws SQLException {
        if (columnCount <= 0) {
            throw OPLMessage_x.makeException(8);
        }
        this.desc = new Coldesc[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            this.desc[i] = new Coldesc();
        }
    }

    @Override
    public void setColumnDisplaySize(int column, int size) throws SQLException {
        this.check_index(column).displaySize = size;
    }

    @Override
    public void setColumnLabel(int column, String label) throws SQLException {
        this.check_index(column).columnLabel = label;
    }

    @Override
    public void setColumnName(int column, String columnName) throws SQLException {
        this.check_index(column).columnName = columnName;
    }

    @Override
    public void setColumnType(int column, int SQLType2) throws SQLException {
        this.check_index(column).type = SQLType2;
    }

    @Override
    public void setColumnTypeName(int column, String typeName) throws SQLException {
        this.check_index(column).typeName = typeName;
    }

    @Override
    public void setCurrency(int column, boolean property) throws SQLException {
        this.check_index(column).isCurrency = property;
    }

    @Override
    public void setNullable(int column, int property) throws SQLException {
        this.check_index(column).nullable = property;
    }

    @Override
    public void setPrecision(int column, int precision) throws SQLException {
        this.check_index(column).precision = precision;
    }

    @Override
    public void setScale(int column, int scale) throws SQLException {
        this.check_index(column).scale = scale;
    }

    @Override
    public void setSchemaName(int column, String schemaName) throws SQLException {
        if (schemaName != null) {
            this.check_index(column).schemaName = schemaName;
        } else {
            this.check_index(column).schemaName = "";
        }
    }

    @Override
    public void setSearchable(int column, boolean property) throws SQLException {
        this.check_index(column).isSearchable = property;
    }

    @Override
    public void setSigned(int column, boolean property) throws SQLException {
        this.check_index(column).isSigned = property;
    }

    @Override
    public void setTableName(int column, String tableName) throws SQLException {
        if (tableName != null) {
            this.check_index(column).tableName = tableName;
        } else {
            this.check_index(column).tableName = "";
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.desc != null ? this.desc.length : 0;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.check_index(column).isAutoIncrement;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.check_index(column).isCaseSensitive;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.check_index(column).isSearchable;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.check_index(column).isCurrency;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.check_index(column).nullable;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.check_index(column).isSigned;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.check_index(column).displaySize;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.check_index(column).columnLabel;
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.check_index(column).columnName;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.check_index(column).schemaName;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.check_index(column).precision;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.check_index(column).scale;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.check_index(column).tableName;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.check_index(column).catalogName;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.check_index(column).type;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.check_index(column).typeName;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.check_index(column).isReadOnly;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return this.check_index(column).isWritable;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.check_index(column).isDefinitelyWritable;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw OPLMessage_x.makeExceptionV(36, iface.toString());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    private Coldesc check_index(int column) throws SQLException {
        if (this.desc == null || column < 1 || column > this.desc.length) {
            throw OPLMessage_x.makeException(9);
        }
        return this.desc[column - 1];
    }

    private class Coldesc
    implements Serializable {
        private String columnLabel;
        private String columnName;
        private String schemaName;
        private String tableName;
        private String catalogName;
        private String typeName;
        private int type;
        private int precision;
        private int scale;
        private int displaySize;
        private int nullable;
        private boolean isAutoIncrement;
        private boolean isCaseSensitive;
        private boolean isCurrency;
        private boolean isSigned;
        private boolean isSearchable;
        private boolean isDefinitelyWritable;
        private boolean isReadOnly;
        private boolean isWritable;

        private Coldesc() {
        }
    }
}

