/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import openlink.util.Vector;
import virtuoso.jdbc4.VirtuosoColumn;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoResultSetMetaData;

public class VirtuosoParameterMetaData
implements ParameterMetaData {
    protected Vector parameters;

    VirtuosoParameterMetaData(Vector args, VirtuosoConnection conn) throws VirtuosoException {
        this.parameters = args == null ? new Vector(0) : (Vector)args.clone();
    }

    @Override
    public int getParameterCount() throws VirtuosoException {
        return this.parameters.size();
    }

    private Vector getPd(int param) throws VirtuosoException {
        if (param < 0 || param > this.getParameterCount()) {
            throw new VirtuosoException("No such parameter", "22023", -4);
        }
        Object pd = this.parameters.elementAt(param);
        if (pd == null || !(pd instanceof Vector)) {
            throw new VirtuosoException("Invalid param info type", "22023", -4);
        }
        Vector pdd = (Vector)pd;
        if (pdd.size() < 5) {
            throw new VirtuosoException("Invalid param info size", "22023", -4);
        }
        return pdd;
    }

    @Override
    public int isNullable(int param) throws VirtuosoException {
        int nullable = ((Number)this.getPd(param).elementAt(3)).intValue();
        return nullable != 0 ? 1 : 0;
    }

    @Override
    public boolean isSigned(int param) throws VirtuosoException {
        int dtp = ((Number)this.getPd(param).elementAt(3)).intValue();
        return dtp == 186 || dtp == 181 || dtp == 238 || dtp == 187 || dtp == 182 || dtp == 183 || dtp == 225 || dtp == 226 || dtp == 184 || dtp == 188 || dtp == 189 || dtp == 201 || dtp == 190 || dtp == 191 || dtp == 192 || dtp == 219;
    }

    @Override
    public int getPrecision(int param) throws VirtuosoException {
        return ((Number)this.getPd(param).elementAt(1)).intValue();
    }

    @Override
    public int getScale(int param) throws VirtuosoException {
        return ((Number)this.getPd(param).elementAt(2)).intValue();
    }

    @Override
    public int getParameterType(int param) throws VirtuosoException {
        return VirtuosoColumn.getColumnType(((Number)this.getPd(param).elementAt(0)).intValue());
    }

    @Override
    public String getParameterTypeName(int param) throws VirtuosoException {
        return VirtuosoResultSetMetaData._getColumnTypeName(this.getParameterType(((Number)this.getPd(param).elementAt(0)).intValue()));
    }

    @Override
    public String getParameterClassName(int param) throws VirtuosoException {
        return VirtuosoColumn.getColumnClassName(((Number)this.getPd(param).elementAt(0)).intValue());
    }

    @Override
    public int getParameterMode(int param) throws VirtuosoException {
        switch (((Number)this.getPd(param).elementAt(0)).intValue()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw new VirtuosoException("Unable to unwrap to " + iface.toString(), "22023", -4);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

