/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.io.IOException;
import java.io.InputStream;
import virtuoso.jdbc4.VirtuosoBlob;

class VirtuosoClobStream
extends InputStream {
    private VirtuosoBlob clob;
    protected long pos = 1L;

    VirtuosoClobStream(VirtuosoBlob clob) {
        this.clob = clob;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.pos > this.clob.length() ? -1 : this.clob.getSubString(this.pos++, 1).getBytes("ASCII")[0];
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            byte[] bytes = null;
            if (len <= 0) {
                return 0;
            }
            if (this.pos + (long)len > this.clob.length()) {
                int to_read = (int)(this.clob.length() - this.pos + 1L);
                if (to_read > 0) {
                    bytes = this.clob.getSubString(this.pos, to_read).getBytes("ASCII");
                }
                if (bytes != null) {
                    System.arraycopy(bytes, 0, b, off, to_read);
                    this.pos = this.clob.length() + 1L;
                    return bytes.length;
                }
                return -1;
            }
            bytes = this.clob.getSubString(this.pos, len).getBytes("ASCII");
            if (bytes != null) {
                System.arraycopy(bytes, 0, b, off, len);
                this.pos += (long)bytes.length;
                return bytes.length;
            }
            return -1;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            if (n <= 0L) {
                return 0L;
            }
            if (this.pos + n > this.clob.length()) {
                long _prov = this.clob.length() - this.pos;
                this.pos = this.clob.length();
                return _prov;
            }
            this.pos += n;
            return n;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public int available() throws IOException {
        try {
            return (int)(this.clob.length() - this.pos + 1L);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

