<?php
 /*
   Tiquit Is Quality User Incident Tracking
   Copyright (C) 2007 Jonathan Ciesla
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
  */
require_once("config.php");
require_once("functionlib.php");
authentication(0, 0);
favicon();

$link = dbms_connect($dbhost, $dbuser, $dbpass, $dbname);

echo "<link rel=stylesheet href=css.php>";
echo "<title>$sitetitle</title>";
echo "<h1>$sitetitle</h1>";

echo "<h2>Custom Reports</h2>";

$date_a = array(date("Y"), date("m"), date("d"));
$today = implode("-", $date_a);

//grab and save query if requested
if(dbms_escape_string($_POST['save'])){
  $title = dbms_escape_string($_POST['title']);

  $user_id = $_SESSION['tiquitid'];
  $query1 = "SELECT number FROM agent WHERE id ='$user_id'";
  $result = dbms_query($query1);
  $line = dbms_fetch_array($result, "NUM");
  $owner = $line[0];
  dbms_free_result($result);

  //check for title, set up query
  $query = "SELECT COUNT(number) FROM reports WHERE title = '$title';";
  $result = dbms_query($query);
  $line = dbms_fetch_array($result, "NUM");
  dbms_free_result($result);
  if($line[0]>0){
    $query = "UPDATE reports SET ";
    $querycap = "WHERE title = '$title' AND owner = '$owner';";
  } else {
    $query1 = "SELECT number FROM reports ORDER BY number DESC LIMIT 1;";
    $result = dbms_query($query1);
    $line = dbms_fetch_array($result, "NUM");
    $num = $line[0];
    $num++;
    dbms_free_result($result);
    
    $query = "INSERT INTO reports SET ";
    $querycap = "title = '$title',number = '$num',owner = '$owner';";
  };
  //agent or group
  if(dbms_escape_string($_POST['ag'])){
    //agent
    if(dbms_escape_string($_POST['ag']=='agent')){
      $query .= " ag='1',";
      $string = "";
      $count = 0;
      foreach($_POST['agent'] as $agent){
	if($count>0){
	  $string .= "|";
	};
	$string .= $agent;
	$count++;
      };
      $query .= "agent='$string',";
    };
    //group
    if(dbms_escape_string($_POST['ag']=='group')){
      $query .= " gr='1',";
      $string = "";
      $count = 0;
      foreach($_POST['group'] as $group){
	if($count>0){
	  $string .= "|";
	};
	$string .= $group;
	$count++;
      };
      $query .= " grp='$string',";
    };
  };
  //user or location
  if(dbms_escape_string($_POST['ul'])){
    //user
    if(dbms_escape_string($_POST['ul']=='user')){
      $query .= " us='1',";
      $string = "";
      $count = 0;
      foreach($_POST['user'] as $user){
	if($count>0){
	  $string .= "|";
	};
	$string .= $user;
	$count++;
      };
      $query .= "usr='$string',";
    };
    //location
    if(dbms_escape_string($_POST['ul']=='location')){
      $query .= "lo='1',";
      $string = "";
      $count = 0;
      foreach($_POST['location'] as $location){
	if($count>0){
	  $string .= "|";
	};
	$string .= $location;
	$count++;
      };
      $query .= "location='$string',";
    };
  };
  //status
  if(dbms_escape_string($_POST['status'])){
    $query .= "status='1',";
    $string = "";
    $count = 0;
    foreach($_POST['status1'] as $status){
      if($count>0){
	$string .= "|";
      };
      $string .= $status;
      $count++;
    };
    $query .= "status1='$string',";
  };
  //severity
  if(dbms_escape_string($_POST['severity'])){
    $query .= "severity='1',";
    $string = "";
    $count = 0;
    foreach($_POST['severity1'] as $severity){
      if($count>0){
	$string .= "|";
      };
      $string .= $severity;
      $count++;
    };
    $query .= "severity1='$string',";
  };
  //type
  if(dbms_escape_string($_POST['type'])){
    $query .= "type='1',";
    $string = "";
    $count = 0;
    foreach($_POST['type1'] as $type){
      if($count>0){
	$string .= "|";
      };
      $string .= $type;
      $count++;
    };
    $query .= "type1='$string',";
  };
  //logged
  if(dbms_escape_string($_POST['logged'])){
    $query .= " logged='1',";
    $string = "";
    $count = 0;
    foreach($_POST['logged1'] as $logged){
      if($count>0){
	$string .= "|";
      };
      $string .= $logged;
      $count++;
    };
    $query .= "logged1='$string',";
  };
  //closed
  if(dbms_escape_string($_POST['closer'])){
    $query .= " closer='1',";
    $string = "";
    $count = 0;
    foreach($_POST['closer1'] as $closer){
      if($count>0){
	$string .= "|";
      };
      $string .= $closer;
      $count++;
    };
    $query .= "closer1='$string',";
  };
  $query = $query . $querycap;
  $result = dbms_query($query);
 };


//set up initial query

$query = "SELECT number,usr,type,description,date,status,severity FROM incident WHERE 1";

//process dates
//open
$date1 = dbms_escape_string($_POST['date1']);
$date2 = dbms_escape_string($_POST['date2']);

if(!$date1){$date1=$today;};
if(!$date2){$date2=inc_new_date($date1);};

$query .= " AND date >= '$date1' AND date <= '$date2'";

//closed
if(dbms_escape_string($_POST['closed'])){
  $closed1 = dbms_escape_string($_POST['closed1']);
  $closed2 = dbms_escape_string($_POST['closed2']);
  
  if(!$closed1){$closed1=$today;};
  if(!$closed2){$closed2=inc_new_date($closed1);};

  $query .= " AND closed >= '$closed1' AND closed <= '$closed2'";

 };


//process people


//agent or group
if(dbms_escape_string($_POST['ag']=='agent')){
  $count = 0;
  foreach($_POST['agent'] as $agent){
    $agent = dbms_escape_string($agent);
    if($count==0){ 
      $query .= " AND ( agent = '$agent'";
    } else {
      $query .= " OR agent = '$agent'";
    };
    $count++;
  };
  $query .= " )";
 };
if(dbms_escape_string($_POST['ag']=='group')){
  $count = 0;
  foreach($_POST['group'] as $group){
    $group = dbms_escape_string($group);
    if($count==0){
      $query .= " AND ( agent = ANY( SELECT number FROM agent WHERE grp = '$group' )";
    } else {
      $query .= " OR agent = ANY( SELECT number FROM agent WHERE grp = '$group' )";
    };
    $count++;
  };
  $query .= " )";
 };

//user or location
if(dbms_escape_string($_POST['ul']=='user')){
  $count = 0;
  foreach($_POST['user'] as $user){
    $user = dbms_escape_string($user);
    if($count==0){ 
      $query .= " AND ( usr = '$user'";
    } else {
      $query .= " OR usr = '$user'";
    };
    $count++;
  };
  $query .= " )";
 };
if(dbms_escape_string($_POST['ul']=='location')){
  $count = 0;
  foreach($_POST['location'] as $location){
    $location = dbms_escape_string($location);
    if($count==0){
      $query .= " AND ( usr = ANY( SELECT number FROM users WHERE location = '$location' )";
    } else {
      $query .= " OR usr = ANY( SELECT number FROM users WHERE location = '$location' )";
    };
    $count++;
  };
  $query .= " )";
 };
//process status
if(dbms_escape_string($_POST['status'])){
  $count = 0;
  foreach($_POST['status1'] as $status){
    $status = dbms_escape_string($status);
    if($count==0){ 
      $query .= " AND ( status = '$status'";
    } else {
      $query .= " OR status = '$status'";
    };
    $count++;
  };
  $query .= " )";
 };

//process severity
if(dbms_escape_string($_POST['severity'])){
  $count = 0;
  foreach($_POST['severity1'] as $severity){
    $severity = dbms_escape_string($severity);
    if($count==0){ 
      $query .= " AND ( severity = '$severity'";
    } else {
      $query .= " OR severity = '$severity'";
    };
    $count++;
  };
  $query .= " )";
 };

//process type
if(dbms_escape_string($_POST['type'])){
  $count = 0;
  foreach($_POST['type1'] as $type){
    $type = dbms_escape_string($type);
    if($count==0){ 
      $query .= " AND ( type = '$type'";
    } else {
      $query .= " OR type = '$type'";
    };
    $count++;
  };
  $query .= " )";
 };

//process logged by
if(dbms_escape_string($_POST['logged'])){
  $count = 0;
  foreach($_POST['logged1'] as $logged){
    $logged = dbms_escape_string($logged);
    if($count==0){ 
      $query .= " AND ( logged = '$logged'";
    } else {
      $query .= " OR logged = '$logged'";
    };
    $count++;
  };
  $query .= " )";
 };

//process closer
if(dbms_escape_string($_POST['closer'])){
  $count = 0;
  foreach($_POST['closer1'] as $closer){
    $closer = dbms_escape_string($closer);
    if($count==0){ 
      $query .= " AND ( closer = '$closer'";
    } else {
      $query .= " OR closer = '$closer'";
    };
    $count++;
  };
  $query .= " )";
 };

//execute query
$query .= ";";
$result = dbms_query($query);

//display results
while ($line = dbms_fetch_array($result, "NUM")) {
  $query1 = "SELECT lname,fname FROM users WHERE number = '$line[1]';";
  $result1 = dbms_query($query1, $link);
  $user_full = dbms_fetch_array($result1, "NUM");
  $user_full_name = $user_full[0] . ", " . $user_full[1];
  dbms_free_result($result1);

  $typea = type_name($line[2]);

  $wrapped = wordwrap($line[3], 45, "<br />\n", 1);

  echo "<table border=1 align=center>";
  echo "<tr><th width=20>Number</th><th width=75>Type</th><th width=300>Description</th><th width=150>User</th><th width=20>Severity</th><th>Date</th><th width=20>Status</th></tr>";
  echo "<tr><td align=center>{$line[0]}</td><td align=center>$typea</td><td>$wrapped</td><td align=center>$user_full_name</td><td align=center>{$line[6]}</td><td>{$line[5]}</td><td align=center>{$line[4]}</td></tr>";
  echo "</table>";
  echo "</br>";
 };

dbms_free_result($result);

dbms_close($link);

?>