/*
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _PST_STREAM_H
#define _PST_STREAM_H

#include <Python.h>
#include "streamtuner.h"
#include "pst-helpers.h"

typedef struct _PythonStream PythonStream;

typedef struct
{
  PyObject_HEAD
  
  PythonStream	*stream;
  PyObject	*fields;
} PSTStream;

extern PyTypeObject PSTStream_Type;

PythonStream  *pst_stream_new_cb              (gpointer		data);
void          pst_stream_field_set_cb         (PythonStream	*stream,
					       STHandlerField	*field,
					       const GValue	*value,
					       gpointer		data);
void          pst_stream_field_get_cb         (PythonStream	*stream,
					       STHandlerField	*field,
					       GValue		*value,
					       gpointer		data);
void          pst_stream_free_cb              (PythonStream	*stream,
					       gpointer		data);
gboolean      pst_stream_cb                   (PythonStream	*stream,
					       PSTCallbackInfo *info,
					       GError		**err);
gboolean      pst_stream_tune_in_multiple_cb  (GSList		*streams,
					       PSTCallbackInfo	*info,
					       GError		**err);
void          pst_stream_stock_field_get_cb   (PythonStream	*stream,
					       STHandlerStockField stock_field,
					       GValue		*value,
					       PSTCallbackInfo	*info);
gboolean      pst_stream_modify_cb            (PythonStream	*stream,
					       GSList		*fields,
					       GSList		*values,
					       PSTCallbackInfo	*info,
					       GError		**err);

gboolean      pst_stream_register             (PyObject		*module);
PythonStream  *pst_stream_copy                (PythonStream	*stream);

#endif /* _PST_STREAM_H */
