/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (XIMServerP_h)
#define	XIMServerP_h

#include "XIMServer.h"
#include "XIMClient.h"
#include "varbuffer.h"
#include <X11/CoreP.h>

typedef struct {
	XtPointer			m_pLispMachine ;
	XtCallbackList		m_lstCbkDestroy ;
	String				m_strLocales ;
	String				m_strConvStartKeys ;

	Atom				m_atServer ;
	Atom				m_atCompoundText ;
	Atom				m_atLocales ;
	Atom				m_atTransport ;
	Atom				m_atXConnect ;
	Atom				m_atProtocol ;
	Atom				m_atMoreData ;
	Atom				m_atSkkComm ;

	struct XrLikeKey*	m_lstHotKeyTrigger ;
	int					m_nHotKeyTrigger ;

	TVarbuffer			m_vbufClient ;

	XtCallbackList		m_setupInputWindowCallback ;
	XtCallbackList		m_serverCloseCallback ;
}	XIMServerPart ;

typedef struct tagXIMServerRec {
	CorePart			core ;
	XIMServerPart		ximServer ;
}	XIMServerRec ;

typedef struct {
	int					dummy ;
}	XIMServerClassPart ;

typedef struct tagXIMServerClassRec {
	CoreClassPart		core_class ;
	XIMServerClassPart	ximServer_class ;
}	XIMServerClassRec ;

extern	XIMServerClassRec	ximServerClassRec ;

#endif

