#include "scav.h"

#include <SDL.h>
#include <stdlib.h>

SDL_Surface *thescreen;
int usedcolors=0;

unsigned char *videomem;
int stride;
unsigned char *block64,*storageblock,*figureblock;
unsigned char mustlock=0,locked=0;

unsigned char blackcolor,whitecolor;

#define KEYMAX 128
int pressedcodes[KEYMAX],downcodes[KEYMAX],numpressed=0,numdown=0;
int mousex,mousey,mouseb,mousebd;

unsigned char mymap[768],currentmap[768];

drawstring(){}
colormapon(){}
colormapoff(){}

void opengfx(int argc, char **argv)
{
unsigned long videoflags;
unsigned char *p;
int i;

	dumpgfx();

	block64=malloc(65536);
	storageblock=malloc(BLOCKX*BLOCKY*128);
	figureblock=malloc(BLOCKX*BLOCKY*12*32);
	if(!block64 || !storageblock || !figureblock)
	{
		printf("No memory\n");
		exit(50);
	}

	if ( SDL_Init(SDL_INIT_VIDEO|SDL_INIT_TIMER|SDL_INIT_AUDIO) < 0 )
	{
		fprintf(stderr, "Couldn't initialize SDL: %s\n",SDL_GetError());
		exit(1);
	}
	videoflags = SDL_SWSURFACE|SDL_HWPALETTE | SDL_FULLSCREEN;

	thescreen = SDL_SetVideoMode(IXSIZE, IYSIZE, 8, videoflags);
	if ( thescreen == NULL )
	{
		fprintf(stderr, "Couldn't set display mode: %s\n",
							SDL_GetError());
		SDL_Quit();
		exit(5);
	}
	stride=thescreen->pitch;
	videomem=thescreen->pixels;
	mustlock=SDL_MUSTLOCK(thescreen);
	locked=0;
	SDL_ShowCursor(0);
}


void closegfx()
{
	SDL_Quit();
}

#define ENDMARK 0xaabacada

int sdlinoutnormal[]={
SDLK_0,'0',
SDLK_1,'1',
SDLK_2,'2',
SDLK_3,'3',
SDLK_4,'4',
SDLK_5,'5',
SDLK_6,'6',
SDLK_7,'7',
SDLK_8,'8',
SDLK_9,'9',
SDLK_a,'a',
SDLK_b,'b',
SDLK_c,'c',
SDLK_d,'d',
SDLK_e,'e',
SDLK_f,'f',
SDLK_g,'g',
SDLK_h,'h',
SDLK_i,'i',
SDLK_j,'j',
SDLK_k,'k',
SDLK_l,'l',
SDLK_m,'m',
SDLK_n,'n',
SDLK_o,'o',
SDLK_p,'p',
SDLK_q,'q',
SDLK_r,'r',
SDLK_s,'s',
SDLK_t,'t',
SDLK_u,'u',
SDLK_v,'v',
SDLK_w,'w',
SDLK_x,'x',
SDLK_y,'y',
SDLK_z,'z',
SDLK_MINUS,'-',
SDLK_EQUALS,'=',
SDLK_LEFTBRACKET,'[',
SDLK_RIGHTBRACKET,']',
SDLK_SEMICOLON,';',
SDLK_QUOTE,'\'',
SDLK_SLASH,'/',
SDLK_PERIOD,'.',
SDLK_COMMA,',',
SDLK_BACKQUOTE,'`',
SDLK_BACKSPACE,8,
SDLK_TAB,9,
SDLK_DELETE,MYDELETE,
SDLK_RETURN,13,
SDLK_F1,MYF1,
SDLK_F2,MYF2,
SDLK_F3,MYF3,
SDLK_F4,MYF4,
SDLK_F5,MYF5,
SDLK_F6,MYF6,
SDLK_F7,MYF7,
SDLK_F8,MYF8,
SDLK_F9,MYF9,
SDLK_F10,MYF10,
SDLK_ESCAPE,0x1b,
SDLK_LEFT,MYLEFT,
SDLK_RIGHT,MYRIGHT,
SDLK_UP,MYUP,
SDLK_DOWN,MYDOWN,
SDLK_PAGEUP,MYPAGEUP,
SDLK_PAGEDOWN,MYPAGEDOWN,
SDLK_SPACE,' ',
SDLK_HOME,MYHOME,
SDLK_END,MYEND,
SDLK_LALT,MYALTL,
SDLK_RALT,MYALTR,
SDLK_LSHIFT,MYSHIFTL,
SDLK_RSHIFT,MYSHIFTR,
SDLK_LCTRL,MYCONTROLL,
SDLK_RCTRL,MYCONTROLR,
SDLK_KP0,'0',
SDLK_KP1,'1',
SDLK_KP2,'2',
SDLK_KP3,'3',
SDLK_KP4,'4',
SDLK_KP5,'5',
SDLK_KP6,'6',
SDLK_KP7,'7',
SDLK_KP8,'8',
SDLK_KP9,'9',

ENDMARK
};
int sdlinoutshifted[]={
SDLK_0,')',
SDLK_1,'!',
SDLK_2,'@',
SDLK_3,'#',
SDLK_4,'$',
SDLK_5,'%',
SDLK_6,'^',
SDLK_7,'&',
SDLK_8,'*',
SDLK_9,'(',
SDLK_a,'A',
SDLK_b,'B',
SDLK_c,'C',
SDLK_d,'D',
SDLK_e,'E',
SDLK_f,'F',
SDLK_g,'G',
SDLK_h,'H',
SDLK_i,'I',
SDLK_j,'J',
SDLK_k,'K',
SDLK_l,'L',
SDLK_m,'M',
SDLK_n,'N',
SDLK_o,'O',
SDLK_p,'P',
SDLK_q,'Q',
SDLK_r,'R',
SDLK_s,'S',
SDLK_t,'T',
SDLK_u,'U',
SDLK_v,'V',
SDLK_w,'W',
SDLK_x,'X',
SDLK_y,'Y',
SDLK_z,'Z',
SDLK_MINUS,'_',
SDLK_EQUALS,'+',
SDLK_LEFTBRACKET,'{',
SDLK_RIGHTBRACKET,'}',
SDLK_SEMICOLON,':',
SDLK_QUOTE,'"',
SDLK_SLASH,'?',
SDLK_PERIOD,'>',
SDLK_COMMA,'<',
SDLK_BACKQUOTE,'~',
SDLK_BACKSPACE,8,
SDLK_TAB,9,
SDLK_DELETE,MYDELETE,
SDLK_RETURN,13,
SDLK_F1,MYF1+MYSHIFTED,
SDLK_F2,MYF2+MYSHIFTED,
SDLK_F3,MYF3+MYSHIFTED,
SDLK_F4,MYF4+MYSHIFTED,
SDLK_F5,MYF5+MYSHIFTED,
SDLK_F6,MYF6+MYSHIFTED,
SDLK_F7,MYF7+MYSHIFTED,
SDLK_F8,MYF8+MYSHIFTED,
SDLK_F9,MYF9+MYSHIFTED,
SDLK_F10,MYF10+MYSHIFTED,
SDLK_ESCAPE,0x1b,
SDLK_LEFT,MYLEFT+MYSHIFTED,
SDLK_RIGHT,MYRIGHT+MYSHIFTED,
SDLK_UP,MYUP+MYSHIFTED,
SDLK_DOWN,MYDOWN+MYSHIFTED,
SDLK_PAGEUP,MYPAGEUP,
SDLK_PAGEDOWN,MYPAGEDOWN,
SDLK_SPACE,' ',
SDLK_HOME,MYHOME,
SDLK_END,MYEND,
SDLK_LALT,MYALTL,
SDLK_RALT,MYALTR,
SDLK_LSHIFT,MYSHIFTL,
SDLK_RSHIFT,MYSHIFTR,
SDLK_LCTRL,MYCONTROLL,
SDLK_RCTRL,MYCONTROLR,
SDLK_KP0,'0',
SDLK_KP1,'1',
SDLK_KP2,'2',
SDLK_KP3,'3',
SDLK_KP4,'4',
SDLK_KP5,'5',
SDLK_KP6,'6',
SDLK_KP7,'7',
SDLK_KP8,'8',
SDLK_KP9,'9',
ENDMARK
};
int looklist(int code,int *list)
{
	while(*list!=ENDMARK)
	{
		if(*list==code)
			return list[1];
		list+=2;
	}
	return -1;
}
int mapkey(int code,int qual)
{

	if(qual & KMOD_SHIFT)
		code=looklist(code,sdlinoutshifted);
	else
		code=looklist(code,sdlinoutnormal);
	if(code<0) return -1;

	if(qual & KMOD_ALT)
		code|=MYALTED;

	return code;
}
void markkey(int code,int status)
{
int i,j;
int *ip;

	if(status)
	{
		if(numdown<KEYMAX)
			downcodes[numdown++]=code;
		ip=pressedcodes;
		i=numpressed;
		while(i)
			if(*ip++==code) break;
			else i--;
		if(!i && numpressed<KEYMAX)
			pressedcodes[numpressed++]=code;
	} else
	{
		i=numpressed;
		ip=pressedcodes;
		while(i)
			if(*ip++==code)
			{
				*--ip=pressedcodes[--numpressed];
				break;
			} else i--;
	}

}

pollinput()
{
	SDL_PollEvent(0);
}


void scaninput(void)
{
SDL_Event event;
int key,mod;
int bs=0;

	numdown=0;
	mousebd=0;
	while(SDL_PollEvent(&event))
	{
		switch(event.type)
		{
		case SDL_KEYDOWN:
			key=event.key.keysym.sym;
			mod=event.key.keysym.mod;
			markkey(mapkey(key,mod),1);
			break;
		case SDL_KEYUP:
			key=event.key.keysym.sym;
			mod=event.key.keysym.mod;
			markkey(mapkey(key,mod),0);
			break;
		case SDL_MOUSEBUTTONUP:
			bs=~(1<<event.button.button-1);
			mousex=event.button.x;
			mousey=event.button.y;
			mouseb&=bs;
			break;
		case SDL_MOUSEBUTTONDOWN:
			bs=1<<event.button.button-1;
			mousex=event.button.x;
			mousey=event.button.y;
			mouseb|=bs;
			mousebd|=bs;
			break;
		case SDL_MOUSEMOTION:
			mousex=event.motion.x;
			mousey=event.motion.y;
			break;
		}
	}
}
void createinout(int num)
{
gfxset *gs;
uchar *p;
int i,j,counts[256];
uchar red,green,blue;
int cnt;

	gs=gfxsets+num;
	p=gs->gs_pic;
	for(i=0;i<256;i++) counts[i]=0;
	i=64000;
	while(i--)
		counts[*p++]++;
	cnt=0;
	gs->gs_inout[0]=0;
	for(i=1;i<256;i++)
	{
		if(counts[i])
		{
			cnt++;
			p=gs->gs_colormap+i+i+i;
			red=*p++;
			green=*p++;
			blue=*p++;
			p=mymap+3;
			for(j=1;j<usedcolors;j++,p+=3)
			{
				if(red==*p && green==p[1] && blue==p[2])
				{
					gs->gs_inout[i]=j;
					break;
				}
			}
			if(j==usedcolors)
			{
				*p++=red;
				*p++=green;
				*p++=blue;
				gs->gs_inout[i]=usedcolors;
				if(usedcolors<255)
					usedcolors++;
			}
		}
	}
}
int checkpressed(int code)
{
int *p,i;
	i=numpressed;
	p=pressedcodes;
	while(i--)
		if(*p++==code) return 1;
	return 0;
}
int checkdown(int code)
{
int *p,i;
	i=numdown;
	p=downcodes;
	while(i--)
		if(*p++==code) return 1;
	return 0;
}
anydown()
{
	return numdown;
}
firstdown()
{
	return *downcodes;
}

gfxlock()
{
	if(locked || !mustlock) return;
	if ( SDL_LockSurface(thescreen) < 0 )
	{
		fprintf(stderr, "Couldn't lock display surface: %s\n",
							SDL_GetError());
	}
	locked=1;
}
gfxunlock()
{
	if(!locked || !mustlock) return;
	SDL_UnlockSurface(thescreen);
	locked=0;
}
void copyup()
{
	gfxunlock();
	SDL_UpdateRect(thescreen, 0, 0, 0, 0);
}
void clear()
{
int i;
unsigned char *p;

	gfxlock();
	p=videomem;
	for(i=0;i<IYSIZE;++i)
	{
		memset(p,0,IXSIZE);
		p+=stride;
	}
}
int bestmatch(unsigned char *map,int r,int g,int b)
{
int best=-1;
int bestdist;
int i,j,k;

	for(i=0;i<256;++i)
	{
		k=r-*map++;
		j=k*k;
		k=g-*map++;
		j+=k*k;
		k=b-*map++;
		j+=k*k;
		if(best==-1 || j<bestdist)
		{
			best=i;
			bestdist=j;
		}
	}
	return best;
}

void loadmap(unsigned char *map)
{
int i;
SDL_Color tempmap[256];
unsigned char *p;

	p=map;
	for(i=0;i<256;++i)
	{
		tempmap[i].r=*p++;
		tempmap[i].g=*p++;
		tempmap[i].b=*p++;
	}
	memcpy(currentmap,map,768);
	SDL_SetColors(thescreen,tempmap,0,256);
	blackcolor=bestmatch(map,0,0,0);
	whitecolor=bestmatch(map,255,255,255);
}
getcolors()
{
	loadmap(mymap);
}
copyupxysize(int x,int y,int xsize,int ysize)
{
	gfxunlock();
	SDL_UpdateRect(thescreen,x,y,xsize,ysize);
}
copyupxy(int x,int y)
{
	gfxunlock();
	SDL_UpdateRect(thescreen,x,y,BLOCKX,BLOCKY);
}

puttile(int destx,int desty,int source)
{
int i,j;
unsigned char *p,*p2;
	gfxlock();
	p=videomem+desty*stride+destx;
	p2=figureblock+source*BLOCKX*BLOCKY;
	for(i=0;i<BLOCKY;++i)
	{
		for(j=0;j<BLOCKX;++j)
		{
			if(*p2) *p=*p2;
			++p2;
			++p;
		}
		p+=stride-BLOCKX;
	}
}
drawsquare(int destx,int desty,unsigned char *source)
{
int i,j;
unsigned char *p;
	gfxlock();
	p=videomem+desty*stride+destx;
	for(i=0;i<BLOCKY;++i)
	{
		memcpy(p,source,BLOCKX);
		source+=BLOCKX;
		p+=stride;
	}
}

store(int x,int y,int which)
{
int i;
unsigned char *p,*p2;

	gfxlock();
	p=videomem+y*stride+x;
	p2=storageblock+BLOCKX*BLOCKY*which;
	for(i=0;i<BLOCKX;++i)
	{
		memcpy(p2,p,BLOCKX);
		p+=stride;
		p2+=BLOCKX;
	}
}
restore(int x,int y,int which)
{
int i;
unsigned char *p,*p2;

	gfxlock();
	p=videomem+y*stride+x;
	p2=storageblock+BLOCKX*BLOCKY*which;
	for(i=0;i<BLOCKX;++i)
	{
		memcpy(p,p2,BLOCKX);
		p+=stride;
		p2+=BLOCKX;
	}
}
void gfxfetch(int num,int source, int dest)
{
unsigned char *p,*p2,pixel;
gfxset *gs;
int dx,dy;
uchar ch;
uchar *map1;

	gs=gfxsets+num;
	map1=gs->gs_inout;
	p=gs->gs_pic+BLOCKX*(source%12)+320*BLOCKY*(source/12);
	p2=figureblock+dest*BLOCKX*BLOCKY;
	for(dy=0;dy<BLOCKY;dy++)
	{
		for(dx=0;dx<BLOCKX;dx++)
		{
			pixel=*p++;
			if(pixel) pixel=map1[pixel];
			*p2++=pixel;
		}
		p+=320-BLOCKX;
	}
}
void getfigures()
{
int i;
	for(i=0;i<12*32;i++)
		gfxfetch(i/96,i%96,i);
}
unsigned char fmap[128];
void fontinit()
{
uchar *p="ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.:!?#/\\*-,>< =";
int i;
	for(i=0;i<128;i++) fmap[i]=53;
	i=0;
	while(*p)
	{
		fmap[tolower(*p)]=fmap[*p++]=i++;
	}
}
void writechar(int x,int y,uchar ch)
{
int sx,sy,ch2;
int i,j,u,v,n;
unsigned char *p,*p2;

	gfxlock();
	ch2=fmap[ch];
	v=ch2/9;
	u=ch2%9;
	n=5*12+9+12*(v>>1)+u/3;
	p2=figureblock+n*BLOCKX*BLOCKY;
	if(v&1) p2+=BLOCKX*BLOCKY>>1;
	p2+=u%3 << 3;
	p=videomem+y*stride+x;
	for(j=0;j<BLOCKY>>1;++j)
	{
		memcpy(p,p2,BLOCKX/3);
		p+=stride;
		p2+=BLOCKX;
	}
}

void drawfillrect(int x,int y,int size,int color)
{
unsigned char *p;
int j;

	gfxlock();
	p=videomem+y*stride+x;
	for(j=0;j<size;++j)
	{
		memset(p,color,size);
		p+=stride;
	}
}
void drawbox(int x,int y,int size,int color)
{
unsigned char *p;
int j;

	gfxlock();
	if(color==ACOLOR)
		color=blackcolor;
	else if(color==BCOLOR)
		color=whitecolor;
	p=videomem+y*stride+x;
	memset(p,color,size+1);
	p+=stride;
	for(j=0;j<size-1;++j)
	{
		*p=color;
		p[size]=color;
		p+=stride;
	}
	memset(p,color,size+1);
}
void drawbox2(int x,int y,int sizex,int sizey,int color)
{
unsigned char *p;
int j;

	gfxlock();
	if(color==ACOLOR)
		color=blackcolor;
	else if(color==BCOLOR)
		color=whitecolor;
	p=videomem+y*stride+x;
	memset(p,color,sizex+1);
	p+=stride;
	for(j=0;j<sizey-1;++j)
	{
		*p=color;
		p[sizex]=color;
		p+=stride;
	}
	memset(p,color,sizex+1);
}
getmousex()
{
	return mousex;
}
getmousey()
{
	return mousey;
}
bigpixel(int x,int y,int color)
{
	drawfillrect(x,y,8,color);
}
invert(int x,int y)
{
unsigned char *p;
int i,j;

	gfxlock();
	p=videomem+y*stride+x;
	for(j=0;j<11;++j)
	{
		for(i=0;i<11;++i)
		{
			*p++^=0xff;
		}
		p+=stride-11;
	}
}
checkbutton(int button)
{
	return mouseb & (1<<button-1);
}
checkbuttondown(int button)
{
	return mousebd & (1<<button-1);
}
dumpgfx()
{
	mymap[0]=0;
	mymap[1]=0;
	mymap[2]=0;
	usedcolors=1;
}
void csline(uchar *put, int line)
{
	memcpy(put,videomem+line*stride,IXSIZE);
}
