/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.util.Stack;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.IntStack;
import org.apache.xml.utils.QName;
import org.apache.xpath.Arg;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;

public class VariableStack
extends Stack {
    private IntStack m_elemFramePos = new IntStack();
    private static final Stack m_emptyStackFrame = new Stack();
    private int m_globalStackFrameIndex = -1;
    private int m_searchStart = -1;

    public VariableStack() {
        this.pushContextMarker();
    }

    private Stack allocateCurrentFrame() {
        int n = this.m_searchStart == -1 ? this.size() - 1 : this.m_searchStart;
        Stack stack = new Stack();
        this.setElementAt(stack, n);
        return stack;
    }

    public int getContextPos() {
        return this.size() - 1;
    }

    private Stack getCurrentFrame() {
        int n = this.m_searchStart == -1 ? this.size() - 1 : this.m_searchStart;
        return (Stack)this.elementAt(n);
    }

    public Arg getDeclaredVariable(QName qName) throws TransformerException {
        Object object;
        Stack stack = this.getCurrentFrame();
        int n = stack.size() - 1;
        while (n >= 0) {
            object = stack.elementAt(n);
            if (((Arg)object).getQName().equals(qName)) {
                return (Arg)object;
            }
            --n;
        }
        object = (Stack)this.elementAt(0);
        if (object == stack) {
            return null;
        }
        int n2 = ((Vector)object).size() - 1;
        while (n2 >= 0) {
            Object e = ((Vector)object).elementAt(n2);
            if (((Arg)e).getQName().equals(qName)) {
                return (Arg)e;
            }
            --n2;
        }
        return null;
    }

    public Arg getParamArg(QName qName) throws TransformerException {
        Object var2_2 = null;
        Stack stack = this.getCurrentFrame();
        int n = stack.size() - 1;
        while (n >= 0) {
            Arg arg = (Arg)stack.elementAt(n);
            if (arg.getQName().equals(qName) && arg.isFromWithParam()) {
                return arg;
            }
            --n;
        }
        return null;
    }

    public int getSearchStart() {
        return this.m_searchStart;
    }

    public int getSearchStartOrTop() {
        return this.m_searchStart == -1 ? this.size() - 1 : this.m_searchStart;
    }

    public XObject getVariable(XPathContext xPathContext, QName qName) throws TransformerException {
        Arg arg;
        int n;
        Stack stack;
        Stack stack2 = this.getCurrentFrame();
        if (stack2 != (stack = (Stack)this.elementAt(0))) {
            n = stack2.size() - 1;
            while (n >= 0) {
                arg = (Arg)stack2.elementAt(n);
                if (arg.getQName().equals(qName) && arg.isVisible()) {
                    XObject xObject = arg.getVal();
                    if (xObject.getType() == 600) {
                        xObject = xObject.execute(xPathContext);
                        arg.setVal(xObject);
                    }
                    return xObject;
                }
                --n;
            }
        }
        n = stack.size() - 1;
        while (n >= 0) {
            arg = (Arg)stack.elementAt(n);
            if (arg.getQName().equals(qName) && arg.isVisible()) {
                XObject xObject = arg.getVal();
                if (xObject.getType() == 600) {
                    xObject = xObject.execute(xPathContext);
                    arg.setVal(xObject);
                }
                return xObject;
            }
            --n;
        }
        return null;
    }

    public void markGlobalStackFrame() {
        this.m_globalStackFrameIndex = this.size();
    }

    public void popContextPosition() {
    }

    public void popCurrentContext() {
        this.pop();
    }

    public void popElemFrame() {
        Stack stack = this.getCurrentFrame();
        int n = this.m_elemFramePos.pop();
        stack.setSize(n);
    }

    public void pushContextMarker() {
        this.push(m_emptyStackFrame);
    }

    public void pushContextPosition(int n) {
    }

    public void pushElemFrame() {
        Stack stack = this.getCurrentFrame();
        this.m_elemFramePos.push(stack.size());
    }

    public void pushOrReplaceParameter(QName qName, XObject xObject) {
        Stack stack = this.getCurrentFrame();
        if (stack == m_emptyStackFrame) {
            stack = this.allocateCurrentFrame();
        }
        int n = stack.size() - 1;
        while (n >= 0) {
            Arg arg = (Arg)stack.elementAt(n);
            if (arg.getQName().equals(qName) && arg.isFromWithParam()) {
                stack.setElementAt(new Arg(qName, xObject, true), n);
                return;
            }
            --n;
        }
        stack.push(new Arg(qName, xObject, true));
    }

    public void pushVariable(QName qName, XObject xObject) {
        Stack stack = this.getCurrentFrame();
        if (stack == m_emptyStackFrame) {
            stack = this.allocateCurrentFrame();
        }
        stack.push(new Arg(qName, xObject, false));
    }

    public void pushVariableArg(Arg arg) {
        Stack stack = this.getCurrentFrame();
        if (stack == m_emptyStackFrame) {
            stack = this.allocateCurrentFrame();
        }
        stack.push(arg);
    }

    public void remarkParams() {
        Stack stack = this.getCurrentFrame();
        int n = stack.size() - 1;
        while (n >= 0) {
            Arg arg = (Arg)stack.elementAt(n);
            if (arg != null) {
                arg.setIsVisible(false);
            }
            --n;
        }
    }

    public void setSearchStart(int n) {
        this.m_searchStart = n;
    }
}

