/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.xalan.lib.sql.Column;
import org.apache.xalan.lib.sql.RowSet;
import org.apache.xalan.lib.sql.StreamableNode;
import org.apache.xalan.lib.sql.XStatement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Row
extends StreamableNode {
    int m_childCount;
    Column[] m_columns;
    ResultSetMetaData m_metadata;
    Row m_nextNode = null;
    Row m_prevNode = null;
    private static final boolean DEBUG = false;
    RowSet m_parent;

    public Row(XStatement xStatement, RowSet rowSet, Row row) {
        super(xStatement);
        this.m_parent = rowSet;
        this.m_prevNode = row;
        this.populateColumnData();
    }

    public Node getFirstChild() {
        if (this.hasChildNodes()) {
            return this.m_columns[0];
        }
        return null;
    }

    public Node getNextSibling() throws DOMException {
        try {
            XStatement xStatement = this.getXStatement();
            ResultSet resultSet = xStatement.getResultSet();
            if (!xStatement.getShouldCacheNodes()) {
                if (resultSet.next()) {
                    this.incermentOrderIndex();
                    this.populateColumnData();
                    return this;
                }
                return null;
            }
            if (this.m_nextNode == null && resultSet.next()) {
                this.m_nextNode = new Row(this.getXStatement(), this.m_parent, this);
            }
            return this.m_nextNode;
        }
        catch (SQLException sQLException) {
            throw new DOMException(12, sQLException.getLocalizedMessage());
        }
    }

    public String getNodeName() {
        return "row";
    }

    public Document getOwnerDocument() {
        return this.getXStatement();
    }

    public Node getParentNode() {
        return this.m_parent;
    }

    public Node getPreviousSibling() {
        return this.m_prevNode;
    }

    public boolean hasChildNodes() {
        return this.m_childCount > 0;
    }

    private void populateColumnData() {
        try {
            ResultSetMetaData resultSetMetaData;
            XStatement xStatement = this.getXStatement();
            ResultSet resultSet = xStatement.getResultSet();
            this.m_metadata = resultSetMetaData = resultSet.getMetaData();
            this.m_childCount = resultSetMetaData.getColumnCount();
            this.m_columns = new Column[this.m_childCount];
            int n = 0;
            while (n < this.m_childCount) {
                this.m_columns[n] = new Column(xStatement, this, n, resultSetMetaData, resultSet);
                ++n;
            }
        }
        catch (SQLException sQLException) {}
    }
}

