#include "config.h"
#include <errno.h>
#include <time.h>
#include <stdlib.h>
#include <fcntl.h>
#include <libgen.h>
#include <stdio.h>
//#define _GNU_SOURCE 1
//#define __USE_GNU 1
#include <string.h>
#include <unistd.h>
#include <math.h>
#include <oniguruma.h>
#include <sys/stat.h>
#include <signal.h>
#include <limits.h>
#include <dirent.h>

#if defined(HAVE_CURSES_H)
#include <curses.h>
#elif defined(HAVE_NCURSES_H)
#include <ncurses.h>
#elif defined(HAVE_NCURSES_NCURSES_H)
#include <ncurses/ncurses.h>
#endif

#include "saphire/saphire.h"
#include "saphire/saphire_inner.h"

static regex_t* get_reg(int* r, char* regex2, BOOL ignore_case, BOOL multiline, enum eKanjiCode code)
{
    regex_t* reg;
    hash_obj* reg_hash;
    OnigOptionType type;
    OnigEncoding enc;
    if(code == kByte) {
        enc = ONIG_ENCODING_ASCII;

        if(ignore_case && multiline) {
            reg_hash = gRegexsIM;
            reg = hash_item(gRegexsIM, (char*)regex2);
            type = ONIG_OPTION_DEFAULT | ONIG_OPTION_IGNORECASE | ONIG_OPTION_MULTILINE;
        }
        else if(ignore_case) {
            reg_hash = gRegexsI;
            reg = hash_item(gRegexsI, (char*)regex2);
            type = ONIG_OPTION_DEFAULT | ONIG_OPTION_IGNORECASE;
        }
        else if(multiline) {
            reg_hash = gRegexsM;
            reg = hash_item(gRegexsM, (char*)regex2);
            type = ONIG_OPTION_DEFAULT | ONIG_OPTION_MULTILINE;
        }
        else {
            reg_hash = gRegexs;
            reg = hash_item(gRegexs, (char*)regex2);
            type = ONIG_OPTION_DEFAULT;
        }
    }
    else if(code == kUtf8) {
        enc = ONIG_ENCODING_UTF8;

        if(ignore_case && multiline) {
            reg_hash = gRegexsIMUtf8;
            reg = hash_item(gRegexsIMUtf8, (char*)regex2);
            type = ONIG_OPTION_DEFAULT | ONIG_OPTION_IGNORECASE | ONIG_OPTION_MULTILINE;
        }
        else if(ignore_case) {
            reg_hash = gRegexsIUtf8;
            reg = hash_item(gRegexsIUtf8, (char*)regex2);
            type = ONIG_OPTION_DEFAULT | ONIG_OPTION_IGNORECASE;
        }
        else if(multiline) {
            reg_hash = gRegexsMUtf8;
            reg = hash_item(gRegexsMUtf8, (char*)regex2);
            type = ONIG_OPTION_DEFAULT | ONIG_OPTION_MULTILINE;
        }
        else {
            reg_hash = gRegexsUtf8;
            reg = hash_item(gRegexsUtf8, (char*)regex2);
            type = ONIG_OPTION_DEFAULT;
        }
    }
    else if(code == kEucjp) {
        enc = ONIG_ENCODING_EUC_JP;

        if(ignore_case && multiline) {
            reg_hash = gRegexsIMEucjp;
            reg = hash_item(gRegexsIMEucjp, (char*)regex2);
            type = ONIG_OPTION_DEFAULT | ONIG_OPTION_IGNORECASE | ONIG_OPTION_MULTILINE;
        }
        else if(ignore_case) {
            reg_hash = gRegexsIEucjp;
            reg = hash_item(gRegexsIEucjp, (char*)regex2);
            type = ONIG_OPTION_DEFAULT | ONIG_OPTION_IGNORECASE;
        }
        else if(multiline) {
            reg_hash = gRegexsMEucjp;
            reg = hash_item(gRegexsMEucjp, (char*)regex2);
            type = ONIG_OPTION_DEFAULT | ONIG_OPTION_MULTILINE;
        }
        else {
            reg_hash = gRegexsEucjp;
            reg = hash_item(gRegexsEucjp, (char*)regex2);
            type = ONIG_OPTION_DEFAULT;
        }
    }
    else {
        enc = ONIG_ENCODING_SJIS;

        if(ignore_case && multiline) {
            reg_hash = gRegexsIMSjis;
            reg = hash_item(gRegexsIMSjis, (char*)regex2);
            type = ONIG_OPTION_DEFAULT | ONIG_OPTION_IGNORECASE | ONIG_OPTION_MULTILINE;
        }
        else if(ignore_case) {
            reg_hash = gRegexsISjis;
            reg = hash_item(gRegexsISjis, (char*)regex2);
            type = ONIG_OPTION_DEFAULT | ONIG_OPTION_IGNORECASE;
        }
        else if(multiline) {
            reg_hash = gRegexsMSjis;
            reg = hash_item(gRegexsMSjis, (char*)regex2);
            type = ONIG_OPTION_DEFAULT | ONIG_OPTION_MULTILINE;
        }
        else {
            reg_hash = gRegexsSjis;
            reg = hash_item(gRegexsSjis, (char*)regex2);
            type = ONIG_OPTION_DEFAULT;
        }
    }

    if(reg == NULL) {
        OnigErrorInfo err_info;
        *r = onig_new(&reg, regex2
                , regex2 + strlen((char*)regex2)
                , type
                , enc
                , ONIG_SYNTAX_DEFAULT
                , &err_info);

        if(*r == ONIG_NORMAL) {
            if(hash_count(reg_hash) == 30) {
                hash_it* it = hash_loop_begin(reg_hash);
                while(it != NULL) {
                    onig_free(hash_loop_item(it));
                    it = hash_loop_next(it);
                }
                hash_clear(reg_hash);
            }
            hash_put(reg_hash, (char*)regex2, reg);
        }
        else {
            onig_free(reg);
        }
    }
    else {
        *r = ONIG_NORMAL;
    }

    return reg;
}

static char* strcasestr_back(char* p, char* start, char* word, char* sname, int sline)
{
    int n = strlen(word);

    while(p >= start) {
        BOOL flg = TRUE;
        int i;
        for(i=-1; i>=-n; i--) {
            if(isascii(p[i]) && isascii(word[n+i])) {
                if(tolower(p[i]) != tolower(word[n+i])) {
                    flg = FALSE;
                    break;
                }
            }
            else {
                if(p[i] != word[n+i]) {
                    flg = FALSE;
                    break;
                }
            }

            if(gKitutukiSigInt) {
                err_msg("interrupt", sname, sline);
                return NULL;
            }
        }

        if(flg) {
            return p -n;
        }
        else {
            p--;
        }
    }

    return NULL;
}

// p: 対象文字列文字列内のポインタ
// start:対象文字列の最初の位置 
// word: 検索文字列
static char* strstr_back(char* p, char* start, char* word, char* sname, int sline)
{
    int n = strlen(word);

    while(p >= start) {
        BOOL flg = TRUE;
        int i;
        for(i=-1; i>=-n; i--) {
            if(p[i] != word[n+i]) {
                flg = FALSE;
                break;
            }

            if(gKitutukiSigInt) {
                err_msg("interrupt", sname, sline);
                return NULL;
            }
        }

        if(flg) {
            return p -n;
        }
        else {
            p--;
        }
    }

    return NULL;
}


BOOL statment_tree_internal_commands_split_base(sWFd* nextout, string_obj* field, BOOL multiline, BOOL ignore_case, char* sname, int sline, enum eKanjiCode code, enum eLineField lf, BOOL input, vector_obj* argv, sRFd* nextin, int* rcode, string_obj* field2)
{
    string_obj* line;
    char* regex;

    if(input) {
        if(vector_size(argv) <= 2) {
            if(vector_size(argv) == 2) {
                regex = string_c_str(vector_item(argv, 1));
            }
            else {
                regex = "\\s+";
            }

            line = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin(nextin, line);
            if(ret < 0) {
                err_msg("interrupt b", sname, sline);
                string_delete(line);
                return FALSE;
            }
            else if(ret == 1) {
                string_delete(line);
                return TRUE;
            }
        }
    }
    else {
        if(vector_size(argv) >= 2) {
            if(vector_size(argv) == 2) {
                regex = "\\s+";
            }
            else {
                regex = string_c_str(vector_item(argv, 2));
            }

            line = STRING_NEW(string_c_str(vector_item(argv, 1)));
        }
    }

    string_chomp(line);
    char* p = string_c_str(line);
    
    char* regex2 = regex;
    int r;
    regex_t* reg = get_reg(&r, regex2, ignore_case, multiline, code);

    if(r == ONIG_NORMAL) {
        string_obj* new_line = STRING_NEW("");
        while(*p) {
            if(gKitutukiSigInt) {
                err_msg("singal interrupt", sname, sline);
                string_delete(line);
                string_delete(new_line);
                return FALSE;
            }
            char* target = p;
            OnigRegion* region = onig_region_new();

            int r2 = onig_search(reg, string_c_str(line)
               , string_c_str(line) + string_length(line)
               , target, string_c_str(line) + string_length(line)
               , region, ONIG_OPTION_NONE);
               
            if(region->num_regs == 1) {
                if(region->beg[0] == -1 && region->end[0] == -1) {
                    string_put(new_line, p);
                    p = p + strlen(p);

                    /// 出力 ///
                    if(!statment_tree_internal_commands_write_nextout(nextout,  string_c_str(new_line)))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(line);
                        string_delete(new_line);
                        onig_region_free(region, 1);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(line);
                        string_delete(new_line);
                        onig_region_free(region, 1);
                        return FALSE;
                    }
                }
                else if(region->beg[0] == region->end[0]) {
                    /// マッチした文字列の前 ///
                    int size = region->beg[0]-(target-string_c_str(line));
                    if(size > 0) {
                        char* tmp = MALLOC(size + 1);
                        memcpy(tmp, target, size);
                        tmp[size] = 0;

                        string_put(new_line, tmp);
                        FREE(tmp);
                        string_push_back(new_line, string_c_str(field));
                        string_push_back2(new_line, *(target + size));

                        p = string_c_str(line) + region->end[0] +1;
                    }
                    else {
                        char* end_byte = str_kanjipos2pointer(code, target, 1);
                        char* tmp = MALLOC(end_byte-target + 1);
                        memcpy(tmp, target, end_byte-target);
                        tmp[end_byte-target] = 0;

                        string_put(new_line, string_c_str(field));
                        string_push_back(new_line, tmp);

                        FREE(tmp);

                        /// マッチした文字列の後 ///
                        p = end_byte;
                    }

                    /// 出力 ///
                    if(!statment_tree_internal_commands_write_nextout(nextout,  string_c_str(new_line)))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(line);
                        string_delete(new_line);
                        onig_region_free(region, 1);
                        return FALSE;
                    }
                }
                else {
                    /// マッチした文字列の前 ///
                    int size = region->beg[0]-(target-string_c_str(line));
                    char* tmp = MALLOC(size + 1);
                    memcpy(tmp, target, size);
                    tmp[size] = 0;

                    string_put(new_line, tmp);

                    FREE(tmp);

                    /// マッチした文字列の後 ///
                    p = string_c_str(line) + region->end[0];

                    /// 出力 ///
                    string_push_back(new_line, string_c_str(field));
                    if(!statment_tree_internal_commands_write_nextout(nextout,  string_c_str(new_line)))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(line);
                        string_delete(new_line);
                        onig_region_free(region, 1);
                        return FALSE;
                    }
                }
            }
            else if(region->num_regs > 1) {
                if(region->beg[0] == -1 && region->end[0] == -1) {
                    string_put(new_line, p);
                    p = p + strlen(p);

                    /// 出力 ///
                    if(!statment_tree_internal_commands_write_nextout(nextout,  string_c_str(new_line)))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(line);
                        string_delete(new_line);
                        onig_region_free(region, 1);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(line);
                        string_delete(new_line);
                        onig_region_free(region, 1);
                        return FALSE;
                    }
                }
                else if(region->beg[0] == region->end[0]) {
                    /// マッチした文字列の前 ///
                    int size = region->beg[0]-(target-string_c_str(line));
                    if(size > 0) {
                        char* tmp = MALLOC(size + 1);
                        memcpy(tmp, target, size);
                        tmp[size] = 0;

                        string_put(new_line, tmp);
                        FREE(tmp);
                        string_push_back(new_line, string_c_str(field));
                        string_push_back2(new_line, *(target + size));

                        p = string_c_str(line) + region->end[0] +1;
                    }
                    else {
                        char* end_byte = str_kanjipos2pointer(code, target, 1);
                        char* tmp = MALLOC(end_byte-target + 1);
                        memcpy(tmp, target, end_byte-target);
                        tmp[end_byte-target] = 0;

                        string_put(new_line, string_c_str(field));
                        string_push_back(new_line, tmp);

                        FREE(tmp);

                        /// マッチした文字列の後 ///
                        p = end_byte;
                    }

                    /// 出力 ///
                    if(!statment_tree_internal_commands_write_nextout(nextout,  string_c_str(new_line)))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(line);
                        string_delete(new_line);
                        onig_region_free(region, 1);
                        return FALSE;
                    }
                }
                else {
                    /// マッチした文字列の前 ///
                    int size = region->beg[0]-(target-string_c_str(line));
                    char* tmp = MALLOC(size + 1);
                    memcpy(tmp, target, size);
                    tmp[size] = 0;

                    string_put(new_line, tmp);

                    FREE(tmp);

                    /// マッチした文字列の後 ///
                    p = string_c_str(line) + region->end[0];

                    /// 出力 ///
                    string_push_back(new_line, string_c_str(field));
                    if(!statment_tree_internal_commands_write_nextout(nextout,  string_c_str(new_line)))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(line);
                        string_delete(new_line);
                        onig_region_free(region, 1);
                        return FALSE;
                    }

                    /// グループ化文字列出力 ///
                    int i;
                    for(i=1; i<region->num_regs; i++) {
                        int n = region->end[i]-region->beg[i] + strlen(string_c_str(field)) + 1;
                        char* tmp = MALLOC(n);

                        memcpy(tmp, string_c_str(line) + region->beg[i], region->end[i]-region->beg[i]);
                        tmp[region->end[i]-region->beg[i]] = 0;
                        xstrncat(tmp, string_c_str(field), n);

                        if(!statment_tree_internal_commands_write_nextout(nextout,  tmp))
                        {
                            err_msg("singal interrupt", sname, sline);
                            string_delete(line);
                            string_delete(new_line);
                            FREE(tmp);
                            onig_region_free(region, 1);
                            return FALSE;
                        }

                        FREE(tmp);
                    }
                }
            }

            onig_region_free(region, 1);
        }

        string_delete(new_line);
    }
    else {
        err_msg("split: invalid regex", sname, sline);

        string_delete(line);
        return FALSE;
    }

    *rcode = 0;

    string_delete(line);

    return TRUE;
}

static BOOL statment_tree_internal_commands_sub_base(sRunInfo* runinfo, BOOL global, vector_obj* blocks, BOOL quiet, BOOL multiline, BOOL check, BOOL ignore_case, int* rcode, sWFd* nextout, char* sname, int sline, sRFd* nextin, int nexterr, enum eKanjiCode code, BOOL input, vector_obj* argv)
{
    string_obj* str;
    char* regex;
    char* destination;

    if(input) {
        if(vector_size(argv) == 3 || vector_size(argv) == 2 && vector_size(blocks) >= 1) 
        {
            str = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin(nextin, str);
            if(ret == 1) { // EOF
                string_delete(str);
                return TRUE;
            }
            else if(ret == -1) {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }

            regex = string_c_str(vector_item(argv, 1));
            if(vector_size(blocks) >= 1) {
                destination = NULL;
            }
            else {
                destination = string_c_str(vector_item(argv, 2));
            }
        }
        else {
            err_msg("invalid argument.", sname, sline);
            return FALSE;
        }
    }
    else if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) 
    {
        str = STRING_NEW(string_c_str(vector_item(argv, 1)));
        regex = string_c_str(vector_item(argv, 2));
        if(vector_size(blocks) >= 1) {
            destination = NULL;
        }
        else {
            destination = string_c_str(vector_item(argv, 3));
        }
    }
    else {
        err_msg("invalid argument.", sname, sline);
        return FALSE;
    }

    BOOL check_all = FALSE;
    BOOL check_all_no = FALSE;
    int hennkann_kaisuu = 0;

    int i;

    char* regex2 = regex;

    int r;
    regex_t* reg = get_reg(&r, regex2, ignore_case, multiline, code);

    char* str2 = string_c_str(str);
    if(r == ONIG_NORMAL) {
        int point = 0;
        int region_end_before = 0;
        string_obj* hennkan_mojiretu = STRING_NEW("");
        while(1) {
            if(gKitutukiSigInt) {
                err_msg("interrupt", sname, sline);
                gKitutukiSigInt = FALSE;
                string_delete(str);
                string_delete(hennkan_mojiretu);
                return FALSE;
            }

            OnigRegion* region = onig_region_new();
            OnigErrorInfo err_info;

            int r2 = onig_search(reg, str2
               , str2 + strlen(str2)
               , str2 + point
               , str2 + strlen(str2)
               , region, ONIG_OPTION_NONE);

            if(r2 == ONIG_MISMATCH) {
                //point++;
                onig_region_free(region, 1);
                break;
            }
            else {
                /// チェック ///
                BOOL quetion;

                if(check_all_no) {
                    quetion = FALSE;
                }
                else if(check_all) {
                    quetion = TRUE;
                }
                else if(check) 
                {
                    if(gRunningOnTerminal == FALSE) {
                        err_msg("selector: not running on terminal", sname, sline);
                        gKitutukiSigInt = FALSE;
                        onig_region_free(region, 1);
                        string_delete(hennkan_mojiretu);
                        string_delete(str);
                        return FALSE;
                    }
#if !defined(__FREEBSD__)
                    msave_screen();
#endif
                    msave_ttysettings();
                    minitscr();

                    mclear();

                    /// 変換場所から行前を表示 ///
                    int count = 0;
                    char* p = str2+region->beg[0];
                    while(p > str2) {
                        if(gKitutukiSigInt) {
                            err_msg("interrupt", sname, sline);
                            gKitutukiSigInt = FALSE;
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            mendwin();
#if !defined(__FREEBSD__)
                            mrestore_screen();
#endif
                            mrestore_ttysettings();
                            return FALSE;
                        }
                        if(is_line_field2(gLineField, p)) {
                            if(gLineField == kCRLF) {
                                count++;
                                if(count == 6) {
                                    p+=2;
                                    break;
                                }
                            }
                            else {
                                count++;
                                if(count == 6) {
                                    p++;
                                    break;
                                }
                            }

                            p--;
                        }
                        else {
                            p--;
                        }
                    }

                    char* tmp = MALLOC(str2+region->beg[0]-p+1);
                    memcpy(tmp, p, str2+region->beg[0]-p);
                    tmp[str2+region->beg[0]-p] = 0;

                    mprintw(tmp);
                    
                    FREE(tmp);

                    /// 変換文字列を表示 ///
                    tmp = MALLOC(region->end[0]-region->beg[0]+1);
                    memcpy(tmp, str2 + region->beg[0], region->end[0]-region->beg[0]);
                    tmp[region->end[0]-region->beg[0]] = 0;

                    mattron(kCAReverse);
                    mprintw(tmp);
                    mattroff();

                    FREE(tmp);

                    /// 変換場所から行後を表示 ///
                    count = 0;
                    p = str2+region->end[0];
                    while(p < str2+strlen(str2)) {
                        if(gKitutukiSigInt) {
                            err_msg("interrupt", sname, sline);
                            gKitutukiSigInt = FALSE;
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            mendwin();
#if !defined(__FREEBSD__)
                            mrestore_screen();
#endif
                            mrestore_ttysettings();
                            return FALSE;
                        }
                        if(is_line_field2(gLineField, p)) {
                            if(gLineField == kCRLF) {
                                count++;
                                if(count == 6) {
                                    p-=2;
                                    break;
                                }
                            }
                            else {
                                count++;
                                if(count == 6) {
                                    p--;
                                    break;
                                }
                            }

                            p++;
                        }
                        else {
                            p++;
                        }
                    }

                    tmp = MALLOC(p-str2-region->end[0]+1);
                    memcpy(tmp, str2+region->end[0], p-str2-region->end[0]);
                    tmp[p-str2-region->end[0]] = 0;

                    mprintw(tmp);

                    FREE(tmp);

                    mprintw("\n");
                    mprintw("sub ok? (y)es/(n)o/(a)ll yes/(A)ll no");
                    mrefresh();

                    int meta;
                    int key = mgetch(&meta);
                    
                    mendwin();
#if !defined(__FREEBSD__)
                    mrestore_screen();
#endif
                    mrestore_ttysettings();

                    if(key == 3) {
                        break;
                    }
                    quetion = key == 'y' || key == 'a';
                    check_all = key == 'a';
                    check_all_no = key == 'A';
                }
                else {
                    quetion = TRUE;
                }

                if(destination) {
                    /// グループ化したものを
                    ///  \\1 \\2などに変換 ///
                    
                    char* p = destination;
                    string_put(hennkan_mojiretu, "");

                    while(*p) {
                        if(gKitutukiSigInt) {
                            err_msg("interrupt", sname, sline);
                            gKitutukiSigInt = FALSE;
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            return FALSE;
                        }
                        if(*p == '\\' 
                            && *(p+1) == '\\')
                        {
                            p++;
                            string_push_back2(
                                hennkan_mojiretu
                                    , *p++);
                        }
                        else if(*p == '\\' 
                            && *(p+1) >= '1'
                            && *(p+1) <= '9')
                        {
                            char tmp[BUFSIZ];
                            int n = *(p+1) - '0';

                            if(n < region->num_regs) 
                            {
                                p+=2;
                                memcpy(tmp
                                    , str2 
                                    + region->beg[n]
                                    , region->end[n]
                                    -region->beg[n]);

                                tmp[region->end[n]
                                  - region->beg[n]] 
                                    = 0;

                                char* p3 = tmp;
                                while(*p3) {
                                    if(gKitutukiSigInt) {
                                        err_msg("interrupt", sname, sline);
                                        gKitutukiSigInt = FALSE;
                                        onig_region_free(region, 1);
                                        string_delete(hennkan_mojiretu);
                                        string_delete(str);
                                        return FALSE;
                                    }

                                   string_push_back2(hennkan_mojiretu, *p3++);
                                }
                            }
                            else {
                                string_push_back2(
                                    hennkan_mojiretu
                                    , *p++);
                                string_push_back2(
                                    hennkan_mojiretu
                                    , *p++);
                            }
                        }
                        else { 
                            string_push_back2(
                                hennkan_mojiretu
                                    , *p++);
                        }
                    }
                }
                else {
                    if(region->num_regs > 1) {
                        /// マッチしたグループ化文字列 ///
                        int i;
                        for (i=1; i<region->num_regs; i++) {
                            char* tmp = MALLOC(
                                region->end[i]-region->beg[i] + 1);

                            memcpy(tmp, str2 + region->beg[i]
                             , region->end[i]-region->beg[i]);

                            tmp[region->end[i]
                                - region->beg[i]] = 0;

                            char name[16];
                            snprintf(name, 16, "%d", i);

                            (void)saphire_set_local_var(name, tmp, NULL);

                            FREE(tmp);
                        }
                        
                        /// run
                        char* tmp = MALLOC(region->end[0]-region->beg[0]+1);

                        memcpy(tmp
                         , str2 + region->beg[0]
                         , region->end[0]-region->beg[0]);

                        tmp[region->end[0]
                            - region->beg[0]] = 0;

                        if(vector_size(blocks) == 0) {
                            err_msg("few blocks", sname, sline);
                            FREE(tmp);
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            return FALSE;
                        }

                        sBlock* block = vector_item(blocks, 0);
                        sStatments* statments = block->mStatments;

                        char* fname = MALLOC(strlen(sname) + 32);
                        snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);
                        sWFd* nextout2 = WFD_NEW(-1);
                        sRFd* nextin2 = RFD_NEW2(-1, tmp);

                        FREE(tmp);
                        *rcode = run(runinfo, statments, fname, nextout2 , nextin2, nexterr, FALSE);

                        FREE(fname);

                        if(!string_put_cancelable(hennkan_mojiretu, nextout2->mBuffer))
                        {
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            sWFd_delete(nextout2);
                            sRFd_delete(nextin2);
                            return FALSE;
                        }
                        sWFd_delete(nextout2);
                        sRFd_delete(nextin2);

                        if(runinfo->enable_break && *runinfo->break_) {
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            return TRUE;
                        }
                        else if(runinfo->enable_return && *runinfo->return_) {
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            return TRUE;
                        }
                        else if(*rcode < 0) {
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            return FALSE;
                        }
                    }
                    else {
                        char* tmp = MALLOC(region->end[0]-region->beg[0]+1);

                        memcpy(tmp
                         , str2 + region->beg[0]
                         , region->end[0]-region->beg[0]);

                        tmp[region->end[0]
                            - region->beg[0]] = 0;

                        if(vector_size(blocks) == 0) {
                            err_msg("few blocks", sname, sline);
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            FREE(tmp);
                            string_delete(str);
                            return FALSE;
                        }

                        sBlock* block = vector_item(blocks, 0);
                        sStatments* statments = block->mStatments;

                        char* fname = MALLOC(strlen(sname) + 32);
                        snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);
                        sWFd* nextout2 = WFD_NEW(-1);
                        sRFd* nextin2 = RFD_NEW2(-1, tmp);
                        FREE(tmp);
                        *rcode = run(runinfo, statments, fname, nextout2 , nextin2, nexterr, FALSE);

                        FREE(fname);

                        if(!string_put_cancelable(hennkan_mojiretu, nextout2->mBuffer))
                        {
                            sWFd_delete(nextout2);
                            sRFd_delete(nextin2);
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            return TRUE;
                        }

                        sWFd_delete(nextout2);
                        sRFd_delete(nextin2);

                        if(runinfo->enable_break && *runinfo->break_) {
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            return TRUE;
                        }
                        else if(runinfo->enable_return && *runinfo->return_) {
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            return TRUE;
                        }
                        else if(*rcode < 0) {
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            return FALSE;
                        }
                    }
                }

                /// 変換開始 ///
                if(quetion) {
                    /// マッチした文字列の前 ///
                    char* tmp = MALLOC(
                        region->beg[0] - point + 1);

                    memcpy(tmp, str2 + point
                        , region->beg[0] - point);
                    tmp[region->beg[0] - point] = 0;
                    if(!quiet) {
                        if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                        {
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            FREE(tmp);
                            string_delete(str);
                            return FALSE;
                        }
                    }

                    FREE(tmp);

                    /// 変換文字列を入れる ///
                    if(!quiet) {
                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(hennkan_mojiretu)))
                        {
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            return FALSE;
                        }
                    }

                    if(region->beg[0] == region->end[0]) 
                    {
                        char buf[2];
                        buf[0] = str2[region->beg[0]];
                        buf[1] = 0;
                        if(!quiet) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                            {
                                onig_region_free(region, 1);
                                string_delete(hennkan_mojiretu);
                                string_delete(str);
                                return FALSE;
                            }
                        }
                        point = region->end[0] + 1;
                    }
                    else {
                        point = region->end[0];
                    }

                    hennkann_kaisuu++;
                }
                else {
                    /// マッチした文字列の前 ///
                    char* tmp = MALLOC(
                        region->beg[0] - point + 1);

                    memcpy(tmp, str2 + point
                        , region->beg[0] - point);
                    tmp[region->beg[0] - point] = 0;
                    if(!quiet) {
                        if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                        {
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            FREE(tmp);
                            string_delete(str);
                            return FALSE;
                        }
                    }

                    FREE(tmp);


                    if(region->beg[0] == region->end[0]) {
                        char buf[2];
                        buf[0] = str2[region->beg[0]];
                        buf[1] = 0;
                        if(!quiet) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                            {
                                onig_region_free(region, 1);
                                string_delete(hennkan_mojiretu);
                                string_delete(str);
                                return FALSE;
                            }
                        }
                        point = region->end[0] + 1;
                    }
                    else {
                        char* tmp = MALLOC(region->end[0] - region->beg[0] + 1);
                        memcpy(tmp, str2 + region->beg[0], region->end[0]-region->beg[0]);
                        tmp[region->end[0]-region->beg[0]] = 0;
                        if(!quiet) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                            {
                                onig_region_free(region, 1);
                                string_delete(hennkan_mojiretu);
                                FREE(tmp);
                                string_delete(str);
                                return FALSE;
                            }
                        }

                        FREE(tmp);

                        point = region->end[0];

                    }
                }

                onig_region_free(region, 1);

                if(str2 + point>=str2 + strlen(str2)) 
                {
                    break;
                }

                if(!global) {
                    break;
                }
            }
        }

        string_delete(hennkan_mojiretu);

        if(point < strlen(str2)) {
            if(!quiet) {
                if(!statment_tree_internal_commands_write_nextout(nextout, str2 + point))
                {
                    string_delete(str);
                    return FALSE;
                }
            }
        }
    }

    /// 出力 ///

    char buf[128];
    snprintf(buf, 128, "%d", hennkann_kaisuu);
    (void)saphire_set_local_var("SUB_COUNT", buf, NULL);

    if(hennkann_kaisuu > 0) {
        *rcode = 0;
    }

    string_delete(str);

    return TRUE;
}

static BOOL statment_tree_internal_commands_sub_base_oneline(sRunInfo* runinfo, BOOL global, vector_obj* blocks, BOOL quiet, BOOL multiline, BOOL check, BOOL ignore_case, int* rcode, sWFd* nextout, char* sname, int sline, sRFd* nextin, int nexterr, enum eKanjiCode code, BOOL input, vector_obj* argv, enum eLineField lf)
{
    char* regex;
    char* destination;
    sRFd* nextin2;

    if(input) {
        if(vector_size(argv) == 3 || vector_size(argv) == 2 && vector_size(blocks) >= 1) 
        {
            nextin2 = nextin;

            regex = string_c_str(vector_item(argv, 1));
            if(vector_size(blocks) >= 1) {
                destination = NULL;
            }
            else {
                destination = string_c_str(vector_item(argv, 2));
            }
        }
        else {
            err_msg("invalid argument", sname, sline);
            return FALSE;
        }
    }
    else if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) 
    {
        nextin2 = RFD_NEW(-1);
        sRFd_set_buffer(nextin2, string_c_str(vector_item(argv, 1)));

        regex = string_c_str(vector_item(argv, 2));
        if(vector_size(blocks) >= 1) {
            destination = NULL;
        }
        else {
            destination = string_c_str(vector_item(argv, 3));
        }
    }
    else {
        err_msg("invalid argument", sname, sline);
        return FALSE;
    }

    BOOL check_all = FALSE;
    BOOL check_all_no = FALSE;
    int hennkann_kaisuu = 0;

    int i;

    char* regex2 = regex;

    int r;
    regex_t* reg = get_reg(&r, regex2, ignore_case, multiline, code);

    if(r == ONIG_NORMAL) {
        while(1) {
            string_obj* str = STRING_NEW("");
            int result = statment_tree_internal_commands_read_nextin_oneline(nextin2, str, lf);
            if(result < 0) {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                return FALSE;
            }
            else if(result == 1) {
                string_delete(str);
                break;
            }

            char* str2 = string_c_str(str);
            int point = 0;
            int region_end_before = 0;
            string_obj* hennkan_mojiretu = STRING_NEW("");
            while(1) {
                if(gKitutukiSigInt) {
                    err_msg("interrupt", sname, sline);
                    gKitutukiSigInt = FALSE;
                    string_delete(str);
                    string_delete(hennkan_mojiretu);
                    if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                    return FALSE;
                }

                OnigRegion* region = onig_region_new();
                OnigErrorInfo err_info;
                int r2 = onig_search(reg, str2
                   , str2 + strlen(str2)
                   , str2 + point
                   , str2 + strlen(str2)
                   , region, ONIG_OPTION_NONE);

                if(r2 == ONIG_MISMATCH) {
                    //point++;
                    onig_region_free(region, 1);
                    break;
                }
                else {
                    /// チェック ///
                    BOOL quetion;

                    if(check_all_no) {
                        quetion = FALSE;
                    }
                    else if(check_all) {
                        quetion = TRUE;
                    }
                    else if(check) 
                    {
#if !defined(__FREEBSD__)
                        msave_screen();
#endif
                        msave_ttysettings();
                        minitscr();

                        mclear();

                        /// 変換場所から行前を表示 ///
                        int count = 0;
                        char* p = str2+region->beg[0];
                        while(p > str2) {
                            if(gKitutukiSigInt) {
                                err_msg("interrupt", sname, sline);
                                gKitutukiSigInt = FALSE;
                                onig_region_free(region, 1);
                                string_delete(str);
                                if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                                string_delete(hennkan_mojiretu);
                                return FALSE;
                            }
                            if(is_line_field2(gLineField, p)) {
                                if(gLineField == kCRLF) {
                                    count++;
                                    if(count == 6) {
                                        p+=2;
                                        break;
                                    }
                                }
                                else {
                                    count++;
                                    if(count == 6) {
                                        p++;
                                        break;
                                    }
                                }

                                p--;
                            }
                            else {
                                p--;
                            }
                        }

                        char* tmp = MALLOC(str2+region->beg[0]-p+1);
                        memcpy(tmp, p, str2+region->beg[0]-p);
                        tmp[str2+region->beg[0]-p] = 0;

                        mprintw(tmp);
                        
                        FREE(tmp);

                        /// 変換文字列を表示 ///
                        tmp = MALLOC(region->end[0]-region->beg[0]+1);
                        memcpy(tmp, str2 + region->beg[0], region->end[0]-region->beg[0]);
                        tmp[region->end[0]-region->beg[0]] = 0;

                        mattron(kCAReverse);
                        mprintw(tmp);
                        mattroff();

                        FREE(tmp);

                        /// 変換場所から行後を表示 ///
                        count = 0;
                        p = str2+region->end[0];
                        while(p < str2+strlen(str2)) {
                            if(gKitutukiSigInt) {
                                err_msg("interrupt", sname, sline);
                                gKitutukiSigInt = FALSE;
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                                return FALSE;
                            }
                            if(is_line_field2(gLineField, p)) {
                                if(gLineField == kCRLF) {
                                    count++;
                                    if(count == 6) {
                                        p-=2;
                                        break;
                                    }
                                }
                                else {
                                    count++;
                                    if(count == 6) {
                                        p--;
                                        break;
                                    }
                                }

                                p++;
                            }
                            else {
                                p++;
                            }
                        }

                        tmp = MALLOC(p-str2-region->end[0]+1);
                        memcpy(tmp, str2+region->end[0], p-str2-region->end[0]);
                        tmp[p-str2-region->end[0]] = 0;

                        mprintw(tmp);

                        FREE(tmp);

                        mprintw("\n");
                        mprintw("sub ok? (y)es/(n)o/(a)ll yes/(A)ll no");
                        mrefresh();

                        int meta;
                        int key = mgetch(&meta);
                        
                        mendwin();
#if !defined(__FREEBSD__)
                        mrestore_screen();
#endif
                        mrestore_ttysettings();

                        if(key == 3) {
                            break;
                        }
                        quetion = key == 'y' || key == 'a';
                        check_all = key == 'a';
                        check_all_no = key == 'A';
                    }
                    else {
                        quetion = TRUE;
                    }

                    if(destination) {
                        /// グループ化したものを
                        ///  \\1 \\2などに変換 ///
                        
                        char* p = destination;
                        string_put(hennkan_mojiretu, "");

                        while(*p) {
                            if(gKitutukiSigInt) {
                                err_msg("interrupt", sname, sline);
                                gKitutukiSigInt = FALSE;
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                                return FALSE;
                            }
                            if(*p == '\\' 
                                && *(p+1) == '\\')
                            {
                                p++;
                                string_push_back2(
                                    hennkan_mojiretu
                                        , *p++);
                            }
                            else if(*p == '\\' 
                                && *(p+1) >= '1'
                                && *(p+1) <= '9')
                            {
                                char tmp[BUFSIZ];
                                int n = *(p+1) - '0';

                                if(n < region->num_regs) 
                                {
                                    p+=2;
                                    memcpy(tmp
                                        , str2 
                                        + region->beg[n]
                                        , region->end[n]
                                        -region->beg[n]);

                                    tmp[region->end[n]
                                      - region->beg[n]] 
                                        = 0;

                                    char* p3 = tmp;
                                    while(*p3) {
                                        if(gKitutukiSigInt) {
                                            err_msg("interrupt", sname, sline);
                                            gKitutukiSigInt = FALSE;
                                            onig_region_free(region, 1);
                                            string_delete(str);
                                            string_delete(hennkan_mojiretu);
                                            if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                                            return FALSE;
                                        }

                                       string_push_back2(hennkan_mojiretu, *p3++);
                                    }
                                }
                                else {
                                    string_push_back2(
                                        hennkan_mojiretu
                                        , *p++);
                                    string_push_back2(
                                        hennkan_mojiretu
                                        , *p++);
                                }
                            }
                            else { 
                                string_push_back2(
                                    hennkan_mojiretu
                                        , *p++);
                            }
                        }
                    }
                    else {
                        if(region->num_regs > 1) {
                            /// マッチしたグループ化文字列 ///
                            int i;
                            for (i=1; i<region->num_regs; i++) {
                                char* tmp = MALLOC(
                                    region->end[i]-region->beg[i] + 1);

                                memcpy(tmp, str2 + region->beg[i]
                                 , region->end[i]-region->beg[i]);

                                tmp[region->end[i]
                                    - region->beg[i]] = 0;

                                char name[16];
                                snprintf(name, 16, "%d", i);

                                (void)saphire_set_local_var(name, tmp, NULL);

                                FREE(tmp);
                            }
                            
                            /// run
                            char* tmp = MALLOC(region->end[0]-region->beg[0]+1);

                            memcpy(tmp
                             , str2 + region->beg[0]
                             , region->end[0]-region->beg[0]);

                            tmp[region->end[0]
                                - region->beg[0]] = 0;

                            if(vector_size(blocks) == 0) {
                                err_msg("few blocks", sname, sline);
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                                FREE(tmp);
                                return FALSE;
                            }

                            sBlock* block = vector_item(blocks, 0);
                            sStatments* statments = block->mStatments;

                            char* fname = MALLOC(strlen(sname) + 32);
                            snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);
                            sWFd* nextout2 = WFD_NEW(-1);
                            sRFd* nextin3 = RFD_NEW2(-1, tmp);
                            FREE(tmp);
                            *rcode = run(runinfo, statments, fname, nextout2 , nextin3, nexterr, FALSE);

                            FREE(fname);

                            if(!string_put_cancelable(hennkan_mojiretu, nextout2->mBuffer))
                            {
                                sWFd_delete(nextout2);
                                sRFd_delete(nextin3);
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                                return FALSE;
                            }

                            sWFd_delete(nextout2);
                            sRFd_delete(nextin3);

                            if(runinfo->enable_break && *runinfo->break_) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                                return TRUE;
                            }
                            else if(runinfo->enable_return && *runinfo->return_) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                                return TRUE;
                            }
                            else if(*rcode < 0) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                                return FALSE;
                            }
                        }
                        else {
                            char* tmp = MALLOC(region->end[0]-region->beg[0]+1);

                            memcpy(tmp
                             , str2 + region->beg[0]
                             , region->end[0]-region->beg[0]);

                            tmp[region->end[0]
                                - region->beg[0]] = 0;

                            if(vector_size(blocks) == 0) {
                                err_msg("few blocks", sname, sline);
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                                FREE(tmp);
                                return FALSE;
                            }

                            sBlock* block = vector_item(blocks, 0);
                            sStatments* statments = block->mStatments;

                            char* fname = MALLOC(strlen(sname) + 32);
                            snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);
                            sWFd* nextout2 = WFD_NEW(-1);
                            sRFd* nextin3 = RFD_NEW2(-1, tmp);
                            FREE(tmp);
                            *rcode = run(runinfo, statments, fname, nextout2 , nextin3, nexterr, FALSE);
                            FREE(fname);

                            if(!string_put_cancelable(hennkan_mojiretu, nextout2->mBuffer))
                            {
                                sWFd_delete(nextout2);
                                sRFd_delete(nextin3);
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                                return FALSE;
                            }

                            sWFd_delete(nextout2);
                            sRFd_delete(nextin3);

                            if(runinfo->enable_break && *runinfo->break_) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                                return TRUE;
                            }
                            else if(runinfo->enable_return && *runinfo->return_) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                                return TRUE;
                            }
                            else if(*rcode < 0) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                                return FALSE;
                            }
                        }
                    }

                    /// 変換開始 ///
                    if(quetion) {
                        /// マッチした文字列の前 ///
                        char* tmp = MALLOC(
                            region->beg[0] - point + 1);

                        memcpy(tmp, str2 + point
                            , region->beg[0] - point);
                        tmp[region->beg[0] - point] = 0;
                        if(!quiet) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                            {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                                FREE(tmp);
                                return FALSE;
                            }
                        }

                        FREE(tmp);

                        /// 変換文字列を入れる ///
                        if(!quiet) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(hennkan_mojiretu)))
                            {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                                return FALSE;
                            }
                        }

                        if(region->beg[0] == region->end[0]) 
                        {
                            char buf[2];
                            buf[0] = str2[region->beg[0]];
                            buf[1] = 0;
                            if(!quiet) {
                                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                                {
                                    onig_region_free(region, 1);
                                    string_delete(str);
                                    string_delete(hennkan_mojiretu);
                                    if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                                    return FALSE;
                                }
                            }
                            point = region->end[0] + 1;
                        }
                        else {
                            point = region->end[0];
                        }

                        hennkann_kaisuu++;
                    }
                    else {
                        /// マッチした文字列の前 ///
                        char* tmp = MALLOC(
                            region->beg[0] - point + 1);

                        memcpy(tmp, str2 + point
                            , region->beg[0] - point);
                        tmp[region->beg[0] - point] = 0;
                        if(!quiet) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                            {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                                FREE(tmp);
                                return FALSE;
                            }
                        }

                        FREE(tmp);


                        if(region->beg[0] == region->end[0]) {
                            char buf[2];
                            buf[0] = str2[region->beg[0]];
                            buf[1] = 0;
                            if(!quiet) {
                                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                                {
                                    onig_region_free(region, 1);
                                    string_delete(str);
                                    string_delete(hennkan_mojiretu);
                                    if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                                    return FALSE;
                                }
                            }
                            point = region->end[0] + 1;
                        }
                        else {
                            char* tmp = MALLOC(region->end[0] - region->beg[0] + 1);
                            memcpy(tmp, str2 + region->beg[0], region->end[0]-region->beg[0]);
                            tmp[region->end[0]-region->beg[0]] = 0;
                            if(!quiet) {
                                if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                                {
                                    onig_region_free(region, 1);
                                    string_delete(str);
                                    string_delete(hennkan_mojiretu);
                                    FREE(tmp);
                                    if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                                    return FALSE;
                                }
                            }

                            point = region->end[0];

                            FREE(tmp);
                        }
                    }

                    onig_region_free(region, 1);

                    if(str2 + point>=str2 + strlen(str2)) 
                    {
                        break;
                    }

                    if(!global) {
                        break;
                    }
                }
            }

            string_delete(hennkan_mojiretu);

            if(point < strlen(str2)) {
                if(!quiet) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, str2 + point))
                    {
                        string_delete(str);
                        if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);
                        return FALSE;
                    }
                }
            }

            string_delete(str);
        }
    }
    else {
        err_msg("erase: invalid regex", sname, sline);
        if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);

        return FALSE;
    } 

    if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) sRFd_delete(nextin2);

    /// 出力 ///
    char buf[128];
    snprintf(buf, 128, "%d", hennkann_kaisuu);
    (void)saphire_set_local_var("SUB_COUNT", buf, NULL);

    if(hennkann_kaisuu > 0) {
        *rcode = 0;
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_length(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    BOOL line_field = TRUE;
    enum eKanjiCode code = gKanjiCode;
    BOOL terminal = FALSE;
    BOOL line_field_count = FALSE;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // when output the variant content, don't add LF at tail
        // 出力するとき改行を加えない
        else if(strcmp(arg, "-nl") == 0) {
            line_field = FALSE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Shift JIS
        // データをSjisエンコードとして扱う
        else if(strcmp(arg, "-s") == 0) {
            code = kSjis;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Eucjp
        // データをEucjpエンコードとして扱う
        else if(strcmp(arg, "-e") == 0) {
            code = kEucjp;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Utf-8
        // データをUtf-8エンコードとして扱う
        else if(strcmp(arg, "-w") == 0) {
            code = kUtf8;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as ASCII code
        // データをASCIIデータとして扱う
        else if(strcmp(arg, "-b") == 0) {
            code = kByte;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // terminal size length
        // 端末上の文字の大きさで何文字か
        else if(strcmp(arg, "-t") == 0) {
            terminal = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // linefield count
        // 改行がいくつあるか
        else if(strcmp(arg, "-L") == 0) {
            line_field_count = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(
                    nextin, str);

        /// EOF
        if(ret == 1) {
            string_delete(str);
            *rcode = 1;
            return TRUE;
        }
        else if(ret < 0)
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }
        else {
            int len;
            if(terminal)
                len = str_termlen(code, string_c_str(str));
            else if(line_field_count)
                len = str_lflen(gLineField, string_c_str(str));
            else {
                len = str_kanjilen_cancelable(code, string_c_str(str));
                if(len < 0) {
                    string_delete(str);
                    return FALSE;
                }
            }

            char buf[128];
            if(line_field)
                snprintf(buf, 128, "%d\n", len);
            else
                snprintf(buf, 128, "%d", len);

            if(!statment_tree_internal_commands_write_nextout(nextout,  buf))
            {
                err_msg("signal interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }

            *rcode = 0;
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) == 2) {
            int len;
            if(terminal)
                len = str_termlen(code, string_c_str(vector_item(argv, 1)));
            else if(line_field_count)
                len = str_lflen(gLineField, string_c_str(vector_item(argv, 1)));
            else {
                len = str_kanjilen_cancelable(code, string_c_str(vector_item(argv, 1)));
                if(len < 0) {
                    return FALSE;
                }
            }
            char buf[128];

            if(line_field)
                snprintf(buf, 128, "%d\n", len);
            else
                snprintf(buf, 128, "%d", len);

            if(!statment_tree_internal_commands_write_nextout(nextout, buf)) 
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_index(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL quiet = FALSE;
    BOOL new_line = TRUE;
    BOOL flg_n = FALSE;
    int n;
    BOOL flg_c = FALSE;
    int c;
    enum eKanjiCode code = gKanjiCode;
    BOOL terminal = FALSE;
    BOOL ignore_case = FALSE;

    int l;
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        // not output only to use return code
        // 出力しない。リターンコードのみ見る場合に使う
        if(strcmp(arg, "-q") == 0) {
            quiet = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // ignore case
        // 英字の大文字小文字を無視する
        else if(strcmp(arg, "-i") == 0) {
            ignore_case = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // when output the variant content, don't add LF at tail
        // 出力するとき改行を加えない
        else if(strcmp(arg, "-nl") == 0) {
            new_line = FALSE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // take a STDIN pipe
        // 標準入力から受け取る
        else if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // count with terminal character size
        // 端末上での文字の大きさで数える
        else if(strcmp(arg, "-t") == 0) {
            terminal = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // assume data as ASCII code
        // データをASCIIデータとして扱う
        else if(strcmp(arg, "-b") == 0) {
            code = kByte;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // search N times
        // n回サーチする
        else if(strcmp(arg, "-c") == 0 && l+1 < vector_size(argv)) {
            flg_c = TRUE;
            c = atoi(string_c_str(vector_item(argv, l+1)));
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // search at Nth character
        // n文字目からサーチする
        else if(strcmp(arg, "-n") == 0 && l+1 < vector_size(argv)) {
            flg_n = TRUE;
            n = atoi(string_c_str(vector_item(argv, l+1)));
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    char* word;
    char* target;
    int start;
    int match_count;
    string_obj* str = STRING_NEW("");

    if(input) {
        if(vector_size(argv) != 2) {
            err_msg("index -I string", sname, sline);
            string_delete(str);
            return FALSE;
        }

        /// 文字列 ///
        int ret = statment_tree_internal_commands_read_nextin(nextin, str);
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }
        target = string_c_str(str);

        /// 検索文字列 ///
        word = string_c_str(vector_item(argv, 1));

        /// 検索文字列開始位置 ///
        if(flg_n) {
            start = n;

            int len = str_kanjilen_cancelable(code, target);
            if(len < 0) {
                string_delete(str);
                return FALSE;
            }

            if(start < 0) {
                start = len + start;
            }

            if(start < 0 || start >= len)
            {
                string_delete(str);
                return TRUE;
            }
        }
        else {
            start = 0;
        }

        /// 検索文字列の検索回数 ///
        if(flg_c) {
            match_count = c;
            if(match_count <= 0) {
                err_msg("index -> invalid -c range", sname, sline);
                string_delete(str);
                return FALSE;
            }
        }
        else {
            match_count = 1;
        }
    }
    else {
        if(vector_size(argv) != 3) {
            err_msg("index -> invalid option number", sname, sline);
            string_delete(str);
            return FALSE;
        }

        /// 検索文字列 ///
        word = string_c_str(vector_item(argv, 2));

        /// 文字列 ///
        target = string_c_str(vector_item(argv, 1));

        /// 検索文字列開始位置 ///
        if(flg_n) {
            start = n;

            int len = str_kanjilen_cancelable(code, target);
            if(len < 0) {
                string_delete(str);
                return FALSE;
            }

            if(start < 0) {
                start = len + start;
            }

            if(start < 0 || start >= len)
            {
                string_delete(str);
                return TRUE;
            }
        }
        else {
            start = 0;
        }

        /// 検索文字列の検索回数 ///
        if(flg_c) {
            match_count = c;
            if(match_count <= 0) {
                err_msg("index -> invalid -c range", sname, sline);
                string_delete(str);
                return FALSE;
            }
        }
        else {
            match_count = 1;
        }
    }

    char* start_byte = str_kanjipos2pointer(code, target, start);
    int count = match_count;
    char* p = start_byte;
    char* result = NULL;
    if(ignore_case) {
        while(p < start_byte + strlen(start_byte)) {
            if(gKitutukiSigInt) {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }
            result = (char*)strcasestr((const char*) p, (const char*)word);
            if(result) {
                count--;
                if(count == 0) {
                    break;
                }
                p = result+strlen(word);
            }
            else {
                break;
            }
        }
    }
    else {
        while(p < start_byte + strlen(start_byte)) {
            if(gKitutukiSigInt) {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }
            result = strstr(p, word);
            if(result) {
                count--;
                if(count == 0) {
                    break;
                }
                p = result+strlen(word);
            }
            else {
                break;
            }
        }
    }

    char msg[64];
    if(result == NULL || count !=0) {
        snprintf(msg, 64, "-1");
    }
    else {
        int c;
        if(terminal) {
            int pos = str_pointer2kanjipos(code, target, result);
            c = str_termlen2(code, target, pos);
        }
        else {
            c = str_pointer2kanjipos(code, target, result);
        }
        snprintf(msg, 64, "%d", c);
        *rcode = 0;
    }

    /// 出力 ///
    if(quiet == FALSE) {
        if(!statment_tree_internal_commands_write_nextout(nextout, msg))
        {
            err_msg("signal interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }

        if(new_line) {
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }
        }
    }

    string_delete(str);

    return TRUE;
}

BOOL statment_tree_internal_commands_rindex(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL quiet = FALSE;
    BOOL new_line = TRUE;
    BOOL flg_n = FALSE;
    int n;
    BOOL flg_c = FALSE;
    BOOL terminal = FALSE;
    int c;
    enum eKanjiCode code = gKanjiCode;
    BOOL ignore_case = FALSE;

    int l;
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        // not output only to use return code
        // 出力しない。リターンコードのみ見る場合に使う
        if(strcmp(arg, "-q") == 0) {
            quiet = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // ignore case
        // 英字の大文字小文字を無視する
        else if(strcmp(arg, "-i") == 0) {
            ignore_case = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // when output the variant content, don't add LF at tail
        // 出力するとき改行を加えない
        else if(strcmp(arg, "-nl") == 0) {
            new_line = FALSE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // count with terminal character size
        // 端末上での文字の大きさで数える
        else if(strcmp(arg, "-t") == 0) {
            terminal = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // assume data as ASCII code
        // データをASCIIデータとして扱う
        else if(strcmp(arg, "-b") == 0) {
            code = kByte;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // take a STDIN pipe
        // 標準入力から受け取る
        else if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // search N times
        // n回サーチする
        else if(strcmp(arg, "-c") == 0 && l+1 < vector_size(argv)) {
            flg_c = TRUE;
            c = atoi(string_c_str(vector_item(argv, l+1)));
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // search at Nth character
        // n文字目からサーチする
        else if(strcmp(arg, "-n") == 0 && l+1 < vector_size(argv)) {
            flg_n = TRUE;
            n = atoi(string_c_str(vector_item(argv, l+1)));
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    char* word;
    char* target;
    int start;
    int match_count;
    string_obj* str = STRING_NEW("");

    if(input) {
        if(vector_size(argv) != 2) {
            err_msg("index -I string", sname, sline);
            string_delete(str);
            return FALSE;
        }

        /// 文字列 ///
        int ret = statment_tree_internal_commands_read_nextin(nextin, str);
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            err_msg("intterrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }
        target = string_c_str(str);

        /// 検索文字列 ///
        word = string_c_str(vector_item(argv, 1));

        /// 検索文字列開始位置 ///
        int len = str_kanjilen_cancelable(code, target);
        if(len < 0) {
            string_delete(str);
            return FALSE;
        }
        if(flg_n) {
            start = n;

            if(start < 0) {
                start = len + start;
            }

            if(start < 0 || start >= len)
            {
                string_delete(str);
                return TRUE;
            }
        }
        else {
            start = len -1;
        }

        /// 検索文字列の検索回数 ///
        if(flg_c) {
            match_count = c;
            if(match_count <= 0) {
                err_msg("index -> invalid -c range", sname, sline);
                string_delete(str);
                return FALSE;
            }
        }
        else {
            match_count = 1;
        }
    }
    else {
        if(vector_size(argv) != 3) {
            err_msg("index -> invalid option number", sname, sline);
            string_delete(str);
            return FALSE;
        }

        /// 文字列 ///
        word = string_c_str(vector_item(argv, 2));

        /// 検索文字列 ///
        target = string_c_str(vector_item(argv, 1));

        /// 検索文字列開始位置 ///
        int len = str_kanjilen_cancelable(code, target);
        if(len < 0) {
            string_delete(str);
            return FALSE;
        }
        if(flg_n) {
            start = n;

            if(start < 0) {
                start = len + start;
            }

            if(start < 0 || start >= len)
            {
                string_delete(str);
                return TRUE;
            }
        }
        else {
            start = len -1;
        }

        /// 検索文字列の検索回数 ///
        if(flg_c) {
            match_count = c;
            if(match_count <= 0) {
                err_msg("index -> invalid -c range", sname, sline);
                string_delete(str);
                return FALSE;
            }
        }
        else {
            match_count = 1;
        }
    }
    
    int count = match_count;

    char* start_byte = str_kanjipos2pointer(code
            , target, start+1);
    char* p = start_byte;
    char* result = NULL;
    if(ignore_case) {
        while(p>=target) {
            result = strcasestr_back(p, target, word, sname, sline);

            if(gKitutukiSigInt) {
                err_msg("interrupt", sname, sline);
                *rcode = 1;
                string_delete(str);
                return FALSE;
            }

            if(result != NULL) {
                count--;
                if(count == 0) {
                    break;
                }
                p = result - 1;
            }
            else {
                break;
            }
        }
    }
    else {
        while(p>=target) {
            result = strstr_back(p, target, word, sname, sline);

            if(gKitutukiSigInt) {
                err_msg("interrupt", sname, sline);
                *rcode = 1;
                string_delete(str);
                return FALSE;
            }

            if(result != NULL) {
                count--;
                if(count == 0) {
                    break;
                }
                p = result - 1;
            }
            else {
                break;
            }
        }
    }

    char msg[64];
    if(result == NULL || count !=0) {
        snprintf(msg, 64, "-1");
    }
    else {
        int c;
        if(terminal) {
            int pos = str_pointer2kanjipos(code, target, result);
            c = str_termlen2(code, target, pos);
        }
        else {
            c = str_pointer2kanjipos(code, target, result);
        }
        snprintf(msg, 64, "%d", c);
        *rcode = 0;
    }

    if(quiet == FALSE) {
        if(!statment_tree_internal_commands_write_nextout(nextout, msg))
        {
            err_msg("signal interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }
        if(new_line) {
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }
        }
    }

    string_delete(str);

    return TRUE;
}

BOOL statment_tree_internal_commands_uc(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    BOOL line_field = FALSE;
    enum eKanjiCode code = gKanjiCode;

    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // when output the variant content, add LF at tail
        // 出力するとき改行も加える
        else if(strcmp(arg, "-L") == 0) {
            line_field = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Shift JIS
        // データをSjisエンコードとして扱う
        else if(strcmp(arg, "-s") == 0) {
            code = kSjis;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Eucjp
        // データをEucjpエンコードとして扱う
        else if(strcmp(arg, "-e") == 0) {
            code = kEucjp;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Utf-8
        // データをUtf-8エンコードとして扱う
        else if(strcmp(arg, "-w") == 0) {
            code = kUtf8;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as ASCII code
        // データをASCIIデータとして扱う
        else if(strcmp(arg, "-b") == 0) {
            code = kByte;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(
                        nextin, str);

        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }
        else {
            string_toupper(str, code);

            /// 出力 ///
            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str))) 
            {
                err_msg("signal interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }

            if(line_field) {
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
            }

            *rcode = 0;
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) == 2) {
            string_obj* str = STRING_NEW(
                string_c_str(vector_item(argv, 1)));

            string_toupper(str, code);

            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str))) 
            {
                err_msg("signal interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }

            if(line_field) {
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
            }

            *rcode = 0;

            string_delete(str);
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_lc(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    BOOL line_field = FALSE;
    enum eKanjiCode code = gKanjiCode;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // when output the variant content, add LF at tail
        // 出力するとき改行も加える
        else if(strcmp(arg, "-L") == 0) {
            line_field = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Shift JIS
        // データをSjisエンコードとして扱う
        else if(strcmp(arg, "-s") == 0) {
            code = kSjis;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Eucjp
        // データをEucjpエンコードとして扱う
        else if(strcmp(arg, "-e") == 0) {
            code = kEucjp;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Utf-8
        // データをUtf-8エンコードとして扱う
        else if(strcmp(arg, "-w") == 0) {
            code = kUtf8;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as ASCII code
        // データをASCIIデータとして扱う
        else if(strcmp(arg, "-b") == 0) {
            code = kByte;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(
            nextin, str);

        if(ret == 1) {
            string_delete(str);
            *rcode = 1;
            return TRUE;
        }
        else if(ret < 0)
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }
        else {
            string_tolower(str, code);

            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
            {
                err_msg("signal interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }

            if(line_field) {
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
            }

            *rcode = 0;
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) == 2) {
            string_obj* str = STRING_NEW(
                string_c_str(vector_item(argv, 1)));

            string_tolower(str, code);

            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
            {
                err_msg("signal interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }

            if(line_field) {
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
            }

            *rcode = 0;

            string_delete(str);
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_chomp(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(input) {
        string_obj* str = STRING_NEW("");
//puts("read_nextin start");
        int ret = statment_tree_internal_commands_read_nextin(
                nextin, str);

        if(ret == 1) {
            string_delete(str);
            *rcode = 1;
            return TRUE;
        }
        else if(ret < 0)
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }
        else {
            string_chomp(str);
            *rcode = 0;

            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
            {
                err_msg("signal interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }
        }

        string_delete(str);
    }
    else if(vector_size(argv) >= 2) {
        string_obj* str = vector_item(argv, 1);
        if(string_chomp(str)) {
            *rcode = 0;
        }

        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
        {
            err_msg("signal interrupt", sname, sline);
            return FALSE;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_scan_base(sRunInfo* runinfo, vector_obj* argv, string_obj* field, BOOL input, sWFd* nextout, sRFd* nextin, int *rcode, BOOL ignore_case, BOOL multiline, char* sname, int sline, vector_obj* blocks, int nexterr, enum eKanjiCode code, enum eLineField lf)
{
    int match_count = 0;

    char* regex;

    string_obj* str;
    if(input) {
        if(vector_size(argv) == 2) {
            str = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin
                    (nextin, str); 
            if(ret == 1) {
                *rcode = 1;
                string_delete(str);
                return TRUE;
            }
            else if(ret < 0)
            {
                string_delete(str);
                return FALSE;
            }
            regex = string_c_str(vector_item(argv, 1));
        }
        else {
            err_msg("invalid match arguments", sname, sline);
            return FALSE;
        }
    }
    else {
        if(vector_size(argv) == 3) {
            str = STRING_NEW(string_c_str(vector_item(argv, 1)));
            regex = string_c_str(vector_item(argv, 2));
        }
        else {
            err_msg("invalid match arguments", sname, sline);
            return FALSE;
        }
    }

    char* str2 = string_c_str(str);
    char* regex2 = regex;

    int r;
    regex_t* reg = get_reg(&r, regex2, ignore_case, multiline, code);

    if(r == ONIG_NORMAL) {
        char* p = str2;
        int region_end_before = 0;
        if(vector_size(blocks) == 0) {
            while(1) {
                if(gKitutukiSigInt) {
                    gKitutukiSigInt = FALSE;
                    string_delete(str);
                    return FALSE;
                }

                OnigRegion* region = onig_region_new();
                int r2 = onig_search(reg, str2
                   , str2 + strlen(str2)
                   , p
                   , str2 + strlen(str2)
                   , region, ONIG_OPTION_NONE);

                if(r2 >= 0) {
                    match_count++;

                    /// グループ化無し ///
                    if(region->num_regs == 1) {
                        /// マッチした文字列 ///
                        int n = region->end[0] - region->beg[0];

                        char* tmp = MALLOC(n +2 + 1);
                        memcpy(tmp, str2 + region->beg[0], n);
                        if(lf == kCR) {
                            tmp[n] = '\r';
                            tmp[n+1] = 0;
                        } else if(lf == kCRLF) {
                            tmp[n] = '\r';
                            tmp[n+1] = '\n';
                            tmp[n+2] = 0;
                        } else if(lf == kLF) {
                            tmp[n] = '\n';
                            tmp[n+1] = 0;
                        } else {
                            tmp[n] = '\a';
                            tmp[n+1] = 0;
                        }

                        if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                        {
                            err_msg("signal interrupt", sname, sline);
                            onig_region_free(region, 1);
                            string_delete(str);
                            FREE(tmp);
                            return FALSE;
                        }

                        FREE(tmp);
                    }
                    /// グループ化 ///
                    else {
                        string_obj* out = STRING_NEW("");

                        int i;
                        for (i=1; i<region->num_regs; i++) {
                            char* tmp = MALLOC(region->end[i]-region->beg[i] + 1);

                            memcpy(tmp, str2 + region->beg[i], region->end[i]-region->beg[i]);

                            tmp[region->end[i] - region->beg[i]] = 0;

                            string_push_back(out, tmp);

                            FREE(tmp);

                            if(i==region->num_regs-1) {
                                if(lf == kCR) {
                                    string_push_back(out, "\r");
                                } else if(lf == kCRLF) {
                                    string_push_back(out, "\r\n");
                                } else if(lf == kLF) {
                                    string_push_back(out, "\n");
                                } else {
                                    string_push_back(out, "\a");
                                }
                            }
                            else {
                                string_push_back(out, string_c_str(field));
                            }
                        }

                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(out)))
                        {
                            err_msg("signal interrupt", sname, sline);
                            onig_region_free(region, 1);
                            string_delete(str);
                            string_delete(out);
                            return FALSE;
                        }

                        string_delete(out);
                    }

                    p = str2 + region->end[0];
                }
                else {
                    p = p + 1;
                }

                onig_region_free(region, 1);

                /// 最後まで行ったら抜ける ///
                if(p >= str2 + strlen(str2)) {
                    break;
                }
            }
        }
        else {
            while(1) {
                if(gKitutukiSigInt) {
                    gKitutukiSigInt = FALSE;
                    string_delete(str);
                    return FALSE;
                }

                OnigRegion* region = onig_region_new();
                int r2 = onig_search(reg, str2
                   , str2 + strlen(str2)
                   , p
                   , str2 + strlen(str2)
                   , region, ONIG_OPTION_NONE);

                if(r2 >= 0) {
                    match_count++;

                    /// グループ化無し ///
                    if(region->num_regs == 1) {
                        /// マッチした文字列 ///
                        int n = region->end[0] - region->beg[0];

                        char* tmp = MALLOC(n +2 + 1);
                        memcpy(tmp, str2 + region->beg[0], n);
                        if(lf == kCR) {
                            tmp[n] = '\r';
                            tmp[n+1] = 0;
                        } else if(lf == kCRLF) {
                            tmp[n] = '\r';
                            tmp[n+1] = '\n';
                            tmp[n+2] = 0;
                        } else if(lf == kLF) {
                            tmp[n] = '\n';
                            tmp[n+1] = 0;
                        } else {
                            tmp[n] = '\a';
                            tmp[n+1] = 0;
                        }

                        char* fname = MALLOC(strlen(sname) + 32);
                        snprintf(fname, strlen(sname) + 32, "%s %d: each", sname, sline);

                        sBlock* block = vector_item(blocks, 0);
                        sStatments* statments = block->mStatments;

                        sRFd* nextin2 = RFD_NEW2(-1, tmp);
                        *rcode = run(runinfo, statments, fname, nextout, nextin2, nexterr, FALSE);
                        sRFd_delete(nextin2);

                        FREE(fname);

                        if(runinfo->enable_break && *runinfo->break_) {
                            onig_region_free(region, 1);
                            string_delete(str);
                            return TRUE;
                        }
                        else if(runinfo->enable_return && *runinfo->return_) {
                            onig_region_free(region, 1);
                            string_delete(str);
                            return TRUE;
                        }
                        else if(*rcode < 0) {
                            onig_region_free(region, 1);
                            string_delete(str);
                            return FALSE;
                        }
                    }
                    /// グループ化 ///
                    else {
                        string_obj* out = STRING_NEW("");

                        int i;
                        for (i=1; i<region->num_regs; i++) {
                            char* tmp = MALLOC(region->end[i]-region->beg[i] + 1);

                            memcpy(tmp, str2 + region->beg[i], region->end[i]-region->beg[i]);

                            tmp[region->end[i] - region->beg[i]] = 0;

                            string_push_back(out, tmp);

                            FREE(tmp);

                            if(i==region->num_regs-1) {
                                if(lf == kCR) {
                                    string_push_back(out, "\r");
                                } else if(lf == kCRLF) {
                                    string_push_back(out, "\r\n");
                                } else if(lf == kLF) {
                                    string_push_back(out, "\n");
                                } else {
                                    string_push_back(out, "\a");
                                }
                            }
                            else {
                                string_push_back(out, string_c_str(field));
                            }

                        }

                        char* fname = MALLOC(strlen(sname) + 32);
                        snprintf(fname, strlen(sname) + 32, "%s %d: each", sname, sline);

                        sBlock* block = vector_item(blocks, 0);
                        sStatments* statments = block->mStatments;
                        sRFd* nextin2 = RFD_NEW2(-1, string_c_str(out));
                        *rcode = run(runinfo, statments , fname, nextout , nextin2, nexterr, FALSE);
                        sRFd_delete(nextin2);

                        FREE(fname);

                        if(runinfo->enable_break && *runinfo->break_) {
                            onig_region_free(region, 1);
                            string_delete(str);
                            string_delete(out);
                            return TRUE;
                        }
                        else if(runinfo->enable_return && *runinfo->return_) {
                            onig_region_free(region, 1);
                            string_delete(out);
                            string_delete(str);
                            return TRUE;
                        }
                        else if(*rcode < 0) {
                            onig_region_free(region, 1);
                            string_delete(str);
                            string_delete(out);
                            return FALSE;
                        }

                        string_delete(out);
                    }

                    p = str2 + region->end[0];
                }
                else {
                    p = p + 1;
                }

                onig_region_free(region, 1);

                /// 最後まで行ったら抜ける ///
                if(p >= str2 + strlen(str2)) {
                    break;
                }
            }
        }
    }
    else {
        err_msg("match: invalid regex", sname, sline);

        string_delete(str);
        return FALSE;
    } 

    char buf[256];
    snprintf(buf, 256, "%d", match_count);
    (void)saphire_set_local_var("MATCH_COUNT", buf, NULL);

    if(match_count > 0) {
        *rcode = 0;
    }

    string_delete(str);
    return TRUE;
}

BOOL statment_tree_internal_commands_scan_oneline_base(sRunInfo* runinfo, vector_obj* argv, string_obj* field, BOOL input, sWFd* nextout, sRFd* nextin, int *rcode, BOOL ignore_case, BOOL multiline, char* sname, int sline, vector_obj* blocks, int nexterr, enum eKanjiCode code, enum eLineField lf)
{
    int match_count = 0;

    char* regex;
    sRFd* nextin2;

    if(input) {
        if(vector_size(argv) <= 1) {
            err_msg("invalid arguments", sname, sline);
            return FALSE;
        }

        nextin2 = nextin;
        regex = string_c_str(vector_item(argv, 1));
    }
    else {
        if(vector_size(argv) <= 2) {
            err_msg("invalid arguments", sname, sline);
            return FALSE;
        }

        nextin2 = RFD_NEW(-1);
        sRFd_set_buffer(nextin2, string_c_str(vector_item(argv, 1)));
        regex = string_c_str(vector_item(argv, 2));
    }

    char* regex2 = regex;

    int r;
    regex_t* reg = get_reg(&r, regex2, ignore_case, multiline, code);

    if(r == ONIG_NORMAL) {
        while(1) {
            string_obj* str = STRING_NEW("");
            int result = statment_tree_internal_commands_read_nextin_oneline(nextin2, str, lf);
            if(result < 0) {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                if(!input) sRFd_delete(nextin2);
                return FALSE;
            }
            else if(result == 1) {
                string_delete(str);
                break;
            }

            char* str2 = string_c_str(str);
                    
            char* p = string_c_str(str);
            int region_end_before = 0;
            if(vector_size(blocks) == 0) {
                while(1) {
                    if(gKitutukiSigInt) {
                        gKitutukiSigInt = FALSE;
                        string_delete(str);
                        if(!input) sRFd_delete(nextin2);
                        return FALSE;
                    }

                    OnigRegion* region = onig_region_new();
                    int r2 = onig_search(reg, str2
                       , str2 + strlen(str2)
                       , p
                       , str2 + strlen(str2)
                       , region, ONIG_OPTION_NONE);

                    if(r2 >= 0) {
                        match_count++;

                        /// グループ化無し ///
                        if(region->num_regs == 1) {
                            /// マッチした文字列 ///
                            int n = region->end[0] - region->beg[0];

                            char* tmp = MALLOC(n +2 + 1);
                            memcpy(tmp, str2 + region->beg[0], n);
                            if(lf == kCR) {
                                tmp[n] = '\r';
                                tmp[n+1] = 0;
                            } else if(lf == kCRLF) {
                                tmp[n] = '\r';
                                tmp[n+1] = '\n';
                                tmp[n+2] = 0;
                            } else if(lf == kLF) {
                                tmp[n] = '\n';
                                tmp[n+1] = 0;
                            } else {
                                tmp[n] = '\a';
                                tmp[n+1] = 0;
                            }


                            if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                            {
                                err_msg("signal interrupt", sname, sline);
                                onig_region_free(region, 1);
                                string_delete(str);
                                if(!input) sRFd_delete(nextin2);
                                FREE(tmp);
                                return FALSE;
                            }

                            FREE(tmp);
                        }
                        /// グループ化 ///
                        else {
                            string_obj* out = STRING_NEW("");

                            int i;
                            for (i=1; i<region->num_regs; i++) {
                                char* tmp = MALLOC(region->end[i]-region->beg[i] + 1);

                                memcpy(tmp, str2 + region->beg[i], region->end[i]-region->beg[i]);

                                tmp[region->end[i] - region->beg[i]] = 0;

                                string_push_back(out, tmp);

                                FREE(tmp);

                                if(i==region->num_regs-1) {
                                    if(lf == kCR) {
                                        string_push_back(out, "\r");
                                    } else if(lf == kCRLF) {
                                        string_push_back(out, "\r\n");
                                    } else if(lf == kLF) {
                                        string_push_back(out, "\n");
                                    } else {
                                        string_push_back(out, "\a");
                                    }
                                }
                                else {
                                    string_push_back(out, string_c_str(field));
                                }
                            }

                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(out)))
                            {
                                err_msg("signal interrupt", sname, sline);
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(out);
                                if(!input) sRFd_delete(nextin2);
                                return FALSE;
                            }

                            string_delete(out);
                        }

                        p = str2 + region->end[0];
                    }
                    else {
                        p = p + 1;
                    }

                    onig_region_free(region, 1);

                    /// 最後まで行ったら抜ける ///
                    if(p >= str2 + strlen(str2)) {
                        break;
                    }
                }
            }
            else {
                while(1) {
                    if(gKitutukiSigInt) {
                        gKitutukiSigInt = FALSE;
                        string_delete(str);
                        if(!input) sRFd_delete(nextin2);
                        return FALSE;
                    }

                    OnigRegion* region = onig_region_new();
                    int r2 = onig_search(reg, str2
                       , str2 + strlen(str2)
                       , p
                       , str2 + strlen(str2)
                       , region, ONIG_OPTION_NONE);

                    if(r2 >= 0) {
                        match_count++;

                        /// グループ化無し ///
                        if(region->num_regs == 1) {
                            /// マッチした文字列 ///
                            int n = region->end[0] - region->beg[0];

                            char* tmp = MALLOC(n +2 + 1);
                            memcpy(tmp, str2 + region->beg[0], n);
                            if(lf == kCR) {
                                tmp[n] = '\r';
                                tmp[n+1] = 0;
                            } else if(lf == kCRLF) {
                                tmp[n] = '\r';
                                tmp[n+1] = '\n';
                                tmp[n+2] = 0;
                            } else if(lf == kLF) {
                                tmp[n] = '\n';
                                tmp[n+1] = 0;
                            } else {
                                tmp[n] = '\a';
                                tmp[n+1] = 0;
                            }

                            char* fname = MALLOC(strlen(sname) + 32);
                            snprintf(fname, strlen(sname) + 32, "%s %d: each", sname, sline);

                            sBlock* block = vector_item(blocks, 0);
                            sStatments* statments = block->mStatments;

                            sRFd* nextin3 = RFD_NEW2(-1, tmp);
                            FREE(tmp);
                            *rcode = run(runinfo, statments , fname, nextout , nextin3, nexterr, FALSE);
                            FREE(fname);
                            sRFd_delete(nextin3);

                            if(runinfo->enable_break && *runinfo->break_) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                if(!input) sRFd_delete(nextin2);
                                return TRUE;
                            }
                            else if(runinfo->enable_return && *runinfo->return_) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                if(!input) sRFd_delete(nextin2);
                                return TRUE;
                            }
                            else if(*rcode < 0) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                if(!input) sRFd_delete(nextin2);
                                return FALSE;
                            }
                        }
                        /// グループ化 ///
                        else {
                            string_obj* out = STRING_NEW("");

                            int i;
                            for (i=1; i<region->num_regs; i++) {
                                char* tmp = MALLOC(region->end[i]-region->beg[i] + 1);

                                memcpy(tmp, str2 + region->beg[i], region->end[i]-region->beg[i]);

                                tmp[region->end[i] - region->beg[i]] = 0;

                                string_push_back(out, tmp);

                                FREE(tmp);

                                if(i==region->num_regs-1) {
                                    if(lf == kCR) {
                                        string_push_back(out, "\r");
                                    } else if(lf == kCRLF) {
                                        string_push_back(out, "\r\n");
                                    } else if(lf == kLF) {
                                        string_push_back(out, "\n");
                                    } else {
                                        string_push_back(out, "\a");
                                    }
                                }
                                else {
                                    string_push_back(out, string_c_str(field));
                                }

                            }

                            char* fname = MALLOC(strlen(sname) + 32);
                            snprintf(fname, strlen(sname) + 32, "%s %d: each", sname, sline);

                            sBlock* block = vector_item(blocks, 0);
                            sStatments* statments = block->mStatments;
                            sRFd* nextin4 = RFD_NEW2(-1, string_c_str(out));
                            *rcode = run(runinfo, statments , fname, nextout , nextin4, nexterr, FALSE);
                            FREE(fname);

                            sRFd_delete(nextin4);

                            if(runinfo->enable_break && *runinfo->break_) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(out);
                                if(!input) sRFd_delete(nextin2);
                                return TRUE;
                            }
                            else if(runinfo->enable_return && *runinfo->return_) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(out);
                                if(!input) sRFd_delete(nextin2);
                                return TRUE;
                            }
                            else if(*rcode < 0) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(out);
                                if(!input) sRFd_delete(nextin2);
                                return FALSE;
                            }

                            string_delete(out);
                        }

                        p = str2 + region->end[0];
                    }
                    else {
                        p = p + 1;
                    }

                    onig_region_free(region, 1);

                    /// 最後まで行ったら抜ける ///
                    if(p >= str2 + strlen(str2)) {
                        break;
                    }
                }
            }

            string_delete(str);
        }
    }
    else {
        err_msg("invalid regex", sname, sline);
        if(!input) sRFd_delete(nextin2);

        return FALSE;
    } 
    if(!input) sRFd_delete(nextin2);

    char buf[256];
    snprintf(buf, 256, "%d", match_count);
    (void)saphire_set_local_var("MATCH_COUNT", buf, NULL);

    if(match_count > 0) {
        *rcode = 0;
    }

    return TRUE;
}
static BOOL statment_tree_internal_commands_match_base(char* str2
  , UChar* regex2, int* rcode, sWFd* nextout, BOOL print, BOOL line_field
  , BOOL line_num, int n, string_obj* field, BOOL line_oriented
  , int* match_count, BOOL ignore_case, BOOL multiline, char* sname, int sline, enum eKanjiCode code , enum eLineField lf)
{
    int r;
    regex_t* reg = get_reg(&r, regex2, ignore_case, multiline, code);

    if(r == ONIG_NORMAL) {
        int position;
        position = 0;

        OnigRegion* region = onig_region_new();
        int r2 = onig_search(reg, str2
           , str2 + strlen(str2)
           , str2 + position, str2 + strlen(str2)
           //, region, ONIG_OPTION_CAPTURE_GROUP);
           , region, ONIG_OPTION_NONE);

        if(r2 >= 0) {
            *rcode = 0;
            (*match_count)++;

            if(region->num_regs > 0) {
                /// マッチした文字列の前 ///
                if(region->beg[0] > 0) {
                    char* tmp = MALLOC(region->beg[0] + 1);

                    memcpy(tmp, str2, region->beg[0]);
                    tmp[region->beg[0]] = 0;

                    (void)saphire_set_local_var("PREMATCH", tmp, NULL);

                    FREE(tmp);

                }
                else {
                    (void)saphire_set_local_var("PREMATCH", "", NULL);
                }

                /// マッチした文字列 ///
                char* tmp = MALLOC(
                        region->end[0]-region->beg[0] + 1);

                memcpy(tmp, str2 + region->beg[0]
                 , region->end[0]-region->beg[0]);

                tmp[region->end[0]
                    - region->beg[0]] = 0;

                (void)saphire_set_local_var("MATCH", tmp, NULL);

                FREE(tmp);


                /// マッチした文字列の後 ///
                const int n = strlen(str2)-region->end[0];
                if(n > 0) {
                    char* tmp = MALLOC(n + 1);

                    memcpy(tmp, str2 + region->end[0], n);

                    tmp[n] = 0;

                    (void)saphire_set_local_var("POSTMATCH", tmp, NULL);

                    FREE(tmp);
                }
                else {
                    (void)saphire_set_local_var("POSTMATCH", "", NULL);
                }
            }

            /// マッチしたグループ化文字列 ///
            int i;
            for (i=1; i<region->num_regs; i++) {
                char* tmp = MALLOC(
                    region->end[i]-region->beg[i] + 1);

                memcpy(tmp, str2 + region->beg[i]
                 , region->end[i]-region->beg[i]);

                tmp[region->end[i]
                    - region->beg[i]] = 0;

                char name[16];
                snprintf(name, 16, "%d", i);

                (void)saphire_set_local_var(name, tmp, NULL);

                FREE(tmp);
            }

            if(print) {
                if(line_oriented) {
                    if(line_num) {
                        char num[128];
                        snprintf(num, 128, "%d:", n);
                        if(!statment_tree_internal_commands_write_nextout(nextout, num))
                        {
                            return FALSE;
                        }
                    }
                    
                    if(!statment_tree_internal_commands_write_nextout(nextout, str2) )
                    {
                        return FALSE;
                    }
                    if(line_field) {
                        if(!statment_tree_internal_commands_write_lf(nextout, lf) )
                        {
                            return FALSE;
                        }
                    }
                }
                else if(region->num_regs == 1) {
                    if(line_num) {
                        char num[128];
                        snprintf(num, 128, "%d:", n);
                        if(!statment_tree_internal_commands_write_nextout(nextout, num) )
                        {
                            return FALSE;
                        }
                    }
                    
                    string_obj* match = saphire_get_local_var("MATCH", NULL);

                    if(match) {
                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(match)) )
                        {
                            return FALSE;
                        }
                    }
                    if(line_field) {
                        if(!statment_tree_internal_commands_write_lf(nextout, lf) )
                        {
                            return FALSE;
                        }
                    }
                }
                else if(region->num_regs > 1) {
                    int i;
                    for(i=1; i<region->num_regs; i++) {
                        char name[16];
                        snprintf(name, 16, "%d", i);

                        string_obj* match = saphire_get_local_var(name, NULL);

                        if(match) {
                            if(line_num) {
                                char num[128];
                                snprintf(num, 128, "%d:", n);
                                if(!statment_tree_internal_commands_write_nextout(nextout, num)) 
                                {
                                    return FALSE;
                                }
                            }

                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(match))) 
                            {
                                return FALSE;
                            }
                        }
                        if(i==region->num_regs-1) {
                            if(line_field) {
                                if(!statment_tree_internal_commands_write_lf(nextout, lf) )
                                {
                                    return FALSE;
                                }
                            }
                        }
                        else {
                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(field))) 
                            {
                                return FALSE;
                            }
                        }
                    }
                }
            }
        }

        onig_region_free(region, 1);
    }
    else {
        err_msg("match: invalid regex", sname, sline);

        return FALSE;
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_printf_base(char* format, vector_obj* strings, sWFd* nextout, BOOL line_field, char* sname, int sline, enum eLineField lf)
{
    char* p = format;

    int strings_num = 0;
    string_obj* output = STRING_NEW("");

    while(*p) {
        if(gKitutukiSigInt) {
            gKitutukiSigInt = FALSE;
            string_delete(output);
            return FALSE;
        }

        if(*p == '%') {
            p++;

            if(*p == '%') {
                string_push_back(output, "%");
            }
            else {
                /// オプション ///
                string_obj* aformat = STRING_NEW("%");

                while(*p) {
                    if(*p == 'd' || *p == 'i' || *p == 'o' || *p == 'u' || *p == 'x' || *p == 'X' || *p == 'c') 
                    {
                        string_push_back2(aformat, *p++);

                        if(strings_num < vector_size(strings)) {
                            string_obj* arg = vector_item(strings, strings_num++);
                            char* buf;
                            asprintf(&buf, string_c_str(aformat), atoi(string_c_str(arg)));
                            string_put(aformat, "");
                            string_push_back(output, buf);
                            free(buf);
                        }
                        else {
                            string_put(aformat, "");
                        }

                        break;
                    }
                    else if(*p == 'e' || *p == 'E' || *p == 'f' || *p == 'F' || *p == 'g' || *p == 'G' || *p == 'a' || *p == 'A')
                    {
                        string_push_back2(aformat, *p++);

                        if(strings_num < vector_size(strings)) {
                            string_obj* arg = vector_item(strings, strings_num++);
                            char* buf;
                            asprintf(&buf, string_c_str(aformat), atof(string_c_str(arg)));
                            string_put(aformat, "");
                            string_push_back(output, buf);
                            free(buf);
                        }
                        else {
                            string_put(aformat, "");
                        }

                        break;
                    }
                    else if(*p == 's') {
                        string_push_back2(aformat, *p++);

                        if(strings_num < vector_size(strings)) {
                            string_obj* arg = vector_item(strings, strings_num++);
                            char* buf;
                            asprintf(&buf, string_c_str(aformat), string_c_str(arg));
                            string_put(aformat, "");
                            string_push_back(output, buf);
                            free(buf);
                        }
                        else {
                            string_put(aformat, "");
                        }

                        break;
                    }
                    else {
                        string_push_back2(aformat, *p++);
                    }
                }

                string_delete(aformat);
            }
        }
        else {
            string_push_back2(output, *p++);
        }
    }

    if(line_field) {
        if(lf == kCR) {
            string_push_back2(output, '\r');
        } else if(lf == kCRLF) {
            string_push_back(output, "\r\n");
        } else if(lf == kLF) {
            string_push_back2(output, '\n');
        } else {
            string_push_back2(output, '\a');
        }
    }

    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(output)))
    {
        string_delete(output);
        return FALSE;
    }

    string_delete(output);
    return TRUE;
}

BOOL statment_tree_internal_commands_condition_re(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    enum eKanjiCode code = gKanjiCode;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv, i));

        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Shift JIS
        // データをSjisエンコードとして扱う
        else if(strcmp(arg, "-s") == 0) {
            code = kSjis;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Eucjp
        // データをEucjpエンコードとして扱う
        else if(strcmp(arg, "-e") == 0) {
            code = kEucjp;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Utf-8
        // データをUtf-8エンコードとして扱う
        else if(strcmp(arg, "-w") == 0) {
            code = kUtf8;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as ASCII code
        // データをASCIIデータとして扱う
        else if(strcmp(arg, "-b") == 0) {
            code = kByte;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    char* target;
    char* regex;
    string_obj* str;
    if(input && vector_size(argv) == 2) {
        str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        target = string_c_str(str);
        regex = string_c_str(vector_item(argv, 1));
    }
    else if(vector_size(argv) == 3) {
        target = string_c_str(vector_item(argv, 1));
        regex = string_c_str(vector_item(argv, 2));
        str = NULL;
    }
    else {
        return TRUE;
    }

    char* regex2 = regex;

    int r;
    regex_t* reg;

    if(command->mKind == kConditionREIM || command->mKind == kConditionREMI)
    {
        reg = get_reg(&r, regex2, TRUE, TRUE, code);
    }
    else if(command->mKind == kConditionREI) {
        reg = get_reg(&r, regex2, TRUE, FALSE, code);
    }
    else if(command->mKind == kConditionREM) {
        reg = get_reg(&r, regex2, FALSE, TRUE, code);
    }
    else {
        reg = get_reg(&r, regex2, FALSE, FALSE, code);
    }

    if(r == ONIG_NORMAL) {
        OnigRegion* region = onig_region_new();
        int r2 = onig_search(reg, target
           , target + strlen(target)
           , target, target + strlen(target)
           , region, ONIG_OPTION_NONE);

        if(region->num_regs > 0) {
            if(region->beg[0] > 0) {
                /// マッチした文字列の前 ///
                char* tmp = MALLOC(region->beg[0] + 1);

                memcpy(tmp, target, region->beg[0]);
                tmp[region->beg[0]] = 0;

                (void)saphire_set_local_var("PREMATCH", tmp, NULL);

                FREE(tmp);
            }
            else {
                (void)saphire_set_local_var("PREMATCH", "", NULL);
            }

            /// マッチした文字列 ///
            char* tmp = MALLOC(
                    region->end[0]-region->beg[0] + 1);

            memcpy(tmp, target + region->beg[0]
             , region->end[0]-region->beg[0]);

            tmp[region->end[0]
                - region->beg[0]] = 0;

            (void)saphire_set_local_var("MATCH", tmp, NULL);

            FREE(tmp);

            /// マッチした文字列の後 ///
            const int n = strlen(target)-region->end[0];
            if(n > 0) {
                char* tmp = MALLOC(n + 1);

                memcpy(tmp, target + region->end[0], n);

                tmp[n] = 0;

                (void)saphire_set_local_var("POSTMATCH", tmp, NULL);

                FREE(tmp);
            }
            else {
                (void)saphire_set_local_var("POSTMATCH", "", NULL);
            }
        }
        if(r2 >= 0) {
            int i;
            for (i=1; i<region->num_regs; i++) {
                char* tmp =
                    MALLOC(region->end[i]-region->beg[i]+1);

                memcpy(tmp, target + region->beg[i]
                 , region->end[i]-region->beg[i]);

                tmp[region->end[i]
                    - region->beg[i]] = 0;

                char name[16];
                snprintf(name, 16, "%d", i);

                (void)saphire_set_local_var(name, tmp, NULL);

                FREE(tmp);
            }
        }

        if(r2 >= 0) {
            *rcode = 0;
        }

        onig_region_free(region, 1);
    }
    else {
        err_msg("-re: invalid regex", sname, sline);

        if(str) string_delete(str);
        return FALSE;
    }

    if(str) string_delete(str);

    return TRUE;
}
BOOL statment_tree_internal_commands_pomch(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    enum eLineField lf = gLineField;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CR
        // 改行コードをCRとして扱う
        else if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    string_obj* str;
    if(input) {
        str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0) {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }
    }
    else {
        if(vector_size(argv) >= 2) {
            str = STRING_NEW(string_c_str(vector_item(argv, 1)));
        }
        else {
            str = STRING_NEW("");
        }
    }

    string_pomch(str, lf);
    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str))) {
        err_msg("interrupt", sname, sline);
        string_delete(str);
        return FALSE;
    }
    *rcode = 0;
    string_delete(str);

    return TRUE;
}
BOOL statment_tree_internal_commands_printf(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    BOOL line_field = FALSE;
    enum eLineField lf = gLineField;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // when output the variant content, add LF at tail
        // 出力するとき改行も加える
        if(strcmp(arg, "-L") == 0) {
            line_field = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // take a STDIN pipe
        // 標準入力から受け取る
        else if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CR
        // 改行コードをCRとして扱う
        else if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(input && vector_size(argv) == 2) {
        /// 引数を取る ///
        vector_obj* v = VECTOR_NEW(30);
        while(1) {
            if(gKitutukiSigInt) {
                err_msg("interrupt", sname, sline);
                int i;
                for(i=0; i<vector_size(v); i++) {
                    string_delete(vector_item(v, i));
                }
                vector_delete(v);
                return FALSE;
            }

            string_obj* str = STRING_NEW("");
            int result = statment_tree_internal_commands_read_nextin_oneline(nextin, str, lf);
            if(result == 0) {
                string_chomp2(str, lf);
                vector_add(v, str);
            }
            else if(result == -1) {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                int i;
                for(i=0; i<vector_size(v); i++) {
                    string_delete(vector_item(v, i));
                }
                vector_delete(v);
                return FALSE;
            }
            else {
                string_delete(str);
                break;
            }
        }

        /// 本題 ///
        char* format = string_c_str(vector_item(argv, 1));

        if(!statment_tree_internal_commands_printf_base(format, v, nextout, line_field, sname, sline, lf)) {

            int i;
            for(i=0; i<vector_size(v); i++) {
                string_delete(vector_item(v, i));
            }
            vector_delete(v);
            return FALSE;
        }
        *rcode = 0;
        int i;
        for(i=0; i<vector_size(v); i++) {
            string_delete(vector_item(v, i));
        }
        vector_delete(v);
    }
    else if(vector_size(argv) > 2) {
        /// 引数を取る ///
        vector_obj* v = VECTOR_NEW(30);
        int i;
        for(i=2; i<vector_size(argv); i++) {
            vector_add(v, STRING_NEW(string_c_str(vector_item(argv, i))));
        }

        /// 本題 ///
        char* format = string_c_str(vector_item(argv, 1));

        if(!statment_tree_internal_commands_printf_base(format, v, nextout, line_field, sname, sline, lf)) 
        {
            int i;
            for(i=0; i<vector_size(v); i++) {
                string_delete(vector_item(v, i));
            }
            vector_delete(v);
            return FALSE;
        }

        for(i=0; i<vector_size(v); i++) {
            string_delete(vector_item(v, i));
        }
        vector_delete(v);
        *rcode = 0;

    }

    return TRUE;
}

BOOL statment_tree_internal_commands_split(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL ignore_case = FALSE;
    BOOL multiline = FALSE;
    enum eKanjiCode code = gKanjiCode;
    enum eLineField lf = gLineField;
    string_obj* field2 = STRING_NEW("\t");
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv, i));
        // ignore case
        // 英字の大文字小文字を無視する
        if(strcmp(arg, "-i") == 0)
        {
            ignore_case = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // set on field character
        // 文字列の間の文字列を設定
        else if(strcmp(arg, "-f") == 0 
            && i+1 < vector_size(argv)) 
        {
            string_put(field2 
                 , string_c_str(vector_item(argv, i+1)));
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // multiline
        // 複数行にまたぐ正規表現を許す
        else if(strcmp(arg, "-m") == 0)
        {
            multiline = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // take a STDIN pipe
        // 標準入力から受け取る
        else if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Shift JIS
        // データをSjisエンコードとして扱う
        else if(strcmp(arg, "-s") == 0) {
            code = kSjis;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Eucjp
        // データをEucjpエンコードとして扱う
        else if(strcmp(arg, "-e") == 0) {
            code = kEucjp;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Utf-8
        // データをUtf-8エンコードとして扱う
        else if(strcmp(arg, "-w") == 0) {
            code = kUtf8;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as ASCII code
        // データをASCIIデータとして扱う
        else if(strcmp(arg, "-b") == 0) {
            code = kByte;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CR
        // 改行コードをCRとして扱う
        else if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    string_obj* field;
    if(lf == kCRLF) {
        field = STRING_NEW("\r\n");
    } 
    else if(lf == kLF) {
        field = STRING_NEW("\n");
    }
    else if(lf == kCR) {
        field = STRING_NEW("\r");
    }
    else {
        field = STRING_NEW("\a");
    }

    if(!statment_tree_internal_commands_split_base(nextout, field, multiline, ignore_case, sname, sline, code, lf, input, argv, nextin, rcode, field2)) {
        string_delete(field);
        string_delete(field2);
        return FALSE;
    }

    string_delete(field);
    string_delete(field2);

    return TRUE;
}

BOOL statment_tree_internal_commands_scan(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL ignore_case = FALSE;
    BOOL multiline = FALSE;
    string_obj* field = STRING_NEW("\t");
    BOOL quiet = FALSE;
    enum eKanjiCode code = gKanjiCode;
    enum eLineField lf = gLineField;

    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv, i));
        // ignore case
        // 英字の大文字小文字を無視する
        if(strcmp(arg, "-i") == 0)
        {
            ignore_case = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // no output
        // アウトプットしない
        else if(strcmp(arg, "-q") == 0)
        {
            quiet = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // multiline
        // 複数行にまたぐ正規表現を許す
        else if(strcmp(arg, "-m") == 0)
        {
            multiline = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // take a STDIN pipe
        // 標準入力から受け取る
        else if(strcmp(arg, "-I") == 0)
        {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // set on field character
        // 文字列の間の文字列を設定
        else if(strcmp(arg, "-f") == 0 
            && i+1 < vector_size(argv)) 
        {
            string_put(field 
                 , string_c_str(vector_item(argv, i+1)));
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Shift JIS
        // データをSjisエンコードとして扱う
        else if(strcmp(arg, "-s") == 0) {
            code = kSjis;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Eucjp
        // データをEucjpエンコードとして扱う
        else if(strcmp(arg, "-e") == 0) {
            code = kEucjp;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Utf-8
        // データをUtf-8エンコードとして扱う
        else if(strcmp(arg, "-w") == 0) {
            code = kUtf8;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as ASCII code
        // データをASCIIデータとして扱う
        else if(strcmp(arg, "-b") == 0) {
            code = kByte;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CR
        // 改行コードをCRとして扱う
        else if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(multiline) {
        if(!statment_tree_internal_commands_scan_base(runinfo, argv, field, input, nextout, nextin, rcode, ignore_case, multiline, sname, sline, blocks, nexterr, code, lf)) {
            string_delete(field);
            return FALSE;
        }
    }
    else {
        if(!statment_tree_internal_commands_scan_oneline_base(runinfo, argv, field, input, nextout, nextin, rcode, ignore_case, multiline, sname, sline, blocks, nexterr, code, lf)) {
            string_delete(field);
            return FALSE;
        }
    }
    
    if(runinfo->enable_break && *runinfo->break_) {
        string_delete(field);
        return TRUE;
    }
    else if(runinfo->enable_return && *runinfo->return_) {
        string_delete(field);
        return TRUE;
    }

    string_delete(field);

    return TRUE;
}

BOOL statment_tree_internal_commands_match(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL quiet = FALSE;
    BOOL line_field = TRUE;
    BOOL line_num = FALSE;
    BOOL global = FALSE;
    BOOL line_oriented = FALSE;
    BOOL ignore_case = FALSE;
    BOOL multiline = FALSE;
    enum eKanjiCode code = gKanjiCode;
    string_obj* field = STRING_NEW("\t");
    enum eLineField lf = gLineField;
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv, i));
        // no output
        // アウトプットしない
        if(strcmp(arg, "-q") == 0)
        {
            quiet = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // line oriented like grep
        // grepのように振る舞う
        else if(strcmp(arg, "-L") == 0)
        {
            line_oriented = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // ignore case
        // 英字の大文字小文字を無視する
        else if(strcmp(arg, "-i") == 0)
        {
            ignore_case = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // multiline
        // 複数行にまたぐ正規表現を許す
        else if(strcmp(arg, "-m") == 0)
        {
            multiline = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // global
        // global
        else if(strcmp(arg, "-g") == 0)
        {
            global = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // when output the variant content, don't add LF at tail
        // 出力するとき改行を加えない
        else if(strcmp(arg, "-nl") == 0)
        {
            line_field = FALSE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // output line numbrs
        // 行番号を表示
        else if(strcmp(arg, "-n") == 0)
        {
            line_num = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // take a STDIN pipe
        // 標準入力から受け取る
        else if(strcmp(arg, "-I") == 0)
        {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // set on field character
        // 文字列の間の文字列を設定
        else if(strcmp(arg, "-f") == 0 
            && i+1 < vector_size(argv)) 
        {
            string_put(field 
                 , string_c_str(vector_item(argv, i+1)));
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Shift JIS
        // データをSjisエンコードとして扱う
        else if(strcmp(arg, "-s") == 0) {
            code = kSjis;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Eucjp
        // データをEucjpエンコードとして扱う
        else if(strcmp(arg, "-e") == 0) {
            code = kEucjp;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Utf-8
        // データをUtf-8エンコードとして扱う
        else if(strcmp(arg, "-w") == 0) {
            code = kUtf8;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as ASCII code
        // データをASCIIデータとして扱う
        else if(strcmp(arg, "-b") == 0) {
            code = kByte;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CR
        // 改行コードをCRとして扱う
        else if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(global) {
        if(multiline) {
            if(!statment_tree_internal_commands_scan_base(runinfo, argv, field, input, nextout, nextin, rcode, ignore_case, multiline, sname, sline, blocks, nexterr, code, lf)) {
                string_delete(field);
                return FALSE;
            }
            
            if(runinfo->enable_break && *runinfo->break_) {
                string_delete(field);
                return TRUE;
            }
            else if(runinfo->enable_return && *runinfo->return_) {
                string_delete(field);
                return TRUE;
            }
        }
        else {
            if(!statment_tree_internal_commands_scan_oneline_base(runinfo, argv, field, input, nextout, nextin, rcode, ignore_case, multiline, sname, sline, blocks, nexterr, code, lf)) {
                string_delete(field);
                return FALSE;
            }
            
            if(runinfo->enable_break && *runinfo->break_) {
                string_delete(field);
                return TRUE;
            }
            else if(runinfo->enable_return && *runinfo->return_) {
                string_delete(field);
                return TRUE;
            }
        }
    }
    else if(input) {
        int match_count = 0;

        if(vector_size(argv) >= 2) {
            if(line_oriented) {
                char* regex = string_c_str(vector_item(argv, 1));
                char* regex2 = regex;

                int n = 1;
                for(;;) {
                    string_obj* str = STRING_NEW("");
                    int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, str, lf);
                    if(ret == -1) {
                        err_msg("interrupt", sname, sline);
                        string_delete(field);
                        string_delete(str);
                        return FALSE;
                    }
                    else if(ret == 1) 
                    {
                        string_delete(str);
                        break;
                    }

                    string_chomp2(str, lf);
                    
                    if(!statment_tree_internal_commands_match_base(
                        string_c_str(str), regex2, rcode, nextout
                        , !quiet, line_field, line_num, n, field
                        , line_oriented, &match_count
                        , ignore_case
                        , multiline
                        , sname
                        , sline
                        , code
                        , lf
                        ))
                    {
                        string_delete(str);
                        string_delete(field);
                        return FALSE;
                    }

                    n++;

                    string_delete(str);
                }
            }
            else {
                char* regex = string_c_str(vector_item(argv, 1));
                char* regex2 = regex;

                int n = 0;
                string_obj* str = STRING_NEW("");
                BOOL ret = statment_tree_internal_commands_read_nextin(nextin, str);
                if(ret == 1) {
                    string_delete(str);
                    *rcode = 1;
                    return TRUE;
                }
                else if(ret < 0) {
                    err_msg("interrupt", sname, sline);
                    string_delete(field);
                    string_delete(str);
                    return FALSE;
                }
                
                if(!statment_tree_internal_commands_match_base(
                    string_c_str(str), regex2, rcode, nextout
                    , !quiet, line_field, line_num, n, field
                    , line_oriented, &match_count, ignore_case
                    , multiline
                    , sname
                    , sline
                    , code
                    , lf
                    ))
                {
                    string_delete(str);
                    string_delete(field);
                    return FALSE;
                }

                string_delete(str);
            }
        }

        char buf[256];
        snprintf(buf, 256, "%d", match_count);
        (void)saphire_set_local_var("MATCH_COUNT", buf, NULL);
    }
    else {
        int match_count = 0;

        string_obj* str;
        if(vector_size(argv) == 3) {
            str = STRING_NEW(string_c_str(vector_item(argv, 1)));
        }
        else {
            return TRUE;
        }

        char* str2 = string_c_str(str);

        char* regex = string_c_str(vector_item(argv, 2));
        char* regex2 = regex;

        if(!statment_tree_internal_commands_match_base(
            str2, regex2, rcode, nextout, !quiet, line_field
            , line_num, 1, field, line_oriented, &match_count
            , ignore_case
            , multiline
            , sname
            , sline
            , code
            , lf
            ))
        {
            string_delete(field);
            string_delete(str);
            return FALSE;
        }


        char buf[256];
        snprintf(buf, 256, "%d", match_count);
        (void)saphire_set_local_var("MATCH_COUNT", buf, NULL);

        string_delete(str);
    }

    string_delete(field);

    return TRUE;
}

BOOL statment_tree_internal_commands_sub(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL global = FALSE;
    BOOL quiet = FALSE;
    BOOL multiline = FALSE;
    BOOL check = FALSE;
    BOOL ignore_case = FALSE;
    enum eKanjiCode code = gKanjiCode;
    enum eLineField lf = gLineField;
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv, i));
        // global
        // global
        if(strcmp(arg, "-g") == 0) {
            global = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // take a STDIN pipe
        // 標準入力から受け取る
        else if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // ignore case
        // 英字の大文字小文字を無視する
        else if(strcmp(arg, "-i") == 0) {
            ignore_case = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // multiline
        // 複数行にまたぐ正規表現を許す
        else if(strcmp(arg, "-m") == 0) {
            multiline = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // no output
        // アウトプットしない
        else if(strcmp(arg, "-q") == 0) {
            quiet = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // check with user select
        // チェック
        else if(strcmp(arg, "-c") == 0) {
            check = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as ASCII code
        // データをASCIIデータとして扱う
        else if(strcmp(arg, "-b") == 0) {
            code = kByte;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Shift JIS
        // データをSjisエンコードとして扱う
        else if(strcmp(arg, "-s") == 0) {
            code = kSjis;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Eucjp
        // データをEucjpエンコードとして扱う
        else if(strcmp(arg, "-e") == 0) {
            code = kEucjp;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Utf-8
        // データをUtf-8エンコードとして扱う
        else if(strcmp(arg, "-w") == 0) {
            code = kUtf8;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CR
        // 改行コードをCRとして扱う
        else if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }
    if(multiline || !global) {
        if(!statment_tree_internal_commands_sub_base(runinfo, global, blocks, quiet, multiline, check, ignore_case, rcode, nextout, sname, sline, nextin, nexterr, code, input, argv))
        {
            return FALSE;
        }
    }
    else {
        if(!statment_tree_internal_commands_sub_base_oneline(runinfo, global, blocks, quiet, multiline, check, ignore_case, rcode, nextout, sname, sline, nextin, nexterr, code, input, argv, lf))
        {
            return FALSE;
        }
    }
    if(runinfo->enable_break && *runinfo->break_) {
        return TRUE;
    }
    else if(runinfo->enable_return && *runinfo->return_) {
        return TRUE;
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_gsub(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL global = TRUE;
    BOOL quiet = FALSE;
    BOOL multiline = FALSE;
    BOOL check = FALSE;
    BOOL ignore_case = FALSE;
    enum eKanjiCode code = gKanjiCode;
    enum eLineField lf = gLineField;
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv, i));
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // ignore case
        // 英字の大文字小文字を無視する
        else if(strcmp(arg, "-i") == 0) {
            ignore_case = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // multiline
        // 複数行にまたぐ正規表現を許す
        else if(strcmp(arg, "-m") == 0) {
            multiline = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // no output
        // アウトプットしない
        else if(strcmp(arg, "-q") == 0) {
            quiet = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // check with user select
        // チェック
        else if(strcmp(arg, "-c") == 0) {
            check = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as ASCII code
        // データをASCIIデータとして扱う
        else if(strcmp(arg, "-b") == 0) {
            code = kByte;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Shift JIS
        // データをSjisエンコードとして扱う
        else if(strcmp(arg, "-s") == 0) {
            code = kSjis;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Eucjp
        // データをEucjpエンコードとして扱う
        else if(strcmp(arg, "-e") == 0) {
            code = kEucjp;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Utf-8
        // データをUtf-8エンコードとして扱う
        else if(strcmp(arg, "-w") == 0) {
            code = kUtf8;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CR
        // 改行コードをCRとして扱う
        else if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(multiline) {
        if(!statment_tree_internal_commands_sub_base(runinfo, global, blocks, quiet, multiline, check, ignore_case, rcode, nextout, sname, sline, nextin, nexterr, code, input, argv))
        {
            return FALSE;
        }
    }
    else {
        if(!statment_tree_internal_commands_sub_base_oneline(runinfo, global, blocks, quiet, multiline, check, ignore_case, rcode, nextout, sname, sline, nextin, nexterr, code, input, argv, lf))
        {
            return FALSE;
        }
    }
    if(runinfo->enable_break && *runinfo->break_) {
        return TRUE;
    }
    else if(runinfo->enable_return && *runinfo->return_) {
        return TRUE;
    }

    return TRUE;
}
BOOL statment_tree_internal_commands_add(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL flg_n = FALSE;
    int n;
    BOOL flg_l = FALSE;
    int l;
    enum eKanjiCode code = gKanjiCode;
    enum eLineField lf = gLineField;

    int k;
    for(k=0; k<vector_size(argv); k++) {
        char* arg = string_c_str(vector_item(argv, k));

        // add at Nth character
        // n文字目から
        if(strcmp(arg, "-n") == 0 && k+1 < vector_size(argv)) {
            flg_n = TRUE;
            n = atoi(string_c_str(vector_item(argv, k+1)));
            string_delete(vector_item(argv, k));
            vector_erase(argv, k);
            string_delete(vector_item(argv, k));
            vector_erase(argv, k);
            k--;
            continue;
        }
        // add at Nth line
        // N行に加える
        else if(strcmp(arg, "-L") == 0 && k+1 < vector_size(argv)) {
            flg_l = TRUE;
            l = atoi(string_c_str(vector_item(argv, k+1)));
            string_delete(vector_item(argv, k));
            vector_erase(argv, k);
            string_delete(vector_item(argv, k));
            vector_erase(argv, k);
            k--;
            continue;
        }
        // assume data as ASCII code
        // データをASCIIデータとして扱う
        else if(strcmp(arg, "-b") == 0) {
            code = kByte;
            string_delete(vector_item(argv, k));
            vector_erase(argv, k);
            k--;
            continue;
        }
        // assume data as Shift JIS
        // データをSjisエンコードとして扱う
        else if(strcmp(arg, "-s") == 0) {
            code = kSjis;
            string_delete(vector_item(argv, k));
            vector_erase(argv, k);
            k--;
            continue;
        }
        // assume data as Eucjp
        // データをEucjpエンコードとして扱う
        else if(strcmp(arg, "-e") == 0) {
            code = kEucjp;
            string_delete(vector_item(argv, k));
            vector_erase(argv, k);
            k--;
            continue;
        }
        // assume data as Utf-8
        // データをUtf-8エンコードとして扱う
        else if(strcmp(arg, "-w") == 0) {
            code = kUtf8;
            string_delete(vector_item(argv, k));
            vector_erase(argv, k);
            k--;
            continue;
        }
        // treat line field as CR
        // 改行コードをCRとして扱う
        else if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, k));
            vector_erase(argv, k);
            k--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, k));
            vector_erase(argv, k);
            k--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, k));
            vector_erase(argv, k);
            k--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, k));
            vector_erase(argv, k);
            k--;
            continue;
        }
    }

    string_obj* str_ = STRING_NEW("");
    if(vector_size(blocks) >= 1) {
        int j;
        for(j=0; j<vector_size(blocks); j++) {
            sWFd* nextout2 = WFD_NEW(-1);
            sBlock* block = vector_item(blocks, j);
            sStatments* statments = block->mStatments;
            char* fname = MALLOC(strlen(sname) + 32);
            snprintf(fname, strlen(sname) + 32, "%s %d: add", sname, sline);
            *rcode = run(runinfo, statments, fname, nextout2 , nextin, nexterr, FALSE);
            FREE(fname);

            if(!string_push_back_cancelable(str_, nextout2->mBuffer))
            {
                sWFd_delete(nextout2);
                string_delete(str_);
                return FALSE;
            }

            sWFd_delete(nextout2);

            if(runinfo->enable_break && *runinfo->break_) {
                string_delete(str_);
                return TRUE;
            }
            else if(runinfo->enable_return && *runinfo->return_) {
                string_delete(str_);
                return TRUE;
            }
            else if(*rcode < 0) {
                string_delete(str_);
                return FALSE;
            }
        }
    }
    else if(vector_size(argv) >= 2) {
        int j;
        for(j=1; j<vector_size(argv); j++) {
            string_push_back(str_, string_c_str(vector_item(argv, j)));
        }
    }
    else {
        string_delete(str_);
        return TRUE;
    }

    if(flg_l) {
        vector_obj* v = VECTOR_NEW(100);

        while(1) {
            if(gKitutukiSigInt) {
                gKitutukiSigInt = FALSE;
                err_msg("interrupt c", sname, sline);
                *rcode = 1;
                string_delete(str_);
                int i;
                for(i=0; i<vector_size(v); i++) {
                    string_delete(vector_item(v, i));
                }
                vector_delete(v);
                return FALSE;
            }
            string_obj* line = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, line, lf);
            if(ret == -1) {
                err_msg("interrupt d", sname, sline);
                string_delete(line);
                string_delete(str_);
                int i;
                for(i=0; i<vector_size(v); i++) {
                    string_delete(vector_item(v, i));
                }
                vector_delete(v);
                return FALSE;
            }
            else if(ret == 1) {
                string_delete(line);
                return TRUE;
            }

            vector_add(v, line);
        }

        if(l < 0) {
            l+=vector_size(v)+1;
        }
        if(l < 0) {
            l = 0;
        }
        if(l > vector_size(v)) {
            l = vector_size(v);
        }

        if(l < vector_size(v)) {
            int k;
            for(k=0; k<l; k++) {
                char* str = string_c_str(vector_item(v, k));

                if(!statment_tree_internal_commands_write_nextout(nextout, str))
                {
                    err_msg("singal interrupt", sname, sline);
                    string_delete(str_);
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        string_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    return FALSE;
                }
            }

            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str_)))
            {
                err_msg("singal interrupt", sname, sline);
                string_delete(str_);
                int i;
                for(i=0; i<vector_size(v); i++) {
                    string_delete(vector_item(v, i));
                }
                vector_delete(v);
                return FALSE;
            }

            for(k=l; k<vector_size(v); k++) {
                char* str = string_c_str(vector_item(v, k));

                if(!statment_tree_internal_commands_write_nextout(nextout, str))
                {
                    err_msg("singal interrupt", sname, sline);
                    string_delete(str_);
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        string_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    return FALSE;
                }
            }

            *rcode = 0;
        }
        else {
            int k;
            for(k=0; k<vector_size(v); k++) {
                char* str = string_c_str(vector_item(v, k));

                if(!statment_tree_internal_commands_write_nextout(nextout, str))
                {
                    err_msg("singal interrupt", sname, sline);
                    string_delete(str_);
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        string_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    return FALSE;
                }
            }
            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str_)))
            {
                err_msg("singal interrupt", sname, sline);
                string_delete(str_);
                int i;
                for(i=0; i<vector_size(v); i++) {
                    string_delete(vector_item(v, i));
                }
                vector_delete(v);
                return FALSE;
            }

            *rcode = 0;
        }

        int i;
        for(i=0; i<vector_size(v); i++) {
            string_delete(vector_item(v, i));
        }
        vector_delete(v);
    }
    else if(flg_n) {
        string_obj* str = STRING_NEW("");

        int ret = statment_tree_internal_commands_read_nextin(nextin, str);
        if(ret < 0) 
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            string_delete(str_);
            return FALSE;
        }
        else if(ret == 1) {
            *rcode = 1;
            string_delete(str_);
            string_delete(str);
            return TRUE;
        }
        else
        {
            char* str2 = string_c_str(str_);
            if(n < 0) {
                n = str_kanjilen(code, string_c_str(str)) + n + 1;
            }

            if(n < 0 || n > str_kanjilen(code, string_c_str(str))) 
            {
                *rcode = 1;
                string_delete(str_);
                string_delete(str);
                return TRUE;
            }

            int m = str_kanjipos2pointer(code, string_c_str(str), n) - string_c_str(str);
            string_insert(str, m, str2);

            if(!statment_tree_internal_commands_write_nextout(nextout,  string_c_str(str)))
            {
                err_msg("singal interrupt", sname, sline);
                string_delete(str_);
                string_delete(str);
                return FALSE;
            }
            *rcode = 0;
        }

        string_delete(str);
    }
    else {
        string_obj* str = STRING_NEW("");

        int ret = statment_tree_internal_commands_read_nextin(nextin, str);
        if(ret < 0)
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            string_delete(str_);
            return FALSE;
        }
        else if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            string_delete(str_);
            return TRUE;
        }
        else {
            char* str2 = string_c_str(str_);

            if(!string_push_back_cancelable(str, str2))
            {
                err_msg("signal interrupt", sname, sline);
                string_delete(str);
                string_delete(str_);
                return FALSE;
            }

            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
            {
                err_msg("signal interrupt", sname, sline);
                string_delete(str);
                string_delete(str_);
                return FALSE;
            }

            *rcode = 0;
        }

        string_delete(str);
    }

    string_delete(str_);

    return TRUE;
}

BOOL statment_tree_internal_commands_del(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL flg_n = FALSE;
    int n;
    enum eKanjiCode code = gKanjiCode;
    BOOL flg_l = FALSE;
    int L;
    enum eLineField lf = gLineField;

    int l;
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        // add at Nth character
        // n文字目から
        if(strcmp(arg, "-n") == 0 && l+1 < vector_size(argv)) {
            flg_n = TRUE;
            n = atoi(string_c_str(vector_item(argv, l+1)));
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // del Nth line
        // N行を削除する
        else if(strcmp(arg, "-L") == 0 && l+1 < vector_size(argv)) {
            flg_l = TRUE;
            L = atoi(string_c_str(vector_item(argv, l+1)));
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // assume data as ASCII code
        // データをASCIIデータとして扱う
        else if(strcmp(arg, "-b") == 0) {
            code = kByte;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // assume data as Shift JIS
        // データをSjisエンコードとして扱う
        else if(strcmp(arg, "-s") == 0) {
            code = kSjis;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // assume data as Eucjp
        // データをEucjpエンコードとして扱う
        else if(strcmp(arg, "-e") == 0) {
            code = kEucjp;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // assume data as Utf-8
        // データをUtf-8エンコードとして扱う
        else if(strcmp(arg, "-w") == 0) {
            code = kUtf8;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // treat line field as CR
        // 改行コードをCRとして扱う
        else if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(flg_l) {
        int N;
        if(vector_size(argv) >= 2) {
            N = atoi(string_c_str(vector_item(argv, 1)));
            if(N < 1) {
                N = 1;
            }
        }
        else {
            N = 1;
        }
        vector_obj* v = VECTOR_NEW(100);

        while(1) {
            if(gKitutukiSigInt) {
                gKitutukiSigInt = FALSE;
                err_msg("interrupt", sname, sline);
                *rcode = 1;
                int i;
                for(i=0; i<vector_size(v); i++) {
                    string_delete(vector_item(v, i));
                }
                vector_delete(v);
                return FALSE;
            }
            string_obj* line = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, line, lf);
            if(ret == -1) {
                err_msg("interrupt", sname, sline);
                int i;
                for(i=0; i<vector_size(v); i++) {
                    string_delete(vector_item(v, i));
                }
                vector_delete(v);
                return FALSE;
            }
            else if(ret == 1) { // EOF
                string_delete(line);
                return TRUE;
            }

            vector_add(v, line);
        }

        if(L < 0) {
            L+=vector_size(v);
        }
        if(L < 0 || L >= vector_size(v)) {
            *rcode = 1;

            int k;
            for(k=0; k<vector_size(v); k++) {
                char* str = string_c_str(vector_item(v, k));

                if(!statment_tree_internal_commands_write_nextout(nextout, str))
                {
                    err_msg("singal interrupt", sname, sline);
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        string_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    return FALSE;
                }
            }

            int i;
            for(i=0; i<vector_size(v); i++) {
                string_delete(vector_item(v, i));
            }
            vector_delete(v);
            return TRUE;
        }

        if(L < vector_size(v)) {
            int k;
            for(k=0; k<L; k++) {
                char* str = string_c_str(vector_item(v, k));

                if(!statment_tree_internal_commands_write_nextout(nextout, str))
                {
                    err_msg("singal interrupt", sname, sline);
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        string_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    return FALSE;
                }
            }

            for(k=L + N; k<vector_size(v); k++) {
                char* str = string_c_str(vector_item(v, k));

                if(!statment_tree_internal_commands_write_nextout(nextout, str))
                {
                    err_msg("singal interrupt", sname, sline);
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        string_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    return FALSE;
                }
            }

            *rcode = 0;
        }

        int i;
        for(i=0; i<vector_size(v); i++) {
            string_delete(vector_item(v, i));
        }
        vector_delete(v);
    }
    else if(flg_n) {
        string_obj* str = STRING_NEW("");

        int ret = statment_tree_internal_commands_read_nextin(nextin, str);
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret == -1)
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }
        else {
            int num;
            if(vector_size(argv) >= 2) {
                char* arg1 = string_c_str(vector_item(argv, 1));
                num = atoi(arg1);
            }
            else {
                num = 1;
            }

            if(n < 0) {
                n = str_kanjilen(code, string_c_str(str)) + n;
            }

            if(n < 0 || n > str_kanjilen(code, string_c_str(str))) {
                *rcode = 1;
                string_delete(str);
                return TRUE;
            }

            int m = str_kanjipos2pointer(code, string_c_str(str), n) - string_c_str(str);
            int l = str_kanjipos2pointer(code, string_c_str(str), n+num) - string_c_str(str);
            string_erase(str, m, l-m);

            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
            {
                err_msg("signal interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }
            *rcode = 0;
        }

        string_delete(str);
    }
    else {
        string_obj* str = STRING_NEW("");

        int ret = statment_tree_internal_commands_read_nextin(nextin, str);
        if(ret == 1)
        {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }
        else {
            int num;
            if(vector_size(argv) >= 2) {
                char* arg1 = string_c_str(vector_item(argv, 1));
                num = atoi(arg1);
            }
            else {
                num = 1;
            }

            int m = str_kanjipos2pointer(code, string_c_str(str), str_kanjilen(code, string_c_str(str))-num) - string_c_str(str);
            
            string_trunc(str, m);

            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
            {
                err_msg("signal interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }

            *rcode = 0;
        }

        string_delete(str);
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_x(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    BOOL line_field = FALSE;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // when output the variant content, add LF at tail
        // 出力するとき改行も加える
        if(strcmp(arg, "-L") == 0) {
            line_field = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // take a STDIN pipe
        // 標準入力から受け取る
        else if(strcmp(arg, "-I") == 0) 
        {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    int count;
    string_obj* str;
    if(vector_size(argv) == 3) {
        str = STRING_NEW(string_c_str(vector_item(argv, 1)));
        count = atoi(string_c_str(vector_item(argv, 2)));
    }
    else if(vector_size(argv) == 2 && input) {
        count = atoi(string_c_str(vector_item(argv, 1)));
        str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str);
        if(ret == 1) {
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }
    }
    else {
        err_msg("invalid argument with x", sname, sline);
        return FALSE;
    }

    for(i=0; i<count; i++) {
        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
        {
            err_msg("signal interrupt2", sname, sline);
            string_delete(str);
            return FALSE;
        }
    }

    if(line_field) {
        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
        {
            err_msg("singal interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }
    }

    *rcode = 0;

    string_delete(str);

    return TRUE;
}

BOOL statment_tree_internal_commands_join(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    BOOL bash_quote = FALSE;
    BOOL saphire_quote = FALSE;
    enum eLineField lf = gLineField;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv, i));
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // quote character with used by saphire
        // saphireで使う文字列でクォートする
        else if(strcmp(arg, "-q") == 0) {
            saphire_quote = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // quote character with used by bash
        // bashで使う文字列でクォートする
        else if(strcmp(arg, "-Q") == 0) {
            bash_quote = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CR
        // 改行コードをCRとして扱う
        else if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(input) {
        char* field;
        if(vector_size(argv) == 2) {
            field = string_c_str(vector_item(argv, 1));
        }
        else {
            field = " ";
        }

        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str);
        if(ret == 1) {
            string_delete(str);
            *rcode = 1;
            return TRUE;
        }
        else if(ret < 0)
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }
        else {
            string_chomp2(str, lf);
            char* p = string_c_str(str);
            string_obj* buf = STRING_NEW("");
            while(*p) {
                if(gKitutukiSigInt) {
                    err_msg("interrupt", sname, sline);
                    string_delete(buf);
                    string_delete(str);
                    return FALSE;
                }
                if(is_line_field2(lf, p)) {
                    if(bash_quote) {
                        string_obj* quoted = STRING_NEW("");
                        bash_get_quoted_fname(string_c_str(buf), quoted);
                        string_put(buf, string_c_str(quoted));
                        string_delete(quoted);
                    }
                    else if(saphire_quote) {
                        string_obj* quoted = STRING_NEW("");
                        saphire_get_quoted_fname(string_c_str(buf), quoted);
                        string_put(buf, string_c_str(quoted));
                        string_delete(quoted);
                    }

                    if(lf == kCRLF) {
                        p+=2;
                    }
                    else {
                        p++;
                    }
                    string_push_back(buf, field);

                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(buf)))
                    {
                        err_msg("signal interrupt", sname, sline);
                        string_delete(str);
                        string_delete(buf);
                        return FALSE;
                    }

                    string_put(buf, "");
                }
                else {
                    string_push_back2(buf, *p++);
                }
            }

            if(strcmp(string_c_str(buf), "") != 0) {
                if(bash_quote) {
                    string_obj* quoted = STRING_NEW("");
                    bash_get_quoted_fname(string_c_str(buf), quoted);
                    string_put(buf, string_c_str(quoted));

                    string_delete(quoted);
                }
                else if(saphire_quote) {
                    string_obj* quoted = STRING_NEW("");
                    saphire_get_quoted_fname(string_c_str(buf), quoted);
                    string_put(buf, string_c_str(quoted));
                    string_delete(quoted);
                }

                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(buf)))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(str);
                    string_delete(buf);
                    return FALSE;
                }
            }

            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                string_delete(str);
                string_delete(buf);
                return FALSE;
            }

            *rcode = 0;

            string_delete(buf);
        }

        string_delete(str);
    }
    else if(vector_size(argv) > 1) {
        char* field;
        if(vector_size(argv) == 2) {
            field = " ";
        }
        else {
            field = string_c_str(vector_item(argv, 2));
        }

        char* p = string_c_str(vector_item(argv, 1));
        string_obj* buf = STRING_NEW("");
        while(*p) {
            if(gKitutukiSigInt) {
                err_msg("interrupt", sname, sline);
                string_delete(buf);
                return FALSE;
            }
            if(is_line_field2(lf, p)) {
                if(lf == kCRLF) {
                    p+=2;
                }
                else {
                    p++;
                }
                if(bash_quote) {
                    string_obj* quoted = STRING_NEW("");
                    bash_get_quoted_fname(string_c_str(buf), quoted);
                    string_put(buf, string_c_str(quoted));

                    string_delete(quoted);
                }
                else if(saphire_quote) {
                    string_obj* quoted = STRING_NEW("");
                    saphire_get_quoted_fname(string_c_str(buf), quoted);
                    string_put(buf, string_c_str(quoted));
                    string_delete(quoted);
                }
                string_push_back(buf, field);

                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(buf)))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(buf);
                    return FALSE;
                }

                string_put(buf, "");
            }
            else {
                string_push_back2(buf, *p++);
            }
        }

        if(strcmp(string_c_str(buf), "") != 0) {
            if(bash_quote) {
                string_obj* quoted = STRING_NEW("");
                bash_get_quoted_fname(string_c_str(buf), quoted);
                string_put(buf, string_c_str(quoted));
                string_delete(quoted);
            }
            else if(saphire_quote) {
                string_obj* quoted = STRING_NEW("");
                saphire_get_quoted_fname(string_c_str(buf), quoted);
                string_put(buf, string_c_str(quoted));
                string_delete(quoted);
            }
            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(buf)))
            {
                err_msg("signal interrupt", sname, sline);
                string_delete(buf);
                return FALSE;
            }
        }

        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
        {
            err_msg("singal interrupt", sname, sline);
            string_delete(buf);
            return FALSE;
        }

        *rcode = 0;

        string_delete(buf);
    }

    return TRUE;
}
