/*
 * その他のルーチン
 */


#ifndef MINATO_EXTRA_H
#define MINATO_EXTRA_H

#ifndef BOOL
#define BOOL int
#endif

#define TRUE 1
#define FALSE 0

#define ALLOC                   // freeが必要なメモリを返す
#define SPACE                   // 十分なスペースが必要な場合
#define MANAGED                 // フリーされるメモリ

#define P(F, O) { FILE* fp = fopen(F, "a"); fprintf(fp, O); fprintf(fp, "\n"); fclose(fp); }

void mygetcwd(SPACE char* result, int result_size);                  // cwdを返す
void parentname(SPACE char* result, int result_size, char* path);    // 親ディレクトリを返す
void extname(SPACE char* result, int result_size, char* name);       // 拡張子を返す
void noextname(SPACE char* result, int result_size, char* name);     // 拡張子以外のファイル名を返す
void mystrtolower(char* result);           // 文字列を小文字にする

int correct_path(char* current_path, char* path, char* path2, int path2_size);                                        // パスの(えせ)正規化

char* mystrcasestr(const char *haystack, const char *needle); // 部分文字列を返す

char* xstrncpy(char* src, char* des, int size);
char* xstrncat(char* src, char* des, int size);


#endif

