/* rygel-media-export-item-factory.c generated by valac 0.40.8, the Vala compiler
 * generated from rygel-media-export-item-factory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2012,2013 Intel Corporation.
 * Copyright (C) 2015 Jens Georg
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *         Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-server.h>
#include <gio/gio.h>

#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY (rygel_media_export_object_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactory))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))

typedef struct _RygelMediaExportObjectFactory RygelMediaExportObjectFactory;
typedef struct _RygelMediaExportObjectFactoryClass RygelMediaExportObjectFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM (rygel_media_export_music_item_get_type ())
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItem))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))

typedef struct _RygelMediaExportMusicItem RygelMediaExportMusicItem;
typedef struct _RygelMediaExportMusicItemClass RygelMediaExportMusicItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT (rygel_media_export_updatable_object_get_type ())
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObject))
#define RYGEL_MEDIA_EXPORT_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT))
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObjectIface))

typedef struct _RygelMediaExportUpdatableObject RygelMediaExportUpdatableObject;
typedef struct _RygelMediaExportUpdatableObjectIface RygelMediaExportUpdatableObjectIface;
typedef struct _RygelMediaExportMusicItemPrivate RygelMediaExportMusicItemPrivate;
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))

typedef enum  {
	RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_DESERIALIZATION,
	RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_MISMATCH
} RygelMediaExportItemFactoryItemFactoryError;
#define RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR rygel_media_export_item_factory_item_factory_error_quark ()
struct _RygelMediaExportUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit_custom) (RygelMediaExportUpdatableObject* self, gboolean override_guarded, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_custom_finish) (RygelMediaExportUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportMusicItem {
	RygelMusicItem parent_instance;
	RygelMediaExportMusicItemPrivate * priv;
	gint disc;
};

struct _RygelMediaExportMusicItemClass {
	RygelMusicItemClass parent_class;
};



GQuark rygel_media_export_item_factory_item_factory_error_quark (void);
gboolean rygel_media_export_item_factory_check_variant_type (GVariant* v,
                                                             const gchar* typestring,
                                                             GError** error);
RygelMediaObject* rygel_media_export_item_factory_create (RygelMediaContainer* parent,
                                                          GVariantDict* vd);
#define RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS "UPnPClass"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_ID "Id"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_TITLE "Title"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_URI "Uri"
GType rygel_media_export_object_factory_get_type (void) G_GNUC_CONST;
RygelMediaExportObjectFactory* rygel_media_export_object_factory_new (void);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_construct (GType object_type);
RygelMediaContainer* rygel_media_export_object_factory_get_container (RygelMediaExportObjectFactory* self,
                                                                      const gchar* id,
                                                                      const gchar* title,
                                                                      guint child_count,
                                                                      const gchar* uri);
RygelMediaFileItem* rygel_media_export_object_factory_get_item (RygelMediaExportObjectFactory* self,
                                                                RygelMediaContainer* parent,
                                                                const gchar* id,
                                                                const gchar* title,
                                                                const gchar* upnp_class);
gint64 rygel_media_export_item_factory_get_int64 (GVariantDict* vd,
                                                  const gchar* key);
gint32 rygel_media_export_item_factory_get_int32 (GVariantDict* vd,
                                                  const gchar* key);
RygelMediaObject* rygel_media_export_item_factory_create_from_variant (RygelMediaContainer* parent,
                                                                       GFile* file,
                                                                       GVariant* v,
                                                                       GError** error);
#define RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE "MimeType"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_SIZE "Size"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_MODIFIED "MTime"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_DLNA_PROFILE "DLNAProfile"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_DATE "Date"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_DURATION "Duration"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_BITRATE "AudioBitrate"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_CHANNELS "AudioChannels"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_RATE "AudioRate"
GType rygel_media_export_music_item_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_SERIALIZER_ARTIST "Artist"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_ALBUM "Album"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_GENRE "Genre"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_TRACK_NUMBER "TrackNumber"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VOLUME_NUMBER "VolumeNumber"
GType rygel_media_export_updatable_object_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_WIDTH "VideoWidth"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_HEIGHT "VideoHeight"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_DEPTH "VideoDepth"
void rygel_media_export_item_factory_apply_meta_data (RygelMediaFileItem* item,
                                                      GVariant* v,
                                                      GError** error);
void rygel_media_export_item_factory_apply_video_info (RygelMediaFileItem* item,
                                                       GVariant* v,
                                                       GError** error);
void rygel_media_export_item_factory_apply_audio_info (RygelMediaFileItem* item,
                                                       GVariant* v,
                                                       GError** error);
void rygel_media_export_item_factory_apply_info (RygelMediaFileItem* item,
                                                 GVariant* v,
                                                 GError** error);
void rygel_media_export_item_factory_apply_dlna_profile (RygelMediaFileItem* item,
                                                         GVariant* v,
                                                         GError** error);
void rygel_media_export_item_factory_apply_file_info (RygelMediaObject* object,
                                                      GVariant* v,
                                                      GError** error);


GQuark
rygel_media_export_item_factory_item_factory_error_quark (void)
{
	return g_quark_from_static_string ("rygel_media_export_item_factory_item_factory_error-quark");
}


gboolean
rygel_media_export_item_factory_check_variant_type (GVariant* v,
                                                    const gchar* typestring,
                                                    GError** error)
{
	gboolean result = FALSE;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (v != NULL, FALSE);
	g_return_val_if_fail (typestring != NULL, FALSE);
	_tmp0_ = g_variant_type_new (typestring);
	_tmp1_ = _tmp0_;
	_tmp2_ = !g_variant_is_of_type (v, _tmp1_);
	_g_variant_type_free0 (_tmp1_);
	if (_tmp2_) {
		gchar* msg = NULL;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GError* _tmp6_;
		gboolean _tmp7_ = FALSE;
		_tmp3_ = g_strdup ("Variant type mismatch, expected %s, got %s");
		msg = _tmp3_;
		_tmp4_ = msg;
		_tmp5_ = g_variant_get_type_string (v);
		_tmp6_ = g_error_new (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR, RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_DESERIALIZATION, _tmp4_, _tmp5_, typestring);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		return _tmp7_;
	}
	result = TRUE;
	return result;
}


RygelMediaObject*
rygel_media_export_item_factory_create (RygelMediaContainer* parent,
                                        GVariantDict* vd)
{
	RygelMediaObject* result = NULL;
	GVariantType* expected = NULL;
	RygelMediaObject* object = NULL;
	GVariant* upnp_class = NULL;
	const GVariantType* _tmp0_;
	GVariant* _tmp1_;
	GVariant* id = NULL;
	const GVariantType* _tmp2_;
	GVariant* _tmp3_;
	GVariant* title = NULL;
	const GVariantType* _tmp4_;
	GVariant* _tmp5_;
	GVariant* uri = NULL;
	const GVariantType* _tmp6_;
	GVariant* _tmp7_;
	RygelMediaExportObjectFactory* factory = NULL;
	RygelMediaExportObjectFactory* _tmp8_;
	GVariant* _tmp9_;
	const gchar* _tmp10_;
	RygelMediaObject* _tmp27_;
	GVariant* _tmp28_;
	const gchar* _tmp29_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (vd != NULL, NULL);
	expected = NULL;
	object = NULL;
	_tmp0_ = expected;
	_tmp1_ = g_variant_dict_lookup_value (vd, RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS, _tmp0_);
	upnp_class = _tmp1_;
	_tmp2_ = expected;
	_tmp3_ = g_variant_dict_lookup_value (vd, RYGEL_MEDIA_EXPORT_SERIALIZER_ID, _tmp2_);
	id = _tmp3_;
	_tmp4_ = expected;
	_tmp5_ = g_variant_dict_lookup_value (vd, RYGEL_MEDIA_EXPORT_SERIALIZER_TITLE, _tmp4_);
	title = _tmp5_;
	_tmp6_ = expected;
	_tmp7_ = g_variant_dict_lookup_value (vd, RYGEL_MEDIA_EXPORT_SERIALIZER_URI, _tmp6_);
	uri = _tmp7_;
	_tmp8_ = rygel_media_export_object_factory_new ();
	factory = _tmp8_;
	_tmp9_ = upnp_class;
	_tmp10_ = g_variant_get_string (_tmp9_, NULL);
	if (g_str_has_prefix (_tmp10_, RYGEL_MEDIA_CONTAINER_UPNP_CLASS)) {
		RygelMediaExportObjectFactory* _tmp11_;
		GVariant* _tmp12_;
		const gchar* _tmp13_;
		GVariant* _tmp14_;
		const gchar* _tmp15_;
		GVariant* _tmp16_;
		const gchar* _tmp17_;
		RygelMediaContainer* _tmp18_;
		_tmp11_ = factory;
		_tmp12_ = id;
		_tmp13_ = g_variant_get_string (_tmp12_, NULL);
		_tmp14_ = title;
		_tmp15_ = g_variant_get_string (_tmp14_, NULL);
		_tmp16_ = uri;
		_tmp17_ = g_variant_get_string (_tmp16_, NULL);
		_tmp18_ = rygel_media_export_object_factory_get_container (_tmp11_, _tmp13_, _tmp15_, (guint) 0, _tmp17_);
		_g_object_unref0 (object);
		object = (RygelMediaObject*) _tmp18_;
	} else {
		RygelMediaExportObjectFactory* _tmp19_;
		GVariant* _tmp20_;
		const gchar* _tmp21_;
		GVariant* _tmp22_;
		const gchar* _tmp23_;
		GVariant* _tmp24_;
		const gchar* _tmp25_;
		RygelMediaFileItem* _tmp26_;
		_tmp19_ = factory;
		_tmp20_ = id;
		_tmp21_ = g_variant_get_string (_tmp20_, NULL);
		_tmp22_ = title;
		_tmp23_ = g_variant_get_string (_tmp22_, NULL);
		_tmp24_ = upnp_class;
		_tmp25_ = g_variant_get_string (_tmp24_, NULL);
		_tmp26_ = rygel_media_export_object_factory_get_item (_tmp19_, parent, _tmp21_, _tmp23_, _tmp25_);
		_g_object_unref0 (object);
		object = (RygelMediaObject*) _tmp26_;
	}
	_tmp27_ = object;
	_tmp28_ = uri;
	_tmp29_ = g_variant_get_string (_tmp28_, NULL);
	rygel_media_object_add_uri (_tmp27_, _tmp29_);
	result = object;
	_g_object_unref0 (factory);
	_g_variant_unref0 (uri);
	_g_variant_unref0 (title);
	_g_variant_unref0 (id);
	_g_variant_unref0 (upnp_class);
	_g_variant_type_free0 (expected);
	return result;
}


gint64
rygel_media_export_item_factory_get_int64 (GVariantDict* vd,
                                           const gchar* key)
{
	gint64 result = 0LL;
	GVariant* val = NULL;
	const GVariantType* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_return_val_if_fail (vd != NULL, 0LL);
	g_return_val_if_fail (key != NULL, 0LL);
	_tmp0_ = G_VARIANT_TYPE_UINT64;
	_tmp1_ = g_variant_dict_lookup_value (vd, key, _tmp0_);
	val = _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ != NULL) {
		GVariant* _tmp3_;
		_tmp3_ = val;
		result = (gint64) g_variant_get_uint64 (_tmp3_);
		_g_variant_unref0 (val);
		return result;
	}
	result = (gint64) -1;
	_g_variant_unref0 (val);
	return result;
}


gint32
rygel_media_export_item_factory_get_int32 (GVariantDict* vd,
                                           const gchar* key)
{
	gint32 result = 0;
	GVariant* val = NULL;
	const GVariantType* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_return_val_if_fail (vd != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_tmp0_ = G_VARIANT_TYPE_INT32;
	_tmp1_ = g_variant_dict_lookup_value (vd, key, _tmp0_);
	val = _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ != NULL) {
		GVariant* _tmp3_;
		_tmp3_ = val;
		result = g_variant_get_int32 (_tmp3_);
		_g_variant_unref0 (val);
		return result;
	}
	result = (gint32) -1;
	_g_variant_unref0 (val);
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


RygelMediaObject*
rygel_media_export_item_factory_create_from_variant (RygelMediaContainer* parent,
                                                     GFile* file,
                                                     GVariant* v,
                                                     GError** error)
{
	RygelMediaObject* result = NULL;
	GVariantType* expected = NULL;
	GVariantDict* vd = NULL;
	GVariantDict* _tmp0_;
	GVariant* upnp_class = NULL;
	GVariantDict* _tmp1_;
	const GVariantType* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	RygelMediaObject* object = NULL;
	GVariantDict* _tmp5_;
	RygelMediaObject* _tmp6_;
	RygelMediaObject* _tmp7_;
	RygelMediaFileItem* item = NULL;
	RygelMediaObject* _tmp8_;
	RygelMediaFileItem* _tmp9_;
	GVariant* val = NULL;
	GVariantDict* _tmp10_;
	const GVariantType* _tmp11_;
	GVariant* _tmp12_;
	RygelMediaFileItem* _tmp13_;
	GVariant* _tmp14_;
	const gchar* _tmp15_;
	RygelMediaFileItem* _tmp16_;
	GVariantDict* _tmp17_;
	GVariantDict* _tmp18_;
	const GVariantType* _tmp19_;
	GVariant* _tmp20_;
	RygelMediaFileItem* _tmp21_;
	GVariant* _tmp22_;
	GVariantDict* _tmp23_;
	const GVariantType* _tmp24_;
	GVariant* _tmp25_;
	GVariant* _tmp26_;
	GVariantDict* _tmp30_;
	const GVariantType* _tmp31_;
	GVariant* _tmp32_;
	GVariant* _tmp33_;
	RygelMediaFileItem* _tmp37_;
	RygelMediaFileItem* _tmp76_;
	RygelMediaFileItem* _tmp85_;
	RygelMediaObject* _tmp86_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	expected = NULL;
	if (v == NULL) {
		result = NULL;
		_g_variant_type_free0 (expected);
		return result;
	}
	rygel_media_export_item_factory_check_variant_type (v, "a{sv}", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_variant_type_free0 (expected);
		return NULL;
	}
	_tmp0_ = g_variant_dict_new (v);
	vd = _tmp0_;
	_tmp1_ = vd;
	_tmp2_ = expected;
	_tmp3_ = g_variant_dict_lookup_value (_tmp1_, RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS, _tmp2_);
	upnp_class = _tmp3_;
	_tmp4_ = upnp_class;
	if (_tmp4_ == NULL) {
		g_debug ("rygel-media-export-item-factory.vala:115: Did not find a UPnP class fo" \
"r item, ignoring");
		result = NULL;
		_g_variant_unref0 (upnp_class);
		_g_variant_dict_unref0 (vd);
		_g_variant_type_free0 (expected);
		return result;
	}
	_tmp5_ = vd;
	_tmp6_ = rygel_media_export_item_factory_create (parent, _tmp5_);
	object = _tmp6_;
	_tmp7_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, RYGEL_TYPE_MEDIA_CONTAINER)) {
		result = object;
		_g_variant_unref0 (upnp_class);
		_g_variant_dict_unref0 (vd);
		_g_variant_type_free0 (expected);
		return result;
	}
	_tmp8_ = object;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp8_) : NULL);
	item = _tmp9_;
	_tmp10_ = vd;
	_tmp11_ = expected;
	_tmp12_ = g_variant_dict_lookup_value (_tmp10_, RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE, _tmp11_);
	val = _tmp12_;
	_tmp13_ = item;
	_tmp14_ = val;
	_tmp15_ = g_variant_get_string (_tmp14_, NULL);
	rygel_media_file_item_set_mime_type (_tmp13_, _tmp15_);
	_tmp16_ = item;
	_tmp17_ = vd;
	rygel_media_file_item_set_size (_tmp16_, rygel_media_export_item_factory_get_int64 (_tmp17_, RYGEL_MEDIA_EXPORT_SERIALIZER_SIZE));
	_tmp18_ = vd;
	_tmp19_ = expected;
	_tmp20_ = g_variant_dict_lookup_value (_tmp18_, RYGEL_MEDIA_EXPORT_SERIALIZER_MODIFIED, _tmp19_);
	_g_variant_unref0 (val);
	val = _tmp20_;
	_tmp21_ = item;
	_tmp22_ = val;
	rygel_media_object_set_modified ((RygelMediaObject*) _tmp21_, g_variant_get_uint64 (_tmp22_));
	_tmp23_ = vd;
	_tmp24_ = expected;
	_tmp25_ = g_variant_dict_lookup_value (_tmp23_, RYGEL_MEDIA_EXPORT_SERIALIZER_DLNA_PROFILE, _tmp24_);
	_g_variant_unref0 (val);
	val = _tmp25_;
	_tmp26_ = val;
	if (_tmp26_ != NULL) {
		RygelMediaFileItem* _tmp27_;
		GVariant* _tmp28_;
		const gchar* _tmp29_;
		_tmp27_ = item;
		_tmp28_ = val;
		_tmp29_ = g_variant_get_string (_tmp28_, NULL);
		rygel_media_file_item_set_dlna_profile (_tmp27_, _tmp29_);
	}
	_tmp30_ = vd;
	_tmp31_ = expected;
	_tmp32_ = g_variant_dict_lookup_value (_tmp30_, RYGEL_MEDIA_EXPORT_SERIALIZER_DATE, _tmp31_);
	_g_variant_unref0 (val);
	val = _tmp32_;
	_tmp33_ = val;
	if (_tmp33_ != NULL) {
		RygelMediaFileItem* _tmp34_;
		GVariant* _tmp35_;
		const gchar* _tmp36_;
		_tmp34_ = item;
		_tmp35_ = val;
		_tmp36_ = g_variant_get_string (_tmp35_, NULL);
		rygel_media_object_set_date ((RygelMediaObject*) _tmp34_, _tmp36_);
	}
	_tmp37_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelAudioItem* audio_item = NULL;
		RygelMediaFileItem* _tmp38_;
		RygelAudioItem* _tmp39_;
		RygelAudioItem* _tmp40_;
		GVariantDict* _tmp41_;
		RygelAudioItem* _tmp42_;
		GVariantDict* _tmp43_;
		RygelAudioItem* _tmp44_;
		GVariantDict* _tmp45_;
		RygelAudioItem* _tmp46_;
		GVariantDict* _tmp47_;
		RygelMediaFileItem* _tmp48_;
		_tmp38_ = item;
		_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp38_) : NULL);
		audio_item = _tmp39_;
		_tmp40_ = audio_item;
		_tmp41_ = vd;
		rygel_audio_item_set_duration (_tmp40_, (glong) rygel_media_export_item_factory_get_int32 (_tmp41_, RYGEL_MEDIA_EXPORT_SERIALIZER_DURATION));
		_tmp42_ = audio_item;
		_tmp43_ = vd;
		rygel_audio_item_set_bitrate (_tmp42_, (gint) rygel_media_export_item_factory_get_int32 (_tmp43_, RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_BITRATE));
		_tmp44_ = audio_item;
		_tmp45_ = vd;
		rygel_audio_item_set_channels (_tmp44_, (gint) rygel_media_export_item_factory_get_int32 (_tmp45_, RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_CHANNELS));
		_tmp46_ = audio_item;
		_tmp47_ = vd;
		rygel_audio_item_set_sample_freq (_tmp46_, (gint) rygel_media_export_item_factory_get_int32 (_tmp47_, RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_RATE));
		_tmp48_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM)) {
			RygelMediaExportMusicItem* music_item = NULL;
			RygelMediaFileItem* _tmp49_;
			RygelMediaExportMusicItem* _tmp50_;
			GVariantDict* _tmp51_;
			const GVariantType* _tmp52_;
			GVariant* _tmp53_;
			GVariant* _tmp54_;
			GVariantDict* _tmp58_;
			const GVariantType* _tmp59_;
			GVariant* _tmp60_;
			GVariant* _tmp61_;
			GVariantDict* _tmp65_;
			const GVariantType* _tmp66_;
			GVariant* _tmp67_;
			GVariant* _tmp68_;
			RygelMediaExportMusicItem* _tmp72_;
			GVariantDict* _tmp73_;
			RygelMediaExportMusicItem* _tmp74_;
			GVariantDict* _tmp75_;
			_tmp49_ = item;
			_tmp50_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) _tmp49_) : NULL);
			music_item = _tmp50_;
			_tmp51_ = vd;
			_tmp52_ = expected;
			_tmp53_ = g_variant_dict_lookup_value (_tmp51_, RYGEL_MEDIA_EXPORT_SERIALIZER_ARTIST, _tmp52_);
			_g_variant_unref0 (val);
			val = _tmp53_;
			_tmp54_ = val;
			if (_tmp54_ != NULL) {
				RygelMediaExportMusicItem* _tmp55_;
				GVariant* _tmp56_;
				const gchar* _tmp57_;
				_tmp55_ = music_item;
				_tmp56_ = val;
				_tmp57_ = g_variant_get_string (_tmp56_, NULL);
				rygel_media_object_set_artist ((RygelMediaObject*) _tmp55_, _tmp57_);
			}
			_tmp58_ = vd;
			_tmp59_ = expected;
			_tmp60_ = g_variant_dict_lookup_value (_tmp58_, RYGEL_MEDIA_EXPORT_SERIALIZER_ALBUM, _tmp59_);
			_g_variant_unref0 (val);
			val = _tmp60_;
			_tmp61_ = val;
			if (_tmp61_ != NULL) {
				RygelMediaExportMusicItem* _tmp62_;
				GVariant* _tmp63_;
				const gchar* _tmp64_;
				_tmp62_ = music_item;
				_tmp63_ = val;
				_tmp64_ = g_variant_get_string (_tmp63_, NULL);
				rygel_audio_item_set_album ((RygelAudioItem*) _tmp62_, _tmp64_);
			}
			_tmp65_ = vd;
			_tmp66_ = expected;
			_tmp67_ = g_variant_dict_lookup_value (_tmp65_, RYGEL_MEDIA_EXPORT_SERIALIZER_GENRE, _tmp66_);
			_g_variant_unref0 (val);
			val = _tmp67_;
			_tmp68_ = val;
			if (_tmp68_ != NULL) {
				RygelMediaExportMusicItem* _tmp69_;
				GVariant* _tmp70_;
				const gchar* _tmp71_;
				_tmp69_ = music_item;
				_tmp70_ = val;
				_tmp71_ = g_variant_get_string (_tmp70_, NULL);
				rygel_media_object_set_genre ((RygelMediaObject*) _tmp69_, _tmp71_);
			}
			_tmp72_ = music_item;
			_tmp73_ = vd;
			rygel_music_item_set_track_number ((RygelMusicItem*) _tmp72_, (gint) rygel_media_export_item_factory_get_int32 (_tmp73_, RYGEL_MEDIA_EXPORT_SERIALIZER_TRACK_NUMBER));
			_tmp74_ = music_item;
			_tmp75_ = vd;
			_tmp74_->disc = (gint) rygel_media_export_item_factory_get_int32 (_tmp75_, RYGEL_MEDIA_EXPORT_SERIALIZER_VOLUME_NUMBER);
			_g_object_unref0 (music_item);
		}
		_g_object_unref0 (audio_item);
	}
	_tmp76_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp76_, RYGEL_TYPE_VISUAL_ITEM)) {
		RygelVisualItem* visual_item = NULL;
		RygelMediaFileItem* _tmp77_;
		RygelVisualItem* _tmp78_;
		RygelVisualItem* _tmp79_;
		GVariantDict* _tmp80_;
		RygelVisualItem* _tmp81_;
		GVariantDict* _tmp82_;
		RygelVisualItem* _tmp83_;
		GVariantDict* _tmp84_;
		_tmp77_ = item;
		_tmp78_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp77_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp77_) : NULL);
		visual_item = _tmp78_;
		_tmp79_ = visual_item;
		_tmp80_ = vd;
		rygel_visual_item_set_width (_tmp79_, (gint) rygel_media_export_item_factory_get_int32 (_tmp80_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_WIDTH));
		_tmp81_ = visual_item;
		_tmp82_ = vd;
		rygel_visual_item_set_height (_tmp81_, (gint) rygel_media_export_item_factory_get_int32 (_tmp82_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_HEIGHT));
		_tmp83_ = visual_item;
		_tmp84_ = vd;
		rygel_visual_item_set_color_depth (_tmp83_, (gint) rygel_media_export_item_factory_get_int32 (_tmp84_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_DEPTH));
		_g_object_unref0 (visual_item);
	}
	_tmp85_ = item;
	_tmp86_ = _g_object_ref0 ((RygelMediaObject*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp85_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp85_) : NULL));
	result = _tmp86_;
	_g_variant_unref0 (val);
	_g_object_unref0 (item);
	_g_object_unref0 (object);
	_g_variant_unref0 (upnp_class);
	_g_variant_dict_unref0 (vd);
	_g_variant_type_free0 (expected);
	return result;
}


void
rygel_media_export_item_factory_apply_meta_data (RygelMediaFileItem* item,
                                                 GVariant* v,
                                                 GError** error)
{
	GVariantIter* it = NULL;
	GVariantIter* _tmp0_;
	GVariant* val = NULL;
	GVariantIter* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	gchar* _tmp6_ = NULL;
	GVariant* _tmp7_;
	GVariantIter* _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	gchar* _tmp14_ = NULL;
	GVariant* _tmp15_;
	gchar* album = NULL;
	gchar* _tmp18_;
	GVariantIter* _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	GVariant* _tmp22_;
	gchar* _tmp23_ = NULL;
	GVariant* _tmp24_;
	gint32 disc = 0;
	GVariantIter* _tmp27_;
	GVariant* _tmp28_;
	GVariant* _tmp29_;
	gint32 _tmp30_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	rygel_media_export_item_factory_check_variant_type (v, "(msmsmsiii)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp0_ = g_variant_iter_new (v);
	it = _tmp0_;
	_tmp1_ = it;
	_tmp2_ = g_variant_iter_next_value (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_get_maybe (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_variant_unref0 (_tmp3_);
	val = _tmp5_;
	_tmp7_ = val;
	if (_tmp7_ == NULL) {
		_g_free0 (_tmp6_);
		_tmp6_ = NULL;
	} else {
		GVariant* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = val;
		_tmp9_ = g_variant_dup_string (_tmp8_, NULL);
		_g_free0 (_tmp6_);
		_tmp6_ = _tmp9_;
	}
	rygel_media_object_set_artist ((RygelMediaObject*) item, _tmp6_);
	_tmp10_ = it;
	_tmp11_ = g_variant_iter_next_value (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_variant_get_maybe (_tmp12_);
	_g_variant_unref0 (val);
	val = _tmp13_;
	_g_variant_unref0 (_tmp12_);
	_tmp15_ = val;
	if (_tmp15_ == NULL) {
		_g_free0 (_tmp14_);
		_tmp14_ = NULL;
	} else {
		GVariant* _tmp16_;
		gchar* _tmp17_;
		_tmp16_ = val;
		_tmp17_ = g_variant_dup_string (_tmp16_, NULL);
		_g_free0 (_tmp14_);
		_tmp14_ = _tmp17_;
	}
	_tmp18_ = g_strdup (_tmp14_);
	album = _tmp18_;
	_tmp19_ = it;
	_tmp20_ = g_variant_iter_next_value (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_variant_get_maybe (_tmp21_);
	_g_variant_unref0 (val);
	val = _tmp22_;
	_g_variant_unref0 (_tmp21_);
	_tmp24_ = val;
	if (_tmp24_ == NULL) {
		_g_free0 (_tmp23_);
		_tmp23_ = NULL;
	} else {
		GVariant* _tmp25_;
		gchar* _tmp26_;
		_tmp25_ = val;
		_tmp26_ = g_variant_dup_string (_tmp25_, NULL);
		_g_free0 (_tmp23_);
		_tmp23_ = _tmp26_;
	}
	rygel_media_object_set_genre ((RygelMediaObject*) item, _tmp23_);
	_tmp27_ = it;
	_tmp28_ = g_variant_iter_next_value (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_variant_get_int32 (_tmp29_);
	_g_variant_unref0 (_tmp29_);
	disc = _tmp30_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelAudioItem* audio_item = NULL;
		RygelAudioItem* _tmp31_;
		gint32 track_number = 0;
		GVariantIter* _tmp32_;
		GVariant* _tmp33_;
		GVariant* _tmp34_;
		gint32 _tmp35_;
		RygelAudioItem* _tmp36_;
		GVariantIter* _tmp37_;
		GVariant* _tmp38_;
		GVariant* _tmp39_;
		RygelAudioItem* _tmp40_;
		const gchar* _tmp41_;
		_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) item) : NULL);
		audio_item = _tmp31_;
		_tmp32_ = it;
		_tmp33_ = g_variant_iter_next_value (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_variant_get_int32 (_tmp34_);
		_g_variant_unref0 (_tmp34_);
		track_number = _tmp35_;
		_tmp36_ = audio_item;
		_tmp37_ = it;
		_tmp38_ = g_variant_iter_next_value (_tmp37_);
		_tmp39_ = _tmp38_;
		rygel_audio_item_set_bitrate (_tmp36_, (gint) g_variant_get_int32 (_tmp39_));
		_g_variant_unref0 (_tmp39_);
		_tmp40_ = audio_item;
		_tmp41_ = album;
		rygel_audio_item_set_album (_tmp40_, _tmp41_);
		if (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM)) {
			RygelMediaExportMusicItem* music_item = NULL;
			RygelMediaExportMusicItem* _tmp42_;
			RygelMediaExportMusicItem* _tmp43_;
			gint32 _tmp44_;
			RygelMediaExportMusicItem* _tmp45_;
			gint32 _tmp46_;
			_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) item) : NULL);
			music_item = _tmp42_;
			_tmp43_ = music_item;
			_tmp44_ = disc;
			_tmp43_->disc = (gint) _tmp44_;
			_tmp45_ = music_item;
			_tmp46_ = track_number;
			rygel_music_item_set_track_number ((RygelMusicItem*) _tmp45_, (gint) _tmp46_);
			_g_object_unref0 (music_item);
		}
		_g_object_unref0 (audio_item);
	}
	_g_free0 (_tmp23_);
	_g_free0 (album);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp6_);
	_g_variant_unref0 (val);
	_g_variant_iter_free0 (it);
}


void
rygel_media_export_item_factory_apply_video_info (RygelMediaFileItem* item,
                                                  GVariant* v,
                                                  GError** error)
{
	RygelVisualItem* visual_item = NULL;
	RygelVisualItem* _tmp3_;
	GVariantIter* it = NULL;
	GVariantIter* _tmp4_;
	RygelVisualItem* _tmp5_;
	GVariantIter* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	RygelVisualItem* _tmp9_;
	GVariantIter* _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	RygelVisualItem* _tmp13_;
	GVariantIter* _tmp14_;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	rygel_media_export_item_factory_check_variant_type (v, "(iii)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	if (!G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_VISUAL_ITEM)) {
		gchar* msg = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		GError* _tmp2_;
		_tmp0_ = g_strdup ("UPnP class does not match supplied meta data");
		msg = _tmp0_;
		_tmp1_ = msg;
		_tmp2_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR, RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_MISMATCH, _tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		return;
	}
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) item) : NULL);
	visual_item = _tmp3_;
	_tmp4_ = g_variant_iter_new (v);
	it = _tmp4_;
	_tmp5_ = visual_item;
	_tmp6_ = it;
	_tmp7_ = g_variant_iter_next_value (_tmp6_);
	_tmp8_ = _tmp7_;
	rygel_visual_item_set_width (_tmp5_, (gint) g_variant_get_int32 (_tmp8_));
	_g_variant_unref0 (_tmp8_);
	_tmp9_ = visual_item;
	_tmp10_ = it;
	_tmp11_ = g_variant_iter_next_value (_tmp10_);
	_tmp12_ = _tmp11_;
	rygel_visual_item_set_height (_tmp9_, (gint) g_variant_get_int32 (_tmp12_));
	_g_variant_unref0 (_tmp12_);
	_tmp13_ = visual_item;
	_tmp14_ = it;
	_tmp15_ = g_variant_iter_next_value (_tmp14_);
	_tmp16_ = _tmp15_;
	rygel_visual_item_set_color_depth (_tmp13_, (gint) g_variant_get_int32 (_tmp16_));
	_g_variant_unref0 (_tmp16_);
	_g_variant_iter_free0 (it);
	_g_object_unref0 (visual_item);
}


void
rygel_media_export_item_factory_apply_audio_info (RygelMediaFileItem* item,
                                                  GVariant* v,
                                                  GError** error)
{
	RygelAudioItem* audio_item = NULL;
	RygelAudioItem* _tmp3_;
	GVariantIter* it = NULL;
	GVariantIter* _tmp4_;
	RygelAudioItem* _tmp5_;
	GVariantIter* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	RygelAudioItem* _tmp9_;
	GVariantIter* _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	rygel_media_export_item_factory_check_variant_type (v, "(ii)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	if (!G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_AUDIO_ITEM)) {
		gchar* msg = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		GError* _tmp2_;
		_tmp0_ = g_strdup ("UPnP class does not match supplied meta data");
		msg = _tmp0_;
		_tmp1_ = msg;
		_tmp2_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR, RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_MISMATCH, _tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		return;
	}
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) item) : NULL);
	audio_item = _tmp3_;
	_tmp4_ = g_variant_iter_new (v);
	it = _tmp4_;
	_tmp5_ = audio_item;
	_tmp6_ = it;
	_tmp7_ = g_variant_iter_next_value (_tmp6_);
	_tmp8_ = _tmp7_;
	rygel_audio_item_set_channels (_tmp5_, (gint) g_variant_get_int32 (_tmp8_));
	_g_variant_unref0 (_tmp8_);
	_tmp9_ = audio_item;
	_tmp10_ = it;
	_tmp11_ = g_variant_iter_next_value (_tmp10_);
	_tmp12_ = _tmp11_;
	rygel_audio_item_set_sample_freq (_tmp9_, (gint) g_variant_get_int32 (_tmp12_));
	_g_variant_unref0 (_tmp12_);
	_g_variant_iter_free0 (it);
	_g_object_unref0 (audio_item);
}


void
rygel_media_export_item_factory_apply_info (RygelMediaFileItem* item,
                                            GVariant* v,
                                            GError** error)
{
	GVariantIter* it = NULL;
	GVariantIter* _tmp0_;
	GVariant* val = NULL;
	GVariantIter* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GVariantIter* _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	rygel_media_export_item_factory_check_variant_type (v, "(msmsi)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp0_ = g_variant_iter_new (v);
	it = _tmp0_;
	_tmp1_ = it;
	_tmp2_ = g_variant_iter_next_value (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_get_maybe (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_variant_unref0 (_tmp3_);
	val = _tmp5_;
	_tmp6_ = val;
	if (_tmp6_ != NULL) {
		GVariant* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = val;
		_tmp8_ = g_variant_dup_string (_tmp7_, NULL);
		_tmp9_ = _tmp8_;
		rygel_media_object_set_title ((RygelMediaObject*) item, _tmp9_);
		_g_free0 (_tmp9_);
	}
	_tmp10_ = it;
	_tmp11_ = g_variant_iter_next_value (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_variant_get_maybe (_tmp12_);
	_g_variant_unref0 (val);
	val = _tmp13_;
	_g_variant_unref0 (_tmp12_);
	_tmp14_ = val;
	if (_tmp14_ != NULL) {
		GVariant* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp15_ = val;
		_tmp16_ = g_variant_dup_string (_tmp15_, NULL);
		_tmp17_ = _tmp16_;
		rygel_media_object_set_date ((RygelMediaObject*) item, _tmp17_);
		_g_free0 (_tmp17_);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_AUDIO_ITEM)) {
		GVariantIter* _tmp18_;
		GVariant* _tmp19_;
		GVariant* _tmp20_;
		_tmp18_ = it;
		_tmp19_ = g_variant_iter_next_value (_tmp18_);
		_tmp20_ = _tmp19_;
		rygel_audio_item_set_duration (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) item) : NULL, (glong) g_variant_get_int32 (_tmp20_));
		_g_variant_unref0 (_tmp20_);
	}
	_g_variant_unref0 (val);
	_g_variant_iter_free0 (it);
}


void
rygel_media_export_item_factory_apply_dlna_profile (RygelMediaFileItem* item,
                                                    GVariant* v,
                                                    GError** error)
{
	GVariantIter* it = NULL;
	GVariantIter* _tmp0_;
	GVariantIter* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GVariantIter* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (v != NULL);
	rygel_media_export_item_factory_check_variant_type (v, "(ss)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp0_ = g_variant_iter_new (v);
	it = _tmp0_;
	_tmp1_ = it;
	_tmp2_ = g_variant_iter_next_value (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_dup_string (_tmp3_, NULL);
	_tmp5_ = _tmp4_;
	rygel_media_file_item_set_dlna_profile (item, _tmp5_);
	_g_free0 (_tmp5_);
	_g_variant_unref0 (_tmp3_);
	_tmp6_ = it;
	_tmp7_ = g_variant_iter_next_value (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_variant_dup_string (_tmp8_, NULL);
	_tmp10_ = _tmp9_;
	rygel_media_file_item_set_mime_type (item, _tmp10_);
	_g_free0 (_tmp10_);
	_g_variant_unref0 (_tmp8_);
	_g_variant_iter_free0 (it);
}


void
rygel_media_export_item_factory_apply_file_info (RygelMediaObject* object,
                                                 GVariant* v,
                                                 GError** error)
{
	GVariantIter* it = NULL;
	GVariantIter* _tmp0_;
	GVariant* display_name = NULL;
	GVariantIter* _tmp1_;
	GVariant* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GVariantIter* _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (object != NULL);
	g_return_if_fail (v != NULL);
	rygel_media_export_item_factory_check_variant_type (v, "(stst)", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp0_ = g_variant_iter_new (v);
	it = _tmp0_;
	_tmp1_ = it;
	_tmp2_ = g_variant_iter_next_value (_tmp1_);
	display_name = _tmp2_;
	_tmp4_ = rygel_media_object_get_title (object);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = rygel_media_object_get_title (object);
		_tmp7_ = _tmp6_;
		_tmp3_ = g_strcmp0 (_tmp7_, "") == 0;
	}
	if (_tmp3_) {
		GVariant* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = display_name;
		_tmp9_ = g_variant_dup_string (_tmp8_, NULL);
		_tmp10_ = _tmp9_;
		rygel_media_object_set_title (object, _tmp10_);
		_g_free0 (_tmp10_);
	}
	_tmp11_ = it;
	_tmp12_ = g_variant_iter_next_value (_tmp11_);
	_tmp13_ = _tmp12_;
	rygel_media_object_set_modified (object, (guint64) ((gint64) g_variant_get_uint64 (_tmp13_)));
	_g_variant_unref0 (_tmp13_);
	if (G_TYPE_CHECK_INSTANCE_TYPE (object, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
		RygelMediaFileItem* item = NULL;
		RygelMediaFileItem* _tmp14_;
		GVariant* mime = NULL;
		GVariantIter* _tmp15_;
		GVariant* _tmp16_;
		RygelMediaFileItem* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		RygelMediaFileItem* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		RygelMediaFileItem* _tmp34_;
		GVariantIter* _tmp35_;
		GVariant* _tmp36_;
		GVariant* _tmp37_;
		_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) object) : NULL);
		item = _tmp14_;
		_tmp15_ = it;
		_tmp16_ = g_variant_iter_next_value (_tmp15_);
		mime = _tmp16_;
		_tmp17_ = item;
		_tmp18_ = rygel_media_file_item_get_mime_type (_tmp17_);
		_tmp19_ = _tmp18_;
		if (_tmp19_ == NULL) {
			RygelMediaFileItem* _tmp20_;
			GVariant* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp20_ = item;
			_tmp21_ = mime;
			_tmp22_ = g_variant_dup_string (_tmp21_, NULL);
			_tmp23_ = _tmp22_;
			rygel_media_file_item_set_mime_type (_tmp20_, _tmp23_);
			_g_free0 (_tmp23_);
		}
		_tmp24_ = item;
		_tmp25_ = rygel_media_object_get_date ((RygelMediaObject*) _tmp24_);
		_tmp26_ = _tmp25_;
		if (_tmp26_ == NULL) {
			GTimeVal tv = {0};
			RygelMediaFileItem* _tmp27_;
			guint64 _tmp28_;
			guint64 _tmp29_;
			GTimeVal _tmp30_ = {0};
			RygelMediaFileItem* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			_tmp27_ = item;
			_tmp28_ = rygel_media_object_get_modified ((RygelMediaObject*) _tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_.tv_sec = (glong) _tmp29_;
			_tmp30_.tv_usec = (glong) 0;
			tv = _tmp30_;
			_tmp31_ = item;
			_tmp32_ = g_time_val_to_iso8601 (&tv);
			_tmp33_ = _tmp32_;
			rygel_media_object_set_date ((RygelMediaObject*) _tmp31_, _tmp33_);
			_g_free0 (_tmp33_);
		}
		_tmp34_ = item;
		_tmp35_ = it;
		_tmp36_ = g_variant_iter_next_value (_tmp35_);
		_tmp37_ = _tmp36_;
		rygel_media_file_item_set_size (_tmp34_, (gint64) g_variant_get_uint64 (_tmp37_));
		_g_variant_unref0 (_tmp37_);
		_g_variant_unref0 (mime);
		_g_object_unref0 (item);
	}
	_g_variant_unref0 (display_name);
	_g_variant_iter_free0 (it);
}



