/* rygel-media-export-media-cache.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-media-export-media-cache.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2013 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jens Georg <mail@jensge.org>
 *         Doug Galligan <doug@sentosatech.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <gee.h>
#include <stdlib.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <rygel-server.h>
#include <glib/gi18n-lib.h>
#include <sqlite3.h>
#include <uuid/uuid.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_TYPE (rygel_media_export_object_type_get_type ())

#define RYGEL_MEDIA_EXPORT_TYPE_EXISTS_CACHE_ENTRY (rygel_media_export_exists_cache_entry_get_type ())
typedef struct _RygelMediaExportExistsCacheEntry RygelMediaExportExistsCacheEntry;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;
typedef struct _RygelMediaExportMediaCachePrivate RygelMediaExportMediaCachePrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER (rygel_media_export_sqlite_wrapper_get_type ())
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapper))
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapperClass))
#define RYGEL_MEDIA_EXPORT_IS_SQLITE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER))
#define RYGEL_MEDIA_EXPORT_IS_SQLITE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER))
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapperClass))

typedef struct _RygelMediaExportSqliteWrapper RygelMediaExportSqliteWrapper;
typedef struct _RygelMediaExportSqliteWrapperClass RygelMediaExportSqliteWrapperClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE (rygel_media_export_database_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabase))
#define RYGEL_MEDIA_EXPORT_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))

typedef struct _RygelMediaExportDatabase RygelMediaExportDatabase;
typedef struct _RygelMediaExportDatabaseClass RygelMediaExportDatabaseClass;

#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY (rygel_media_export_object_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactory))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))

typedef struct _RygelMediaExportObjectFactory RygelMediaExportObjectFactory;
typedef struct _RygelMediaExportObjectFactoryClass RygelMediaExportObjectFactoryClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY (rygel_media_export_sql_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactory))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))

typedef struct _RygelMediaExportSQLFactory RygelMediaExportSQLFactory;
typedef struct _RygelMediaExportSQLFactoryClass RygelMediaExportSQLFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_STRING (rygel_media_export_sql_string_get_type ())

#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR (rygel_media_export_database_cursor_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursor))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursorClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursorClass))

typedef struct _RygelMediaExportDatabaseCursor RygelMediaExportDatabaseCursor;
typedef struct _RygelMediaExportDatabaseCursorClass RygelMediaExportDatabaseCursorClass;

#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR (rygel_media_export_database_cursor_iterator_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR, RygelMediaExportDatabaseCursorIterator))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR, RygelMediaExportDatabaseCursorIteratorClass))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR, RygelMediaExportDatabaseCursorIteratorClass))

typedef struct _RygelMediaExportDatabaseCursorIterator RygelMediaExportDatabaseCursorIterator;
typedef struct _RygelMediaExportDatabaseCursorIteratorClass RygelMediaExportDatabaseCursorIteratorClass;
#define _rygel_media_export_database_cursor_iterator_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_database_cursor_iterator_unref (var), NULL)))
#define _rygel_media_export_exists_cache_entry_free0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_exists_cache_entry_free (var), NULL)))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DETAIL_COLUMN (rygel_media_export_detail_column_get_type ())

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER (rygel_media_export_media_cache_upgrader_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgrader))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))

typedef struct _RygelMediaExportMediaCacheUpgrader RygelMediaExportMediaCacheUpgrader;
typedef struct _RygelMediaExportMediaCacheUpgraderClass RygelMediaExportMediaCacheUpgraderClass;
#define _rygel_media_export_media_cache_upgrader_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_media_cache_upgrader_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM (rygel_media_export_music_item_get_type ())
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItem))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))

typedef struct _RygelMediaExportMusicItem RygelMediaExportMusicItem;
typedef struct _RygelMediaExportMusicItemClass RygelMediaExportMusicItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT (rygel_media_export_updatable_object_get_type ())
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObject))
#define RYGEL_MEDIA_EXPORT_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT))
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObjectIface))

typedef struct _RygelMediaExportUpdatableObject RygelMediaExportUpdatableObject;
typedef struct _RygelMediaExportUpdatableObjectIface RygelMediaExportUpdatableObjectIface;
typedef struct _RygelMediaExportMusicItemPrivate RygelMediaExportMusicItemPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM (rygel_media_export_video_item_get_type ())
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItem))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))

typedef struct _RygelMediaExportVideoItem RygelMediaExportVideoItem;
typedef struct _RygelMediaExportVideoItemClass RygelMediaExportVideoItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM (rygel_media_export_playlist_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItem))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))

typedef struct _RygelMediaExportPlaylistItem RygelMediaExportPlaylistItem;
typedef struct _RygelMediaExportPlaylistItemClass RygelMediaExportPlaylistItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;
typedef struct _Block4Data Block4Data;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR (rygel_media_export_sql_operator_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_OPERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR, RygelMediaExportSqlOperator))
#define RYGEL_MEDIA_EXPORT_SQL_OPERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR, RygelMediaExportSqlOperatorClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_OPERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR))
#define RYGEL_MEDIA_EXPORT_IS_SQL_OPERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR))
#define RYGEL_MEDIA_EXPORT_SQL_OPERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR, RygelMediaExportSqlOperatorClass))

typedef struct _RygelMediaExportSqlOperator RygelMediaExportSqlOperator;
typedef struct _RygelMediaExportSqlOperatorClass RygelMediaExportSqlOperatorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION (rygel_media_export_sql_function_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION, RygelMediaExportSqlFunction))
#define RYGEL_MEDIA_EXPORT_SQL_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION, RygelMediaExportSqlFunctionClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION))
#define RYGEL_MEDIA_EXPORT_SQL_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION, RygelMediaExportSqlFunctionClass))

typedef struct _RygelMediaExportSqlFunction RygelMediaExportSqlFunction;
typedef struct _RygelMediaExportSqlFunctionClass RygelMediaExportSqlFunctionClass;

typedef enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH
} RygelMediaExportMediaCacheError;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR rygel_media_export_media_cache_error_quark ()
typedef enum  {
	RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER,
	RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM
} RygelMediaExportObjectType;

struct _RygelMediaExportExistsCacheEntry {
	gint64 mtime;
	gint64 size;
};

struct _RygelMediaExportMediaCache {
	GObject parent_instance;
	RygelMediaExportMediaCachePrivate * priv;
};

struct _RygelMediaExportMediaCacheClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportMediaCachePrivate {
	RygelMediaExportDatabase* db;
	RygelMediaExportObjectFactory* factory;
	RygelMediaExportSQLFactory* sql;
	GeeHashMap* exists_cache;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
typedef enum  {
	RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER_WITH_ANCESTOR,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER_WITH_ANCESTOR,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS_CACHE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_STATISTICS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_RESET_TOKEN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_MAX_UPDATE_ID,
	RYGEL_MEDIA_EXPORT_SQL_STRING_MAKE_GUARDED,
	RYGEL_MEDIA_EXPORT_SQL_STRING_IS_GUARDED,
	RYGEL_MEDIA_EXPORT_SQL_STRING_UPDATE_GUARDED_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_REFERENCE
} RygelMediaExportSQLString;

typedef enum  {
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TYPE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TITLE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SIZE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_MIME_TYPE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_WIDTH,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_HEIGHT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CLASS,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CREATOR,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ALBUM,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DATE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITRATE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SAMPLE_FREQ,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITS_PER_SAMPLE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CHANNELS,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TRACK,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_COLOR_DEPTH,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DURATION,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_PARENT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TIMESTAMP,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DLNA_PROFILE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_GENRE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DISC,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_OBJECT_UPDATE_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DELETED_CHILD_COUNT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CONTAINER_UPDATE_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_REFERENCE_ID
} RygelMediaExportDetailColumn;

struct _RygelMediaExportUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit_custom) (RygelMediaExportUpdatableObject* self, gboolean override_guarded, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_custom_finish) (RygelMediaExportUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportMusicItem {
	RygelMusicItem parent_instance;
	RygelMediaExportMusicItemPrivate * priv;
	gint disc;
};

struct _RygelMediaExportMusicItemClass {
	RygelMusicItemClass parent_class;
};

struct _Block4Data {
	int _ref_count_;
	RygelMediaExportMediaCache* self;
	RygelMediaFileItem* item;
	RygelMediaEngine* media_engine;
};


static gpointer rygel_media_export_media_cache_parent_class = NULL;
static RygelMediaExportMediaCache* rygel_media_export_media_cache_instance;
static RygelMediaExportMediaCache* rygel_media_export_media_cache_instance = NULL;

GQuark rygel_media_export_media_cache_error_quark (void);
GType rygel_media_export_object_type_get_type (void) G_GNUC_CONST;
GType rygel_media_export_exists_cache_entry_get_type (void) G_GNUC_CONST;
RygelMediaExportExistsCacheEntry* rygel_media_export_exists_cache_entry_dup (const RygelMediaExportExistsCacheEntry* self);
void rygel_media_export_exists_cache_entry_free (RygelMediaExportExistsCacheEntry* self);
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_sqlite_wrapper_get_type (void) G_GNUC_CONST;
GType rygel_media_export_database_get_type (void) G_GNUC_CONST;
GType rygel_media_export_object_factory_get_type (void) G_GNUC_CONST;
GType rygel_media_export_sql_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCachePrivate))
enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_DUMMY_PROPERTY
};
static RygelMediaExportMediaCache* rygel_media_export_media_cache_new (GError** error);
static RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type, GError** error);
RygelMediaExportSQLFactory* rygel_media_export_sql_factory_new (void);
RygelMediaExportSQLFactory* rygel_media_export_sql_factory_construct (GType object_type);
static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self, const gchar* name, GError** error);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_new (void);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_construct (GType object_type);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
void rygel_media_export_media_cache_ensure_exists (GError** error);
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (void);
GQuark rygel_media_export_database_error_quark (void);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error);
void rygel_media_export_database_exec (RygelMediaExportDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
GType rygel_media_export_sql_string_get_type (void) G_GNUC_CONST;
const gchar* rygel_media_export_sql_factory_make (RygelMediaExportSQLFactory* self, RygelMediaExportSQLString query);
static void _vala_GValue_array_free (GValue* array, gint array_length);
void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
void rygel_media_export_database_begin (RygelMediaExportDatabase* self, GError** error);
static void rygel_media_export_media_cache_save_container_metadata (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean override_guarded, GError** error);
void rygel_media_export_database_commit (RygelMediaExportDatabase* self, GError** error);
void rygel_media_export_database_rollback (RygelMediaExportDatabase* self);
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaFileItem* item, gboolean override_guarded, GError** error);
static void rygel_media_export_media_cache_save_item_metadata (RygelMediaExportMediaCache* self, RygelMediaFileItem* item, GError** error);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error);
GType rygel_media_export_database_cursor_get_type (void) G_GNUC_CONST;
static RygelMediaExportDatabaseCursor* rygel_media_export_media_cache_exec_cursor (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error);
gpointer rygel_media_export_database_cursor_iterator_ref (gpointer instance);
void rygel_media_export_database_cursor_iterator_unref (gpointer instance);
GParamSpec* rygel_media_export_database_cursor_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_media_export_database_cursor_value_set_iterator (GValue* value, gpointer v_object);
void rygel_media_export_database_cursor_value_take_iterator (GValue* value, gpointer v_object);
gpointer rygel_media_export_database_cursor_value_get_iterator (const GValue* value);
GType rygel_media_export_database_cursor_iterator_get_type (void) G_GNUC_CONST;
RygelMediaExportDatabaseCursorIterator* rygel_media_export_database_cursor_iterator (RygelMediaExportDatabaseCursor* self);
gboolean rygel_media_export_database_cursor_iterator_next (RygelMediaExportDatabaseCursorIterator* self, GError** error);
sqlite3_stmt* rygel_media_export_database_cursor_iterator_get (RygelMediaExportDatabaseCursorIterator* self, GError** error);
static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self, RygelMediaContainer* parent, sqlite3_stmt* statement);
RygelMediaContainer* rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
static gint rygel_media_export_media_cache_query_value (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error);
guint32 rygel_media_export_media_cache_get_update_id (RygelMediaExportMediaCache* self);
void rygel_media_export_media_cache_get_track_properties (RygelMediaExportMediaCache* self, const gchar* id, guint32* object_update_id, guint32* container_update_id, guint32* total_deleted_child_count);
RygelMediaExportDatabaseCursor* rygel_media_export_database_exec_cursor (RygelMediaExportDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
sqlite3_stmt* rygel_media_export_database_cursor_next (RygelMediaExportDatabaseCursor* self, GError** error);
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error);
RygelMediaObjects* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self, RygelMediaContainer* container, const gchar* sort_criteria, glong offset, glong max_count, GError** error);
static gchar* rygel_media_export_media_cache_translate_sort_criteria (const gchar* sort_criteria, gchar** extra_columns, gint* column_count);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, const gchar* sort_criteria, guint offset, guint max_count, guint* total_matches, GError** error);
static gchar* rygel_media_export_media_cache_translate_search_expression (RygelSearchExpression* expression, GValueArray* args, const gchar* prefix, GError** error);
static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self, guint max_count);
glong rygel_media_export_media_cache_get_object_count_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, GError** error);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, const gchar* sort_criteria, glong offset, glong max_count, GError** error);
glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, GError** error);
static GValue* _g_value_dup (GValue* self);
static void _vala_GValue_free (GValue* self);
gint rygel_media_export_database_query_value (RygelMediaExportDatabase* self, const gchar* sql, GValue* args, int args_length1, GError** error);
GType rygel_media_export_detail_column_get_type (void) G_GNUC_CONST;
RygelNullContainer* rygel_null_container_new_root (void);
RygelNullContainer* rygel_null_container_construct_root (GType object_type);
GType rygel_null_container_get_type (void) G_GNUC_CONST;
RygelNullContainer* rygel_null_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelNullContainer* rygel_null_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
void rygel_media_export_media_cache_debug_statistics (RygelMediaExportMediaCache* self);
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
GeeList* rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self, const gchar* column, const gchar* filter, GValueArray* args, glong offset, const gchar* sort_criteria, glong max_count, gboolean add_all_container, GError** error);
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const gchar* attribute, RygelSearchExpression* expression, const gchar* sort_criteria, glong offset, guint max_count, gboolean add_all_container, GError** error);
static gchar* rygel_media_export_media_cache_map_operand_to_column (const gchar* operand, gchar** collate, gboolean for_sort, GError** error);
gchar* rygel_media_export_media_cache_get_reset_token (RygelMediaExportMediaCache* self);
void rygel_media_export_media_cache_save_reset_token (RygelMediaExportMediaCache* self, const gchar* token);
void rygel_media_export_media_cache_drop_virtual_folders (RygelMediaExportMediaCache* self);
void rygel_media_export_media_cache_make_object_guarded (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean guarded);
gchar* rygel_media_export_media_cache_create_reference (RygelMediaExportMediaCache* self, RygelMediaObject* object, RygelMediaContainer* parent, GError** error);
static gboolean rygel_media_export_media_cache_is_object_guarded (RygelMediaExportMediaCache* self, const gchar* id);
void rygel_media_export_media_cache_rebuild_exists_cache (RygelMediaExportMediaCache* self, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_new (const gchar* name, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_construct (GType object_type, const gchar* name, GError** error);
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION "16"
gpointer rygel_media_export_media_cache_upgrader_ref (gpointer instance);
void rygel_media_export_media_cache_upgrader_unref (gpointer instance);
GParamSpec* rygel_media_export_param_spec_media_cache_upgrader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_media_export_value_set_media_cache_upgrader (GValue* value, gpointer v_object);
void rygel_media_export_value_take_media_cache_upgrader (GValue* value, gpointer v_object);
gpointer rygel_media_export_value_get_media_cache_upgrader (const GValue* value);
GType rygel_media_export_media_cache_upgrader_get_type (void) G_GNUC_CONST;
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_new (RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql);
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_construct (GType object_type, RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql);
gboolean rygel_media_export_media_cache_upgrader_needs_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint* current_version, GError** error);
void rygel_media_export_media_cache_upgrader_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint old_version);
void rygel_media_export_media_cache_upgrader_fix_schema (RygelMediaExportMediaCacheUpgrader* self, GError** error);
void rygel_media_export_media_cache_upgrader_ensure_indices (RygelMediaExportMediaCacheUpgrader* self);
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self);
void rygel_media_export_database_null (GValue* result);
GType rygel_media_export_music_item_get_type (void) G_GNUC_CONST;
GType rygel_media_export_updatable_object_get_type (void) G_GNUC_CONST;
GType rygel_media_export_video_item_get_type (void) G_GNUC_CONST;
GType rygel_media_export_playlist_item_get_type (void) G_GNUC_CONST;
static void rygel_media_export_media_cache_update_guarded_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
static void rygel_media_export_media_cache_create_normal_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean is_guarded, GError** error);
void rygel_media_export_database_analyze (RygelMediaExportDatabase* self);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
RygelMediaExportDBContainer* rygel_media_export_object_factory_get_container (RygelMediaExportObjectFactory* self, const gchar* id, const gchar* title, guint child_count, const gchar* uri);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
RygelMediaFileItem* rygel_media_export_object_factory_get_item (RygelMediaExportObjectFactory* self, RygelMediaContainer* parent, const gchar* id, const gchar* title, const gchar* upnp_class);
static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self, sqlite3_stmt* statement, RygelMediaFileItem* item);
static void ___lambda4_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res);
static void ____lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gchar* rygel_media_export_media_cache_search_expression_to_sql (RygelSearchExpression* expression, GValueArray* args, GError** error);
static gchar* rygel_media_export_media_cache_logical_expression_to_sql (RygelLogicalExpression* expression, GValueArray* args, GError** error);
static gchar* rygel_media_export_media_cache_relational_expression_to_sql (RygelRelationalExpression* exp, GValueArray* args, GError** error);
GType rygel_media_export_sql_operator_get_type (void) G_GNUC_CONST;
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_new_from_search_criteria_op (GUPnPSearchCriteriaOp op, const gchar* arg, const gchar* collate);
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_construct_from_search_criteria_op (GType object_type, GUPnPSearchCriteriaOp op, const gchar* arg, const gchar* collate);
RygelMediaExportSqlFunction* rygel_media_export_sql_function_new (const gchar* name, const gchar* arg);
RygelMediaExportSqlFunction* rygel_media_export_sql_function_construct (GType object_type, const gchar* name, const gchar* arg);
GType rygel_media_export_sql_function_get_type (void) G_GNUC_CONST;
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_new (const gchar* name, const gchar* arg, const gchar* collate);
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_construct (GType object_type, const gchar* name, const gchar* arg, const gchar* collate);
gchar* rygel_media_export_sql_operator_to_string (RygelMediaExportSqlOperator* self);
static void rygel_media_export_media_cache_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark rygel_media_export_media_cache_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_export_media_cache_error-quark");
}


GType rygel_media_export_object_type_get_type (void) {
	static volatile gsize rygel_media_export_object_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_object_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER, "RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER", "container"}, {RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM, "RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM", "item"}, {0, NULL, NULL}};
		GType rygel_media_export_object_type_type_id;
		rygel_media_export_object_type_type_id = g_enum_register_static ("RygelMediaExportObjectType", values);
		g_once_init_leave (&rygel_media_export_object_type_type_id__volatile, rygel_media_export_object_type_type_id);
	}
	return rygel_media_export_object_type_type_id__volatile;
}


RygelMediaExportExistsCacheEntry* rygel_media_export_exists_cache_entry_dup (const RygelMediaExportExistsCacheEntry* self) {
	RygelMediaExportExistsCacheEntry* dup;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	dup = g_new0 (RygelMediaExportExistsCacheEntry, 1);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	memcpy (dup, self, sizeof (RygelMediaExportExistsCacheEntry));
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return dup;
#line 519 "rygel-media-export-media-cache.c"
}


void rygel_media_export_exists_cache_entry_free (RygelMediaExportExistsCacheEntry* self) {
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_free (self);
#line 526 "rygel-media-export-media-cache.c"
}


GType rygel_media_export_exists_cache_entry_get_type (void) {
	static volatile gsize rygel_media_export_exists_cache_entry_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_exists_cache_entry_type_id__volatile)) {
		GType rygel_media_export_exists_cache_entry_type_id;
		rygel_media_export_exists_cache_entry_type_id = g_boxed_type_register_static ("RygelMediaExportExistsCacheEntry", (GBoxedCopyFunc) rygel_media_export_exists_cache_entry_dup, (GBoxedFreeFunc) rygel_media_export_exists_cache_entry_free);
		g_once_init_leave (&rygel_media_export_exists_cache_entry_type_id__volatile, rygel_media_export_exists_cache_entry_type_id);
	}
	return rygel_media_export_exists_cache_entry_type_id__volatile;
}


static RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type, GError** error) {
	RygelMediaExportMediaCache * self = NULL;
	gchar* db_name = NULL;
	gchar* _tmp0_ = NULL;
	RygelMediaExportSQLFactory* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	RygelMediaExportObjectFactory* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self = (RygelMediaExportMediaCache*) g_object_new (object_type, NULL);
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = g_strdup ("media-export");
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	db_name = _tmp0_;
#line 555 "rygel-media-export-media-cache.c"
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = rygel_meta_config_get_default ();
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		config = _tmp1_;
#line 68 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = rygel_configuration_get_bool ((RygelConfiguration*) config, "MediaExport", "use-temp-db", &_inner_error_);
#line 68 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = _tmp3_;
#line 68 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 68 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (config);
#line 573 "rygel-media-export-media-cache.c"
			goto __catch5_g_error;
		}
#line 68 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_tmp2_) {
#line 578 "rygel-media-export-media-cache.c"
			gchar* _tmp4_ = NULL;
#line 69 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp4_ = g_strdup (":memory:");
#line 69 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (db_name);
#line 69 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			db_name = _tmp4_;
#line 586 "rygel-media-export-media-cache.c"
		}
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (config);
#line 590 "rygel-media-export-media-cache.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* _error_ = NULL;
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 602 "rygel-media-export-media-cache.c"
	}
	__finally5:
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (db_name);
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (self);
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 615 "rygel-media-export-media-cache.c"
	}
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = rygel_media_export_sql_factory_new ();
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->sql);
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self->priv->sql = _tmp5_;
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = db_name;
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_open_db (self, _tmp6_, &_inner_error_);
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (db_name);
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (self);
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 637 "rygel-media-export-media-cache.c"
	}
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = rygel_media_export_object_factory_new ();
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->factory);
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self->priv->factory = _tmp7_;
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (db_name);
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return self;
#line 649 "rygel-media-export-media-cache.c"
}


static RygelMediaExportMediaCache* rygel_media_export_media_cache_new (GError** error) {
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return rygel_media_export_media_cache_construct (RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, error);
#line 656 "rygel-media-export-media-cache.c"
}


gchar* rygel_media_export_media_cache_get_id (GFile* file) {
	gchar* result = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = file;
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = g_file_get_uri (_tmp0_);
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = _tmp1_;
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp2_, (gsize) (-1));
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = _tmp3_;
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp2_);
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp4_;
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 685 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_ensure_exists (GError** error) {
	RygelMediaExportMediaCache* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_export_media_cache_instance;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp0_ == NULL) {
#line 696 "rygel-media-export-media-cache.c"
		RygelMediaExportMediaCache* _tmp1_ = NULL;
		RygelMediaExportMediaCache* _tmp2_ = NULL;
		RygelMediaExportMediaCache* _tmp3_ = NULL;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = rygel_media_export_media_cache_new (&_inner_error_);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = _tmp2_;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 710 "rygel-media-export-media-cache.c"
		}
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = _tmp1_;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = NULL;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (rygel_media_export_media_cache_instance);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_instance = _tmp3_;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (_tmp1_);
#line 722 "rygel-media-export-media-cache.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return self ? g_object_ref (self) : NULL;
#line 730 "rygel-media-export-media-cache.c"
}


RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (void) {
	RygelMediaExportMediaCache* result = NULL;
	RygelMediaExportMediaCache* _tmp0_ = NULL;
	RygelMediaExportMediaCache* _tmp1_ = NULL;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_export_media_cache_instance;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp1_;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 746 "rygel-media-export-media-cache.c"
}


static void _vala_GValue_array_free (GValue* array, gint array_length) {
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (array != NULL) {
#line 753 "rygel-media-export-media-cache.c"
		int i;
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_unset (&array[i]);
#line 759 "rygel-media-export-media-cache.c"
		}
	}
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_free (array);
#line 764 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error) {
	GValue* values = NULL;
	const gchar* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	RygelMediaExportDatabase* _tmp3_ = NULL;
	RygelMediaExportSQLFactory* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (id != NULL);
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = id;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_STRING);
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp1_, _tmp0_);
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = g_new0 (GValue, 1);
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_[0] = _tmp1_;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp2_;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = self->priv->db;
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = self->priv->sql;
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = rygel_media_export_sql_factory_make (_tmp4_, RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (_tmp3_, _tmp5_, values, values_length1, &_inner_error_);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 817 "rygel-media-export-media-cache.c"
		} else {
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 827 "rygel-media-export-media-cache.c"
		}
	}
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 832 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error) {
	RygelMediaObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (object != NULL);
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = object;
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = rygel_media_object_get_id (_tmp0_);
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = _tmp1_;
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_remove_by_id (self, _tmp2_, &_inner_error_);
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 861 "rygel-media-export-media-cache.c"
		} else {
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 869 "rygel-media-export-media-cache.c"
		}
	}
}


/**
     * Add the container to the cache, in a database transcation,
     * rolling back the transaction if necessary.
     */
static gpointer _g_error_copy0 (gpointer self) {
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return self ? g_error_copy (self) : NULL;
#line 882 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error) {
	GError * _inner_error_ = NULL;
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (container != NULL);
#line 892 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabase* _tmp0_ = NULL;
		RygelMediaContainer* _tmp1_ = NULL;
		RygelMediaContainer* _tmp2_ = NULL;
		RygelMediaExportDatabase* _tmp3_ = NULL;
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = self->priv->db;
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 906 "rygel-media-export-media-cache.c"
				goto __catch6_rygel_media_export_database_error;
			}
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 915 "rygel-media-export-media-cache.c"
		}
#line 111 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = container;
#line 111 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_save_container_metadata (self, _tmp1_, &_inner_error_);
#line 111 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 111 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 925 "rygel-media-export-media-cache.c"
				goto __catch6_rygel_media_export_database_error;
			}
			goto __finally6;
		}
#line 112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = container;
#line 112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) _tmp2_, FALSE, &_inner_error_);
#line 112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 938 "rygel-media-export-media-cache.c"
				goto __catch6_rygel_media_export_database_error;
			}
			goto __finally6;
		}
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = self->priv->db;
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (_tmp3_, &_inner_error_);
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 951 "rygel-media-export-media-cache.c"
				goto __catch6_rygel_media_export_database_error;
			}
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 960 "rygel-media-export-media-cache.c"
		}
	}
	goto __finally6;
	__catch6_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		RygelMediaExportDatabase* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = self->priv->db;
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_rollback (_tmp4_);
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = _error_;
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = _g_error_copy0 (_tmp5_);
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = _tmp6_;
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 986 "rygel-media-export-media-cache.c"
		goto __finally6;
	}
	__finally6:
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 996 "rygel-media-export-media-cache.c"
	}
}


/**
     * Add the item to the cache.
     */
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaFileItem* item, gboolean override_guarded, GError** error) {
	GError * _inner_error_ = NULL;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 1010 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabase* _tmp0_ = NULL;
		RygelMediaFileItem* _tmp1_ = NULL;
		RygelMediaFileItem* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		RygelMediaExportDatabase* _tmp4_ = NULL;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = self->priv->db;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 1025 "rygel-media-export-media-cache.c"
				goto __catch7_rygel_media_export_database_error;
			}
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 1034 "rygel-media-export-media-cache.c"
		}
#line 128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = item;
#line 128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_save_item_metadata (self, _tmp1_, &_inner_error_);
#line 128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 1044 "rygel-media-export-media-cache.c"
				goto __catch7_rygel_media_export_database_error;
			}
			goto __finally7;
		}
#line 129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = item;
#line 129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = override_guarded;
#line 129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) _tmp2_, _tmp3_, &_inner_error_);
#line 129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 1059 "rygel-media-export-media-cache.c"
				goto __catch7_rygel_media_export_database_error;
			}
			goto __finally7;
		}
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = self->priv->db;
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (_tmp4_, &_inner_error_);
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 1072 "rygel-media-export-media-cache.c"
				goto __catch7_rygel_media_export_database_error;
			}
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 1081 "rygel-media-export-media-cache.c"
		}
	}
	goto __finally7;
	__catch7_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp5_ = NULL;
		RygelMediaFileItem* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		RygelMediaExportDatabase* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
#line 126 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 126 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = _ ("Failed to add item with ID %s: %s");
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = item;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp6_);
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = _tmp7_;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = _error_;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = _tmp9_->message;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_warning (_tmp5_, _tmp8_, _tmp10_);
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = self->priv->db;
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_rollback (_tmp11_);
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp12_ = _error_;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp13_ = _g_error_copy0 (_tmp12_);
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = _tmp13_;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 1127 "rygel-media-export-media-cache.c"
		goto __finally7;
	}
	__finally7:
#line 126 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 126 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 126 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 1137 "rygel-media-export-media-cache.c"
	}
}


/**
     * Create a new container or item instance based on the ID.
     *
     * The Rygel server discards the object when the browse request is finished,
     * after serializing the result.
     */
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error) {
	RygelMediaObject* result = NULL;
	GValue* values = NULL;
	const gchar* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	RygelMediaObject* parent = NULL;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	GValue* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (object_id != NULL, NULL);
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = object_id;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_STRING);
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp1_, _tmp0_);
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = g_new0 (GValue, 1);
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_[0] = _tmp1_;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp2_;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	parent = NULL;
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = values;
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3__length1 = values_length1;
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT, _tmp3_, _tmp3__length1, &_inner_error_);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp4_;
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (parent);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1204 "rygel-media-export-media-cache.c"
		} else {
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (parent);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1216 "rygel-media-export-media-cache.c"
		}
	}
	{
		RygelMediaExportDatabaseCursorIterator* _statement_it = NULL;
		RygelMediaExportDatabaseCursor* _tmp5_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _tmp6_ = NULL;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = cursor;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_media_export_database_cursor_iterator (_tmp5_);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp6_;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 1231 "rygel-media-export-media-cache.c"
			gboolean _tmp7_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			sqlite3_stmt* statement = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp10_ = NULL;
			sqlite3_stmt* _tmp11_ = NULL;
			RygelMediaContainer* parent_container = NULL;
			RygelMediaObject* _tmp12_ = NULL;
			RygelMediaContainer* _tmp13_ = NULL;
			RygelMediaObject* object = NULL;
			RygelMediaContainer* _tmp14_ = NULL;
			sqlite3_stmt* _tmp15_ = NULL;
			RygelMediaObject* _tmp16_ = NULL;
			RygelMediaObject* _tmp17_ = NULL;
			RygelMediaContainer* _tmp18_ = NULL;
			RygelMediaObject* _tmp19_ = NULL;
			RygelMediaObject* _tmp20_ = NULL;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp8_ = _statement_it;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = rygel_media_export_database_cursor_iterator_next (_tmp8_, &_inner_error_);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp7_ = _tmp9_;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_propagate_error (error, _inner_error_);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (parent);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 1271 "rygel-media-export-media-cache.c"
				} else {
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (parent);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_clear_error (&_inner_error_);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 1287 "rygel-media-export-media-cache.c"
				}
			}
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp7_) {
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 1294 "rygel-media-export-media-cache.c"
			}
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = _statement_it;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = rygel_media_export_database_cursor_iterator_get (_tmp10_, &_inner_error_);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp11_;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_propagate_error (error, _inner_error_);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (parent);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 1318 "rygel-media-export-media-cache.c"
				} else {
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (parent);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_clear_error (&_inner_error_);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 1334 "rygel-media-export-media-cache.c"
				}
			}
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = parent;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp12_) : NULL);
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			parent_container = _tmp13_;
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = parent_container;
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = statement;
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp16_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp14_, _tmp15_);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			object = _tmp16_;
#line 157 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp17_ = object;
#line 157 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp18_ = parent_container;
#line 157 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_object_set_parent_ref (_tmp17_, _tmp18_);
#line 158 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp19_ = object;
#line 158 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp20_ = _g_object_ref0 (_tmp19_);
#line 158 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (parent);
#line 158 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			parent = _tmp20_;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (object);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (parent_container);
#line 1369 "rygel-media-export-media-cache.c"
		}
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 1373 "rygel-media-export-media-cache.c"
	}
#line 161 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = parent;
#line 161 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 161 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 161 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 1383 "rygel-media-export-media-cache.c"
}


RygelMediaContainer* rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error) {
	RygelMediaContainer* result = NULL;
	RygelMediaObject* object = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	RygelMediaObject* _tmp3_ = NULL;
	RygelMediaObject* _tmp7_ = NULL;
	RygelMediaContainer* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = container_id;
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = rygel_media_export_media_cache_get_object (self, _tmp0_, &_inner_error_);
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	object = _tmp1_;
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1415 "rygel-media-export-media-cache.c"
		} else {
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1423 "rygel-media-export-media-cache.c"
		}
	}
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = object;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp3_ != NULL) {
#line 1430 "rygel-media-export-media-cache.c"
		RygelMediaObject* _tmp4_ = NULL;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = object;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MEDIA_CONTAINER);
#line 1436 "rygel-media-export-media-cache.c"
	} else {
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = FALSE;
#line 1440 "rygel-media-export-media-cache.c"
	}
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp2_) {
#line 1444 "rygel-media-export-media-cache.c"
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = container_id;
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = g_error_new (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE, "Object with id %s is " "not a MediaContainer", _tmp5_);
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = _tmp6_;
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (object);
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1461 "rygel-media-export-media-cache.c"
		} else {
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (object);
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1471 "rygel-media-export-media-cache.c"
		}
	}
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = object;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp7_) : NULL);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp8_;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (object);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 1484 "rygel-media-export-media-cache.c"
}


gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error) {
	gint result = 0;
	GValue* values = NULL;
	const gchar* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GError * _inner_error_ = NULL;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, 0);
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = container_id;
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_STRING);
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp1_, _tmp0_);
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = g_new0 (GValue, 1);
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_[0] = _tmp1_;
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp2_;
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT, values, values_length1, &_inner_error_);
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = _tmp4_;
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return 0;
#line 1533 "rygel-media-export-media-cache.c"
		} else {
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return 0;
#line 1543 "rygel-media-export-media-cache.c"
		}
	}
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp3_;
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 1552 "rygel-media-export-media-cache.c"
}


guint32 rygel_media_export_media_cache_get_update_id (RygelMediaExportMediaCache* self) {
	guint32 result = 0U;
	GError * _inner_error_ = NULL;
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 1561 "rygel-media-export-media-cache.c"
	{
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_MAX_UPDATE_ID, NULL, 0, &_inner_error_);
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = _tmp1_;
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1571 "rygel-media-export-media-cache.c"
			goto __catch8_g_error;
		}
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = (guint32) _tmp0_;
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 1578 "rygel-media-export-media-cache.c"
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* _error_ = NULL;
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 1590 "rygel-media-export-media-cache.c"
	}
	__finally8:
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_clear_error (&_inner_error_);
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return 0U;
#line 1601 "rygel-media-export-media-cache.c"
	}
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = (guint32) 0;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 1607 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_get_track_properties (RygelMediaExportMediaCache* self, const gchar* id, guint32* object_update_id, guint32* container_update_id, guint32* total_deleted_child_count) {
	guint32 _vala_object_update_id = 0U;
	guint32 _vala_container_update_id = 0U;
	guint32 _vala_total_deleted_child_count = 0U;
	GValue* values = NULL;
	const gchar* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	GError * _inner_error_ = NULL;
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (id != NULL);
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = id;
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_STRING);
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp1_, _tmp0_);
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = g_new0 (GValue, 1);
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_[0] = _tmp1_;
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp2_;
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_object_update_id = (guint32) 0;
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_container_update_id = (guint32) 0;
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_total_deleted_child_count = (guint32) 0;
#line 1648 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabaseCursor* cursor = NULL;
		RygelMediaExportDatabase* _tmp3_ = NULL;
		GValue* _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		RygelMediaExportDatabaseCursor* _tmp5_ = NULL;
		sqlite3_stmt* statement = NULL;
		RygelMediaExportDatabaseCursor* _tmp6_ = NULL;
		sqlite3_stmt* _tmp7_ = NULL;
		sqlite3_stmt* _tmp8_ = NULL;
		gint64 _tmp9_ = 0LL;
		sqlite3_stmt* _tmp10_ = NULL;
		gint64 _tmp11_ = 0LL;
		sqlite3_stmt* _tmp12_ = NULL;
		gint64 _tmp13_ = 0LL;
#line 203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = self->priv->db;
#line 203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = values;
#line 203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4__length1 = values_length1;
#line 203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = rygel_media_export_database_exec_cursor (_tmp3_, "SELECT object_update_id, " "container_update_id, " "deleted_child_count " "FROM Object WHERE upnp_id = ?", _tmp4_, _tmp4__length1, &_inner_error_);
#line 203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		cursor = _tmp5_;
#line 203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1676 "rygel-media-export-media-cache.c"
			goto __catch9_g_error;
		}
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = cursor;
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = rygel_media_export_database_cursor_next (_tmp6_, &_inner_error_);
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		statement = _tmp7_;
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (cursor);
#line 1689 "rygel-media-export-media-cache.c"
			goto __catch9_g_error;
		}
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = statement;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = sqlite3_column_int64 (_tmp8_, 0);
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_object_update_id = (guint32) _tmp9_;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = statement;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = sqlite3_column_int64 (_tmp10_, 1);
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_container_update_id = (guint32) _tmp11_;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp12_ = statement;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp13_ = sqlite3_column_int64 (_tmp12_, 2);
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_total_deleted_child_count = (guint32) _tmp13_;
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (cursor);
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (object_update_id) {
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			*object_update_id = _vala_object_update_id;
#line 1718 "rygel-media-export-media-cache.c"
		}
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (container_update_id) {
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			*container_update_id = _vala_container_update_id;
#line 1724 "rygel-media-export-media-cache.c"
		}
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (total_deleted_child_count) {
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			*total_deleted_child_count = _vala_total_deleted_child_count;
#line 1730 "rygel-media-export-media-cache.c"
		}
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 1734 "rygel-media-export-media-cache.c"
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 202 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 202 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp14_ = _error_;
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp15_ = _tmp14_->message;
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_warning ("rygel-media-export-media-cache.vala:215: Failed to get update ids: %s", _tmp15_);
#line 202 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 1754 "rygel-media-export-media-cache.c"
	}
	__finally9:
#line 202 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 202 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 202 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 202 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_clear_error (&_inner_error_);
#line 202 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 1767 "rygel-media-export-media-cache.c"
	}
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (object_update_id) {
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*object_update_id = _vala_object_update_id;
#line 1775 "rygel-media-export-media-cache.c"
	}
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (container_update_id) {
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*container_update_id = _vala_container_update_id;
#line 1781 "rygel-media-export-media-cache.c"
	}
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (total_deleted_child_count) {
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*total_deleted_child_count = _vala_total_deleted_child_count;
#line 1787 "rygel-media-export-media-cache.c"
	}
}


gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error) {
	gint64 _vala_timestamp = 0LL;
	gint64 _vala_size = 0LL;
	gboolean result = FALSE;
	gchar* uri = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GValue* values = NULL;
	const gchar* _tmp2_ = NULL;
	GValue _tmp3_ = {0};
	GValue* _tmp4_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	GeeHashMap* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	GValue* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp18_ = NULL;
	sqlite3_stmt* statement = NULL;
	RygelMediaExportDatabaseCursor* _tmp19_ = NULL;
	sqlite3_stmt* _tmp20_ = NULL;
	sqlite3_stmt* _tmp21_ = NULL;
	gint64 _tmp22_ = 0LL;
	gint64 _tmp23_ = 0LL;
	sqlite3_stmt* _tmp24_ = NULL;
	gint64 _tmp25_ = 0LL;
	sqlite3_stmt* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	GError * _inner_error_ = NULL;
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = file;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = g_file_get_uri (_tmp0_);
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	uri = _tmp1_;
#line 224 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = uri;
#line 224 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp3_, G_TYPE_STRING);
#line 224 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp3_, _tmp2_);
#line 224 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = g_new0 (GValue, 1);
#line 224 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_[0] = _tmp3_;
#line 224 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp4_;
#line 224 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 224 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = self->priv->exists_cache;
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = uri;
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, _tmp6_);
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp7_) {
#line 1857 "rygel-media-export-media-cache.c"
		RygelMediaExportExistsCacheEntry* entry = NULL;
		GeeHashMap* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gpointer _tmp10_ = NULL;
		GeeHashMap* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		RygelMediaExportExistsCacheEntry* _tmp13_ = NULL;
		gint64 _tmp14_ = 0LL;
		RygelMediaExportExistsCacheEntry* _tmp15_ = NULL;
		gint64 _tmp16_ = 0LL;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = self->priv->exists_cache;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = uri;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, _tmp9_);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		entry = (RygelMediaExportExistsCacheEntry*) _tmp10_;
#line 228 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = self->priv->exists_cache;
#line 228 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp12_ = uri;
#line 228 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp11_, _tmp12_, NULL);
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp13_ = entry;
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp14_ = (*_tmp13_).mtime;
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_timestamp = _tmp14_;
#line 230 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp15_ = entry;
#line 230 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp16_ = (*_tmp15_).size;
#line 230 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_size = _tmp16_;
#line 232 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = TRUE;
#line 232 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_exists_cache_entry_free0 (entry);
#line 232 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 232 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (uri);
#line 232 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (timestamp) {
#line 232 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			*timestamp = _vala_timestamp;
#line 1906 "rygel-media-export-media-cache.c"
		}
#line 232 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (size) {
#line 232 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			*size = _vala_size;
#line 1912 "rygel-media-export-media-cache.c"
		}
#line 232 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 1916 "rygel-media-export-media-cache.c"
	}
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = values;
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17__length1 = values_length1;
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS, _tmp17_, _tmp17__length1, &_inner_error_);
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp18_;
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (uri);
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return FALSE;
#line 1938 "rygel-media-export-media-cache.c"
		} else {
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (uri);
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return FALSE;
#line 1950 "rygel-media-export-media-cache.c"
		}
	}
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = cursor;
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20_ = rygel_media_export_database_cursor_next (_tmp19_, &_inner_error_);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	statement = _tmp20_;
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (cursor);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (uri);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return FALSE;
#line 1973 "rygel-media-export-media-cache.c"
		} else {
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (cursor);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (uri);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return FALSE;
#line 1987 "rygel-media-export-media-cache.c"
		}
	}
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp21_ = statement;
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp22_ = sqlite3_column_int64 (_tmp21_, 1);
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_timestamp = _tmp22_;
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp23_ = _vala_timestamp;
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp23_ == G_MAXINT64) {
#line 241 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_timestamp = (gint64) 0;
#line 2002 "rygel-media-export-media-cache.c"
	}
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp24_ = statement;
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp25_ = sqlite3_column_int64 (_tmp24_, 2);
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_size = _tmp25_;
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_ = statement;
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp27_ = sqlite3_column_int (_tmp26_, 0);
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp27_ == 1;
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (uri);
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (timestamp) {
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*timestamp = _vala_timestamp;
#line 2026 "rygel-media-export-media-cache.c"
	}
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (size) {
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*size = _vala_size;
#line 2032 "rygel-media-export-media-cache.c"
	}
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 2036 "rygel-media-export-media-cache.c"
}


RygelMediaObjects* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self, RygelMediaContainer* container, const gchar* sort_criteria, glong offset, glong max_count, GError** error) {
	RygelMediaObjects* result = NULL;
	RygelMediaObjects* children = NULL;
	RygelMediaObjects* _tmp0_ = NULL;
	GValue* values = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GValue _tmp4_ = {0};
	glong _tmp5_ = 0L;
	GValue _tmp6_ = {0};
	glong _tmp7_ = 0L;
	GValue _tmp8_ = {0};
	GValue* _tmp9_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	gchar* sql = NULL;
	RygelMediaExportSQLFactory* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* sort_order = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	RygelMediaExportDatabase* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	GValue* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp21_ = NULL;
	RygelMediaExportDatabaseCursor* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
#line 248 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 248 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container != NULL, NULL);
#line 248 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (sort_criteria != NULL, NULL);
#line 253 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_objects_new ();
#line 253 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	children = _tmp0_;
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = container;
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp1_);
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = _tmp2_;
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp4_, G_TYPE_STRING);
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp4_, _tmp3_);
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = offset;
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp6_, G_TYPE_LONG);
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp6_, _tmp5_);
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = max_count;
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp8_, G_TYPE_LONG);
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp8_, _tmp7_);
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = g_new0 (GValue, 3);
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_[0] = _tmp4_;
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_[1] = _tmp6_;
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_[2] = _tmp8_;
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp9_;
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 3;
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = self->priv->sql;
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = rygel_media_export_sql_factory_make (_tmp10_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN);
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = g_strdup (_tmp11_);
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	sql = _tmp12_;
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = sort_criteria;
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = rygel_media_export_media_cache_translate_sort_criteria (_tmp13_, NULL, NULL);
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	sort_order = _tmp14_;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = self->priv->db;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = sql;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = sort_order;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = g_strdup_printf (_tmp16_, _tmp17_);
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = _tmp18_;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20_ = values;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20__length1 = values_length1;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp21_ = rygel_media_export_database_exec_cursor (_tmp15_, _tmp19_, _tmp20_, _tmp20__length1, &_inner_error_);
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp22_ = _tmp21_;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp19_);
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp22_;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (sort_order);
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (sql);
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (children);
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 2170 "rygel-media-export-media-cache.c"
	}
	{
		RygelMediaExportDatabaseCursorIterator* _statement_it = NULL;
		RygelMediaExportDatabaseCursor* _tmp23_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _tmp24_ = NULL;
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp23_ = cursor;
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp24_ = rygel_media_export_database_cursor_iterator (_tmp23_);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp24_;
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 2184 "rygel-media-export-media-cache.c"
			gboolean _tmp25_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp26_ = NULL;
			gboolean _tmp27_ = FALSE;
			sqlite3_stmt* statement = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp28_ = NULL;
			sqlite3_stmt* _tmp29_ = NULL;
			RygelMediaObjects* _tmp30_ = NULL;
			RygelMediaContainer* _tmp31_ = NULL;
			sqlite3_stmt* _tmp32_ = NULL;
			RygelMediaObject* _tmp33_ = NULL;
			RygelMediaObject* _tmp34_ = NULL;
			RygelMediaObjects* _tmp35_ = NULL;
			gpointer _tmp36_ = NULL;
			RygelMediaObject* _tmp37_ = NULL;
			RygelMediaContainer* _tmp38_ = NULL;
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp26_ = _statement_it;
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp27_ = rygel_media_export_database_cursor_iterator_next (_tmp26_, &_inner_error_);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp25_ = _tmp27_;
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (cursor);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sort_order);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sql);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (children);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 2224 "rygel-media-export-media-cache.c"
			}
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp25_) {
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 2230 "rygel-media-export-media-cache.c"
			}
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp28_ = _statement_it;
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp29_ = rygel_media_export_database_cursor_iterator_get (_tmp28_, &_inner_error_);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp29_;
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (cursor);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sort_order);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sql);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (children);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 2256 "rygel-media-export-media-cache.c"
			}
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp30_ = children;
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp31_ = container;
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp32_ = statement;
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp33_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp31_, _tmp32_);
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp34_ = _tmp33_;
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, _tmp34_);
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (_tmp34_);
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp35_ = children;
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp36_ = gee_list_last ((GeeList*) _tmp35_);
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp37_ = (RygelMediaObject*) _tmp36_;
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp38_ = container;
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_object_set_parent_ref (_tmp37_, _tmp38_);
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (_tmp37_);
#line 2284 "rygel-media-export-media-cache.c"
		}
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 2288 "rygel-media-export-media-cache.c"
	}
#line 269 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = children;
#line 269 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 269 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (sort_order);
#line 269 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (sql);
#line 269 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 269 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 2302 "rygel-media-export-media-cache.c"
}


RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, const gchar* sort_criteria, guint offset, guint max_count, guint* total_matches, GError** error) {
	guint _vala_total_matches = 0U;
	RygelMediaObjects* result = NULL;
	GValueArray* args = NULL;
	GValueArray* _tmp0_ = NULL;
	gchar* filter = NULL;
	RygelSearchExpression* _tmp1_ = NULL;
	GValueArray* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	RygelSearchExpression* _tmp4_ = NULL;
	guint max_objects = 0U;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	glong _tmp11_ = 0L;
	const gchar* _tmp12_ = NULL;
	GValueArray* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	glong _tmp15_ = 0L;
	RygelMediaObjects* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GValueArray* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	guint _tmp21_ = 0U;
	guint _tmp22_ = 0U;
	RygelMediaObjects* _tmp23_ = NULL;
	RygelMediaObjects* _tmp24_ = NULL;
	GError * _inner_error_ = NULL;
#line 272 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 272 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (sort_criteria != NULL, NULL);
#line 280 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = g_value_array_new ((guint) 0);
#line 280 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args = _tmp0_;
#line 281 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = expression;
#line 281 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = args;
#line 281 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_translate_search_expression (_tmp1_, _tmp2_, "WHERE", &_inner_error_);
#line 281 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	filter = _tmp3_;
#line 281 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 281 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 281 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 281 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 2358 "rygel-media-export-media-cache.c"
	}
#line 283 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = expression;
#line 283 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp4_ != NULL) {
#line 2364 "rygel-media-export-media-cache.c"
		RygelSearchExpression* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 284 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = expression;
#line 284 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_search_expression_to_string (_tmp5_);
#line 284 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = _tmp6_;
#line 284 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:284: Original search: %s", _tmp7_);
#line 284 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp7_);
#line 285 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = filter;
#line 285 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:285: Parsed search expression: %s", _tmp8_);
#line 2383 "rygel-media-export-media-cache.c"
	}
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = max_count;
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = rygel_media_export_media_cache_modify_limit (self, _tmp9_);
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	max_objects = _tmp10_;
#line 289 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = filter;
#line 289 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = args;
#line 289 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = container_id;
#line 289 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = rygel_media_export_media_cache_get_object_count_by_filter (self, _tmp12_, _tmp13_, _tmp14_, &_inner_error_);
#line 289 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = _tmp15_;
#line 289 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 289 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 289 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (filter);
#line 289 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 289 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 2411 "rygel-media-export-media-cache.c"
	}
#line 289 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_total_matches = (guint) _tmp11_;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = filter;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = args;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = container_id;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20_ = sort_criteria;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp21_ = offset;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp22_ = max_objects;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp23_ = rygel_media_export_media_cache_get_objects_by_filter (self, _tmp17_, _tmp18_, _tmp19_, _tmp20_, (glong) _tmp21_, (glong) _tmp22_, &_inner_error_);
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = _tmp23_;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (filter);
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 2441 "rygel-media-export-media-cache.c"
	}
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp24_ = _tmp16_;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = NULL;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp24_;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (_tmp16_);
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (filter);
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_value_array_free0 (args);
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (total_matches) {
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*total_matches = _vala_total_matches;
#line 2459 "rygel-media-export-media-cache.c"
	}
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 2463 "rygel-media-export-media-cache.c"
}


static GValue* _g_value_dup (GValue* self) {
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return g_boxed_copy (G_TYPE_VALUE, self);
#line 2470 "rygel-media-export-media-cache.c"
}


static gpointer __g_value_dup0 (gpointer self) {
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return self ? _g_value_dup (self) : NULL;
#line 2477 "rygel-media-export-media-cache.c"
}


static void _vala_GValue_free (GValue* self) {
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_unset (self);
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_free (self);
#line 2486 "rygel-media-export-media-cache.c"
}


glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, GError** error) {
	glong result = 0L;
	GValueArray* args = NULL;
	GValueArray* _tmp0_ = NULL;
	gchar* filter = NULL;
	RygelSearchExpression* _tmp1_ = NULL;
	GValueArray* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	RygelSearchExpression* _tmp4_ = NULL;
	glong _tmp27_ = 0L;
	const gchar* _tmp28_ = NULL;
	GValueArray* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	glong _tmp31_ = 0L;
	GError * _inner_error_ = NULL;
#line 301 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0L);
#line 305 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = g_value_array_new ((guint) 0);
#line 305 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args = _tmp0_;
#line 306 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = expression;
#line 306 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = args;
#line 306 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_translate_search_expression (_tmp1_, _tmp2_, "WHERE", &_inner_error_);
#line 306 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	filter = _tmp3_;
#line 306 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 306 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 306 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 306 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return 0L;
#line 2527 "rygel-media-export-media-cache.c"
	}
#line 308 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = expression;
#line 308 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp4_ != NULL) {
#line 2533 "rygel-media-export-media-cache.c"
		RygelSearchExpression* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = expression;
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_search_expression_to_string (_tmp5_);
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = _tmp6_;
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:309: Original search: %s", _tmp7_);
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp7_);
#line 310 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = filter;
#line 310 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:310: Parsed search expression: %s", _tmp8_);
#line 2552 "rygel-media-export-media-cache.c"
	}
	{
		gint i = 0;
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		i = 0;
#line 2558 "rygel-media-export-media-cache.c"
		{
			gboolean _tmp9_ = FALSE;
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = TRUE;
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			while (TRUE) {
#line 2565 "rygel-media-export-media-cache.c"
				gint _tmp11_ = 0;
				GValueArray* _tmp12_ = NULL;
				guint _tmp13_ = 0U;
				GValue* arg = NULL;
				GValueArray* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				GValue* _tmp16_ = NULL;
				GValue* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				GValue* _tmp19_ = NULL;
				gboolean _tmp20_ = FALSE;
				gint _tmp26_ = 0;
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!_tmp9_) {
#line 2580 "rygel-media-export-media-cache.c"
					gint _tmp10_ = 0;
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp10_ = i;
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					i = _tmp10_ + 1;
#line 2586 "rygel-media-export-media-cache.c"
				}
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp9_ = FALSE;
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp11_ = i;
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp12_ = args;
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp13_ = _tmp12_->n_values;
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!(((guint) _tmp11_) < _tmp13_)) {
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					break;
#line 2600 "rygel-media-export-media-cache.c"
				}
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp14_ = args;
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp15_ = i;
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp16_ = g_value_array_get_nth (_tmp14_, (guint) _tmp15_);
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp17_ = __g_value_dup0 (_tmp16_);
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				arg = _tmp17_;
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp19_ = arg;
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp20_ = G_VALUE_HOLDS (_tmp19_, G_TYPE_STRING);
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_tmp20_) {
#line 2618 "rygel-media-export-media-cache.c"
					GValue* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
#line 316 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp21_ = arg;
#line 316 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp22_ = g_value_get_string (_tmp21_);
#line 316 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp23_ = g_strdup (_tmp22_);
#line 316 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (_tmp18_);
#line 316 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp18_ = _tmp23_;
#line 2632 "rygel-media-export-media-cache.c"
				} else {
					GValue* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
#line 317 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp24_ = arg;
#line 317 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp25_ = g_strdup_value_contents (_tmp24_);
#line 317 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (_tmp18_);
#line 317 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp18_ = _tmp25_;
#line 2644 "rygel-media-export-media-cache.c"
				}
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp26_ = i;
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:315: Arg %d: %s", _tmp26_, _tmp18_);
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (_tmp18_);
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				__vala_GValue_free0 (arg);
#line 2654 "rygel-media-export-media-cache.c"
			}
		}
	}
#line 320 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp28_ = filter;
#line 320 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp29_ = args;
#line 320 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp30_ = container_id;
#line 320 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp31_ = rygel_media_export_media_cache_get_object_count_by_filter (self, _tmp28_, _tmp29_, _tmp30_, &_inner_error_);
#line 320 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp27_ = _tmp31_;
#line 320 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 320 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 320 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (filter);
#line 320 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 320 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return 0L;
#line 2678 "rygel-media-export-media-cache.c"
	}
#line 320 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp27_;
#line 320 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (filter);
#line 320 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_value_array_free0 (args);
#line 320 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 2688 "rygel-media-export-media-cache.c"
}


glong rygel_media_export_media_cache_get_object_count_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, GError** error) {
	glong result = 0L;
	const gchar* _tmp0_ = NULL;
	GValueArray* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	const gchar* pattern = NULL;
	RygelMediaExportSQLString string_id = 0;
	const gchar* _tmp7_ = NULL;
	RygelMediaExportSQLFactory* _tmp8_ = NULL;
	RygelMediaExportSQLString _tmp9_ = 0;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	RygelMediaExportDatabase* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	GValueArray* _tmp16_ = NULL;
	GValue* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	GError * _inner_error_ = NULL;
#line 325 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0L);
#line 325 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (filter != NULL, 0L);
#line 325 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, 0L);
#line 330 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = container_id;
#line 330 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp0_ != NULL) {
#line 2724 "rygel-media-export-media-cache.c"
		GValue v = {0};
		const gchar* _tmp1_ = NULL;
		GValue _tmp2_ = {0};
		GValueArray* _tmp3_ = NULL;
		GValue _tmp4_ = {0};
#line 331 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = container_id;
#line 331 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp2_, G_TYPE_STRING);
#line 331 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_string (&_tmp2_, _tmp1_);
#line 331 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		v = _tmp2_;
#line 332 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = args;
#line 332 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = v;
#line 332 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_array_prepend (_tmp3_, &_tmp4_);
#line 330 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 2746 "rygel-media-export-media-cache.c"
	}
#line 335 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = args;
#line 335 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = _tmp5_->n_values;
#line 335 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:335: Parameters to bind: %u", _tmp6_);
#line 338 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = container_id;
#line 338 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp7_ != NULL) {
#line 339 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		string_id = RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER_WITH_ANCESTOR;
#line 2760 "rygel-media-export-media-cache.c"
	} else {
#line 341 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		string_id = RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER;
#line 2764 "rygel-media-export-media-cache.c"
	}
#line 343 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = self->priv->sql;
#line 343 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = string_id;
#line 343 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = rygel_media_export_sql_factory_make (_tmp8_, _tmp9_);
#line 343 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	pattern = _tmp10_;
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = self->priv->db;
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = filter;
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = g_strdup_printf (pattern, _tmp13_);
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = _tmp14_;
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = args;
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = _tmp16_->values;
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17__length1 = (gint) _tmp16_->n_values;
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = rygel_media_export_database_query_value (_tmp12_, _tmp15_, _tmp17_, _tmp17__length1, &_inner_error_);
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = _tmp18_;
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp15_);
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = _tmp19_;
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return 0L;
#line 2802 "rygel-media-export-media-cache.c"
	}
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = (glong) _tmp11_;
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 2808 "rygel-media-export-media-cache.c"
}


RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, const gchar* sort_criteria, glong offset, glong max_count, GError** error) {
	RygelMediaObjects* result = NULL;
	RygelMediaObjects* children = NULL;
	RygelMediaObjects* _tmp0_ = NULL;
	GValue v = {0};
	glong _tmp1_ = 0L;
	GValue _tmp2_ = {0};
	GValueArray* _tmp3_ = NULL;
	GValue _tmp4_ = {0};
	glong _tmp5_ = 0L;
	GValue _tmp6_ = {0};
	GValueArray* _tmp7_ = NULL;
	GValue _tmp8_ = {0};
	RygelMediaContainer* parent = NULL;
	GValueArray* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	const gchar* sql = NULL;
	const gchar* _tmp29_ = NULL;
	gchar* sort_order = NULL;
	const gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	RygelMediaExportDatabase* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	GValueArray* _tmp42_ = NULL;
	GValue* _tmp43_ = NULL;
	gint _tmp43__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp44_ = NULL;
	RygelMediaExportDatabaseCursor* _tmp45_ = NULL;
	GError * _inner_error_ = NULL;
#line 348 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 348 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (filter != NULL, NULL);
#line 348 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 348 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (sort_criteria != NULL, NULL);
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_objects_new ();
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	children = _tmp0_;
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = offset;
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp2_, G_TYPE_LONG);
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp2_, _tmp1_);
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	v = _tmp2_;
#line 357 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = args;
#line 357 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = v;
#line 357 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_array_append (_tmp3_, &_tmp4_);
#line 358 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = max_count;
#line 358 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp6_, G_TYPE_LONG);
#line 358 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp6_, _tmp5_);
#line 358 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 358 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	v = _tmp6_;
#line 359 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = args;
#line 359 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = v;
#line 359 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_array_append (_tmp7_, &_tmp8_);
#line 360 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	parent = NULL;
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = args;
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = _tmp9_->n_values;
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:362: Parameters to bind: %u", _tmp10_);
#line 2896 "rygel-media-export-media-cache.c"
	{
		gint i = 0;
#line 363 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		i = 0;
#line 2901 "rygel-media-export-media-cache.c"
		{
			gboolean _tmp11_ = FALSE;
#line 363 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = TRUE;
#line 363 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			while (TRUE) {
#line 2908 "rygel-media-export-media-cache.c"
				gint _tmp13_ = 0;
				GValueArray* _tmp14_ = NULL;
				guint _tmp15_ = 0U;
				GValue* arg = NULL;
				GValueArray* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				GValue* _tmp18_ = NULL;
				GValue* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				GValue* _tmp21_ = NULL;
				gboolean _tmp22_ = FALSE;
				gint _tmp28_ = 0;
#line 363 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!_tmp11_) {
#line 2923 "rygel-media-export-media-cache.c"
					gint _tmp12_ = 0;
#line 363 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp12_ = i;
#line 363 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					i = _tmp12_ + 1;
#line 2929 "rygel-media-export-media-cache.c"
				}
#line 363 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp11_ = FALSE;
#line 363 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp13_ = i;
#line 363 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp14_ = args;
#line 363 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp15_ = _tmp14_->n_values;
#line 363 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!(((guint) _tmp13_) < _tmp15_)) {
#line 363 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					break;
#line 2943 "rygel-media-export-media-cache.c"
				}
#line 364 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp16_ = args;
#line 364 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp17_ = i;
#line 364 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp18_ = g_value_array_get_nth (_tmp16_, (guint) _tmp17_);
#line 364 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp19_ = __g_value_dup0 (_tmp18_);
#line 364 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				arg = _tmp19_;
#line 365 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp21_ = arg;
#line 365 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp22_ = G_VALUE_HOLDS (_tmp21_, G_TYPE_STRING);
#line 365 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_tmp22_) {
#line 2961 "rygel-media-export-media-cache.c"
					GValue* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp23_ = arg;
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp24_ = g_value_get_string (_tmp23_);
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp25_ = g_strdup (_tmp24_);
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (_tmp20_);
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp20_ = _tmp25_;
#line 2975 "rygel-media-export-media-cache.c"
				} else {
					GValue* _tmp26_ = NULL;
					gchar* _tmp27_ = NULL;
#line 367 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp26_ = arg;
#line 367 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp27_ = g_strdup_value_contents (_tmp26_);
#line 367 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (_tmp20_);
#line 367 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp20_ = _tmp27_;
#line 2987 "rygel-media-export-media-cache.c"
				}
#line 365 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp28_ = i;
#line 365 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:365: Arg %d: %s", _tmp28_, _tmp20_);
#line 363 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (_tmp20_);
#line 363 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				__vala_GValue_free0 (arg);
#line 2997 "rygel-media-export-media-cache.c"
			}
		}
	}
#line 371 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp29_ = container_id;
#line 371 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp29_ != NULL) {
#line 3005 "rygel-media-export-media-cache.c"
		RygelMediaExportSQLFactory* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
#line 372 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp30_ = self->priv->sql;
#line 372 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp31_ = rygel_media_export_sql_factory_make (_tmp30_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER_WITH_ANCESTOR);
#line 372 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		sql = _tmp31_;
#line 3014 "rygel-media-export-media-cache.c"
	} else {
		RygelMediaExportSQLFactory* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp32_ = self->priv->sql;
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp33_ = rygel_media_export_sql_factory_make (_tmp32_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER);
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		sql = _tmp33_;
#line 3024 "rygel-media-export-media-cache.c"
	}
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_ = sort_criteria;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp35_ = rygel_media_export_media_cache_translate_sort_criteria (_tmp34_, NULL, NULL);
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	sort_order = _tmp35_;
#line 378 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp36_ = self->priv->db;
#line 378 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp37_ = sql;
#line 378 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp38_ = filter;
#line 378 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp39_ = sort_order;
#line 378 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp40_ = g_strdup_printf (_tmp37_, _tmp38_, _tmp39_);
#line 378 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_ = _tmp40_;
#line 378 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp42_ = args;
#line 378 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp43_ = _tmp42_->values;
#line 378 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp43__length1 = (gint) _tmp42_->n_values;
#line 378 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp44_ = rygel_media_export_database_exec_cursor (_tmp36_, _tmp41_, _tmp43_, _tmp43__length1, &_inner_error_);
#line 378 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp45_ = _tmp44_;
#line 378 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp41_);
#line 378 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp45_;
#line 378 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 378 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 378 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (sort_order);
#line 378 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (parent);
#line 378 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 378 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (children);
#line 378 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 3072 "rygel-media-export-media-cache.c"
	}
	{
		RygelMediaExportDatabaseCursorIterator* _statement_it = NULL;
		RygelMediaExportDatabaseCursor* _tmp46_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _tmp47_ = NULL;
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp46_ = cursor;
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp47_ = rygel_media_export_database_cursor_iterator (_tmp46_);
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp47_;
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 3086 "rygel-media-export-media-cache.c"
			gboolean _tmp48_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp49_ = NULL;
			gboolean _tmp50_ = FALSE;
			sqlite3_stmt* statement = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp51_ = NULL;
			sqlite3_stmt* _tmp52_ = NULL;
			const gchar* parent_id = NULL;
			sqlite3_stmt* _tmp53_ = NULL;
			const gchar* _tmp54_ = NULL;
			gboolean _tmp55_ = FALSE;
			RygelMediaContainer* _tmp56_ = NULL;
			RygelMediaContainer* _tmp65_ = NULL;
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp49_ = _statement_it;
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp50_ = rygel_media_export_database_cursor_iterator_next (_tmp49_, &_inner_error_);
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp48_ = _tmp50_;
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (cursor);
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sort_order);
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (parent);
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (children);
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 3123 "rygel-media-export-media-cache.c"
			}
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp48_) {
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 3129 "rygel-media-export-media-cache.c"
			}
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp51_ = _statement_it;
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp52_ = rygel_media_export_database_cursor_iterator_get (_tmp51_, &_inner_error_);
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp52_;
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (cursor);
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sort_order);
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (parent);
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (children);
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 3155 "rygel-media-export-media-cache.c"
			}
#line 381 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp53_ = statement;
#line 381 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp54_ = sqlite3_column_text (_tmp53_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_PARENT);
#line 381 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			parent_id = _tmp54_;
#line 383 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp56_ = parent;
#line 383 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp56_ == NULL) {
#line 383 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp55_ = TRUE;
#line 3169 "rygel-media-export-media-cache.c"
			} else {
				const gchar* _tmp57_ = NULL;
				RygelMediaContainer* _tmp58_ = NULL;
				const gchar* _tmp59_ = NULL;
				const gchar* _tmp60_ = NULL;
#line 383 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp57_ = parent_id;
#line 383 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp58_ = parent;
#line 383 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp59_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp58_);
#line 383 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp60_ = _tmp59_;
#line 383 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp55_ = g_strcmp0 (_tmp57_, _tmp60_) != 0;
#line 3185 "rygel-media-export-media-cache.c"
			}
#line 383 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp55_) {
#line 3189 "rygel-media-export-media-cache.c"
				const gchar* _tmp61_ = NULL;
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp61_ = parent_id;
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_tmp61_ == NULL) {
#line 3195 "rygel-media-export-media-cache.c"
					RygelNullContainer* _tmp62_ = NULL;
#line 385 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp62_ = rygel_null_container_new_root ();
#line 385 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (parent);
#line 385 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					parent = (RygelMediaContainer*) _tmp62_;
#line 3203 "rygel-media-export-media-cache.c"
				} else {
					const gchar* _tmp63_ = NULL;
					RygelNullContainer* _tmp64_ = NULL;
#line 387 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp63_ = parent_id;
#line 387 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp64_ = rygel_null_container_new (_tmp63_, NULL, "MediaExport");
#line 387 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (parent);
#line 387 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					parent = (RygelMediaContainer*) _tmp64_;
#line 3215 "rygel-media-export-media-cache.c"
				}
			}
#line 391 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp65_ = parent;
#line 391 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp65_ != NULL) {
#line 3222 "rygel-media-export-media-cache.c"
				RygelMediaObjects* _tmp66_ = NULL;
				RygelMediaContainer* _tmp67_ = NULL;
				sqlite3_stmt* _tmp68_ = NULL;
				RygelMediaObject* _tmp69_ = NULL;
				RygelMediaObject* _tmp70_ = NULL;
				RygelMediaObjects* _tmp71_ = NULL;
				gpointer _tmp72_ = NULL;
				RygelMediaObject* _tmp73_ = NULL;
				RygelMediaContainer* _tmp74_ = NULL;
#line 392 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp66_ = children;
#line 392 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp67_ = parent;
#line 392 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp68_ = statement;
#line 392 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp69_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp67_, _tmp68_);
#line 392 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp70_ = _tmp69_;
#line 392 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp66_, _tmp70_);
#line 392 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (_tmp70_);
#line 394 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp71_ = children;
#line 394 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp72_ = gee_list_last ((GeeList*) _tmp71_);
#line 394 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp73_ = (RygelMediaObject*) _tmp72_;
#line 394 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp74_ = parent;
#line 394 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				rygel_media_object_set_parent_ref (_tmp73_, _tmp74_);
#line 394 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (_tmp73_);
#line 3258 "rygel-media-export-media-cache.c"
			} else {
				sqlite3_stmt* _tmp75_ = NULL;
				const gchar* _tmp76_ = NULL;
				const gchar* _tmp77_ = NULL;
#line 396 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp75_ = statement;
#line 396 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp76_ = sqlite3_column_text (_tmp75_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID);
#line 396 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp77_ = parent_id;
#line 396 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_warning ("Inconsistent database: item %s " "has no parent %s", _tmp76_, _tmp77_);
#line 3271 "rygel-media-export-media-cache.c"
			}
		}
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 3276 "rygel-media-export-media-cache.c"
	}
#line 403 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = children;
#line 403 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 403 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (sort_order);
#line 403 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (parent);
#line 403 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 403 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 3290 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_debug_statistics (RygelMediaExportMediaCache* self) {
	GError * _inner_error_ = NULL;
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 3298 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabaseCursor* cursor = NULL;
		RygelMediaExportDatabaseCursor* _tmp0_ = NULL;
#line 408 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:408: Database statistics:");
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_STATISTICS, NULL, 0, &_inner_error_);
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		cursor = _tmp0_;
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3310 "rygel-media-export-media-cache.c"
			goto __catch10_g_error;
		}
		{
			RygelMediaExportDatabaseCursorIterator* _statement_it = NULL;
			RygelMediaExportDatabaseCursor* _tmp1_ = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp2_ = NULL;
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp1_ = cursor;
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp2_ = rygel_media_export_database_cursor_iterator (_tmp1_);
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_statement_it = _tmp2_;
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			while (TRUE) {
#line 3325 "rygel-media-export-media-cache.c"
				gboolean _tmp3_ = FALSE;
				RygelMediaExportDatabaseCursorIterator* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				sqlite3_stmt* statement = NULL;
				RygelMediaExportDatabaseCursorIterator* _tmp6_ = NULL;
				sqlite3_stmt* _tmp7_ = NULL;
				sqlite3_stmt* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				sqlite3_stmt* _tmp10_ = NULL;
				gint _tmp11_ = 0;
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp4_ = _statement_it;
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp5_ = rygel_media_export_database_cursor_iterator_next (_tmp4_, &_inner_error_);
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp3_ = _tmp5_;
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 3348 "rygel-media-export-media-cache.c"
					goto __catch10_g_error;
				}
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!_tmp3_) {
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					break;
#line 3355 "rygel-media-export-media-cache.c"
				}
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp6_ = _statement_it;
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp7_ = rygel_media_export_database_cursor_iterator_get (_tmp6_, &_inner_error_);
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				statement = _tmp7_;
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 3369 "rygel-media-export-media-cache.c"
					goto __catch10_g_error;
				}
#line 411 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp8_ = statement;
#line 411 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp9_ = sqlite3_column_text (_tmp8_, 0);
#line 411 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp10_ = statement;
#line 411 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp11_ = sqlite3_column_int (_tmp10_, 1);
#line 411 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:411: %s: %d", _tmp9_, _tmp11_);
#line 3382 "rygel-media-export-media-cache.c"
			}
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 3386 "rygel-media-export-media-cache.c"
		}
#line 407 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (cursor);
#line 3390 "rygel-media-export-media-cache.c"
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* _error_ = NULL;
#line 407 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 407 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 407 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 3402 "rygel-media-export-media-cache.c"
	}
	__finally10:
#line 407 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 407 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 407 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_clear_error (&_inner_error_);
#line 407 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 3413 "rygel-media-export-media-cache.c"
	}
}


GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error) {
	GeeArrayList* result = NULL;
	GeeArrayList* children = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GValue* values = NULL;
	const gchar* _tmp1_ = NULL;
	GValue _tmp2_ = {0};
	GValue* _tmp3_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	GValue* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 418 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 418 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	children = _tmp0_;
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = container_id;
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp2_, G_TYPE_STRING);
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp2_, _tmp1_);
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = g_new0 (GValue, 1);
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_[0] = _tmp2_;
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp3_;
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 421 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = values;
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4__length1 = values_length1;
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS, _tmp4_, _tmp4__length1, &_inner_error_);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp5_;
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (children);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 3477 "rygel-media-export-media-cache.c"
		} else {
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (children);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 3489 "rygel-media-export-media-cache.c"
		}
	}
	{
		RygelMediaExportDatabaseCursorIterator* _statement_it = NULL;
		RygelMediaExportDatabaseCursor* _tmp6_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _tmp7_ = NULL;
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = cursor;
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = rygel_media_export_database_cursor_iterator (_tmp6_);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp7_;
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 3504 "rygel-media-export-media-cache.c"
			gboolean _tmp8_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
			sqlite3_stmt* statement = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp11_ = NULL;
			sqlite3_stmt* _tmp12_ = NULL;
			GeeArrayList* _tmp13_ = NULL;
			sqlite3_stmt* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = _statement_it;
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = rygel_media_export_database_cursor_iterator_next (_tmp9_, &_inner_error_);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp8_ = _tmp10_;
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_propagate_error (error, _inner_error_);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (children);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 3536 "rygel-media-export-media-cache.c"
				} else {
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (children);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_clear_error (&_inner_error_);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 3552 "rygel-media-export-media-cache.c"
				}
			}
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp8_) {
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 3559 "rygel-media-export-media-cache.c"
			}
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = _statement_it;
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = rygel_media_export_database_cursor_iterator_get (_tmp11_, &_inner_error_);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp12_;
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_propagate_error (error, _inner_error_);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (children);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 3583 "rygel-media-export-media-cache.c"
				} else {
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (children);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_clear_error (&_inner_error_);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 3599 "rygel-media-export-media-cache.c"
				}
			}
#line 425 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = children;
#line 425 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = statement;
#line 425 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = sqlite3_column_text (_tmp14_, 0);
#line 425 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp15_);
#line 3610 "rygel-media-export-media-cache.c"
		}
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 3614 "rygel-media-export-media-cache.c"
	}
#line 428 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = children;
#line 428 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 428 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 428 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 3624 "rygel-media-export-media-cache.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 3637 "rygel-media-export-media-cache.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 3668 "rygel-media-export-media-cache.c"
				goto __catch11_g_regex_error;
			}
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 3677 "rygel-media-export-media-cache.c"
		}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 3693 "rygel-media-export-media-cache.c"
				goto __catch11_g_regex_error;
			}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 3704 "rygel-media-export-media-cache.c"
		}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 3718 "rygel-media-export-media-cache.c"
	}
	goto __finally11;
	__catch11_g_regex_error:
	{
		GError* e = NULL;
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1287 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 3732 "rygel-media-export-media-cache.c"
	}
	__finally11:
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return NULL;
#line 3743 "rygel-media-export-media-cache.c"
	}
}


GeeList* rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self, const gchar* column, const gchar* filter, GValueArray* args, glong offset, const gchar* sort_criteria, glong max_count, gboolean add_all_container, GError** error) {
	GeeList* result = NULL;
	GValue v = {0};
	glong _tmp0_ = 0L;
	GValue _tmp1_ = {0};
	GValueArray* _tmp2_ = NULL;
	GValue _tmp3_ = {0};
	glong _tmp4_ = 0L;
	GValue _tmp5_ = {0};
	GValueArray* _tmp6_ = NULL;
	GValue _tmp7_ = {0};
	gchar* extra_columns = NULL;
	gint column_count = 0;
	GString* builder = NULL;
	GString* _tmp8_ = NULL;
	GeeArrayList* data = NULL;
	GeeArrayList* _tmp9_ = NULL;
	gchar* sql_sort_order = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	GString* _tmp26_ = NULL;
	RygelMediaExportSQLFactory* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	RygelMediaExportDatabase* _tmp33_ = NULL;
	GString* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	GValueArray* _tmp36_ = NULL;
	GValue* _tmp37_ = NULL;
	gint _tmp37__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp38_ = NULL;
	GError * _inner_error_ = NULL;
#line 431 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 431 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (column != NULL, NULL);
#line 431 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (filter != NULL, NULL);
#line 431 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 431 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (sort_criteria != NULL, NULL);
#line 440 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = offset;
#line 440 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_LONG);
#line 440 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp1_, _tmp0_);
#line 440 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	v = _tmp1_;
#line 441 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = args;
#line 441 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = v;
#line 441 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_array_append (_tmp2_, &_tmp3_);
#line 442 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = max_count;
#line 442 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp5_, G_TYPE_LONG);
#line 442 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp5_, _tmp4_);
#line 442 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 442 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	v = _tmp5_;
#line 443 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = args;
#line 443 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = v;
#line 443 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_array_append (_tmp6_, &_tmp7_);
#line 447 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = g_string_new ("");
#line 447 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	builder = _tmp8_;
#line 448 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 448 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	data = _tmp9_;
#line 450 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = sort_criteria;
#line 450 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = rygel_media_export_media_cache_translate_sort_criteria (_tmp10_, &_tmp11_, &_tmp12_);
#line 450 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (extra_columns);
#line 450 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	extra_columns = _tmp11_;
#line 450 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	column_count = _tmp12_;
#line 450 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	sql_sort_order = _tmp13_;
#line 457 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = sql_sort_order;
#line 457 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = string_replace (_tmp14_, "o.title", "_column");
#line 457 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (sql_sort_order);
#line 457 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	sql_sort_order = _tmp15_;
#line 458 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = extra_columns;
#line 458 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = string_replace (_tmp16_, "o.title", "1");
#line 458 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (extra_columns);
#line 458 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	extra_columns = _tmp17_;
#line 460 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = add_all_container;
#line 460 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp18_) {
#line 3871 "rygel-media-export-media-cache.c"
		GString* _tmp19_ = NULL;
		GString* _tmp25_ = NULL;
#line 461 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp19_ = builder;
#line 461 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_string_append (_tmp19_, "SELECT 'all_place_holder' AS _column ");
#line 3878 "rygel-media-export-media-cache.c"
		{
			gint i = 0;
#line 462 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			i = 0;
#line 3883 "rygel-media-export-media-cache.c"
			{
				gboolean _tmp20_ = FALSE;
#line 462 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp20_ = TRUE;
#line 462 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				while (TRUE) {
#line 3890 "rygel-media-export-media-cache.c"
					gint _tmp22_ = 0;
					gint _tmp23_ = 0;
					GString* _tmp24_ = NULL;
#line 462 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					if (!_tmp20_) {
#line 3896 "rygel-media-export-media-cache.c"
						gint _tmp21_ = 0;
#line 462 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
						_tmp21_ = i;
#line 462 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
						i = _tmp21_ + 1;
#line 3902 "rygel-media-export-media-cache.c"
					}
#line 462 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp20_ = FALSE;
#line 462 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp22_ = i;
#line 462 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp23_ = column_count;
#line 462 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					if (!(_tmp22_ < _tmp23_)) {
#line 462 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
						break;
#line 3914 "rygel-media-export-media-cache.c"
					}
#line 463 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp24_ = builder;
#line 463 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_string_append (_tmp24_, ", 1 ");
#line 3920 "rygel-media-export-media-cache.c"
				}
			}
		}
#line 465 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp25_ = builder;
#line 465 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_string_append (_tmp25_, "UNION ");
#line 3928 "rygel-media-export-media-cache.c"
	}
#line 469 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_ = builder;
#line 469 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp27_ = self->priv->sql;
#line 469 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp28_ = rygel_media_export_sql_factory_make (_tmp27_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN);
#line 469 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp29_ = column;
#line 469 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp30_ = extra_columns;
#line 469 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp31_ = filter;
#line 469 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_ = sql_sort_order;
#line 469 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_string_append_printf (_tmp26_, _tmp28_, _tmp29_, _tmp30_, _tmp31_, _tmp32_);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_ = self->priv->db;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_ = builder;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp35_ = _tmp34_->str;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp36_ = args;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp37_ = _tmp36_->values;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp37__length1 = (gint) _tmp36_->n_values;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp38_ = rygel_media_export_database_exec_cursor (_tmp33_, _tmp35_, _tmp37_, _tmp37__length1, &_inner_error_);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp38_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (sql_sort_order);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (data);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_string_free0 (builder);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (extra_columns);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 3978 "rygel-media-export-media-cache.c"
	}
	{
		RygelMediaExportDatabaseCursorIterator* _statement_it = NULL;
		RygelMediaExportDatabaseCursor* _tmp39_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _tmp40_ = NULL;
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp39_ = cursor;
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp40_ = rygel_media_export_database_cursor_iterator (_tmp39_);
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp40_;
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 3992 "rygel-media-export-media-cache.c"
			gboolean _tmp41_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp42_ = NULL;
			gboolean _tmp43_ = FALSE;
			sqlite3_stmt* statement = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp44_ = NULL;
			sqlite3_stmt* _tmp45_ = NULL;
			GeeArrayList* _tmp46_ = NULL;
			sqlite3_stmt* _tmp47_ = NULL;
			const gchar* _tmp48_ = NULL;
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp42_ = _statement_it;
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp43_ = rygel_media_export_database_cursor_iterator_next (_tmp42_, &_inner_error_);
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp41_ = _tmp43_;
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (cursor);
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sql_sort_order);
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (data);
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_string_free0 (builder);
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (extra_columns);
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 4028 "rygel-media-export-media-cache.c"
			}
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp41_) {
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 4034 "rygel-media-export-media-cache.c"
			}
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp44_ = _statement_it;
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp45_ = rygel_media_export_database_cursor_iterator_get (_tmp44_, &_inner_error_);
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp45_;
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (cursor);
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sql_sort_order);
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (data);
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_string_free0 (builder);
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (extra_columns);
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 4062 "rygel-media-export-media-cache.c"
			}
#line 477 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp46_ = data;
#line 477 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp47_ = statement;
#line 477 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp48_ = sqlite3_column_text (_tmp47_, 0);
#line 477 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, _tmp48_);
#line 4072 "rygel-media-export-media-cache.c"
		}
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 4076 "rygel-media-export-media-cache.c"
	}
#line 480 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = (GeeList*) data;
#line 480 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 480 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (sql_sort_order);
#line 480 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_string_free0 (builder);
#line 480 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (extra_columns);
#line 480 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 480 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 4092 "rygel-media-export-media-cache.c"
}


/**
     * TODO
     */
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const gchar* attribute, RygelSearchExpression* expression, const gchar* sort_criteria, glong offset, guint max_count, gboolean add_all_container, GError** error) {
	GeeList* result = NULL;
	GValueArray* args = NULL;
	GValueArray* _tmp0_ = NULL;
	gchar* filter = NULL;
	RygelSearchExpression* _tmp1_ = NULL;
	GValueArray* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* column = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	guint max_objects = 0U;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	GeeList* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GValueArray* _tmp12_ = NULL;
	glong _tmp13_ = 0L;
	const gchar* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	gboolean _tmp16_ = FALSE;
	GeeList* _tmp17_ = NULL;
	GeeList* _tmp18_ = NULL;
	GError * _inner_error_ = NULL;
#line 486 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 486 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (attribute != NULL, NULL);
#line 486 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (sort_criteria != NULL, NULL);
#line 494 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = g_value_array_new ((guint) 0);
#line 494 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args = _tmp0_;
#line 495 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = expression;
#line 495 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = args;
#line 495 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_translate_search_expression (_tmp1_, _tmp2_, "AND", &_inner_error_);
#line 495 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	filter = _tmp3_;
#line 495 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 495 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 495 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 495 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 4151 "rygel-media-export-media-cache.c"
	}
#line 499 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = filter;
#line 499 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:499: Parsed filter: %s", _tmp4_);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = attribute;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = rygel_media_export_media_cache_map_operand_to_column (_tmp5_, NULL, FALSE, &_inner_error_);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	column = _tmp6_;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (filter);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 4173 "rygel-media-export-media-cache.c"
	}
#line 502 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = max_count;
#line 502 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = rygel_media_export_media_cache_modify_limit (self, _tmp7_);
#line 502 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	max_objects = _tmp8_;
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = column;
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = filter;
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = args;
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = offset;
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = sort_criteria;
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = max_objects;
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = add_all_container;
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = rygel_media_export_media_cache_get_meta_data_column_by_filter (self, _tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_, (glong) _tmp15_, _tmp16_, &_inner_error_);
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = _tmp17_;
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (column);
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (filter);
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 4211 "rygel-media-export-media-cache.c"
	}
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = _tmp9_;
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = NULL;
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp18_;
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (_tmp9_);
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (column);
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (filter);
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_value_array_free0 (args);
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 4229 "rygel-media-export-media-cache.c"
}


static gchar* uuid_get (void) {
	gchar* result = NULL;
	guchar* id = NULL;
	guchar* _tmp0_ = NULL;
	gint id_length1 = 0;
	gint _id_size_ = 0;
	guchar* unparsed = NULL;
	guchar* _tmp1_ = NULL;
	gint unparsed_length1 = 0;
	gint _unparsed_size_ = 0;
	guchar* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guchar* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	guchar _tmp6_ = '\0';
	guchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar* _tmp8_ = NULL;
#line 8 "../../../src/librygel-core/uuid.vapi"
	_tmp0_ = g_new0 (guchar, 16);
#line 8 "../../../src/librygel-core/uuid.vapi"
	id = _tmp0_;
#line 8 "../../../src/librygel-core/uuid.vapi"
	id_length1 = 16;
#line 8 "../../../src/librygel-core/uuid.vapi"
	_id_size_ = id_length1;
#line 9 "../../../src/librygel-core/uuid.vapi"
	_tmp1_ = g_new0 (guchar, 51);
#line 9 "../../../src/librygel-core/uuid.vapi"
	unparsed = _tmp1_;
#line 9 "../../../src/librygel-core/uuid.vapi"
	unparsed_length1 = 51;
#line 9 "../../../src/librygel-core/uuid.vapi"
	_unparsed_size_ = unparsed_length1;
#line 11 "../../../src/librygel-core/uuid.vapi"
	_tmp2_ = id;
#line 11 "../../../src/librygel-core/uuid.vapi"
	_tmp2__length1 = id_length1;
#line 11 "../../../src/librygel-core/uuid.vapi"
	uuid_generate (_tmp2_);
#line 12 "../../../src/librygel-core/uuid.vapi"
	_tmp3_ = id;
#line 12 "../../../src/librygel-core/uuid.vapi"
	_tmp3__length1 = id_length1;
#line 12 "../../../src/librygel-core/uuid.vapi"
	_tmp4_ = unparsed;
#line 12 "../../../src/librygel-core/uuid.vapi"
	_tmp4__length1 = unparsed_length1;
#line 12 "../../../src/librygel-core/uuid.vapi"
	uuid_unparse (_tmp3_, _tmp4_);
#line 13 "../../../src/librygel-core/uuid.vapi"
	_tmp5_ = unparsed;
#line 13 "../../../src/librygel-core/uuid.vapi"
	_tmp5__length1 = unparsed_length1;
#line 13 "../../../src/librygel-core/uuid.vapi"
	_tmp5_[50] = (guchar) '\0';
#line 13 "../../../src/librygel-core/uuid.vapi"
	_tmp6_ = _tmp5_[50];
#line 15 "../../../src/librygel-core/uuid.vapi"
	_tmp7_ = unparsed;
#line 15 "../../../src/librygel-core/uuid.vapi"
	_tmp7__length1 = unparsed_length1;
#line 15 "../../../src/librygel-core/uuid.vapi"
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
#line 15 "../../../src/librygel-core/uuid.vapi"
	result = _tmp8_;
#line 15 "../../../src/librygel-core/uuid.vapi"
	unparsed = (g_free (unparsed), NULL);
#line 15 "../../../src/librygel-core/uuid.vapi"
	id = (g_free (id), NULL);
#line 15 "../../../src/librygel-core/uuid.vapi"
	return result;
#line 4309 "rygel-media-export-media-cache.c"
}


gchar* rygel_media_export_media_cache_get_reset_token (RygelMediaExportMediaCache* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 513 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 4318 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabaseCursor* cursor = NULL;
		RygelMediaExportDatabaseCursor* _tmp0_ = NULL;
		sqlite3_stmt* statement = NULL;
		RygelMediaExportDatabaseCursor* _tmp1_ = NULL;
		sqlite3_stmt* _tmp2_ = NULL;
		sqlite3_stmt* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 515 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_RESET_TOKEN, NULL, 0, &_inner_error_);
#line 515 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		cursor = _tmp0_;
#line 515 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 515 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 4336 "rygel-media-export-media-cache.c"
				goto __catch12_rygel_media_export_database_error;
			}
#line 515 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 515 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 515 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 4345 "rygel-media-export-media-cache.c"
		}
#line 516 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = cursor;
#line 516 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = rygel_media_export_database_cursor_next (_tmp1_, &_inner_error_);
#line 516 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		statement = _tmp2_;
#line 516 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 516 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (cursor);
#line 516 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 4359 "rygel-media-export-media-cache.c"
				goto __catch12_rygel_media_export_database_error;
			}
#line 516 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (cursor);
#line 516 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 516 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 516 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 4370 "rygel-media-export-media-cache.c"
		}
#line 518 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = statement;
#line 518 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = sqlite3_column_text (_tmp3_, 0);
#line 518 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 518 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp5_;
#line 518 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (cursor);
#line 518 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 4384 "rygel-media-export-media-cache.c"
	}
	goto __finally12;
	__catch12_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp6_ = NULL;
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 520 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_warning ("rygel-media-export-media-cache.vala:520: Failed to get reset token");
#line 522 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = uuid_get ();
#line 522 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp6_;
#line 522 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 522 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 4405 "rygel-media-export-media-cache.c"
	}
	__finally12:
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_clear_error (&_inner_error_);
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return NULL;
#line 4414 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_save_reset_token (RygelMediaExportMediaCache* self, const gchar* token) {
	GError * _inner_error_ = NULL;
#line 526 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 526 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (token != NULL);
#line 4424 "rygel-media-export-media-cache.c"
	{
		GValue* args = NULL;
		const gchar* _tmp0_ = NULL;
		GValue _tmp1_ = {0};
		GValue* _tmp2_ = NULL;
		gint args_length1 = 0;
		gint _args_size_ = 0;
		RygelMediaExportDatabase* _tmp3_ = NULL;
#line 528 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = token;
#line 528 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp1_, G_TYPE_STRING);
#line 528 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_string (&_tmp1_, _tmp0_);
#line 528 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = g_new0 (GValue, 1);
#line 528 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_[0] = _tmp1_;
#line 528 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		args = _tmp2_;
#line 528 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		args_length1 = 1;
#line 528 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_args_size_ = args_length1;
#line 530 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = self->priv->db;
#line 530 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp3_, "UPDATE schema_info SET reset_token = ?", args, args_length1, &_inner_error_);
#line 530 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 530 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			args = (_vala_GValue_array_free (args, args_length1), NULL);
#line 530 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 4459 "rygel-media-export-media-cache.c"
				goto __catch13_rygel_media_export_database_error;
			}
#line 530 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			args = (_vala_GValue_array_free (args, args_length1), NULL);
#line 530 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 530 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 530 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 4470 "rygel-media-export-media-cache.c"
		}
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		args = (_vala_GValue_array_free (args, args_length1), NULL);
#line 4474 "rygel-media-export-media-cache.c"
	}
	goto __finally13;
	__catch13_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 532 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = _error_;
#line 532 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = _tmp4_->message;
#line 532 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_warning ("rygel-media-export-media-cache.vala:532: Failed to persist ServiceRese" \
"tToken: %s", _tmp5_);
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 4494 "rygel-media-export-media-cache.c"
	}
	__finally13:
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_clear_error (&_inner_error_);
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 4505 "rygel-media-export-media-cache.c"
	}
}


void rygel_media_export_media_cache_drop_virtual_folders (RygelMediaExportMediaCache* self) {
	GError * _inner_error_ = NULL;
#line 536 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 4514 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabase* _tmp0_ = NULL;
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = self->priv->db;
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp0_, "DELETE FROM object WHERE " "upnp_id LIKE 'virtual-parent:%'", NULL, 0, &_inner_error_);
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 4525 "rygel-media-export-media-cache.c"
				goto __catch14_rygel_media_export_database_error;
			}
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 4534 "rygel-media-export-media-cache.c"
		}
	}
	goto __finally14;
	__catch14_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 537 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 537 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 541 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = _error_;
#line 541 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = _tmp1_->message;
#line 541 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_warning ("rygel-media-export-media-cache.vala:541: Failed to drop virtual folder" \
"s: %s", _tmp2_);
#line 537 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 4555 "rygel-media-export-media-cache.c"
	}
	__finally14:
#line 537 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 537 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 537 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_clear_error (&_inner_error_);
#line 537 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 4566 "rygel-media-export-media-cache.c"
	}
}


void rygel_media_export_media_cache_make_object_guarded (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean guarded) {
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gint guarded_val = 0;
	GError * _inner_error_ = NULL;
#line 545 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 545 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (object != NULL);
#line 547 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = guarded;
#line 547 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp1_) {
#line 547 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = 1;
#line 4586 "rygel-media-export-media-cache.c"
	} else {
#line 547 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = 0;
#line 4590 "rygel-media-export-media-cache.c"
	}
#line 547 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	guarded_val = _tmp0_;
#line 4594 "rygel-media-export-media-cache.c"
	{
		GValue* values = NULL;
		GValue _tmp2_ = {0};
		RygelMediaObject* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GValue _tmp6_ = {0};
		GValue* _tmp7_ = NULL;
		gint values_length1 = 0;
		gint _values_size_ = 0;
		RygelMediaExportDatabase* _tmp8_ = NULL;
		RygelMediaExportSQLFactory* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 550 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp2_, G_TYPE_INT);
#line 550 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp2_, guarded_val);
#line 550 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = object;
#line 550 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = rygel_media_object_get_id (_tmp3_);
#line 550 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = _tmp4_;
#line 550 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp6_, G_TYPE_STRING);
#line 550 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_string (&_tmp6_, _tmp5_);
#line 550 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = g_new0 (GValue, 2);
#line 550 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_[0] = _tmp2_;
#line 550 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_[1] = _tmp6_;
#line 550 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = _tmp7_;
#line 550 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values_length1 = 2;
#line 550 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_values_size_ = values_length1;
#line 553 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = self->priv->db;
#line 553 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = self->priv->sql;
#line 553 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = rygel_media_export_sql_factory_make (_tmp9_, RYGEL_MEDIA_EXPORT_SQL_STRING_MAKE_GUARDED);
#line 553 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp8_, _tmp10_, values, values_length1, &_inner_error_);
#line 553 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 553 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 553 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 4648 "rygel-media-export-media-cache.c"
				goto __catch15_rygel_media_export_database_error;
			}
#line 553 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 553 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 553 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 553 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 4659 "rygel-media-export-media-cache.c"
		}
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 4663 "rygel-media-export-media-cache.c"
	}
	goto __finally15;
	__catch15_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		RygelMediaObject* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 555 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = object;
#line 555 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp12_ = rygel_media_object_get_id (_tmp11_);
#line 555 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp13_ = _tmp12_;
#line 555 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp14_ = _error_;
#line 555 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp15_ = _tmp14_->message;
#line 555 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_warning ("rygel-media-export-media-cache.vala:555: Failed to mark item %s as gua" \
"rded (%d): %s", _tmp13_, guarded_val, _tmp15_);
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 4692 "rygel-media-export-media-cache.c"
	}
	__finally15:
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_clear_error (&_inner_error_);
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 4703 "rygel-media-export-media-cache.c"
	}
}


gchar* rygel_media_export_media_cache_create_reference (RygelMediaExportMediaCache* self, RygelMediaObject* object, RygelMediaContainer* parent, GError** error) {
	gchar* result = NULL;
	RygelMediaObject* _tmp0_ = NULL;
	RygelMediaObject* _tmp5_ = NULL;
	RygelMediaContainer* _tmp6_ = NULL;
	RygelMediaObject* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	RygelMediaObject* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	RygelMediaObject* _tmp17_ = NULL;
	RygelMediaObject* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GError * _inner_error_ = NULL;
#line 562 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 562 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (object != NULL, NULL);
#line 562 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 564 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = object;
#line 564 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_CONTAINER)) {
#line 4735 "rygel-media-export-media-cache.c"
		gchar* msg = NULL;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
#line 565 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = _ ("Cannot create references to containers");
#line 565 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = g_strdup (_tmp1_);
#line 565 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		msg = _tmp2_;
#line 567 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = msg;
#line 567 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, _tmp3_);
#line 567 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = _tmp4_;
#line 567 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 567 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (msg);
#line 567 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 4759 "rygel-media-export-media-cache.c"
	}
#line 570 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = object;
#line 570 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = parent;
#line 570 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_object_set_parent (_tmp5_, _tmp6_);
#line 574 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = object;
#line 574 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = rygel_media_object_get_ref_id (_tmp7_);
#line 574 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = _tmp8_;
#line 574 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp9_ == NULL) {
#line 4775 "rygel-media-export-media-cache.c"
		RygelMediaObject* _tmp10_ = NULL;
		RygelMediaObject* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
#line 575 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = object;
#line 575 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = object;
#line 575 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp12_ = rygel_media_object_get_id (_tmp11_);
#line 575 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp13_ = _tmp12_;
#line 575 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_object_set_ref_id (_tmp10_, _tmp13_);
#line 4790 "rygel-media-export-media-cache.c"
	}
#line 577 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = object;
#line 577 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = uuid_get ();
#line 577 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = _tmp15_;
#line 577 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_object_set_id (_tmp14_, _tmp16_);
#line 577 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp16_);
#line 579 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = object;
#line 579 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_save_item (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp17_) : NULL, FALSE, &_inner_error_);
#line 579 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 579 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 579 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 4812 "rygel-media-export-media-cache.c"
	}
#line 581 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = object;
#line 581 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = rygel_media_object_get_id (_tmp18_);
#line 581 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20_ = _tmp19_;
#line 581 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp21_ = g_strdup (_tmp20_);
#line 581 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp21_;
#line 581 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 4826 "rygel-media-export-media-cache.c"
}


static gboolean rygel_media_export_media_cache_is_object_guarded (RygelMediaExportMediaCache* self, const gchar* id) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 585 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 585 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (id != NULL, FALSE);
#line 4837 "rygel-media-export-media-cache.c"
	{
		GValue* id_value = NULL;
		const gchar* _tmp0_ = NULL;
		GValue _tmp1_ = {0};
		GValue* _tmp2_ = NULL;
		gint id_value_length1 = 0;
		gint _id_value_size_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 587 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = id;
#line 587 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp1_, G_TYPE_STRING);
#line 587 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_string (&_tmp1_, _tmp0_);
#line 587 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = g_new0 (GValue, 1);
#line 587 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_[0] = _tmp1_;
#line 587 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		id_value = _tmp2_;
#line 587 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		id_value_length1 = 1;
#line 587 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_id_value_size_ = id_value_length1;
#line 589 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_IS_GUARDED, id_value, id_value_length1, &_inner_error_);
#line 589 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = _tmp4_;
#line 589 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 589 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			id_value = (_vala_GValue_array_free (id_value, id_value_length1), NULL);
#line 589 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 4873 "rygel-media-export-media-cache.c"
				goto __catch16_rygel_media_export_database_error;
			}
#line 589 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			id_value = (_vala_GValue_array_free (id_value, id_value_length1), NULL);
#line 589 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 589 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 589 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return FALSE;
#line 4884 "rygel-media-export-media-cache.c"
		}
#line 589 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp3_ == 1;
#line 589 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		id_value = (_vala_GValue_array_free (id_value, id_value_length1), NULL);
#line 589 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 4892 "rygel-media-export-media-cache.c"
	}
	goto __finally16;
	__catch16_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 592 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = id;
#line 592 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = _error_;
#line 592 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = _tmp6_->message;
#line 592 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_warning ("rygel-media-export-media-cache.vala:592: Failed to get whether item %s" \
" is guarded: %s", _tmp5_, _tmp7_);
#line 596 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = FALSE;
#line 596 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 596 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 4919 "rygel-media-export-media-cache.c"
	}
	__finally16:
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_clear_error (&_inner_error_);
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return FALSE;
#line 4928 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_rebuild_exists_cache (RygelMediaExportMediaCache* self, GError** error) {
	GeeHashMap* _tmp0_ = NULL;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	RygelMediaExportDatabaseCursor* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 600 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 601 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_MEDIA_EXPORT_TYPE_EXISTS_CACHE_ENTRY, (GBoxedCopyFunc) rygel_media_export_exists_cache_entry_dup, rygel_media_export_exists_cache_entry_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 601 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->exists_cache);
#line 601 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self->priv->exists_cache = _tmp0_;
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS_CACHE, NULL, 0, &_inner_error_);
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp1_;
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 4957 "rygel-media-export-media-cache.c"
		} else {
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 4965 "rygel-media-export-media-cache.c"
		}
	}
	{
		RygelMediaExportDatabaseCursorIterator* _statement_it = NULL;
		RygelMediaExportDatabaseCursor* _tmp2_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _tmp3_ = NULL;
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = cursor;
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = rygel_media_export_database_cursor_iterator (_tmp2_);
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp3_;
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 4980 "rygel-media-export-media-cache.c"
			gboolean _tmp4_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			sqlite3_stmt* statement = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp7_ = NULL;
			sqlite3_stmt* _tmp8_ = NULL;
			RygelMediaExportExistsCacheEntry entry = {0};
			sqlite3_stmt* _tmp9_ = NULL;
			gint64 _tmp10_ = 0LL;
			sqlite3_stmt* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
			GeeHashMap* _tmp13_ = NULL;
			sqlite3_stmt* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			RygelMediaExportExistsCacheEntry _tmp16_ = {0};
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp5_ = _statement_it;
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp6_ = rygel_media_export_database_cursor_iterator_next (_tmp5_, &_inner_error_);
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp4_ = _tmp6_;
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_propagate_error (error, _inner_error_);
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return;
#line 5014 "rygel-media-export-media-cache.c"
				} else {
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_clear_error (&_inner_error_);
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return;
#line 5026 "rygel-media-export-media-cache.c"
				}
			}
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp4_) {
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 5033 "rygel-media-export-media-cache.c"
			}
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp7_ = _statement_it;
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp8_ = rygel_media_export_database_cursor_iterator_get (_tmp7_, &_inner_error_);
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp8_;
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_propagate_error (error, _inner_error_);
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return;
#line 5053 "rygel-media-export-media-cache.c"
				} else {
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_clear_error (&_inner_error_);
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return;
#line 5065 "rygel-media-export-media-cache.c"
				}
			}
#line 604 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			memset (&entry, 0, sizeof (RygelMediaExportExistsCacheEntry));
#line 605 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = statement;
#line 605 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = sqlite3_column_int64 (_tmp9_, 1);
#line 605 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			entry.mtime = _tmp10_;
#line 606 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = statement;
#line 606 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = sqlite3_column_int64 (_tmp11_, 0);
#line 606 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			entry.size = _tmp12_;
#line 607 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = self->priv->exists_cache;
#line 607 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = statement;
#line 607 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = sqlite3_column_text (_tmp14_, 2);
#line 607 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp16_ = entry;
#line 607 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _tmp15_, &_tmp16_);
#line 5092 "rygel-media-export-media-cache.c"
		}
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 5096 "rygel-media-export-media-cache.c"
	}
#line 600 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 5100 "rygel-media-export-media-cache.c"
}


static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self, guint max_count) {
	guint result = 0U;
	guint _tmp0_ = 0U;
#line 611 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 612 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = max_count;
#line 612 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp0_ == ((guint) 0)) {
#line 613 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = (guint) (-1);
#line 613 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 5117 "rygel-media-export-media-cache.c"
	} else {
		guint _tmp1_ = 0U;
#line 615 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = max_count;
#line 615 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp1_;
#line 615 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 5126 "rygel-media-export-media-cache.c"
	}
}


static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self, const gchar* name, GError** error) {
	RygelMediaExportDatabase* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	RygelMediaExportDatabase* _tmp2_ = NULL;
	RygelMediaExportDatabase* _tmp3_ = NULL;
	gint old_version = 0;
	gint current_version = 0;
	gint _tmp4_ = 0;
	GError * _inner_error_ = NULL;
#line 619 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 619 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (name != NULL);
#line 620 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = name;
#line 620 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = rygel_media_export_database_new (_tmp1_, &_inner_error_);
#line 620 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = _tmp2_;
#line 620 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 620 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 620 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 5156 "rygel-media-export-media-cache.c"
	}
#line 620 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = _tmp0_;
#line 620 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = NULL;
#line 620 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->db);
#line 620 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self->priv->db = _tmp3_;
#line 621 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	old_version = -1;
#line 622 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = atoi (RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION);
#line 622 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	current_version = _tmp4_;
#line 5172 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportMediaCacheUpgrader* upgrader = NULL;
		RygelMediaExportDatabase* _tmp5_ = NULL;
		RygelMediaExportSQLFactory* _tmp6_ = NULL;
		RygelMediaExportMediaCacheUpgrader* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		RygelMediaExportMediaCacheUpgrader* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gboolean _tmp11_ = FALSE;
		RygelMediaExportMediaCacheUpgrader* _tmp20_ = NULL;
#line 625 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = self->priv->db;
#line 625 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = self->priv->sql;
#line 625 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = rygel_media_export_media_cache_upgrader_new (_tmp5_, _tmp6_);
#line 625 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		upgrader = _tmp7_;
#line 626 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = upgrader;
#line 626 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = rygel_media_export_media_cache_upgrader_needs_upgrade (_tmp9_, &_tmp10_, &_inner_error_);
#line 626 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		old_version = _tmp10_;
#line 626 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = _tmp11_;
#line 626 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 626 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
#line 626 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 5205 "rygel-media-export-media-cache.c"
				goto __catch17_rygel_media_export_database_error;
			}
			goto __finally17;
		}
#line 626 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_tmp8_) {
#line 5212 "rygel-media-export-media-cache.c"
			RygelMediaExportMediaCacheUpgrader* _tmp12_ = NULL;
			gint _tmp13_ = 0;
#line 627 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = upgrader;
#line 627 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = old_version;
#line 627 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_export_media_cache_upgrader_upgrade (_tmp12_, _tmp13_);
#line 5221 "rygel-media-export-media-cache.c"
		} else {
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
#line 628 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = old_version;
#line 628 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = current_version;
#line 628 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp14_ == _tmp15_) {
#line 5231 "rygel-media-export-media-cache.c"
				RygelMediaExportMediaCacheUpgrader* _tmp16_ = NULL;
#line 629 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp16_ = upgrader;
#line 629 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				rygel_media_export_media_cache_upgrader_fix_schema (_tmp16_, &_inner_error_);
#line 629 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 629 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
#line 629 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 5243 "rygel-media-export-media-cache.c"
						goto __catch17_rygel_media_export_database_error;
					}
					goto __finally17;
				}
			} else {
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				GError* _tmp19_ = NULL;
#line 631 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp17_ = old_version;
#line 631 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp18_ = current_version;
#line 631 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_warning ("The version \"%d\" of the detected database" " is newer than our supported version \"%d\"", _tmp17_, _tmp18_);
#line 635 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (self->priv->db);
#line 635 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				self->priv->db = NULL;
#line 637 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp19_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, "Database format" " not supported");
#line 637 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_inner_error_ = _tmp19_;
#line 637 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
#line 637 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 5270 "rygel-media-export-media-cache.c"
					goto __catch17_rygel_media_export_database_error;
				}
				goto __finally17;
			}
		}
#line 640 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp20_ = upgrader;
#line 640 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_upgrader_ensure_indices (_tmp20_);
#line 624 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
#line 5282 "rygel-media-export-media-cache.c"
	}
	goto __finally17;
	__catch17_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
#line 624 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 624 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 642 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:642: %s", "Could not find schema version;" " checking for empty database...");
#line 5294 "rygel-media-export-media-cache.c"
		{
			gint rows = 0;
			RygelMediaExportDatabase* _tmp21_ = NULL;
			gint _tmp22_ = 0;
			gint _tmp23_ = 0;
#line 645 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp21_ = self->priv->db;
#line 645 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp22_ = rygel_media_export_database_query_value (_tmp21_, "SELECT count(type) FROM " "sqlite_master WHERE rowid=1", NULL, 0, &_inner_error_);
#line 645 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rows = _tmp22_;
#line 645 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 645 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 5310 "rygel-media-export-media-cache.c"
					goto __catch18_rygel_media_export_database_error;
				}
#line 645 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_error_free0 (_error_);
#line 645 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (_tmp0_);
#line 645 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 645 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_clear_error (&_inner_error_);
#line 645 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return;
#line 5323 "rygel-media-export-media-cache.c"
			}
#line 647 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp23_ = rows;
#line 647 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp23_ == 0) {
#line 5329 "rygel-media-export-media-cache.c"
				gboolean _tmp24_ = FALSE;
#line 648 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:648: Empty database, creating new " \
"schema version %s", RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION);
#line 650 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp24_ = rygel_media_export_media_cache_create_schema (self);
#line 650 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!_tmp24_) {
#line 651 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (self->priv->db);
#line 651 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					self->priv->db = NULL;
#line 653 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_error_free0 (_error_);
#line 653 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (_tmp0_);
#line 653 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return;
#line 5347 "rygel-media-export-media-cache.c"
				}
			} else {
#line 656 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_warning ("rygel-media-export-media-cache.vala:656: Incompatible schema... cannot" \
" proceed");
#line 657 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (self->priv->db);
#line 657 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				self->priv->db = NULL;
#line 659 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_error_free0 (_error_);
#line 659 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (_tmp0_);
#line 659 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return;
#line 5362 "rygel-media-export-media-cache.c"
			}
		}
		goto __finally18;
		__catch18_rygel_media_export_database_error:
		{
			GError* _error_ = NULL;
			GError* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			GError* _tmp27_ = NULL;
#line 644 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_error_ = _inner_error_;
#line 644 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_inner_error_ = NULL;
#line 662 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp25_ = _error_;
#line 662 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp26_ = _tmp25_->message;
#line 662 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_warning ("rygel-media-export-media-cache.vala:662: Something weird going on: %s", _tmp26_);
#line 663 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (self->priv->db);
#line 663 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			self->priv->db = NULL;
#line 665 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp27_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, "Invalid database");
#line 665 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_inner_error_ = _tmp27_;
#line 665 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_error_free0 (_error_);
#line 5392 "rygel-media-export-media-cache.c"
			goto __finally18;
		}
		__finally18:
#line 644 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 644 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_error_free0 (_error_);
#line 5400 "rygel-media-export-media-cache.c"
			goto __finally17;
		}
#line 624 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 5405 "rygel-media-export-media-cache.c"
	}
	__finally17:
#line 624 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 624 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 624 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (_tmp0_);
#line 624 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 5416 "rygel-media-export-media-cache.c"
	}
#line 619 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (_tmp0_);
#line 5420 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_save_container_metadata (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error) {
	GValue* values = NULL;
	GValue _tmp0_ = {0};
	GValue _tmp1_ = {0};
	GValue _tmp2_ = {0};
	GValue _tmp3_ = {0};
	RygelMediaContainer* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GValue _tmp7_ = {0};
	GValue _tmp8_ = {0};
	GValue _tmp9_ = {0};
	GValue _tmp10_ = {0};
	GValue _tmp11_ = {0};
	GValue _tmp12_ = {0};
	GValue _tmp13_ = {0};
	GValue _tmp14_ = {0};
	GValue _tmp15_ = {0};
	GValue _tmp16_ = {0};
	GValue _tmp17_ = {0};
	RygelMediaContainer* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GValue _tmp21_ = {0};
	GValue _tmp22_ = {0};
	GValue _tmp23_ = {0};
	GValue _tmp24_ = {0};
	GValue _tmp25_ = {0};
	GValue* _tmp26_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	RygelMediaExportDatabase* _tmp27_ = NULL;
	RygelMediaExportSQLFactory* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GError * _inner_error_ = NULL;
#line 670 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 670 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (container != NULL);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp0_, G_TYPE_INT);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp0_, 0);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_STRING);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp1_, "inode/directory");
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp2_, G_TYPE_INT);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp2_, -1);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp3_, G_TYPE_INT);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp3_, -1);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = container;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) _tmp4_);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = _tmp5_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp7_, G_TYPE_STRING);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp7_, _tmp6_);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp8_);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp9_);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp10_);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp11_, G_TYPE_INT);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp11_, -1);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp12_, G_TYPE_INT);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp12_, -1);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp13_, G_TYPE_INT);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp13_, -1);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp14_, G_TYPE_INT);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp14_, -1);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp15_, G_TYPE_INT);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp15_, -1);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp16_, G_TYPE_INT);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp16_, -1);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp17_, G_TYPE_INT);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp17_, -1);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = container;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp18_);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20_ = _tmp19_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp21_, G_TYPE_STRING);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp21_, _tmp20_);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp22_);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp23_);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp24_, G_TYPE_INT);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp24_, -1);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp25_);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_ = g_new0 (GValue, 20);
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[0] = _tmp0_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[1] = _tmp1_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[2] = _tmp2_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[3] = _tmp3_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[4] = _tmp7_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[5] = _tmp8_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[6] = _tmp9_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[7] = _tmp10_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[8] = _tmp11_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[9] = _tmp12_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[10] = _tmp13_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[11] = _tmp14_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[12] = _tmp15_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[13] = _tmp16_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[14] = _tmp17_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[15] = _tmp21_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[16] = _tmp22_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[17] = _tmp23_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[18] = _tmp24_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[19] = _tmp25_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp26_;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 20;
#line 672 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 693 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp27_ = self->priv->db;
#line 693 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp28_ = self->priv->sql;
#line 693 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp29_ = rygel_media_export_sql_factory_make (_tmp28_, RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA);
#line 693 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (_tmp27_, _tmp29_, values, values_length1, &_inner_error_);
#line 693 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 693 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 693 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 693 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 5607 "rygel-media-export-media-cache.c"
	}
#line 670 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 5611 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_save_item_metadata (RygelMediaExportMediaCache* self, RygelMediaFileItem* item, GError** error) {
	GValue* values = NULL;
	RygelMediaFileItem* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	GValue _tmp3_ = {0};
	RygelMediaFileItem* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GValue _tmp7_ = {0};
	GValue _tmp8_ = {0};
	GValue _tmp9_ = {0};
	RygelMediaFileItem* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GValue _tmp13_ = {0};
	GValue _tmp14_ = {0};
	GValue _tmp15_ = {0};
	RygelMediaFileItem* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GValue _tmp19_ = {0};
	GValue _tmp20_ = {0};
	GValue _tmp21_ = {0};
	GValue _tmp22_ = {0};
	GValue _tmp23_ = {0};
	GValue _tmp24_ = {0};
	GValue _tmp25_ = {0};
	GValue _tmp26_ = {0};
	RygelMediaFileItem* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GValue _tmp30_ = {0};
	RygelMediaFileItem* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	GValue _tmp34_ = {0};
	GValue _tmp35_ = {0};
	GValue _tmp36_ = {0};
	RygelMediaFileItem* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	GValue _tmp40_ = {0};
	GValue* _tmp41_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	RygelMediaFileItem* _tmp42_ = NULL;
	RygelMediaFileItem* _tmp107_ = NULL;
	RygelMediaFileItem* _tmp137_ = NULL;
	RygelMediaExportDatabase* _tmp146_ = NULL;
	RygelMediaExportSQLFactory* _tmp147_ = NULL;
	const gchar* _tmp148_ = NULL;
	GValue* _tmp149_ = NULL;
	gint _tmp149__length1 = 0;
	GError * _inner_error_ = NULL;
#line 697 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 697 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = item;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = rygel_media_file_item_get_size (_tmp0_);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = _tmp1_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp3_, G_TYPE_INT64);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int64 (&_tmp3_, _tmp2_);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = item;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = rygel_media_file_item_get_mime_type (_tmp4_);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = _tmp5_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp7_, G_TYPE_STRING);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp7_, _tmp6_);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp8_, G_TYPE_INT);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp8_, -1);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp9_, G_TYPE_INT);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp9_, -1);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = item;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) _tmp10_);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = _tmp11_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp13_, G_TYPE_STRING);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp13_, _tmp12_);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp14_);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp15_);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = item;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = rygel_media_object_get_date ((RygelMediaObject*) _tmp16_);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = _tmp17_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp19_, G_TYPE_STRING);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp19_, _tmp18_);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp20_, G_TYPE_INT);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp20_, -1);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp21_, G_TYPE_INT);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp21_, -1);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp22_, G_TYPE_INT);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp22_, -1);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp23_, G_TYPE_INT);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp23_, -1);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp24_, G_TYPE_INT);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp24_, -1);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp25_, G_TYPE_INT);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp25_, -1);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp26_, G_TYPE_INT);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp26_, -1);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp27_ = item;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp28_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp27_);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp29_ = _tmp28_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp30_, G_TYPE_STRING);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp30_, _tmp29_);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp31_ = item;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_ = rygel_media_file_item_get_dlna_profile (_tmp31_);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_ = _tmp32_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp34_, G_TYPE_STRING);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp34_, _tmp33_);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp35_);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp36_, G_TYPE_INT);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp36_, -1);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp37_ = item;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp38_ = rygel_media_object_get_creator ((RygelMediaObject*) _tmp37_);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp39_ = _tmp38_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp40_, G_TYPE_STRING);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp40_, _tmp39_);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_ = g_new0 (GValue, 20);
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[0] = _tmp3_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[1] = _tmp7_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[2] = _tmp8_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[3] = _tmp9_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[4] = _tmp13_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[5] = _tmp14_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[6] = _tmp15_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[7] = _tmp19_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[8] = _tmp20_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[9] = _tmp21_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[10] = _tmp22_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[11] = _tmp23_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[12] = _tmp24_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[13] = _tmp25_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[14] = _tmp26_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[15] = _tmp30_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[16] = _tmp34_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[17] = _tmp35_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[18] = _tmp36_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[19] = _tmp40_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp41_;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 20;
#line 699 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 720 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp42_ = item;
#line 720 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, RYGEL_TYPE_AUDIO_ITEM)) {
#line 5842 "rygel-media-export-media-cache.c"
		RygelAudioItem* audio_item = NULL;
		RygelMediaFileItem* _tmp43_ = NULL;
		RygelAudioItem* _tmp44_ = NULL;
		GValue* _tmp45_ = NULL;
		gint _tmp45__length1 = 0;
		RygelAudioItem* _tmp46_ = NULL;
		glong _tmp47_ = 0L;
		glong _tmp48_ = 0L;
		GValue _tmp49_ = {0};
		GValue _tmp50_ = {0};
		GValue* _tmp51_ = NULL;
		gint _tmp51__length1 = 0;
		RygelAudioItem* _tmp52_ = NULL;
		gint _tmp53_ = 0;
		gint _tmp54_ = 0;
		GValue _tmp55_ = {0};
		GValue _tmp56_ = {0};
		GValue* _tmp57_ = NULL;
		gint _tmp57__length1 = 0;
		RygelAudioItem* _tmp58_ = NULL;
		gint _tmp59_ = 0;
		gint _tmp60_ = 0;
		GValue _tmp61_ = {0};
		GValue _tmp62_ = {0};
		GValue* _tmp63_ = NULL;
		gint _tmp63__length1 = 0;
		RygelAudioItem* _tmp64_ = NULL;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		GValue _tmp67_ = {0};
		GValue _tmp68_ = {0};
		GValue* _tmp69_ = NULL;
		gint _tmp69__length1 = 0;
		RygelAudioItem* _tmp70_ = NULL;
		gint _tmp71_ = 0;
		gint _tmp72_ = 0;
		GValue _tmp73_ = {0};
		GValue _tmp74_ = {0};
		RygelMediaFileItem* _tmp75_ = NULL;
#line 721 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp43_ = item;
#line 721 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp43_) : NULL);
#line 721 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		audio_item = _tmp44_;
#line 722 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp45_ = values;
#line 722 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp45__length1 = values_length1;
#line 722 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp46_ = audio_item;
#line 722 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp47_ = rygel_audio_item_get_duration (_tmp46_);
#line 722 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp48_ = _tmp47_;
#line 722 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp49_, G_TYPE_LONG);
#line 722 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_long (&_tmp49_, _tmp48_);
#line 722 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp45_[14]) ? (g_value_unset (&_tmp45_[14]), NULL) : NULL;
#line 722 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp45_[14] = _tmp49_;
#line 722 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp50_ = _tmp45_[14];
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp51_ = values;
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp51__length1 = values_length1;
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp52_ = audio_item;
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp53_ = rygel_audio_item_get_bitrate (_tmp52_);
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp54_ = _tmp53_;
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp55_, G_TYPE_INT);
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp55_, _tmp54_);
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp51_[8]) ? (g_value_unset (&_tmp51_[8]), NULL) : NULL;
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp51_[8] = _tmp55_;
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp56_ = _tmp51_[8];
#line 724 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp57_ = values;
#line 724 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp57__length1 = values_length1;
#line 724 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp58_ = audio_item;
#line 724 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp59_ = rygel_audio_item_get_sample_freq (_tmp58_);
#line 724 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp60_ = _tmp59_;
#line 724 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp61_, G_TYPE_INT);
#line 724 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp61_, _tmp60_);
#line 724 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp57_[9]) ? (g_value_unset (&_tmp57_[9]), NULL) : NULL;
#line 724 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp57_[9] = _tmp61_;
#line 724 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp62_ = _tmp57_[9];
#line 725 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp63_ = values;
#line 725 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp63__length1 = values_length1;
#line 725 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp64_ = audio_item;
#line 725 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp65_ = rygel_audio_item_get_bits_per_sample (_tmp64_);
#line 725 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp66_ = _tmp65_;
#line 725 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp67_, G_TYPE_INT);
#line 725 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp67_, _tmp66_);
#line 725 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp63_[10]) ? (g_value_unset (&_tmp63_[10]), NULL) : NULL;
#line 725 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp63_[10] = _tmp67_;
#line 725 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp68_ = _tmp63_[10];
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp69_ = values;
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp69__length1 = values_length1;
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp70_ = audio_item;
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp71_ = rygel_audio_item_get_channels (_tmp70_);
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp72_ = _tmp71_;
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp73_, G_TYPE_INT);
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp73_, _tmp72_);
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp69_[11]) ? (g_value_unset (&_tmp69_[11]), NULL) : NULL;
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp69_[11] = _tmp73_;
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp74_ = _tmp69_[11];
#line 727 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp75_ = item;
#line 727 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM)) {
#line 5992 "rygel-media-export-media-cache.c"
			RygelMediaExportMusicItem* music_item = NULL;
			RygelMediaFileItem* _tmp76_ = NULL;
			RygelMediaExportMusicItem* _tmp77_ = NULL;
			GValue* _tmp78_ = NULL;
			gint _tmp78__length1 = 0;
			RygelMediaExportMusicItem* _tmp79_ = NULL;
			const gchar* _tmp80_ = NULL;
			const gchar* _tmp81_ = NULL;
			GValue _tmp82_ = {0};
			GValue _tmp83_ = {0};
			GValue* _tmp84_ = NULL;
			gint _tmp84__length1 = 0;
			RygelMediaExportMusicItem* _tmp85_ = NULL;
			const gchar* _tmp86_ = NULL;
			const gchar* _tmp87_ = NULL;
			GValue _tmp88_ = {0};
			GValue _tmp89_ = {0};
			GValue* _tmp90_ = NULL;
			gint _tmp90__length1 = 0;
			RygelMediaExportMusicItem* _tmp91_ = NULL;
			const gchar* _tmp92_ = NULL;
			const gchar* _tmp93_ = NULL;
			GValue _tmp94_ = {0};
			GValue _tmp95_ = {0};
			GValue* _tmp96_ = NULL;
			gint _tmp96__length1 = 0;
			RygelMediaExportMusicItem* _tmp97_ = NULL;
			gint _tmp98_ = 0;
			gint _tmp99_ = 0;
			GValue _tmp100_ = {0};
			GValue _tmp101_ = {0};
			GValue* _tmp102_ = NULL;
			gint _tmp102__length1 = 0;
			RygelMediaExportMusicItem* _tmp103_ = NULL;
			gint _tmp104_ = 0;
			GValue _tmp105_ = {0};
			GValue _tmp106_ = {0};
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp76_ = item;
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp77_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp76_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) _tmp76_) : NULL);
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			music_item = _tmp77_;
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp78_ = values;
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp78__length1 = values_length1;
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp79_ = music_item;
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp80_ = rygel_media_object_get_artist ((RygelMediaObject*) _tmp79_);
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp81_ = _tmp80_;
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp82_, G_TYPE_STRING);
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (&_tmp82_, _tmp81_);
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp78_[5]) ? (g_value_unset (&_tmp78_[5]), NULL) : NULL;
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp78_[5] = _tmp82_;
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp83_ = _tmp78_[5];
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp84_ = values;
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp84__length1 = values_length1;
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp85_ = music_item;
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp86_ = rygel_audio_item_get_album ((RygelAudioItem*) _tmp85_);
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp87_ = _tmp86_;
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp88_, G_TYPE_STRING);
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (&_tmp88_, _tmp87_);
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp84_[6]) ? (g_value_unset (&_tmp84_[6]), NULL) : NULL;
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp84_[6] = _tmp88_;
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp89_ = _tmp84_[6];
#line 731 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp90_ = values;
#line 731 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp90__length1 = values_length1;
#line 731 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp91_ = music_item;
#line 731 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp92_ = rygel_media_object_get_genre ((RygelMediaObject*) _tmp91_);
#line 731 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp93_ = _tmp92_;
#line 731 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp94_, G_TYPE_STRING);
#line 731 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (&_tmp94_, _tmp93_);
#line 731 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp90_[17]) ? (g_value_unset (&_tmp90_[17]), NULL) : NULL;
#line 731 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp90_[17] = _tmp94_;
#line 731 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp95_ = _tmp90_[17];
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp96_ = values;
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp96__length1 = values_length1;
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp97_ = music_item;
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp98_ = rygel_music_item_get_track_number ((RygelMusicItem*) _tmp97_);
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp99_ = _tmp98_;
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp100_, G_TYPE_INT);
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_int (&_tmp100_, _tmp99_);
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp96_[12]) ? (g_value_unset (&_tmp96_[12]), NULL) : NULL;
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp96_[12] = _tmp100_;
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp101_ = _tmp96_[12];
#line 733 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp102_ = values;
#line 733 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp102__length1 = values_length1;
#line 733 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp103_ = music_item;
#line 733 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp104_ = _tmp103_->disc;
#line 733 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp105_, G_TYPE_INT);
#line 733 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_int (&_tmp105_, _tmp104_);
#line 733 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp102_[18]) ? (g_value_unset (&_tmp102_[18]), NULL) : NULL;
#line 733 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp102_[18] = _tmp105_;
#line 733 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp106_ = _tmp102_[18];
#line 727 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (music_item);
#line 6136 "rygel-media-export-media-cache.c"
		}
#line 720 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (audio_item);
#line 6140 "rygel-media-export-media-cache.c"
	}
#line 737 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp107_ = item;
#line 737 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp107_, RYGEL_TYPE_VISUAL_ITEM)) {
#line 6146 "rygel-media-export-media-cache.c"
		RygelVisualItem* visual_item = NULL;
		RygelMediaFileItem* _tmp108_ = NULL;
		RygelVisualItem* _tmp109_ = NULL;
		GValue* _tmp110_ = NULL;
		gint _tmp110__length1 = 0;
		RygelVisualItem* _tmp111_ = NULL;
		gint _tmp112_ = 0;
		gint _tmp113_ = 0;
		GValue _tmp114_ = {0};
		GValue _tmp115_ = {0};
		GValue* _tmp116_ = NULL;
		gint _tmp116__length1 = 0;
		RygelVisualItem* _tmp117_ = NULL;
		gint _tmp118_ = 0;
		gint _tmp119_ = 0;
		GValue _tmp120_ = {0};
		GValue _tmp121_ = {0};
		GValue* _tmp122_ = NULL;
		gint _tmp122__length1 = 0;
		RygelVisualItem* _tmp123_ = NULL;
		gint _tmp124_ = 0;
		gint _tmp125_ = 0;
		GValue _tmp126_ = {0};
		GValue _tmp127_ = {0};
		RygelMediaFileItem* _tmp128_ = NULL;
#line 738 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp108_ = item;
#line 738 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp109_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp108_) : NULL);
#line 738 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		visual_item = _tmp109_;
#line 739 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp110_ = values;
#line 739 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp110__length1 = values_length1;
#line 739 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp111_ = visual_item;
#line 739 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp112_ = rygel_visual_item_get_width (_tmp111_);
#line 739 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp113_ = _tmp112_;
#line 739 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp114_, G_TYPE_INT);
#line 739 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp114_, _tmp113_);
#line 739 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp110_[2]) ? (g_value_unset (&_tmp110_[2]), NULL) : NULL;
#line 739 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp110_[2] = _tmp114_;
#line 739 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp115_ = _tmp110_[2];
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp116_ = values;
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp116__length1 = values_length1;
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp117_ = visual_item;
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp118_ = rygel_visual_item_get_height (_tmp117_);
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp119_ = _tmp118_;
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp120_, G_TYPE_INT);
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp120_, _tmp119_);
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp116_[3]) ? (g_value_unset (&_tmp116_[3]), NULL) : NULL;
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp116_[3] = _tmp120_;
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp121_ = _tmp116_[3];
#line 741 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp122_ = values;
#line 741 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp122__length1 = values_length1;
#line 741 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp123_ = visual_item;
#line 741 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp124_ = rygel_visual_item_get_color_depth (_tmp123_);
#line 741 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp125_ = _tmp124_;
#line 741 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp126_, G_TYPE_INT);
#line 741 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp126_, _tmp125_);
#line 741 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp122_[13]) ? (g_value_unset (&_tmp122_[13]), NULL) : NULL;
#line 741 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp122_[13] = _tmp126_;
#line 741 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp127_ = _tmp122_[13];
#line 742 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp128_ = item;
#line 742 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp128_, RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM)) {
#line 6242 "rygel-media-export-media-cache.c"
			RygelMediaExportVideoItem* video_item = NULL;
			RygelMediaFileItem* _tmp129_ = NULL;
			RygelMediaExportVideoItem* _tmp130_ = NULL;
			GValue* _tmp131_ = NULL;
			gint _tmp131__length1 = 0;
			RygelMediaExportVideoItem* _tmp132_ = NULL;
			const gchar* _tmp133_ = NULL;
			const gchar* _tmp134_ = NULL;
			GValue _tmp135_ = {0};
			GValue _tmp136_ = {0};
#line 743 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp129_ = item;
#line 743 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp130_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp129_, RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM) ? ((RygelMediaExportVideoItem*) _tmp129_) : NULL);
#line 743 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			video_item = _tmp130_;
#line 744 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp131_ = values;
#line 744 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp131__length1 = values_length1;
#line 744 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp132_ = video_item;
#line 744 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp133_ = rygel_video_item_get_author ((RygelVideoItem*) _tmp132_);
#line 744 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp134_ = _tmp133_;
#line 744 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp135_, G_TYPE_STRING);
#line 744 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (&_tmp135_, _tmp134_);
#line 744 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp131_[5]) ? (g_value_unset (&_tmp131_[5]), NULL) : NULL;
#line 744 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp131_[5] = _tmp135_;
#line 744 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp136_ = _tmp131_[5];
#line 742 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (video_item);
#line 6281 "rygel-media-export-media-cache.c"
		}
#line 737 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (visual_item);
#line 6285 "rygel-media-export-media-cache.c"
	}
#line 748 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp137_ = item;
#line 748 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp137_, RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM)) {
#line 6291 "rygel-media-export-media-cache.c"
		RygelMediaExportPlaylistItem* playlist_item = NULL;
		RygelMediaFileItem* _tmp138_ = NULL;
		RygelMediaExportPlaylistItem* _tmp139_ = NULL;
		GValue* _tmp140_ = NULL;
		gint _tmp140__length1 = 0;
		RygelMediaExportPlaylistItem* _tmp141_ = NULL;
		const gchar* _tmp142_ = NULL;
		const gchar* _tmp143_ = NULL;
		GValue _tmp144_ = {0};
		GValue _tmp145_ = {0};
#line 749 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp138_ = item;
#line 749 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp139_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp138_, RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM) ? ((RygelMediaExportPlaylistItem*) _tmp138_) : NULL);
#line 749 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		playlist_item = _tmp139_;
#line 751 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp140_ = values;
#line 751 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp140__length1 = values_length1;
#line 751 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp141_ = playlist_item;
#line 751 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp142_ = rygel_media_object_get_creator ((RygelMediaObject*) _tmp141_);
#line 751 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp143_ = _tmp142_;
#line 751 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp144_, G_TYPE_STRING);
#line 751 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_string (&_tmp144_, _tmp143_);
#line 751 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp140_[5]) ? (g_value_unset (&_tmp140_[5]), NULL) : NULL;
#line 751 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp140_[5] = _tmp144_;
#line 751 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp145_ = _tmp140_[5];
#line 748 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (playlist_item);
#line 6330 "rygel-media-export-media-cache.c"
	}
#line 754 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp146_ = self->priv->db;
#line 754 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp147_ = self->priv->sql;
#line 754 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp148_ = rygel_media_export_sql_factory_make (_tmp147_, RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA);
#line 754 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp149_ = values;
#line 754 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp149__length1 = values_length1;
#line 754 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (_tmp146_, _tmp148_, _tmp149_, _tmp149__length1, &_inner_error_);
#line 754 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 754 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 754 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 754 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 6352 "rygel-media-export-media-cache.c"
	}
#line 697 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 6356 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_update_guarded_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error) {
	gint type = 0;
	GValue parent = {0};
	RygelMediaObject* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMediaContainer* _tmp2_ = NULL;
	RygelMediaContainer* _tmp3_ = NULL;
	GValue* values = NULL;
	gint _tmp11_ = 0;
	GValue _tmp12_ = {0};
	GValue _tmp13_ = {0};
	GValue _tmp14_ = {0};
	RygelMediaObject* _tmp15_ = NULL;
	guint64 _tmp16_ = 0ULL;
	guint64 _tmp17_ = 0ULL;
	GValue _tmp18_ = {0};
	RygelMediaObject* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GValue _tmp21_ = {0};
	RygelMediaObject* _tmp22_ = NULL;
	guint _tmp23_ = 0U;
	guint _tmp24_ = 0U;
	GValue _tmp25_ = {0};
	GValue _tmp26_ = {0};
	GValue _tmp27_ = {0};
	RygelMediaObject* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	GValue _tmp31_ = {0};
	GValue* _tmp32_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	RygelMediaObject* _tmp33_ = NULL;
	RygelMediaExportDatabase* _tmp46_ = NULL;
	RygelMediaExportSQLFactory* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	GValue* _tmp49_ = NULL;
	gint _tmp49__length1 = 0;
	GError * _inner_error_ = NULL;
#line 757 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 757 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (object != NULL);
#line 758 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER;
#line 761 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = object;
#line 761 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
#line 762 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM;
#line 6411 "rygel-media-export-media-cache.c"
	}
#line 765 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = object;
#line 765 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = rygel_media_object_get_parent (_tmp1_);
#line 765 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = _tmp2_;
#line 765 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp3_ == NULL) {
#line 6421 "rygel-media-export-media-cache.c"
		GValue _tmp4_ = {0};
#line 766 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_null (&_tmp4_);
#line 766 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 766 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		parent = _tmp4_;
#line 6429 "rygel-media-export-media-cache.c"
	} else {
		RygelMediaObject* _tmp5_ = NULL;
		RygelMediaContainer* _tmp6_ = NULL;
		RygelMediaContainer* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GValue _tmp10_ = {0};
#line 768 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = object;
#line 768 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_media_object_get_parent (_tmp5_);
#line 768 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = _tmp6_;
#line 768 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp7_);
#line 768 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = _tmp8_;
#line 768 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp10_, G_TYPE_STRING);
#line 768 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_string (&_tmp10_, _tmp9_);
#line 768 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 768 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		parent = _tmp10_;
#line 6455 "rygel-media-export-media-cache.c"
	}
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = type;
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp12_, G_TYPE_INT);
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp12_, _tmp11_);
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = parent;
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_IS_VALUE (&_tmp13_)) {
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp14_, G_VALUE_TYPE (&_tmp13_));
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_copy (&_tmp13_, &_tmp14_);
#line 6471 "rygel-media-export-media-cache.c"
	} else {
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp14_ = _tmp13_;
#line 6475 "rygel-media-export-media-cache.c"
	}
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = object;
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = rygel_media_object_get_modified (_tmp15_);
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = _tmp16_;
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp18_, G_TYPE_UINT64);
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_uint64 (&_tmp18_, _tmp17_);
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = object;
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20_ = rygel_media_object_get_primary_uri (_tmp19_);
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp21_, G_TYPE_STRING);
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_take_string (&_tmp21_, _tmp20_);
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp22_ = object;
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp23_ = rygel_media_object_get_object_update_id (_tmp22_);
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp24_ = _tmp23_;
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp25_, G_TYPE_UINT);
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_uint (&_tmp25_, _tmp24_);
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp26_, G_TYPE_INT);
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp26_, -1);
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp27_, G_TYPE_INT);
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp27_, -1);
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp28_ = object;
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp29_ = rygel_media_object_get_id (_tmp28_);
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp30_ = _tmp29_;
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp31_, G_TYPE_STRING);
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp31_, _tmp30_);
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_ = g_new0 (GValue, 8);
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[0] = _tmp12_;
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[1] = _tmp14_;
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[2] = _tmp18_;
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[3] = _tmp21_;
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[4] = _tmp25_;
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[5] = _tmp26_;
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[6] = _tmp27_;
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_[7] = _tmp31_;
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp32_;
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 8;
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 780 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_ = object;
#line 780 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, RYGEL_TYPE_MEDIA_CONTAINER)) {
#line 6551 "rygel-media-export-media-cache.c"
		RygelMediaContainer* container = NULL;
		RygelMediaObject* _tmp34_ = NULL;
		RygelMediaContainer* _tmp35_ = NULL;
		GValue* _tmp36_ = NULL;
		gint _tmp36__length1 = 0;
		RygelMediaContainer* _tmp37_ = NULL;
		gint64 _tmp38_ = 0LL;
		GValue _tmp39_ = {0};
		GValue _tmp40_ = {0};
		GValue* _tmp41_ = NULL;
		gint _tmp41__length1 = 0;
		RygelMediaContainer* _tmp42_ = NULL;
		guint32 _tmp43_ = 0U;
		GValue _tmp44_ = {0};
		GValue _tmp45_ = {0};
#line 781 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp34_ = object;
#line 781 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp34_) : NULL);
#line 781 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		container = _tmp35_;
#line 782 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp36_ = values;
#line 782 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp36__length1 = values_length1;
#line 782 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp37_ = container;
#line 782 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp38_ = _tmp37_->total_deleted_child_count;
#line 782 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp39_, G_TYPE_INT64);
#line 782 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int64 (&_tmp39_, _tmp38_);
#line 782 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp36_[6]) ? (g_value_unset (&_tmp36_[6]), NULL) : NULL;
#line 782 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp36_[6] = _tmp39_;
#line 782 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp40_ = _tmp36_[6];
#line 783 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp41_ = values;
#line 783 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp41__length1 = values_length1;
#line 783 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp42_ = container;
#line 783 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp43_ = _tmp42_->update_id;
#line 783 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp44_, G_TYPE_UINT);
#line 783 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_uint (&_tmp44_, _tmp43_);
#line 783 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp41_[7]) ? (g_value_unset (&_tmp41_[7]), NULL) : NULL;
#line 783 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp41_[7] = _tmp44_;
#line 783 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp45_ = _tmp41_[7];
#line 780 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (container);
#line 6611 "rygel-media-export-media-cache.c"
	}
#line 786 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp46_ = self->priv->db;
#line 786 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp47_ = self->priv->sql;
#line 786 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp48_ = rygel_media_export_sql_factory_make (_tmp47_, RYGEL_MEDIA_EXPORT_SQL_STRING_UPDATE_GUARDED_OBJECT);
#line 786 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp49_ = values;
#line 786 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp49__length1 = values_length1;
#line 786 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (_tmp46_, _tmp48_, _tmp49_, _tmp49__length1, &_inner_error_);
#line 786 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 786 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 786 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 786 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 786 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 6635 "rygel-media-export-media-cache.c"
	}
#line 757 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 757 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 6641 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_create_normal_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean is_guarded, GError** error) {
	gint type = 0;
	GValue parent = {0};
	RygelMediaObject* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMediaContainer* _tmp2_ = NULL;
	RygelMediaContainer* _tmp3_ = NULL;
	gint _tmp11_ = 0;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_ = NULL;
	RygelMediaObject* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GValue* values = NULL;
	RygelMediaObject* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GValue _tmp20_ = {0};
	RygelMediaObject* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GValue _tmp24_ = {0};
	gint _tmp25_ = 0;
	GValue _tmp26_ = {0};
	GValue _tmp27_ = {0};
	GValue _tmp28_ = {0};
	RygelMediaObject* _tmp29_ = NULL;
	guint64 _tmp30_ = 0ULL;
	guint64 _tmp31_ = 0ULL;
	GValue _tmp32_ = {0};
	RygelMediaObject* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	GValue _tmp35_ = {0};
	RygelMediaObject* _tmp36_ = NULL;
	guint _tmp37_ = 0U;
	guint _tmp38_ = 0U;
	GValue _tmp39_ = {0};
	GValue _tmp40_ = {0};
	GValue _tmp41_ = {0};
	GValue _tmp42_ = {0};
	GValue _tmp43_ = {0};
	GValue* _tmp44_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	RygelMediaObject* _tmp45_ = NULL;
	RygelMediaExportDatabase* _tmp58_ = NULL;
	RygelMediaExportSQLFactory* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	GValue* _tmp61_ = NULL;
	gint _tmp61__length1 = 0;
	GError * _inner_error_ = NULL;
#line 789 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 789 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (object != NULL);
#line 791 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER;
#line 794 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = object;
#line 794 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
#line 795 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM;
#line 6708 "rygel-media-export-media-cache.c"
	}
#line 798 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = object;
#line 798 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = rygel_media_object_get_parent (_tmp1_);
#line 798 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = _tmp2_;
#line 798 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp3_ == NULL) {
#line 6718 "rygel-media-export-media-cache.c"
		GValue _tmp4_ = {0};
#line 799 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_null (&_tmp4_);
#line 799 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 799 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		parent = _tmp4_;
#line 6726 "rygel-media-export-media-cache.c"
	} else {
		RygelMediaObject* _tmp5_ = NULL;
		RygelMediaContainer* _tmp6_ = NULL;
		RygelMediaContainer* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GValue _tmp10_ = {0};
#line 801 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = object;
#line 801 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_media_object_get_parent (_tmp5_);
#line 801 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = _tmp6_;
#line 801 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp7_);
#line 801 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = _tmp8_;
#line 801 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp10_, G_TYPE_STRING);
#line 801 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_string (&_tmp10_, _tmp9_);
#line 801 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 801 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		parent = _tmp10_;
#line 6752 "rygel-media-export-media-cache.c"
	}
#line 813 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = is_guarded;
#line 813 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp12_) {
#line 813 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = 1;
#line 6760 "rygel-media-export-media-cache.c"
	} else {
#line 813 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = 0;
#line 6764 "rygel-media-export-media-cache.c"
	}
#line 814 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = object;
#line 814 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = rygel_media_object_get_ref_id (_tmp14_);
#line 814 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = _tmp15_;
#line 814 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = _tmp16_;
#line 814 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp13_ == NULL) {
#line 814 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp13_ = NULL;
#line 6778 "rygel-media-export-media-cache.c"
	}
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = object;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = rygel_media_object_get_id (_tmp17_);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = _tmp18_;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp20_, G_TYPE_STRING);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp20_, _tmp19_);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp21_ = object;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp22_ = rygel_media_object_get_title (_tmp21_);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp23_ = _tmp22_;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp24_, G_TYPE_STRING);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp24_, _tmp23_);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp25_ = type;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp26_, G_TYPE_INT);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp26_, _tmp25_);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp27_ = parent;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_IS_VALUE (&_tmp27_)) {
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp28_, G_VALUE_TYPE (&_tmp27_));
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_copy (&_tmp27_, &_tmp28_);
#line 6814 "rygel-media-export-media-cache.c"
	} else {
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp28_ = _tmp27_;
#line 6818 "rygel-media-export-media-cache.c"
	}
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp29_ = object;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp30_ = rygel_media_object_get_modified (_tmp29_);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp31_ = _tmp30_;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp32_, G_TYPE_UINT64);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_uint64 (&_tmp32_, _tmp31_);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_ = object;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_ = rygel_media_object_get_primary_uri (_tmp33_);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp35_, G_TYPE_STRING);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_take_string (&_tmp35_, _tmp34_);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp36_ = object;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp37_ = rygel_media_object_get_object_update_id (_tmp36_);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp38_ = _tmp37_;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp39_, G_TYPE_UINT);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_uint (&_tmp39_, _tmp38_);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp40_, G_TYPE_INT);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp40_, -1);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp41_, G_TYPE_INT);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp41_, -1);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp42_, G_TYPE_INT);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp42_, _tmp11_);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp43_, G_TYPE_STRING);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp43_, _tmp13_);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp44_ = g_new0 (GValue, 11);
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp44_[0] = _tmp20_;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp44_[1] = _tmp24_;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp44_[2] = _tmp26_;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp44_[3] = _tmp28_;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp44_[4] = _tmp32_;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp44_[5] = _tmp35_;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp44_[6] = _tmp39_;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp44_[7] = _tmp40_;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp44_[8] = _tmp41_;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp44_[9] = _tmp42_;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp44_[10] = _tmp43_;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp44_;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 11;
#line 804 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 816 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp45_ = object;
#line 816 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp45_, RYGEL_TYPE_MEDIA_CONTAINER)) {
#line 6898 "rygel-media-export-media-cache.c"
		RygelMediaContainer* container = NULL;
		RygelMediaObject* _tmp46_ = NULL;
		RygelMediaContainer* _tmp47_ = NULL;
		GValue* _tmp48_ = NULL;
		gint _tmp48__length1 = 0;
		RygelMediaContainer* _tmp49_ = NULL;
		gint64 _tmp50_ = 0LL;
		GValue _tmp51_ = {0};
		GValue _tmp52_ = {0};
		GValue* _tmp53_ = NULL;
		gint _tmp53__length1 = 0;
		RygelMediaContainer* _tmp54_ = NULL;
		guint32 _tmp55_ = 0U;
		GValue _tmp56_ = {0};
		GValue _tmp57_ = {0};
#line 817 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp46_ = object;
#line 817 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp46_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp46_) : NULL);
#line 817 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		container = _tmp47_;
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp48_ = values;
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp48__length1 = values_length1;
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp49_ = container;
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp50_ = _tmp49_->total_deleted_child_count;
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp51_, G_TYPE_INT64);
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int64 (&_tmp51_, _tmp50_);
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp48_[7]) ? (g_value_unset (&_tmp48_[7]), NULL) : NULL;
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp48_[7] = _tmp51_;
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp52_ = _tmp48_[7];
#line 819 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp53_ = values;
#line 819 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp53__length1 = values_length1;
#line 819 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp54_ = container;
#line 819 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp55_ = _tmp54_->update_id;
#line 819 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp56_, G_TYPE_UINT);
#line 819 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_uint (&_tmp56_, _tmp55_);
#line 819 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp53_[8]) ? (g_value_unset (&_tmp53_[8]), NULL) : NULL;
#line 819 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp53_[8] = _tmp56_;
#line 819 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp57_ = _tmp53_[8];
#line 816 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (container);
#line 6958 "rygel-media-export-media-cache.c"
	}
#line 822 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp58_ = self->priv->db;
#line 822 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp59_ = self->priv->sql;
#line 822 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp60_ = rygel_media_export_sql_factory_make (_tmp59_, RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT);
#line 822 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp61_ = values;
#line 822 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp61__length1 = values_length1;
#line 822 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (_tmp58_, _tmp60_, _tmp61_, _tmp61__length1, &_inner_error_);
#line 822 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 822 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 822 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 822 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 822 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 6982 "rygel-media-export-media-cache.c"
	}
#line 789 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 789 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 6988 "rygel-media-export-media-cache.c"
}


/**
     * Add the container or item to the cache.
     */
static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean override_guarded, GError** error) {
	gboolean is_guarded = FALSE;
	RygelMediaObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
#line 828 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 828 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (object != NULL);
#line 830 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = object;
#line 830 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = rygel_media_object_get_id (_tmp0_);
#line 830 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = _tmp1_;
#line 830 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_is_object_guarded (self, _tmp2_);
#line 830 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	is_guarded = _tmp3_;
#line 832 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = override_guarded;
#line 832 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (!_tmp5_) {
#line 7022 "rygel-media-export-media-cache.c"
		gboolean _tmp6_ = FALSE;
#line 832 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = is_guarded;
#line 832 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = _tmp6_;
#line 7028 "rygel-media-export-media-cache.c"
	} else {
#line 832 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = FALSE;
#line 7032 "rygel-media-export-media-cache.c"
	}
#line 832 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp4_) {
#line 7036 "rygel-media-export-media-cache.c"
		RygelMediaObject* _tmp7_ = NULL;
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = object;
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_update_guarded_object (self, _tmp7_, &_inner_error_);
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 7048 "rygel-media-export-media-cache.c"
		}
	} else {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		RygelMediaObject* _tmp11_ = NULL;
#line 835 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = is_guarded;
#line 835 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_tmp9_) {
#line 835 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp8_ = TRUE;
#line 7060 "rygel-media-export-media-cache.c"
		} else {
			gboolean _tmp10_ = FALSE;
#line 835 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = override_guarded;
#line 835 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp8_ = _tmp10_;
#line 7067 "rygel-media-export-media-cache.c"
		}
#line 835 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = object;
#line 835 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_create_normal_object (self, _tmp11_, _tmp8_, &_inner_error_);
#line 835 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 835 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 835 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 7079 "rygel-media-export-media-cache.c"
		}
	}
}


/**
     * Create the current schema.
     *
     * If schema creation fails, schema will be rolled back
     * completely.
     *
     * @returns: true on success, false on failure
     */
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 847 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 7098 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabase* _tmp0_ = NULL;
		RygelMediaExportDatabase* _tmp1_ = NULL;
		RygelMediaExportSQLFactory* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		RygelMediaExportDatabase* _tmp4_ = NULL;
		RygelMediaExportSQLFactory* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		RygelMediaExportDatabase* _tmp7_ = NULL;
		RygelMediaExportSQLFactory* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		RygelMediaExportDatabase* _tmp10_ = NULL;
		RygelMediaExportSQLFactory* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		RygelMediaExportDatabase* _tmp13_ = NULL;
		RygelMediaExportSQLFactory* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		RygelMediaExportDatabase* _tmp16_ = NULL;
		RygelMediaExportSQLFactory* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		RygelMediaExportDatabase* _tmp19_ = NULL;
		RygelMediaExportDatabase* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
#line 849 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = self->priv->db;
#line 849 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
#line 849 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7129 "rygel-media-export-media-cache.c"
			goto __catch19_g_error;
		}
#line 850 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = self->priv->db;
#line 850 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = self->priv->sql;
#line 850 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = rygel_media_export_sql_factory_make (_tmp2_, RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA);
#line 850 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp1_, _tmp3_, NULL, 0, &_inner_error_);
#line 850 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7142 "rygel-media-export-media-cache.c"
			goto __catch19_g_error;
		}
#line 851 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = self->priv->db;
#line 851 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = self->priv->sql;
#line 851 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_media_export_sql_factory_make (_tmp5_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON);
#line 851 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp4_, _tmp6_, NULL, 0, &_inner_error_);
#line 851 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7155 "rygel-media-export-media-cache.c"
			goto __catch19_g_error;
		}
#line 852 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = self->priv->db;
#line 852 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = self->priv->sql;
#line 852 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = rygel_media_export_sql_factory_make (_tmp8_, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE);
#line 852 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp7_, _tmp9_, NULL, 0, &_inner_error_);
#line 852 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7168 "rygel-media-export-media-cache.c"
			goto __catch19_g_error;
		}
#line 853 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = self->priv->db;
#line 853 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = self->priv->sql;
#line 853 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp12_ = rygel_media_export_sql_factory_make (_tmp11_, RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON);
#line 853 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp10_, _tmp12_, NULL, 0, &_inner_error_);
#line 853 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7181 "rygel-media-export-media-cache.c"
			goto __catch19_g_error;
		}
#line 854 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp13_ = self->priv->db;
#line 854 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp14_ = self->priv->sql;
#line 854 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp15_ = rygel_media_export_sql_factory_make (_tmp14_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
#line 854 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp13_, _tmp15_, NULL, 0, &_inner_error_);
#line 854 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7194 "rygel-media-export-media-cache.c"
			goto __catch19_g_error;
		}
#line 855 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp16_ = self->priv->db;
#line 855 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp17_ = self->priv->sql;
#line 855 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp18_ = rygel_media_export_sql_factory_make (_tmp17_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_REFERENCE);
#line 855 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp16_, _tmp18_, NULL, 0, &_inner_error_);
#line 855 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7207 "rygel-media-export-media-cache.c"
			goto __catch19_g_error;
		}
#line 856 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp19_ = self->priv->db;
#line 856 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (_tmp19_, &_inner_error_);
#line 856 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7216 "rygel-media-export-media-cache.c"
			goto __catch19_g_error;
		}
#line 857 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp20_ = self->priv->db;
#line 857 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_analyze (_tmp20_);
#line 858 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp21_ = uuid_get ();
#line 858 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp22_ = _tmp21_;
#line 858 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_save_reset_token (self, _tmp22_);
#line 858 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp22_);
#line 860 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = TRUE;
#line 860 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 7235 "rygel-media-export-media-cache.c"
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* err = NULL;
		GError* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		RygelMediaExportDatabase* _tmp25_ = NULL;
#line 848 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		err = _inner_error_;
#line 848 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 862 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp23_ = err;
#line 862 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp24_ = _tmp23_->message;
#line 862 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_warning ("rygel-media-export-media-cache.vala:862: Failed to create schema: %s", _tmp24_);
#line 863 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp25_ = self->priv->db;
#line 863 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_rollback (_tmp25_);
#line 848 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (err);
#line 7260 "rygel-media-export-media-cache.c"
	}
	__finally19:
#line 848 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 848 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 848 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_clear_error (&_inner_error_);
#line 848 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return FALSE;
#line 7271 "rygel-media-export-media-cache.c"
	}
#line 866 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = FALSE;
#line 866 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 7277 "rygel-media-export-media-cache.c"
}


/**
     * Create a new container or item based on a SQL result.
     *
     * The Rygel server discards the object when the browse request is finished,
     * after serializing the result.
     *
     * @param parent The object's parent container.
     * @param statement a SQLite result indicating the container's details.
     */
static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 885 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 885 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return _data4_;
#line 7295 "rygel-media-export-media-cache.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 885 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 7304 "rygel-media-export-media-cache.c"
		RygelMediaExportMediaCache* self;
#line 885 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		self = _data4_->self;
#line 885 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (_data4_->media_engine);
#line 885 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (_data4_->item);
#line 885 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (self);
#line 885 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_slice_free (Block4Data, _data4_);
#line 7316 "rygel-media-export-media-cache.c"
	}
}


static void ___lambda4_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res) {
	RygelMediaExportMediaCache* self;
	GeeList* added_resources = NULL;
	RygelMediaEngine* _tmp0_ = NULL;
	GAsyncResult* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	RygelMediaFileItem* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	RygelMediaFileItem* _tmp23_ = NULL;
	GeeList* _tmp24_ = NULL;
	GeeList* _tmp25_ = NULL;
	GeeList* _tmp26_ = NULL;
#line 917 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self = _data4_->self;
#line 917 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (res != NULL);
#line 918 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = _data4_->media_engine;
#line 918 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = res;
#line 918 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = rygel_media_engine_get_resources_for_item_finish (_tmp0_, _tmp1_);
#line 918 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	added_resources = _tmp2_;
#line 920 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = added_resources;
#line 920 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
#line 920 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = _tmp4_;
#line 920 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = _data4_->item;
#line 920 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) _tmp6_);
#line 920 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = _tmp7_;
#line 920 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:920: Adding %d resources to item s" \
"ource %s", _tmp5_, _tmp8_);
#line 920 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp8_);
#line 7365 "rygel-media-export-media-cache.c"
	{
		GeeList* _resrc_list = NULL;
		GeeList* _tmp9_ = NULL;
		GeeList* _tmp10_ = NULL;
		gint _resrc_size = 0;
		GeeList* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _resrc_index = 0;
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = added_resources;
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_resrc_list = _tmp10_;
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = _resrc_list;
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp13_ = _tmp12_;
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_resrc_size = _tmp13_;
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_resrc_index = -1;
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 7393 "rygel-media-export-media-cache.c"
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			RygelMediaResource* resrc = NULL;
			GeeList* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gpointer _tmp19_ = NULL;
			RygelMediaResource* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = _resrc_index;
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_resrc_index = _tmp14_ + 1;
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = _resrc_index;
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp16_ = _resrc_size;
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!(_tmp15_ < _tmp16_)) {
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 7416 "rygel-media-export-media-cache.c"
			}
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp17_ = _resrc_list;
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp18_ = _resrc_index;
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp19_ = gee_list_get (_tmp17_, _tmp18_);
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			resrc = (RygelMediaResource*) _tmp19_;
#line 923 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp20_ = resrc;
#line 923 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp21_ = rygel_media_resource_get_name (_tmp20_);
#line 923 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp22_ = _tmp21_;
#line 923 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_debug ("rygel-media-export-media-cache.vala:923: Media-export item media resou" \
"rce %s", _tmp22_);
#line 923 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (_tmp22_);
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (resrc);
#line 7438 "rygel-media-export-media-cache.c"
		}
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (_resrc_list);
#line 7442 "rygel-media-export-media-cache.c"
	}
#line 926 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp23_ = _data4_->item;
#line 926 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp24_ = rygel_media_object_get_resource_list ((RygelMediaObject*) _tmp23_);
#line 926 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp25_ = _tmp24_;
#line 926 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_ = added_resources;
#line 926 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	gee_collection_add_all ((GeeCollection*) _tmp25_, (GeeCollection*) _tmp26_);
#line 926 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (_tmp25_);
#line 917 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (added_resources);
#line 7458 "rygel-media-export-media-cache.c"
}


static void ____lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 916 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	___lambda4_ (self, source_object, res);
#line 916 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	block4_data_unref (self);
#line 7467 "rygel-media-export-media-cache.c"
}


static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self, RygelMediaContainer* parent, sqlite3_stmt* statement) {
	RygelMediaObject* result = NULL;
	RygelMediaObject* object = NULL;
	const gchar* title = NULL;
	sqlite3_stmt* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* object_id = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* uri = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	sqlite3_stmt* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	RygelMediaObject* _tmp42_ = NULL;
#line 878 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 878 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, NULL);
#line 880 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	object = NULL;
#line 881 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = statement;
#line 881 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = sqlite3_column_text (_tmp0_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TITLE);
#line 881 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	title = _tmp1_;
#line 882 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = statement;
#line 882 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = sqlite3_column_text (_tmp2_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID);
#line 882 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	object_id = _tmp3_;
#line 883 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = statement;
#line 883 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = sqlite3_column_text (_tmp4_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI);
#line 883 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	uri = _tmp5_;
#line 885 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = statement;
#line 885 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = sqlite3_column_int (_tmp6_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TYPE);
#line 885 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	switch (_tmp7_) {
#line 885 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case 0:
#line 7518 "rygel-media-export-media-cache.c"
		{
			RygelMediaExportObjectFactory* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			RygelMediaExportDBContainer* _tmp12_ = NULL;
			RygelMediaContainer* container = NULL;
			RygelMediaObject* _tmp13_ = NULL;
			RygelMediaContainer* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			RygelMediaContainer* _tmp18_ = NULL;
			sqlite3_stmt* _tmp19_ = NULL;
			gint64 _tmp20_ = 0LL;
			RygelMediaContainer* _tmp21_ = NULL;
			sqlite3_stmt* _tmp22_ = NULL;
			gint64 _tmp23_ = 0LL;
#line 888 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp8_ = self->priv->factory;
#line 888 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = object_id;
#line 888 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = title;
#line 888 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = uri;
#line 888 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = rygel_media_export_object_factory_get_container (_tmp8_, _tmp9_, _tmp10_, (guint) 0, _tmp11_);
#line 888 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (object);
#line 888 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			object = (RygelMediaObject*) _tmp12_;
#line 890 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = object;
#line 890 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp13_) : NULL);
#line 890 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			container = _tmp14_;
#line 891 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = uri;
#line 891 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp15_ != NULL) {
#line 7559 "rygel-media-export-media-cache.c"
				RygelMediaContainer* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
#line 892 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp16_ = container;
#line 892 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp17_ = uri;
#line 892 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				rygel_media_object_add_uri ((RygelMediaObject*) _tmp16_, _tmp17_);
#line 7568 "rygel-media-export-media-cache.c"
			}
#line 894 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp18_ = container;
#line 894 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp19_ = statement;
#line 894 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp20_ = sqlite3_column_int64 (_tmp19_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DELETED_CHILD_COUNT);
#line 894 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp18_->total_deleted_child_count = (gint64) ((guint32) _tmp20_);
#line 896 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp21_ = container;
#line 896 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp22_ = statement;
#line 896 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp23_ = sqlite3_column_int64 (_tmp22_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CONTAINER_UPDATE_ID);
#line 896 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp21_->update_id = (guint32) ((guint) _tmp23_);
#line 898 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (container);
#line 898 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 7590 "rygel-media-export-media-cache.c"
		}
#line 885 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case 1:
#line 7594 "rygel-media-export-media-cache.c"
		{
			Block4Data* _data4_;
			const gchar* upnp_class = NULL;
			sqlite3_stmt* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			RygelMediaExportObjectFactory* _tmp26_ = NULL;
			RygelMediaContainer* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
			RygelMediaFileItem* _tmp31_ = NULL;
			RygelMediaObject* _tmp32_ = NULL;
			RygelMediaFileItem* _tmp33_ = NULL;
			sqlite3_stmt* _tmp34_ = NULL;
			RygelMediaFileItem* _tmp35_ = NULL;
			const gchar* _tmp36_ = NULL;
			RygelMediaEngine* _tmp39_ = NULL;
			RygelMediaEngine* _tmp40_ = NULL;
			RygelMediaFileItem* _tmp41_ = NULL;
#line 885 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_data4_ = g_slice_new0 (Block4Data);
#line 885 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_data4_->_ref_count_ = 1;
#line 885 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_data4_->self = g_object_ref (self);
#line 901 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp24_ = statement;
#line 901 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp25_ = sqlite3_column_text (_tmp24_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CLASS);
#line 901 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			upnp_class = _tmp25_;
#line 903 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp26_ = self->priv->factory;
#line 903 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp27_ = parent;
#line 903 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp28_ = object_id;
#line 903 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp29_ = title;
#line 903 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp30_ = upnp_class;
#line 903 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp31_ = rygel_media_export_object_factory_get_item (_tmp26_, _tmp27_, _tmp28_, _tmp29_, _tmp30_);
#line 903 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (object);
#line 903 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			object = (RygelMediaObject*) _tmp31_;
#line 907 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp32_ = object;
#line 907 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp32_) : NULL);
#line 907 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_data4_->item = _tmp33_;
#line 908 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp34_ = statement;
#line 908 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp35_ = _data4_->item;
#line 908 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_export_media_cache_fill_item (self, _tmp34_, _tmp35_);
#line 910 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp36_ = uri;
#line 910 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp36_ != NULL) {
#line 7658 "rygel-media-export-media-cache.c"
				RygelMediaFileItem* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
#line 911 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp37_ = _data4_->item;
#line 911 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp38_ = uri;
#line 911 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				rygel_media_object_add_uri ((RygelMediaObject*) _tmp37_, _tmp38_);
#line 7667 "rygel-media-export-media-cache.c"
			}
#line 915 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp39_ = rygel_media_engine_get_default ();
#line 915 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_data4_->media_engine = _tmp39_;
#line 916 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp40_ = _data4_->media_engine;
#line 916 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp41_ = _data4_->item;
#line 916 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_engine_get_resources_for_item (_tmp40_, (RygelMediaObject*) _tmp41_, ____lambda4__gasync_ready_callback, block4_data_ref (_data4_));
#line 928 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			block4_data_unref (_data4_);
#line 928 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_data4_ = NULL;
#line 928 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 7685 "rygel-media-export-media-cache.c"
		}
		default:
		{
#line 930 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_assert_not_reached ();
#line 7691 "rygel-media-export-media-cache.c"
		}
	}
#line 933 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp42_ = object;
#line 933 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp42_ != NULL) {
#line 7698 "rygel-media-export-media-cache.c"
		RygelMediaObject* _tmp43_ = NULL;
		sqlite3_stmt* _tmp44_ = NULL;
		gint64 _tmp45_ = 0LL;
		gboolean _tmp46_ = FALSE;
		RygelMediaObject* _tmp47_ = NULL;
		guint64 _tmp48_ = 0ULL;
		guint64 _tmp49_ = 0ULL;
		RygelMediaObject* _tmp53_ = NULL;
		sqlite3_stmt* _tmp54_ = NULL;
		gint64 _tmp55_ = 0LL;
		RygelMediaObject* _tmp56_ = NULL;
		sqlite3_stmt* _tmp57_ = NULL;
		const gchar* _tmp58_ = NULL;
#line 934 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp43_ = object;
#line 934 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp44_ = statement;
#line 934 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp45_ = sqlite3_column_int64 (_tmp44_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TIMESTAMP);
#line 934 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_object_set_modified (_tmp43_, (guint64) _tmp45_);
#line 935 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp47_ = object;
#line 935 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp48_ = rygel_media_object_get_modified (_tmp47_);
#line 935 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp49_ = _tmp48_;
#line 935 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_tmp49_ == ((guint64) G_MAXINT64)) {
#line 7728 "rygel-media-export-media-cache.c"
			RygelMediaObject* _tmp50_ = NULL;
#line 935 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp50_ = object;
#line 935 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp46_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, RYGEL_TYPE_MEDIA_FILE_ITEM);
#line 7734 "rygel-media-export-media-cache.c"
		} else {
#line 935 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp46_ = FALSE;
#line 7738 "rygel-media-export-media-cache.c"
		}
#line 935 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_tmp46_) {
#line 7742 "rygel-media-export-media-cache.c"
			RygelMediaObject* _tmp51_ = NULL;
			RygelMediaObject* _tmp52_ = NULL;
#line 936 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp51_ = object;
#line 936 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_object_set_modified (_tmp51_, (guint64) 0);
#line 937 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp52_ = object;
#line 937 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_file_item_set_place_holder (G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp52_) : NULL, TRUE);
#line 7753 "rygel-media-export-media-cache.c"
		}
#line 939 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp53_ = object;
#line 939 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp54_ = statement;
#line 939 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp55_ = sqlite3_column_int64 (_tmp54_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_OBJECT_UPDATE_ID);
#line 939 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_object_set_object_update_id (_tmp53_, (guint) _tmp55_);
#line 941 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp56_ = object;
#line 941 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp57_ = statement;
#line 941 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp58_ = sqlite3_column_text (_tmp57_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_REFERENCE_ID);
#line 941 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_object_set_ref_id (_tmp56_, _tmp58_);
#line 7771 "rygel-media-export-media-cache.c"
	}
#line 944 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = object;
#line 944 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 7777 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self, sqlite3_stmt* statement, RygelMediaFileItem* item) {
	RygelMediaFileItem* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	RygelMediaFileItem* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	RygelMediaFileItem* _tmp6_ = NULL;
	sqlite3_stmt* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	RygelMediaFileItem* _tmp9_ = NULL;
	sqlite3_stmt* _tmp10_ = NULL;
	gint64 _tmp11_ = 0LL;
	RygelMediaFileItem* _tmp12_ = NULL;
	sqlite3_stmt* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	RygelMediaFileItem* _tmp15_ = NULL;
	RygelMediaFileItem* _tmp49_ = NULL;
#line 947 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 947 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (statement != NULL);
#line 947 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 949 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = item;
#line 949 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = statement;
#line 949 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = sqlite3_column_text (_tmp1_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DATE);
#line 949 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_object_set_date ((RygelMediaObject*) _tmp0_, _tmp2_);
#line 950 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = item;
#line 950 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = statement;
#line 950 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = sqlite3_column_text (_tmp4_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_MIME_TYPE);
#line 950 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_file_item_set_mime_type (_tmp3_, _tmp5_);
#line 951 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = item;
#line 951 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = statement;
#line 951 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = sqlite3_column_text (_tmp7_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DLNA_PROFILE);
#line 951 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_file_item_set_dlna_profile (_tmp6_, _tmp8_);
#line 952 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = item;
#line 952 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = statement;
#line 952 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = sqlite3_column_int64 (_tmp10_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SIZE);
#line 952 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_file_item_set_size (_tmp9_, _tmp11_);
#line 953 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = item;
#line 953 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = statement;
#line 953 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = sqlite3_column_text (_tmp13_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CREATOR);
#line 953 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_object_set_creator ((RygelMediaObject*) _tmp12_, _tmp14_);
#line 955 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = item;
#line 955 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, RYGEL_TYPE_AUDIO_ITEM)) {
#line 7849 "rygel-media-export-media-cache.c"
		RygelAudioItem* audio_item = NULL;
		RygelMediaFileItem* _tmp16_ = NULL;
		RygelAudioItem* _tmp17_ = NULL;
		RygelAudioItem* _tmp18_ = NULL;
		sqlite3_stmt* _tmp19_ = NULL;
		gint64 _tmp20_ = 0LL;
		RygelAudioItem* _tmp21_ = NULL;
		sqlite3_stmt* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		RygelAudioItem* _tmp24_ = NULL;
		sqlite3_stmt* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		RygelAudioItem* _tmp27_ = NULL;
		sqlite3_stmt* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		RygelAudioItem* _tmp30_ = NULL;
		sqlite3_stmt* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		RygelMediaFileItem* _tmp33_ = NULL;
#line 956 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp16_ = item;
#line 956 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp16_) : NULL);
#line 956 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		audio_item = _tmp17_;
#line 957 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp18_ = audio_item;
#line 957 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp19_ = statement;
#line 957 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp20_ = sqlite3_column_int64 (_tmp19_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DURATION);
#line 957 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_audio_item_set_duration (_tmp18_, (glong) _tmp20_);
#line 959 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp21_ = audio_item;
#line 959 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp22_ = statement;
#line 959 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp23_ = sqlite3_column_int (_tmp22_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITRATE);
#line 959 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_audio_item_set_bitrate (_tmp21_, _tmp23_);
#line 960 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp24_ = audio_item;
#line 960 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp25_ = statement;
#line 960 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp26_ = sqlite3_column_int (_tmp25_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SAMPLE_FREQ);
#line 960 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_audio_item_set_sample_freq (_tmp24_, _tmp26_);
#line 962 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp27_ = audio_item;
#line 962 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp28_ = statement;
#line 962 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp29_ = sqlite3_column_int (_tmp28_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITS_PER_SAMPLE);
#line 962 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_audio_item_set_bits_per_sample (_tmp27_, _tmp29_);
#line 964 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp30_ = audio_item;
#line 964 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp31_ = statement;
#line 964 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp32_ = sqlite3_column_int (_tmp31_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CHANNELS);
#line 964 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_audio_item_set_channels (_tmp30_, _tmp32_);
#line 965 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp33_ = item;
#line 965 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM)) {
#line 7919 "rygel-media-export-media-cache.c"
			RygelMediaExportMusicItem* music_item = NULL;
			RygelMediaFileItem* _tmp34_ = NULL;
			RygelMediaExportMusicItem* _tmp35_ = NULL;
			RygelMediaExportMusicItem* _tmp36_ = NULL;
			sqlite3_stmt* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			RygelMediaExportMusicItem* _tmp39_ = NULL;
			sqlite3_stmt* _tmp40_ = NULL;
			const gchar* _tmp41_ = NULL;
			RygelMediaExportMusicItem* _tmp42_ = NULL;
			sqlite3_stmt* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			RygelMediaExportMusicItem* _tmp45_ = NULL;
			sqlite3_stmt* _tmp46_ = NULL;
			gint _tmp47_ = 0;
			RygelMediaExportMusicItem* _tmp48_ = NULL;
#line 966 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp34_ = item;
#line 966 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) _tmp34_) : NULL);
#line 966 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			music_item = _tmp35_;
#line 967 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp36_ = music_item;
#line 967 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp37_ = statement;
#line 967 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp38_ = sqlite3_column_text (_tmp37_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR);
#line 967 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_object_set_artist ((RygelMediaObject*) _tmp36_, _tmp38_);
#line 968 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp39_ = music_item;
#line 968 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp40_ = statement;
#line 968 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp41_ = sqlite3_column_text (_tmp40_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ALBUM);
#line 968 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_audio_item_set_album ((RygelAudioItem*) _tmp39_, _tmp41_);
#line 969 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp42_ = music_item;
#line 969 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp43_ = statement;
#line 969 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp44_ = sqlite3_column_text (_tmp43_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_GENRE);
#line 969 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_object_set_genre ((RygelMediaObject*) _tmp42_, _tmp44_);
#line 970 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp45_ = music_item;
#line 970 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp46_ = statement;
#line 970 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp47_ = sqlite3_column_int (_tmp46_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TRACK);
#line 970 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_music_item_set_track_number ((RygelMusicItem*) _tmp45_, _tmp47_);
#line 972 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp48_ = music_item;
#line 972 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_music_item_lookup_album_art ((RygelMusicItem*) _tmp48_);
#line 965 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (music_item);
#line 7980 "rygel-media-export-media-cache.c"
		}
#line 955 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (audio_item);
#line 7984 "rygel-media-export-media-cache.c"
	}
#line 976 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp49_ = item;
#line 976 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, RYGEL_TYPE_VISUAL_ITEM)) {
#line 7990 "rygel-media-export-media-cache.c"
		RygelVisualItem* visual_item = NULL;
		RygelMediaFileItem* _tmp50_ = NULL;
		RygelVisualItem* _tmp51_ = NULL;
		RygelVisualItem* _tmp52_ = NULL;
		sqlite3_stmt* _tmp53_ = NULL;
		gint _tmp54_ = 0;
		RygelVisualItem* _tmp55_ = NULL;
		sqlite3_stmt* _tmp56_ = NULL;
		gint _tmp57_ = 0;
		RygelVisualItem* _tmp58_ = NULL;
		sqlite3_stmt* _tmp59_ = NULL;
		gint _tmp60_ = 0;
#line 977 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp50_ = item;
#line 977 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp50_) : NULL);
#line 977 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		visual_item = _tmp51_;
#line 978 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp52_ = visual_item;
#line 978 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp53_ = statement;
#line 978 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp54_ = sqlite3_column_int (_tmp53_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_WIDTH);
#line 978 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_visual_item_set_width (_tmp52_, _tmp54_);
#line 979 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp55_ = visual_item;
#line 979 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp56_ = statement;
#line 979 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp57_ = sqlite3_column_int (_tmp56_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_HEIGHT);
#line 979 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_visual_item_set_height (_tmp55_, _tmp57_);
#line 980 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp58_ = visual_item;
#line 980 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp59_ = statement;
#line 980 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp60_ = sqlite3_column_int (_tmp59_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_COLOR_DEPTH);
#line 980 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_visual_item_set_color_depth (_tmp58_, _tmp60_);
#line 976 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (visual_item);
#line 8035 "rygel-media-export-media-cache.c"
	}
}


static gchar* rygel_media_export_media_cache_translate_search_expression (RygelSearchExpression* expression, GValueArray* args, const gchar* prefix, GError** error) {
	gchar* result = NULL;
	RygelSearchExpression* _tmp0_ = NULL;
	gchar* filter = NULL;
	RygelSearchExpression* _tmp2_ = NULL;
	GValueArray* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 985 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 985 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 990 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = expression;
#line 990 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp0_ == NULL) {
#line 8059 "rygel-media-export-media-cache.c"
		gchar* _tmp1_ = NULL;
#line 991 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = g_strdup ("");
#line 991 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp1_;
#line 991 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 8067 "rygel-media-export-media-cache.c"
	}
#line 994 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = expression;
#line 994 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = args;
#line 994 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = rygel_media_export_media_cache_search_expression_to_sql (_tmp2_, _tmp3_, &_inner_error_);
#line 994 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	filter = _tmp4_;
#line 994 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 994 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 994 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 8083 "rygel-media-export-media-cache.c"
	}
#line 996 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = prefix;
#line 996 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = filter;
#line 996 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = g_strdup_printf (" %s %s", _tmp5_, _tmp6_);
#line 996 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp7_;
#line 996 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (filter);
#line 996 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 8097 "rygel-media-export-media-cache.c"
}


static gchar* rygel_media_export_media_cache_search_expression_to_sql (RygelSearchExpression* expression, GValueArray* args, GError** error) {
	gchar* result = NULL;
	RygelSearchExpression* _tmp0_ = NULL;
	RygelSearchExpression* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 999 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 1003 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = expression;
#line 1003 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp0_ == NULL) {
#line 8112 "rygel-media-export-media-cache.c"
		gchar* _tmp1_ = NULL;
#line 1004 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = g_strdup ("");
#line 1004 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp1_;
#line 1004 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 8120 "rygel-media-export-media-cache.c"
	}
#line 1007 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = expression;
#line 1007 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_LOGICAL_EXPRESSION)) {
#line 8126 "rygel-media-export-media-cache.c"
		gchar* _tmp3_ = NULL;
		RygelSearchExpression* _tmp4_ = NULL;
		GValueArray* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 1008 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = expression;
#line 1008 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = args;
#line 1008 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_media_export_media_cache_logical_expression_to_sql (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_LOGICAL_EXPRESSION) ? ((RygelLogicalExpression*) _tmp4_) : NULL, _tmp5_, &_inner_error_);
#line 1008 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = _tmp6_;
#line 1008 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1008 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 1008 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 8146 "rygel-media-export-media-cache.c"
		}
#line 1008 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = _tmp3_;
#line 1008 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = NULL;
#line 1008 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp7_;
#line 1008 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp3_);
#line 1008 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 8158 "rygel-media-export-media-cache.c"
	} else {
		gchar* _tmp8_ = NULL;
		RygelSearchExpression* _tmp9_ = NULL;
		GValueArray* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 1011 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = expression;
#line 1011 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = args;
#line 1011 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = rygel_media_export_media_cache_relational_expression_to_sql (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) _tmp9_) : NULL, _tmp10_, &_inner_error_);
#line 1011 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = _tmp11_;
#line 1011 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1011 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 1011 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 8179 "rygel-media-export-media-cache.c"
		}
#line 1011 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp12_ = _tmp8_;
#line 1011 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = NULL;
#line 1011 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp12_;
#line 1011 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp8_);
#line 1011 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 8191 "rygel-media-export-media-cache.c"
	}
}


static gchar* rygel_media_export_media_cache_logical_expression_to_sql (RygelLogicalExpression* expression, GValueArray* args, GError** error) {
	gchar* result = NULL;
	gchar* left_sql_string = NULL;
	RygelLogicalExpression* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GValueArray* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* right_sql_string = NULL;
	RygelLogicalExpression* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	GValueArray* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* operator_sql_string = NULL;
	RygelLogicalExpression* _tmp8_ = NULL;
	gconstpointer _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
#line 1017 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (expression != NULL, NULL);
#line 1017 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 1021 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = expression;
#line 1021 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = ((RygelSearchExpression*) _tmp0_)->operand1;
#line 1021 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = args;
#line 1021 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_search_expression_to_sql ((RygelSearchExpression*) _tmp1_, _tmp2_, &_inner_error_);
#line 1021 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	left_sql_string = _tmp3_;
#line 1021 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1021 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 1021 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 8236 "rygel-media-export-media-cache.c"
	}
#line 1024 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = expression;
#line 1024 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = ((RygelSearchExpression*) _tmp4_)->operand2;
#line 1024 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = args;
#line 1024 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = rygel_media_export_media_cache_search_expression_to_sql ((RygelSearchExpression*) _tmp5_, _tmp6_, &_inner_error_);
#line 1024 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	right_sql_string = _tmp7_;
#line 1024 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1024 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 1024 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (left_sql_string);
#line 1024 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 8256 "rygel-media-export-media-cache.c"
	}
#line 1027 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	operator_sql_string = "OR";
#line 1029 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = expression;
#line 1029 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = ((RygelSearchExpression*) _tmp8_)->op;
#line 1029 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (((RygelLogicalOperator) ((gintptr) _tmp9_)) == RYGEL_LOGICAL_OPERATOR_AND) {
#line 1030 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		operator_sql_string = "AND";
#line 8268 "rygel-media-export-media-cache.c"
	}
#line 1033 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = left_sql_string;
#line 1033 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = operator_sql_string;
#line 1033 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = right_sql_string;
#line 1033 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = g_strdup_printf ("(%s %s %s)", _tmp10_, _tmp11_, _tmp12_);
#line 1033 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp13_;
#line 1033 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (right_sql_string);
#line 1033 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (left_sql_string);
#line 1033 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 8286 "rygel-media-export-media-cache.c"
}


static gchar* rygel_media_export_media_cache_map_operand_to_column (const gchar* operand, gchar** collate, gboolean for_sort, GError** error) {
	gchar* _vala_collate = NULL;
	gchar* result = NULL;
	gchar* column = NULL;
	gboolean use_collation = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label0 = 0;
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label1 = 0;
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label2 = 0;
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label3 = 0;
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label4 = 0;
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label5 = 0;
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label6 = 0;
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label7 = 0;
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label8 = 0;
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label9 = 0;
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label10 = 0;
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label11 = 0;
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label12 = 0;
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label13 = 0;
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label14 = 0;
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label15 = 0;
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label16 = 0;
#line 8332 "rygel-media-export-media-cache.c"
	gboolean _tmp25_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1038 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (operand != NULL, NULL);
#line 1042 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	column = NULL;
#line 1043 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	use_collation = FALSE;
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = operand;
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = _tmp0_;
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("res")))) {
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8351 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp4_ = NULL;
#line 1047 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp4_ = g_strdup ("o.uri");
#line 1047 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1047 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp4_;
#line 1048 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8363 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("res@duration")))) {
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8369 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp5_ = NULL;
#line 1050 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp5_ = g_strdup ("m.duration");
#line 1050 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1050 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp5_;
#line 1051 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8381 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("@id")))) {
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8387 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp6_ = NULL;
#line 1053 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp6_ = g_strdup ("o.upnp_id");
#line 1053 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1053 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp6_;
#line 1054 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8399 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("@parentID")))) {
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8405 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp7_ = NULL;
#line 1056 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp7_ = g_strdup ("o.parent");
#line 1056 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1056 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp7_;
#line 1057 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8417 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("upnp:class")))) {
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8423 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp8_ = NULL;
#line 1059 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp8_ = g_strdup ("m.class");
#line 1059 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1059 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp8_;
#line 1060 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8435 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("dc:title")))) {
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8441 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp9_ = NULL;
#line 1062 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp9_ = g_strdup ("o.title");
#line 1062 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1062 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp9_;
#line 1063 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				use_collation = TRUE;
#line 1064 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8455 "rygel-media-export-media-cache.c"
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("upnp:artist")))) || (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("upnp:author"))))) {
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8461 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp10_ = NULL;
#line 1067 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp10_ = g_strdup ("m.author");
#line 1067 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1067 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp10_;
#line 1068 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				use_collation = TRUE;
#line 1069 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8475 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("dc:creator")))) {
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8481 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp11_ = NULL;
#line 1071 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp11_ = g_strdup ("m.creator");
#line 1071 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1071 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp11_;
#line 1072 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				use_collation = TRUE;
#line 1073 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8495 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("dc:date")))) {
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8501 "rygel-media-export-media-cache.c"
			default:
			{
				gboolean _tmp12_ = FALSE;
#line 1075 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp12_ = for_sort;
#line 1075 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_tmp12_) {
#line 8509 "rygel-media-export-media-cache.c"
					gchar* _tmp13_ = NULL;
#line 1076 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp13_ = g_strdup ("m.date");
#line 1076 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (column);
#line 1076 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					column = _tmp13_;
#line 8517 "rygel-media-export-media-cache.c"
				} else {
					gchar* _tmp14_ = NULL;
#line 1078 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp14_ = g_strdup ("strftime(\"%Y\", m.date)");
#line 1078 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (column);
#line 1078 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					column = _tmp14_;
#line 8526 "rygel-media-export-media-cache.c"
				}
#line 1080 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8530 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("upnp:album")))) {
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8536 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp15_ = NULL;
#line 1082 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp15_ = g_strdup ("m.album");
#line 1082 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1082 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp15_;
#line 1083 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				use_collation = TRUE;
#line 1084 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8550 "rygel-media-export-media-cache.c"
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("upnp:genre")))) || (_tmp3_ == ((0 != _tmp2_label12) ? _tmp2_label12 : (_tmp2_label12 = g_quark_from_static_string ("dc:genre"))))) {
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8556 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp16_ = NULL;
#line 1088 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp16_ = g_strdup ("m.genre");
#line 1088 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1088 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp16_;
#line 1089 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				use_collation = TRUE;
#line 1090 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8570 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label13) ? _tmp2_label13 : (_tmp2_label13 = g_quark_from_static_string ("upnp:originalTrackNumber")))) {
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8576 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp17_ = NULL;
#line 1092 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp17_ = g_strdup ("m.track");
#line 1092 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1092 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp17_;
#line 1093 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8588 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label14) ? _tmp2_label14 : (_tmp2_label14 = g_quark_from_static_string ("rygel:originalVolumeNumber")))) {
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8594 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp18_ = NULL;
#line 1095 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp18_ = g_strdup ("m.disc");
#line 1095 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1095 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp18_;
#line 1096 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8606 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label15) ? _tmp2_label15 : (_tmp2_label15 = g_quark_from_static_string ("upnp:objectUpdateID")))) {
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8612 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp19_ = NULL;
#line 1098 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp19_ = g_strdup ("o.object_update_id");
#line 1098 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1098 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp19_;
#line 1099 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8624 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label16) ? _tmp2_label16 : (_tmp2_label16 = g_quark_from_static_string ("upnp:containerUpdateID")))) {
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8630 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp20_ = NULL;
#line 1101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp20_ = g_strdup ("o.container_update_id");
#line 1101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp20_;
#line 1102 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8642 "rygel-media-export-media-cache.c"
			}
		}
	} else {
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8648 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* message = NULL;
				const gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				GError* _tmp24_ = NULL;
#line 1104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp21_ = operand;
#line 1104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp22_ = g_strdup_printf ("Unsupported column %s", _tmp21_);
#line 1104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				message = _tmp22_;
#line 1106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp23_ = message;
#line 1106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp24_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH, _tmp23_);
#line 1106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_inner_error_ = _tmp24_;
#line 1106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 1106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (message);
#line 1106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 8676 "rygel-media-export-media-cache.c"
			}
		}
	}
#line 1109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp25_ = use_collation;
#line 1109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp25_) {
#line 8684 "rygel-media-export-media-cache.c"
		gchar* _tmp26_ = NULL;
#line 1110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp26_ = g_strdup ("COLLATE CASEFOLD");
#line 1110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_vala_collate);
#line 1110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_collate = _tmp26_;
#line 8692 "rygel-media-export-media-cache.c"
	} else {
		gchar* _tmp27_ = NULL;
#line 1112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp27_ = g_strdup ("");
#line 1112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_vala_collate);
#line 1112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_collate = _tmp27_;
#line 8701 "rygel-media-export-media-cache.c"
	}
#line 1115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = column;
#line 1115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (collate) {
#line 1115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*collate = _vala_collate;
#line 8709 "rygel-media-export-media-cache.c"
	} else {
#line 1115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_vala_collate);
#line 8713 "rygel-media-export-media-cache.c"
	}
#line 1115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 8717 "rygel-media-export-media-cache.c"
}


static gchar* rygel_media_export_media_cache_relational_expression_to_sql (RygelRelationalExpression* exp, GValueArray* args, GError** error) {
	gchar* result = NULL;
	GValue* v = NULL;
	gchar* collate = NULL;
	gchar* column = NULL;
	RygelRelationalExpression* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	RygelMediaExportSqlOperator* operator = NULL;
	RygelRelationalExpression* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	GValue* _tmp40_ = NULL;
	RygelMediaExportSqlOperator* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	GError * _inner_error_ = NULL;
#line 1118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (exp != NULL, NULL);
#line 1118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 1122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	v = NULL;
#line 1123 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	collate = NULL;
#line 1125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = exp;
#line 1125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = ((RygelSearchExpression*) _tmp0_)->operand1;
#line 1125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_map_operand_to_column ((const gchar*) _tmp1_, &_tmp2_, FALSE, &_inner_error_);
#line 1125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (collate);
#line 1125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	collate = _tmp2_;
#line 1125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	column = _tmp3_;
#line 1125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 1125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (collate);
#line 1125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		__vala_GValue_free0 (v);
#line 1125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 8767 "rygel-media-export-media-cache.c"
	}
#line 1129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = exp;
#line 1129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = ((RygelSearchExpression*) _tmp4_)->op;
#line 1129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp5_)) {
#line 1129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
#line 8777 "rygel-media-export-media-cache.c"
		{
			gchar* sql_function = NULL;
			RygelRelationalExpression* _tmp6_ = NULL;
			gconstpointer _tmp7_ = NULL;
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
#line 1132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp6_ = exp;
#line 1132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp7_ = ((RygelSearchExpression*) _tmp6_)->operand2;
#line 1132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (g_strcmp0 ((const gchar*) _tmp7_, "true") == 0) {
#line 8792 "rygel-media-export-media-cache.c"
				gchar* _tmp8_ = NULL;
#line 1133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp8_ = g_strdup ("%s IS NOT NULL AND %s != ''");
#line 1133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sql_function);
#line 1133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				sql_function = _tmp8_;
#line 8800 "rygel-media-export-media-cache.c"
			} else {
				gchar* _tmp9_ = NULL;
#line 1135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp9_ = g_strdup ("%s IS NULL OR %s = ''");
#line 1135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sql_function);
#line 1135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				sql_function = _tmp9_;
#line 8809 "rygel-media-export-media-cache.c"
			}
#line 1138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = sql_function;
#line 1138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = column;
#line 1138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = column;
#line 1138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = g_strdup_printf (_tmp10_, _tmp11_, _tmp12_);
#line 1138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			result = _tmp13_;
#line 1138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (sql_function);
#line 1138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 1138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (column);
#line 1138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (collate);
#line 1138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 1138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return result;
#line 8833 "rygel-media-export-media-cache.c"
		}
#line 1129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
#line 1129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
#line 1129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
#line 1129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
#line 1129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
#line 1129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
#line 8847 "rygel-media-export-media-cache.c"
		{
			RygelRelationalExpression* _tmp14_ = NULL;
			gconstpointer _tmp15_ = NULL;
			GValue* _tmp16_ = NULL;
			RygelRelationalExpression* _tmp17_ = NULL;
			gconstpointer _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			RygelMediaExportSqlOperator* _tmp21_ = NULL;
#line 1145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = exp;
#line 1145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = ((RygelSearchExpression*) _tmp14_)->operand2;
#line 1145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp16_ = g_new0 (GValue, 1);
#line 1145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (_tmp16_, G_TYPE_STRING);
#line 1145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (_tmp16_, (const gchar*) _tmp15_);
#line 1145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 1145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			v = _tmp16_;
#line 1146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp17_ = exp;
#line 1146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp18_ = ((RygelSearchExpression*) _tmp17_)->op;
#line 1146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp19_ = column;
#line 1146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp20_ = collate;
#line 1146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp21_ = rygel_media_export_sql_operator_new_from_search_criteria_op ((GUPnPSearchCriteriaOp) ((gintptr) _tmp18_), _tmp19_, _tmp20_);
#line 1146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 1146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			operator = _tmp21_;
#line 1148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 8887 "rygel-media-export-media-cache.c"
		}
#line 1129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
#line 8891 "rygel-media-export-media-cache.c"
		{
			const gchar* _tmp22_ = NULL;
			RygelMediaExportSqlFunction* _tmp23_ = NULL;
			RygelRelationalExpression* _tmp24_ = NULL;
			gconstpointer _tmp25_ = NULL;
			GValue* _tmp26_ = NULL;
#line 1150 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp22_ = column;
#line 1150 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp23_ = rygel_media_export_sql_function_new ("contains", _tmp22_);
#line 1150 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 1150 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			operator = (RygelMediaExportSqlOperator*) _tmp23_;
#line 1151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp24_ = exp;
#line 1151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp25_ = ((RygelSearchExpression*) _tmp24_)->operand2;
#line 1151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp26_ = g_new0 (GValue, 1);
#line 1151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (_tmp26_, G_TYPE_STRING);
#line 1151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (_tmp26_, (const gchar*) _tmp25_);
#line 1151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 1151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			v = _tmp26_;
#line 1152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 8922 "rygel-media-export-media-cache.c"
		}
#line 1129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_DOES_NOT_CONTAIN:
#line 8926 "rygel-media-export-media-cache.c"
		{
			const gchar* _tmp27_ = NULL;
			RygelMediaExportSqlFunction* _tmp28_ = NULL;
			RygelRelationalExpression* _tmp29_ = NULL;
			gconstpointer _tmp30_ = NULL;
			GValue* _tmp31_ = NULL;
#line 1154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp27_ = column;
#line 1154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp28_ = rygel_media_export_sql_function_new ("NOT contains", _tmp27_);
#line 1154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 1154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			operator = (RygelMediaExportSqlOperator*) _tmp28_;
#line 1155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp29_ = exp;
#line 1155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp30_ = ((RygelSearchExpression*) _tmp29_)->operand2;
#line 1155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp31_ = g_new0 (GValue, 1);
#line 1155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (_tmp31_, G_TYPE_STRING);
#line 1155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (_tmp31_, (const gchar*) _tmp30_);
#line 1155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 1155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			v = _tmp31_;
#line 1156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 8957 "rygel-media-export-media-cache.c"
		}
#line 1129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
#line 8961 "rygel-media-export-media-cache.c"
		{
			const gchar* _tmp32_ = NULL;
			RygelMediaExportSqlOperator* _tmp33_ = NULL;
			RygelRelationalExpression* _tmp34_ = NULL;
			gconstpointer _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			GValue* _tmp37_ = NULL;
#line 1158 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp32_ = column;
#line 1158 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp33_ = rygel_media_export_sql_operator_new ("LIKE", _tmp32_, "");
#line 1158 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 1158 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			operator = _tmp33_;
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp34_ = exp;
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp35_ = ((RygelSearchExpression*) _tmp34_)->operand2;
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp36_ = g_strdup_printf ("%s%%", (const gchar*) _tmp35_);
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp37_ = g_new0 (GValue, 1);
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (_tmp37_, G_TYPE_STRING);
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_take_string (_tmp37_, _tmp36_);
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			v = _tmp37_;
#line 1160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 8995 "rygel-media-export-media-cache.c"
		}
		default:
		{
			RygelRelationalExpression* _tmp38_ = NULL;
			gconstpointer _tmp39_ = NULL;
#line 1162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp38_ = exp;
#line 1162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp39_ = ((RygelSearchExpression*) _tmp38_)->op;
#line 1162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_warning ("rygel-media-export-media-cache.vala:1162: Unsupported op %d", (gint) ((GUPnPSearchCriteriaOp) ((gintptr) _tmp39_)));
#line 1163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			result = NULL;
#line 1163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 1163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (column);
#line 1163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (collate);
#line 1163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 1163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return result;
#line 9019 "rygel-media-export-media-cache.c"
		}
	}
#line 1166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp40_ = v;
#line 1166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp40_ != NULL) {
#line 9026 "rygel-media-export-media-cache.c"
		GValueArray* _tmp41_ = NULL;
		GValue* _tmp42_ = NULL;
		GValue _tmp43_ = {0};
#line 1167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp41_ = args;
#line 1167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp42_ = v;
#line 1167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp43_ = *_tmp42_;
#line 1167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_array_append (_tmp41_, &_tmp43_);
#line 9038 "rygel-media-export-media-cache.c"
	}
#line 1170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp44_ = operator;
#line 1170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp45_ = rygel_media_export_sql_operator_to_string (_tmp44_);
#line 1170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp45_;
#line 1170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (operator);
#line 1170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (column);
#line 1170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (collate);
#line 1170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	__vala_GValue_free0 (v);
#line 1170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 9056 "rygel-media-export-media-cache.c"
}


static RygelMediaExportDatabaseCursor* rygel_media_export_media_cache_exec_cursor (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error) {
	RygelMediaExportDatabaseCursor* result = NULL;
	RygelMediaExportDatabaseCursor* _tmp0_ = NULL;
	RygelMediaExportDatabase* _tmp1_ = NULL;
	RygelMediaExportSQLFactory* _tmp2_ = NULL;
	RygelMediaExportSQLString _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
	GValue* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp6_ = NULL;
	RygelMediaExportDatabaseCursor* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 1173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = self->priv->db;
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = self->priv->sql;
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = id;
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = rygel_media_export_sql_factory_make (_tmp2_, _tmp3_);
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = values;
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5__length1 = values_length1;
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = rygel_media_export_database_exec_cursor (_tmp1_, _tmp4_, _tmp5_, _tmp5__length1, &_inner_error_);
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = _tmp6_;
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 9098 "rygel-media-export-media-cache.c"
		} else {
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 9106 "rygel-media-export-media-cache.c"
		}
	}
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = _tmp0_;
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = NULL;
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp7_;
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (_tmp0_);
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 9119 "rygel-media-export-media-cache.c"
}


static gint rygel_media_export_media_cache_query_value (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error) {
	gint result = 0;
	gint _tmp0_ = 0;
	RygelMediaExportDatabase* _tmp1_ = NULL;
	RygelMediaExportSQLFactory* _tmp2_ = NULL;
	RygelMediaExportSQLString _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
	GValue* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp6_ = 0;
	GError * _inner_error_ = NULL;
#line 1179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = self->priv->db;
#line 1182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = self->priv->sql;
#line 1182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = id;
#line 1182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = rygel_media_export_sql_factory_make (_tmp2_, _tmp3_);
#line 1182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = values;
#line 1182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5__length1 = values_length1;
#line 1182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = rygel_media_export_database_query_value (_tmp1_, _tmp4_, _tmp5_, _tmp5__length1, &_inner_error_);
#line 1182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = _tmp6_;
#line 1182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 1182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 1182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return 0;
#line 9160 "rygel-media-export-media-cache.c"
		} else {
#line 1182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 1182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return 0;
#line 9168 "rygel-media-export-media-cache.c"
		}
	}
#line 1182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp0_;
#line 1182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 9175 "rygel-media-export-media-cache.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1230 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1231 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1231 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1231 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1232 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1232 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 9208 "rygel-media-export-media-cache.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1233 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1233 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1233 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 9217 "rygel-media-export-media-cache.c"
	}
#line 1235 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1235 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 9223 "rygel-media-export-media-cache.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1236 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1236 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1236 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 9232 "rygel-media-export-media-cache.c"
	}
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 9238 "rygel-media-export-media-cache.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 9247 "rygel-media-export-media-cache.c"
	} else {
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 9251 "rygel-media-export-media-cache.c"
	}
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 9259 "rygel-media-export-media-cache.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 9268 "rygel-media-export-media-cache.c"
	} else {
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 9272 "rygel-media-export-media-cache.c"
	}
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1240 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1240 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1240 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 9294 "rygel-media-export-media-cache.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 9312 "rygel-media-export-media-cache.c"
}


static gchar* rygel_media_export_media_cache_translate_sort_criteria (const gchar* sort_criteria, gchar** extra_columns, gint* column_count) {
	gchar* _vala_extra_columns = NULL;
	gint _vala_column_count = 0;
	gchar* result = NULL;
	gchar* collate = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	GString* column_builder = NULL;
	GString* _tmp1_ = NULL;
	gchar** fields = NULL;
	const gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint fields_length1 = 0;
	gint _fields_size_ = 0;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	GString* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	GString* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	GError * _inner_error_ = NULL;
#line 1185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (sort_criteria != NULL, NULL);
#line 1190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = g_string_new ("ORDER BY ");
#line 1190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	builder = _tmp0_;
#line 1191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = g_string_new ("");
#line 1191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	column_builder = _tmp1_;
#line 1192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = sort_criteria;
#line 1192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ",", 0);
#line 1192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	fields = _tmp4_;
#line 1192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	fields_length1 = _vala_array_length (_tmp3_);
#line 1192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_fields_size_ = fields_length1;
#line 1193 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = fields;
#line 1193 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5__length1 = fields_length1;
#line 1193 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_column_count = _tmp5__length1;
#line 1194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = fields;
#line 1194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6__length1 = fields_length1;
#line 9372 "rygel-media-export-media-cache.c"
	{
		gchar** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
#line 1194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		field_collection = _tmp6_;
#line 1194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		field_collection_length1 = _tmp6__length1;
#line 1194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		for (field_it = 0; field_it < _tmp6__length1; field_it = field_it + 1) {
#line 9384 "rygel-media-export-media-cache.c"
			const gchar* field = NULL;
#line 1194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			field = field_collection[field_it];
#line 9388 "rygel-media-export-media-cache.c"
			{
				{
					gchar* column = NULL;
					const gchar* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					const gchar* _tmp18_ = NULL;
					GString* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					gchar _tmp23_ = '\0';
					GString* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					GString* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
#line 1196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp7_ = field;
#line 1196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp8_ = field;
#line 1196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp9_ = strlen (_tmp8_);
#line 1196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp10_ = _tmp9_;
#line 1196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp11_ = string_slice (_tmp7_, (glong) 1, (glong) _tmp10_);
#line 1196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp12_ = _tmp11_;
#line 1196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp14_ = rygel_media_export_media_cache_map_operand_to_column (_tmp12_, &_tmp13_, TRUE, &_inner_error_);
#line 1196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (collate);
#line 1196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					collate = _tmp13_;
#line 1196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp15_ = _tmp14_;
#line 1196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (_tmp12_);
#line 1196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					column = _tmp15_;
#line 1196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9440 "rygel-media-export-media-cache.c"
						goto __catch20_g_error;
					}
#line 1200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp16_ = field;
#line 1200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp17_ = fields;
#line 1200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp17__length1 = fields_length1;
#line 1200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp18_ = _tmp17_[0];
#line 1200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					if (g_strcmp0 (_tmp16_, _tmp18_) != 0) {
#line 9453 "rygel-media-export-media-cache.c"
						GString* _tmp19_ = NULL;
#line 1201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
						_tmp19_ = builder;
#line 1201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
						g_string_append (_tmp19_, ",");
#line 9459 "rygel-media-export-media-cache.c"
					}
#line 1203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp20_ = column_builder;
#line 1203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_string_append (_tmp20_, ",");
#line 1207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp22_ = field;
#line 1207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp23_ = string_get (_tmp22_, (glong) 0);
#line 1207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					if (_tmp23_ == '-') {
#line 1207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
						_tmp21_ = "DESC";
#line 9473 "rygel-media-export-media-cache.c"
					} else {
#line 1207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
						_tmp21_ = "ASC";
#line 9477 "rygel-media-export-media-cache.c"
					}
#line 1204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp24_ = builder;
#line 1204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp25_ = column;
#line 1204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp26_ = collate;
#line 1204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_string_append_printf (_tmp24_, "%s %s %s ", _tmp25_, _tmp26_, _tmp21_);
#line 1208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp27_ = column_builder;
#line 1208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp28_ = column;
#line 1208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_string_append (_tmp27_, _tmp28_);
#line 1195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (column);
#line 9495 "rygel-media-export-media-cache.c"
				}
				goto __finally20;
				__catch20_g_error:
				{
					GError* _error_ = NULL;
					const gchar* _tmp29_ = NULL;
#line 1195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_error_ = _inner_error_;
#line 1195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_inner_error_ = NULL;
#line 1210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp29_ = field;
#line 1210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_warning ("rygel-media-export-media-cache.vala:1210: Skipping unsupported field: " \
"%s", _tmp29_);
#line 1195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_error_free0 (_error_);
#line 9512 "rygel-media-export-media-cache.c"
				}
				__finally20:
#line 1195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
#line 1195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_string_free0 (column_builder);
#line 1195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_string_free0 (builder);
#line 1195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (collate);
#line 1195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_clear_error (&_inner_error_);
#line 1195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 9531 "rygel-media-export-media-cache.c"
				}
			}
		}
	}
#line 1214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp30_ = column_builder;
#line 1214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp31_ = _tmp30_->str;
#line 1214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_ = g_strdup (_tmp31_);
#line 1214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_vala_extra_columns);
#line 1214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_extra_columns = _tmp32_;
#line 1216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_ = builder;
#line 1216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_ = _tmp33_->str;
#line 1216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp35_ = g_strdup (_tmp34_);
#line 1216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp35_;
#line 1216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
#line 1216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_string_free0 (column_builder);
#line 1216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_string_free0 (builder);
#line 1216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (collate);
#line 1216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (extra_columns) {
#line 1216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*extra_columns = _vala_extra_columns;
#line 9566 "rygel-media-export-media-cache.c"
	} else {
#line 1216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_vala_extra_columns);
#line 9570 "rygel-media-export-media-cache.c"
	}
#line 1216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (column_count) {
#line 1216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*column_count = _vala_column_count;
#line 9576 "rygel-media-export-media-cache.c"
	}
#line 1216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 9580 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_class_init (RygelMediaExportMediaCacheClass * klass) {
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_parent_class = g_type_class_peek_parent (klass);
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaExportMediaCachePrivate));
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_media_cache_finalize;
#line 9591 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_instance_init (RygelMediaExportMediaCache * self) {
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self->priv = RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE (self);
#line 9598 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_finalize (GObject* obj) {
	RygelMediaExportMediaCache * self;
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache);
#line 55 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->db);
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->factory);
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->sql);
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->exists_cache);
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_OBJECT_CLASS (rygel_media_export_media_cache_parent_class)->finalize (obj);
#line 9616 "rygel-media-export-media-cache.c"
}


/**
 * Persistent storage of media objects.
 *
 * MediaExportDB is a sqlite3 backed persistent storage of media objects.
 */
GType rygel_media_export_media_cache_get_type (void) {
	static volatile gsize rygel_media_export_media_cache_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_media_cache_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMediaCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_media_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMediaCache), 0, (GInstanceInitFunc) rygel_media_export_media_cache_instance_init, NULL };
		GType rygel_media_export_media_cache_type_id;
		rygel_media_export_media_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportMediaCache", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_media_cache_type_id__volatile, rygel_media_export_media_cache_type_id);
	}
	return rygel_media_export_media_cache_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



