/* rygel-trackable-container.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-trackable-container.vala, do not modify */

/*
 * Copyright (C) 2012,2013 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>
#include <uuid/uuid.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_TRACKABLE_CONTAINER (rygel_trackable_container_get_type ())
#define RYGEL_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainer))
#define RYGEL_IS_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER))
#define RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainerIface))

typedef struct _RygelTrackableContainer RygelTrackableContainer;
typedef struct _RygelTrackableContainerIface RygelTrackableContainerIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelTrackableContainerClearData RygelTrackableContainerClearData;

#define RYGEL_TYPE_OBJECT_EVENT_TYPE (rygel_object_event_type_get_type ())
typedef struct _RygelTrackableContainerAddChildTrackedData RygelTrackableContainerAddChildTrackedData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
typedef struct _RygelTrackableContainerRemoveChildTrackedData RygelTrackableContainerRemoveChildTrackedData;

struct _RygelTrackableContainerIface {
	GTypeInterface parent_iface;
	void (*add_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
	void (*remove_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
	gchar* (*get_service_reset_token) (RygelTrackableContainer* self);
	void (*set_service_reset_token) (RygelTrackableContainer* self, const gchar* token);
	guint32 (*get_system_update_id) (RygelTrackableContainer* self);
};

struct _RygelTrackableContainerClearData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackableContainer* self;
	RygelMediaObjects* children;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	RygelMediaObjects* _tmp2_;
	RygelMediaObjects* _tmp3_;
	RygelMediaObjects* _child_list;
	RygelMediaObjects* _tmp4_;
	RygelMediaObjects* _tmp5_;
	gint _child_size;
	RygelMediaObjects* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _child_index;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	RygelMediaObject* child;
	RygelMediaObjects* _tmp12_;
	gint _tmp13_;
	gpointer _tmp14_;
	RygelMediaObject* _tmp15_;
	GError* _error_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_OBJECT_EVENT_TYPE_ADDED = 0,
	RYGEL_OBJECT_EVENT_TYPE_MODIFIED = 1,
	RYGEL_OBJECT_EVENT_TYPE_DELETED = 2
} RygelObjectEventType;

struct _RygelTrackableContainerAddChildTrackedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackableContainer* self;
	RygelMediaObject* object;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaObject* _tmp2_;
	RygelTrackableContainer* trackable;
	RygelMediaObject* _tmp3_;
	RygelTrackableContainer* _tmp4_;
	RygelTrackableContainer* _tmp5_;
	RygelMediaObject* _tmp6_;
};

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*add_uri) (RygelMediaObject* self, const gchar* uri);
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	RygelDataSource* (*create_stream_source_for_resource) (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	guint32 update_id;
	gint64 storage_used;
	gint64 total_deleted_child_count;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelTrackableContainerRemoveChildTrackedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackableContainer* self;
	RygelMediaObject* object;
	RygelMediaObject* _tmp0_;
	RygelTrackableContainer* trackable;
	RygelMediaObject* _tmp1_;
	RygelTrackableContainer* _tmp2_;
	RygelTrackableContainer* _tmp3_;
	RygelMediaObject* _tmp4_;
	RygelMediaObject* _tmp5_;
	gint64 _tmp6_;
	RygelMediaObject* _tmp7_;
};



GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_trackable_container_get_type (void) G_GNUC_CONST;
static void rygel_trackable_container_clear_data_free (gpointer _data);
void rygel_trackable_container_clear (RygelTrackableContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_trackable_container_clear_finish (RygelTrackableContainer* self, GAsyncResult* _res_);
static gboolean rygel_trackable_container_clear_co (RygelTrackableContainerClearData* _data_);
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
void rygel_media_container_get_children (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
const gchar* rygel_media_container_get_sort_criteria (RygelMediaContainer* self);
static void rygel_trackable_container_clear_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_trackable_container_remove_child_tracked (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_trackable_container_remove_child_tracked_finish (RygelTrackableContainer* self, GAsyncResult* _res_);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
void rygel_trackable_container_add_child (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_trackable_container_add_child_finish (RygelTrackableContainer* self, GAsyncResult* _res_);
static void rygel_trackable_container_add_child_tracked_data_free (gpointer _data);
void rygel_trackable_container_add_child_tracked (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_trackable_container_add_child_tracked_finish (RygelTrackableContainer* self, GAsyncResult* _res_);
static gboolean rygel_trackable_container_add_child_tracked_co (RygelTrackableContainerAddChildTrackedData* _data_);
static void rygel_trackable_container_add_child_tracked_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_object_event_type_get_type (void) G_GNUC_CONST;
void rygel_media_container_updated (RygelMediaContainer* self, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static void rygel_trackable_container_thaw_events (RygelTrackableContainer* self);
void rygel_trackable_container_remove_child (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_trackable_container_remove_child_finish (RygelTrackableContainer* self, GAsyncResult* _res_);
static void rygel_trackable_container_remove_child_tracked_data_free (gpointer _data);
static gboolean rygel_trackable_container_remove_child_tracked_co (RygelTrackableContainerRemoveChildTrackedData* _data_);
static void rygel_trackable_container_remove_child_tracked_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
gchar* rygel_trackable_container_get_service_reset_token (RygelTrackableContainer* self);
static gchar* rygel_trackable_container_real_get_service_reset_token (RygelTrackableContainer* self);
void rygel_trackable_container_set_service_reset_token (RygelTrackableContainer* self, const gchar* token);
static void rygel_trackable_container_real_set_service_reset_token (RygelTrackableContainer* self, const gchar* token);
guint32 rygel_trackable_container_get_system_update_id (RygelTrackableContainer* self);
static guint32 rygel_trackable_container_real_get_system_update_id (RygelTrackableContainer* self);


static void rygel_trackable_container_clear_data_free (gpointer _data) {
	RygelTrackableContainerClearData* _data_;
	_data_ = _data;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_g_object_unref0 (_data_->self);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	g_slice_free (RygelTrackableContainerClearData, _data_);
#line 343 "rygel-trackable-container.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	return self ? g_object_ref (self) : NULL;
#line 350 "rygel-trackable-container.c"
}


void rygel_trackable_container_clear (RygelTrackableContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackableContainerClearData* _data_;
	RygelTrackableContainer* _tmp0_ = NULL;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_ = g_slice_new0 (RygelTrackableContainerClearData);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_trackable_container_clear);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_trackable_container_clear_data_free);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->self = _tmp0_;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	rygel_trackable_container_clear_co (_data_);
#line 369 "rygel-trackable-container.c"
}


void rygel_trackable_container_clear_finish (RygelTrackableContainer* self, GAsyncResult* _res_) {
	RygelTrackableContainerClearData* _data_;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 377 "rygel-trackable-container.c"
}


static void rygel_trackable_container_clear_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackableContainerClearData* _data_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_ = _user_data_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_source_object_ = source_object;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_res_ = _res_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	rygel_trackable_container_clear_co (_data_);
#line 391 "rygel-trackable-container.c"
}


static gboolean rygel_trackable_container_clear_co (RygelTrackableContainerClearData* _data_) {
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	switch (_data_->_state_) {
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		case 0:
#line 400 "rygel-trackable-container.c"
		goto _state_0;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		case 1:
#line 404 "rygel-trackable-container.c"
		goto _state_1;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		case 2:
#line 408 "rygel-trackable-container.c"
		goto _state_2;
		default:
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		g_assert_not_reached ();
#line 413 "rygel-trackable-container.c"
	}
	_state_0:
	{
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp0_ = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp0_ = rygel_media_container_get_sort_criteria ((RygelMediaContainer*) _data_->self);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp1_ = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp1_ = _data_->_tmp0_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_state_ = 1;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		rygel_media_container_get_children ((RygelMediaContainer*) _data_->self, (guint) 0, (guint) (-1), _data_->_tmp1_, NULL, rygel_trackable_container_clear_ready, _data_);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		return FALSE;
#line 431 "rygel-trackable-container.c"
		_state_1:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp2_ = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp2_ = rygel_media_container_get_children_finish ((RygelMediaContainer*) _data_->self, _data_->_res_, &_data_->_inner_error_);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->children = _data_->_tmp2_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 441 "rygel-trackable-container.c"
			goto __catch20_g_error;
		}
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp3_ = NULL;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp3_ = _data_->children;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		if (_data_->_tmp3_ == NULL) {
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
			_g_object_unref0 (_data_->children);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
			if (_data_->_state_ == 0) {
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 456 "rygel-trackable-container.c"
			} else {
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 460 "rygel-trackable-container.c"
			}
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
			g_object_unref (_data_->_async_result);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
			return FALSE;
#line 466 "rygel-trackable-container.c"
		}
		{
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
			_data_->_tmp4_ = NULL;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
			_data_->_tmp4_ = _data_->children;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
			_data_->_tmp5_ = NULL;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
			_data_->_tmp5_ = _g_object_ref0 (_data_->_tmp4_);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
			_data_->_child_list = _data_->_tmp5_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
			_data_->_tmp6_ = NULL;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
			_data_->_tmp6_ = _data_->_child_list;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
			_data_->_tmp7_ = 0;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
			_data_->_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp6_);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
			_data_->_tmp8_ = 0;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
			_data_->_tmp8_ = _data_->_tmp7_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
			_data_->_child_size = _data_->_tmp8_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
			_data_->_child_index = -1;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
			while (TRUE) {
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				_data_->_tmp9_ = 0;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				_data_->_tmp9_ = _data_->_child_index;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				_data_->_child_index = _data_->_tmp9_ + 1;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				_data_->_tmp10_ = 0;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				_data_->_tmp10_ = _data_->_child_index;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				_data_->_tmp11_ = 0;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				_data_->_tmp11_ = _data_->_child_size;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				if (!(_data_->_tmp10_ < _data_->_tmp11_)) {
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
					break;
#line 515 "rygel-trackable-container.c"
				}
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				_data_->_tmp12_ = NULL;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				_data_->_tmp12_ = _data_->_child_list;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				_data_->_tmp13_ = 0;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				_data_->_tmp13_ = _data_->_child_index;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				_data_->_tmp14_ = NULL;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				_data_->_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp12_, _data_->_tmp13_);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				_data_->child = (RygelMediaObject*) _data_->_tmp14_;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				_data_->_tmp15_ = NULL;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				_data_->_tmp15_ = _data_->child;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				_data_->_state_ = 2;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				rygel_trackable_container_remove_child_tracked (_data_->self, _data_->_tmp15_, rygel_trackable_container_clear_ready, _data_);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				return FALSE;
#line 541 "rygel-trackable-container.c"
				_state_2:
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				rygel_trackable_container_remove_child_tracked_finish (_data_->self, _data_->_res_);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
				_g_object_unref0 (_data_->child);
#line 547 "rygel-trackable-container.c"
			}
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
			_g_object_unref0 (_data_->_child_list);
#line 551 "rygel-trackable-container.c"
		}
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_g_object_unref0 (_data_->children);
#line 555 "rygel-trackable-container.c"
	}
	goto __finally20;
	__catch20_g_error:
	{
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_inner_error_ = NULL;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp16_ = NULL;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp16_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->self);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp17_ = NULL;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp17_ = _data_->_tmp16_;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp18_ = NULL;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp18_ = _data_->_error_;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp19_ = NULL;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp19_ = _data_->_tmp18_->message;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		g_warning ("rygel-trackable-container.vala:49: Failed to clear trackable container" \
" %s: %s", _data_->_tmp17_, _data_->_tmp19_);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_g_error_free0 (_data_->_error_);
#line 584 "rygel-trackable-container.c"
	}
	__finally20:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		g_clear_error (&_data_->_inner_error_);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		return FALSE;
#line 595 "rygel-trackable-container.c"
	}
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	if (_data_->_state_ == 0) {
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 601 "rygel-trackable-container.c"
	} else {
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 605 "rygel-trackable-container.c"
	}
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	g_object_unref (_data_->_async_result);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	return FALSE;
#line 611 "rygel-trackable-container.c"
}


void rygel_trackable_container_add_child (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE (self)->add_child (self, object, _callback_, _user_data_);
#line 618 "rygel-trackable-container.c"
}


void rygel_trackable_container_add_child_finish (RygelTrackableContainer* self, GAsyncResult* _res_) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE (self)->add_child_finish (self, _res_);
#line 625 "rygel-trackable-container.c"
}


static void rygel_trackable_container_add_child_tracked_data_free (gpointer _data) {
	RygelTrackableContainerAddChildTrackedData* _data_;
	_data_ = _data;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_g_object_unref0 (_data_->object);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_g_object_unref0 (_data_->self);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	g_slice_free (RygelTrackableContainerAddChildTrackedData, _data_);
#line 638 "rygel-trackable-container.c"
}


void rygel_trackable_container_add_child_tracked (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackableContainerAddChildTrackedData* _data_;
	RygelTrackableContainer* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMediaObject* _tmp2_ = NULL;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_ = g_slice_new0 (RygelTrackableContainerAddChildTrackedData);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_trackable_container_add_child_tracked);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_trackable_container_add_child_tracked_data_free);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->self = _tmp0_;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_tmp1_ = object;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_g_object_unref0 (_data_->object);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->object = _tmp2_;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	rygel_trackable_container_add_child_tracked_co (_data_);
#line 667 "rygel-trackable-container.c"
}


void rygel_trackable_container_add_child_tracked_finish (RygelTrackableContainer* self, GAsyncResult* _res_) {
	RygelTrackableContainerAddChildTrackedData* _data_;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 675 "rygel-trackable-container.c"
}


/**
     * Add a child object, emitting the #RygelContainer::container_updated signal
     * with the object.
     * @see rygel_trackable_object_remove_child_tracked()
     *
     * @param object The child item or child container to be added.
     */
static void rygel_trackable_container_add_child_tracked_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackableContainerAddChildTrackedData* _data_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_ = _user_data_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_source_object_ = source_object;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_res_ = _res_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	rygel_trackable_container_add_child_tracked_co (_data_);
#line 696 "rygel-trackable-container.c"
}


static gboolean rygel_trackable_container_add_child_tracked_co (RygelTrackableContainerAddChildTrackedData* _data_) {
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	switch (_data_->_state_) {
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		case 0:
#line 705 "rygel-trackable-container.c"
		goto _state_0;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		case 1:
#line 709 "rygel-trackable-container.c"
		goto _state_1;
		default:
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		g_assert_not_reached ();
#line 714 "rygel-trackable-container.c"
	}
	_state_0:
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_tmp0_ = NULL;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_tmp0_ = _data_->object;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_state_ = 1;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	rygel_trackable_container_add_child (_data_->self, _data_->_tmp0_, rygel_trackable_container_add_child_tracked_ready, _data_);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	return FALSE;
#line 727 "rygel-trackable-container.c"
	_state_1:
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	rygel_trackable_container_add_child_finish (_data_->self, _data_->_res_);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_tmp1_ = NULL;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_tmp1_ = _data_->object;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	rygel_media_container_updated ((RygelMediaContainer*) _data_->self, _data_->_tmp1_, RYGEL_OBJECT_EVENT_TYPE_ADDED, FALSE);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	rygel_media_container_updated ((RygelMediaContainer*) _data_->self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_tmp2_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_tmp2_ = _data_->object;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp2_, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp3_ = NULL;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp3_ = _data_->object;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp4_ = NULL;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp3_, RYGEL_TYPE_TRACKABLE_CONTAINER) ? ((RygelTrackableContainer*) _data_->_tmp3_) : NULL);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->trackable = _data_->_tmp4_;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp5_ = NULL;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp5_ = _data_->trackable;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		rygel_trackable_container_thaw_events (_data_->_tmp5_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_g_object_unref0 (_data_->trackable);
#line 763 "rygel-trackable-container.c"
	}
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_tmp6_ = NULL;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_tmp6_ = _data_->object;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	g_signal_emit_by_name (_data_->self, "child-added", _data_->_tmp6_);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	if (_data_->_state_ == 0) {
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 775 "rygel-trackable-container.c"
	} else {
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 779 "rygel-trackable-container.c"
	}
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	g_object_unref (_data_->_async_result);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	return FALSE;
#line 785 "rygel-trackable-container.c"
}


void rygel_trackable_container_remove_child (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE (self)->remove_child (self, object, _callback_, _user_data_);
#line 792 "rygel-trackable-container.c"
}


void rygel_trackable_container_remove_child_finish (RygelTrackableContainer* self, GAsyncResult* _res_) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE (self)->remove_child_finish (self, _res_);
#line 799 "rygel-trackable-container.c"
}


static void rygel_trackable_container_remove_child_tracked_data_free (gpointer _data) {
	RygelTrackableContainerRemoveChildTrackedData* _data_;
	_data_ = _data;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_g_object_unref0 (_data_->object);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_g_object_unref0 (_data_->self);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	g_slice_free (RygelTrackableContainerRemoveChildTrackedData, _data_);
#line 812 "rygel-trackable-container.c"
}


void rygel_trackable_container_remove_child_tracked (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackableContainerRemoveChildTrackedData* _data_;
	RygelTrackableContainer* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMediaObject* _tmp2_ = NULL;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_ = g_slice_new0 (RygelTrackableContainerRemoveChildTrackedData);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_trackable_container_remove_child_tracked);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_trackable_container_remove_child_tracked_data_free);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->self = _tmp0_;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_tmp1_ = object;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_g_object_unref0 (_data_->object);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->object = _tmp2_;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	rygel_trackable_container_remove_child_tracked_co (_data_);
#line 841 "rygel-trackable-container.c"
}


void rygel_trackable_container_remove_child_tracked_finish (RygelTrackableContainer* self, GAsyncResult* _res_) {
	RygelTrackableContainerRemoveChildTrackedData* _data_;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 849 "rygel-trackable-container.c"
}


/**
     * Add a child object, emitting the #RygelContainer::container_updated signal
     * with the object.
     * @see rygel_trackable_object_add_child_tracked()
     *
     * @param object The child item or child container to be added.
     */
static void rygel_trackable_container_remove_child_tracked_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackableContainerRemoveChildTrackedData* _data_;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_ = _user_data_;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_source_object_ = source_object;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_res_ = _res_;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	rygel_trackable_container_remove_child_tracked_co (_data_);
#line 870 "rygel-trackable-container.c"
}


static gboolean rygel_trackable_container_remove_child_tracked_co (RygelTrackableContainerRemoveChildTrackedData* _data_) {
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	switch (_data_->_state_) {
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		case 0:
#line 879 "rygel-trackable-container.c"
		goto _state_0;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		case 1:
#line 883 "rygel-trackable-container.c"
		goto _state_1;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		case 2:
#line 887 "rygel-trackable-container.c"
		goto _state_2;
		default:
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		g_assert_not_reached ();
#line 892 "rygel-trackable-container.c"
	}
	_state_0:
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_tmp0_ = NULL;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_tmp0_ = _data_->object;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp0_, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp1_ = NULL;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp1_ = _data_->object;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp2_ = NULL;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, RYGEL_TYPE_TRACKABLE_CONTAINER) ? ((RygelTrackableContainer*) _data_->_tmp1_) : NULL);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->trackable = _data_->_tmp2_;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp3_ = NULL;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_tmp3_ = _data_->trackable;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_data_->_state_ = 1;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		rygel_trackable_container_clear (_data_->_tmp3_, rygel_trackable_container_remove_child_tracked_ready, _data_);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		return FALSE;
#line 921 "rygel-trackable-container.c"
		_state_1:
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		rygel_trackable_container_clear_finish (_data_->_tmp3_, _data_->_res_);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		_g_object_unref0 (_data_->trackable);
#line 927 "rygel-trackable-container.c"
	}
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_tmp4_ = NULL;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_tmp4_ = _data_->object;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_state_ = 2;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	rygel_trackable_container_remove_child (_data_->self, _data_->_tmp4_, rygel_trackable_container_remove_child_tracked_ready, _data_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	return FALSE;
#line 939 "rygel-trackable-container.c"
	_state_2:
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	rygel_trackable_container_remove_child_finish (_data_->self, _data_->_res_);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_tmp5_ = NULL;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_tmp5_ = _data_->object;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	rygel_media_container_updated ((RygelMediaContainer*) _data_->self, _data_->_tmp5_, RYGEL_OBJECT_EVENT_TYPE_DELETED, FALSE);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_tmp6_ = 0LL;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_tmp6_ = ((RygelMediaContainer*) _data_->self)->total_deleted_child_count;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	((RygelMediaContainer*) _data_->self)->total_deleted_child_count = _data_->_tmp6_ + 1;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	rygel_media_container_updated ((RygelMediaContainer*) _data_->self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_tmp7_ = NULL;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_data_->_tmp7_ = _data_->object;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	g_signal_emit_by_name (_data_->self, "child-removed", _data_->_tmp7_);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	if (_data_->_state_ == 0) {
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 967 "rygel-trackable-container.c"
	} else {
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 971 "rygel-trackable-container.c"
	}
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	g_object_unref (_data_->_async_result);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	return FALSE;
#line 977 "rygel-trackable-container.c"
}


/**
     * Used to query the (persisted) service reset token from the plug-in.
     *
     * If a plugin implements PLUGIN_CAPABILITIES_TRACK_CHANGES, it should
     * persist the ServiceResetToken. To do this override this virtual
     * function in the root container implementation and provide the persisted
     * version.
     */
static gchar* uuid_get (void) {
	gchar* result = NULL;
	guchar* id = NULL;
	guchar* _tmp0_ = NULL;
	gint id_length1 = 0;
	gint _id_size_ = 0;
	guchar* unparsed = NULL;
	guchar* _tmp1_ = NULL;
	gint unparsed_length1 = 0;
	gint _unparsed_size_ = 0;
	guchar* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guchar* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	guchar _tmp6_ = '\0';
	guchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar* _tmp8_ = NULL;
#line 8 "../../src/librygel-core/uuid.vapi"
	_tmp0_ = g_new0 (guchar, 16);
#line 8 "../../src/librygel-core/uuid.vapi"
	id = _tmp0_;
#line 8 "../../src/librygel-core/uuid.vapi"
	id_length1 = 16;
#line 8 "../../src/librygel-core/uuid.vapi"
	_id_size_ = id_length1;
#line 9 "../../src/librygel-core/uuid.vapi"
	_tmp1_ = g_new0 (guchar, 51);
#line 9 "../../src/librygel-core/uuid.vapi"
	unparsed = _tmp1_;
#line 9 "../../src/librygel-core/uuid.vapi"
	unparsed_length1 = 51;
#line 9 "../../src/librygel-core/uuid.vapi"
	_unparsed_size_ = unparsed_length1;
#line 11 "../../src/librygel-core/uuid.vapi"
	_tmp2_ = id;
#line 11 "../../src/librygel-core/uuid.vapi"
	_tmp2__length1 = id_length1;
#line 11 "../../src/librygel-core/uuid.vapi"
	uuid_generate (_tmp2_);
#line 12 "../../src/librygel-core/uuid.vapi"
	_tmp3_ = id;
#line 12 "../../src/librygel-core/uuid.vapi"
	_tmp3__length1 = id_length1;
#line 12 "../../src/librygel-core/uuid.vapi"
	_tmp4_ = unparsed;
#line 12 "../../src/librygel-core/uuid.vapi"
	_tmp4__length1 = unparsed_length1;
#line 12 "../../src/librygel-core/uuid.vapi"
	uuid_unparse (_tmp3_, _tmp4_);
#line 13 "../../src/librygel-core/uuid.vapi"
	_tmp5_ = unparsed;
#line 13 "../../src/librygel-core/uuid.vapi"
	_tmp5__length1 = unparsed_length1;
#line 13 "../../src/librygel-core/uuid.vapi"
	_tmp5_[50] = (guchar) '\0';
#line 13 "../../src/librygel-core/uuid.vapi"
	_tmp6_ = _tmp5_[50];
#line 15 "../../src/librygel-core/uuid.vapi"
	_tmp7_ = unparsed;
#line 15 "../../src/librygel-core/uuid.vapi"
	_tmp7__length1 = unparsed_length1;
#line 15 "../../src/librygel-core/uuid.vapi"
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
#line 15 "../../src/librygel-core/uuid.vapi"
	result = _tmp8_;
#line 15 "../../src/librygel-core/uuid.vapi"
	unparsed = (g_free (unparsed), NULL);
#line 15 "../../src/librygel-core/uuid.vapi"
	id = (g_free (id), NULL);
#line 15 "../../src/librygel-core/uuid.vapi"
	return result;
#line 1065 "rygel-trackable-container.c"
}


static gchar* rygel_trackable_container_real_get_service_reset_token (RygelTrackableContainer* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	_tmp0_ = uuid_get ();
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	result = _tmp0_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	return result;
#line 1078 "rygel-trackable-container.c"
}


gchar* rygel_trackable_container_get_service_reset_token (RygelTrackableContainer* self) {
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	return RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE (self)->get_service_reset_token (self);
#line 1087 "rygel-trackable-container.c"
}


/**
     * Set a new service reset token.
     *
     * If the service reset procedure has to be performed, the content
     * directory service will set the new service reset token.
     *
     * @param token the new service reset token.
     */
static void rygel_trackable_container_real_set_service_reset_token (RygelTrackableContainer* self, const gchar* token) {
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	g_return_if_fail (token != NULL);
#line 1102 "rygel-trackable-container.c"
}


void rygel_trackable_container_set_service_reset_token (RygelTrackableContainer* self, const gchar* token) {
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	g_return_if_fail (self != NULL);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE (self)->set_service_reset_token (self, token);
#line 1111 "rygel-trackable-container.c"
}


/**
     * Query the current system update ID,
     * used for the UPnP GetSystemUpdateID implementation.
     *
     * This should be overriden by the root container of the back-end
     * implementation. This will only be called once, at service startup, 
     * to discover the cached system Update ID, if any, that was known
     * when the service last shut down.
     *
     * Derived classes may need to delay part of their initialization
     * until this function has been called, doing that initialization in
     * the function override. That can prevent other parts of their 
     * implementation from changing the cached System Update ID before
     * it has been provided.
     *
     * @return the current SystemUpdateID as persisted by the back-end.
     */
static guint32 rygel_trackable_container_real_get_system_update_id (RygelTrackableContainer* self) {
	guint32 result = 0U;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	result = (guint32) 0;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	return result;
#line 1138 "rygel-trackable-container.c"
}


guint32 rygel_trackable_container_get_system_update_id (RygelTrackableContainer* self) {
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	return RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE (self)->get_system_update_id (self);
#line 1147 "rygel-trackable-container.c"
}


static void rygel_trackable_container_thaw_events (RygelTrackableContainer* self) {
}


static void rygel_trackable_container_base_init (RygelTrackableContainerIface * iface) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	static gboolean initialized = FALSE;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
	if (!initialized) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		initialized = TRUE;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		g_signal_new ("child_added", RYGEL_TYPE_TRACKABLE_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, RYGEL_TYPE_MEDIA_OBJECT);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		g_signal_new ("child_removed", RYGEL_TYPE_TRACKABLE_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, RYGEL_TYPE_MEDIA_OBJECT);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		iface->get_service_reset_token = rygel_trackable_container_real_get_service_reset_token;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		iface->set_service_reset_token = rygel_trackable_container_real_set_service_reset_token;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-trackable-container.vala"
		iface->get_system_update_id = rygel_trackable_container_real_get_system_update_id;
#line 1172 "rygel-trackable-container.c"
	}
}


/**
 * The base class for containers that provide automatic change tracking.
 *
 * Derived classes should implement the add_child() and remove_child()
 * virtual functions to keep track of child items and child containers.
 *
 * Rygel server plugins (See #RygelMediaServer) may then call
 * rygel_trackable_container_add_child_tracked() and
 * rygel_trackable_container_remove_child_tracked() to add and remove
 * items, which will then cause the #RygelContainer::container_updated signal
 * to be emitted.
 */
GType rygel_trackable_container_get_type (void) {
	static volatile gsize rygel_trackable_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_trackable_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackableContainerIface), (GBaseInitFunc) rygel_trackable_container_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_trackable_container_type_id;
		rygel_trackable_container_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelTrackableContainer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_trackable_container_type_id, RYGEL_TYPE_MEDIA_CONTAINER);
		g_once_init_leave (&rygel_trackable_container_type_id__volatile, rygel_trackable_container_type_id);
	}
	return rygel_trackable_container_type_id__volatile;
}



