/* rygel-playspeed.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-playspeed.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL CABLE TELEVISION LABORATORIES
 * INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_PLAY_SPEED (rygel_play_speed_get_type ())
#define RYGEL_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeed))
#define RYGEL_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))
#define RYGEL_IS_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_IS_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_PLAY_SPEED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))

typedef struct _RygelPlaySpeed RygelPlaySpeed;
typedef struct _RygelPlaySpeedClass RygelPlaySpeedClass;
typedef struct _RygelPlaySpeedPrivate RygelPlaySpeedPrivate;
#define _rygel_play_speed_unref0(var) ((var == NULL) ? NULL : (var = (rygel_play_speed_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelParamSpecPlaySpeed RygelParamSpecPlaySpeed;

struct _RygelPlaySpeed {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelPlaySpeedPrivate * priv;
	gint numerator;
	guint denominator;
};

struct _RygelPlaySpeedClass {
	GTypeClass parent_class;
	void (*finalize) (RygelPlaySpeed *self);
};

typedef enum  {
	RYGEL_PLAY_SPEED_ERROR_INVALID_SPEED_FORMAT,
	RYGEL_PLAY_SPEED_ERROR_SPEED_NOT_PRESENT
} RygelPlaySpeedError;
#define RYGEL_PLAY_SPEED_ERROR rygel_play_speed_error_quark ()
struct _RygelParamSpecPlaySpeed {
	GParamSpec parent_instance;
};


static gpointer rygel_play_speed_parent_class = NULL;

gpointer rygel_play_speed_ref (gpointer instance);
void rygel_play_speed_unref (gpointer instance);
GParamSpec* rygel_param_spec_play_speed (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_play_speed (GValue* value, gpointer v_object);
void rygel_value_take_play_speed (GValue* value, gpointer v_object);
gpointer rygel_value_get_play_speed (const GValue* value);
GType rygel_play_speed_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_PLAY_SPEED_DUMMY_PROPERTY
};
RygelPlaySpeed* rygel_play_speed_new (gint numerator, guint denominator);
RygelPlaySpeed* rygel_play_speed_construct (GType object_type, gint numerator, guint denominator);
GQuark rygel_play_speed_error_quark (void);
RygelPlaySpeed* rygel_play_speed_new_from_string (const gchar* speed, GError** error);
RygelPlaySpeed* rygel_play_speed_construct_from_string (GType object_type, const gchar* speed, GError** error);
static void rygel_play_speed_parse (RygelPlaySpeed* self, const gchar* speed, GError** error);
gboolean rygel_play_speed_equals (RygelPlaySpeed* self, RygelPlaySpeed* that);
gboolean rygel_play_speed_is_positive (RygelPlaySpeed* self);
gboolean rygel_play_speed_is_normal_rate (RygelPlaySpeed* self);
gchar* rygel_play_speed_to_string (RygelPlaySpeed* self);
gfloat rygel_play_speed_to_float (RygelPlaySpeed* self);
gdouble rygel_play_speed_to_double (RygelPlaySpeed* self);
static void rygel_play_speed_finalize (RygelPlaySpeed* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


RygelPlaySpeed* rygel_play_speed_construct (GType object_type, gint numerator, guint denominator) {
	RygelPlaySpeed* self = NULL;
	gint _tmp0_ = 0;
	guint _tmp1_ = 0U;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	self = (RygelPlaySpeed*) g_type_create_instance (object_type);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	_tmp0_ = numerator;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	self->numerator = _tmp0_;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	_tmp1_ = denominator;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	self->denominator = _tmp1_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	return self;
#line 126 "rygel-playspeed.c"
}


RygelPlaySpeed* rygel_play_speed_new (gint numerator, guint denominator) {
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	return rygel_play_speed_construct (RYGEL_TYPE_PLAY_SPEED, numerator, denominator);
#line 133 "rygel-playspeed.c"
}


RygelPlaySpeed* rygel_play_speed_construct_from_string (GType object_type, const gchar* speed, GError** error) {
	RygelPlaySpeed* self = NULL;
	const gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	g_return_val_if_fail (speed != NULL, NULL);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	self = (RygelPlaySpeed*) g_type_create_instance (object_type);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	_tmp0_ = speed;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	rygel_play_speed_parse (self, _tmp0_, &_inner_error_);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		if (_inner_error_->domain == RYGEL_PLAY_SPEED_ERROR) {
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
			g_propagate_error (error, _inner_error_);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
			_rygel_play_speed_unref0 (self);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
			return NULL;
#line 159 "rygel-playspeed.c"
		} else {
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
			g_clear_error (&_inner_error_);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
			return NULL;
#line 167 "rygel-playspeed.c"
		}
	}
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	return self;
#line 172 "rygel-playspeed.c"
}


RygelPlaySpeed* rygel_play_speed_new_from_string (const gchar* speed, GError** error) {
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	return rygel_play_speed_construct_from_string (RYGEL_TYPE_PLAY_SPEED, speed, error);
#line 179 "rygel-playspeed.c"
}


gboolean rygel_play_speed_equals (RygelPlaySpeed* self, RygelPlaySpeed* that) {
	gboolean result = FALSE;
	RygelPlaySpeed* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	RygelPlaySpeed* _tmp3_ = NULL;
	gint _tmp4_ = 0;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	g_return_val_if_fail (that != NULL, FALSE);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	_tmp0_ = that;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	if (_tmp0_ == NULL) {
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		result = FALSE;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		return result;
#line 202 "rygel-playspeed.c"
	}
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	_tmp2_ = self->numerator;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	_tmp3_ = that;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	_tmp4_ = _tmp3_->numerator;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	if (_tmp2_ == _tmp4_) {
#line 212 "rygel-playspeed.c"
		guint _tmp5_ = 0U;
		RygelPlaySpeed* _tmp6_ = NULL;
		guint _tmp7_ = 0U;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp5_ = self->denominator;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp6_ = that;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp7_ = _tmp6_->denominator;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp1_ = _tmp5_ == _tmp7_;
#line 224 "rygel-playspeed.c"
	} else {
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp1_ = FALSE;
#line 228 "rygel-playspeed.c"
	}
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	result = _tmp1_;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	return result;
#line 234 "rygel-playspeed.c"
}


gboolean rygel_play_speed_is_positive (RygelPlaySpeed* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	_tmp0_ = self->numerator;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	result = _tmp0_ > 0;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	return result;
#line 249 "rygel-playspeed.c"
}


gboolean rygel_play_speed_is_normal_rate (RygelPlaySpeed* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	_tmp1_ = self->numerator;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	if (_tmp1_ == 1) {
#line 263 "rygel-playspeed.c"
		guint _tmp2_ = 0U;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp2_ = self->denominator;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp0_ = _tmp2_ == ((guint) 1);
#line 269 "rygel-playspeed.c"
	} else {
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp0_ = FALSE;
#line 273 "rygel-playspeed.c"
	}
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	result = _tmp0_;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	return result;
#line 279 "rygel-playspeed.c"
}


gchar* rygel_play_speed_to_string (RygelPlaySpeed* self) {
	gchar* result = NULL;
	guint _tmp0_ = 0U;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	_tmp0_ = self->denominator;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	if (_tmp0_ == ((guint) 1)) {
#line 292 "rygel-playspeed.c"
		gint _tmp1_ = 0;
		gchar* _tmp2_ = NULL;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp1_ = self->numerator;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp2_ = g_strdup_printf ("%i", _tmp1_);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		result = _tmp2_;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		return result;
#line 303 "rygel-playspeed.c"
	} else {
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp3_ = self->numerator;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp4_ = g_strdup_printf ("%i", _tmp3_);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp5_ = _tmp4_;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp6_ = g_strconcat (_tmp5_, "/", NULL);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp7_ = _tmp6_;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp8_ = self->denominator;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp9_ = g_strdup_printf ("%u", _tmp8_);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp10_ = _tmp9_;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp11_ = g_strconcat (_tmp7_, _tmp10_, NULL);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp12_ = _tmp11_;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_g_free0 (_tmp10_);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_g_free0 (_tmp7_);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_g_free0 (_tmp5_);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		result = _tmp12_;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		return result;
#line 345 "rygel-playspeed.c"
	}
}


gfloat rygel_play_speed_to_float (RygelPlaySpeed* self) {
	gfloat result = 0.0F;
	gint _tmp0_ = 0;
	guint _tmp1_ = 0U;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	g_return_val_if_fail (self != NULL, 0.0F);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	_tmp0_ = self->numerator;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	_tmp1_ = self->denominator;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	result = ((gfloat) _tmp0_) / _tmp1_;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	return result;
#line 364 "rygel-playspeed.c"
}


gdouble rygel_play_speed_to_double (RygelPlaySpeed* self) {
	gdouble result = 0.0;
	gint _tmp0_ = 0;
	guint _tmp1_ = 0U;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	_tmp0_ = self->numerator;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	_tmp1_ = self->denominator;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	result = ((gdouble) _tmp0_) / _tmp1_;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	return result;
#line 382 "rygel-playspeed.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1278 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1278 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 402 "rygel-playspeed.c"
}


static void rygel_play_speed_parse (RygelPlaySpeed* self, const gchar* speed, GError** error) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gint _tmp15_ = 0;
	guint _tmp21_ = 0U;
	GError * _inner_error_ = NULL;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	g_return_if_fail (self != NULL);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	g_return_if_fail (speed != NULL);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	_tmp0_ = speed;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	_tmp1_ = string_contains (_tmp0_, "/");
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	if (!_tmp1_) {
#line 422 "rygel-playspeed.c"
		const gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp2_ = speed;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp3_ = atoi (_tmp2_);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		self->numerator = _tmp3_;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		self->denominator = (guint) 1;
#line 433 "rygel-playspeed.c"
	} else {
		gchar** elements = NULL;
		const gchar* _tmp4_ = NULL;
		gchar** _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		gint elements_length1 = 0;
		gint _elements_size_ = 0;
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		const gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gchar** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		const gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp4_ = speed;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, "/", 0);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		elements = _tmp6_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		elements_length1 = _vala_array_length (_tmp5_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_elements_size_ = elements_length1;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp7_ = elements;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp7__length1 = elements_length1;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		if (_tmp7__length1 != 2) {
#line 467 "rygel-playspeed.c"
			GError* _tmp8_ = NULL;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
			_tmp8_ = g_error_new_literal (RYGEL_PLAY_SPEED_ERROR, RYGEL_PLAY_SPEED_ERROR_INVALID_SPEED_FORMAT, "Missing/extra numerator/denominator");
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
			_inner_error_ = _tmp8_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
			if (_inner_error_->domain == RYGEL_PLAY_SPEED_ERROR) {
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
				g_propagate_error (error, _inner_error_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
				elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
				return;
#line 481 "rygel-playspeed.c"
			} else {
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
				elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
				g_clear_error (&_inner_error_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
				return;
#line 491 "rygel-playspeed.c"
			}
		}
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp9_ = elements;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp9__length1 = elements_length1;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp10_ = _tmp9_[0];
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp11_ = atoi (_tmp10_);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		self->numerator = _tmp11_;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp12_ = elements;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp12__length1 = elements_length1;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp13_ = _tmp12_[1];
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp14_ = atoi (_tmp13_);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		self->denominator = (guint) _tmp14_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
#line 516 "rygel-playspeed.c"
	}
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	_tmp15_ = self->numerator;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	if (_tmp15_ == 0) {
#line 522 "rygel-playspeed.c"
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		GError* _tmp19_ = NULL;
		GError* _tmp20_ = NULL;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp16_ = speed;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp17_ = g_strconcat ("Invalid numerator in speed: ", _tmp16_, NULL);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp18_ = _tmp17_;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp19_ = g_error_new_literal (RYGEL_PLAY_SPEED_ERROR, RYGEL_PLAY_SPEED_ERROR_INVALID_SPEED_FORMAT, _tmp18_);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp20_ = _tmp19_;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_g_free0 (_tmp18_);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_inner_error_ = _tmp20_;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		if (_inner_error_->domain == RYGEL_PLAY_SPEED_ERROR) {
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
			g_propagate_error (error, _inner_error_);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
			return;
#line 548 "rygel-playspeed.c"
		} else {
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
			g_clear_error (&_inner_error_);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
			return;
#line 556 "rygel-playspeed.c"
		}
	}
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	_tmp21_ = self->denominator;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	if (_tmp21_ <= ((guint) 0)) {
#line 563 "rygel-playspeed.c"
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		GError* _tmp25_ = NULL;
		GError* _tmp26_ = NULL;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp22_ = speed;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp23_ = g_strconcat ("Invalid denominator in speed: ", _tmp22_, NULL);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp24_ = _tmp23_;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp25_ = g_error_new_literal (RYGEL_PLAY_SPEED_ERROR, RYGEL_PLAY_SPEED_ERROR_INVALID_SPEED_FORMAT, _tmp24_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_tmp26_ = _tmp25_;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_g_free0 (_tmp24_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		_inner_error_ = _tmp26_;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		if (_inner_error_->domain == RYGEL_PLAY_SPEED_ERROR) {
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
			g_propagate_error (error, _inner_error_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
			return;
#line 589 "rygel-playspeed.c"
		} else {
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
			g_clear_error (&_inner_error_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
			return;
#line 597 "rygel-playspeed.c"
		}
	}
}


static void rygel_value_play_speed_init (GValue* value) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	value->data[0].v_pointer = NULL;
#line 606 "rygel-playspeed.c"
}


static void rygel_value_play_speed_free_value (GValue* value) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	if (value->data[0].v_pointer) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		rygel_play_speed_unref (value->data[0].v_pointer);
#line 615 "rygel-playspeed.c"
	}
}


static void rygel_value_play_speed_copy_value (const GValue* src_value, GValue* dest_value) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	if (src_value->data[0].v_pointer) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		dest_value->data[0].v_pointer = rygel_play_speed_ref (src_value->data[0].v_pointer);
#line 625 "rygel-playspeed.c"
	} else {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		dest_value->data[0].v_pointer = NULL;
#line 629 "rygel-playspeed.c"
	}
}


static gpointer rygel_value_play_speed_peek_pointer (const GValue* value) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	return value->data[0].v_pointer;
#line 637 "rygel-playspeed.c"
}


static gchar* rygel_value_play_speed_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	if (collect_values[0].v_pointer) {
#line 644 "rygel-playspeed.c"
		RygelPlaySpeed* object;
		object = collect_values[0].v_pointer;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		if (object->parent_instance.g_class == NULL) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 651 "rygel-playspeed.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 655 "rygel-playspeed.c"
		}
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		value->data[0].v_pointer = rygel_play_speed_ref (object);
#line 659 "rygel-playspeed.c"
	} else {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		value->data[0].v_pointer = NULL;
#line 663 "rygel-playspeed.c"
	}
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	return NULL;
#line 667 "rygel-playspeed.c"
}


static gchar* rygel_value_play_speed_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelPlaySpeed** object_p;
	object_p = collect_values[0].v_pointer;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	if (!object_p) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 678 "rygel-playspeed.c"
	}
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	if (!value->data[0].v_pointer) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		*object_p = NULL;
#line 684 "rygel-playspeed.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		*object_p = value->data[0].v_pointer;
#line 688 "rygel-playspeed.c"
	} else {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		*object_p = rygel_play_speed_ref (value->data[0].v_pointer);
#line 692 "rygel-playspeed.c"
	}
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	return NULL;
#line 696 "rygel-playspeed.c"
}


GParamSpec* rygel_param_spec_play_speed (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecPlaySpeed* spec;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_PLAY_SPEED), NULL);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	return G_PARAM_SPEC (spec);
#line 710 "rygel-playspeed.c"
}


gpointer rygel_value_get_play_speed (const GValue* value) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_PLAY_SPEED), NULL);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	return value->data[0].v_pointer;
#line 719 "rygel-playspeed.c"
}


void rygel_value_set_play_speed (GValue* value, gpointer v_object) {
	RygelPlaySpeed* old;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_PLAY_SPEED));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	old = value->data[0].v_pointer;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	if (v_object) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_PLAY_SPEED));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		value->data[0].v_pointer = v_object;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		rygel_play_speed_ref (value->data[0].v_pointer);
#line 739 "rygel-playspeed.c"
	} else {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		value->data[0].v_pointer = NULL;
#line 743 "rygel-playspeed.c"
	}
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	if (old) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		rygel_play_speed_unref (old);
#line 749 "rygel-playspeed.c"
	}
}


void rygel_value_take_play_speed (GValue* value, gpointer v_object) {
	RygelPlaySpeed* old;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_PLAY_SPEED));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	old = value->data[0].v_pointer;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	if (v_object) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_PLAY_SPEED));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		value->data[0].v_pointer = v_object;
#line 768 "rygel-playspeed.c"
	} else {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		value->data[0].v_pointer = NULL;
#line 772 "rygel-playspeed.c"
	}
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	if (old) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		rygel_play_speed_unref (old);
#line 778 "rygel-playspeed.c"
	}
}


static void rygel_play_speed_class_init (RygelPlaySpeedClass * klass) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	rygel_play_speed_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	((RygelPlaySpeedClass *) klass)->finalize = rygel_play_speed_finalize;
#line 788 "rygel-playspeed.c"
}


static void rygel_play_speed_instance_init (RygelPlaySpeed * self) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	self->ref_count = 1;
#line 795 "rygel-playspeed.c"
}


static void rygel_play_speed_finalize (RygelPlaySpeed* obj) {
	RygelPlaySpeed * self;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeed);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	g_signal_handlers_destroy (self);
#line 805 "rygel-playspeed.c"
}


/**
 * This is a container for a PlaySpeed value.
 *
 * A Playspeed can be positive or negative whole numbers or fractions.
 * e.g. "2". "1/2", "-1/4"
 */
GType rygel_play_speed_get_type (void) {
	static volatile gsize rygel_play_speed_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_play_speed_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_play_speed_init, rygel_value_play_speed_free_value, rygel_value_play_speed_copy_value, rygel_value_play_speed_peek_pointer, "p", rygel_value_play_speed_collect_value, "p", rygel_value_play_speed_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlaySpeedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_play_speed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaySpeed), 0, (GInstanceInitFunc) rygel_play_speed_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_play_speed_type_id;
		rygel_play_speed_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelPlaySpeed", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_play_speed_type_id__volatile, rygel_play_speed_type_id);
	}
	return rygel_play_speed_type_id__volatile;
}


gpointer rygel_play_speed_ref (gpointer instance) {
	RygelPlaySpeed* self;
	self = instance;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	g_atomic_int_inc (&self->ref_count);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	return instance;
#line 836 "rygel-playspeed.c"
}


void rygel_play_speed_unref (gpointer instance) {
	RygelPlaySpeed* self;
	self = instance;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		RYGEL_PLAY_SPEED_GET_CLASS (self)->finalize (self);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 849 "rygel-playspeed.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



