/* rygel-media-server-plugin.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-media-server-plugin.vala, do not modify */

/*
 * Copyright (C) 2008,2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <libgupnp/gupnp.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_MEDIA_SERVER_PLUGIN (rygel_media_server_plugin_get_type ())
#define RYGEL_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin))
#define RYGEL_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_MEDIA_SERVER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))

typedef struct _RygelMediaServerPlugin RygelMediaServerPlugin;
typedef struct _RygelMediaServerPluginClass RygelMediaServerPluginClass;
typedef struct _RygelMediaServerPluginPrivate RygelMediaServerPluginPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__rygel_dlna_profile_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__rygel_dlna_profile_unref0_ (var), NULL)))

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;

#define RYGEL_TYPE_SOURCE_CONNECTION_MANAGER (rygel_source_connection_manager_get_type ())
#define RYGEL_SOURCE_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER, RygelSourceConnectionManager))
#define RYGEL_SOURCE_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER, RygelSourceConnectionManagerClass))
#define RYGEL_IS_SOURCE_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER))
#define RYGEL_IS_SOURCE_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER))
#define RYGEL_SOURCE_CONNECTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER, RygelSourceConnectionManagerClass))

typedef struct _RygelSourceConnectionManager RygelSourceConnectionManager;
typedef struct _RygelSourceConnectionManagerClass RygelSourceConnectionManagerClass;
#define _rygel_resource_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_resource_info_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR (rygel_media_receiver_registrar_get_type ())
#define RYGEL_MEDIA_RECEIVER_REGISTRAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR, RygelMediaReceiverRegistrar))
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR, RygelMediaReceiverRegistrarClass))
#define RYGEL_IS_MEDIA_RECEIVER_REGISTRAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR))
#define RYGEL_IS_MEDIA_RECEIVER_REGISTRAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR))
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR, RygelMediaReceiverRegistrarClass))

typedef struct _RygelMediaReceiverRegistrar RygelMediaReceiverRegistrar;
typedef struct _RygelMediaReceiverRegistrarClass RygelMediaReceiverRegistrarClass;

#define RYGEL_TYPE_OBJECT_EVENT_TYPE (rygel_object_event_type_get_type ())

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;
#define _rygel_dlna_profile_unref0(var) ((var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_ENGINE (rygel_media_engine_get_type ())
#define RYGEL_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngine))
#define RYGEL_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))
#define RYGEL_IS_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_IS_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_MEDIA_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))

typedef struct _RygelMediaEngine RygelMediaEngine;
typedef struct _RygelMediaEngineClass RygelMediaEngineClass;

struct _RygelMediaServerPlugin {
	RygelPlugin parent_instance;
	RygelMediaServerPluginPrivate * priv;
};

struct _RygelMediaServerPluginClass {
	RygelPluginClass parent_class;
	const gchar* (*get_search_caps) (RygelMediaServerPlugin* self);
};

struct _RygelMediaServerPluginPrivate {
	RygelMediaContainer* _root_container;
	gchar* _search_caps;
	GList* _upload_profiles;
	GList* _supported_profiles;
};

typedef enum  {
	RYGEL_OBJECT_EVENT_TYPE_ADDED = 0,
	RYGEL_OBJECT_EVENT_TYPE_MODIFIED = 1,
	RYGEL_OBJECT_EVENT_TYPE_DELETED = 2
} RygelObjectEventType;

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()

static gpointer rygel_media_server_plugin_parent_class = NULL;

GType rygel_media_server_plugin_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_SERVER_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginPrivate))
enum  {
	RYGEL_MEDIA_SERVER_PLUGIN_DUMMY_PROPERTY,
	RYGEL_MEDIA_SERVER_PLUGIN_ROOT_CONTAINER,
	RYGEL_MEDIA_SERVER_PLUGIN_SEARCH_CAPS,
	RYGEL_MEDIA_SERVER_PLUGIN_UPLOAD_PROFILES,
	RYGEL_MEDIA_SERVER_PLUGIN_SUPPORTED_PROFILES
};
static void _rygel_dlna_profile_unref0_ (gpointer var);
static void _g_list_free__rygel_dlna_profile_unref0_ (GList* self);
#define RYGEL_MEDIA_SERVER_PLUGIN_DMS "urn:schemas-upnp-org:device:MediaServer"
#define RYGEL_MEDIA_SERVER_PLUGIN_MEDIA_SERVER_DESC_PATH DATA_DIR "/xml/MediaServer3.xml"
RygelMediaServerPlugin* rygel_media_server_plugin_construct (GType object_type, RygelMediaContainer* root_container, const gchar* name, const gchar* description, RygelPluginCapabilities capabilities);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
static void rygel_media_server_plugin_real_constructed (GObject* base);
#define RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH_NO_TRACK "xml/ContentDirectory-NoTrack.xml"
#define RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH "xml/ContentDirectory.xml"
#define RYGEL_CONTENT_DIRECTORY_UPNP_ID "urn:upnp-org:serviceId:ContentDirectory"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE "urn:schemas-upnp-org:service:ContentDirectory:3"
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
GType rygel_source_connection_manager_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_ID "urn:microsoft-com:serviceId:X_MS_MediaReceiverRegistrar"
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_TYPE "urn:microsoft-com:service:X_MS_MediaReceiverRegistrar:1"
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_DESCRIPTION_PATH "xml/X_MS_MediaReceiverRegistrar1.xml"
GType rygel_media_receiver_registrar_get_type (void) G_GNUC_CONST;
RygelMediaContainer* rygel_media_server_plugin_get_root_container (RygelMediaServerPlugin* self);
gint rygel_media_container_get_child_count (RygelMediaContainer* self);
GType rygel_object_event_type_get_type (void) G_GNUC_CONST;
static void rygel_media_server_plugin_on_container_updated (RygelMediaServerPlugin* self, RygelMediaContainer* root_container, RygelMediaContainer* updated, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static void _rygel_media_server_plugin_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self);
static void rygel_media_server_plugin_real_apply_hacks (RygelPlugin* base, RygelRootDevice* device, const gchar* description_path, GError** error);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_xbox_hacks_get_type (void) G_GNUC_CONST;
GQuark rygel_client_hacks_error_quark (void);
RygelXBoxHacks* rygel_xbox_hacks_new (SoupMessage* message, GError** error);
RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type, SoupMessage* message, GError** error);
void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self, RygelRootDevice* device, const gchar* template_path, GError** error);
static void rygel_media_server_plugin_set_root_container (RygelMediaServerPlugin* self, RygelMediaContainer* value);
const gchar* rygel_media_server_plugin_get_search_caps (RygelMediaServerPlugin* self);
#define RYGEL_RELATIONAL_EXPRESSION_CAPS "@id,@parentID,@refID,upnp:class," "dc:title,upnp:artist,upnp:album," "dc:creator,upnp:createClass,@childCount"
GList* rygel_media_server_plugin_get_upload_profiles (RygelMediaServerPlugin* self);
GList* rygel_media_server_plugin_get_supported_profiles (RygelMediaServerPlugin* self);
void rygel_media_server_plugin_set_upload_profiles (RygelMediaServerPlugin* self, GList* value);
GType rygel_media_engine_get_type (void) G_GNUC_CONST;
RygelMediaEngine* rygel_media_engine_get_default (void);
GList* rygel_media_engine_get_dlna_profiles (RygelMediaEngine* self);
void rygel_media_server_plugin_set_supported_profiles (RygelMediaServerPlugin* self, GList* value);
static void rygel_media_server_plugin_finalize (GObject* obj);
static void _vala_rygel_media_server_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_server_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _rygel_dlna_profile_unref0_ (gpointer var) {
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	(var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL));
#line 227 "rygel-media-server-plugin.c"
}


static void _g_list_free__rygel_dlna_profile_unref0_ (GList* self) {
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_list_foreach (self, (GFunc) _rygel_dlna_profile_unref0_, NULL);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_list_free (self);
#line 236 "rygel-media-server-plugin.c"
}


/**
     * Create an instance of the plugin.
     * The plugin's service will have the same title as its root container.
     *
     * @param root_container The container that should be served by this plugin's service.
     * @param name The non-human-readable name for the plugin and its service, used in UPnP messages and in the Rygel configuration file.
     * @param description An optional human-readable description (modelDescription) of the UPnP service provided by the plugin.
     */
RygelMediaServerPlugin* rygel_media_server_plugin_construct (GType object_type, RygelMediaContainer* root_container, const gchar* name, const gchar* description, RygelPluginCapabilities capabilities) {
	RygelMediaServerPlugin * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	RygelPluginCapabilities _tmp5_ = 0;
	RygelMediaContainer* _tmp6_ = NULL;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_val_if_fail (root_container != NULL, NULL);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp0_ = name;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp1_ = root_container;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp2_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp1_);
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp3_ = _tmp2_;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp4_ = description;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp5_ = capabilities;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp6_ = root_container;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	self = (RygelMediaServerPlugin*) g_object_new (object_type, "desc-path", RYGEL_MEDIA_SERVER_PLUGIN_MEDIA_SERVER_DESC_PATH, "name", _tmp0_, "title", _tmp3_, "description", _tmp4_, "capabilities", _tmp5_, "root-container", _tmp6_, NULL);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	return self;
#line 279 "rygel-media-server-plugin.c"
}


static void _rygel_media_server_plugin_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self) {
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_media_server_plugin_on_container_updated ((RygelMediaServerPlugin*) self, _sender, container, object, event_type, sub_tree_update);
#line 286 "rygel-media-server-plugin.c"
}


static void rygel_media_server_plugin_real_constructed (GObject* base) {
	RygelMediaServerPlugin * self;
	gchar* path = NULL;
	gchar* _tmp0_ = NULL;
	RygelPluginCapabilities _tmp1_ = 0;
	RygelPluginCapabilities _tmp2_ = 0;
	RygelResourceInfo* info = NULL;
	const gchar* _tmp4_ = NULL;
	RygelResourceInfo* _tmp5_ = NULL;
	RygelResourceInfo* _tmp6_ = NULL;
	RygelResourceInfo* _tmp7_ = NULL;
	RygelResourceInfo* _tmp8_ = NULL;
	RygelResourceInfo* _tmp9_ = NULL;
	RygelResourceInfo* _tmp10_ = NULL;
	RygelMediaContainer* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	self = (RygelMediaServerPlugin*) base;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	G_OBJECT_CLASS (rygel_media_server_plugin_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_PLUGIN, RygelPlugin));
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp0_ = g_strdup (RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH_NO_TRACK);
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	path = _tmp0_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp1_ = rygel_plugin_get_capabilities ((RygelPlugin*) self);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp2_ = _tmp1_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if ((_tmp2_ & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) {
#line 321 "rygel-media-server-plugin.c"
		gchar* _tmp3_ = NULL;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp3_ = g_strdup (RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_g_free0 (path);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		path = _tmp3_;
#line 329 "rygel-media-server-plugin.c"
	}
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp4_ = path;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp5_ = rygel_resource_info_new (RYGEL_CONTENT_DIRECTORY_UPNP_ID, RYGEL_CONTENT_DIRECTORY_UPNP_TYPE, _tmp4_, RYGEL_TYPE_CONTENT_DIRECTORY);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	info = _tmp5_;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp6_ = info;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp6_);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp7_ = rygel_resource_info_new (RYGEL_CONNECTION_MANAGER_UPNP_ID, RYGEL_CONNECTION_MANAGER_UPNP_TYPE, RYGEL_CONNECTION_MANAGER_DESCRIPTION_PATH, RYGEL_TYPE_SOURCE_CONNECTION_MANAGER);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_rygel_resource_info_unref0 (info);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	info = _tmp7_;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp8_ = info;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp8_);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp9_ = rygel_resource_info_new (RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_ID, RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_TYPE, RYGEL_MEDIA_RECEIVER_REGISTRAR_DESCRIPTION_PATH, RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_rygel_resource_info_unref0 (info);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	info = _tmp9_;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp10_ = info;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp10_);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp11_ = self->priv->_root_container;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp12_ = rygel_media_container_get_child_count (_tmp11_);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp13_ = _tmp12_;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (_tmp13_ == 0) {
#line 369 "rygel-media-server-plugin.c"
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		RygelMediaContainer* _tmp16_ = NULL;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp14_ = rygel_plugin_get_name ((RygelPlugin*) self);
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp15_ = _tmp14_;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_debug ("rygel-media-server-plugin.vala:172: Deactivating plugin '%s' until it " \
"provides content.", _tmp15_);
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		rygel_plugin_set_active ((RygelPlugin*) self, FALSE);
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp16_ = self->priv->_root_container;
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_signal_connect_object (_tmp16_, "container-updated", (GCallback) _rygel_media_server_plugin_on_container_updated_rygel_media_container_container_updated, self, 0);
#line 385 "rygel-media-server-plugin.c"
	}
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_rygel_resource_info_unref0 (info);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_g_free0 (path);
#line 391 "rygel-media-server-plugin.c"
}


static void rygel_media_server_plugin_real_apply_hacks (RygelPlugin* base, RygelRootDevice* device, const gchar* description_path, GError** error) {
	RygelMediaServerPlugin * self;
	gchar** services = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint services_length1 = 0;
	gint _services_size_ = 0;
	RygelV1Hacks* v1_hacks = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	RygelV1Hacks* _tmp4_ = NULL;
	RygelV1Hacks* _tmp5_ = NULL;
	RygelRootDevice* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	RygelXBoxHacks* xbox_hacks = NULL;
	RygelXBoxHacks* _tmp8_ = NULL;
	RygelXBoxHacks* _tmp9_ = NULL;
	RygelRootDevice* _tmp10_ = NULL;
	RygelV1Hacks* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	self = (RygelMediaServerPlugin*) base;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (device != NULL);
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (description_path != NULL);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp0_ = g_strdup (RYGEL_CONTENT_DIRECTORY_UPNP_TYPE);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp1_ = g_strdup (RYGEL_CONNECTION_MANAGER_UPNP_TYPE);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp2_ = g_new0 (gchar*, 2 + 1);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp2_[0] = _tmp0_;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp2_[1] = _tmp1_;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	services = _tmp2_;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	services_length1 = 2;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_services_size_ = services_length1;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp3_ = services;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp3__length1 = services_length1;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp4_ = rygel_v1_hacks_new (RYGEL_MEDIA_SERVER_PLUGIN_DMS, _tmp3_, _tmp3__length1);
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	v1_hacks = _tmp4_;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp5_ = v1_hacks;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp6_ = device;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp7_ = description_path;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_v1_hacks_apply_on_device (_tmp5_, _tmp6_, _tmp7_, &_inner_error_);
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_propagate_error (error, _inner_error_);
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_g_object_unref0 (v1_hacks);
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		return;
#line 465 "rygel-media-server-plugin.c"
	}
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp8_ = rygel_xbox_hacks_new (NULL, &_inner_error_);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	xbox_hacks = _tmp8_;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_propagate_error (error, _inner_error_);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_g_object_unref0 (v1_hacks);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		return;
#line 481 "rygel-media-server-plugin.c"
	}
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp9_ = xbox_hacks;
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp10_ = device;
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp11_ = v1_hacks;
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp12_ = _tmp11_->description_path;
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_xbox_hacks_apply_on_device (_tmp9_, _tmp10_, _tmp12_, &_inner_error_);
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_propagate_error (error, _inner_error_);
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_g_object_unref0 (xbox_hacks);
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_g_object_unref0 (v1_hacks);
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		return;
#line 505 "rygel-media-server-plugin.c"
	}
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_g_object_unref0 (xbox_hacks);
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_g_object_unref0 (v1_hacks);
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
#line 513 "rygel-media-server-plugin.c"
}


static void rygel_media_server_plugin_on_container_updated (RygelMediaServerPlugin* self, RygelMediaContainer* root_container, RygelMediaContainer* updated, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	gboolean _tmp0_ = FALSE;
	RygelMediaContainer* _tmp1_ = NULL;
	RygelMediaContainer* _tmp2_ = NULL;
	RygelMediaContainer* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (self != NULL);
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (root_container != NULL);
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (updated != NULL);
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (object != NULL);
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp1_ = updated;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp2_ = root_container;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (_tmp1_ != _tmp2_) {
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp0_ = TRUE;
#line 541 "rygel-media-server-plugin.c"
	} else {
		RygelMediaContainer* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp3_ = updated;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp4_ = rygel_media_container_get_child_count (_tmp3_);
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp5_ = _tmp4_;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp0_ = _tmp5_ == 0;
#line 554 "rygel-media-server-plugin.c"
	}
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (_tmp0_) {
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		return;
#line 560 "rygel-media-server-plugin.c"
	}
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp6_ = root_container;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_signal_parse_name ("container-updated", RYGEL_TYPE_MEDIA_CONTAINER, &_tmp7_, NULL, FALSE);
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _rygel_media_server_plugin_on_container_updated_rygel_media_container_container_updated, self);
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp8_ = rygel_plugin_get_name ((RygelPlugin*) self);
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp9_ = _tmp8_;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_debug ("rygel-media-server-plugin.vala:209: Activating plugin '%s' since it no" \
"w provides content.", _tmp9_);
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_plugin_set_active ((RygelPlugin*) self, TRUE);
#line 576 "rygel-media-server-plugin.c"
}


RygelMediaContainer* rygel_media_server_plugin_get_root_container (RygelMediaServerPlugin* self) {
	RygelMediaContainer* result;
	RygelMediaContainer* _tmp0_ = NULL;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp0_ = self->priv->_root_container;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	result = _tmp0_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	return result;
#line 591 "rygel-media-server-plugin.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 598 "rygel-media-server-plugin.c"
}


static void rygel_media_server_plugin_set_root_container (RygelMediaServerPlugin* self, RygelMediaContainer* value) {
	RygelMediaContainer* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (self != NULL);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp0_ = value;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_g_object_unref0 (self->priv->_root_container);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	self->priv->_root_container = _tmp1_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_object_notify ((GObject *) self, "root-container");
#line 617 "rygel-media-server-plugin.c"
}


const gchar* rygel_media_server_plugin_get_search_caps (RygelMediaServerPlugin* self) {
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	return RYGEL_MEDIA_SERVER_PLUGIN_GET_CLASS (self)->get_search_caps (self);
#line 626 "rygel-media-server-plugin.c"
}


static const gchar* rygel_media_server_plugin_real_get_search_caps (RygelMediaServerPlugin* base) {
	const gchar* result;
	RygelMediaServerPlugin* self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp6_ = NULL;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	self = base;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp0_ = self->priv->_search_caps;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (_tmp0_ == NULL) {
#line 641 "rygel-media-server-plugin.c"
		gchar* _tmp1_ = NULL;
		RygelPluginCapabilities _tmp2_ = 0;
		RygelPluginCapabilities _tmp3_ = 0;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp1_ = g_strdup (RYGEL_RELATIONAL_EXPRESSION_CAPS);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_g_free0 (self->priv->_search_caps);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		self->priv->_search_caps = _tmp1_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp2_ = rygel_plugin_get_capabilities ((RygelPlugin*) self);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp3_ = _tmp2_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		if ((_tmp3_ & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) {
#line 657 "rygel-media-server-plugin.c"
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
			_tmp4_ = self->priv->_search_caps;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
			_tmp5_ = g_strconcat (_tmp4_, ",upnp:objectUpdateID,upnp:containerUpdateID", NULL);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
			_g_free0 (self->priv->_search_caps);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
			self->priv->_search_caps = _tmp5_;
#line 668 "rygel-media-server-plugin.c"
		}
	}
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp6_ = self->priv->_search_caps;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	result = _tmp6_;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	return result;
#line 677 "rygel-media-server-plugin.c"
}


GList* rygel_media_server_plugin_get_upload_profiles (RygelMediaServerPlugin* self) {
	GList* result;
	GList* _tmp0_ = NULL;
	GList* _tmp3_ = NULL;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp0_ = self->priv->_upload_profiles;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (_tmp0_ == NULL) {
#line 691 "rygel-media-server-plugin.c"
		GList* _tmp1_ = NULL;
		GList* _tmp2_ = NULL;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp1_ = rygel_media_server_plugin_get_supported_profiles (self);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp2_ = _tmp1_;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		result = _tmp2_;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		return result;
#line 702 "rygel-media-server-plugin.c"
	}
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp3_ = self->priv->_upload_profiles;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	result = _tmp3_;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	return result;
#line 710 "rygel-media-server-plugin.c"
}


static gpointer _rygel_dlna_profile_ref0 (gpointer self) {
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	return self ? rygel_dlna_profile_ref (self) : NULL;
#line 717 "rygel-media-server-plugin.c"
}


void rygel_media_server_plugin_set_upload_profiles (RygelMediaServerPlugin* self, GList* value) {
	GList* _tmp0_ = NULL;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (self != NULL);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	__g_list_free__rygel_dlna_profile_unref0_0 (self->priv->_upload_profiles);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	self->priv->_upload_profiles = NULL;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp0_ = value;
#line 731 "rygel-media-server-plugin.c"
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		profile_collection = _tmp0_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
#line 739 "rygel-media-server-plugin.c"
			RygelDLNAProfile* _tmp1_ = NULL;
			RygelDLNAProfile* profile = NULL;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
			_tmp1_ = _rygel_dlna_profile_ref0 ((RygelDLNAProfile*) profile_it->data);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
			profile = _tmp1_;
#line 746 "rygel-media-server-plugin.c"
			{
				RygelDLNAProfile* _tmp2_ = NULL;
				RygelDLNAProfile* _tmp3_ = NULL;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
				_tmp2_ = profile;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
				_tmp3_ = _rygel_dlna_profile_ref0 (_tmp2_);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
				self->priv->_upload_profiles = g_list_append (self->priv->_upload_profiles, _tmp3_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
				_rygel_dlna_profile_unref0 (profile);
#line 758 "rygel-media-server-plugin.c"
			}
		}
	}
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_object_notify ((GObject *) self, "upload-profiles");
#line 764 "rygel-media-server-plugin.c"
}


GList* rygel_media_server_plugin_get_supported_profiles (RygelMediaServerPlugin* self) {
	GList* result;
	GList* _tmp0_ = NULL;
	GList* _tmp5_ = NULL;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp0_ = self->priv->_supported_profiles;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	if (_tmp0_ == NULL) {
#line 778 "rygel-media-server-plugin.c"
		RygelMediaEngine* _tmp1_ = NULL;
		RygelMediaEngine* _tmp2_ = NULL;
		GList* _tmp3_ = NULL;
		GList* _tmp4_ = NULL;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp1_ = rygel_media_engine_get_default ();
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp2_ = _tmp1_;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp3_ = rygel_media_engine_get_dlna_profiles (_tmp2_);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_tmp4_ = _tmp3_;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		_g_object_unref0 (_tmp2_);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		result = _tmp4_;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		return result;
#line 797 "rygel-media-server-plugin.c"
	}
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp5_ = self->priv->_supported_profiles;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	result = _tmp5_;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	return result;
#line 805 "rygel-media-server-plugin.c"
}


void rygel_media_server_plugin_set_supported_profiles (RygelMediaServerPlugin* self, GList* value) {
	GList* _tmp0_ = NULL;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_return_if_fail (self != NULL);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	__g_list_free__rygel_dlna_profile_unref0_0 (self->priv->_supported_profiles);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	self->priv->_supported_profiles = NULL;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_tmp0_ = value;
#line 819 "rygel-media-server-plugin.c"
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		profile_collection = _tmp0_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
#line 827 "rygel-media-server-plugin.c"
			RygelDLNAProfile* _tmp1_ = NULL;
			RygelDLNAProfile* profile = NULL;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
			_tmp1_ = _rygel_dlna_profile_ref0 ((RygelDLNAProfile*) profile_it->data);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
			profile = _tmp1_;
#line 834 "rygel-media-server-plugin.c"
			{
				RygelDLNAProfile* _tmp2_ = NULL;
				RygelDLNAProfile* _tmp3_ = NULL;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
				_tmp2_ = profile;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
				_tmp3_ = _rygel_dlna_profile_ref0 (_tmp2_);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
				self->priv->_supported_profiles = g_list_append (self->priv->_supported_profiles, _tmp3_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
				_rygel_dlna_profile_unref0 (profile);
#line 846 "rygel-media-server-plugin.c"
			}
		}
	}
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_object_notify ((GObject *) self, "supported-profiles");
#line 852 "rygel-media-server-plugin.c"
}


static void rygel_media_server_plugin_class_init (RygelMediaServerPluginClass * klass) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	rygel_media_server_plugin_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaServerPluginPrivate));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	((GObjectClass *) klass)->constructed = rygel_media_server_plugin_real_constructed;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	((RygelPluginClass *) klass)->apply_hacks = rygel_media_server_plugin_real_apply_hacks;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	RYGEL_MEDIA_SERVER_PLUGIN_CLASS (klass)->get_search_caps = rygel_media_server_plugin_real_get_search_caps;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_server_plugin_get_property;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_server_plugin_set_property;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_server_plugin_finalize;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_SERVER_PLUGIN_ROOT_CONTAINER, g_param_spec_object ("root-container", "root-container", "root-container", RYGEL_TYPE_MEDIA_CONTAINER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 875 "rygel-media-server-plugin.c"
	/**
	     * The SearchCapabilities this MediaServer plugin supports.
	     *
	     * Implementations can override this to match their capabilities. If they do,
	     * they should take care to include the change tracking capabilities
	     * (upnp:objectUpdateID, upnp:containerUpdateID) based on
	     * PluginCapabilities.TRACK_CHANGES.
	     */
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_SERVER_PLUGIN_SEARCH_CAPS, g_param_spec_string ("search-caps", "search-caps", "search-caps", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 886 "rygel-media-server-plugin.c"
	/**
	     * The list of DLNA profiles the MediaServer in this plugin will accept
	     * files as upload.
	     *
	     * Can be a subset of :supported_profiles. If set to %NULL, it will be
	     * reset to :supported_profiles.
	     */
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_SERVER_PLUGIN_UPLOAD_PROFILES, g_param_spec_pointer ("upload-profiles", "upload-profiles", "upload-profiles", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 896 "rygel-media-server-plugin.c"
	/**
	     * The list of DLNA profiles the MediaServer in this plugin will be able
	     * to serve.
	     *
	     * If it does not accept all formats it can serve for uploading,
	     * :upload_profiles needs to be set to the supported subset.
	     *
	     * By default it will be the supported profiles of the #RygelMediaEngine.
	     */
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_SERVER_PLUGIN_SUPPORTED_PROFILES, g_param_spec_pointer ("supported-profiles", "supported-profiles", "supported-profiles", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 908 "rygel-media-server-plugin.c"
}


static void rygel_media_server_plugin_instance_init (RygelMediaServerPlugin * self) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	self->priv = RYGEL_MEDIA_SERVER_PLUGIN_GET_PRIVATE (self);
#line 915 "rygel-media-server-plugin.c"
}


static void rygel_media_server_plugin_finalize (GObject* obj) {
	RygelMediaServerPlugin * self;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_g_object_unref0 (self->priv->_root_container);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	_g_free0 (self->priv->_search_caps);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	__g_list_free__rygel_dlna_profile_unref0_0 (self->priv->_upload_profiles);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	__g_list_free__rygel_dlna_profile_unref0_0 (self->priv->_supported_profiles);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	G_OBJECT_CLASS (rygel_media_server_plugin_parent_class)->finalize (obj);
#line 933 "rygel-media-server-plugin.c"
}


/**
 * This is the base class for every Rygel implementation of a UPnP media
 * server. It should be used either for a real plug-in for the Rygel process or used
 * in-process via the librygel-server API.
 *
 * The plugin instance should have a #RygelMediaContainer instance as its
 * root container, which may be provided to the constructor.
 *
 * See the
 * <link linkend="implementing-server-plugins">Implementing Server Plugins</link> section.
 */
GType rygel_media_server_plugin_get_type (void) {
	static volatile gsize rygel_media_server_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_server_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaServerPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_server_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaServerPlugin), 0, (GInstanceInitFunc) rygel_media_server_plugin_instance_init, NULL };
		GType rygel_media_server_plugin_type_id;
		rygel_media_server_plugin_type_id = g_type_register_static (RYGEL_TYPE_PLUGIN, "RygelMediaServerPlugin", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_server_plugin_type_id__volatile, rygel_media_server_plugin_type_id);
	}
	return rygel_media_server_plugin_type_id__volatile;
}


static void _vala_rygel_media_server_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaServerPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	switch (property_id) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		case RYGEL_MEDIA_SERVER_PLUGIN_ROOT_CONTAINER:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_value_set_object (value, rygel_media_server_plugin_get_root_container (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		case RYGEL_MEDIA_SERVER_PLUGIN_SEARCH_CAPS:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_value_set_string (value, rygel_media_server_plugin_get_search_caps (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		case RYGEL_MEDIA_SERVER_PLUGIN_UPLOAD_PROFILES:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_value_set_pointer (value, rygel_media_server_plugin_get_upload_profiles (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		case RYGEL_MEDIA_SERVER_PLUGIN_SUPPORTED_PROFILES:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		g_value_set_pointer (value, rygel_media_server_plugin_get_supported_profiles (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		break;
#line 989 "rygel-media-server-plugin.c"
		default:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		break;
#line 995 "rygel-media-server-plugin.c"
	}
}


static void _vala_rygel_media_server_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaServerPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
	switch (property_id) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		case RYGEL_MEDIA_SERVER_PLUGIN_ROOT_CONTAINER:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		rygel_media_server_plugin_set_root_container (self, g_value_get_object (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		case RYGEL_MEDIA_SERVER_PLUGIN_UPLOAD_PROFILES:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		rygel_media_server_plugin_set_upload_profiles (self, g_value_get_pointer (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		case RYGEL_MEDIA_SERVER_PLUGIN_SUPPORTED_PROFILES:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		rygel_media_server_plugin_set_supported_profiles (self, g_value_get_pointer (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		break;
#line 1023 "rygel-media-server-plugin.c"
		default:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server-plugin.vala"
		break;
#line 1029 "rygel-media-server-plugin.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



