/* rygel-media-art-store.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-media-art-store.vala, do not modify */

/*
 * Copyright (C) 2010-2014 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libmediaart/mediaart.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_MEDIA_ART_STORE (rygel_media_art_store_get_type ())
#define RYGEL_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStore))
#define RYGEL_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))
#define RYGEL_IS_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_IS_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_MEDIA_ART_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))

typedef struct _RygelMediaArtStore RygelMediaArtStore;
typedef struct _RygelMediaArtStoreClass RygelMediaArtStoreClass;
typedef struct _RygelMediaArtStorePrivate RygelMediaArtStorePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

typedef enum  {
	MEDIA_ART_STORE_ERROR_NO_DIR,
	MEDIA_ART_STORE_ERROR_NO_MEDIA_ART
} MediaArtStoreError;
#define MEDIA_ART_STORE_ERROR media_art_store_error_quark ()
struct _RygelMediaArtStore {
	GObject parent_instance;
	RygelMediaArtStorePrivate * priv;
};

struct _RygelMediaArtStoreClass {
	GObjectClass parent_class;
};

struct _RygelMediaArtStorePrivate {
	MediaArtProcess* media_art_process;
};


static gpointer rygel_media_art_store_parent_class = NULL;
static RygelMediaArtStore* rygel_media_art_store_media_art_store;
static RygelMediaArtStore* rygel_media_art_store_media_art_store = NULL;
static gboolean rygel_media_art_store_first_time;
static gboolean rygel_media_art_store_first_time = TRUE;

GQuark media_art_store_error_quark (void);
GType rygel_media_art_store_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_ART_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStorePrivate))
enum  {
	RYGEL_MEDIA_ART_STORE_DUMMY_PROPERTY
};
RygelMediaArtStore* rygel_media_art_store_get_default (void);
static RygelMediaArtStore* rygel_media_art_store_new (GError** error);
static RygelMediaArtStore* rygel_media_art_store_construct (GType object_type, GError** error);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
RygelThumbnail* rygel_media_art_store_lookup_media_art (RygelMediaArtStore* self, RygelMusicItem* item, GError** error);
const gchar* rygel_audio_item_get_album (RygelAudioItem* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
const gchar* rygel_media_object_get_artist (RygelMediaObject* self);
RygelThumbnail* rygel_thumbnail_new (const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelThumbnail* rygel_thumbnail_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
void rygel_media_art_store_add (RygelMediaArtStore* self, RygelMusicItem* item, GFile* file, guint8* data, int data_length1, const gchar* mime);
void rygel_media_art_store_search_media_art_for_file (RygelMediaArtStore* self, RygelMusicItem* item, GFile* file);
static void rygel_media_art_store_finalize (GObject* obj);

static const gchar* RYGEL_MEDIA_ART_STORE_types[6] = {"track", "album", "artist", "podcast", "radio", "video"};

GQuark media_art_store_error_quark (void) {
	return g_quark_from_static_string ("media_art_store_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	return self ? g_object_ref (self) : NULL;
#line 173 "rygel-media-art-store.c"
}


RygelMediaArtStore* rygel_media_art_store_get_default (void) {
	RygelMediaArtStore* result = NULL;
	gboolean _tmp0_ = FALSE;
	RygelMediaArtStore* _tmp6_ = NULL;
	RygelMediaArtStore* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp0_ = rygel_media_art_store_first_time;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if (_tmp0_) {
#line 187 "rygel-media-art-store.c"
		{
			RygelMediaArtStore* _tmp1_ = NULL;
			RygelMediaArtStore* _tmp2_ = NULL;
			RygelMediaArtStore* _tmp3_ = NULL;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			media_art_plugin_init (128);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_tmp2_ = rygel_media_art_store_new (&_inner_error_);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_tmp1_ = _tmp2_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				if (_inner_error_->domain == MEDIA_ART_STORE_ERROR) {
#line 202 "rygel-media-art-store.c"
					goto __catch0_media_art_store_error;
				}
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				g_clear_error (&_inner_error_);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				return NULL;
#line 211 "rygel-media-art-store.c"
			}
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_tmp3_ = _tmp1_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_tmp1_ = NULL;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_object_unref0 (rygel_media_art_store_media_art_store);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			rygel_media_art_store_media_art_store = _tmp3_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_object_unref0 (_tmp1_);
#line 223 "rygel-media-art-store.c"
		}
		goto __finally0;
		__catch0_media_art_store_error:
		{
			GError* _error_ = NULL;
			GError* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_error_ = _inner_error_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_inner_error_ = NULL;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_tmp4_ = _error_;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_tmp5_ = _tmp4_->message;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_warning ("rygel-media-art-store.vala:47: No media art available: %s", _tmp5_);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_error_free0 (_error_);
#line 243 "rygel-media-art-store.c"
		}
		__finally0:
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_clear_error (&_inner_error_);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			return NULL;
#line 254 "rygel-media-art-store.c"
		}
	}
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	rygel_media_art_store_first_time = FALSE;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp6_ = rygel_media_art_store_media_art_store;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	result = _tmp7_;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	return result;
#line 267 "rygel-media-art-store.c"
}


RygelThumbnail* rygel_media_art_store_lookup_media_art (RygelMediaArtStore* self, RygelMusicItem* item, GError** error) {
	RygelThumbnail* result = NULL;
	GFile* file = NULL;
	GFile* _tmp17_ = NULL;
	GFileInfo* info = NULL;
	GFile* _tmp18_ = NULL;
	GFileInfo* _tmp19_ = NULL;
	GFileInfo* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	RygelThumbnail* thumb = NULL;
	RygelThumbnail* _tmp22_ = NULL;
	RygelThumbnail* _tmp23_ = NULL;
	GFile* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	RygelThumbnail* _tmp26_ = NULL;
	GFileInfo* _tmp27_ = NULL;
	gint64 _tmp28_ = 0LL;
	GError * _inner_error_ = NULL;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	file = NULL;
#line 295 "rygel-media-art-store.c"
	{
		const gchar** type_collection = NULL;
		gint type_collection_length1 = 0;
		gint _type_collection_size_ = 0;
		gint type_it = 0;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		type_collection = RYGEL_MEDIA_ART_STORE_types;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		type_collection_length1 = G_N_ELEMENTS (RYGEL_MEDIA_ART_STORE_types);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		for (type_it = 0; type_it < G_N_ELEMENTS (RYGEL_MEDIA_ART_STORE_types); type_it = type_it + 1) {
#line 307 "rygel-media-art-store.c"
			const gchar* type = NULL;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			type = type_collection[type_it];
#line 311 "rygel-media-art-store.c"
			{
				const gchar* _tmp0_ = NULL;
				const gchar* _tmp1_ = NULL;
				RygelMusicItem* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				GFile* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
				GFile* _tmp14_ = NULL;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp1_ = type;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				if (g_strcmp0 (_tmp1_, "album") == 0) {
#line 326 "rygel-media-art-store.c"
					RygelMusicItem* _tmp2_ = NULL;
					const gchar* _tmp3_ = NULL;
					const gchar* _tmp4_ = NULL;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp2_ = item;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp3_ = rygel_audio_item_get_album ((RygelAudioItem*) _tmp2_);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp4_ = _tmp3_;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp0_ = _tmp4_;
#line 338 "rygel-media-art-store.c"
				} else {
					RygelMusicItem* _tmp5_ = NULL;
					const gchar* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp5_ = item;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp6_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp5_);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp7_ = _tmp6_;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp0_ = _tmp7_;
#line 351 "rygel-media-art-store.c"
				}
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp8_ = item;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp9_ = rygel_media_object_get_artist ((RygelMediaObject*) _tmp8_);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp10_ = _tmp9_;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp11_ = type;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				media_art_get_file (_tmp10_, _tmp0_, _tmp11_, &_tmp12_);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_object_unref0 (file);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				file = _tmp12_;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp14_ = file;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				if (_tmp14_ != NULL) {
#line 371 "rygel-media-art-store.c"
					GFile* _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp15_ = file;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp16_ = g_file_query_exists (_tmp15_, NULL);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp13_ = _tmp16_;
#line 380 "rygel-media-art-store.c"
				} else {
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp13_ = FALSE;
#line 384 "rygel-media-art-store.c"
				}
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				if (_tmp13_) {
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					break;
#line 390 "rygel-media-art-store.c"
				} else {
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_g_object_unref0 (file);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					file = NULL;
#line 396 "rygel-media-art-store.c"
				}
			}
		}
	}
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp17_ = file;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if (_tmp17_ == NULL) {
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		result = NULL;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_object_unref0 (file);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		return result;
#line 411 "rygel-media-art-store.c"
	}
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp18_ = file;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp19_ = g_file_query_info (_tmp18_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	info = _tmp19_;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		g_propagate_error (error, _inner_error_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_object_unref0 (file);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		return NULL;
#line 427 "rygel-media-art-store.c"
	}
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp20_ = info;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp21_ = g_file_info_get_attribute_boolean (_tmp20_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if (!_tmp21_) {
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		result = NULL;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_object_unref0 (info);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_object_unref0 (file);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		return result;
#line 443 "rygel-media-art-store.c"
	}
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp22_ = rygel_thumbnail_new ("image/jpeg", "JPEG_TN", "jpg");
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	thumb = _tmp22_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp23_ = thumb;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp24_ = file;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp25_ = g_file_get_uri (_tmp24_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_free0 (((RygelIconInfo*) _tmp23_)->uri);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	((RygelIconInfo*) _tmp23_)->uri = _tmp25_;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp26_ = thumb;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp27_ = info;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp28_ = g_file_info_get_size (_tmp27_);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	((RygelIconInfo*) _tmp26_)->size = (gint64) _tmp28_;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	result = thumb;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_object_unref0 (info);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_object_unref0 (file);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	return result;
#line 475 "rygel-media-art-store.c"
}


void rygel_media_art_store_add (RygelMediaArtStore* self, RygelMusicItem* item, GFile* file, guint8* data, int data_length1, const gchar* mime) {
	MediaArtProcess* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_if_fail (self != NULL);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_if_fail (item != NULL);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_if_fail (file != NULL);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_if_fail (mime != NULL);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp0_ = self->priv->media_art_process;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if (_tmp0_ == NULL) {
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		return;
#line 496 "rygel-media-art-store.c"
	}
	{
		MediaArtProcess* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		guint8* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		const gchar* _tmp4_ = NULL;
		RygelMusicItem* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		RygelMusicItem* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp1_ = self->priv->media_art_process;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp2_ = file;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp3_ = data;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp3__length1 = data_length1;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp4_ = mime;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp5_ = item;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp6_ = rygel_media_object_get_artist ((RygelMediaObject*) _tmp5_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp7_ = _tmp6_;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp8_ = item;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp9_ = rygel_audio_item_get_album ((RygelAudioItem*) _tmp8_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp10_ = _tmp9_;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		media_art_process_buffer (_tmp1_, MEDIA_ART_ALBUM, MEDIA_ART_PROCESS_FLAGS_NONE, _tmp2_, _tmp3_, (gsize) _tmp3__length1, _tmp4_, _tmp7_, _tmp10_, NULL, &_inner_error_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 536 "rygel-media-art-store.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp11_ = NULL;
		GFile* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_error_ = _inner_error_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_inner_error_ = NULL;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp11_ = _ ("Failed to add album art for %s: %s");
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp12_ = file;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp13_ = g_file_get_uri (_tmp12_);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp14_ = _tmp13_;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp15_ = _error_;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp16_ = _tmp15_->message;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		g_warning (_tmp11_, _tmp14_, _tmp16_);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_free0 (_tmp14_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_error_free0 (_error_);
#line 572 "rygel-media-art-store.c"
	}
	__finally1:
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		g_clear_error (&_inner_error_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		return;
#line 583 "rygel-media-art-store.c"
	}
}


void rygel_media_art_store_search_media_art_for_file (RygelMediaArtStore* self, RygelMusicItem* item, GFile* file) {
	GError * _inner_error_ = NULL;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_if_fail (self != NULL);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_if_fail (item != NULL);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_if_fail (file != NULL);
#line 596 "rygel-media-art-store.c"
	{
		MediaArtProcess* _tmp0_ = NULL;
		GFile* _tmp1_ = NULL;
		RygelMusicItem* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		RygelMusicItem* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp0_ = self->priv->media_art_process;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp1_ = file;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp2_ = item;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp3_ = rygel_media_object_get_artist ((RygelMediaObject*) _tmp2_);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp4_ = _tmp3_;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp5_ = item;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp6_ = rygel_audio_item_get_album ((RygelAudioItem*) _tmp5_);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp7_ = _tmp6_;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		media_art_process_file (_tmp0_, MEDIA_ART_ALBUM, MEDIA_ART_PROCESS_FLAGS_NONE, _tmp1_, _tmp4_, _tmp7_, NULL, &_inner_error_);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 626 "rygel-media-art-store.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_error_ = _inner_error_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_inner_error_ = NULL;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp8_ = _ ("Failed to find media art for %s: %s");
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp9_ = file;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp10_ = g_file_get_uri (_tmp9_);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp11_ = _tmp10_;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp12_ = _error_;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp13_ = _tmp12_->message;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		g_warning (_tmp8_, _tmp11_, _tmp13_);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_free0 (_tmp11_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_error_free0 (_error_);
#line 662 "rygel-media-art-store.c"
	}
	__finally2:
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		g_clear_error (&_inner_error_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		return;
#line 673 "rygel-media-art-store.c"
	}
}


static RygelMediaArtStore* rygel_media_art_store_construct (GType object_type, GError** error) {
	RygelMediaArtStore * self = NULL;
	GError * _inner_error_ = NULL;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	self = (RygelMediaArtStore*) g_object_new (object_type, NULL);
#line 683 "rygel-media-art-store.c"
	{
		MediaArtProcess* _tmp0_ = NULL;
		MediaArtProcess* _tmp1_ = NULL;
		MediaArtProcess* _tmp2_ = NULL;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp1_ = media_art_process_new (&_inner_error_);
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp0_ = _tmp1_;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 694 "rygel-media-art-store.c"
			goto __catch3_g_error;
		}
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp2_ = _tmp0_;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp0_ = NULL;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_object_unref0 (self->priv->media_art_process);
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		self->priv->media_art_process = _tmp2_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_object_unref0 (_tmp0_);
#line 707 "rygel-media-art-store.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_error_ = _inner_error_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_inner_error_ = NULL;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_object_unref0 (self->priv->media_art_process);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		self->priv->media_art_process = NULL;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp3_ = _error_;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp4_ = _tmp3_->message;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp5_ = g_error_new (MEDIA_ART_STORE_ERROR, MEDIA_ART_STORE_ERROR_NO_MEDIA_ART, "%s", _tmp4_);
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_inner_error_ = _tmp5_;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_error_free0 (_error_);
#line 734 "rygel-media-art-store.c"
		goto __finally3;
	}
	__finally3:
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		if (_inner_error_->domain == MEDIA_ART_STORE_ERROR) {
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_propagate_error (error, _inner_error_);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_object_unref0 (self);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			return NULL;
#line 748 "rygel-media-art-store.c"
		} else {
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_clear_error (&_inner_error_);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			return NULL;
#line 756 "rygel-media-art-store.c"
		}
	}
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	return self;
#line 761 "rygel-media-art-store.c"
}


static RygelMediaArtStore* rygel_media_art_store_new (GError** error) {
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	return rygel_media_art_store_construct (RYGEL_TYPE_MEDIA_ART_STORE, error);
#line 768 "rygel-media-art-store.c"
}


static void rygel_media_art_store_class_init (RygelMediaArtStoreClass * klass) {
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	rygel_media_art_store_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaArtStorePrivate));
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_art_store_finalize;
#line 779 "rygel-media-art-store.c"
}


static void rygel_media_art_store_instance_init (RygelMediaArtStore * self) {
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	self->priv = RYGEL_MEDIA_ART_STORE_GET_PRIVATE (self);
#line 786 "rygel-media-art-store.c"
}


static void rygel_media_art_store_finalize (GObject* obj) {
	RygelMediaArtStore * self;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStore);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_object_unref0 (self->priv->media_art_process);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	G_OBJECT_CLASS (rygel_media_art_store_parent_class)->finalize (obj);
#line 798 "rygel-media-art-store.c"
}


/**
 * This maps RygelMusicItem objects to their cached cover art,
 * implementing the GNOME
 * [[https://live.gnome.org/MediaArtStorageSpec|MediaArt storage specification]].
 */
GType rygel_media_art_store_get_type (void) {
	static volatile gsize rygel_media_art_store_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_art_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaArtStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_art_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaArtStore), 0, (GInstanceInitFunc) rygel_media_art_store_instance_init, NULL };
		GType rygel_media_art_store_type_id;
		rygel_media_art_store_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaArtStore", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_art_store_type_id__volatile, rygel_media_art_store_type_id);
	}
	return rygel_media_art_store_type_id__volatile;
}



