/* rygel-http-byte-seek-request.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-http-byte-seek-request.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-core.h>
#include <gio/gio.h>


#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;
typedef struct _RygelHTTPSeekRequestPrivate RygelHTTPSeekRequestPrivate;

#define RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST (rygel_http_byte_seek_request_get_type ())
#define RYGEL_HTTP_BYTE_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequest))
#define RYGEL_HTTP_BYTE_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequestClass))
#define RYGEL_IS_HTTP_BYTE_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST))
#define RYGEL_IS_HTTP_BYTE_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST))
#define RYGEL_HTTP_BYTE_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequestClass))

typedef struct _RygelHTTPByteSeekRequest RygelHTTPByteSeekRequest;
typedef struct _RygelHTTPByteSeekRequestClass RygelHTTPByteSeekRequestClass;
typedef struct _RygelHTTPByteSeekRequestPrivate RygelHTTPByteSeekRequestPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelHTTPSeekRequest {
	GObject parent_instance;
	RygelHTTPSeekRequestPrivate * priv;
};

struct _RygelHTTPSeekRequestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPByteSeekRequest {
	RygelHTTPSeekRequest parent_instance;
	RygelHTTPByteSeekRequestPrivate * priv;
};

struct _RygelHTTPByteSeekRequestClass {
	RygelHTTPSeekRequestClass parent_class;
};

struct _RygelHTTPByteSeekRequestPrivate {
	gint64 _start_byte;
	gint64 _end_byte;
	gint64 _range_length;
	gint64 _total_size;
};

typedef enum  {
	RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekRequestError;
#define RYGEL_HTTP_SEEK_REQUEST_ERROR rygel_http_seek_request_error_quark ()
typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelHTTPSeekRequest* seek;
	RygelPlaySpeedRequest* speed_request;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()

static gpointer rygel_http_byte_seek_request_parent_class = NULL;

GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_http_byte_seek_request_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_BYTE_SEEK_REQUEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequestPrivate))
enum  {
	RYGEL_HTTP_BYTE_SEEK_REQUEST_DUMMY_PROPERTY,
	RYGEL_HTTP_BYTE_SEEK_REQUEST_START_BYTE,
	RYGEL_HTTP_BYTE_SEEK_REQUEST_END_BYTE,
	RYGEL_HTTP_BYTE_SEEK_REQUEST_RANGE_LENGTH,
	RYGEL_HTTP_BYTE_SEEK_REQUEST_TOTAL_SIZE
};
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_request_error_quark (void);
GQuark rygel_http_request_error_quark (void);
RygelHTTPByteSeekRequest* rygel_http_byte_seek_request_new (RygelHTTPGet* request, GError** error);
RygelHTTPByteSeekRequest* rygel_http_byte_seek_request_construct (GType object_type, RygelHTTPGet* request, GError** error);
RygelHTTPSeekRequest* rygel_http_seek_request_construct (GType object_type);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
gint64 rygel_http_get_handler_get_resource_size (RygelHTTPGetHandler* self);
#define RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED ((gint64) (-1))
static gchar* rygel_http_byte_seek_request_strip_leading_zeros (const gchar* number_string);
static void rygel_http_byte_seek_request_set_range_length (RygelHTTPByteSeekRequest* self, gint64 value);
void rygel_http_byte_seek_request_set_start_byte (RygelHTTPByteSeekRequest* self, gint64 value);
void rygel_http_byte_seek_request_set_end_byte (RygelHTTPByteSeekRequest* self, gint64 value);
void rygel_http_byte_seek_request_set_total_size (RygelHTTPByteSeekRequest* self, gint64 value);
gboolean rygel_http_byte_seek_request_supported (RygelHTTPGet* request);
GQuark rygel_client_hacks_error_quark (void);
RygelClientHacks* rygel_client_hacks_create (SoupMessage* message, GError** error);
gboolean rygel_client_hacks_force_seek (RygelClientHacks* self);
gboolean rygel_http_get_handler_supports_byte_seek (RygelHTTPGetHandler* self);
gboolean rygel_http_byte_seek_request_requested (RygelHTTPGet* request);
gint64 rygel_http_byte_seek_request_get_start_byte (RygelHTTPByteSeekRequest* self);
gint64 rygel_http_byte_seek_request_get_end_byte (RygelHTTPByteSeekRequest* self);
gint64 rygel_http_byte_seek_request_get_range_length (RygelHTTPByteSeekRequest* self);
gint64 rygel_http_byte_seek_request_get_total_size (RygelHTTPByteSeekRequest* self);
static void rygel_http_byte_seek_request_finalize (GObject* obj);
static void _vala_rygel_http_byte_seek_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_byte_seek_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1198 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1198 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 291 "rygel-http-byte-seek-request.c"
		glong _tmp4_ = 0L;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 299 "rygel-http-byte-seek-request.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 311 "rygel-http-byte-seek-request.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1208 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 335 "rygel-http-byte-seek-request.c"
		glong _tmp2_ = 0L;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 341 "rygel-http-byte-seek-request.c"
	} else {
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 345 "rygel-http-byte-seek-request.c"
	}
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 349 "rygel-http-byte-seek-request.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 361 "rygel-http-byte-seek-request.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 371 "rygel-http-byte-seek-request.c"
	}
#line 1217 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1217 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 377 "rygel-http-byte-seek-request.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1219 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1219 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 391 "rygel-http-byte-seek-request.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 401 "rygel-http-byte-seek-request.c"
	}
#line 1223 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1223 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 407 "rygel-http-byte-seek-request.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 416 "rygel-http-byte-seek-request.c"
	}
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 436 "rygel-http-byte-seek-request.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1278 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1278 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 456 "rygel-http-byte-seek-request.c"
}


static gboolean int64_try_parse (const gchar* str, gint64* _result_) {
	gint64 _vala_result = 0LL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
#line 608 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, FALSE);
#line 610 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 610 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = g_ascii_strtoll (_tmp0_, &_tmp1_, (guint) 0);
#line 610 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	endptr = _tmp1_;
#line 610 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_vala_result = _tmp2_;
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = endptr;
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp4_ = str;
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp5_ = str;
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp6_ = strlen (_tmp5_);
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp7_ = _tmp6_;
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
#line 612 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = TRUE;
#line 612 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (_result_) {
#line 612 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			*_result_ = _vala_result;
#line 500 "rygel-http-byte-seek-request.c"
		}
#line 612 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 504 "rygel-http-byte-seek-request.c"
	} else {
#line 614 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = FALSE;
#line 614 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (_result_) {
#line 614 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			*_result_ = _vala_result;
#line 512 "rygel-http-byte-seek-request.c"
		}
#line 614 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 516 "rygel-http-byte-seek-request.c"
	}
#line 608 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_result_) {
#line 608 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		*_result_ = _vala_result;
#line 522 "rygel-http-byte-seek-request.c"
	}
}


RygelHTTPByteSeekRequest* rygel_http_byte_seek_request_construct (GType object_type, RygelHTTPGet* request, GError** error) {
	RygelHTTPByteSeekRequest * self = NULL;
	const gchar* range = NULL;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gint64 start_byte = 0LL;
	gint64 end_byte = 0LL;
	gint64 total_size = 0LL;
	RygelHTTPGet* _tmp6_ = NULL;
	RygelHTTPGetHandler* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	gint64 _tmp9_ = 0LL;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gchar* parsed_range = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	gchar** range_tokens = NULL;
	gchar** _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint range_tokens_length1 = 0;
	gint _range_tokens_size_ = 0;
	gchar** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gint64 _tmp25_ = 0LL;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gint64 _tmp31_ = 0LL;
	gboolean _tmp38_ = FALSE;
	gchar** _tmp39_ = NULL;
	gint _tmp39__length1 = 0;
	const gchar* _tmp40_ = NULL;
	gint64 _tmp71_ = 0LL;
	gint64 _tmp72_ = 0LL;
	gint64 _tmp73_ = 0LL;
	GError * _inner_error_ = NULL;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	g_return_val_if_fail (request != NULL, NULL);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	self = (RygelHTTPByteSeekRequest*) rygel_http_seek_request_construct (object_type);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp0_ = request;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp2_ = _tmp1_->request_headers;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp3_ = soup_message_headers_get_one (_tmp2_, "Range");
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	range = _tmp3_;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp4_ = range;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	if (_tmp4_ == NULL) {
#line 589 "rygel-http-byte-seek-request.c"
		GError* _tmp5_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp5_ = g_error_new_literal (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Range header not present");
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_inner_error_ = _tmp5_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			g_propagate_error (error, _inner_error_);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_g_object_unref0 (self);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			return NULL;
#line 603 "rygel-http-byte-seek-request.c"
		} else {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			g_clear_error (&_inner_error_);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			return NULL;
#line 611 "rygel-http-byte-seek-request.c"
		}
	}
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp6_ = request;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp7_ = _tmp6_->handler;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp8_ = rygel_http_get_handler_get_resource_size (_tmp7_);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	total_size = _tmp8_;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp9_ = total_size;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	if (_tmp9_ < ((gint64) 0)) {
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		total_size = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
#line 628 "rygel-http-byte-seek-request.c"
	}
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp10_ = range;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp11_ = g_str_has_prefix (_tmp10_, "bytes=");
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	if (!_tmp11_) {
#line 636 "rygel-http-byte-seek-request.c"
		const gchar* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp12_ = range;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp13_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid Range value (missing 'bytes=' field): '%s'", _tmp12_);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_inner_error_ = _tmp13_;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			g_propagate_error (error, _inner_error_);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_g_object_unref0 (self);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			return NULL;
#line 653 "rygel-http-byte-seek-request.c"
		} else {
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			g_clear_error (&_inner_error_);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			return NULL;
#line 661 "rygel-http-byte-seek-request.c"
		}
	}
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp14_ = range;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp15_ = string_substring (_tmp14_, (glong) 6, (glong) (-1));
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	parsed_range = _tmp15_;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp16_ = string_contains (parsed_range, "-");
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	if (!_tmp16_) {
#line 674 "rygel-http-byte-seek-request.c"
		const gchar* _tmp17_ = NULL;
		GError* _tmp18_ = NULL;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp17_ = range;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp18_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid Range request with no '-': '%s'", _tmp17_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_inner_error_ = _tmp18_;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			g_propagate_error (error, _inner_error_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_g_free0 (parsed_range);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_g_object_unref0 (self);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			return NULL;
#line 693 "rygel-http-byte-seek-request.c"
		} else {
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_g_free0 (parsed_range);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			g_clear_error (&_inner_error_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			return NULL;
#line 703 "rygel-http-byte-seek-request.c"
		}
	}
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp20_ = _tmp19_ = g_strsplit (parsed_range, "-", 2);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	range_tokens = _tmp20_;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	range_tokens_length1 = _vala_array_length (_tmp19_);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_range_tokens_size_ = range_tokens_length1;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp21_ = range_tokens;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp21__length1 = range_tokens_length1;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp22_ = _tmp21_[0];
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp23_ = rygel_http_byte_seek_request_strip_leading_zeros (_tmp22_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp24_ = _tmp23_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp26_ = int64_try_parse (_tmp24_, &_tmp25_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	start_byte = _tmp25_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp27_ = !_tmp26_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_g_free0 (_tmp24_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	if (_tmp27_) {
#line 734 "rygel-http-byte-seek-request.c"
		const gchar* _tmp28_ = NULL;
		GError* _tmp29_ = NULL;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp28_ = range;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp29_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid Range start value: '%s'", _tmp28_);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_inner_error_ = _tmp29_;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			g_propagate_error (error, _inner_error_);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_g_free0 (parsed_range);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_g_object_unref0 (self);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			return NULL;
#line 755 "rygel-http-byte-seek-request.c"
		} else {
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_g_free0 (parsed_range);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			g_clear_error (&_inner_error_);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			return NULL;
#line 767 "rygel-http-byte-seek-request.c"
		}
	}
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp31_ = total_size;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	if (_tmp31_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
#line 774 "rygel-http-byte-seek-request.c"
		gint64 _tmp32_ = 0LL;
		gint64 _tmp33_ = 0LL;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp32_ = start_byte;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp33_ = total_size;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp30_ = _tmp32_ >= _tmp33_;
#line 783 "rygel-http-byte-seek-request.c"
	} else {
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp30_ = FALSE;
#line 787 "rygel-http-byte-seek-request.c"
	}
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	if (_tmp30_) {
#line 791 "rygel-http-byte-seek-request.c"
		gint64 _tmp34_ = 0LL;
		gint64 _tmp35_ = 0LL;
		const gchar* _tmp36_ = NULL;
		GError* _tmp37_ = NULL;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp34_ = start_byte;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp35_ = total_size;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp36_ = range;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp37_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE, "Range start value %lld is larger than content size %lld: '%s'", _tmp34_, _tmp35_, _tmp36_);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_inner_error_ = _tmp37_;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			g_propagate_error (error, _inner_error_);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_g_free0 (parsed_range);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_g_object_unref0 (self);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			return NULL;
#line 818 "rygel-http-byte-seek-request.c"
		} else {
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_g_free0 (parsed_range);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			g_clear_error (&_inner_error_);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			return NULL;
#line 830 "rygel-http-byte-seek-request.c"
		}
	}
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp39_ = range_tokens;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp39__length1 = range_tokens_length1;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp40_ = _tmp39_[1];
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	if (_tmp40_ == NULL) {
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp38_ = TRUE;
#line 843 "rygel-http-byte-seek-request.c"
	} else {
		gchar** _tmp41_ = NULL;
		gint _tmp41__length1 = 0;
		const gchar* _tmp42_ = NULL;
		gint _tmp43_ = 0;
		gint _tmp44_ = 0;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp41_ = range_tokens;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp41__length1 = range_tokens_length1;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp42_ = _tmp41_[1];
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp43_ = strlen (_tmp42_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp44_ = _tmp43_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp38_ = _tmp44_ == 0;
#line 862 "rygel-http-byte-seek-request.c"
	}
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	if (_tmp38_) {
#line 866 "rygel-http-byte-seek-request.c"
		gint64 _tmp45_ = 0LL;
		gint64 _tmp46_ = 0LL;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp45_ = total_size;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		end_byte = _tmp45_;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp46_ = total_size;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		if (_tmp46_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
#line 877 "rygel-http-byte-seek-request.c"
			gint64 _tmp47_ = 0LL;
			gint64 _tmp48_ = 0LL;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_tmp47_ = end_byte;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_tmp48_ = start_byte;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			rygel_http_byte_seek_request_set_range_length (self, (_tmp47_ - _tmp48_) + 1);
#line 886 "rygel-http-byte-seek-request.c"
		} else {
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			rygel_http_byte_seek_request_set_range_length (self, RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED);
#line 890 "rygel-http-byte-seek-request.c"
		}
	} else {
		gchar** _tmp49_ = NULL;
		gint _tmp49__length1 = 0;
		const gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		gint64 _tmp53_ = 0LL;
		gboolean _tmp54_ = FALSE;
		gboolean _tmp55_ = FALSE;
		gint64 _tmp58_ = 0LL;
		gint64 _tmp59_ = 0LL;
		gboolean _tmp64_ = FALSE;
		gint64 _tmp65_ = 0LL;
		gint64 _tmp69_ = 0LL;
		gint64 _tmp70_ = 0LL;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp49_ = range_tokens;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp49__length1 = range_tokens_length1;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp50_ = _tmp49_[1];
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp51_ = rygel_http_byte_seek_request_strip_leading_zeros (_tmp50_);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp52_ = _tmp51_;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp54_ = int64_try_parse (_tmp52_, &_tmp53_);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		end_byte = _tmp53_;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp55_ = !_tmp54_;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_g_free0 (_tmp52_);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		if (_tmp55_) {
#line 927 "rygel-http-byte-seek-request.c"
			const gchar* _tmp56_ = NULL;
			GError* _tmp57_ = NULL;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_tmp56_ = range;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_tmp57_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid Range end value: '%s'", _tmp56_);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_inner_error_ = _tmp57_;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
				g_propagate_error (error, _inner_error_);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
				_g_free0 (parsed_range);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
				_g_object_unref0 (self);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
				return NULL;
#line 948 "rygel-http-byte-seek-request.c"
			} else {
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
				_g_free0 (parsed_range);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
				g_clear_error (&_inner_error_);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
				return NULL;
#line 960 "rygel-http-byte-seek-request.c"
			}
		}
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp58_ = end_byte;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp59_ = start_byte;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		if (_tmp58_ < _tmp59_) {
#line 969 "rygel-http-byte-seek-request.c"
			gint64 _tmp60_ = 0LL;
			gint64 _tmp61_ = 0LL;
			const gchar* _tmp62_ = NULL;
			GError* _tmp63_ = NULL;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_tmp60_ = end_byte;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_tmp61_ = start_byte;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_tmp62_ = range;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_tmp63_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Range end value %lld is smaller than range start value %lld: '%s'", _tmp60_, _tmp61_, _tmp62_);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_inner_error_ = _tmp63_;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
				g_propagate_error (error, _inner_error_);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
				_g_free0 (parsed_range);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
				_g_object_unref0 (self);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
				return NULL;
#line 996 "rygel-http-byte-seek-request.c"
			} else {
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
				_g_free0 (parsed_range);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
				g_clear_error (&_inner_error_);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
				return NULL;
#line 1008 "rygel-http-byte-seek-request.c"
			}
		}
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp65_ = total_size;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		if (_tmp65_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
#line 1015 "rygel-http-byte-seek-request.c"
			gint64 _tmp66_ = 0LL;
			gint64 _tmp67_ = 0LL;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_tmp66_ = end_byte;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_tmp67_ = total_size;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_tmp64_ = _tmp66_ >= _tmp67_;
#line 1024 "rygel-http-byte-seek-request.c"
		} else {
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_tmp64_ = FALSE;
#line 1028 "rygel-http-byte-seek-request.c"
		}
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		if (_tmp64_) {
#line 1032 "rygel-http-byte-seek-request.c"
			gint64 _tmp68_ = 0LL;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_tmp68_ = total_size;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			end_byte = _tmp68_ - 1;
#line 1038 "rygel-http-byte-seek-request.c"
		}
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp69_ = end_byte;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp70_ = start_byte;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		rygel_http_byte_seek_request_set_range_length (self, (_tmp69_ - _tmp70_) + 1);
#line 1046 "rygel-http-byte-seek-request.c"
	}
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp71_ = start_byte;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	rygel_http_byte_seek_request_set_start_byte (self, _tmp71_);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp72_ = end_byte;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	rygel_http_byte_seek_request_set_end_byte (self, _tmp72_);
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp73_ = total_size;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	rygel_http_byte_seek_request_set_total_size (self, _tmp73_);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_g_free0 (parsed_range);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	return self;
#line 1066 "rygel-http-byte-seek-request.c"
}


RygelHTTPByteSeekRequest* rygel_http_byte_seek_request_new (RygelHTTPGet* request, GError** error) {
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	return rygel_http_byte_seek_request_construct (RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, request, error);
#line 1073 "rygel-http-byte-seek-request.c"
}


gboolean rygel_http_byte_seek_request_supported (RygelHTTPGet* request) {
	gboolean result = FALSE;
	gboolean force_seek = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	g_return_val_if_fail (request != NULL, FALSE);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	force_seek = FALSE;
#line 1087 "rygel-http-byte-seek-request.c"
	{
		RygelClientHacks* hack = NULL;
		RygelHTTPGet* _tmp0_ = NULL;
		SoupMessage* _tmp1_ = NULL;
		RygelClientHacks* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp0_ = request;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp2_ = rygel_client_hacks_create (_tmp1_, &_inner_error_);
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		hack = _tmp2_;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1104 "rygel-http-byte-seek-request.c"
			goto __catch36_g_error;
		}
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp3_ = rygel_client_hacks_force_seek (hack);
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		force_seek = _tmp3_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_g_object_unref0 (hack);
#line 1113 "rygel-http-byte-seek-request.c"
	}
	goto __finally36;
	__catch36_g_error:
	{
		GError* _error_ = NULL;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_error_ = _inner_error_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_inner_error_ = NULL;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_g_error_free0 (_error_);
#line 1125 "rygel-http-byte-seek-request.c"
	}
	__finally36:
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		g_clear_error (&_inner_error_);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		return FALSE;
#line 1136 "rygel-http-byte-seek-request.c"
	}
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp5_ = force_seek;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	if (_tmp5_) {
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp4_ = TRUE;
#line 1144 "rygel-http-byte-seek-request.c"
	} else {
		RygelHTTPGet* _tmp6_ = NULL;
		RygelHTTPGetHandler* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp6_ = request;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp7_ = _tmp6_->handler;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp8_ = rygel_http_get_handler_supports_byte_seek (_tmp7_);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp4_ = _tmp8_;
#line 1157 "rygel-http-byte-seek-request.c"
	}
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	result = _tmp4_;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	return result;
#line 1163 "rygel-http-byte-seek-request.c"
}


gboolean rygel_http_byte_seek_request_requested (RygelHTTPGet* request) {
	gboolean result = FALSE;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	g_return_val_if_fail (request != NULL, FALSE);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp0_ = request;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp2_ = _tmp1_->request_headers;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp3_ = soup_message_headers_get_one (_tmp2_, "Range");
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	result = _tmp3_ != NULL;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	return result;
#line 1187 "rygel-http-byte-seek-request.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 1205 "rygel-http-byte-seek-request.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1230 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1231 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1231 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1231 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1232 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1232 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 1238 "rygel-http-byte-seek-request.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1233 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1233 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1233 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 1247 "rygel-http-byte-seek-request.c"
	}
#line 1235 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1235 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 1253 "rygel-http-byte-seek-request.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1236 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1236 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1236 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 1262 "rygel-http-byte-seek-request.c"
	}
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 1268 "rygel-http-byte-seek-request.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 1277 "rygel-http-byte-seek-request.c"
	} else {
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 1281 "rygel-http-byte-seek-request.c"
	}
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 1289 "rygel-http-byte-seek-request.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 1298 "rygel-http-byte-seek-request.c"
	} else {
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 1302 "rygel-http-byte-seek-request.c"
	}
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1240 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1240 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1240 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 1324 "rygel-http-byte-seek-request.c"
}


static gchar* rygel_http_byte_seek_request_strip_leading_zeros (const gchar* number_string) {
	gchar* result = NULL;
	gint i = 0;
	gint _tmp9_ = 0;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	g_return_val_if_fail (number_string != NULL, NULL);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	i = 0;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	while (TRUE) {
#line 1338 "rygel-http-byte-seek-request.c"
		gboolean _tmp0_ = FALSE;
		const gchar* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gchar _tmp3_ = '\0';
		gint _tmp8_ = 0;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp1_ = number_string;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp2_ = i;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp3_ = string_get (_tmp1_, (glong) _tmp2_);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		if (_tmp3_ == '0') {
#line 1352 "rygel-http-byte-seek-request.c"
			gint _tmp4_ = 0;
			const gchar* _tmp5_ = NULL;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_tmp4_ = i;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_tmp5_ = number_string;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_tmp6_ = strlen (_tmp5_);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_tmp7_ = _tmp6_;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_tmp0_ = _tmp4_ < _tmp7_;
#line 1367 "rygel-http-byte-seek-request.c"
		} else {
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			_tmp0_ = FALSE;
#line 1371 "rygel-http-byte-seek-request.c"
		}
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		if (!_tmp0_) {
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
			break;
#line 1377 "rygel-http-byte-seek-request.c"
		}
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp8_ = i;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		i = _tmp8_ + 1;
#line 1383 "rygel-http-byte-seek-request.c"
	}
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp9_ = i;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	if (_tmp9_ == 0) {
#line 1389 "rygel-http-byte-seek-request.c"
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp10_ = number_string;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp11_ = g_strdup (_tmp10_);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		result = _tmp11_;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		return result;
#line 1400 "rygel-http-byte-seek-request.c"
	} else {
		const gchar* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		const gchar* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gchar* _tmp17_ = NULL;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp12_ = number_string;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp13_ = i;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp14_ = number_string;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp15_ = strlen (_tmp14_);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp16_ = _tmp15_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		_tmp17_ = string_slice (_tmp12_, (glong) _tmp13_, (glong) _tmp16_);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		result = _tmp17_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		return result;
#line 1424 "rygel-http-byte-seek-request.c"
	}
}


gint64 rygel_http_byte_seek_request_get_start_byte (RygelHTTPByteSeekRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp0_ = self->priv->_start_byte;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	result = _tmp0_;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	return result;
#line 1440 "rygel-http-byte-seek-request.c"
}


void rygel_http_byte_seek_request_set_start_byte (RygelHTTPByteSeekRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	g_return_if_fail (self != NULL);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp0_ = value;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	self->priv->_start_byte = _tmp0_;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	g_object_notify ((GObject *) self, "start-byte");
#line 1454 "rygel-http-byte-seek-request.c"
}


gint64 rygel_http_byte_seek_request_get_end_byte (RygelHTTPByteSeekRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp0_ = self->priv->_end_byte;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	result = _tmp0_;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	return result;
#line 1469 "rygel-http-byte-seek-request.c"
}


void rygel_http_byte_seek_request_set_end_byte (RygelHTTPByteSeekRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	g_return_if_fail (self != NULL);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp0_ = value;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	self->priv->_end_byte = _tmp0_;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	g_object_notify ((GObject *) self, "end-byte");
#line 1483 "rygel-http-byte-seek-request.c"
}


gint64 rygel_http_byte_seek_request_get_range_length (RygelHTTPByteSeekRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp0_ = self->priv->_range_length;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	result = _tmp0_;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	return result;
#line 1498 "rygel-http-byte-seek-request.c"
}


static void rygel_http_byte_seek_request_set_range_length (RygelHTTPByteSeekRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	g_return_if_fail (self != NULL);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp0_ = value;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	self->priv->_range_length = _tmp0_;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	g_object_notify ((GObject *) self, "range-length");
#line 1512 "rygel-http-byte-seek-request.c"
}


gint64 rygel_http_byte_seek_request_get_total_size (RygelHTTPByteSeekRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp0_ = self->priv->_total_size;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	result = _tmp0_;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	return result;
#line 1527 "rygel-http-byte-seek-request.c"
}


void rygel_http_byte_seek_request_set_total_size (RygelHTTPByteSeekRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	g_return_if_fail (self != NULL);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	_tmp0_ = value;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	self->priv->_total_size = _tmp0_;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	g_object_notify ((GObject *) self, "total-size");
#line 1541 "rygel-http-byte-seek-request.c"
}


static void rygel_http_byte_seek_request_class_init (RygelHTTPByteSeekRequestClass * klass) {
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	rygel_http_byte_seek_request_parent_class = g_type_class_peek_parent (klass);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPByteSeekRequestPrivate));
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_byte_seek_request_get_property;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_byte_seek_request_set_property;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_byte_seek_request_finalize;
#line 1556 "rygel-http-byte-seek-request.c"
	/**
	     * The start of the range in bytes
	     */
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_REQUEST_START_BYTE, g_param_spec_int64 ("start-byte", "start-byte", "start-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1562 "rygel-http-byte-seek-request.c"
	/**
	     * The end of the range in bytes (inclusive)
	     */
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_REQUEST_END_BYTE, g_param_spec_int64 ("end-byte", "end-byte", "end-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1568 "rygel-http-byte-seek-request.c"
	/**
	     * The length of the range in bytes
	     */
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_REQUEST_RANGE_LENGTH, g_param_spec_int64 ("range-length", "range-length", "range-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1574 "rygel-http-byte-seek-request.c"
	/**
	     * The length of the resource in bytes
	     */
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_REQUEST_TOTAL_SIZE, g_param_spec_int64 ("total-size", "total-size", "total-size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1580 "rygel-http-byte-seek-request.c"
}


static void rygel_http_byte_seek_request_instance_init (RygelHTTPByteSeekRequest * self) {
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	self->priv = RYGEL_HTTP_BYTE_SEEK_REQUEST_GET_PRIVATE (self);
#line 1587 "rygel-http-byte-seek-request.c"
}


static void rygel_http_byte_seek_request_finalize (GObject* obj) {
	RygelHTTPByteSeekRequest * self;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequest);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	G_OBJECT_CLASS (rygel_http_byte_seek_request_parent_class)->finalize (obj);
#line 1597 "rygel-http-byte-seek-request.c"
}


GType rygel_http_byte_seek_request_get_type (void) {
	static volatile gsize rygel_http_byte_seek_request_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_byte_seek_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPByteSeekRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_byte_seek_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPByteSeekRequest), 0, (GInstanceInitFunc) rygel_http_byte_seek_request_instance_init, NULL };
		GType rygel_http_byte_seek_request_type_id;
		rygel_http_byte_seek_request_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK_REQUEST, "RygelHTTPByteSeekRequest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_byte_seek_request_type_id__volatile, rygel_http_byte_seek_request_type_id);
	}
	return rygel_http_byte_seek_request_type_id__volatile;
}


static void _vala_rygel_http_byte_seek_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPByteSeekRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequest);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	switch (property_id) {
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_START_BYTE:
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		g_value_set_int64 (value, rygel_http_byte_seek_request_get_start_byte (self));
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		break;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_END_BYTE:
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		g_value_set_int64 (value, rygel_http_byte_seek_request_get_end_byte (self));
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		break;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_RANGE_LENGTH:
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		g_value_set_int64 (value, rygel_http_byte_seek_request_get_range_length (self));
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		break;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_TOTAL_SIZE:
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		g_value_set_int64 (value, rygel_http_byte_seek_request_get_total_size (self));
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		break;
#line 1642 "rygel-http-byte-seek-request.c"
		default:
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		break;
#line 1648 "rygel-http-byte-seek-request.c"
	}
}


static void _vala_rygel_http_byte_seek_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPByteSeekRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST, RygelHTTPByteSeekRequest);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
	switch (property_id) {
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_START_BYTE:
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		rygel_http_byte_seek_request_set_start_byte (self, g_value_get_int64 (value));
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		break;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_END_BYTE:
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		rygel_http_byte_seek_request_set_end_byte (self, g_value_get_int64 (value));
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		break;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_RANGE_LENGTH:
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		rygel_http_byte_seek_request_set_range_length (self, g_value_get_int64 (value));
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		break;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		case RYGEL_HTTP_BYTE_SEEK_REQUEST_TOTAL_SIZE:
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		rygel_http_byte_seek_request_set_total_size (self, g_value_get_int64 (value));
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		break;
#line 1682 "rygel-http-byte-seek-request.c"
		default:
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-byte-seek-request.vala"
		break;
#line 1688 "rygel-http-byte-seek-request.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



