/* rygel-dtcp-cleartext-response.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-dtcp-cleartext-response.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL CABLE TELEVISION LABORATORIES
 * INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;
typedef struct _RygelHTTPResponseElementPrivate RygelHTTPResponseElementPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_DTCP_CLEARTEXT_RESPONSE (rygel_dtcp_cleartext_response_get_type ())
#define RYGEL_DTCP_CLEARTEXT_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_RESPONSE, RygelDTCPCleartextResponse))
#define RYGEL_DTCP_CLEARTEXT_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DTCP_CLEARTEXT_RESPONSE, RygelDTCPCleartextResponseClass))
#define RYGEL_IS_DTCP_CLEARTEXT_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_RESPONSE))
#define RYGEL_IS_DTCP_CLEARTEXT_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DTCP_CLEARTEXT_RESPONSE))
#define RYGEL_DTCP_CLEARTEXT_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_RESPONSE, RygelDTCPCleartextResponseClass))

typedef struct _RygelDTCPCleartextResponse RygelDTCPCleartextResponse;
typedef struct _RygelDTCPCleartextResponseClass RygelDTCPCleartextResponseClass;
typedef struct _RygelDTCPCleartextResponsePrivate RygelDTCPCleartextResponsePrivate;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST (rygel_dtcp_cleartext_request_get_type ())
#define RYGEL_DTCP_CLEARTEXT_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest))
#define RYGEL_DTCP_CLEARTEXT_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequestClass))
#define RYGEL_IS_DTCP_CLEARTEXT_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST))
#define RYGEL_IS_DTCP_CLEARTEXT_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST))
#define RYGEL_DTCP_CLEARTEXT_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequestClass))

typedef struct _RygelDTCPCleartextRequest RygelDTCPCleartextRequest;
typedef struct _RygelDTCPCleartextRequestClass RygelDTCPCleartextRequestClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

struct _RygelHTTPResponseElement {
	GObject parent_instance;
	RygelHTTPResponseElementPrivate * priv;
};

struct _RygelHTTPResponseElementClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPResponseElement* self, RygelHTTPRequest* request);
	gchar* (*to_string) (RygelHTTPResponseElement* self);
};

struct _RygelDTCPCleartextResponse {
	RygelHTTPResponseElement parent_instance;
	RygelDTCPCleartextResponsePrivate * priv;
};

struct _RygelDTCPCleartextResponseClass {
	RygelHTTPResponseElementClass parent_class;
};

struct _RygelDTCPCleartextResponsePrivate {
	gint64 _start_byte;
	gint64 _end_byte;
	gint64 _range_length;
	gint64 _total_size;
	gint64 _encrypted_length;
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_dtcp_cleartext_response_parent_class = NULL;

GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_dtcp_cleartext_response_get_type (void) G_GNUC_CONST;
#define RYGEL_DTCP_CLEARTEXT_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_DTCP_CLEARTEXT_RESPONSE, RygelDTCPCleartextResponsePrivate))
enum  {
	RYGEL_DTCP_CLEARTEXT_RESPONSE_DUMMY_PROPERTY,
	RYGEL_DTCP_CLEARTEXT_RESPONSE_START_BYTE,
	RYGEL_DTCP_CLEARTEXT_RESPONSE_END_BYTE,
	RYGEL_DTCP_CLEARTEXT_RESPONSE_RANGE_LENGTH,
	RYGEL_DTCP_CLEARTEXT_RESPONSE_TOTAL_SIZE,
	RYGEL_DTCP_CLEARTEXT_RESPONSE_ENCRYPTED_LENGTH
};
#define RYGEL_DTCP_CLEARTEXT_RESPONSE_DTCP_CONTENT_RANGE_HEADER "Content-Range.dtcp.com"
RygelDTCPCleartextResponse* rygel_dtcp_cleartext_response_new (gint64 start_byte, gint64 end_byte, gint64 total_size, gint64 encrypted_length);
RygelDTCPCleartextResponse* rygel_dtcp_cleartext_response_construct (GType object_type, gint64 start_byte, gint64 end_byte, gint64 total_size, gint64 encrypted_length);
RygelHTTPResponseElement* rygel_http_response_element_construct (GType object_type);
static void rygel_dtcp_cleartext_response_set_start_byte (RygelDTCPCleartextResponse* self, gint64 value);
static void rygel_dtcp_cleartext_response_set_end_byte (RygelDTCPCleartextResponse* self, gint64 value);
static void rygel_dtcp_cleartext_response_set_range_length (RygelDTCPCleartextResponse* self, gint64 value);
static void rygel_dtcp_cleartext_response_set_total_size (RygelDTCPCleartextResponse* self, gint64 value);
void rygel_dtcp_cleartext_response_set_encrypted_length (RygelDTCPCleartextResponse* self, gint64 value);
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_dtcp_cleartext_request_get_type (void) G_GNUC_CONST;
RygelDTCPCleartextResponse* rygel_dtcp_cleartext_response_new_from_request (RygelDTCPCleartextRequest* request, gint64 encrypted_length);
RygelDTCPCleartextResponse* rygel_dtcp_cleartext_response_construct_from_request (GType object_type, RygelDTCPCleartextRequest* request, gint64 encrypted_length);
gint64 rygel_dtcp_cleartext_request_get_start_byte (RygelDTCPCleartextRequest* self);
gint64 rygel_dtcp_cleartext_request_get_end_byte (RygelDTCPCleartextRequest* self);
gint64 rygel_dtcp_cleartext_request_get_range_length (RygelDTCPCleartextRequest* self);
gint64 rygel_dtcp_cleartext_request_get_total_size (RygelDTCPCleartextRequest* self);
static void rygel_dtcp_cleartext_response_real_add_response_headers (RygelHTTPResponseElement* base, RygelHTTPRequest* request);
gint64 rygel_dtcp_cleartext_response_get_start_byte (RygelDTCPCleartextResponse* self);
#define RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED ((gint64) (-1))
gint64 rygel_dtcp_cleartext_response_get_total_size (RygelDTCPCleartextResponse* self);
gint64 rygel_dtcp_cleartext_response_get_end_byte (RygelDTCPCleartextResponse* self);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
gint64 rygel_dtcp_cleartext_response_get_encrypted_length (RygelDTCPCleartextResponse* self);
static gchar* rygel_dtcp_cleartext_response_real_to_string (RygelHTTPResponseElement* base);
gint64 rygel_dtcp_cleartext_response_get_range_length (RygelDTCPCleartextResponse* self);
static void rygel_dtcp_cleartext_response_finalize (GObject* obj);
static void _vala_rygel_dtcp_cleartext_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_dtcp_cleartext_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


RygelDTCPCleartextResponse* rygel_dtcp_cleartext_response_construct (GType object_type, gint64 start_byte, gint64 end_byte, gint64 total_size, gint64 encrypted_length) {
	RygelDTCPCleartextResponse * self = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	self = (RygelDTCPCleartextResponse*) rygel_http_response_element_construct (object_type);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp0_ = start_byte;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	rygel_dtcp_cleartext_response_set_start_byte (self, _tmp0_);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp1_ = end_byte;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	rygel_dtcp_cleartext_response_set_end_byte (self, _tmp1_);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp2_ = end_byte;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp3_ = start_byte;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	rygel_dtcp_cleartext_response_set_range_length (self, (_tmp2_ - _tmp3_) + 1);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp4_ = total_size;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	rygel_dtcp_cleartext_response_set_total_size (self, _tmp4_);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp5_ = encrypted_length;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	rygel_dtcp_cleartext_response_set_encrypted_length (self, _tmp5_);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	return self;
#line 267 "rygel-dtcp-cleartext-response.c"
}


RygelDTCPCleartextResponse* rygel_dtcp_cleartext_response_new (gint64 start_byte, gint64 end_byte, gint64 total_size, gint64 encrypted_length) {
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	return rygel_dtcp_cleartext_response_construct (RYGEL_TYPE_DTCP_CLEARTEXT_RESPONSE, start_byte, end_byte, total_size, encrypted_length);
#line 274 "rygel-dtcp-cleartext-response.c"
}


RygelDTCPCleartextResponse* rygel_dtcp_cleartext_response_construct_from_request (GType object_type, RygelDTCPCleartextRequest* request, gint64 encrypted_length) {
	RygelDTCPCleartextResponse * self = NULL;
	RygelDTCPCleartextRequest* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	RygelDTCPCleartextRequest* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	RygelDTCPCleartextRequest* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gint64 _tmp8_ = 0LL;
	RygelDTCPCleartextRequest* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	gint64 _tmp11_ = 0LL;
	gint64 _tmp12_ = 0LL;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_return_val_if_fail (request != NULL, NULL);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	self = (RygelDTCPCleartextResponse*) rygel_http_response_element_construct (object_type);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp0_ = request;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp1_ = rygel_dtcp_cleartext_request_get_start_byte (_tmp0_);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp2_ = _tmp1_;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	rygel_dtcp_cleartext_response_set_start_byte (self, _tmp2_);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp3_ = request;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp4_ = rygel_dtcp_cleartext_request_get_end_byte (_tmp3_);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp5_ = _tmp4_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	rygel_dtcp_cleartext_response_set_end_byte (self, _tmp5_);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp6_ = request;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp7_ = rygel_dtcp_cleartext_request_get_range_length (_tmp6_);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp8_ = _tmp7_;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	rygel_dtcp_cleartext_response_set_range_length (self, _tmp8_);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp9_ = request;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp10_ = rygel_dtcp_cleartext_request_get_total_size (_tmp9_);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp11_ = _tmp10_;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	rygel_dtcp_cleartext_response_set_total_size (self, _tmp11_);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp12_ = encrypted_length;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	rygel_dtcp_cleartext_response_set_encrypted_length (self, _tmp12_);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	return self;
#line 335 "rygel-dtcp-cleartext-response.c"
}


RygelDTCPCleartextResponse* rygel_dtcp_cleartext_response_new_from_request (RygelDTCPCleartextRequest* request, gint64 encrypted_length) {
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	return rygel_dtcp_cleartext_response_construct_from_request (RYGEL_TYPE_DTCP_CLEARTEXT_RESPONSE, request, encrypted_length);
#line 342 "rygel-dtcp-cleartext-response.c"
}


static void rygel_dtcp_cleartext_response_real_add_response_headers (RygelHTTPResponseElement* base, RygelHTTPRequest* request) {
	RygelDTCPCleartextResponse * self;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp26_ = 0LL;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	self = (RygelDTCPCleartextResponse*) base;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_return_if_fail (request != NULL);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp0_ = self->priv->_start_byte;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	if (_tmp0_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
#line 358 "rygel-dtcp-cleartext-response.c"
		gchar* _tmp1_ = NULL;
		gint64 _tmp2_ = 0LL;
		gchar* response = NULL;
		gint64 _tmp6_ = 0LL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gint64 _tmp13_ = 0LL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		RygelHTTPRequest* _tmp22_ = NULL;
		SoupMessage* _tmp23_ = NULL;
		SoupMessageHeaders* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp2_ = self->priv->_total_size;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		if (_tmp2_ == RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
#line 386 "rygel-dtcp-cleartext-response.c"
			gchar* _tmp3_ = NULL;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
			_tmp3_ = g_strdup ("*");
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
			_g_free0 (_tmp1_);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
			_tmp1_ = _tmp3_;
#line 394 "rygel-dtcp-cleartext-response.c"
		} else {
			gint64 _tmp4_ = 0LL;
			gchar* _tmp5_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
			_tmp4_ = self->priv->_total_size;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
			_tmp5_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp4_);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
			_g_free0 (_tmp1_);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
			_tmp1_ = _tmp5_;
#line 406 "rygel-dtcp-cleartext-response.c"
		}
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp6_ = self->priv->_start_byte;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp6_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp8_ = _tmp7_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp9_ = g_strconcat ("bytes ", _tmp8_, NULL);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp10_ = _tmp9_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp11_ = g_strconcat (_tmp10_, "-", NULL);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp12_ = _tmp11_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp13_ = self->priv->_end_byte;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp14_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp13_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp15_ = _tmp14_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp16_ = g_strconcat (_tmp12_, _tmp15_, NULL);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp17_ = _tmp16_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp18_ = g_strconcat (_tmp17_, "/", NULL);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp19_ = _tmp18_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp20_ = g_strconcat (_tmp19_, _tmp1_, NULL);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp21_ = _tmp20_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_g_free0 (_tmp19_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_g_free0 (_tmp17_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_g_free0 (_tmp15_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_g_free0 (_tmp12_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_g_free0 (_tmp10_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_g_free0 (_tmp8_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		response = _tmp21_;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp22_ = request;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp23_ = _tmp22_->msg;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp24_ = _tmp23_->response_headers;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp25_ = response;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		soup_message_headers_append (_tmp24_, RYGEL_DTCP_CLEARTEXT_RESPONSE_DTCP_CONTENT_RANGE_HEADER, _tmp25_);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_g_free0 (response);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_g_free0 (_tmp1_);
#line 468 "rygel-dtcp-cleartext-response.c"
	}
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp26_ = self->priv->_encrypted_length;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	if (_tmp26_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
#line 474 "rygel-dtcp-cleartext-response.c"
		RygelHTTPRequest* _tmp27_ = NULL;
		SoupMessage* _tmp28_ = NULL;
		SoupMessageHeaders* _tmp29_ = NULL;
		gint64 _tmp30_ = 0LL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp27_ = request;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp28_ = _tmp27_->msg;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp29_ = _tmp28_->response_headers;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		_tmp30_ = self->priv->_encrypted_length;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		soup_message_headers_set_content_length (_tmp29_, _tmp30_);
#line 489 "rygel-dtcp-cleartext-response.c"
	}
}


static gchar* rygel_dtcp_cleartext_response_real_to_string (RygelHTTPResponseElement* base) {
	RygelDTCPCleartextResponse * self;
	gchar* result = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gchar* _tmp4_ = NULL;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	self = (RygelDTCPCleartextResponse*) base;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp0_ = self->priv->_start_byte;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp1_ = self->priv->_end_byte;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp2_ = self->priv->_total_size;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp3_ = self->priv->_encrypted_length;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp4_ = g_strdup_printf ("DTCPCleartextResponse(bytes=%lld-%lld/%lld, enc_len=%lld)", _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	result = _tmp4_;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	return result;
#line 518 "rygel-dtcp-cleartext-response.c"
}


gint64 rygel_dtcp_cleartext_response_get_start_byte (RygelDTCPCleartextResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp0_ = self->priv->_start_byte;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	result = _tmp0_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	return result;
#line 533 "rygel-dtcp-cleartext-response.c"
}


static void rygel_dtcp_cleartext_response_set_start_byte (RygelDTCPCleartextResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_return_if_fail (self != NULL);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp0_ = value;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	self->priv->_start_byte = _tmp0_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_object_notify ((GObject *) self, "start-byte");
#line 547 "rygel-dtcp-cleartext-response.c"
}


gint64 rygel_dtcp_cleartext_response_get_end_byte (RygelDTCPCleartextResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp0_ = self->priv->_end_byte;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	result = _tmp0_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	return result;
#line 562 "rygel-dtcp-cleartext-response.c"
}


static void rygel_dtcp_cleartext_response_set_end_byte (RygelDTCPCleartextResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_return_if_fail (self != NULL);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp0_ = value;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	self->priv->_end_byte = _tmp0_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_object_notify ((GObject *) self, "end-byte");
#line 576 "rygel-dtcp-cleartext-response.c"
}


gint64 rygel_dtcp_cleartext_response_get_range_length (RygelDTCPCleartextResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp0_ = self->priv->_range_length;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	result = _tmp0_;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	return result;
#line 591 "rygel-dtcp-cleartext-response.c"
}


static void rygel_dtcp_cleartext_response_set_range_length (RygelDTCPCleartextResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_return_if_fail (self != NULL);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp0_ = value;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	self->priv->_range_length = _tmp0_;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_object_notify ((GObject *) self, "range-length");
#line 605 "rygel-dtcp-cleartext-response.c"
}


gint64 rygel_dtcp_cleartext_response_get_total_size (RygelDTCPCleartextResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp0_ = self->priv->_total_size;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	result = _tmp0_;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	return result;
#line 620 "rygel-dtcp-cleartext-response.c"
}


static void rygel_dtcp_cleartext_response_set_total_size (RygelDTCPCleartextResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_return_if_fail (self != NULL);
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp0_ = value;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	self->priv->_total_size = _tmp0_;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_object_notify ((GObject *) self, "total-size");
#line 634 "rygel-dtcp-cleartext-response.c"
}


gint64 rygel_dtcp_cleartext_response_get_encrypted_length (RygelDTCPCleartextResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp0_ = self->priv->_encrypted_length;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	result = _tmp0_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	return result;
#line 649 "rygel-dtcp-cleartext-response.c"
}


void rygel_dtcp_cleartext_response_set_encrypted_length (RygelDTCPCleartextResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_return_if_fail (self != NULL);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	_tmp0_ = value;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	self->priv->_encrypted_length = _tmp0_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_object_notify ((GObject *) self, "encrypted-length");
#line 663 "rygel-dtcp-cleartext-response.c"
}


static void rygel_dtcp_cleartext_response_class_init (RygelDTCPCleartextResponseClass * klass) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	rygel_dtcp_cleartext_response_parent_class = g_type_class_peek_parent (klass);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_type_class_add_private (klass, sizeof (RygelDTCPCleartextResponsePrivate));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	((RygelHTTPResponseElementClass *) klass)->add_response_headers = rygel_dtcp_cleartext_response_real_add_response_headers;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	((RygelHTTPResponseElementClass *) klass)->to_string = rygel_dtcp_cleartext_response_real_to_string;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_dtcp_cleartext_response_get_property;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_dtcp_cleartext_response_set_property;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_dtcp_cleartext_response_finalize;
#line 682 "rygel-dtcp-cleartext-response.c"
	/**
	     * The start of the response range in bytes
	     */
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_RESPONSE_START_BYTE, g_param_spec_int64 ("start-byte", "start-byte", "start-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 688 "rygel-dtcp-cleartext-response.c"
	/**
	     * The end of the range in bytes (inclusive)
	     */
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_RESPONSE_END_BYTE, g_param_spec_int64 ("end-byte", "end-byte", "end-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 694 "rygel-dtcp-cleartext-response.c"
	/**
	     * The length of the range in bytes
	     */
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_RESPONSE_RANGE_LENGTH, g_param_spec_int64 ("range-length", "range-length", "range-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 700 "rygel-dtcp-cleartext-response.c"
	/**
	     * The length of the resource in bytes. May be HTTPSeekRequest.UNSPECIFIED
	     */
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_RESPONSE_TOTAL_SIZE, g_param_spec_int64 ("total-size", "total-size", "total-size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 706 "rygel-dtcp-cleartext-response.c"
	/**
	     * The encrypted length of the response
	     */
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_RESPONSE_ENCRYPTED_LENGTH, g_param_spec_int64 ("encrypted-length", "encrypted-length", "encrypted-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 712 "rygel-dtcp-cleartext-response.c"
}


static void rygel_dtcp_cleartext_response_instance_init (RygelDTCPCleartextResponse * self) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	self->priv = RYGEL_DTCP_CLEARTEXT_RESPONSE_GET_PRIVATE (self);
#line 719 "rygel-dtcp-cleartext-response.c"
}


static void rygel_dtcp_cleartext_response_finalize (GObject* obj) {
	RygelDTCPCleartextResponse * self;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DTCP_CLEARTEXT_RESPONSE, RygelDTCPCleartextResponse);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	G_OBJECT_CLASS (rygel_dtcp_cleartext_response_parent_class)->finalize (obj);
#line 729 "rygel-dtcp-cleartext-response.c"
}


GType rygel_dtcp_cleartext_response_get_type (void) {
	static volatile gsize rygel_dtcp_cleartext_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_dtcp_cleartext_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDTCPCleartextResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_dtcp_cleartext_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDTCPCleartextResponse), 0, (GInstanceInitFunc) rygel_dtcp_cleartext_response_instance_init, NULL };
		GType rygel_dtcp_cleartext_response_type_id;
		rygel_dtcp_cleartext_response_type_id = g_type_register_static (RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, "RygelDTCPCleartextResponse", &g_define_type_info, 0);
		g_once_init_leave (&rygel_dtcp_cleartext_response_type_id__volatile, rygel_dtcp_cleartext_response_type_id);
	}
	return rygel_dtcp_cleartext_response_type_id__volatile;
}


static void _vala_rygel_dtcp_cleartext_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelDTCPCleartextResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DTCP_CLEARTEXT_RESPONSE, RygelDTCPCleartextResponse);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		case RYGEL_DTCP_CLEARTEXT_RESPONSE_START_BYTE:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		g_value_set_int64 (value, rygel_dtcp_cleartext_response_get_start_byte (self));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		case RYGEL_DTCP_CLEARTEXT_RESPONSE_END_BYTE:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		g_value_set_int64 (value, rygel_dtcp_cleartext_response_get_end_byte (self));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		case RYGEL_DTCP_CLEARTEXT_RESPONSE_RANGE_LENGTH:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		g_value_set_int64 (value, rygel_dtcp_cleartext_response_get_range_length (self));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		case RYGEL_DTCP_CLEARTEXT_RESPONSE_TOTAL_SIZE:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		g_value_set_int64 (value, rygel_dtcp_cleartext_response_get_total_size (self));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		case RYGEL_DTCP_CLEARTEXT_RESPONSE_ENCRYPTED_LENGTH:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		g_value_set_int64 (value, rygel_dtcp_cleartext_response_get_encrypted_length (self));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		break;
#line 780 "rygel-dtcp-cleartext-response.c"
		default:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		break;
#line 786 "rygel-dtcp-cleartext-response.c"
	}
}


static void _vala_rygel_dtcp_cleartext_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelDTCPCleartextResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DTCP_CLEARTEXT_RESPONSE, RygelDTCPCleartextResponse);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		case RYGEL_DTCP_CLEARTEXT_RESPONSE_START_BYTE:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		rygel_dtcp_cleartext_response_set_start_byte (self, g_value_get_int64 (value));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		case RYGEL_DTCP_CLEARTEXT_RESPONSE_END_BYTE:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		rygel_dtcp_cleartext_response_set_end_byte (self, g_value_get_int64 (value));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		case RYGEL_DTCP_CLEARTEXT_RESPONSE_RANGE_LENGTH:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		rygel_dtcp_cleartext_response_set_range_length (self, g_value_get_int64 (value));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		case RYGEL_DTCP_CLEARTEXT_RESPONSE_TOTAL_SIZE:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		rygel_dtcp_cleartext_response_set_total_size (self, g_value_get_int64 (value));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		case RYGEL_DTCP_CLEARTEXT_RESPONSE_ENCRYPTED_LENGTH:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		rygel_dtcp_cleartext_response_set_encrypted_length (self, g_value_get_int64 (value));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		break;
#line 826 "rygel-dtcp-cleartext-response.c"
		default:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-response.vala"
		break;
#line 832 "rygel-dtcp-cleartext-response.c"
	}
}



