/* rygel-basic-management.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-basic-management.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Christophe Guiraud,
 *         Jussi Kukkonen
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_BASIC_MANAGEMENT (rygel_basic_management_get_type ())
#define RYGEL_BASIC_MANAGEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagement))
#define RYGEL_BASIC_MANAGEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagementClass))
#define RYGEL_IS_BASIC_MANAGEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT))
#define RYGEL_IS_BASIC_MANAGEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT))
#define RYGEL_BASIC_MANAGEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagementClass))

typedef struct _RygelBasicManagement RygelBasicManagement;
typedef struct _RygelBasicManagementClass RygelBasicManagementClass;
typedef struct _RygelBasicManagementPrivate RygelBasicManagementPrivate;

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST (rygel_basic_management_test_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest))
#define RYGEL_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))

typedef struct _RygelBasicManagementTest RygelBasicManagementTest;
typedef struct _RygelBasicManagementTestClass RygelBasicManagementTestClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _RygelBasicManagementTestPrivate RygelBasicManagementTestPrivate;

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_INIT_STATE (rygel_basic_management_test_init_state_get_type ())
typedef struct _Block1Data Block1Data;

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_EXECUTION_STATE (rygel_basic_management_test_execution_state_get_type ())

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING (rygel_basic_management_test_ping_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST_PING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPing))
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPingClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_PING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_PING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING))
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPingClass))

typedef struct _RygelBasicManagementTestPing RygelBasicManagementTestPing;
typedef struct _RygelBasicManagementTestPingClass RygelBasicManagementTestPingClass;

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP (rygel_basic_management_test_ns_lookup_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookup))
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookupClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_NS_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_NS_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP))
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookupClass))

typedef struct _RygelBasicManagementTestNSLookup RygelBasicManagementTestNSLookup;
typedef struct _RygelBasicManagementTestNSLookupClass RygelBasicManagementTestNSLookupClass;

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE (rygel_basic_management_test_traceroute_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTraceroute))
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTracerouteClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_TRACEROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_TRACEROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE))
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTracerouteClass))

typedef struct _RygelBasicManagementTestTraceroute RygelBasicManagementTestTraceroute;
typedef struct _RygelBasicManagementTestTracerouteClass RygelBasicManagementTestTracerouteClass;

struct _RygelBasicManagement {
	GUPnPService parent_instance;
	RygelBasicManagementPrivate * priv;
	gchar* device_status;
};

struct _RygelBasicManagementClass {
	GUPnPServiceClass parent_class;
};

struct _RygelBasicManagementPrivate {
	guint _max_history_size;
	GeeHashMap* tests_map;
	GeeHashMap* test_ids_by_type;
	guint current_id;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_OK,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER
} RygelBasicManagementTestInitState;

struct _RygelBasicManagementTest {
	GObject parent_instance;
	RygelBasicManagementTestPrivate * priv;
	GCancellable* _cancellable;
	RygelBasicManagementTestInitState init_state;
	gchar* id;
	guint iterations;
	GSpawnFlags flags;
	gchar** command;
	gint command_length1;
	gint _command_size_;
};

struct _RygelBasicManagementTestClass {
	GObjectClass parent_class;
	void (*init_iteration) (RygelBasicManagementTest* self);
	void (*handle_output) (RygelBasicManagementTest* self, const gchar* line);
	void (*handle_error) (RygelBasicManagementTest* self, const gchar* line);
	gboolean (*finish_iteration) (RygelBasicManagementTest* self);
	void (*run) (RygelBasicManagementTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelBasicManagementTest* self, GAsyncResult* _res_);
	const gchar* (*get_method_type) (RygelBasicManagementTest* self);
	const gchar* (*get_results_type) (RygelBasicManagementTest* self);
};

struct _Block1Data {
	int _ref_count_;
	RygelBasicManagement* self;
	RygelBasicManagementTest* bm_test;
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_REQUESTED,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_IN_PROGRESS,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_CANCELED
} RygelBasicManagementTestExecutionState;


static gpointer rygel_basic_management_parent_class = NULL;

GType rygel_basic_management_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_get_type (void) G_GNUC_CONST;
#define RYGEL_BASIC_MANAGEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagementPrivate))
enum  {
	RYGEL_BASIC_MANAGEMENT_DUMMY_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_MAX_HISTORY_SIZE
};
#define RYGEL_BASIC_MANAGEMENT_UPNP_ID "urn:upnp-org:serviceId:BasicManagement"
#define RYGEL_BASIC_MANAGEMENT_UPNP_TYPE "urn:schemas-upnp-org:service:BasicManagement:2"
#define RYGEL_BASIC_MANAGEMENT_DESCRIPTION_PATH "xml/BasicManagement2.xml"
static void rygel_basic_management_real_constructed (GObject* base);
static void rygel_basic_management_query_device_status_cb (RygelBasicManagement* self, GUPnPService* bm, const gchar* var, GValue* val);
static void _rygel_basic_management_query_device_status_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_basic_management_query_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, const gchar* var, GValue* val);
static void _rygel_basic_management_query_test_ids_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_basic_management_query_active_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, const gchar* var, GValue* val);
static void _rygel_basic_management_query_active_test_ids_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_basic_management_get_device_status_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_get_device_status_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_ping_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_ping_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_ping_result_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_ping_result_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_nslookup_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_nslookup_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_nslookup_result_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_nslookup_result_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_traceroute_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_traceroute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_traceroute_result_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_traceroute_result_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_get_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_get_test_ids_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_get_active_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_get_active_test_ids_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_get_test_info_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_get_test_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_cancel_test_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_cancel_test_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static gchar* rygel_basic_management_create_test_ids_list (RygelBasicManagement* self, gboolean active_only);
gboolean rygel_basic_management_test_is_active (RygelBasicManagementTest* self);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_init_state_get_type (void) G_GNUC_CONST;
static gchar* rygel_basic_management_add_test (RygelBasicManagement* self, RygelBasicManagementTest* test);
const gchar* rygel_basic_management_test_get_method_type (RygelBasicManagementTest* self);
guint rygel_basic_management_get_max_history_size (RygelBasicManagement* self);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_basic_management_add_test_and_return_action (RygelBasicManagement* self, RygelBasicManagementTest* bm_test, GUPnPServiceAction* action);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void rygel_basic_management_test_run (RygelBasicManagementTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_basic_management_test_run_finish (RygelBasicManagementTest* self, GAsyncResult* _res_);
static void __lambda5_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res);
static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean rygel_basic_management_ensure_test_exists (RygelBasicManagement* self, GUPnPServiceAction* action, RygelBasicManagementTest** bm_test);
const gchar* rygel_basic_management_test_get_results_type (RygelBasicManagementTest* self);
GType rygel_basic_management_test_execution_state_get_type (void) G_GNUC_CONST;
RygelBasicManagementTestExecutionState rygel_basic_management_test_get_execution_state (RygelBasicManagementTest* self);
gchar* rygel_basic_management_test_execution_state_to_string (RygelBasicManagementTestExecutionState self);
GType rygel_basic_management_test_ping_get_type (void) G_GNUC_CONST;
RygelBasicManagementTestPing* rygel_basic_management_test_ping_new (const gchar* host, guint repeat_count, guint32 interval_time_out, guint data_block_size, guint dscp);
RygelBasicManagementTestPing* rygel_basic_management_test_ping_construct (GType object_type, const gchar* host, guint repeat_count, guint32 interval_time_out, guint data_block_size, guint dscp);
void rygel_basic_management_test_ping_get_results (RygelBasicManagementTestPing* self, gchar** status, gchar** additional_info, guint* success_count, guint* failure_count, guint32* avg_response_time, guint32* min_response_time, guint32* max_response_time);
GType rygel_basic_management_test_ns_lookup_get_type (void) G_GNUC_CONST;
RygelBasicManagementTestNSLookup* rygel_basic_management_test_ns_lookup_new (const gchar* host_name, const gchar* name_server, guint repetitions, guint32 interval_time_out);
RygelBasicManagementTestNSLookup* rygel_basic_management_test_ns_lookup_construct (GType object_type, const gchar* host_name, const gchar* name_server, guint repetitions, guint32 interval_time_out);
void rygel_basic_management_test_ns_lookup_get_results (RygelBasicManagementTestNSLookup* self, gchar** status, gchar** additional_info, guint* success_count, gchar** result_string);
GType rygel_basic_management_test_traceroute_get_type (void) G_GNUC_CONST;
RygelBasicManagementTestTraceroute* rygel_basic_management_test_traceroute_new (const gchar* host, guint32 wait_time_out, guint data_block_size, guint max_hop_count, guint dscp);
RygelBasicManagementTestTraceroute* rygel_basic_management_test_traceroute_construct (GType object_type, const gchar* host, guint32 wait_time_out, guint data_block_size, guint max_hop_count, guint dscp);
void rygel_basic_management_test_traceroute_get_results (RygelBasicManagementTestTraceroute* self, gchar** status, gchar** additional_info, guint32* response_time, gchar** hop_ips);
RygelBasicManagement* rygel_basic_management_new (void);
RygelBasicManagement* rygel_basic_management_construct (GType object_type);
void rygel_basic_management_set_max_history_size (RygelBasicManagement* self, guint value);
static void rygel_basic_management_finalize (GObject* obj);
static void _vala_rygel_basic_management_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_basic_management_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _rygel_basic_management_query_device_status_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 55 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_query_device_status_cb ((RygelBasicManagement*) self, _sender, variable, value);
#line 259 "rygel-basic-management.c"
}


static void _rygel_basic_management_query_test_ids_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 57 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_query_test_ids_cb ((RygelBasicManagement*) self, _sender, variable, value);
#line 266 "rygel-basic-management.c"
}


static void _rygel_basic_management_query_active_test_ids_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 58 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_query_active_test_ids_cb ((RygelBasicManagement*) self, _sender, variable, value);
#line 273 "rygel-basic-management.c"
}


static void _rygel_basic_management_get_device_status_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 61 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_get_device_status_cb ((RygelBasicManagement*) self, _sender, action);
#line 280 "rygel-basic-management.c"
}


static void _rygel_basic_management_ping_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_ping_cb ((RygelBasicManagement*) self, _sender, action);
#line 287 "rygel-basic-management.c"
}


static void _rygel_basic_management_ping_result_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_ping_result_cb ((RygelBasicManagement*) self, _sender, action);
#line 294 "rygel-basic-management.c"
}


static void _rygel_basic_management_nslookup_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 65 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_nslookup_cb ((RygelBasicManagement*) self, _sender, action);
#line 301 "rygel-basic-management.c"
}


static void _rygel_basic_management_nslookup_result_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 66 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_nslookup_result_cb ((RygelBasicManagement*) self, _sender, action);
#line 308 "rygel-basic-management.c"
}


static void _rygel_basic_management_traceroute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_traceroute_cb ((RygelBasicManagement*) self, _sender, action);
#line 315 "rygel-basic-management.c"
}


static void _rygel_basic_management_traceroute_result_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_traceroute_result_cb ((RygelBasicManagement*) self, _sender, action);
#line 322 "rygel-basic-management.c"
}


static void _rygel_basic_management_get_test_ids_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_get_test_ids_cb ((RygelBasicManagement*) self, _sender, action);
#line 329 "rygel-basic-management.c"
}


static void _rygel_basic_management_get_active_test_ids_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 72 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_get_active_test_ids_cb ((RygelBasicManagement*) self, _sender, action);
#line 336 "rygel-basic-management.c"
}


static void _rygel_basic_management_get_test_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 74 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_get_test_info_cb ((RygelBasicManagement*) self, _sender, action);
#line 343 "rygel-basic-management.c"
}


static void _rygel_basic_management_cancel_test_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_cancel_test_cb ((RygelBasicManagement*) self, _sender, action);
#line 350 "rygel-basic-management.c"
}


static void rygel_basic_management_real_constructed (GObject* base) {
	RygelBasicManagement * self;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GTimeVal now = {0};
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	self = (RygelBasicManagement*) base;
#line 45 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	G_OBJECT_CLASS (rygel_basic_management_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_service_get_type (), GUPnPService));
#line 47 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 47 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_object_unref0 (self->priv->tests_map);
#line 47 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	self->priv->tests_map = _tmp0_;
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_LINKED_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_object_unref0 (self->priv->test_ids_by_type);
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	self->priv->test_ids_by_type = _tmp1_;
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_get_current_time (&now);
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	now.tv_usec = (glong) 0;
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp2_ = g_time_val_to_iso8601 (&now);
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp3_ = _tmp2_;
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp4_ = g_strconcat ("OK,", _tmp3_, NULL);
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (self->device_status);
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	self->device_status = _tmp4_;
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (_tmp3_);
#line 55 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::DeviceStatus", (GCallback) _rygel_basic_management_query_device_status_cb_gupnp_service_query_variable, self, 0);
#line 57 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::TestIDs", (GCallback) _rygel_basic_management_query_test_ids_cb_gupnp_service_query_variable, self, 0);
#line 58 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::ActiveTestIDs", (GCallback) _rygel_basic_management_query_active_test_ids_cb_gupnp_service_query_variable, self, 0);
#line 61 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetDeviceStatus", (GCallback) _rygel_basic_management_get_device_status_cb_gupnp_service_action_invoked, self, 0);
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Ping", (GCallback) _rygel_basic_management_ping_cb_gupnp_service_action_invoked, self, 0);
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetPingResult", (GCallback) _rygel_basic_management_ping_result_cb_gupnp_service_action_invoked, self, 0);
#line 65 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::NSLookup", (GCallback) _rygel_basic_management_nslookup_cb_gupnp_service_action_invoked, self, 0);
#line 66 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetNSLookupResult", (GCallback) _rygel_basic_management_nslookup_result_cb_gupnp_service_action_invoked, self, 0);
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Traceroute", (GCallback) _rygel_basic_management_traceroute_cb_gupnp_service_action_invoked, self, 0);
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTracerouteResult", (GCallback) _rygel_basic_management_traceroute_result_cb_gupnp_service_action_invoked, self, 0);
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTestIDs", (GCallback) _rygel_basic_management_get_test_ids_cb_gupnp_service_action_invoked, self, 0);
#line 72 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetActiveTestIDs", (GCallback) _rygel_basic_management_get_active_test_ids_cb_gupnp_service_action_invoked, self, 0);
#line 74 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTestInfo", (GCallback) _rygel_basic_management_get_test_info_cb_gupnp_service_action_invoked, self, 0);
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::CancelTest", (GCallback) _rygel_basic_management_cancel_test_cb_gupnp_service_action_invoked, self, 0);
#line 422 "rygel-basic-management.c"
}


static gchar* rygel_basic_management_create_test_ids_list (RygelBasicManagement* self, gboolean active_only) {
	gchar* result = NULL;
	gchar* test_ids_list = NULL;
	gchar* _tmp0_ = NULL;
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 79 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = g_strdup ("");
#line 79 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	test_ids_list = _tmp0_;
#line 436 "rygel-basic-management.c"
	{
		GeeIterator* _test_it = NULL;
		GeeHashMap* _tmp1_ = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp1_ = self->priv->tests_map;
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp2_ = gee_abstract_map_get_values ((GeeMap*) _tmp1_);
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp3_ = _tmp2_;
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp4_ = _tmp3_;
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp6_ = _tmp5_;
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_g_object_unref0 (_tmp4_);
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_test_it = _tmp6_;
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		while (TRUE) {
#line 463 "rygel-basic-management.c"
			GeeIterator* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			RygelBasicManagementTest* test = NULL;
			GeeIterator* _tmp9_ = NULL;
			gpointer _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			const gchar* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			const gchar* _tmp20_ = NULL;
			RygelBasicManagementTest* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_tmp7_ = _test_it;
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_tmp8_ = gee_iterator_next (_tmp7_);
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			if (!_tmp8_) {
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				break;
#line 486 "rygel-basic-management.c"
			}
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_tmp9_ = _test_it;
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_tmp10_ = gee_iterator_get (_tmp9_);
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			test = (RygelBasicManagementTest*) _tmp10_;
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_tmp12_ = active_only;
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			if (_tmp12_) {
#line 498 "rygel-basic-management.c"
				RygelBasicManagementTest* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp13_ = test;
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp14_ = rygel_basic_management_test_is_active (_tmp13_);
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp11_ = !_tmp14_;
#line 507 "rygel-basic-management.c"
			} else {
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp11_ = FALSE;
#line 511 "rygel-basic-management.c"
			}
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			if (_tmp11_) {
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_g_object_unref0 (test);
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				continue;
#line 519 "rygel-basic-management.c"
			}
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_tmp15_ = test_ids_list;
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_tmp16_ = strlen (_tmp15_);
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_tmp17_ = _tmp16_;
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			if (_tmp17_ > 0) {
#line 529 "rygel-basic-management.c"
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp18_ = test_ids_list;
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp19_ = g_strconcat (_tmp18_, ",", NULL);
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_g_free0 (test_ids_list);
#line 87 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				test_ids_list = _tmp19_;
#line 540 "rygel-basic-management.c"
			}
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_tmp20_ = test_ids_list;
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_tmp21_ = test;
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_tmp22_ = _tmp21_->id;
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_tmp23_ = g_strconcat (_tmp20_, _tmp22_, NULL);
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_g_free0 (test_ids_list);
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			test_ids_list = _tmp23_;
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_g_object_unref0 (test);
#line 556 "rygel-basic-management.c"
		}
#line 81 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_g_object_unref0 (_test_it);
#line 560 "rygel-basic-management.c"
	}
#line 93 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	result = test_ids_list;
#line 93 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	return result;
#line 566 "rygel-basic-management.c"
}


static gchar* rygel_basic_management_add_test (RygelBasicManagement* self, RygelBasicManagementTest* test) {
	gchar* result = NULL;
	guint _tmp0_ = 0U;
	RygelBasicManagementTest* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gchar* _tmp3_ = NULL;
	GeeHashMap* _tmp4_ = NULL;
	RygelBasicManagementTest* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	RygelBasicManagementTest* _tmp7_ = NULL;
	GeeLinkedList* type_test_ids = NULL;
	GeeHashMap* _tmp8_ = NULL;
	RygelBasicManagementTest* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gpointer _tmp12_ = NULL;
	GeeLinkedList* _tmp13_ = NULL;
	GeeLinkedList* _tmp20_ = NULL;
	RygelBasicManagementTest* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	GeeLinkedList* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	guint _tmp26_ = 0U;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	RygelBasicManagementTest* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
#line 96 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 96 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_val_if_fail (test != NULL, NULL);
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = self->priv->current_id;
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	self->priv->current_id = _tmp0_ + 1;
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp1_ = test;
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp2_ = self->priv->current_id;
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp3_ = g_strdup_printf ("%u", _tmp2_);
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (_tmp1_->id);
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp1_->id = _tmp3_;
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp4_ = self->priv->tests_map;
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp5_ = test;
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp6_ = _tmp5_->id;
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp7_ = test;
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp4_, _tmp6_, _tmp7_);
#line 105 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp8_ = self->priv->test_ids_by_type;
#line 105 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp9_ = test;
#line 105 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp10_ = rygel_basic_management_test_get_method_type (_tmp9_);
#line 105 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp11_ = _tmp10_;
#line 105 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, _tmp11_);
#line 105 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_object_unref0 (type_test_ids);
#line 105 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	type_test_ids = (GeeLinkedList*) _tmp12_;
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp13_ = type_test_ids;
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (_tmp13_ == NULL) {
#line 647 "rygel-basic-management.c"
		GeeLinkedList* _tmp14_ = NULL;
		GeeHashMap* _tmp15_ = NULL;
		RygelBasicManagementTest* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		GeeLinkedList* _tmp19_ = NULL;
#line 107 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp14_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 107 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_g_object_unref0 (type_test_ids);
#line 107 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		type_test_ids = _tmp14_;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp15_ = self->priv->test_ids_by_type;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp16_ = test;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp17_ = rygel_basic_management_test_get_method_type (_tmp16_);
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp18_ = _tmp17_;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp19_ = type_test_ids;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp18_, _tmp19_);
#line 672 "rygel-basic-management.c"
	}
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp20_ = type_test_ids;
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp21_ = test;
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp22_ = _tmp21_->id;
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp22_);
#line 113 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp23_ = type_test_ids;
#line 113 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp24_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp23_);
#line 113 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp25_ = _tmp24_;
#line 113 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp26_ = self->priv->_max_history_size;
#line 113 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (((guint) _tmp25_) > _tmp26_) {
#line 692 "rygel-basic-management.c"
		gchar* old_id = NULL;
		GeeLinkedList* _tmp27_ = NULL;
		gpointer _tmp28_ = NULL;
		GeeHashMap* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gpointer _tmp31_ = NULL;
		RygelBasicManagementTest* _tmp32_ = NULL;
		GCancellable* _tmp33_ = NULL;
		GCancellable* _tmp34_ = NULL;
		GeeHashMap* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
#line 114 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp27_ = type_test_ids;
#line 114 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp28_ = gee_deque_poll_head ((GeeDeque*) _tmp27_);
#line 114 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		old_id = (gchar*) _tmp28_;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp29_ = self->priv->tests_map;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp30_ = old_id;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp31_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp29_, _tmp30_);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp32_ = (RygelBasicManagementTest*) _tmp31_;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp33_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _tmp32_);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp34_ = _tmp33_;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		g_cancellable_cancel (_tmp34_);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_g_object_unref0 (_tmp32_);
#line 117 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp35_ = self->priv->tests_map;
#line 117 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp36_ = old_id;
#line 117 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp35_, _tmp36_, NULL);
#line 113 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_g_free0 (old_id);
#line 734 "rygel-basic-management.c"
	}
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp37_ = rygel_basic_management_create_test_ids_list (self, FALSE);
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp38_ = _tmp37_;
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_notify ((GUPnPService*) self, "TestIDs", G_TYPE_STRING, _tmp38_, NULL);
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (_tmp38_);
#line 121 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp39_ = rygel_basic_management_create_test_ids_list (self, TRUE);
#line 121 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp40_ = _tmp39_;
#line 121 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_notify ((GUPnPService*) self, "ActiveTestIDs", G_TYPE_STRING, _tmp40_, NULL);
#line 121 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (_tmp40_);
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp41_ = test;
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp42_ = _tmp41_->id;
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp43_ = g_strdup (_tmp42_);
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	result = _tmp43_;
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_object_unref0 (type_test_ids);
#line 125 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	return result;
#line 764 "rygel-basic-management.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	return self ? g_object_ref (self) : NULL;
#line 771 "rygel-basic-management.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	return _data1_;
#line 780 "rygel-basic-management.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 789 "rygel-basic-management.c"
		RygelBasicManagement* self;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		self = _data1_->self;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_g_object_unref0 (_data1_->bm_test);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_g_object_unref0 (self);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		g_slice_free (Block1Data, _data1_);
#line 799 "rygel-basic-management.c"
	}
}


static void __lambda5_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res) {
	RygelBasicManagement* self;
	RygelBasicManagementTest* _tmp0_ = NULL;
	GAsyncResult* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	self = _data1_->self;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (res != NULL);
#line 136 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = _data1_->bm_test;
#line 136 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp1_ = res;
#line 136 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_test_run_finish (_tmp0_, _tmp1_);
#line 137 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp2_ = rygel_basic_management_create_test_ids_list (self, TRUE);
#line 137 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp3_ = _tmp2_;
#line 137 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_notify ((GUPnPService*) self, "ActiveTestIDs", G_TYPE_STRING, _tmp3_, NULL);
#line 137 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (_tmp3_);
#line 828 "rygel-basic-management.c"
}


static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	__lambda5_ (self, source_object, res);
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	block1_data_unref (self);
#line 837 "rygel-basic-management.c"
}


static void rygel_basic_management_add_test_and_return_action (RygelBasicManagement* self, RygelBasicManagementTest* bm_test, GUPnPServiceAction* action) {
	Block1Data* _data1_;
	RygelBasicManagementTest* _tmp0_ = NULL;
	RygelBasicManagementTest* _tmp1_ = NULL;
	gchar* id = NULL;
	RygelBasicManagementTest* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	RygelBasicManagementTest* _tmp4_ = NULL;
	GUPnPServiceAction* _tmp5_ = NULL;
	GUPnPServiceAction* _tmp6_ = NULL;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (self != NULL);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (bm_test != NULL);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (action != NULL);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_data1_->_ref_count_ = 1;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_data1_->self = g_object_ref (self);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = bm_test;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_object_unref0 (_data1_->bm_test);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_data1_->bm_test = _tmp1_;
#line 130 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp2_ = _data1_->bm_test;
#line 130 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp3_ = rygel_basic_management_add_test (self, _tmp2_);
#line 130 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	id = _tmp3_;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp4_ = _data1_->bm_test;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_test_run (_tmp4_, ___lambda5__gasync_ready_callback, block1_data_ref (_data1_));
#line 142 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp5_ = action;
#line 142 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_action_set (_tmp5_, "TestID", G_TYPE_STRING, id, NULL);
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp6_ = action;
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_action_return (_tmp6_);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (id);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	block1_data_unref (_data1_);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_data1_ = NULL;
#line 895 "rygel-basic-management.c"
}


static gboolean rygel_basic_management_ensure_test_exists (RygelBasicManagement* self, GUPnPServiceAction* action, RygelBasicManagementTest** bm_test) {
	RygelBasicManagementTest* _vala_bm_test = NULL;
	gboolean result = FALSE;
	gchar* test_id = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	gchar* action_name = NULL;
	GUPnPServiceAction* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	RygelBasicManagementTest* _tmp7_ = NULL;
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_val_if_fail (action != NULL, FALSE);
#line 152 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = action;
#line 152 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_action_get (_tmp0_, "TestID", G_TYPE_STRING, &test_id, NULL);
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp1_ = self->priv->tests_map;
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp2_ = test_id;
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp2_);
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_object_unref0 (_vala_bm_test);
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_vala_bm_test = (RygelBasicManagementTest*) _tmp3_;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp4_ = action;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp5_ = gupnp_service_action_get_name (_tmp4_);
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	action_name = _tmp6_;
#line 157 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp7_ = _vala_bm_test;
#line 157 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (_tmp7_ == NULL) {
#line 942 "rygel-basic-management.c"
		GUPnPServiceAction* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp8_ = action;
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp9_ = _ ("No Such Test");
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		gupnp_service_action_return_error (_tmp8_, (guint) 706, _tmp9_);
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		result = FALSE;
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_g_free0 (action_name);
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_g_free0 (test_id);
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		if (bm_test) {
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			*bm_test = _vala_bm_test;
#line 961 "rygel-basic-management.c"
		} else {
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_g_object_unref0 (_vala_bm_test);
#line 965 "rygel-basic-management.c"
		}
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		return result;
#line 969 "rygel-basic-management.c"
	} else {
		gboolean _tmp10_ = FALSE;
		RygelBasicManagementTest* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 162 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp11_ = _vala_bm_test;
#line 162 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp12_ = rygel_basic_management_test_get_results_type (_tmp11_);
#line 162 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp13_ = _tmp12_;
#line 162 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp14_ = action_name;
#line 162 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		if (g_strcmp0 (_tmp13_, _tmp14_) != 0) {
#line 986 "rygel-basic-management.c"
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_ = FALSE;
			const gchar* _tmp17_ = NULL;
#line 163 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_tmp17_ = action_name;
#line 163 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			if (g_strcmp0 (_tmp17_, "GetPingResult") == 0) {
#line 163 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp16_ = TRUE;
#line 996 "rygel-basic-management.c"
			} else {
				const gchar* _tmp18_ = NULL;
#line 164 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp18_ = action_name;
#line 164 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp16_ = g_strcmp0 (_tmp18_, "GetNSLookupResult") == 0;
#line 1003 "rygel-basic-management.c"
			}
#line 163 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			if (_tmp16_) {
#line 163 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp15_ = TRUE;
#line 1009 "rygel-basic-management.c"
			} else {
				const gchar* _tmp19_ = NULL;
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp19_ = action_name;
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp15_ = g_strcmp0 (_tmp19_, "GetTracerouteResult") == 0;
#line 1016 "rygel-basic-management.c"
			}
#line 163 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_tmp10_ = _tmp15_;
#line 1020 "rygel-basic-management.c"
		} else {
#line 162 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_tmp10_ = FALSE;
#line 1024 "rygel-basic-management.c"
		}
#line 162 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		if (_tmp10_) {
#line 1028 "rygel-basic-management.c"
			GUPnPServiceAction* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_tmp20_ = action;
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_tmp21_ = _ ("Wrong Test Type");
#line 167 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			gupnp_service_action_return_error (_tmp20_, (guint) 707, _tmp21_);
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			result = FALSE;
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_g_free0 (action_name);
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_g_free0 (test_id);
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			if (bm_test) {
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				*bm_test = _vala_bm_test;
#line 1047 "rygel-basic-management.c"
			} else {
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_g_object_unref0 (_vala_bm_test);
#line 1051 "rygel-basic-management.c"
			}
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			return result;
#line 1055 "rygel-basic-management.c"
		} else {
			gboolean _tmp22_ = FALSE;
			RygelBasicManagementTest* _tmp23_ = NULL;
			RygelBasicManagementTestExecutionState _tmp24_ = 0;
			RygelBasicManagementTestExecutionState _tmp25_ = 0;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_tmp23_ = _vala_bm_test;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_tmp24_ = rygel_basic_management_test_get_execution_state (_tmp23_);
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			_tmp25_ = _tmp24_;
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			if (_tmp25_ != RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED) {
#line 1069 "rygel-basic-management.c"
				gboolean _tmp26_ = FALSE;
				gboolean _tmp27_ = FALSE;
				const gchar* _tmp28_ = NULL;
#line 171 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp28_ = action_name;
#line 171 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				if (g_strcmp0 (_tmp28_, "GetPingResult") == 0) {
#line 171 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_tmp27_ = TRUE;
#line 1079 "rygel-basic-management.c"
				} else {
					const gchar* _tmp29_ = NULL;
#line 172 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_tmp29_ = action_name;
#line 172 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_tmp27_ = g_strcmp0 (_tmp29_, "GetNSLookupResult") == 0;
#line 1086 "rygel-basic-management.c"
				}
#line 171 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				if (_tmp27_) {
#line 171 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_tmp26_ = TRUE;
#line 1092 "rygel-basic-management.c"
				} else {
					const gchar* _tmp30_ = NULL;
#line 173 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_tmp30_ = action_name;
#line 173 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_tmp26_ = g_strcmp0 (_tmp30_, "GetTracerouteResult") == 0;
#line 1099 "rygel-basic-management.c"
				}
#line 171 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp22_ = _tmp26_;
#line 1103 "rygel-basic-management.c"
			} else {
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp22_ = FALSE;
#line 1107 "rygel-basic-management.c"
			}
#line 170 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
			if (_tmp22_) {
#line 1111 "rygel-basic-management.c"
				GUPnPServiceAction* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				RygelBasicManagementTest* _tmp33_ = NULL;
				RygelBasicManagementTestExecutionState _tmp34_ = 0;
				RygelBasicManagementTestExecutionState _tmp35_ = 0;
				gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				gchar* _tmp39_ = NULL;
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp31_ = action;
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp32_ = _ ("Invalid Test State '%s'");
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp33_ = _vala_bm_test;
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp34_ = rygel_basic_management_test_get_execution_state (_tmp33_);
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp35_ = _tmp34_;
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp36_ = rygel_basic_management_test_execution_state_to_string (_tmp35_);
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp37_ = _tmp36_;
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp38_ = g_strdup_printf (_tmp32_, _tmp37_);
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp39_ = _tmp38_;
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				gupnp_service_action_return_error (_tmp31_, (guint) 708, _tmp39_);
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_g_free0 (_tmp39_);
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_g_free0 (_tmp37_);
#line 178 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				result = FALSE;
#line 178 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_g_free0 (action_name);
#line 178 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_g_free0 (test_id);
#line 178 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				if (bm_test) {
#line 178 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					*bm_test = _vala_bm_test;
#line 1155 "rygel-basic-management.c"
				} else {
#line 178 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_g_object_unref0 (_vala_bm_test);
#line 1159 "rygel-basic-management.c"
				}
#line 178 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				return result;
#line 1163 "rygel-basic-management.c"
			} else {
				gboolean _tmp40_ = FALSE;
				const gchar* _tmp41_ = NULL;
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				_tmp41_ = action_name;
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				if (g_strcmp0 (_tmp41_, "CancelTest") == 0) {
#line 1171 "rygel-basic-management.c"
					RygelBasicManagementTest* _tmp42_ = NULL;
					gboolean _tmp43_ = FALSE;
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_tmp42_ = _vala_bm_test;
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_tmp43_ = rygel_basic_management_test_is_active (_tmp42_);
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_tmp40_ = !_tmp43_;
#line 1180 "rygel-basic-management.c"
				} else {
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_tmp40_ = FALSE;
#line 1184 "rygel-basic-management.c"
				}
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
				if (_tmp40_) {
#line 1188 "rygel-basic-management.c"
					GUPnPServiceAction* _tmp44_ = NULL;
					const gchar* _tmp45_ = NULL;
					RygelBasicManagementTest* _tmp46_ = NULL;
					RygelBasicManagementTestExecutionState _tmp47_ = 0;
					RygelBasicManagementTestExecutionState _tmp48_ = 0;
					gchar* _tmp49_ = NULL;
					gchar* _tmp50_ = NULL;
					gchar* _tmp51_ = NULL;
					gchar* _tmp52_ = NULL;
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_tmp44_ = action;
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_tmp45_ = _ ("State '%s' Precludes Cancel");
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_tmp46_ = _vala_bm_test;
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_tmp47_ = rygel_basic_management_test_get_execution_state (_tmp46_);
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_tmp48_ = _tmp47_;
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_tmp49_ = rygel_basic_management_test_execution_state_to_string (_tmp48_);
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_tmp50_ = _tmp49_;
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_tmp51_ = g_strdup_printf (_tmp45_, _tmp50_);
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_tmp52_ = _tmp51_;
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					gupnp_service_action_return_error (_tmp44_, (guint) 709, _tmp52_);
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_g_free0 (_tmp52_);
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_g_free0 (_tmp50_);
#line 184 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					result = FALSE;
#line 184 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_g_free0 (action_name);
#line 184 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					_g_free0 (test_id);
#line 184 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					if (bm_test) {
#line 184 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
						*bm_test = _vala_bm_test;
#line 1232 "rygel-basic-management.c"
					} else {
#line 184 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
						_g_object_unref0 (_vala_bm_test);
#line 1236 "rygel-basic-management.c"
					}
#line 184 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
					return result;
#line 1240 "rygel-basic-management.c"
				}
			}
		}
	}
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	result = TRUE;
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (action_name);
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (test_id);
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (bm_test) {
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		*bm_test = _vala_bm_test;
#line 1255 "rygel-basic-management.c"
	} else {
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_g_object_unref0 (_vala_bm_test);
#line 1259 "rygel-basic-management.c"
	}
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	return result;
#line 1263 "rygel-basic-management.c"
}


static void rygel_basic_management_query_device_status_cb (RygelBasicManagement* self, GUPnPService* bm, const gchar* var, GValue* val) {
	const gchar* _tmp0_ = NULL;
#line 190 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (self != NULL);
#line 190 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (bm != NULL);
#line 190 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (var != NULL);
#line 190 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (val != NULL);
#line 193 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_value_init (val, G_TYPE_STRING);
#line 194 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = self->device_status;
#line 194 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_value_set_string (val, _tmp0_);
#line 1283 "rygel-basic-management.c"
}


static void rygel_basic_management_query_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, const gchar* var, GValue* val) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (self != NULL);
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (bm != NULL);
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (var != NULL);
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (val != NULL);
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_value_init (val, G_TYPE_STRING);
#line 201 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = rygel_basic_management_create_test_ids_list (self, FALSE);
#line 201 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp1_ = _tmp0_;
#line 201 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_value_set_string (val, _tmp1_);
#line 201 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (_tmp1_);
#line 1308 "rygel-basic-management.c"
}


static void rygel_basic_management_query_active_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, const gchar* var, GValue* val) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (self != NULL);
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (bm != NULL);
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (var != NULL);
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (val != NULL);
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_value_init (val, G_TYPE_STRING);
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = rygel_basic_management_create_test_ids_list (self, TRUE);
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp1_ = _tmp0_;
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_value_set_string (val, _tmp1_);
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (_tmp1_);
#line 1333 "rygel-basic-management.c"
}


static void rygel_basic_management_get_device_status_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GUPnPServiceAction* _tmp6_ = NULL;
#line 211 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (self != NULL);
#line 211 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (bm != NULL);
#line 211 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (action != NULL);
#line 213 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = action;
#line 213 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 213 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 1355 "rygel-basic-management.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp2_ = action;
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp3_ = _ ("Invalid argument");
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 216 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		return;
#line 1366 "rygel-basic-management.c"
	}
#line 219 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp4_ = action;
#line 219 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp5_ = self->device_status;
#line 219 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_action_set (_tmp4_, "DeviceStatus", G_TYPE_STRING, _tmp5_, NULL);
#line 223 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp6_ = action;
#line 223 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_action_return (_tmp6_);
#line 1378 "rygel-basic-management.c"
}


static void rygel_basic_management_ping_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gchar* host = NULL;
	guint repeat_count = 0U;
	guint data_block_size = 0U;
	guint dscp = 0U;
	guint32 interval_time_out = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	RygelBasicManagementTestPing* ping = NULL;
	const gchar* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	guint32 _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	RygelBasicManagementTestPing* _tmp14_ = NULL;
	RygelBasicManagementTestPing* _tmp15_ = NULL;
	GUPnPServiceAction* _tmp16_ = NULL;
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (self != NULL);
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (bm != NULL);
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (action != NULL);
#line 228 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = action;
#line 228 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 228 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (_tmp1_ != ((guint) 5)) {
#line 1413 "rygel-basic-management.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 229 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp2_ = action;
#line 229 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp3_ = _ ("Invalid argument");
#line 229 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 231 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		return;
#line 1424 "rygel-basic-management.c"
	}
#line 238 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp4_ = action;
#line 238 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_action_get (_tmp4_, "Host", G_TYPE_STRING, &host, "NumberOfRepetitions", G_TYPE_UINT, &repeat_count, "Timeout", G_TYPE_UINT, &interval_time_out, "DataBlockSize", G_TYPE_UINT, &data_block_size, "DSCP", G_TYPE_UINT, &dscp, NULL);
#line 254 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp5_ = host;
#line 254 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (g_strcmp0 (_tmp5_, "") == 0) {
#line 1434 "rygel-basic-management.c"
		const gchar* _tmp6_ = NULL;
		GUPnPServiceAction* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 255 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp6_ = _ ("Cannot run 'Ping' action: Host is empty");
#line 255 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		g_warning ("rygel-basic-management.vala:255: %s", _tmp6_);
#line 256 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp7_ = action;
#line 256 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp8_ = _ ("Invalid argument");
#line 256 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		gupnp_service_action_return_error (_tmp7_, (guint) 402, _tmp8_);
#line 258 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_g_free0 (host);
#line 258 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		return;
#line 1452 "rygel-basic-management.c"
	}
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp9_ = host;
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp10_ = repeat_count;
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp11_ = interval_time_out;
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp12_ = data_block_size;
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp13_ = dscp;
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp14_ = rygel_basic_management_test_ping_new (_tmp9_, _tmp10_, _tmp11_, _tmp12_, _tmp13_);
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	ping = _tmp14_;
#line 266 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp15_ = ping;
#line 266 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp16_ = action;
#line 266 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_add_test_and_return_action (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, RYGEL_TYPE_BASIC_MANAGEMENT_TEST) ? ((RygelBasicManagementTest*) _tmp15_) : NULL, _tmp16_);
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_object_unref0 (ping);
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (host);
#line 1478 "rygel-basic-management.c"
}


static void rygel_basic_management_ping_result_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	RygelBasicManagementTest* bm_test = NULL;
	GUPnPServiceAction* _tmp4_ = NULL;
	RygelBasicManagementTest* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gchar* status = NULL;
	gchar* additional_info = NULL;
	guint success_count = 0U;
	guint failure_count = 0U;
	guint32 avg_response_time = 0U;
	guint32 min_response_time = 0U;
	guint32 max_response_time = 0U;
	RygelBasicManagementTest* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	guint32 _tmp12_ = 0U;
	guint32 _tmp13_ = 0U;
	guint32 _tmp14_ = 0U;
	GUPnPServiceAction* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	guint _tmp18_ = 0U;
	guint _tmp19_ = 0U;
	guint32 _tmp20_ = 0U;
	guint32 _tmp21_ = 0U;
	guint32 _tmp22_ = 0U;
	GUPnPServiceAction* _tmp23_ = NULL;
#line 269 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (self != NULL);
#line 269 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (bm != NULL);
#line 269 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (action != NULL);
#line 271 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = action;
#line 271 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 271 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (_tmp1_ != ((guint) 1)) {
#line 1525 "rygel-basic-management.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 272 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp2_ = action;
#line 272 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp3_ = _ ("Invalid argument");
#line 272 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 274 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		return;
#line 1536 "rygel-basic-management.c"
	}
#line 279 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp4_ = action;
#line 279 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp6_ = rygel_basic_management_ensure_test_exists (self, _tmp4_, &_tmp5_);
#line 279 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_object_unref0 (bm_test);
#line 279 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	bm_test = _tmp5_;
#line 279 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (!_tmp6_) {
#line 280 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_g_object_unref0 (bm_test);
#line 280 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		return;
#line 1552 "rygel-basic-management.c"
	}
#line 287 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp7_ = bm_test;
#line 287 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_test_ping_get_results (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING) ? ((RygelBasicManagementTestPing*) _tmp7_) : NULL, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_);
#line 287 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (status);
#line 287 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	status = _tmp8_;
#line 287 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (additional_info);
#line 287 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	additional_info = _tmp9_;
#line 287 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	success_count = _tmp10_;
#line 287 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	failure_count = _tmp11_;
#line 287 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	avg_response_time = _tmp12_;
#line 287 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	min_response_time = _tmp13_;
#line 287 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	max_response_time = _tmp14_;
#line 296 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp15_ = action;
#line 296 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp16_ = status;
#line 296 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp17_ = additional_info;
#line 296 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp18_ = success_count;
#line 296 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp19_ = failure_count;
#line 296 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp20_ = avg_response_time;
#line 296 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp21_ = min_response_time;
#line 296 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp22_ = max_response_time;
#line 296 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_action_set (_tmp15_, "Status", G_TYPE_STRING, _tmp16_, "AdditionalInfo", G_TYPE_STRING, _tmp17_, "SuccessCount", G_TYPE_UINT, _tmp18_, "FailureCount", G_TYPE_UINT, _tmp19_, "AverageResponseTime", G_TYPE_UINT, _tmp20_, "MinimumResponseTime", G_TYPE_UINT, _tmp21_, "MaximumResponseTime", G_TYPE_UINT, _tmp22_, NULL);
#line 318 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp23_ = action;
#line 318 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_action_return (_tmp23_);
#line 269 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (additional_info);
#line 269 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (status);
#line 269 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_object_unref0 (bm_test);
#line 1604 "rygel-basic-management.c"
}


static void rygel_basic_management_nslookup_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gchar* hostname = NULL;
	gchar* dns_server = NULL;
	guint repeat_count = 0U;
	guint32 interval_time_out = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	RygelBasicManagementTestNSLookup* nslookup = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	guint32 _tmp12_ = 0U;
	RygelBasicManagementTestNSLookup* _tmp13_ = NULL;
	RygelBasicManagementTestNSLookup* _tmp14_ = NULL;
	GUPnPServiceAction* _tmp15_ = NULL;
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (self != NULL);
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (bm != NULL);
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (action != NULL);
#line 323 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = action;
#line 323 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 323 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (_tmp1_ != ((guint) 4)) {
#line 1637 "rygel-basic-management.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 324 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp2_ = action;
#line 324 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp3_ = _ ("Invalid argument");
#line 324 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 326 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		return;
#line 1648 "rygel-basic-management.c"
	}
#line 334 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp4_ = action;
#line 334 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_action_get (_tmp4_, "HostName", G_TYPE_STRING, &hostname, "DNSServer", G_TYPE_STRING, &dns_server, "NumberOfRepetitions", G_TYPE_UINT, &repeat_count, "Timeout", G_TYPE_UINT, &interval_time_out, NULL);
#line 347 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp5_ = hostname;
#line 347 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (g_strcmp0 (_tmp5_, "") == 0) {
#line 1658 "rygel-basic-management.c"
		const gchar* _tmp6_ = NULL;
		GUPnPServiceAction* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 348 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp6_ = _ ("Cannot run 'NSLookup' action: HostName is empty");
#line 348 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		g_warning ("rygel-basic-management.vala:348: %s", _tmp6_);
#line 349 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp7_ = action;
#line 349 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp8_ = _ ("Invalid argument");
#line 349 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		gupnp_service_action_return_error (_tmp7_, (guint) 402, _tmp8_);
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_g_free0 (dns_server);
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_g_free0 (hostname);
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		return;
#line 1678 "rygel-basic-management.c"
	}
#line 354 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp9_ = hostname;
#line 354 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp10_ = dns_server;
#line 354 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp11_ = repeat_count;
#line 354 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp12_ = interval_time_out;
#line 354 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp13_ = rygel_basic_management_test_ns_lookup_new (_tmp9_, _tmp10_, _tmp11_, _tmp12_);
#line 354 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	nslookup = _tmp13_;
#line 358 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp14_ = nslookup;
#line 358 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp15_ = action;
#line 358 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_add_test_and_return_action (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, RYGEL_TYPE_BASIC_MANAGEMENT_TEST) ? ((RygelBasicManagementTest*) _tmp14_) : NULL, _tmp15_);
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_object_unref0 (nslookup);
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (dns_server);
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (hostname);
#line 1704 "rygel-basic-management.c"
}


static void rygel_basic_management_nslookup_result_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	RygelBasicManagementTest* bm_test = NULL;
	GUPnPServiceAction* _tmp4_ = NULL;
	RygelBasicManagementTest* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gchar* status = NULL;
	gchar* additional_info = NULL;
	gchar* _result_ = NULL;
	guint success_count = 0U;
	RygelBasicManagementTest* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	gchar* _tmp11_ = NULL;
	GUPnPServiceAction* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	const gchar* _tmp16_ = NULL;
	GUPnPServiceAction* _tmp17_ = NULL;
#line 362 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (self != NULL);
#line 362 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (bm != NULL);
#line 362 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (action != NULL);
#line 364 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = action;
#line 364 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 364 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (_tmp1_ != ((guint) 1)) {
#line 1742 "rygel-basic-management.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 365 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp2_ = action;
#line 365 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp3_ = _ ("Invalid argument");
#line 365 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 367 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		return;
#line 1753 "rygel-basic-management.c"
	}
#line 372 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp4_ = action;
#line 372 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp6_ = rygel_basic_management_ensure_test_exists (self, _tmp4_, &_tmp5_);
#line 372 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_object_unref0 (bm_test);
#line 372 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	bm_test = _tmp5_;
#line 372 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (!_tmp6_) {
#line 373 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_g_object_unref0 (bm_test);
#line 373 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		return;
#line 1769 "rygel-basic-management.c"
	}
#line 379 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp7_ = bm_test;
#line 379 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_test_ns_lookup_get_results (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP) ? ((RygelBasicManagementTestNSLookup*) _tmp7_) : NULL, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_);
#line 379 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (status);
#line 379 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	status = _tmp8_;
#line 379 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (additional_info);
#line 379 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	additional_info = _tmp9_;
#line 379 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	success_count = _tmp10_;
#line 379 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (_result_);
#line 379 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_result_ = _tmp11_;
#line 385 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp12_ = action;
#line 385 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp13_ = status;
#line 385 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp14_ = additional_info;
#line 385 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp15_ = success_count;
#line 385 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp16_ = _result_;
#line 385 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_action_set (_tmp12_, "Status", G_TYPE_STRING, _tmp13_, "AdditionalInfo", G_TYPE_STRING, _tmp14_, "SuccessCount", G_TYPE_UINT, _tmp15_, "Result", G_TYPE_STRING, _tmp16_, NULL);
#line 398 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp17_ = action;
#line 398 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_action_return (_tmp17_);
#line 362 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (_result_);
#line 362 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (additional_info);
#line 362 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (status);
#line 362 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_object_unref0 (bm_test);
#line 1813 "rygel-basic-management.c"
}


static void rygel_basic_management_traceroute_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gchar* host = NULL;
	guint32 wait_time_out = 0U;
	guint data_block_size = 0U;
	guint max_hop_count = 0U;
	guint dscp = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	RygelBasicManagementTestTraceroute* traceroute = NULL;
	const gchar* _tmp9_ = NULL;
	guint32 _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	RygelBasicManagementTestTraceroute* _tmp14_ = NULL;
	RygelBasicManagementTestTraceroute* _tmp15_ = NULL;
	GUPnPServiceAction* _tmp16_ = NULL;
#line 401 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (self != NULL);
#line 401 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (bm != NULL);
#line 401 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (action != NULL);
#line 403 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = action;
#line 403 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 403 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (_tmp1_ != ((guint) 5)) {
#line 1848 "rygel-basic-management.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 404 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp2_ = action;
#line 404 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp3_ = _ ("Invalid argument");
#line 404 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 406 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		return;
#line 1859 "rygel-basic-management.c"
	}
#line 413 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp4_ = action;
#line 413 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_action_get (_tmp4_, "Host", G_TYPE_STRING, &host, "Timeout", G_TYPE_UINT, &wait_time_out, "DataBlockSize", G_TYPE_UINT, &data_block_size, "MaxHopCount", G_TYPE_UINT, &max_hop_count, "DSCP", G_TYPE_UINT, &dscp, NULL);
#line 429 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp5_ = host;
#line 429 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (g_strcmp0 (_tmp5_, "") == 0) {
#line 1869 "rygel-basic-management.c"
		const gchar* _tmp6_ = NULL;
		GUPnPServiceAction* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 430 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp6_ = _ ("Cannot run 'Traceroute' action: Host is empty");
#line 430 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		g_warning ("rygel-basic-management.vala:430: %s", _tmp6_);
#line 431 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp7_ = action;
#line 431 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp8_ = _ ("Invalid argument");
#line 431 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		gupnp_service_action_return_error (_tmp7_, (guint) 402, _tmp8_);
#line 433 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_g_free0 (host);
#line 433 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		return;
#line 1887 "rygel-basic-management.c"
	}
#line 436 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp9_ = host;
#line 436 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp10_ = wait_time_out;
#line 436 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp11_ = data_block_size;
#line 436 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp12_ = max_hop_count;
#line 436 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp13_ = dscp;
#line 436 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp14_ = rygel_basic_management_test_traceroute_new (_tmp9_, _tmp10_, _tmp11_, _tmp12_, _tmp13_);
#line 436 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	traceroute = _tmp14_;
#line 441 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp15_ = traceroute;
#line 441 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp16_ = action;
#line 441 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_add_test_and_return_action (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, RYGEL_TYPE_BASIC_MANAGEMENT_TEST) ? ((RygelBasicManagementTest*) _tmp15_) : NULL, _tmp16_);
#line 401 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_object_unref0 (traceroute);
#line 401 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (host);
#line 1913 "rygel-basic-management.c"
}


static void rygel_basic_management_traceroute_result_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	RygelBasicManagementTest* bm_test = NULL;
	GUPnPServiceAction* _tmp4_ = NULL;
	RygelBasicManagementTest* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gchar* status = NULL;
	gchar* additional_info = NULL;
	gchar* hop_hosts = NULL;
	guint32 response_time = 0U;
	RygelBasicManagementTest* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	guint32 _tmp10_ = 0U;
	gchar* _tmp11_ = NULL;
	GUPnPServiceAction* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	guint32 _tmp15_ = 0U;
	const gchar* _tmp16_ = NULL;
	GUPnPServiceAction* _tmp17_ = NULL;
#line 445 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (self != NULL);
#line 445 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (bm != NULL);
#line 445 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (action != NULL);
#line 447 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = action;
#line 447 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 447 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (_tmp1_ != ((guint) 1)) {
#line 1951 "rygel-basic-management.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 448 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp2_ = action;
#line 448 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp3_ = _ ("Invalid argument");
#line 448 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 450 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		return;
#line 1962 "rygel-basic-management.c"
	}
#line 455 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp4_ = action;
#line 455 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp6_ = rygel_basic_management_ensure_test_exists (self, _tmp4_, &_tmp5_);
#line 455 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_object_unref0 (bm_test);
#line 455 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	bm_test = _tmp5_;
#line 455 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (!_tmp6_) {
#line 456 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_g_object_unref0 (bm_test);
#line 456 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		return;
#line 1978 "rygel-basic-management.c"
	}
#line 462 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp7_ = bm_test;
#line 462 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_test_traceroute_get_results (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE) ? ((RygelBasicManagementTestTraceroute*) _tmp7_) : NULL, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_);
#line 462 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (status);
#line 462 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	status = _tmp8_;
#line 462 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (additional_info);
#line 462 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	additional_info = _tmp9_;
#line 462 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	response_time = _tmp10_;
#line 462 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (hop_hosts);
#line 462 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	hop_hosts = _tmp11_;
#line 468 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp12_ = action;
#line 468 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp13_ = status;
#line 468 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp14_ = additional_info;
#line 468 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp15_ = response_time;
#line 468 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp16_ = hop_hosts;
#line 468 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_action_set (_tmp12_, "Status", G_TYPE_STRING, _tmp13_, "AdditionalInfo", G_TYPE_STRING, _tmp14_, "ResponseTime", G_TYPE_UINT, _tmp15_, "HopHosts", G_TYPE_STRING, _tmp16_, NULL);
#line 481 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp17_ = action;
#line 481 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_action_return (_tmp17_);
#line 445 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (hop_hosts);
#line 445 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (additional_info);
#line 445 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (status);
#line 445 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_object_unref0 (bm_test);
#line 2022 "rygel-basic-management.c"
}


static void rygel_basic_management_get_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GUPnPServiceAction* _tmp7_ = NULL;
#line 484 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (self != NULL);
#line 484 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (bm != NULL);
#line 484 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (action != NULL);
#line 486 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = action;
#line 486 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 486 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 2045 "rygel-basic-management.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 487 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp2_ = action;
#line 487 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp3_ = _ ("Invalid argument");
#line 487 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 489 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		return;
#line 2056 "rygel-basic-management.c"
	}
#line 492 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp4_ = action;
#line 492 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp5_ = rygel_basic_management_create_test_ids_list (self, FALSE);
#line 492 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp6_ = _tmp5_;
#line 492 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_action_set (_tmp4_, "TestIDs", G_TYPE_STRING, _tmp6_, NULL);
#line 492 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (_tmp6_);
#line 496 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp7_ = action;
#line 496 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_action_return (_tmp7_);
#line 2072 "rygel-basic-management.c"
}


static void rygel_basic_management_get_active_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GUPnPServiceAction* _tmp7_ = NULL;
#line 499 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (self != NULL);
#line 499 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (bm != NULL);
#line 499 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (action != NULL);
#line 501 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = action;
#line 501 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 501 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 2095 "rygel-basic-management.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 502 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp2_ = action;
#line 502 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp3_ = _ ("Invalid argument");
#line 502 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 504 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		return;
#line 2106 "rygel-basic-management.c"
	}
#line 507 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp4_ = action;
#line 507 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp5_ = rygel_basic_management_create_test_ids_list (self, TRUE);
#line 507 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp6_ = _tmp5_;
#line 507 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_action_set (_tmp4_, "TestIDs", G_TYPE_STRING, _tmp6_, NULL);
#line 507 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (_tmp6_);
#line 511 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp7_ = action;
#line 511 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_action_return (_tmp7_);
#line 2122 "rygel-basic-management.c"
}


static void rygel_basic_management_get_test_info_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	RygelBasicManagementTest* bm_test = NULL;
	GUPnPServiceAction* _tmp4_ = NULL;
	RygelBasicManagementTest* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GUPnPServiceAction* _tmp7_ = NULL;
	RygelBasicManagementTest* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	RygelBasicManagementTest* _tmp11_ = NULL;
	RygelBasicManagementTestExecutionState _tmp12_ = 0;
	RygelBasicManagementTestExecutionState _tmp13_ = 0;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	GUPnPServiceAction* _tmp16_ = NULL;
#line 514 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (self != NULL);
#line 514 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (bm != NULL);
#line 514 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (action != NULL);
#line 516 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = action;
#line 516 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 516 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (_tmp1_ != ((guint) 1)) {
#line 2155 "rygel-basic-management.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 517 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp2_ = action;
#line 517 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp3_ = _ ("Invalid argument");
#line 517 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 519 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		return;
#line 2166 "rygel-basic-management.c"
	}
#line 524 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp4_ = action;
#line 524 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp6_ = rygel_basic_management_ensure_test_exists (self, _tmp4_, &_tmp5_);
#line 524 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_object_unref0 (bm_test);
#line 524 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	bm_test = _tmp5_;
#line 524 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (!_tmp6_) {
#line 525 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_g_object_unref0 (bm_test);
#line 525 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		return;
#line 2182 "rygel-basic-management.c"
	}
#line 528 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp7_ = action;
#line 528 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp8_ = bm_test;
#line 528 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp9_ = rygel_basic_management_test_get_method_type (_tmp8_);
#line 528 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp10_ = _tmp9_;
#line 528 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp11_ = bm_test;
#line 528 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp12_ = rygel_basic_management_test_get_execution_state (_tmp11_);
#line 528 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp13_ = _tmp12_;
#line 528 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp14_ = rygel_basic_management_test_execution_state_to_string (_tmp13_);
#line 528 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp15_ = _tmp14_;
#line 528 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_action_set (_tmp7_, "Type", G_TYPE_STRING, _tmp10_, "State", G_TYPE_STRING, _tmp15_, NULL);
#line 528 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (_tmp15_);
#line 535 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp16_ = action;
#line 535 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_action_return (_tmp16_);
#line 514 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_object_unref0 (bm_test);
#line 2212 "rygel-basic-management.c"
}


static void rygel_basic_management_cancel_test_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	RygelBasicManagementTest* bm_test = NULL;
	GUPnPServiceAction* _tmp4_ = NULL;
	RygelBasicManagementTest* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	RygelBasicManagementTest* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
	GCancellable* _tmp9_ = NULL;
	GUPnPServiceAction* _tmp10_ = NULL;
#line 538 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (self != NULL);
#line 538 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (bm != NULL);
#line 538 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (action != NULL);
#line 540 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = action;
#line 540 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 540 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (_tmp1_ != ((guint) 1)) {
#line 2239 "rygel-basic-management.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 541 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp2_ = action;
#line 541 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_tmp3_ = _ ("Invalid argument");
#line 541 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 543 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		return;
#line 2250 "rygel-basic-management.c"
	}
#line 548 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp4_ = action;
#line 548 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp6_ = rygel_basic_management_ensure_test_exists (self, _tmp4_, &_tmp5_);
#line 548 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_object_unref0 (bm_test);
#line 548 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	bm_test = _tmp5_;
#line 548 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	if (!_tmp6_) {
#line 549 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		_g_object_unref0 (bm_test);
#line 549 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		return;
#line 2266 "rygel-basic-management.c"
	}
#line 552 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp7_ = bm_test;
#line 552 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp8_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _tmp7_);
#line 552 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp9_ = _tmp8_;
#line 552 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_cancellable_cancel (_tmp9_);
#line 557 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp10_ = action;
#line 557 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	gupnp_service_action_return (_tmp10_);
#line 538 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_object_unref0 (bm_test);
#line 2282 "rygel-basic-management.c"
}


RygelBasicManagement* rygel_basic_management_construct (GType object_type) {
	RygelBasicManagement * self = NULL;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	self = (RygelBasicManagement*) g_object_new (object_type, NULL);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	return self;
#line 2292 "rygel-basic-management.c"
}


RygelBasicManagement* rygel_basic_management_new (void) {
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	return rygel_basic_management_construct (RYGEL_TYPE_BASIC_MANAGEMENT);
#line 2299 "rygel-basic-management.c"
}


guint rygel_basic_management_get_max_history_size (RygelBasicManagement* self) {
	guint result;
	guint _tmp0_ = 0U;
#line 36 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 36 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = self->priv->_max_history_size;
#line 36 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	result = _tmp0_;
#line 36 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	return result;
#line 2314 "rygel-basic-management.c"
}


void rygel_basic_management_set_max_history_size (RygelBasicManagement* self, guint value) {
	guint _tmp0_ = 0U;
#line 36 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_return_if_fail (self != NULL);
#line 36 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_tmp0_ = value;
#line 36 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	self->priv->_max_history_size = _tmp0_;
#line 36 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_object_notify ((GObject *) self, "max-history-size");
#line 2328 "rygel-basic-management.c"
}


static void rygel_basic_management_class_init (RygelBasicManagementClass * klass) {
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	rygel_basic_management_parent_class = g_type_class_peek_parent (klass);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_type_class_add_private (klass, sizeof (RygelBasicManagementPrivate));
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	((GObjectClass *) klass)->constructed = rygel_basic_management_real_constructed;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_basic_management_get_property;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_basic_management_set_property;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_basic_management_finalize;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_MAX_HISTORY_SIZE, g_param_spec_uint ("max-history-size", "max-history-size", "max-history-size", 0, G_MAXUINT, (guint) 10, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2347 "rygel-basic-management.c"
}


static void rygel_basic_management_instance_init (RygelBasicManagement * self) {
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	self->priv = RYGEL_BASIC_MANAGEMENT_GET_PRIVATE (self);
#line 36 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	self->priv->_max_history_size = (guint) 10;
#line 2356 "rygel-basic-management.c"
}


static void rygel_basic_management_finalize (GObject* obj) {
	RygelBasicManagement * self;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagement);
#line 38 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_object_unref0 (self->priv->tests_map);
#line 39 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_object_unref0 (self->priv->test_ids_by_type);
#line 42 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	_g_free0 (self->device_status);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	G_OBJECT_CLASS (rygel_basic_management_parent_class)->finalize (obj);
#line 2372 "rygel-basic-management.c"
}


/**
 * Basic implementation of UPnP BasicManagement service version 2.
 */
GType rygel_basic_management_get_type (void) {
	static volatile gsize rygel_basic_management_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelBasicManagementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_basic_management_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelBasicManagement), 0, (GInstanceInitFunc) rygel_basic_management_instance_init, NULL };
		GType rygel_basic_management_type_id;
		rygel_basic_management_type_id = g_type_register_static (gupnp_service_get_type (), "RygelBasicManagement", &g_define_type_info, 0);
		g_once_init_leave (&rygel_basic_management_type_id__volatile, rygel_basic_management_type_id);
	}
	return rygel_basic_management_type_id__volatile;
}


static void _vala_rygel_basic_management_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelBasicManagement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagement);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	switch (property_id) {
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		case RYGEL_BASIC_MANAGEMENT_MAX_HISTORY_SIZE:
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		g_value_set_uint (value, rygel_basic_management_get_max_history_size (self));
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		break;
#line 2402 "rygel-basic-management.c"
		default:
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		break;
#line 2408 "rygel-basic-management.c"
	}
}


static void _vala_rygel_basic_management_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelBasicManagement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagement);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
	switch (property_id) {
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		case RYGEL_BASIC_MANAGEMENT_MAX_HISTORY_SIZE:
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		rygel_basic_management_set_max_history_size (self, g_value_get_uint (value));
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		break;
#line 2424 "rygel-basic-management.c"
		default:
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management.vala"
		break;
#line 2430 "rygel-basic-management.c"
	}
}



