# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require "tempfile"

module ReadBucketsToFile
  def initialize
    @file = nil
  end

  def invoke(filter, brigade, mime_type)
    brigade.each do |bucket|
      if bucket.eos?
        @file.close(false)
        process_file(filter, mime_type, @file.path)
        @file.close(true)
        @file = nil
      end
      if @file.nil?
        @file = Tempfile.new(self.class.name.gsub(/[:]/, "_"))
      end
      @file.write(bucket.read)
    end
  end

  def process_file(filter, mime_type, path)
    raise NotImplementedError, "sub class must implement this method"
  end
end
