dnl AM_PATH_APR([MAJOR], [MINOR], [TEENY])
dnl Adds support for APR
AC_DEFUN([AM_PATH_APR],
[
  rast_lib_apr_major="$1"
  rast_lib_apr_minor="$2"
  rast_lib_apr_patch="$3"
  rast_lib_apr_version="$1.$2.$3"

  AC_ARG_WITH(apr-config,
  AC_HELP_STRING([--with-apr-config=PATH],[path to apr-config]),
  [
      AC_MSG_RESULT([using $withval for apr-config])
      APR_CONFIG="$withval"
  ], [
      AC_PATH_PROG(APR_CONFIG, apr-config, no)
  ])
  if test "$APR_CONFIG" = "no"; then
      AC_MSG_ERROR([apr-config is required])
  fi

  AC_MSG_CHECKING([APR version])    
  APR_VERSION="`$APR_CONFIG --version`"
  if test $? -ne 0; then
    AC_MSG_ERROR([apr-config --version failed])
  fi
  changequote(<<, >>)
  APR_MAJOR=`expr "$APR_VERSION" : '\(.*\)\..*\..*'`
  APR_MINOR=`expr "$APR_VERSION" : '.*\.\(.*\)\..*'`
  APR_PATCH=`expr "$APR_VERSION" : '.*\..*\.\(.*\)'`
  changequote([, ])
  if expr "$APR_MAJOR" '<' "$rast_lib_apr_major" > /dev/null; then
    AC_MSG_ERROR([$rast_lib_apr_version is required])
  fi
  if expr "$APR_MAJOR" '=' "$rast_lib_apr_major" > /dev/null; then
    if expr "$APR_MINOR" '<' "$rast_lib_apr_minor" > /dev/null; then
      AC_MSG_ERROR([$rast_lib_apr_version is required])
    fi
    if expr "$APR_MINOR" '=' "$rast_lib_apr_minor" > /dev/null; then
      if expr "$APR_PATCH" '<' "$rast_lib_apr_patch" > /dev/null; then
        AC_MSG_ERROR([$rast_lib_apr_version is required])
      fi
    fi
  fi
  AC_MSG_RESULT([$APR_VERSION])

  CPPFLAGS="`$APR_CONFIG --cppflags` $CPPFLAGS"
  CFLAGS="`$APR_CONFIG --cflags` $CFLAGS"
  LDFLAGS="`$APR_CONFIG --ldflags` $LDFLAGS"
  APR_INCLUDES="`$APR_CONFIG --includes`"

  APR_LIBS_LD="`$APR_CONFIG --link-ld --libs`"
  APR_LIBS_LIBTOOL="`$APR_CONFIG --link-libtool --libs`"

  AC_SUBST(APR_INCLUDES)
  AC_SUBST(APR_LIBS_LD)
  AC_SUBST(APR_LIBS_LIBTOOL)
])
