/***************************************************************************
 *   Copyright (C) 2008 Robert Keevil                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; under version 2 of the License.         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#include <QtGui>
#include "progress.h"
#include "qtscrob.h"


Progress::Progress(QTScrob *parent) : QDialog( parent ) {
	setupUi(this);
	qtscrob = parent;
	this->setWindowTitle(tr("Submission Progress"));

	connect(btnCancel, SIGNAL(clicked()), this, SLOT(cancel()));
	QTimer *timer = new QTimer(this);
	connect(timer, SIGNAL(timeout()), this, SLOT(update_progress()));
	timer->start(100);

	qDebug() << "In Progress::Progress";

	prgBatch->setMaximum(10);
	prgBatch->setValue(0);
	prgTotal->setValue(0);

	oldnumtracks = oldtot = oldnow = 0;

}

Progress::~Progress()
{
	disconnect(btnCancel, SIGNAL(clicked()), this, SLOT(cancel()));
	//disconnect(timer, SIGNAL(timeout()), this, SLOT(update_progress()));
	//timer->stop();
}

void Progress::cancel(void)
{
	qtscrob->scrob->cancel_submission();
	this->hide();
}

void Progress::update_progress(void)
{
	double ulnow = qtscrob->scrob->get_u_now();
	double ultot = qtscrob->scrob->get_u_tot();

	if ((totaltracks - qtscrob->scrob->get_num_tracks()) != oldnumtracks)
	{
		prgTotal->reset();
		prgTotal->setMinimum(0);
		prgTotal->setMaximum((int)totaltracks);

		prgTotal->setValue(totaltracks - qtscrob->scrob->get_num_tracks());
		oldnumtracks = totaltracks - qtscrob->scrob->get_num_tracks();
	}

	if (oldtot != ultot || oldnow != ulnow)
	{
		prgBatch->reset();
		prgBatch->setMinimum(0);
		prgBatch->setMaximum(ultot);
		prgBatch->setValue(ulnow);
		oldnow = ulnow;
		oldtot = ultot;
	}

	//qDebug() << "RECEIVED PROGRESS EVENT: Total " << prgTotal->value() << "/" << prgTotal->maximum() << "    Batch " << prgBatch->value() << "/" << prgBatch->maximum();

	QApplication::processEvents();
	//QCoreApplication::flush();
}
