/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

/*
 * This file is auto-generated by Qpid Gentools v.0.1 - do not modify.
 * Supported AMQP versions:
 *   8-0
 */
package org.apache.qpid.server.output;

import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.server.output.ProtocolOutputConverter.Factory;
import org.apache.qpid.server.protocol.AMQProtocolSession;

import java.util.HashMap;
import java.util.Map;

public class ProtocolOutputConverterRegistry
{

    private static final Map<ProtocolVersion, Factory> _registry =
            new HashMap<ProtocolVersion, Factory>();


    static
    {
        register(ProtocolVersion.v8_0);
        register(ProtocolVersion.v0_9);
        register(ProtocolVersion.v0_91);
    }

    private ProtocolOutputConverterRegistry()
    {
    }

    private static void register(ProtocolVersion version)
    {

        _registry.put(version,new ConverterFactory(version));
    }


    public static ProtocolOutputConverter getConverter(AMQProtocolSession session)
    {
        return _registry.get(session.getProtocolVersion()).newInstance(session);
    }

    private static class ConverterFactory implements Factory
    {
        private ProtocolVersion _protocolVersion;
        private MethodRegistry _methodRegistry;
        private int _classId;

        public ConverterFactory(ProtocolVersion pv)
        {
            _protocolVersion = pv;

        }

        public synchronized ProtocolOutputConverter newInstance(AMQProtocolSession session)
        {
            if(_methodRegistry == null)
            {

                _methodRegistry = MethodRegistry.getMethodRegistry(_protocolVersion);

            }
            return new ProtocolOutputConverterImpl(session, _methodRegistry);
        }
    }
}
