/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

package org.apache.qpid.server.model;

import java.util.HashMap;
import java.util.Map;

/**
 * A type of event generated by a ConfiguredObject.
 */
public abstract class EventType<T extends EventType<T>>
{
    private static final Map<Class<? extends EventType>, Integer> EVENT_TYPES =
        new HashMap<Class<? extends EventType>, Integer>();

    private final int _classId;

    protected EventType()
    {
        synchronized (EVENT_TYPES)
        {
            if(EVENT_TYPES.containsKey(getClass()))
            {
                throw new IllegalArgumentException("Cannot define more one instance of the same EventType " +
                                                   getClass().getName());
            }
            else
            {
                _classId = EVENT_TYPES.size();
                EVENT_TYPES.put(getClass(), _classId);
            }
        }
    }

    public final int getId()
    {
        return _classId;
    }

    abstract public Event<T> newEvent();
}
