/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */
#ifndef _Deliverable_
#define _Deliverable_

#include "qpid/broker/AsyncCompletion.h"
#include "qpid/sys/IntegerTypes.h"
#include <boost/shared_ptr.hpp>

namespace qpid {
    namespace broker {
        class Message;
        class Queue;

    class Deliverable : public AsyncCompletion {
        public:
            bool delivered;
            Deliverable() : delivered(false) {}

	    virtual Message& getMessage() = 0;

            virtual void deliverTo(const boost::shared_ptr<Queue>& queue) = 0;
            virtual uint64_t contentSize() { return 0; }
            virtual ~Deliverable(){}
        };
    }
}


#endif
