/****************************************************************************
    QtNlist   Netlist & Partslist utility for Qt-BSch3V
    Copyright (C) 2004-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/
/****************************************************************************
** XBSch饹
****************************************************************************/
#ifndef XBSCHLINE_H
#define XBSCHLINE_H

#include "xbsch.h"
#include "xbschobj.h"
//#include <SPoint.h>
//#include <SRect.h>

class SXBSchLine:public SXBSchObj
{
public:
	//󥹥ȥ饯
	SXBSchLine();
	//ǥȥ饯
	virtual ~SXBSchLine(){}
	//֤ΤȤΥʥåץݥȤ
	SPoint snapPoint();

public:
	//ꤷ٤֤
	int qSelectWeight(const SPoint&);
	//ϰϤꤷԤ
	unsigned testSelection(const SRect& );
	//ϰϤ򤷤ƥɥåԤ
	unsigned testSelectionForDrag(const SRect& );
	//褬ɬפɤ֤
	bool qRedraw(const SRect& );
	//ԥ֤
	//int pinCount(){return 2;}
	//nܤΥԥΰ֤롣
	//SPoint pinPosition(int);
	SRect area();
	SRect rotateRect();
	//ͭʥ֥Ȥʤtrue֤ĹΤʤʬͭǤϤʤ
	bool qValid(){return(m_p1 != m_p2);}
protected:
	//ȥ꡼फɤ߹
	//bool readStreamEx(SCsvIStream* pStrm,const SPoint* pptOrigin,const char* pTag);
	//ȥ꡼ؤν񤭹
	//bool writeStreamEx(SCsvOStream* pStrm,const SPoint* pptOrigin,const char* pTag);

	//ȥ꡼फɤ߹
	virtual bool readCe3Ex(SReadCE3& rce3,const SPoint* pptOrigin,const char* pTag);
	//ȥ꡼ؤν񤭹
	virtual bool writeCe3Ex(SWriteCE3& wce3,const SPoint* pptOrigin,const char* pTag);
};

//磻䡼饹
class SXBSchWire:public SXBSchLine
{
public:
	//󥹥ȥ饯
	SXBSchWire(){}
	//ǥȥ饯
	~SXBSchWire(){}
/*
	//ȥ꡼फɤ߹ ~ -WIRE
	bool readStream(SCsvIStream* pStrm,const SPoint* pptOrigin);
	//ȥ꡼ؤν񤭹ߡ+WIRE ~ -WIRE
	bool writeStream(SCsvOStream* pStrm,const SPoint* pptOrigin);
*/
	bool readCe3(SReadCE3&,const SPoint* ,SXBSchDoc*);
	bool writeCe3(SWriteCE3& ,const SPoint* );

	//IDμ
	unsigned id(){return ID_WIRE;}
	//ʣԤ
	SXBSchObj* duplicate();
};

//Х饹
class SXBSchBus:public SXBSchLine
{
public:
	//󥹥ȥ饯
	SXBSchBus(){}
	//ǥȥ饯
	~SXBSchBus(){}
	//IDμ
	unsigned id(){return ID_BUS;}
/*
	//ȥ꡼फɤ߹ ~ -BUS
	bool readStream(SCsvIStream* pStrm,const SPoint* pptOrigin);
	//ȥ꡼ؤν񤭹ߡ+BUS ~ -BUS
	bool writeStream(SCsvOStream* pStrm,const SPoint* pptOrigin);
*/
	bool readCe3(SReadCE3&,const SPoint* ,SXBSchDoc*);
	bool writeCe3(SWriteCE3& ,const SPoint* );

	//ʣԤ
	SXBSchObj* duplicate();
};

//饹
class SXBSchDash:public SXBSchLine
{
public:
	//󥹥ȥ饯
	SXBSchDash(){}
	//ǥȥ饯
	~SXBSchDash(){}
/*
	//ȥ꡼फɤ߹ ~ -DASH
	bool readStream(SCsvIStream* pStrm,const SPoint* pptOrigin);
	//ȥ꡼ؤν񤭹ߡ+DASH ~ -DASH
	bool writeStream(SCsvOStream* pStrm,const SPoint* pptOrigin);
*/
	bool readCe3(SReadCE3&,const SPoint* ,SXBSchDoc*);
	bool writeCe3(SWriteCE3& ,const SPoint* );

	
	//IDμ
	unsigned id(){return ID_DASH;}
	//ʣԤ
	SXBSchObj* duplicate();
};


#endif
