/*****************************************************************************
 ** Class QSubtitles
 **
 ** This class handles the subtitles - tab of the main QDVDAuthor 
 ** application
 **
 **   Created : 
 **        by : Varol Okan
 ** Copyright : (c) Varol Okan
 ** License   : GPL v 2.0
 **
 *****************************************************************************/

#ifndef SUBTITLESGUI_H
#define SUBTITLESGUI_H

#include <qlabel.h>
#include <qdragobject.h>

#include "uisubtitles.h"
#include "rgba.h"

class Subtitles;
class QDVDAuthor;
class QGridLayout;
class QScrollView;
class SubtitlesGui;
class MediaInterface;
class SourceFileInfo;
class SourceFileEntry;

class MediaLabel : public QLabel
{
  Q_OBJECT
public:
           MediaLabel ( SubtitlesGui *, QWidget *p, const char *n=NULL, WFlags f=0 );
  virtual ~MediaLabel ( );

protected:
   virtual void dropEvent      ( QDropEvent * );
   virtual void dragEnterEvent ( QDragEnterEvent * );

private:
   SubtitlesGui *m_pSubtitlesGui;
};

class PreviewLabel : public QLabel
{
  Q_OBJECT
public:
           PreviewLabel ( SubtitlesGui *, QWidget *p, const char *n=NULL, WFlags f=0 );
  virtual ~PreviewLabel ( );

protected:
   virtual void mouseDoubleClickEvent ( QMouseEvent * );
   virtual void mouseMoveEvent        ( QMouseEvent * );
   virtual void mousePressEvent       ( QMouseEvent * );

private:
   SubtitlesGui *m_pSubtitlesGui;
   QPoint        m_lastPos;
};

class SubtitlesGui : public uiSubtitles
{
  Q_OBJECT

  enum enPreviewMode { ModeFitWindow=0, ModeHalfScroll, ModeScroll };
public:
   SubtitlesGui ( QDVDAuthor *, QWidget *p, const char * n=0, WFlags f=0 );
  ~SubtitlesGui ( );

public slots:
  virtual void slotNewPosition          ( int, const QString & );
  virtual void slotNewPosition          ( long );
  virtual void slotCloseSource          ( );
  virtual void slotMediaFB              ( );
  virtual void slotMediaBack            ( );
  virtual void slotMediaStop            ( );
  virtual void slotMediaPause           ( );
  virtual void slotMediaPlay            ( );
  virtual void slotMediaPlayStop        ( );
  virtual void slotMediaFF              ( );
  virtual void slotAddNew               ( );
  virtual void slotStart                ( );
  virtual void slotEnd                  ( );
  virtual void slotImport               ( );
  virtual void slotExport               ( );
  virtual void slotClear                ( );
  virtual void slotChange               ( );
  virtual void slotDelete               ( );
  virtual void slotDeleteLine           ( );
  virtual void slotSearchText           ( );
  virtual void slotApplyToAll           ( );
  virtual void slotFontColor            ( );
  virtual void slotAddSubtitle          ( );
  virtual void slotBackgroundColor      ( );
  virtual void slotRenderPreview        ( );
  virtual void slotFontFamilyChanged    ( int  );
  virtual void slotFontStyleChanged     ( int  );
  virtual void slotFontSizeChanged      ( int  );
  virtual void slotVolumeChanged        ( int  );
  virtual void slotPositionChanged      ( int  );
  virtual void slotTransparencyChanged  ( int  );
  virtual void slotBGTransparencyChanged( int  );
  virtual void slotTextOnly             ( bool );
  virtual void slotRight                ( bool );
  virtual void slotCenter               ( bool );
  virtual void slotLeft                 ( bool );
  virtual void slotJustify              ( bool );
  virtual void slotVTop                 ( bool );
  virtual void slotVCenter              ( bool );
  virtual void slotVBottom              ( bool );
  virtual void slotFit                  ( bool );
  virtual void slotUnderline            ( bool );
  virtual void slotOutline              ( bool );
  virtual void slotTabChanged           ( QWidget * );
  virtual void slotSubtitleChanged      ( QListViewItem * );

protected slots:
  virtual bool event      ( QEvent * );
  virtual void slotSetSelectedItem ( );

public:
  void insertDraggedObject    ( QDropEvent *, QImage  & );
  void insertDraggedText      ( QDropEvent *, QString & );
  Subtitles *getSubtitles     ( bool b=false );
  void releaseSourceFileInfo  ( );
  void createTableEntries     ( );
  void previewDoubleClick     ( );
  void scrollPreview ( int, int );

private:
  void initMe                                       ( );
  void displayRow                              (  int );
  void updateFont                              ( uint );
  bool addSubtitle                          ( QString );
  int  findString            ( QStringList &, QString );
  bool createSubtitles                              ( );
  void updateButtons                                ( );
  void resetMediaWidget                             ( );
  void renderPreview                                ( );
  QFont &getFont                                    ( );
  bool getSubtitleRect                    ( QRect   & );
  void setBackgroundColor                 ( Rgba    & );
  void setForegroundColor                 ( Rgba    & );
  void initNewSourceFileInfo              (      bool );
  bool sanityCheckSubtitleTrack           (     int & );
  SourceFileInfo  *findSourceFileInfo     ( QString & );
  SourceFileEntry *sourceFileEntry ( SourceFileInfo * );
  void displayPreview              ( QImage &,QRect & );

private:
  MediaLabel     *m_pDragLabel;
  QGridLayout    *m_pLayout;
  MediaInterface *m_pMediaInterface;
  QScrollView    *m_pScrollView;
  QLabel         *m_pPreview;
  SourceFileInfo *m_pSourceFileInfo;
  Subtitles      *m_pSubtitles; // separated from the actual Subtitle in the SourceFileInfo.
  QDVDAuthor     *m_pDVDAuthor;
  QString         m_qsCurrentURL;
  QString         m_strCurrentTime;
  QString         m_strStartTime;
  QString         m_strEndTime;
  QFont           m_qfFont;
  int             m_iAlignement;
  Rgba            m_backgroundColor;
  Rgba            m_foregroundColor;
  int             m_iCurrentSubtitleNumber;
  enPreviewMode   m_enPreviewMode;
  QListViewItem  *m_pSelectItem;
  int             m_iOrigSubtitlesState;
  int             m_iVideoHeight;
  int             m_iVideoWidth;
};

#endif // SUBTITLESGUI_H
