SOURCES	+= slidemain.cpp \
	imageline.cpp\
	soundline.cpp \
	filterline.cpp \
	slidertime.cpp  \
	dialogfilter.cpp \
	dialogcreate.cpp  \
	imagepreview.cpp   \
	../xml_slideshow.cpp\
	../rgba.cpp \
	modifiers2.cpp

HEADERS	+= imageline.h \
	soundline.h \
	filterline.h \
	slidertime.h  \
	dialogfilter.h \
	dialogcreate.h  \
	imagepreview.h   \
	../xml_slideshow.h\
	../rgba.h \
	modifiers2.h

unix {
  UI_DIR      = .ui
  MOC_DIR     = .moc
  OBJECTS_DIR = .obj
  DEFINES    += QDVD_LINUX
}
win32 {
  UI_DIR      = ui
  MOC_DIR     = moc
  OBJECTS_DIR = obj
  DEFINES    += QDVD_WIN32
}
DEFINES += QDVD_SLIDESHOW

FORMS	= dialogslide.ui \
	dialogimage.ui \
	uidialogcreate.ui

# here we set the default type ...
WHICH_DEBUG = $$(DEBUG_QDVDAUTHOR)
isEmpty(WHICH_DEBUG)	{
	WHICH_DEBUG=release
}

WHICH_PREFIX = $$(PREFIX)
isEmpty( WHICH_PREFIX ) {
	WHICH_PREFIX =/usr
}

!exists (../i18n/qslideshow_de.qm)	{
	LRELEASE=$$(QTDIR)/bin/lrelease
	!exists ( $${LRELEASE} ) {
		LRELEASE=lrelease
	}
	system ( $${LRELEASE} qslideshow.pro )
}

target.path = $${WHICH_PREFIX}/bin

i18n.path = $${WHICH_PREFIX}/share/qdvdauthor
i18n.files = ../i18n/qslideshow_*.qm
#i18n.extra = $${LRELEASE} qslideshow.pro

IMAGES = ../images/checkered.png ../images/error.jpg

TRANSLATIONS    = ../i18n/qslideshow_de.ts \
                  ../i18n/qslideshow_fr.ts \
                  ../i18n/qslideshow_es.ts \
                  ../i18n/qslideshow_ca.ts \
                  ../i18n/qslideshow_it.ts \
                  ../i18n/qslideshow_ru.ts

LIBS                   +=-L/usr/X11R6/lib64
INSTALLS                = target i18n
INCLUDEPATH             = ../ $$(ADD_INCLUDEDIR)
DESTDIR                 =../../bin
TEMPLATE                =app
CONFIG	               += qt thread warn_on $${WHICH_DEBUG}
QMAKE_CXXFLAGS_WARN_ON += -Wno-non-virtual-dtor
QMAKE_CXXFLAGS_DEBUG   += -O0 -ggdb3
QMAKE_CFLAGS_DEBUG     += -O0 -ggdb3
LANGUAGE                = C++
