/****************************************************************************
** dialogslideshow.cpp
**
**   Created : Wed Jun 4'th 2008 
**        by : Varol Okan using vi
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
*****************************************************************************/

#include <unistd.h>

#include <qlabel.h>
#include <qimage.h>
#include <qtimer.h>
#include <qpixmap.h>
#include <qcursor.h>
#include <qspinbox.h>
#include <qlistbox.h>
#include <qfileinfo.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qapplication.h>
#include <qradiobutton.h>
#include <qcolordialog.h>

#include "utils.h"
#include "global.h"
#include "messagebox.h"
#include "qdvdauthor.h"
#include "messagebox.h"
#include "xml_slideshow.h"
#include "render_client.h"
#include "dialogkenburns.h"
#include "dialogslideshow.h"
#include "dialogalphatrans.h"
#include "filepreviewdialog.h"
#include "qplayer/mediainfo.h"

namespace Input
{

DialogSlideshow::DialogSlideshow ( QWidget *pParent )
  : uiSlideshow ( pParent )
{
  int t;
  for ( t=0; t<THUMBNAIL_COUNT; t++ )  {
    m_arrayPix[t] = new QPixmap;
  }
  m_iCurrentPix = 0;
  m_pTimer      = NULL;
  m_bExitNow    = false;
  m_bAnimated   = false;
  m_pSlideshow  = NULL;

  connect ( m_pButtonOkay,      SIGNAL ( clicked ( ) ), this, SLOT ( accept ( ) ) );
  connect ( m_pButtonCancel,    SIGNAL ( clicked ( ) ), this, SLOT ( reject ( ) ) );
  connect ( m_pButtonImage,     SIGNAL ( clicked ( ) ), this, SLOT ( slotImage       ( ) ) );
  connect ( m_pButtonColor,     SIGNAL ( clicked ( ) ), this, SLOT ( slotColor       ( ) ) );
  connect ( m_pButtonAdd,       SIGNAL ( clicked ( ) ), this, SLOT ( slotAddAudio    ( ) ) );
  connect ( m_pButtonDelete,    SIGNAL ( clicked ( ) ), this, SLOT ( slotDeleteAudio ( ) ) );
  connect ( m_pButtonSelect,    SIGNAL ( clicked ( ) ), this, SLOT ( slotSelect      ( ) ) );
  connect ( m_pButtonAll,       SIGNAL ( clicked ( ) ), this, SLOT ( slotAll         ( ) ) );
  connect ( m_pButtonClear,     SIGNAL ( clicked ( ) ), this, SLOT ( slotClear       ( ) ) );
  connect ( m_pButtonAnim,      SIGNAL ( clicked ( ) ), this, SLOT ( slotAnim        ( ) ) );
  connect ( m_pButtonKBParams,  SIGNAL ( clicked ( ) ), this, SLOT ( slotKBParams    ( ) ) );
  connect ( m_pCheckIntroPage,  SIGNAL ( toggled     ( bool ) ), this, SLOT ( slotIntroPage   ( bool ) ) );
  connect ( m_pCheckKenBurns,   SIGNAL ( toggled     ( bool ) ), this, SLOT ( slotKenBurns    ( bool ) ) );
  connect ( m_pSpinImageDelay,  SIGNAL ( valueChanged ( int ) ), this, SLOT ( slotValueChanged ( int ) ) );
  connect ( m_pSpinFilterDelay, SIGNAL ( valueChanged ( int ) ), this, SLOT ( slotValueChanged ( int ) ) );
  connect ( m_pListViewTransitions,  SIGNAL  ( selectionChanged ( QListViewItem * ) ), this, SLOT ( slotSelectionChanged ( QListViewItem * ) ) );
}

/*
 *  Destroys the object and frees any allocated resources
 */
DialogSlideshow::~DialogSlideshow ( )
{
  m_pSlideshow = NULL;

  if ( m_pTimer )
    delete m_pTimer;
  m_pTimer = NULL;

  int t;
  for ( t=0; t<THUMBNAIL_COUNT; t++ )  {
    if ( m_arrayPix[t] )
      delete m_arrayPix[t];
    m_arrayPix[t] = NULL;
  }
}

void DialogSlideshow::accept ( )
{
  m_bExitNow = true;
  QDialog::accept     ( ); //done ( QDialog::Accepted ); //accept ( );
  qApp->processEvents ( );
  usleep ( 100000 );
}

void DialogSlideshow::reject ( )
{
  m_bExitNow = true;
  QDialog::reject     ( ); //done ( QDialog::Accepted ); //accept ( );
  qApp->processEvents ( );
  usleep ( 100000 );
}

QString DialogSlideshow::background ( )
{
  return m_qsBackground;
}

QStringList &DialogSlideshow::audioList ( )
{
  return m_listAudio;
}

QStringList DialogSlideshow::filterList ( )
{
  QStringList listOfCurrentSelections;

  QCheckListItem *pItem = (QCheckListItem *)m_pListViewTransitions->firstChild ( );
  bool bAllFilter = true;
  while ( pItem )  {
    if  ( pItem->isOn ( ) )
      listOfCurrentSelections.append ( pItem->text ( ) );
    else
      bAllFilter = false;
    pItem = (QCheckListItem *)pItem->nextSibling ( );
  }
  // If all filter were selected, then we don't need to bother
  // But hey we only know if we go through all of them ... right ?
  if ( bAllFilter )
    listOfCurrentSelections.clear ( );

  return listOfCurrentSelections;
}

void DialogSlideshow::initMe ( CXmlSlideshow *pSlideshow, bool bEnableName )
{
  m_pSlideshow = pSlideshow;
  if ( ! pSlideshow )
    return;

  Utils theUtils;

  m_pSpinImageDelay->setValue   ( (int)pSlideshow->delay        );
  m_pCheckIntroPage->setChecked ( pSlideshow->intro_page        );
  m_pSpinFilterDelay->setValue  ( (int)pSlideshow->filter_delay );
  m_pEditName->setText          ( pSlideshow->slideshow_name    );
  m_pEditName->setEnabled       ( bEnableName                   );
  m_pCheckKenBurns->setChecked  ( pSlideshow->bKenBurns         );
  m_pButtonKBParams->setEnabled ( pSlideshow->bKenBurns         );
 
  int iFormat = 0;
  if ( theUtils.getFormat ( pSlideshow->xres, pSlideshow->yres ) > FORMAT_NTSC4 )  // set to PAL
    iFormat = ( pSlideshow->aspect == 0 ) ? 1 : 3;
  else
    iFormat = ( pSlideshow->aspect == 0 ) ? 0 : 2;

  m_pComboFormat->setCurrentItem ( iFormat );

  bool      bBackgroundImage = false;
  QString   qsAudio;
  QFileInfo fileInfo;
  QStringList::iterator it = pSlideshow->audio_list.begin ( );
  while ( it  !=  pSlideshow->audio_list.end ( ) )  {
    qsAudio = *it++;
    fileInfo.setFile ( qsAudio );
    qsAudio = fileInfo.fileName ( );
    m_pListAudio->insertItem    ( qsAudio );
  }
  m_listAudio = pSlideshow->audio_list;

  if ( pSlideshow->background[0] == '#' )  {
//    QColor theColor ( pSlideshow->background );
//    m_pLabelBckground->setPaletteBackgroundColor ( theColor );
  }
  else if ( pSlideshow->background.isEmpty ( ) )
    pSlideshow->background = "#000000";
  else  {
    QFileInfo fileInfo   ( pSlideshow->background );
    if ( fileInfo.exists ( ) )  {
      // in order to get the correct size I need to show the dialog now.
      show ( );
      QPixmap thePixmap;
      QImage  theImage ( pSlideshow->background );
      thePixmap.convertFromImage    ( theImage.smoothScale ( m_pLabelBackground->size ( ), QImage::ScaleFree ) );
      m_pLabelBackground->setPixmap ( thePixmap );
      bBackgroundImage = true;
    }
    else
      pSlideshow->background = "#000000";
  }

  m_qsBackground  = pSlideshow->background;
  if ( ! bBackgroundImage )  {
    QColor theColor ( pSlideshow->background );
    m_pLabelBackground->setPaletteBackgroundColor ( theColor );
  }

  QString qsTitle = "Slideshow [";
  qsTitle += m_pSlideshow->slideshow_name + "] <";
  qsTitle += QString ( "%1 Imgs+ %2 Vids>" ).arg ( m_pSlideshow->countImg ( ) ).arg ( m_pSlideshow->countVid ( ) );

  setCaption ( qsTitle );

  // init Transitions will also call createVidsLength, and createAudioLength
  initTransitions ( );
}

void DialogSlideshow::initTransitions ( )
{
  // Here we add the system transitions plus 
  // load the available transitions from the system folder

  // Check if we need to create a new object ...
  if ( Render::Manager::m_pSelf == NULL )
       Render::Manager::m_pSelf = new Render::Manager;

  // Disable sorting.
  m_pListViewTransitions->setSorting ( -1 );

  // We need to also init the selected transitions for a Slideshow
  QString qsFilter;
  QStringList::iterator itFilter;
  QCheckListItem    *pItem = NULL;
  QStringList         list = Render::Manager::m_pSelf->getFilterNames ( );
  QStringList::iterator it = list.end ( );
  bool bChecked;

  if ( list.count ( ) < 5 )  {
    Utils theUtils;
    QString qsQRender = theUtils.getToolPath ( "qrender");
    if ( qsQRender == "qrender" )  // qrender path not found
      qsQRender = tr ( "Could not find 'qrender'. Please make sure that 'qrender is in $PATH and executable.\n\n" );
    else
      qsQRender = "";
    QString qsTransitionPath = Global::qsSystemPath + QString ( "/share/qdvdauthor/slideshow/transitions/alpha/" );
    QString qsText = qsQRender;
    qsText += tr ( "Please check if you have all transitions installed in " );
    qsText += tr ( "\n%1\n\nYou can donload them from:\nhttp://qdvdauthor.sourceforge.net/data/alpha_trans.tar.bz2\n\n" ).arg ( qsTransitionPath );
    qsText += tr ( "To install do the following:\n" );

    qsTransitionPath = Global::qsSystemPath + QString ( "/share/qdvdauthor/" );
    qsText += tr ( "cd /tmp; wget http://qdvdauthor.sourceforge.net/data/alpha_trans.tar.bz2\n" );
    qsText += tr ( "cd %1; sudo tar -xjf /tmp/alpha_trans.tar.bz2\n\n" ).arg ( qsTransitionPath );
    qsText += tr ( "The filter will be available after restarting QDVDAuthor.\n" );

    QSize theSize    ( 600, 300 );
    MessageBox::html ( this, tr ( "Warning" ), qsText, theSize );
  }

  QPixmap pix;
  QImage  img ( QImage::fromMimeSource ( "please_wait.jpg" ) );
  img  =  img.smoothScale ( 24, 24 );
  pix.convertFromImage  ( img );
  do  {
    qsFilter = *(--it);
    pItem = new QCheckListItem ( m_pListViewTransitions, qsFilter, QCheckListItem::CheckBoxController );
    pItem->setPixmap ( 0, pix );
    bChecked = false;
    if ( m_pSlideshow->validFilterNames.count ( ) > 0 )  {
      itFilter = m_pSlideshow->validFilterNames.begin ( );
      while (  itFilter   != m_pSlideshow->validFilterNames.end ( ) )  {
        if  ( *itFilter++ == *it )  {
          bChecked = true;
          break;
        }
      }
    }
    else
      bChecked  =   true;
    pItem->setOn ( bChecked );
  } while ( it != list.begin ( ) );

  bChecked = m_pSlideshow->imgBkgImg ( );
  m_pRadioImgImg   ->setChecked ( !bChecked );
  m_pRadioImgBkgImg->setChecked (  bChecked );

//  bChecked = m_pSlideshow->kenBurns ( );
//  m_pCheckKenBurns->setChecked  (  bChecked );

  QTimer::singleShot ( 1000, this, SLOT ( slotCreateListViewPix ( ) ) );
}

void DialogSlideshow::slotCreateListViewPix ( )
{
  QCheckListItem *pItem = (QCheckListItem *)m_pListViewTransitions->firstChild ( );

  while ( pItem )  {
    pItem->setPixmap    ( 0, getListViewPix ( pItem->text ( ) ) );
    qApp->processEvents ( 500 );
    pItem = (QCheckListItem *)pItem->nextSibling ( );
  }
  // After we initialized the pixies, we need to ge vids, and audio lengths
  QTimer::singleShot ( 10,   this, SLOT ( createVidsLength  ( ) ) );
}

QPixmap DialogSlideshow::getListViewPix ( QString qsFilterName )
{
  QPixmap pix;
  QString qsTransitionPath = Global::qsSystemPath + QString ( "/share/qdvdauthor/slideshow/transitions/alpha/" );
  QString qsFileName       = qsTransitionPath + qsFilterName + ".jpg";

  QFileInfo fileInfo ( qsFileName );
  for ( int t=0; t<2;  t++ ) {
    if ( fileInfo.exists ( ) )
      break;

    qsTransitionPath = Global::qsSystemPath + QString ( "/share/qdvdauthor/slideshow/transitions/luma/" );
    qsFileName       = qsTransitionPath + qsFilterName + ".png";
    fileInfo.setFile ( qsFileName );
  }
  if ( ! fileInfo.exists ( ) )
    return pix; // E.g. "Cross Fade"

  QImage img  (  qsFileName );
  img =  img.scale ( 24, 24 );
  pix.convertFromImage( img );

  return pix;
}

void DialogSlideshow::createTransitions ( )
{
  // Here we compare the tranition selection from the slideshow to the current selection
  // If they have changed we'll re-create the transitions for this slideshow randomly.
  // Note: We need to preserve transitions which the user manually changed.
  QStringList listOfCurrentSelections;

  QCheckListItem *pItem = (QCheckListItem *)m_pListViewTransitions->firstChild ( );
  while ( pItem )  {
    if  ( pItem->isOn ( ) )
      listOfCurrentSelections.append ( pItem->text ( ) );
    pItem = (QCheckListItem *)pItem->nextSibling ( );
  }
}

void DialogSlideshow::createVidsLength ( )
{
  if ( ! m_pSlideshow )
    return;
  MediaInfo *pMediaInfo = Global::pApp->getMediaInfo ( );
  if ( ! pMediaInfo )
    return;

  uint t;
  CXmlSlideshow::vid_struct *pVid = NULL;
  for ( t=0; t<m_pSlideshow->countVid ( ); t++ )  {
    pVid = m_pSlideshow->getVid ( t );
    if ( pVid->length == 0L )   {
      pMediaInfo->setFileName   ( pVid->src, true );
      pVid->length = pMediaInfo->getLength ( );
    }
  }
  // Lastly we create the audio length
  QTimer::singleShot ( 10, this, SLOT ( createAudioLength ( ) ) );
}

void DialogSlideshow::createAudioLength ( )
{
  static bool bBusy = false;
  if ( bBusy )  {
    m_pSlideshow->total_audio_length = 0;
    displayLength ( );
    return;
  }
  bBusy = true;
  if ( m_pSlideshow )  {
    MediaInfo *pMediaInfo = Global::pApp->getMediaInfo ( );
    if ( pMediaInfo )  {
      QString qsFile;
      m_pSlideshow->total_audio_length = 0;
      QStringList tempList     = m_listAudio;
      QStringList::iterator it = tempList.begin ( );
      while ( it != tempList.end ( ) )  {
        qsFile = *it++;
        pMediaInfo->setFileName ( qsFile, true );
        if ( ( ! m_pSlideshow ) || ( m_bExitNow ) ) {
          displayLength ( );
          bBusy = false;
          m_bExitNow = false;
          return;
        }
        m_pSlideshow->total_audio_length += (uint)( pMediaInfo->getLength ( ) / 1000.0 );
      }
    }
    m_pButtonKBParams->setEnabled ( m_pSlideshow->bKenBurns );
  }
  displayLength ( );
  bBusy = false;
}

void DialogSlideshow::displayLength ( )
{
  if ( ! m_pSlideshow )
    return;
  Utils theUtils;
  QString qsLength = theUtils.getStringFromMs ( (long)( m_pSlideshow->slideLength ( ) * 1000 ) );
  m_pGroupGeneral->setTitle ( QString ( "General ( " )     + qsLength + QString ( " )" )  );
  qsLength = theUtils.getStringFromMs ( (long)( m_pSlideshow->audioLength ( ) * 1000 ) );
  m_pGroupAudio->setTitle   ( QString ( "Audio files ( " ) + qsLength + QString ( " )" )  );
}

void DialogSlideshow::slotKBParams ( )
{
  DialogKenBurns dialog;
  dialog.setSlideshow ( m_pSlideshow );
  if ( dialog.exec ( ) == QDialog::Accepted )   {
    if ( m_pSlideshow  && dialog.getSlideshow ( ) )
        *m_pSlideshow  = *dialog.getSlideshow ( );
         QString qsTitle = "Slideshow [";
         qsTitle += m_pSlideshow->slideshow_name + "] <";
         qsTitle += QString ( "%1 Imgs+ %2 Vids>" ).arg ( m_pSlideshow->countImg ( ) ).arg ( m_pSlideshow->countVid ( ) );
         setCaption ( qsTitle );
  }
}

void DialogSlideshow::slotKenBurns ( bool bChecked )
{
  if ( m_pSlideshow ) {
    // At this point we need the width / height information of the images,
    // which has not yet been generated.
    if ( bChecked && ! m_pSlideshow->bKenBurns )  {
      uint iImgCount = m_pSlideshow->countImg( );
      uint t;
      Utils theUtils;
      QCursor myCursor ( QCursor::WaitCursor );
      QApplication::setOverrideCursor ( myCursor );
      Cache::Thumbs::ImageEntry *pCache = NULL;
      for ( t=0; t<iImgCount; t++ )  {
        CXmlSlideshow::img_struct *pImg = m_pSlideshow->getImg ( t );
        if ( ! pImg )
          continue;
        if ( ( pImg->width == 0 ) || ( pImg->height == 0 ) ) {
          pCache = (Cache::Thumbs::ImageEntry *)Global::pThumbsCache->find ( pImg->src, true );
          if ( pCache )  {
            if ( theUtils.getWidthHeight ( pCache->qsDimension, pImg->width, pImg->height ) )  {
              // Trying to figure out when we rotated the image by 90deg.
              if ( ( ( pCache->iOrientation != 6 && pCache->iOrientation != 8 ) && ( pCache->fRotate == 90.0 || pCache->fRotate == 270.0 ) ) || 
                   ( ( pCache->iOrientation == 6 || pCache->iOrientation == 8 ) && ( pCache->fRotate ==  0.0 || pCache->fRotate == 360.0 ) ) ) {
                int w = pImg->width;
                pImg->width  = pImg->height;
                pImg->height = w;
              }
            }
          }
          else  {
            QImage img ( pImg->src );
            pImg->width  = img.width  ( );
            pImg->height = img.height ( );
            if ( pImg->pMatrix )  {
              img = img.xForm ( *pImg->pMatrix );
              pImg->width  = img.width  ( );
              pImg->height = img.height ( );
            }
          }
        }
        if ( t%10 == 9 )
          qApp->processEvents ( );
      }
    }
    m_pSlideshow->setKenBurns     ( bChecked );
    m_pButtonKBParams->setEnabled ( bChecked );
    QApplication::restoreOverrideCursor ();
  }
}

void DialogSlideshow::slotIntroPage ( bool )
{
  slotValueChanged ( 0 );
}

void DialogSlideshow::slotValueChanged ( int )
{
  Utils theUtils;
  int iFilterDelay     = m_pSpinFilterDelay->value ( );
  int iImageDelay      = m_pSpinImageDelay->value  ( );
  unsigned int iLength = ( iFilterDelay   + iImageDelay ) * m_pSlideshow->countImg ( );
  iLength += m_pSlideshow->vidsLength ( ) + iFilterDelay  * m_pSlideshow->countVid ( );
  if ( m_pCheckIntroPage->isChecked ( ) )
    iLength += iFilterDelay + iImageDelay;

  QString qsLength     = theUtils.getStringFromMs ( (long)( iLength * 1000 ) );
  m_pGroupGeneral->setTitle ( QString ( "General ( " )     + qsLength + QString ( " )" )  );
}

void DialogSlideshow::slotAnim ( )
{
  // User pushed button [Anim]
  QString qsAnim = tr ( "A\nn\ni\nm" );
  QString qsStop = tr ( "S\nt\no\np" );
  if ( m_bAnimated )  {
    m_pButtonAnim->setText  ( qsAnim );
    if ( m_pTimer )
         m_pTimer->stop ( );
    m_bAnimated = false;
  }
  else  {
    m_pButtonAnim->setText ( qsStop );
    // First we init the timer if required
    if ( ! m_pTimer )  {
      m_pTimer = new QTimer ( this );
      connect ( m_pTimer, SIGNAL ( timeout ( ) ), this, SLOT ( slotAnimatePix ( ) ) );
    }
    // start the timer
    m_pTimer->start ( 100 );
    m_bAnimated = true;
  }
  // and lastly, we recreate the pixmaps / preview ...
  recreatePix ( );
}

void DialogSlideshow::slotSelectionChanged ( QListViewItem * )
{
  QCheckListItem *pItem = (QCheckListItem *)m_pListViewTransitions->selectedItem ( );
  if ( ! pItem )
    return;

  QString qsTransitionPath = Global::qsSystemPath + QString ( "/share/qdvdauthor/slideshow/transitions/alpha/" );
  QString qsFilterName     = pItem->text ( );
  QString qsFileName       = qsTransitionPath + qsFilterName + ".jpg";

  QFileInfo fileInfo ( qsFileName );
  for ( int t=0; t<2; t++ )  {
    if ( fileInfo.exists ( ) )
      break;

    qsTransitionPath = Global::qsSystemPath + QString ( "/share/qdvdauthor/slideshow/transitions/luma/" );
    qsFileName       = qsTransitionPath + qsFilterName + ".png";
    fileInfo.setFile ( qsFileName );
  }
  if ( ! fileInfo.exists ( ) )
    return; // E.g. "Cross Fade"

  QImage theImage ( qsFileName );
  theImage = theImage.smoothScale ( m_pLabelPreview->size ( ) );
  QPixmap thePix;
  thePix.convertFromImage ( theImage );
  m_pLabelPreview->setPaletteBackgroundPixmap ( thePix );

  recreatePix ( );
}

void DialogSlideshow::recreatePix ( )
{
  QCheckListItem *pItem = (QCheckListItem *)m_pListViewTransitions->selectedItem ( );
  if ( ( ! pItem ) || ( ! m_pSlideshow ) )
    return;

  Utils theUtils;
  QCursor myCursor     ( QCursor::WaitCursor );
  QApplication::setOverrideCursor ( myCursor );

  QString qsTransitionPath = Global::qsSystemPath + QString ( "/share/qdvdauthor/slideshow/transitions/alpha/" );
  QString qsFilterName     = qsTransitionPath + pItem->text (   ) + ".jpg";

  QFileInfo fileInfo ( qsFilterName );
  if ( ! fileInfo.exists ( ) )  {
    qsTransitionPath = Global::qsSystemPath + QString ( "/share/qdvdauthor/slideshow/transitions/luma/" );
    qsFilterName     = qsTransitionPath + pItem->text (   ) + ".png";
  }

  if ( m_bAnimated )  {
    int      t, iDiff = 0;
    float    fDelta;
    bool     bImgBkgImg = m_pRadioImgBkgImg->isChecked ( );
    QPixmap *array[THUMBNAIL_COUNT];

    for ( t=0; t<THUMBNAIL_COUNT; t++ )
      array[t] = new QPixmap ( m_pLabelPreview->size ( ) );

    QImage filter ( qsFilterName );
    QImage start  = QImage::fromMimeSource ( "default.jpg" );
    QImage stop   = QImage::fromMimeSource (  "splash.jpg" );
    if ( m_pSlideshow->countImg ( ) >= 2 )  {
      CXmlSlideshow::img_struct *pStart = m_pSlideshow->getImg  ( 0 );
      CXmlSlideshow::img_struct *pStop  = m_pSlideshow->getImg  ( 1 );
      start = QImage ( pStart->src  );
      stop  = QImage ( pStop->src   );
    }

    QImage result     ( start ); // init the size
    QImage background ( start.copy ( ) ); // init the size
    if ( bImgBkgImg ) {
      QFileInfo fileInfo    ( m_qsBackground );
      if ( fileInfo.exists  ( ) )
        background = QImage ( m_qsBackground );
      else  {
        QColor theColor;
        theColor.setNamedColor ( m_qsBackground );
        background.fill ( theColor.rgb ( ) );
      }
      iDiff = 15;
    }
    background = background.smoothScale ( m_pLabelPreview->size ( ) );

    filter = filter.smoothScale ( m_pLabelPreview->size ( ) );
    start  = start.smoothScale  ( m_pLabelPreview->size ( ) );
    stop   = stop.smoothScale   ( m_pLabelPreview->size ( ) );
    result = result.smoothScale ( m_pLabelPreview->size ( ) );
    fDelta = 512.0f / ( THUMBNAIL_COUNT - iDiff - 1 );

    for ( t=0; t<THUMBNAIL_COUNT; t++ )  {
      if ( bImgBkgImg )
        theUtils.augmentAlpha ( (int)( fDelta * t ), (int)(fDelta * (t-iDiff)), filter, start, stop, result, &background );
      else
        theUtils.augmentAlpha ( (int)( fDelta * t ), filter, start, stop, result );

      array[t]->convertFromImage ( result );
    }
    for ( t=0; t<THUMBNAIL_COUNT; t++ )  {
      if ( m_arrayPix[t] )
        delete m_arrayPix[t];
      m_arrayPix[t] = array[t];
    }
  }
  else  {
    // Simply display the filter and do not use animation.
    QPixmap pix;
    QImage  filter ( qsFilterName );
    pix.convertFromImage ( filter.smoothScale   ( m_pLabelPreview->size ( ) ) );
    m_pLabelPreview->setPaletteBackgroundPixmap ( pix );
  }
  m_iCurrentPix = 0;

  QApplication::restoreOverrideCursor ( );
}

void DialogSlideshow::slotAnimatePix ( )
{
  m_iCurrentPix ++;
  if ( m_iCurrentPix < 0 )
    return;

  if ( m_iCurrentPix >= THUMBNAIL_COUNT )  {
    m_iCurrentPix = -10; // 1 sec pause between each run ...
    return;
  }
  m_pLabelPreview->setPaletteBackgroundPixmap ( *m_arrayPix[m_iCurrentPix] );
}

void DialogSlideshow::slotSelect ( )
{
  QStringList listEnabled;
  QCheckListItem *pItem = (QCheckListItem *)m_pListViewTransitions->firstChild ( );
  while ( pItem )  {
    if  ( pItem->isOn ( ) )
      listEnabled.append ( pItem->text ( ) );
    pItem = (QCheckListItem *)pItem->nextSibling ( );
  }

  DialogAlphaTrans filterDialog ( listEnabled, this );
  if ( filterDialog.exec ( )  ==  QDialog::Rejected )
    return;

  QString qsName;
  bool    bChecked;
  pItem = (QCheckListItem *)m_pListViewTransitions->firstChild ( );
  while ( pItem )  {
    qsName = pItem->text ( );
    bChecked = false;
    if  ( filterDialog.isChecked ( qsName ) )
      bChecked = true;
    pItem->setOn ( bChecked );
    pItem = (QCheckListItem *)pItem->nextSibling ( );
  }
}

void DialogSlideshow::slotAll ( )
{
  QCheckListItem *pItem = (QCheckListItem *)m_pListViewTransitions->firstChild ( );
  while ( pItem )  {
    pItem->setOn ( true );
    pItem = (QCheckListItem *)pItem->nextSibling ( );
  }
}

void DialogSlideshow::slotClear ( )
{
  QCheckListItem *pItem = (QCheckListItem *)m_pListViewTransitions->firstChild ( );
  while ( pItem )  {
    pItem->setOn ( false );
    pItem = (QCheckListItem *)pItem->nextSibling ( );
  }
}

void DialogSlideshow::slotImage ( )
{
  QString qsFilter   = Global::pApp->getImageFilter ( );
  QString qsFileName = FilePreviewDialog::getOpenFileName ( NULL, Global::qsCurrentPath, qsFilter, this );

  if ( qsFileName.isEmpty ( ) )
    return;

  QFileInfo fileInfo ( qsFileName );
  Global::qsCurrentPath = fileInfo.dirPath ( TRUE );

  QImage  theImg ( qsFileName );
  QPixmap thePix;
  if ( theImg.isNull ( ) )
    return;

  thePix.convertFromImage ( theImg.smoothScale ( m_pLabelBackground->size ( ), QImage::ScaleFree ) );
  m_pLabelBackground->setPixmap ( thePix );
  m_qsBackground = qsFileName;
}

void DialogSlideshow::slotColor ( )
{
  QColor theColor;
  if ( m_pSlideshow->background[0] != '/' )  {
    theColor.setNamedColor ( m_pSlideshow->background );

    if ( ! theColor.isValid ( ) )
      theColor.setNamedColor ( "#000000" );
  }
  else
    theColor.setNamedColor ( "#000000" );

  theColor = QColorDialog::getColor ( theColor, this );
  if ( ! theColor.isValid ( ) )
      return;

  QPixmap emptyPix;
  m_pLabelBackground->setPixmap  ( emptyPix );
  m_pLabelBackground->setBackgroundColor ( theColor );
  m_qsBackground = theColor.name ( );
}

void DialogSlideshow::slotAddAudio ( )
{
  QString qsFilter = "Audio ( " + Global::pApp->getSoundFilter  ( ) + ")";
  QStringList list = FilePreviewDialog::getOpenFileNames ( Global::qsCurrentPath, qsFilter, this );

  if ( list.count ( ) < 1 )
    return;

  m_listAudio += list;
  QFileInfo fileInfo ( list[0] );
  Global::qsCurrentPath = fileInfo.dirPath ( TRUE );

  QString   qsAudio;
  QStringList::iterator it = list.begin ( );
  while ( it  !=  list.end ( ) )  {
    qsAudio = *it++;
    fileInfo.setFile ( qsAudio );
    qsAudio = fileInfo.fileName ( );
    m_pListAudio->insertItem    ( qsAudio );
  }

  createAudioLength ( );
}

void DialogSlideshow::slotDeleteAudio ( )
{
  QString qsAudio = m_pListAudio->currentText ( );
  if ( qsAudio.isEmpty ( ) )
    return;

  m_pListAudio->removeItem ( m_pListAudio->currentItem ( ) );

  // The listBox only holds the file name, and not the whole path
  // thus we need to search for the right entry.
  QString qsInList;
  QStringList::iterator it = m_listAudio.begin ( );
  while ( it != m_listAudio.end ( ) )  {
    qsInList = *it++;
    if ( qsInList.find   ( qsAudio  ) > -1 ) {
      m_listAudio.remove ( qsInList );
      createAudioLength  ( );
      return;
    }
  }
}

}; // End of namespace Input

