/****************************************************************************
    Qt-BSch3V schematic capture
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#include "editcomponent.h"

#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <q3whatsthis.h>
#include <q3textedit.h>
#include <qcheckbox.h>
//Added by qt3to4:
#include <QHBoxLayout>
#include <QGridLayout>

/* 
 *  Constructs a editcomponentBase which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
editcomponentBase::editcomponentBase( QWidget* parent,  const char* name, bool modal, Qt::WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "editcomponentBase" );
    resize( 350, 250 ); 
    setProperty( "windowTitle", tr( "Qt-BSch EditComponent" ) );
//    setProperty( "caption", tr( "Qt-BSch EditComponent" ) );
    setProperty( "sizeGripEnabled", QVariant( FALSE, 0 ) );
    editcomponentBaseLayout = new QGridLayout( this ); 
    editcomponentBaseLayout->setSpacing( 6 );
    editcomponentBaseLayout->setMargin( 11 );

    Layout1 = new QHBoxLayout; 
    Layout1->setSpacing( 6 );
    Layout1->setMargin( 0 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout1->addItem( spacer );

    buttonOk = new QPushButton( this, "buttonOk" );
    //buttonOk->setProperty( "caption", tr( "" ) );
    buttonOk->setProperty( "text", tr( "&OK" ) );
    buttonOk->setProperty( "autoDefault", QVariant( TRUE, 0 ) );
    buttonOk->setProperty( "default", QVariant( TRUE, 0 ) );
    Layout1->addWidget( buttonOk );

    buttonCancel = new QPushButton( this, "buttonCancel" );
    buttonCancel->setProperty( "text", tr( "&Cancel" ) );
    buttonCancel->setProperty( "autoDefault", QVariant( TRUE, 0 ) );
    Layout1->addWidget( buttonCancel );

    editcomponentBaseLayout->addMultiCellLayout( Layout1, 10, 10, 0, 3 );


	TextLabel4 = new QLabel( this, "TextLabel4" );
    TextLabel4->setProperty( "sizePolicy", QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, TextLabel4->sizePolicy().hasHeightForWidth() ) );
    TextLabel4->setProperty( "text", tr( "Note" ) );
	editcomponentBaseLayout->addWidget( TextLabel4, 4, 0 );

	EditNote = new Q3TextEdit(this, "EditNote" );
	EditNote->setTabChangesFocus (true); 
	editcomponentBaseLayout->addMultiCellWidget( EditNote, 5, 9, 0, 3 );


    PinNumber = new QLabel( this, "PinNumber" );
    PinNumber->setProperty( "sizePolicy", QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)0, PinNumber->sizePolicy().hasHeightForWidth() ) );
    PinNumber->setProperty( "minimumSize", QSize( 140, 20 ) );
    PinNumber->setProperty( "text", tr( "" ) );

    editcomponentBaseLayout->addWidget( PinNumber, 2, 3 );

    EditName = new QLineEdit( this, "EditName" );

    editcomponentBaseLayout->addMultiCellWidget( EditName, 1, 1, 1, 3 );
	
	CheckReferenceVert = new QCheckBox(this,"CheckReferenceVert");
	setProperty( "sizePolicy", QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, CheckReferenceVert->sizePolicy().hasHeightForWidth() ) );
	CheckReferenceVert->setProperty( "text", tr( "Vertical" ) );
 	editcomponentBaseLayout->addMultiCellWidget( CheckReferenceVert,0, 0,4,4 );

	CheckNameVert = new QCheckBox(this,"CheckNameVert");
	setProperty( "sizePolicy", QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, CheckNameVert->sizePolicy().hasHeightForWidth() ) );
	CheckNameVert->setProperty( "text", tr( "Vertical" ) );
 	editcomponentBaseLayout->addMultiCellWidget( CheckNameVert,1, 1,4,4 );
	
	
	

    SpinBlock = new QSpinBox( this, "SpinBlock" );
    SpinBlock->setProperty( "sizePolicy", QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, SpinBlock->sizePolicy().hasHeightForWidth() ) );

    editcomponentBaseLayout->addMultiCellWidget( SpinBlock, 2, 2, 1, 2 );

    TextLabel1_2 = new QLabel( this, "TextLabel1_2" );
    TextLabel1_2->setProperty( "sizePolicy", QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, TextLabel1_2->sizePolicy().hasHeightForWidth() ) );
    TextLabel1_2->setProperty( "text", tr( "Name" ) );

    editcomponentBaseLayout->addWidget( TextLabel1_2, 1, 0 );

    TextLabel2 = new QLabel( this, "TextLabel2" );
    TextLabel2->setProperty( "sizePolicy", QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, TextLabel2->sizePolicy().hasHeightForWidth() ) );
    TextLabel2->setProperty( "text", tr( "Reference" ) );

    editcomponentBaseLayout->addWidget( TextLabel2, 0, 0 );

    EditReference = new QLineEdit( this, "EditReference" );
    EditReference->setProperty( "sizePolicy", QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)0, EditReference->sizePolicy().hasHeightForWidth() ) );

    editcomponentBaseLayout->addMultiCellWidget( EditReference, 0, 0, 1, 3 );

    OriginalName = new QLabel( this, "OriginalName" );
    OriginalName->setProperty( "sizePolicy", QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)0, OriginalName->sizePolicy().hasHeightForWidth() ) );
    OriginalName->setProperty( "text", tr( "" ) );

    editcomponentBaseLayout->addMultiCellWidget( OriginalName, 3, 3, 2, 3 );

    TextLabel3 = new QLabel( this, "TextLabel3" );
    TextLabel3->setProperty( "sizePolicy", QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, TextLabel3->sizePolicy().hasHeightForWidth() ) );
    TextLabel3->setProperty( "text", tr( "Block" ) );

    editcomponentBaseLayout->addWidget( TextLabel3, 2, 0 );

    TextLabel2_2 = new QLabel( this, "TextLabel2_2" );
    TextLabel2_2->setProperty( "text", tr( "OriginalName" ) );

    editcomponentBaseLayout->addMultiCellWidget( TextLabel2_2, 3, 3, 0, 1 );

    // signals and slots connections
    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect( SpinBlock, SIGNAL( valueChanged(int) ), this, SLOT( blockChanged(int) ) );

    // tab order
    setTabOrder( EditReference, CheckReferenceVert );
    setTabOrder( CheckReferenceVert, EditName );
    setTabOrder( EditName, CheckNameVert );
    setTabOrder( CheckNameVert, SpinBlock );
    setTabOrder( SpinBlock, EditNote );
    setTabOrder( EditNote, buttonOk );
    setTabOrder( buttonOk, buttonCancel );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
editcomponentBase::~editcomponentBase()
{
    // no need to delete child widgets, Qt does it all for us
}

void editcomponentBase::blockChanged(int)
{
    qWarning( "editcomponentBase::blockChanged(int): Not implemented yet!" );
}

