/****************************************************************************
    Qt-BSch3V schematic capture
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#ifndef APPLICATION_H
#define APPLICATION_H

#include <q3mainwindow.h>
#include <qwidget.h>
//Added by qt3to4:
#include <QLabel>
#include <QKeyEvent>
#include <Q3PopupMenu>
#include <QCloseEvent>
#include <QPrinter>

#include "xbsch.h"

//class QMultiLineEdit;
class Q3ToolBar;
class QLabel;
class Q3PopupMenu;
class QToolButton;
class Q3ScrollView;
class SXBSchView;
class QAction;

class ApplicationWindow: public Q3MainWindow
{
	Q_OBJECT
public:
    ApplicationWindow();
	~ApplicationWindow();
	QString fileName();
	bool isEmptyDocWindow();
	static  ApplicationWindow* firstEmptyDocWindow();
protected:
    void closeEvent( QCloseEvent* );
	void keyPressEvent ( QKeyEvent * e );
	void ZoomIn(bool menucommand);
	void ZoomOut(bool menucommand);

public slots:
void load(const QString &fn);

private slots:
	//MENU
	//FILE
	void newDoc();
    void load();
    int save();
    int saveAs();
    void print();
    void printOption();	
	void exportImage();
	//EDIT
	void EditUndo();
	void EditCut();
	void EditCopy();
	void EditPaste();
	void EditDelete();
	void EditAttr();
	void EditMirror();
	void EditRotate();
	void EditInvert();
	
	void MoveToLayer0();
	void MoveToLayer1();
	void MoveToLayer2();
	void MoveToLayer3();
	void MoveToLayer4();
	void MoveToLayer5();
	void MoveToLayer6();
	void MoveToLayer7();
	
	void SetupLayer();
	
	//VIEW
	void ViewRefresh();
	void ViewZoomIn();
	void ViewZoomOut();
	void ViewGridOnOff();
	//TOOL
	void ToolSelector();
	void ToolDrag();
	void ToolComp();
	void ToolBus();
	void ToolWire();
	void ToolDash();
	void ToolJunction();
	void ToolBEntry();
	void ToolEntry();
	void ToolTag();
	void ToolLabel();
	void ToolCmnt();
	//SET
	void SetSheetSize();
	void SetSnap();
	void SetLibrary();
	void SetFont();
	void SetSmallFont();
	//HELP
    void about();
    void aboutQt();

	//ӥ塼ǤΥ֤ΰư
	void cursorMove(int x,int y);
	void toolChange();
	
	//Edit˥塼Υߥ󥰤
	void setupEditMenu();

	//Window˥塼Υߥ󥰤
	void setupWindowMenu();
	
	//Window˥塼Υƥब򤵤줿ȤSLOT
	void selectActiveDocument(QAction*);
	
	void redrawAll();

private:
	static QWidgetList m_appWindowList;

    QPrinter* printer;

    Q3ToolBar* toolbar;
    QString m_filename;
	QLabel* m_plabelX;
	QLabel* m_plabelY;
	
	QMenu *m_menuWindow;
	QMenu *m_menuEdit;

	QToolButton* m_ptbFileOpen;
	QToolButton* m_ptbFileSave;
    QToolButton* m_ptbFilePrint;
    QToolButton* m_ptbToolSelect;
    QToolButton* m_ptbToolDrag;
    QToolButton* m_ptbToolComp;
    QToolButton* m_ptbToolBus;
    QToolButton* m_ptbToolWire;
    QToolButton* m_ptbToolDash;
    QToolButton* m_ptbToolJunc;
    QToolButton* m_ptbToolBEnt;
    QToolButton* m_ptbToolEnt;
    QToolButton* m_ptbToolTag;
    QToolButton* m_ptbToolLabel;
    QToolButton* m_ptbToolCmnt;

	QAction* m_nMenuItemEditUndo;
	QAction* m_nMenuItemEditCut;
	QAction* m_nMenuItemEditCopy;
	QAction* m_nMenuItemEditPaste;
	QAction* m_nMenuItemEditDelete;
	QAction* m_nMenuItemEditAttr;
	QAction* m_nMenuItemEditMirror;
	QAction* m_nMenuItemEditRotate;
	QAction* m_nMenuItemEditInvert;
	QAction* m_nMenuItemEditMoveTo0;
	QAction* m_nMenuItemEditMoveTo1;
	QAction* m_nMenuItemEditMoveTo2;
	QAction* m_nMenuItemEditMoveTo3;
	QAction* m_nMenuItemEditMoveTo4;
	QAction* m_nMenuItemEditMoveTo5;
	QAction* m_nMenuItemEditMoveTo6;
	QAction* m_nMenuItemEditMoveTo7;
	QAction* m_nMenuItemEditSetupLayer;
	

	QAction* m_nMenuItemViewZoomIn;
	QAction* m_nMenuItemViewZoomOut;
	QAction* m_nMenuItemViewGrid;

	QAction* m_nMenuItemToolSelect;
	QAction* m_nMenuItemToolDrag;
	QAction* m_nMenuItemToolComp;
	QAction* m_nMenuItemToolBus;
	QAction* m_nMenuItemToolWire;
	QAction* m_nMenuItemToolDash;
	QAction* m_nMenuItemToolJunc;
	QAction* m_nMenuItemToolBEnt;
	QAction* m_nMenuItemToolEnt;
	QAction* m_nMenuItemToolTag;
	QAction* m_nMenuItemToolLabel;
	QAction* m_nMenuItemToolCmnt;
	

	QAction* m_nMenuItemSetSnap;


private:
	//BSCH_TOOL_MODE m_toolmode;
	void SetToolButtonState();	//ġܥξ֤ꤹ

//	QScrollView* m_pScrollView;
	SXBSchView* m_pXBSchView;
	
	void setAppCaption();		//ץꥱΥץ


};


#endif

