
/*  Q eQuational Programming System
    Copyright (c) 1991-2002 by Albert Graef
    <ag@muwiinfa.geschichte.uni-mainz.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/*

Q code instruction format:

Any Q code instruction consists of an opcode optionally followed
by some arguments. This format is implemented by the structure
described below. Here is a table of the different opcodes, their
meanings and mnemonics, and the arguments they take:

opcode		arguments	mnemonic    	    meaning
-----------	---------------	-----------	    -------------------------
RETOP				!RET		    return from rule
LVALOP      	lval		ofs$p1$p2...	    push a lhs value
QUERYOP		addr, ofs	? addr/ofs	    abort rule if not true
MATCHOP		m, addr, ofs	?MATCH #m addr/ofs  match (pattern binding)
INFOP		info		!INFO mno lno	    source module and line no
POPOP				!POP		    pop expression from stack
INTVALOP	iv		<number>	    push an int constant
FLOATVALOP	fv		<number>	    push a float constant
STRVALOP	sv		<string>	    push a string constant
CONSOP                          [|]                 construct a list node
PAIROP                          (|)                 construct a pair node
APPOP                           @                   apply

Other positive opcodes (ADDOP..) represent built-in and user-defined
symbols. Each instruction also contains a "mode" flag which is used to handle
special forms at runtime.

NOTE: As of Q 7.7, the QUERYOP and MATCHOP instructions have a jump address
and a stack offset as additional arguments. The jump address may be -1 to
indicate "abort rule". Otherwise the address denotes a code address to jump to
while unwinding the stack to the given stack offset if the qualifier
fails. The new operations allow multiple equations for the same lhs to be
implemented as a single rule.

*/

enum opcodes {

/* reserved opcodes of the Q machine: */

        RETOP, LVALOP, QUERYOP, MATCHOP, DEFOP, UNDEFOP, INFOP, POPOP,
	INTVALOP, FLOATVALOP, STRVALOP, FILEVALOP, BADFILEVALOP, VECTOP,
	USRVALOP,

/* binary symbols: */

	CONSOP, PAIROP, APPOP,

/* built-in constants: */

	FALSEOP, TRUEOP, NILOP, SNILOP, SCONSOP, VOIDOP,

/* operator symbols: */

	CATOP, ADDOP, MINOP, MULOP, FDIVOP, DIVOP, MODOP,
	POWOP, IDXOP, COMPOP,

	UMINOP, HASHOP, QUOTEOP, UNQUOTEOP, FORCEOP, MEMOP,

	OROP, ANDOP, ORELSEOP, ANDTHENOP, NOTOP,

	LEOP, GROP, EQOP, LEQOP, GEQOP, NEQOP, IDOP,

	RAPPOP, SEQOP,

/* other predefined function symbols: */

	SHLOP, SHROP, PREDOP, SUCCOP,
	ENUMOP, ENUM1OP, TENUMOP, TENUM1OP, SENUMOP, SENUM1OP,

	EXPOP, LNOP, SQRTOP, SINOP, COSOP, ATANOP, ATAN2OP, RANDOMOP, SEEDOP,

	SUBOP, SUBSTROP, POSOP,

	INTOP, FRACOP, TRUNCOP, ROUNDOP, FLOATOP, HASHNUMOP, ORDOP, CHROP,
	LISTOP, TUPLEOP, STROP, VALOP, STRQOP, VALQOP,

	ISSPECIALOP, ISCONSTOP, ISFUNOP, ISVAROP, ISDEFOP, FLIPOP,

	READOP, READQOP, READCOP, READSOP,
	WRITEOP, WRITEQOP, WRITECOP, WRITESOP,

	FREADOP, FREADQOP, FREADCOP, FREADSOP,
	FWRITEOP, FWRITEQOP, FWRITECOP, FWRITESOP,

	FOPENOP, POPENOP, FCLOSEOP, EOFOP, FEOFOP, FLUSHOP, FFLUSHOP,

	VERSIONOP, SYSINFOOP, WHICHOP, HALTOP, QUITOP, BREAKOP,
	CATCHOP, THROWOP, TRAPOP, FAILOP, FAIL2OP, SYSERROP,
	LAMBDAOP, LAMBDAXOP,
	TIMEOP, SLEEPOP, UNPARSEOP,
	
/* predefined variable symbols: */

	INPUTOP, OUTPUTOP, ERROROP, ARGSOP, DEFVAROP,

/* predefined type symbols: */

	NUMTYPE, REALTYPE, INTTYPE, FLOATTYPE, STRTYPE, CHARTYPE, FILETYPE,
	LISTTYPE, STREAMTYPE, TUPLETYPE, BOOLTYPE,
	LAMBDATYPE, LAMBDAVARTYPE, FUNCTIONTYPE, EXCEPTTYPE, SYSEXCEPTTYPE,

/* built-in symbols stop here: */

	BUILTIN,

/* built-in type symbols start here: */

	TYPESYMS = NUMTYPE,

/* reserved symbols stop here: */

	RESERVED = CONSOP,

/* binary symbols stop here: */

	BINARY = FALSEOP,

/* the following is reserved for use in the Q compiler: */

	VAROP = -1

};
