# dictformat-pubdic.rb: Converter module for pubdic format.
# $Id: dictformat-pubdic.rb,v 1.2 2004/03/25 17:19:51 komatsu Exp $
#
# Copyright (C) 2003 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.

require 'prime/makedict/dictformat'
$KCODE = 'e'

class DictFormatPubdic < DictFormat
  @@alt_hinshi = {
    "#KYU" => "ŵ",     "#OKX" => "ǫ",
    "#SX"  => "()", "#T30" => "()",
    "#SUC" => "",
  }

  def parse (line)
    line.chomp!
    (pattern, word, hinshi_line, freq, attr) = line.split(/ /)
    (hinshi, hinshi2) = hinshi_line.split(/\//)
    if hinshi == "" then
      hinshi = @@alt_hinshi[hinshi2]
    end
    return [[pattern, hinshi, word, freq, attr]]
  end
end
