# dictformat-adambnc.rb: Converter module for Adam's BNC word frequency list.
# See also: http://www.itri.bton.ac.uk/~Adam.Kilgarriff/bnc-readme.html
# $Id: dictformat-adambnc.rb,v 1.2 2005/03/07 07:51:33 komatsu Exp $
#
# Copyright (C) 2003 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.

require 'prime/prime-config'
require 'prime/makedict/dictformat'

class DictFormatAdamBNC < DictFormat
  
  def initialize (is_interactive = true)
    super(is_interactive)
  end

  def parse (line)
    line.chomp!
    words = []
    (frequency, word, pos, file_num) = line.split(/ /)
    
    score = frequency.to_i / 50
    words << [word, pos, word, score]
    return words
  end
end
