/* Generated By:JJTree: Do not edit this line. ASTLocalVariableDeclaration.java */

package net.sourceforge.pmd.ast;

import net.sourceforge.pmd.Rule;

public class ASTLocalVariableDeclaration extends AccessNode implements Dimensionable, CanSuppressWarnings {

    public ASTLocalVariableDeclaration(int id) {
        super(id);
    }

    public ASTLocalVariableDeclaration(JavaParser p, int id) {
        super(p, id);
    }

    /**
     * Accept the visitor. *
     */
    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean hasSuppressWarningsAnnotationFor(Rule rule) {
        for (int i = 0; i < jjtGetNumChildren(); i++) {
            if (jjtGetChild(i) instanceof ASTAnnotation) {
                ASTAnnotation a = (ASTAnnotation) jjtGetChild(i);
                if (a.suppresses(rule)) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isArray() {
        return checkType() + checkDecl() > 0;
    }

    public int getArrayDepth() {
        return checkType() + checkDecl();
    }

    public ASTType getTypeNode() {
        for (int i = 0; i < jjtGetNumChildren(); i++) {
            if (jjtGetChild(i) instanceof ASTType) {
                return (ASTType) jjtGetChild(i);
            }
        }
        throw new IllegalStateException("ASTType not found");
    }

    private int checkType() {
        return getTypeNode().getArrayDepth();
    }

    private ASTVariableDeclaratorId getDecl() {
        return (ASTVariableDeclaratorId) jjtGetChild(jjtGetNumChildren()-1).jjtGetChild(0);
    }

    private int checkDecl() {
        return getDecl().getArrayDepth();
    }

    public void dump(String prefix) {
        String out = "";
        if (isArray()) {
            out += "(array";
            for (int i = 0; i < getArrayDepth(); i++) {
                out += "[";
            }
            out += ")";
        }
        if (isFinal()) {
            out += "(final)";
        }
        System.out.println(toString(prefix) + out);
        dumpChildren(prefix);
    }
    
    /**
     * Gets the variable name of this field.
     * This method searches the first VariableDeclartorId node and returns it's image or <code>null</code> if the child node is not found.
     *
     * @return a String representing the name of the variable
     */
    public String getVariableName() {
        ASTVariableDeclaratorId decl = getFirstChildOfType(ASTVariableDeclaratorId.class);
        if (decl != null) {
            return decl.getImage();
        }
        return null;
    }
}
