/*
** libconfiguration
** $Id: configuration.h,v 1.1 2006/04/08 06:29:26 sella Exp $
** Copyright (c) 2006 James M. Sella. All Rights Reserved.
** Released under the GPL Version 2 License.
** http://www.digitalgenesis.com
*/

#ifndef __DGS_LIBCONFIGURATION_CONFIGURATION_H
#define __DGS_LIBCONFIGURATION_CONFIGURATION_H

#include <stdio.h>

struct config_node {
	char* var;
	char* val;
	struct config_node* sub;
	struct config_node* next;
};

int read_conf_file(const char *config_file, struct config_node **node);
void free_config_nodes(struct config_node *node);
void print_config_nodes(struct config_node *node, int depth);
int parse_config(FILE *fp, struct config_node** node_h, const char* level);

#endif 

/*
** Local Variables:
** c-basic-offset: 3
** tab-width: 3
** End:
** vim: noet ts=3 sw=3
*/
