/*
  +----------------------------------------------------------------------+
  | PHP Version 5                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997-2006 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.0 of the PHP license,       |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_0.txt.                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Author: Sara Golemon <pollita@php.net>                               |
  +----------------------------------------------------------------------+
*/

/* $Id: php_parsekit.h 289718 2009-10-17 21:40:17Z sean $ */

#ifndef PHP_PARSEKIT_H
#define PHP_PARSEKIT_H

#define PHP_PARSEKIT_VERSION "1.3.0"

#ifdef ZTS
#include "TSRM.h"
#endif

extern zend_module_entry parsekit_module_entry;
#define phpext_parsekit_ptr &parsekit_module_entry

PHP_MINIT_FUNCTION(parsekit);
PHP_MSHUTDOWN_FUNCTION(parsekit);
PHP_MINFO_FUNCTION(parsekit);

PHP_FUNCTION(parsekit_compile_string);
PHP_FUNCTION(parsekit_compile_file);
PHP_FUNCTION(parsekit_opcode_flags);
PHP_FUNCTION(parsekit_opcode_name);
PHP_FUNCTION(parsekit_func_arginfo);

ZEND_BEGIN_MODULE_GLOBALS(parsekit)
	int in_parsekit_compile;
	zval *compile_errors;
ZEND_END_MODULE_GLOBALS(parsekit)

#ifdef ZTS
#define PARSEKIT_G(v) TSRMG(parsekit_globals_id, zend_parsekit_globals *, v)
#else
#define PARSEKIT_G(v) (parsekit_globals.v)
#endif

typedef struct _php_parsekit_define_list {
	long val;
	char *str;
	long flags;
} php_parsekit_define_list;

#ifdef ZEND_ENGINE_2
#define PHP_PARSEKIT_TSRMLS_CC_ZE2ONLY	TSRMLS_CC
#else
#define PHP_PARSEKIT_TSRMLS_CC_ZE2ONLY
#endif

#define PHP_PARSEKIT_QUIET			0
#define PHP_PARSEKIT_ALWAYS_SET			1
#define PHP_PARSEKIT_ALL_ELEMENTS		2
#define PHP_PARSEKIT_SIMPLE			3

#define PHP_PARSEKIT_UNKNOWN			"UNKNOWN"
#define PHP_PARSEKIT_OPCODE_UNKNOWN		"Unknown Opcode"
#define PHP_PARSEKIT_NODETYPE_UNKNOWN	"Unknown Nodetype"
#define PHP_PARSEKIT_FUNCTYPE_UNKNOWN	"Unknown Functiontype"
#define PHP_PARSEKIT_CLASSTYPE_UNKNOWN	"Unknown Classtype"

/* Opcode Flags */

#define PHP_PARSEKIT_RESULT_CONST		0x00000001
#define PHP_PARSEKIT_RESULT_VAR			0x00000002
#define PHP_PARSEKIT_RESULT_OPLINE		0x00000004
#define PHP_PARSEKIT_RESULT_OPARRAY		0x00000008
#define PHP_PARSEKIT_RESULT_JMP_ADDR	0x00000010
#define PHP_PARSEKIT_RESULT_EA_TYPE		0x00000020

#define PHP_PARSEKIT_RESULT_GETVAR		(PHP_PARSEKIT_RESULT_CONST | PHP_PARSEKIT_RESULT_VAR)
#define PHP_PARSEKIT_RESULT_USED		0x000000FF

#define PHP_PARSEKIT_OP1_CONST			0x00000100
#define PHP_PARSEKIT_OP1_VAR			0x00000200
#define PHP_PARSEKIT_OP1_OPLINE			0x00000400
#define PHP_PARSEKIT_OP1_OPARRAY		0x00000800
#define PHP_PARSEKIT_OP1_JMP_ADDR		0x00001000
#define PHP_PARSEKIT_OP1_EA_TYPE		0x00002000

#define PHP_PARSEKIT_OP1_GETVAR			(PHP_PARSEKIT_OP1_CONST | PHP_PARSEKIT_OP1_VAR)
#define PHP_PARSEKIT_OP1_USED			0x0000FF00

#define PHP_PARSEKIT_OP2_CONST			0x00010000
#define PHP_PARSEKIT_OP2_VAR			0x00020000
#define PHP_PARSEKIT_OP2_OPLINE			0x00040000
#define PHP_PARSEKIT_OP2_OPARRAY		0x00080000
#define PHP_PARSEKIT_OP2_JMP_ADDR		0x00100000
#define PHP_PARSEKIT_OP2_EA_TYPE		0x00200000

#define PHP_PARSEKIT_OP2_GETVAR			(PHP_PARSEKIT_OP2_CONST | PHP_PARSEKIT_OP2_VAR)
#define PHP_PARSEKIT_OP2_USED			0x00FF0000

#define PHP_PARSEKIT_EXTENDED_VALUE		0x01000000

#define PHP_PARSEKIT_USAGE_UNKNOWN		0xFFFFFFFF

#define PHP_PARSEKIT_CONSY				( PHP_PARSEKIT_RESULT_CONST		| PHP_PARSEKIT_OP1_CONST	| PHP_PARSEKIT_OP2_CONST )
#define PHP_PARSEKIT_VAR				( PHP_PARSEKIT_RESULT_VAR		| PHP_PARSEKIT_OP1_VAR		| PHP_PARSEKIT_OP2_VAR )
#define PHP_PARSEKIT_OPLINE				( PHP_PARSEKIT_RESULT_OPLINE	| PHP_PARSEKIT_OP1_OPLINE	| PHP_PARSEKIT_OP2_OPLINE )
#define PHP_PARSEKIT_OPARRAY			( PHP_PARSEKIT_RESULT_OPARRAY	| PHP_PARSEKIT_OP1_OPARRAY	| PHP_PARSEKIT_OP2_OPARRAY )
#define PHP_PARSEKIT_JMP_ADDR			( PHP_PARSEKIT_RESULT_JMP_ADDR	| PHP_PARSEKIT_OP1_JMP_ADDR	| PHP_PARSEKIT_OP2_JMP_ADDR )
#define PHP_PARSEKIT_EA_TYPE			( PHP_PARSEKIT_RESULT_EA_TYPE	| PHP_PARSEKIT_OP1_EA_TYPE	| PHP_PARSEKIT_OP2_EA_TYPE )

static php_parsekit_define_list php_parsekit_opnode_flags[] = {
	{ PHP_PARSEKIT_RESULT_CONST,		"RESULT_CONST" },
	{ PHP_PARSEKIT_RESULT_VAR,			"RESULT_VAR" },
	{ PHP_PARSEKIT_RESULT_OPLINE,		"RESULT_OPLINE" },
	{ PHP_PARSEKIT_RESULT_OPARRAY,		"RESULT_OPARRAY" },
	{ PHP_PARSEKIT_RESULT_JMP_ADDR,		"RESULT_JMP_ADDR" },
	{ PHP_PARSEKIT_RESULT_EA_TYPE,		"RESULT_EA_TYPE" },
	{ PHP_PARSEKIT_OP1_CONST,			"OP1_CONST" },
	{ PHP_PARSEKIT_OP1_VAR,				"OP1_VAR" },
	{ PHP_PARSEKIT_OP1_OPLINE,			"OP1_OPLINE" },
	{ PHP_PARSEKIT_OP1_OPARRAY,			"OP1_OPARRAY" },
	{ PHP_PARSEKIT_OP1_JMP_ADDR,		"OP1_JMP_ADDR" },
	{ PHP_PARSEKIT_OP1_EA_TYPE,			"OP1_EA_TYPE" },
	{ PHP_PARSEKIT_OP2_CONST,			"OP2_CONST" },
	{ PHP_PARSEKIT_OP2_VAR,				"OP2_VAR" },
	{ PHP_PARSEKIT_OP2_OPLINE,			"OP2_OPLINE" },
	{ PHP_PARSEKIT_OP2_OPARRAY,			"OP2_OPARRAY" },
	{ PHP_PARSEKIT_OP2_JMP_ADDR,		"OP2_JMP_ADDR" },
	{ PHP_PARSEKIT_OP2_EA_TYPE,			"OP2_EA_TYPE" },
	{ PHP_PARSEKIT_EXTENDED_VALUE,		"EXTENDED_VALUE" },
	{ PHP_PARSEKIT_USAGE_UNKNOWN,		"USAGE_UNKNOWN" },
	{ 0, NULL }
};

static php_parsekit_define_list php_parsekit_class_types[] = {
	{ ZEND_INTERNAL_CLASS, "ZEND_INTERNAL_CLASS" },
	{ ZEND_USER_CLASS, "ZEND_USER_CLASS" },
	{ 0, NULL }
};

static php_parsekit_define_list php_parsekit_function_types[] = {
	{ ZEND_INTERNAL_FUNCTION, "ZEND_INTERNAL_FUNCTION" },
	{ ZEND_USER_FUNCTION, "ZEND_USER_FUNCTION" },
	{ ZEND_OVERLOADED_FUNCTION, "ZEND_OVERLOADED_FUNCTION" },
	{ ZEND_EVAL_CODE, "ZEND_EVAL_CODE" },
#ifdef ZEND_OVERLOADED_FUNCTION_TEMPORARY
/* ZE2 Only */
	{ ZEND_OVERLOADED_FUNCTION_TEMPORARY, "ZEND_OVERLOADED_FUNCTION_TEMPORARY" },
#endif
	{ 0, NULL }
};

static php_parsekit_define_list php_parsekit_nodetype_names[] = {
	{ IS_CONST, "IS_CONST" },
	{ IS_TMP_VAR, "IS_TMP_VAR" },
	{ IS_VAR, "IS_VAR" },
	{ IS_UNUSED, "IS_UNUSED" },
#ifdef IS_CV
/* PHP >= 5.1 */
	{ IS_CV, "IS_CV" },
#endif
	{ 0, NULL }
};

static php_parsekit_define_list php_parsekit_opcode_names[] = {
	{ ZEND_NOP,						"ZEND_NOP",						0 },
	{ ZEND_ADD,						"ZEND_ADD",						PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_SUB,						"ZEND_SUB",						PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_MUL,						"ZEND_MUL",						PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_DIV,						"ZEND_DIV",						PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_MOD,						"ZEND_MOD",						PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_SL,						"ZEND_SL",						PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_SR,						"ZEND_SR",						PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_CONCAT,					"ZEND_CONCAT",					PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_BW_OR,					"ZEND_BW_OR",					PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_BW_AND,					"ZEND_BW_AND",					PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_BW_XOR,					"ZEND_BW_XOR",					PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_BW_NOT,					"ZEND_BW_NOT",					PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR },
	{ ZEND_BOOL_NOT,				"ZEND_BOOL_NOT",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR },
	{ ZEND_BOOL_XOR,				"ZEND_BOOL_XOR",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_IS_IDENTICAL,			"ZEND_IS_IDENTICAL",			PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_IS_NOT_IDENTICAL,		"ZEND_IS_NOT_IDENTICAL",		PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_IS_EQUAL,				"ZEND_IS_EQUAL",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_IS_NOT_EQUAL,			"ZEND_IS_NOT_EQUAL",			PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_IS_SMALLER,				"ZEND_IS_SMALLER",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_IS_SMALLER_OR_EQUAL,		"ZEND_IS_SMALLER_OR_EQUAL",		PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_CAST,					"ZEND_CAST",					PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_QM_ASSIGN,				"ZEND_QM_ASSIGN",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR },
	{ ZEND_ASSIGN_ADD,				"ZEND_ASSIGN_ADD",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_ASSIGN_SUB,				"ZEND_ASSIGN_SUB",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_ASSIGN_MUL,				"ZEND_ASSIGN_MUL",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_ASSIGN_DIV,				"ZEND_ASSIGN_DIV",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_ASSIGN_MOD,				"ZEND_ASSIGN_MOD",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_ASSIGN_SL,				"ZEND_ASSIGN_SL",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_ASSIGN_SR,				"ZEND_ASSIGN_SR",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_ASSIGN_CONCAT,			"ZEND_ASSIGN_CONCAT",			PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_ASSIGN_BW_OR,			"ZEND_ASSIGN_BW_OR",			PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_ASSIGN_BW_AND,			"ZEND_ASSIGN_BW_AND",			PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_ASSIGN_BW_XOR,			"ZEND_ASSIGN_BW_XOR",			PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_PRE_INC,					"ZEND_PRE_INC",					PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR },
	{ ZEND_PRE_DEC,					"ZEND_PRE_DEC",					PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR },
	{ ZEND_POST_INC,				"ZEND_POST_INC",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR },
	{ ZEND_POST_DEC,				"ZEND_POST_DEC",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR },
	{ ZEND_ASSIGN,					"ZEND_ASSIGN",					PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_RESULT_EA_TYPE | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_ASSIGN_REF,				"ZEND_ASSIGN_REF",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_RESULT_EA_TYPE | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_ECHO,					"ZEND_ECHO",					PHP_PARSEKIT_OP1_GETVAR },
	{ ZEND_PRINT,					"ZEND_PRINT",					PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR },
	{ ZEND_JMP,						"ZEND_JMP",						PHP_PARSEKIT_OP1_OPLINE | PHP_PARSEKIT_OP1_JMP_ADDR },
	{ ZEND_JMPZ,					"ZEND_JMPZ",					PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_OPLINE | PHP_PARSEKIT_OP2_JMP_ADDR },
	{ ZEND_JMPNZ,					"ZEND_JMPNZ",					PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_OPLINE | PHP_PARSEKIT_OP2_JMP_ADDR },
	{ ZEND_JMPZNZ,					"ZEND_JMPZNZ",					PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_OPLINE | PHP_PARSEKIT_OP2_JMP_ADDR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_JMPZ_EX,					"ZEND_JMPZ_EX",					PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_OPLINE | PHP_PARSEKIT_OP2_JMP_ADDR },
	{ ZEND_JMPNZ_EX,				"ZEND_JMPNZ_EX",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_OPLINE | PHP_PARSEKIT_OP2_JMP_ADDR },
	{ ZEND_CASE,					"ZEND_CASE",					PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_SWITCH_FREE,				"ZEND_SWITCH_FREE",				PHP_PARSEKIT_OP1_VAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_BRK,						"ZEND_BRK",						PHP_PARSEKIT_OP1_VAR | PHP_PARSEKIT_OP1_OPLINE | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_CONT,					"ZEND_CONT",					PHP_PARSEKIT_OP1_VAR | PHP_PARSEKIT_OP1_OPLINE | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_BOOL,					"ZEND_BOOL",					PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR },
	{ ZEND_INIT_STRING,				"ZEND_INIT_STRING",				PHP_PARSEKIT_RESULT_VAR },
	{ ZEND_ADD_CHAR,				"ZEND_ADD_CHAR",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_CONST },
	{ ZEND_ADD_STRING,				"ZEND_ADD_STRING",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_CONST },
	{ ZEND_ADD_VAR,					"ZEND_ADD_VAR",					PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_BEGIN_SILENCE,			"ZEND_BEGIN_SILENCE",			PHP_PARSEKIT_RESULT_VAR },
	{ ZEND_END_SILENCE,				"ZEND_END_SILENCE",				PHP_PARSEKIT_OP1_VAR },
	{ ZEND_INIT_FCALL_BY_NAME,		"ZEND_INIT_FCALL_BY_NAME",		PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_DO_FCALL,				"ZEND_DO_FCALL",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_DO_FCALL_BY_NAME,		"ZEND_DO_FCALL_BY_NAME",		PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_RETURN,					"ZEND_RETURN",					PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_RECV,					"ZEND_RECV",					PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_CONST },
	{ ZEND_RECV_INIT,				"ZEND_RECV_INIT",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_CONST | PHP_PARSEKIT_OP2_CONST },
	{ ZEND_SEND_VAL,				"ZEND_SEND_VAL",				PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_OPLINE | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_SEND_VAR,				"ZEND_SEND_VAR",				PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_OPLINE | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_SEND_REF,				"ZEND_SEND_REF",				PHP_PARSEKIT_OP1_GETVAR },
	{ ZEND_NEW,						"ZEND_NEW",						PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_VAR },
#ifdef ZEND_JMP_NO_CTOR
/* Pre-PHP 5.1 only */
	{ ZEND_JMP_NO_CTOR,				"ZEND_JMP_NO_CTOR",				PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_OPLINE },
#endif
	{ ZEND_FREE,					"ZEND_FREE",					PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP1_EA_TYPE | PHP_PARSEKIT_OP2_OPLINE },
	{ ZEND_INIT_ARRAY,				"ZEND_INIT_ARRAY",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_ADD_ARRAY_ELEMENT,		"ZEND_ADD_ARRAY_ELEMENT",		PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_INCLUDE_OR_EVAL,			"ZEND_INCLUDE_OR_EVAL",			PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_CONST },
	{ ZEND_UNSET_VAR,				"ZEND_UNSET_VAR",				PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_EA_TYPE },
#ifdef ZEND_UNSET_DIM_OBJ
/* Pre-PHP 5.1 only */
	{ ZEND_UNSET_DIM_OBJ,			"ZEND_UNSET_DIM_OBJ",			PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
#endif
#ifdef ZEND_ISSET_ISEMPTY
/* ZE1 Only */
	{ ZEND_ISSET_ISEMPTY,			"ZEND_ISSET_ISEMPTY",			PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_CONST },
#endif
	{ ZEND_FE_RESET,				"ZEND_FE_RESET",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_OPLINE | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_FE_FETCH,				"ZEND_FE_FETCH",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_OPLINE | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_EXIT,					"ZEND_EXIT",					PHP_PARSEKIT_OP1_GETVAR },
	{ ZEND_FETCH_R,					"ZEND_FETCH_R",					PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_VAR | PHP_PARSEKIT_OP2_EA_TYPE },
	{ ZEND_FETCH_DIM_R,				"ZEND_FETCH_DIM_R",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_FETCH_OBJ_R,				"ZEND_FETCH_OBJ_R",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_FETCH_W,					"ZEND_FETCH_W",					PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_VAR | PHP_PARSEKIT_OP2_EA_TYPE },
	{ ZEND_FETCH_DIM_W,				"ZEND_FETCH_DIM_W",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_FETCH_OBJ_W,				"ZEND_FETCH_OBJ_W",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_FETCH_RW,				"ZEND_FETCH_RW",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_VAR | PHP_PARSEKIT_OP2_EA_TYPE },
	{ ZEND_FETCH_DIM_RW,			"ZEND_FETCH_DIM_RW",			PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_FETCH_OBJ_RW,			"ZEND_FETCH_OBJ_RW",			PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_FETCH_IS,				"ZEND_FETCH_IS",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_EA_TYPE },
	{ ZEND_FETCH_DIM_IS,			"ZEND_FETCH_DIM_IS",			PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_FETCH_OBJ_IS,			"ZEND_FETCH_OBJ_IS",			PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_FETCH_FUNC_ARG,			"ZEND_FETCH_FUNC_ARG",			PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_OP2_EA_TYPE | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_FETCH_DIM_FUNC_ARG,		"ZEND_FETCH_DIM_FUNC_ARG",		PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_FETCH_OBJ_FUNC_ARG,		"ZEND_FETCH_OBJ_FUNC_ARG",		PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_FETCH_UNSET,				"ZEND_FETCH_UNSET",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_VAR | PHP_PARSEKIT_OP2_EA_TYPE },
	{ ZEND_FETCH_DIM_UNSET,			"ZEND_FETCH_DIM_UNSET",			PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_FETCH_OBJ_UNSET,			"ZEND_FETCH_OBJ_UNSET",			PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_FETCH_DIM_TMP_VAR,		"ZEND_FETCH_DIM_TMP_VAR",		PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_FETCH_CONSTANT,			"ZEND_FETCH_CONSTANT",			PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_VAR | PHP_PARSEKIT_OP2_CONST },
	{ ZEND_EXT_STMT,				"ZEND_EXT_STMT",				PHP_PARSEKIT_USAGE_UNKNOWN },
	{ ZEND_EXT_FCALL_BEGIN,			"ZEND_EXT_FCALL_BEGIN",			PHP_PARSEKIT_USAGE_UNKNOWN },
	{ ZEND_EXT_FCALL_END,			"ZEND_EXT_FCALL_END",			PHP_PARSEKIT_USAGE_UNKNOWN },
	{ ZEND_EXT_NOP,					"ZEND_EXT_NOP",					PHP_PARSEKIT_USAGE_UNKNOWN },
	{ ZEND_TICKS,					"ZEND_TICKS",					PHP_PARSEKIT_OP1_CONST },
	{ ZEND_SEND_VAR_NO_REF,			"ZEND_SEND_VAR_NO_REF",			PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_OPLINE | PHP_PARSEKIT_EXTENDED_VALUE },
#if PHP_MAJOR_VERSION >= 5
	{ ZEND_CATCH,					"ZEND_CATCH",					PHP_PARSEKIT_OP1_VAR | PHP_PARSEKIT_OP1_EA_TYPE | PHP_PARSEKIT_OP2_OPLINE | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_THROW,					"ZEND_THROW",					PHP_PARSEKIT_OP1_GETVAR },
	{ ZEND_FETCH_CLASS,				"ZEND_FETCH_CLASS",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_CLONE,					"ZEND_CLONE",					PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR },
#ifdef ZEND_INIT_CTOR_CALL
/* PHP 5.0 only */
	{ ZEND_INIT_CTOR_CALL,			"ZEND_INIT_CTOR_CALL",			PHP_PARSEKIT_OP1_GETVAR },
#endif
	{ ZEND_INIT_METHOD_CALL,		"ZEND_INIT_METHOD_CALL",		PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_INIT_STATIC_METHOD_CALL,	"ZEND_INIT_STATIC_METHOD_CALL",	PHP_PARSEKIT_OP1_VAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_ISSET_ISEMPTY_VAR,		"ZEND_ISSET_ISEMPTY_VAR",		PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_VAR | PHP_PARSEKIT_OP2_EA_TYPE },
	{ ZEND_ISSET_ISEMPTY_DIM_OBJ,	"ZEND_ISSET_ISEMPTY_DIM_OBJ",	PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
#ifdef ZEND_IMPORT_FUNCTION
	{ ZEND_IMPORT_FUNCTION,			"ZEND_IMPORT_FUNCTION",			PHP_PARSEKIT_USAGE_UNKNOWN },
#endif
#ifdef ZEND_IMPORT_CLASS
	{ ZEND_IMPORT_CLASS,			"ZEND_IMPORT_CLASS",			PHP_PARSEKIT_USAGE_UNKNOWN },
#endif
#ifdef ZEND_IMPORT_CONST
	{ ZEND_IMPORT_CONST,			"ZEND_IMPORT_CONST",			PHP_PARSEKIT_USAGE_UNKNOWN },
#endif
	{ ZEND_PRE_INC_OBJ,				"ZEND_PRE_INC_OBJ",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_PRE_DEC_OBJ,				"ZEND_PRE_DEC_OBJ",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_POST_INC_OBJ,			"ZEND_POST_INC_OBJ",			PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_POST_DEC_OBJ,			"ZEND_POST_DEC_OBJ",			PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_ASSIGN_OBJ,				"ZEND_ASSIGN_OBJ",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR },
	{ ZEND_OP_DATA,					"ZEND_OP_DATA",					PHP_PARSEKIT_USAGE_UNKNOWN },
	{ ZEND_INSTANCEOF,				"ZEND_INSTANCEOF",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_VAR },
	{ ZEND_DECLARE_CLASS,			"ZEND_DECLARE_CLASS",			PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_CONST | PHP_PARSEKIT_OP2_CONST },
	{ ZEND_DECLARE_INHERITED_CLASS,	"ZEND_DECLARE_INHERITED_CLASS",	PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_CONST | PHP_PARSEKIT_OP2_CONST },
	{ ZEND_DECLARE_FUNCTION,		"ZEND_DECLARE_FUNCTION",		PHP_PARSEKIT_OP1_CONST | PHP_PARSEKIT_OP2_CONST },
	{ ZEND_RAISE_ABSTRACT_ERROR,	"ZEND_RAISE_ABSTRACT_ERROR",	PHP_PARSEKIT_USAGE_UNKNOWN },
	{ ZEND_ADD_INTERFACE,			"ZEND_ADD_INTERFACE",			PHP_PARSEKIT_OP1_VAR | PHP_PARSEKIT_OP2_VAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_VERIFY_ABSTRACT_CLASS,	"ZEND_VERIFY_ABSTRACT_CLASS",	PHP_PARSEKIT_OP1_VAR },
	{ ZEND_ASSIGN_DIM,				"ZEND_ASSIGN_DIM",				PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_ISSET_ISEMPTY_PROP_OBJ,	"ZEND_ISSET_ISEMPTY_PROP_OBJ",	PHP_PARSEKIT_RESULT_VAR | PHP_PARSEKIT_OP1_GETVAR | PHP_PARSEKIT_OP2_GETVAR | PHP_PARSEKIT_EXTENDED_VALUE },
	{ ZEND_HANDLE_EXCEPTION,		"ZEND_HANDLE_EXCEPTION",		0 },
#endif
	{ 0, NULL }
};

#else

#define phpext_parsekit_ptr &parsekit_module_entry

#endif	/* PHP_PARSEKIT_H */


/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */

