/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2013, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/

package help;

import grpFilt.GrpFiltWidget;

import java.io.File;
import java.util.ArrayList;
import java.util.Locale;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;


import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import xmlObjects.Item;
import xmlObjects.VtEnv;
import java.io.*;


/***
 * Class to load current settings.
 */
public class LoadConfig {
	private static String file = null;
	private VtEnv env = null; 
	private String error = new String(""); 
	
	/***
	 * initialize this class
	 * @param env {@link VtEnv environment} with all informations 
	 */
	public LoadConfig(VtEnv env)
	{
		this.env = env;
		
	}
	
	/****
	 * opens a file dialog to get the filename
	 * @param advanced true if the user views advanced settings otherwise false
	 */
	public void setFile(boolean advanced)
	{
		JFileChooser chooser = new JFileChooser();
		chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		chooser.setLocale(Locale.ENGLISH);
		chooser.setMultiSelectionEnabled(false);
		
		FileNameExtensionFilter filter = new FileNameExtensionFilter(
		        "XML", "xml");
		chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
		chooser.addChoosableFileFilter(filter);
	
		 
	    File f = null;
	    try{
	    	f = new File(new File(".").getCanonicalPath());
	    	chooser.setCurrentDirectory(f);
	    }catch(Exception ex)
	    {
	    	Config.errorHandler(ex);
	    }
	    
	   
	    chooser.showOpenDialog(null);
	    
	    
	    if(chooser.getSelectedFile() != null)
	    {
	    	try{
	    		file = chooser.getSelectedFile().getCanonicalPath();
	    		if (!(new File(file).exists()))
		    	{
		    		JOptionPane.showMessageDialog(null, "File not found or invalid!", "Warning", JOptionPane.WARNING_MESSAGE);
		    		file = null;
		    	}
	    		else
	    			getSettings(advanced);
	    		
	    		
	    	}catch(Exception e)
	    	{
	    		Config.errorHandler(e);
	    	}
	    }
	}
	
	/****
	 * opens a file dialog to get the filename
	 * @param advanced true if the user views advanced settings otherwise false
	 */
	public void setFile_silent(boolean advanced, String File)
	{	 
	    File f = null;
	 try{
	   	f = new File(File);

	    if(!f.isFile())
	    {
	    	JOptionPane.showMessageDialog(null, "File not found or invalid!", "Warning", JOptionPane.WARNING_MESSAGE);
		    file = null;
	    }
	    else
	    {
	    	file = File;
	    }
		
	    if(file != null)
	    	getSettings(advanced);
	    		
	    		
	    }catch(Exception e)
	    {
	    	Config.errorHandler(e);
	    }
	 
	
	}

	/***
	 * returns the file path 
	 * @return path to the file that was loaded lastly
	 */
	public String getFile()
	{
		return file;
	}


	/***
	 * get all settings from the file. 
	 * @param advanced true if the user views advanced settings otherwise false
	 */
	public void getSettings(boolean advanced)
	{
		try{
			String document = "",line="";
			boolean grpFiltfound = false;
			BufferedReader myfile = new BufferedReader(new FileReader(file));
			while((line = myfile.readLine()) != null)
			{
				if(line.contains("<grpFilt>") || grpFiltfound)
				{
					document = document+ "\n" + line;
					grpFiltfound = true;
				}
				else
					document = document + line.replaceAll("\n|\r", "");
			}
			
			DocumentBuilderFactory factory  = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder  = factory.newDocumentBuilder();
			Document doc = builder.parse( new InputSource(new StringReader(document)));
			doc.normalizeDocument();
			doc.normalize();
			
			NodeList liste = doc.getElementsByTagName("item");
			NodeList version = doc.getElementsByTagName("version");
			if(version.getLength() == 0)
			{
				JOptionPane.showMessageDialog(null, "File is not a valid vtconfig file", "error", JOptionPane.ERROR_MESSAGE);
				throw new Exception("not valid xml");
			}
			ArrayList<Item> items = this.env.getItems();
			boolean valid=true;
			
			Item item =null;
			MyComponentHandler help = new MyComponentHandler();
			
			for(int i=0;i<liste.getLength();i++)
			{
				String name = liste.item(i).getFirstChild().getTextContent();
				
				//get item
				for(int j=0;j<items.size();j++)
				{
					if(items.get(j).getEnvname().compareTo(name) == 0)
					{
						
						item = items.get(j);
						break;
					}
				}
				
				if(item != null && item.getEnvname().trim().compareTo(name) != 0)
				{
					this.error += " \""+name+"\" is not available in this version.\n";
					continue;
				}
				
				
				
				Node next = liste.item(i).getFirstChild().getNextSibling();
				for(int j=0;next != null;j++)
				{
					String type = next.getAttributes().getNamedItem("type").getTextContent();
					//String defaultval = next.getFirstChild().getTextContent();
					String cur = next.getFirstChild().getNextSibling().getTextContent();
					next = next.getNextSibling();
					
					if(type.trim().compareTo(item.getValue().get(j).getType()) == 0)
						help.SetComponent(item.getValue().get(j).getComponent(), cur);
					else
					{
						valid = false;
					}
				}
				if(!valid)
				{
					valid = true;
					help.SetItemDefault(item,this.env);
					this.error += "No valid Data for \""+item.getDescname()+"\".\n";
				}
			}
			
			//load filtwidget
			NodeList grpFilt = doc.getElementsByTagName("grpFilt");
			GrpFiltWidget helpWidget = env.getGrpFiltWidget();
			if(helpWidget != null)
				env.getGrpFiltWidget().loadFile(grpFilt.item(0).getTextContent(),advanced);
			
			if(this.error.compareTo("")!=0)
			{
				JOptionPane.showMessageDialog(null, this.error, "Warning", JOptionPane.WARNING_MESSAGE);
				this.error="";
			}
						
			env.hasChanged=false;
		}catch(Exception ex)
		{
			Config.errorHandler(ex);
		}

	}

}
