# Look for the header file.
FIND_PATH(PTHREAD_INCLUDE_DIR NAMES pthread.h)

# Look for the library.
FIND_LIBRARY(PTHREAD_LIBRARY NAMES pthread)

# Handle the QUIETLY and REQUIRED arguments and set PTHREAD_FOUND to TRUE if all listed variables are TRUE.
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(PTHREAD DEFAULT_MSG PTHREAD_LIBRARY PTHREAD_INCLUDE_DIR)

# Copy the results to the output variables.
IF(PTHREAD_FOUND)
	SET(PTHREAD_LIBRARIES ${PTHREAD_LIBRARY})
	SET(PTHREAD_INCLUDE_DIRS ${PTHREAD_INCLUDE_DIR})
ELSE(PTHREAD_FOUND)
	SET(PTHREAD_LIBRARIES)
	SET(PTHREAD_INCLUDE_DIRS)
ENDIF(PTHREAD_FOUND)

MARK_AS_ADVANCED(PTHREAD_INCLUDE_DIRS PTHREAD_LIBRARIES)
