# -*- coding: utf-8 -*-
#
#  Copyright (C) 2003-2011 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#  Copyright (C) 2003 by Shun-ichi TAHARA <jado@flowernet.gr.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import os
import re

import gtk
import ninix.pix


class Menu:

    def __init__(self, callback):
        self.callback = callback
        ui_info = '''
        <ui>
          <popup name='popup'>
            <menu action='Recommend'>
            </menu>
            <menu action='Portal'>
            </menu>
            <separator/>
            <menuitem action='Stick'/>
            <separator/>
            <menu action='Options'>
            <menuitem action='Update'/>
            <menuitem action='Vanish'/>
            <menuitem action='Preferences'/>
            <menuitem action='Manager'/>
            </menu>
            <separator/>
            <menu action='Change'>
            </menu>
            <menu action='Summon'>
            </menu>
            <menu action='Shell'>
            </menu>
            <menu action='Costume'>
            </menu>
            <menu action='Balloon'>
            </menu>
            <separator/>
            <menu action='Information'>
            <menuitem action='Usage'/>
            <menuitem action='Version'/>
            </menu>
            <separator/>
            <menu action='Nekodorif'>
            </menu>
            <menu action='Kinoko'>
            </menu>
            <separator/>
            <menuitem action='Close'/>
            <menuitem action='Quit'/>
          </popup>
        </ui>
        '''
        self.__menu_list = { ## FIXME
            'Portal': [
                ('Portal', None, _('Portal sites(_P)'), None),
                None, 1, 1],
            'Recommend': [
                ('Recommend', None, _('Recommend sites(_R)'), None),
                None, 1, 1],
            'Options': [
                ('Options', None, _('Options(_F)'), None),
                None, 1, 1],
            'Options/Update': [
                ('Update', None, _('Network Update(_U)'), None,
                 '', lambda *a: self.callback['network_update']()),
                None, 1, 1],
            'Options/Vanish': [
                ('Vanish', None, _('Vanish(_F)'), None,
                 '', lambda *a: self.callback['vanish_sakura']()),
                None, 1, 1],
            'Options/Preferences': [
                ('Preferences', None, _('Preferences...(_O)'), None,
                 '', lambda *a: self.callback['edit_preferences']()),
                None, 1, 1],
            'Options/Manager': [
                ('Manager', None, _('Ghost Manager(_M)'), None,
                 '', lambda *a: self.callback['open_ghost_manager']()),
                None, 1, 1],
            'Information': [
                ('Information', None, _('Information(_I)'), None),
                None, 1, 1],
            'Information/Usage': [
                ('Usage', None, _('Usage graph(_A)'), None,
                 '', lambda *a: self.callback['show_usage']()),
                None, 1, 1],
            'Information/Version': [
                ('Version', None, _('Version(_V)'), None,
                 '', lambda *a: self.callback['about']()),
                None, 1, 1],
            'Close': [
                ('Close', None, _('Close(_W)'), None,
                 '', lambda *a: self.callback['close_sakura']()),
                None, 1, 1],
            'Quit': [('Quit', None, _('Quit(_Q)'), None,
                      '', lambda *a: self.callback['close_all']()),
                     None, 1, 1],
            'Change': [
                ('Change', None, _('Change(_G)'), None),
                None, 1, 1],
            'Summon': [
                ('Summon', None, _('Summon(_X)'), None),
                None, 1, 1],
            'Shell': [
                ('Shell', None, _('Shell(_S)'), None),
                None, 1, 1],
            'Balloon': [
                ('Balloon', None, _('Balloon(_B)'), None),
                None, 1, 1],
            'Costume': [
                ('Costume', None, _('Costume(_C)'), None),
                None, 1, 1],
            'Stick': [
                ('Stick', None, _('Stick(_Y)'), None,
                 '', self.callback['stick_window'], False),
                None, 1, 1],
            'Nekodorif': [
                ('Nekodorif', None, _('Nekodorif(_N)'), None),
                None, 1, 1],
            'Kinoko': [
                ('Kinoko', None, _('Kinoko(_K)'), None),
                None, 1, 1],
            }
        self.__pixmap = None
        self.__pixmap_with_sidebar = None
        self.__pixmap_prelight = None
        self.__pixmap_prelight_with_sidebar = None
        self.__fontcolor = {'normal': '#000000', 'prelight': '#ffffff'} ## FIXME
        self.__sidebar_width = 0
        actions = gtk.ActionGroup('Actions')
        entry = []
        for key, value in self.__menu_list.iteritems():
            if key != 'Stick':
                entry.append(value[0])
        actions.add_actions(tuple(entry))
        actions.add_toggle_actions(tuple([self.__menu_list['Stick'][0]]))
        self.ui_manager = gtk.UIManager()
        self.ui_manager.insert_action_group(actions, 0)
        self.ui_manager.add_ui_from_string(ui_info)
        self.__popup_menu = self.ui_manager.get_widget('/popup')

    def set_fontcolor(self, background, foreground):
        self.__fontcolor['normal'] = '#%02x%02x%02x' % background
        self.__fontcolor['prelight'] = '#%02x%02x%02x' % foreground

    def set_pixmap(self, path_background, path_sidebar, path_foreground):
        pixbuf = None
        if path_background and os.path.exists(path_background):
            try:
                pixbuf = ninix.pix.create_pixbuf_from_file(
                    path_background, is_pnr=False)
            except:
                pixbuf = None
        if pixbuf is None:
            self.__pixmap = None
            self.__pixmap_with_sidebar = None
            self.__pixmap_prelight = None
            self.__pixmap_prelight_with_sidebar = None
            return
        pixmap, mask = pixbuf.render_pixmap_and_mask(255)
        self.__pixmap = pixmap
        pixbuf_sidebar = None
        if path_sidebar and os.path.exists(path_sidebar):
            try:
                pixbuf_sidebar = ninix.pix.create_pixbuf_from_file(
                    path_sidebar, is_pnr=False)
            except:
                pixbuf_sidebar = None
        if pixbuf_sidebar:
            width = pixbuf.get_width()
            height = pixbuf.get_height()
            sidebar_width = pixbuf_sidebar.get_width()
            sidebar_height = pixbuf_sidebar.get_height()
            new_pixbuf = gtk.gdk.Pixbuf(
                pixbuf.get_colorspace(), False,
                pixbuf.get_bits_per_sample(),
                width + sidebar_width, max(height, sidebar_height))
            pixbuf.composite(
                new_pixbuf,
                0, 0, new_pixbuf.get_width(), new_pixbuf.get_height(),
                width - 1, height - 1,
                1.0, 1.0, gtk.gdk.INTERP_BILINEAR, 255)
            pixbuf_sidebar.composite(
                new_pixbuf,
                0, 0, sidebar_width, sidebar_height,
                0, 0,
                1.0, 1.0, gtk.gdk.INTERP_BILINEAR, 255)
            pixbuf.composite(
                new_pixbuf,
                sidebar_width, 0, width, height,
                0, 0,
                1.0, 1.0, gtk.gdk.INTERP_BILINEAR, 255)
            self.__sidebar_width = sidebar_width
            pixmap, mask = new_pixbuf.render_pixmap_and_mask(255)
        else:
            self.__sidebar_width = 0
        self.__pixmap_with_sidebar = pixmap
        pixbuf = None
        if path_foreground and os.path.exists(path_foreground):
            try:
                pixbuf = ninix.pix.create_pixbuf_from_file(
                    path_foreground, is_pnr=False)
            except:
                pixbuf = None
        if pixbuf is None:
            return
        pixmap, mask = pixbuf.render_pixmap_and_mask(255)
        self.__pixmap_prelight = pixmap
        if pixbuf_sidebar:
            width = pixbuf.get_width()
            height = pixbuf.get_height()
            sidebar_width = pixbuf_sidebar.get_width()
            sidebar_height = pixbuf_sidebar.get_height()
            new_pixbuf = gtk.gdk.Pixbuf(
                pixbuf.get_colorspace(), False,
                pixbuf.get_bits_per_sample(),
                width + sidebar_width, max(height, sidebar_height))
            pixbuf.composite(
                new_pixbuf,
                0, 0, new_pixbuf.get_width(), new_pixbuf.get_height(),
                width - 1, height - 1,
                1.0, 1.0, gtk.gdk.INTERP_BILINEAR, 255)
            pixbuf_sidebar.composite(
                new_pixbuf,
                0, 0, sidebar_width, sidebar_height,
                0, 0,
                1.0, 1.0, gtk.gdk.INTERP_BILINEAR, 255)
            pixbuf.composite(
                new_pixbuf,
                sidebar_width, 0, width, height,
                0, 0,
                1.0, 1.0, gtk.gdk.INTERP_BILINEAR, 255)
            pixmap, mask = new_pixbuf.render_pixmap_and_mask(255)
        self.__pixmap_prelight_with_sidebar = pixmap

    def __set_mayuna_menu(self, side):
        if len(self.__mayuna_menu) > side and \
           self.__mayuna_menu[side] is not None:
            menuitem = self.ui_manager.get_widget(
                ''.join(('/popup/', 'Costume')))
            menuitem.set_submenu(self.__mayuna_menu[side])
            self.__set_visible('Costume', 1)
        else:
            self.__set_visible('Costume', 0)

    def create_mayuna_menu(self, mayuna_menu):
        self.__mayuna_menu = []
        for side, index in [('sakura', 0), ('kero', 1)]:
            if mayuna_menu[side]:
                self.__mayuna_menu.append(gtk.Menu())
                item = gtk.TearoffMenuItem()
                item.show()
                self.__mayuna_menu[index].append(item)
                for j in range(len(mayuna_menu[side])):
                    key, name, state = mayuna_menu[side][j]
                    if key != '-':
                        item = gtk.CheckMenuItem(name)
                        item.set_name('popup menu item')
                        item.set_active(bool(state))
                        item.connect('activate', self.callback['toggle_bind'],
                                     (index, key))
                    else:
                        item = gtk.SeparatorMenuItem()
                    item.show()
                    self.__mayuna_menu[index].append(item)
            else:
                self.__mayuna_menu.append(None)

    __re_shortcut = re.compile(r'&(?=[\x21-\x7e])')

    def __modify_shortcut(self, caption):
        return self.__re_shortcut.sub('_', caption)

    __re_mnemonic = re.compile(r'\(_.\)|_')

    def __cut_mnemonic(self, caption):
        return self.__re_mnemonic.sub('', caption)

    __ui = {'Options/Update': ([['updatebuttoncaption', 'updatebutton.caption'],
                             ['updatebuttoncaption', 'updatebutton.caption']],
                            '(_U)', [[],[]]),
            'Options/Vanish': ([['vanishbuttoncaption', 'vanishbutton.caption'],
                             ['vanishbuttoncaption', 'vanishbutton.caption']],
                            '(_F)',
                            [['vanishbuttonvisible', 'vanishbutton.visible'],
                             ['vanishbuttonvisible', 'vanishbutton.visible']]),
            'Portal': ([['sakura.portalbuttoncaption',
                         'portalrootbutton.caption'], []], '(_P)', [[], None]),
            'Recommend': ([['sakura.recommendbuttoncaption',
                            'recommendrootbutton.caption'],
                           ['kero.recommendbuttoncaption']], '(_R)', [[], []]),
           }

    def __update_ui(self, side):
        for key in self.__ui:
            if key not in self.__menu_list:
                continue
            if side > 1:
                if key in ['Options/Update', 'Options/Vanish']:
                    name_list = self.__ui[key][0][1] # same as 'kero'
                elif key == 'Portal':
                    name_list = [] # same as 'kero'
                elif key == 'Recommend':
                    name_list = ['char%d.recommendbuttoncaption' % side]
            else:
                name_list = self.__ui[key][0][side]
            if name_list: # caption
                for name in name_list:
                    caption = self.callback['getstring'](name)
                    if caption:
                        break
                if caption:
                    caption = self.__modify_shortcut(caption)
                    if caption == self.__cut_mnemonic(caption):
                        caption = ''.join((caption, self.__ui[key][1]))
                    self.__set_caption(key, caption)
            if side > 1:
                name_list = self.__ui[key][2][1] # same as 'kero'
            else:
                name_list = self.__ui[key][2][side]
            if name_list: # visible
                for name in name_list:
                    visible = self.callback['getstring'](name)
                    if visible is not None:
                        break
                if visible == '0':
                    self.__set_visible(key, 0)
                else:
                    self.__set_visible(key, 1)
            elif name_list is None:
                self.__set_visible(key, 0)

    def set_submenu_back_pixmap(self, submenu):
        item_list = submenu.get_children()
        if item_list:
            for item in item_list:
                if self.__pixmap_prelight:
                    style = item.style.copy()
                    style.bg_pixmap[gtk.STATE_PRELIGHT] = self.__pixmap_prelight
                    item.set_style(style)
                submenu = item.get_submenu()
                if submenu:
                    style = submenu.style.copy()
                    style.bg_pixmap[gtk.STATE_NORMAL] = self.__pixmap
                    submenu.set_style(style)
                    self.set_submenu_back_pixmap(submenu)

    def set_submenu_fontcolor(self, submenu):
        for item in submenu.get_children():
            # reset label
            children = item.get_children()
            if children:
                label = children[0]
                style = label.style.copy()
                cmap = label.get_colormap()
                colour = cmap.alloc_color(self.__fontcolor['normal'])
                style.fg[gtk.STATE_NORMAL] =  colour
                colour = cmap.alloc_color(self.__fontcolor['prelight'])
                style.fg[gtk.STATE_PRELIGHT] =  colour
                label.set_style(style)
            submenu = item.get_submenu()
            if submenu:
                self.set_submenu_fontcolor(submenu)

    def popup(self, button, side):
        if side > 1:
            string = 'char%d' % side
        else:
            assert side in [0, 1] ## FIXME
            string = ['sakura', 'kero'][side]
        string = ''.join((string, '.popupmenu.visible'))
        if self.callback['getstring'](string) == '0':
            return
        self.__update_ui(side)
        if side == 0:
            portal = self.callback['getstring']('sakura.portalsites')
        else:
            portal = None
        self.__set_portal_menu(side, portal)
        if side > 1:
            string = 'char%d' % side
        else:
            assert side in [0, 1] ## FIXME
            string = ['sakura', 'kero'][side]
        string = ''.join((string, '.recommendsites'))
        recommend = self.callback['getstring'](string)
        self.__set_recommend_menu(recommend)
        self.__set_ghost_menu()
        self.__set_shell_menu()
        self.__set_balloon_menu()
        self.__set_mayuna_menu(side)
        self.__set_nekodorif_menu()
        self.__set_kinoko_menu()
        if self.__pixmap_with_sidebar:
            style = self.__popup_menu.style.copy()
            style.bg_pixmap[gtk.STATE_NORMAL] = self.__pixmap_with_sidebar
            self.__popup_menu.set_style(style)
        for key in self.__menu_list:
            item = self.ui_manager.get_widget(''.join(('/popup/', key)))
            visible = self.__menu_list[key][2]
            changed = self.__menu_list[key][3]
            if item and changed:
                self.__menu_list[key][3] = 0 # changed
                if visible:
                    if not key.startswith('Options/'): # XXX
                        if self.__pixmap_prelight_with_sidebar:
                            style = item.style.copy()
                            style.bg_pixmap[gtk.STATE_PRELIGHT] = self.__pixmap_prelight_with_sidebar
                            item.set_style(style)
                    label = item.get_children()[0]
                    style = label.style.copy()
                    cmap = label.get_colormap()
                    colour = cmap.alloc_color(self.__fontcolor['normal'])
                    style.fg[gtk.STATE_NORMAL] =  colour
                    colour = cmap.alloc_color(self.__fontcolor['prelight'])
                    style.fg[gtk.STATE_PRELIGHT] =  colour
                    label.set_style(style)
                    item.show()
                    submenu = item.get_submenu()
                    if submenu:
                        if self.__pixmap:
                            style = submenu.style.copy()
                            style.bg_pixmap[gtk.STATE_NORMAL] = self.__pixmap
                            submenu.set_style(style)
                            self.set_submenu_back_pixmap(submenu)
                        self.set_submenu_fontcolor(submenu)
                else:
                    item.hide()
        self.__popup_menu.popup(None, None, None, button,
                                gtk.get_current_event_time())
        for item in self.__popup_menu.get_children():
            if gtk.REALIZED & item.flags():
                allocation = item.get_allocation()
                allocation.x += self.__sidebar_width
                allocation.width -= self.__sidebar_width
                item.size_allocate(allocation)
        self.__popup_menu.resize_children()

    def __set_caption(self, name, caption):
        assert name in self.__menu_list
        assert isinstance(caption, basestring)
        item = self.ui_manager.get_widget(''.join(('/popup/', name)))
        if item:
            label = item.get_children()[0]
            label.set_text_with_mnemonic(caption)
        self.__menu_list[name][3] = 1 # changed

    def __set_visible(self, name, visible):
        assert name in self.__menu_list
        assert visible in [0, 1]
        if self.__menu_list[name][2] == visible:
            return
        self.__menu_list[name][2] = visible
        self.__menu_list[name][3] = 1 # changed

    def __set_portal_menu(self, side, portal):
        if side >= 1:
            self.__set_visible('Portal', 0)
        else:
            if portal:
                menu = gtk.Menu()
                portal_list = portal.split(chr(2))
                for site in portal_list:
                    entry = site.split(chr(1))
                    if not entry:
                        continue
                    title = entry[0]
                    if title == '-':
                        item = gtk.SeparatorMenuItem()
                    else:
                        if len(entry) < 2:
                            continue
                        url = entry[1]
                        ## FIXME
                        #if len(entry) > 2:
                        #    bannar = entry[2]
                        #else:
                        #    bannar = None
                        item = gtk.MenuItem(title)
                        item.connect('activate',
                                     self.callback['notify_site_selection'],
                                     (title, url))
                    menu.add(item)
                    item.show()
                menuitem = self.ui_manager.get_widget(
                    ''.join(('/popup/', 'Portal')))
                menuitem.set_submenu(menu)
                menu.show()
                self.__set_visible('Portal', 1)
            else:
                self.__set_visible('Portal', 0)
        self.__menu_list['Portal'][3] = 1 # changed

    def __set_recommend_menu(self, recommend):
        if recommend:
            menu = gtk.Menu()
            recommend_list = recommend.split(chr(2))
            for site in recommend_list:
                entry = site.split(chr(1))
                if not entry:
                    continue
                title = entry[0]
                if title == '-':
                    item = gtk.SeparatorMenuItem()
                else:
                    if len(entry) < 2:
                        continue
                    url = entry[1]
                    ## FIXME
                    #if len(entry) > 2:
                    #    bannar = entry[2]
                    #else:
                    #    bannar = None
                    item = gtk.MenuItem(title)
                    item.connect('activate',
                                 self.callback['notify_site_selection'],
                                 (title, url))
                menu.add(item)
                item.show()
            menuitem =  self.ui_manager.get_widget(
                ''.join(('/popup/', 'Recommend')))
            menuitem.set_submenu(menu)
            menu.show()
            self.__set_visible('Recommend', 1)
        else:
            self.__set_visible('Recommend', 0)
        self.__menu_list['Recommend'][3] = 1 # changed

    def __update_ghost_menu(self, set_list, summon):
        if summon:
            callback = self.callback['start_sakura']
        else:
            callback = self.callback['select_sakura']
        ghost_menu = gtk.Menu()
        for i in range(len(set_list)):
            if set_list[i] is None:
                continue
            name = set_list[i]['name']
            icon = set_list[i]['icon']
            shell_list = set_list[i]['shell']
            if icon is not None:
                image = gtk.Image()
                image.set_from_file(icon)
                image.show()
                item = gtk.ImageMenuItem(name)
                item.set_image(image)
            else:
                item = gtk.MenuItem(name)
            item.set_name('popup menu item')
            item.show()
            ghost_menu.append(item)
            if set_list[i]['instance'].is_running():
                item.set_sensitive(False)
            if len(shell_list) <= 1:
                shell_name, value = shell_list[0]
                item.connect('activate', callback, value)
            else:
                submenu = gtk.Menu()
                submenu.set_name('popup menu')
                item.set_submenu(submenu)
                for shell_name, value in shell_list:
                    item = gtk.MenuItem(shell_name)
                    item.set_name('popup menu item')
                    item.connect('activate', callback, value)
                    item.show()
                    submenu.append(item)
        path = 'Summon' if summon else 'Change'
        menuitem = self.ui_manager.get_widget(''.join(('/popup/', path)))
        menuitem.set_submenu(ghost_menu)
        self.__menu_list[path][3] = 1

    def __set_ghost_menu(self):
        ghosts = self.callback['get_ghost_list']()
        self.__update_ghost_menu(ghosts, False)
        self.__update_ghost_menu(ghosts, True)

    def __set_shell_menu(self):
        shell_list = self.callback['get_shell_list']()
        shell_menu = gtk.Menu()
        for i in range(len(shell_list)):
            shell_name, value, working = shell_list[i]
            item = gtk.MenuItem(shell_name)
            item.set_name('popup menu item')
            item.connect('activate', self.callback['select_shell'], value)
            item.show()
            if working:
                item.set_sensitive(False)
            shell_menu.append(item)
        menuitem = self.ui_manager.get_widget(''.join(('/popup/', 'Shell')))
        menuitem.set_submenu(shell_menu)
        self.__menu_list['Shell'][3] = 1

    def __set_balloon_menu(self):
        balloon_list = self.callback['get_balloon_list']()
        balloon_menu = gtk.Menu()
        group = None
        for name, directory in balloon_list:
            item = group = gtk.RadioMenuItem(group, name)
            item.set_name('popup menu item')
            hid = item.connect('activate',
                               self.callback['select_balloon'], directory)
            item.show()
            balloon_menu.append(item)
            if directory == self.callback['get_current_balloon_directory']():
                item.handler_block(hid)
                item.activate()
                item.handler_unblock(hid)
        menuitem = self.ui_manager.get_widget(''.join(('/popup/', 'Balloon')))
        menuitem.set_submenu(balloon_menu)
        self.__menu_list['Balloon'][3] = 1

    def __set_nekodorif_menu(self):
        nekodorif_list = self.callback['get_nekodorif_list']()
        nekodorif_menu = gtk.Menu()
        for i in range(len(nekodorif_list)):
            name = nekodorif_list[i]['name']
            item = gtk.MenuItem(name)
            item.set_name('popup menu item')
            item.show()
            nekodorif_menu.append(item)
            item.connect('activate', self.callback['select_nekodorif'],
                         nekodorif_list[i]['dir'])
            ##if working:
            ##    item.set_sensitive(False)
        menuitem = self.ui_manager.get_widget(
            ''.join(('/popup/', 'Nekodorif')))
        menuitem.set_submenu(nekodorif_menu)
        self.__menu_list['Nekodorif'][3] = 1

    def __set_kinoko_menu(self):
        kinoko_list = self.callback['get_kinoko_list']()
        kinoko_menu = gtk.Menu()
        for i in range(len(kinoko_list)):
            name = kinoko_list[i]['title']
            item = gtk.MenuItem(name)
            item.set_name('popup menu item')
            item.show()
            kinoko_menu.append(item)
            item.connect('activate', self.callback['select_kinoko'],
                         kinoko_list[i])
            ##if working:
            ##    item.set_sensitive(False)
        menuitem = self.ui_manager.get_widget(''.join(('/popup/', 'Kinoko')))
        menuitem.set_submenu(kinoko_menu)
        self.__menu_list['Kinoko'][3] = 1

    def get_stick(self):
        item =  self.ui_manager.get_widget(''.join(('/popup/', 'Stick')))
        return 1 if item and item.get_active() else 0


def test():
    pass


if __name__ == '__main__':
    test()
